// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/service_identity_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ServiceIdentityResponse struct {
	Identities           []*storage.ServiceIdentity `protobuf:"bytes,1,rep,name=identities,proto3" json:"identities,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *ServiceIdentityResponse) Reset()         { *m = ServiceIdentityResponse{} }
func (m *ServiceIdentityResponse) String() string { return proto.CompactTextString(m) }
func (*ServiceIdentityResponse) ProtoMessage()    {}
func (*ServiceIdentityResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c074a5de4b4a386, []int{0}
}
func (m *ServiceIdentityResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceIdentityResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceIdentityResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceIdentityResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceIdentityResponse.Merge(m, src)
}
func (m *ServiceIdentityResponse) XXX_Size() int {
	return m.Size()
}
func (m *ServiceIdentityResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceIdentityResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceIdentityResponse proto.InternalMessageInfo

func (m *ServiceIdentityResponse) GetIdentities() []*storage.ServiceIdentity {
	if m != nil {
		return m.Identities
	}
	return nil
}

func (m *ServiceIdentityResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ServiceIdentityResponse) Clone() *ServiceIdentityResponse {
	if m == nil {
		return nil
	}
	cloned := new(ServiceIdentityResponse)
	*cloned = *m

	if m.Identities != nil {
		cloned.Identities = make([]*storage.ServiceIdentity, len(m.Identities))
		for idx, v := range m.Identities {
			cloned.Identities[idx] = v.Clone()
		}
	}
	return cloned
}

type CreateServiceIdentityRequest struct {
	Id                   string              `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Type                 storage.ServiceType `protobuf:"varint,2,opt,name=type,proto3,enum=storage.ServiceType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *CreateServiceIdentityRequest) Reset()         { *m = CreateServiceIdentityRequest{} }
func (m *CreateServiceIdentityRequest) String() string { return proto.CompactTextString(m) }
func (*CreateServiceIdentityRequest) ProtoMessage()    {}
func (*CreateServiceIdentityRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c074a5de4b4a386, []int{1}
}
func (m *CreateServiceIdentityRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CreateServiceIdentityRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CreateServiceIdentityRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CreateServiceIdentityRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateServiceIdentityRequest.Merge(m, src)
}
func (m *CreateServiceIdentityRequest) XXX_Size() int {
	return m.Size()
}
func (m *CreateServiceIdentityRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateServiceIdentityRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateServiceIdentityRequest proto.InternalMessageInfo

func (m *CreateServiceIdentityRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *CreateServiceIdentityRequest) GetType() storage.ServiceType {
	if m != nil {
		return m.Type
	}
	return storage.ServiceType_UNKNOWN_SERVICE
}

func (m *CreateServiceIdentityRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *CreateServiceIdentityRequest) Clone() *CreateServiceIdentityRequest {
	if m == nil {
		return nil
	}
	cloned := new(CreateServiceIdentityRequest)
	*cloned = *m

	return cloned
}

type CreateServiceIdentityResponse struct {
	Identity             *storage.ServiceIdentity `protobuf:"bytes,1,opt,name=identity,proto3" json:"identity,omitempty"`
	CertificatePem       []byte                   `protobuf:"bytes,2,opt,name=certificate_pem,json=certificatePem,proto3" json:"certificate_pem,omitempty"`
	PrivateKeyPem        []byte                   `protobuf:"bytes,3,opt,name=private_key_pem,json=privateKeyPem,proto3" json:"private_key_pem,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *CreateServiceIdentityResponse) Reset()         { *m = CreateServiceIdentityResponse{} }
func (m *CreateServiceIdentityResponse) String() string { return proto.CompactTextString(m) }
func (*CreateServiceIdentityResponse) ProtoMessage()    {}
func (*CreateServiceIdentityResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c074a5de4b4a386, []int{2}
}
func (m *CreateServiceIdentityResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CreateServiceIdentityResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CreateServiceIdentityResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CreateServiceIdentityResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateServiceIdentityResponse.Merge(m, src)
}
func (m *CreateServiceIdentityResponse) XXX_Size() int {
	return m.Size()
}
func (m *CreateServiceIdentityResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateServiceIdentityResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreateServiceIdentityResponse proto.InternalMessageInfo

func (m *CreateServiceIdentityResponse) GetIdentity() *storage.ServiceIdentity {
	if m != nil {
		return m.Identity
	}
	return nil
}

func (m *CreateServiceIdentityResponse) GetCertificatePem() []byte {
	if m != nil {
		return m.CertificatePem
	}
	return nil
}

func (m *CreateServiceIdentityResponse) GetPrivateKeyPem() []byte {
	if m != nil {
		return m.PrivateKeyPem
	}
	return nil
}

func (m *CreateServiceIdentityResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *CreateServiceIdentityResponse) Clone() *CreateServiceIdentityResponse {
	if m == nil {
		return nil
	}
	cloned := new(CreateServiceIdentityResponse)
	*cloned = *m

	cloned.Identity = m.Identity.Clone()
	if m.CertificatePem != nil {
		cloned.CertificatePem = make([]byte, len(m.CertificatePem))
		copy(cloned.CertificatePem, m.CertificatePem)
	}
	if m.PrivateKeyPem != nil {
		cloned.PrivateKeyPem = make([]byte, len(m.PrivateKeyPem))
		copy(cloned.PrivateKeyPem, m.PrivateKeyPem)
	}
	return cloned
}

type Authority struct {
	CertificatePem       []byte   `protobuf:"bytes,1,opt,name=certificate_pem,json=certificatePem,proto3" json:"certificate_pem,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Authority) Reset()         { *m = Authority{} }
func (m *Authority) String() string { return proto.CompactTextString(m) }
func (*Authority) ProtoMessage()    {}
func (*Authority) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c074a5de4b4a386, []int{3}
}
func (m *Authority) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Authority) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Authority.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Authority) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Authority.Merge(m, src)
}
func (m *Authority) XXX_Size() int {
	return m.Size()
}
func (m *Authority) XXX_DiscardUnknown() {
	xxx_messageInfo_Authority.DiscardUnknown(m)
}

var xxx_messageInfo_Authority proto.InternalMessageInfo

func (m *Authority) GetCertificatePem() []byte {
	if m != nil {
		return m.CertificatePem
	}
	return nil
}

func (m *Authority) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Authority) Clone() *Authority {
	if m == nil {
		return nil
	}
	cloned := new(Authority)
	*cloned = *m

	if m.CertificatePem != nil {
		cloned.CertificatePem = make([]byte, len(m.CertificatePem))
		copy(cloned.CertificatePem, m.CertificatePem)
	}
	return cloned
}

type Authorities struct {
	Authorities          []*Authority `protobuf:"bytes,1,rep,name=authorities,proto3" json:"authorities,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Authorities) Reset()         { *m = Authorities{} }
func (m *Authorities) String() string { return proto.CompactTextString(m) }
func (*Authorities) ProtoMessage()    {}
func (*Authorities) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c074a5de4b4a386, []int{4}
}
func (m *Authorities) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Authorities) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Authorities.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Authorities) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Authorities.Merge(m, src)
}
func (m *Authorities) XXX_Size() int {
	return m.Size()
}
func (m *Authorities) XXX_DiscardUnknown() {
	xxx_messageInfo_Authorities.DiscardUnknown(m)
}

var xxx_messageInfo_Authorities proto.InternalMessageInfo

func (m *Authorities) GetAuthorities() []*Authority {
	if m != nil {
		return m.Authorities
	}
	return nil
}

func (m *Authorities) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Authorities) Clone() *Authorities {
	if m == nil {
		return nil
	}
	cloned := new(Authorities)
	*cloned = *m

	if m.Authorities != nil {
		cloned.Authorities = make([]*Authority, len(m.Authorities))
		for idx, v := range m.Authorities {
			cloned.Authorities[idx] = v.Clone()
		}
	}
	return cloned
}

func init() {
	proto.RegisterType((*ServiceIdentityResponse)(nil), "v1.ServiceIdentityResponse")
	proto.RegisterType((*CreateServiceIdentityRequest)(nil), "v1.CreateServiceIdentityRequest")
	proto.RegisterType((*CreateServiceIdentityResponse)(nil), "v1.CreateServiceIdentityResponse")
	proto.RegisterType((*Authority)(nil), "v1.Authority")
	proto.RegisterType((*Authorities)(nil), "v1.Authorities")
}

func init() {
	proto.RegisterFile("api/v1/service_identity_service.proto", fileDescriptor_5c074a5de4b4a386)
}

var fileDescriptor_5c074a5de4b4a386 = []byte{
	// 475 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x93, 0xcf, 0x6e, 0xd3, 0x40,
	0x10, 0xc6, 0xbb, 0x2e, 0x42, 0x64, 0x42, 0x13, 0xb1, 0x6a, 0x89, 0x65, 0x5a, 0xcb, 0x58, 0x02,
	0x22, 0x0e, 0x8e, 0x1c, 0x7a, 0x40, 0x1c, 0x90, 0x00, 0x55, 0x15, 0xe2, 0x52, 0xb9, 0x1c, 0x2a,
	0x24, 0x14, 0x2d, 0xc9, 0x10, 0x56, 0x25, 0xde, 0xc5, 0xbb, 0xb5, 0xf0, 0x85, 0x03, 0xaf, 0xc0,
	0x85, 0x27, 0xe0, 0x31, 0x38, 0x73, 0x44, 0xe2, 0x05, 0x50, 0xe0, 0x41, 0xd0, 0x3a, 0xdb, 0xb2,
	0xcd, 0xbf, 0x9b, 0x77, 0xe6, 0xdb, 0xdf, 0x37, 0x33, 0x3b, 0x86, 0x3b, 0x4c, 0xf2, 0x5e, 0x99,
	0xf6, 0x14, 0x16, 0x25, 0x1f, 0xe2, 0x80, 0x8f, 0x30, 0xd7, 0x5c, 0x57, 0x03, 0x1b, 0x48, 0x64,
	0x21, 0xb4, 0xa0, 0x5e, 0x99, 0x06, 0xbb, 0x63, 0x21, 0xc6, 0xef, 0xb1, 0x67, 0x6e, 0xb0, 0x3c,
	0x17, 0x9a, 0x69, 0x2e, 0x72, 0x35, 0x53, 0x04, 0xd4, 0x82, 0x70, 0x22, 0x75, 0x65, 0x63, 0xa1,
	0xd2, 0xa2, 0x60, 0x63, 0x5c, 0xa0, 0xcf, 0xf2, 0xf1, 0x31, 0x74, 0x8e, 0x67, 0x99, 0xe7, 0x36,
	0x91, 0xa1, 0x92, 0x22, 0x57, 0x48, 0x1f, 0x02, 0x58, 0x31, 0x47, 0xe5, 0x93, 0x68, 0xb3, 0xdb,
	0xec, 0xfb, 0x89, 0xe5, 0x25, 0xf3, 0xb7, 0x1c, 0x6d, 0x7c, 0x02, 0xbb, 0xcf, 0x0a, 0x64, 0x1a,
	0x17, 0xd0, 0x1f, 0xce, 0x50, 0x69, 0xda, 0x02, 0x8f, 0x8f, 0x7c, 0x12, 0x91, 0x6e, 0x23, 0xf3,
	0xf8, 0x88, 0x76, 0xe1, 0x8a, 0xae, 0x24, 0xfa, 0x5e, 0x44, 0xba, 0xad, 0xfe, 0xf6, 0xbc, 0xc7,
	0xcb, 0x4a, 0x62, 0x56, 0x2b, 0xe2, 0x6f, 0x04, 0xf6, 0x56, 0xa0, 0x6d, 0xd5, 0xfb, 0x70, 0xed,
	0xbc, 0xc5, 0xda, 0x61, 0x5d, 0xcd, 0x17, 0x4a, 0x7a, 0x0f, 0xda, 0x43, 0x2c, 0x34, 0x7f, 0xcb,
	0x87, 0x4c, 0xe3, 0x40, 0xe2, 0xa4, 0x2e, 0xe6, 0x7a, 0xd6, 0x72, 0xc2, 0x47, 0x38, 0xa1, 0x77,
	0xa1, 0x2d, 0x0b, 0x5e, 0x1a, 0xd1, 0x29, 0x56, 0xb5, 0x70, 0xb3, 0x16, 0x6e, 0xd9, 0xf0, 0x0b,
	0xac, 0x8e, 0x70, 0x12, 0xef, 0x43, 0xe3, 0xc9, 0x99, 0x7e, 0x27, 0x8a, 0x15, 0x74, 0xb2, 0x8c,
	0x1e, 0x3f, 0x86, 0xe6, 0xf9, 0x2d, 0x8e, 0x8a, 0xf6, 0xa0, 0xc9, 0xfe, 0x1f, 0xed, 0x13, 0x6c,
	0x25, 0x65, 0x9a, 0x5c, 0xb0, 0x33, 0x57, 0xd1, 0xff, 0xee, 0xc1, 0xcd, 0xb9, 0x26, 0xed, 0x91,
	0xbe, 0x86, 0xed, 0x43, 0xd4, 0x97, 0x93, 0xc6, 0xa3, 0x61, 0x70, 0x07, 0x66, 0x63, 0x82, 0x5b,
	0xe6, 0x73, 0xc5, 0x5c, 0xe3, 0xbd, 0xcf, 0xbf, 0xfe, 0x7e, 0xf1, 0x3a, 0x74, 0xc7, 0x59, 0x55,
	0x07, 0xf3, 0x09, 0x76, 0x96, 0xbe, 0x0b, 0x8d, 0x0c, 0x74, 0xdd, 0x36, 0x04, 0xb7, 0xd7, 0x28,
	0xac, 0x79, 0x54, 0x9b, 0x07, 0xf1, 0x72, 0xf3, 0x47, 0xe4, 0x3e, 0x3d, 0x80, 0xd6, 0x21, 0x6a,
	0x77, 0x78, 0x4e, 0x63, 0x6d, 0x77, 0x64, 0x66, 0x41, 0x3b, 0x35, 0xef, 0x06, 0x6d, 0x1b, 0x9e,
	0x33, 0xc0, 0xa7, 0xc9, 0x8f, 0x69, 0x48, 0x7e, 0x4e, 0x43, 0xf2, 0x7b, 0x1a, 0x92, 0xaf, 0x7f,
	0xc2, 0x0d, 0xf0, 0xb9, 0x48, 0x94, 0x66, 0xc3, 0xd3, 0x42, 0x7c, 0x9c, 0xfd, 0x33, 0x09, 0x93,
	0x3c, 0x29, 0xd3, 0x57, 0x5e, 0x99, 0x9e, 0x6c, 0xbc, 0xb9, 0x5a, 0xc7, 0x1e, 0xfc, 0x0b, 0x00,
	0x00, 0xff, 0xff, 0x68, 0x2f, 0xd5, 0x30, 0xc6, 0x03, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ServiceIdentityServiceClient is the client API for ServiceIdentityService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type ServiceIdentityServiceClient interface {
	GetServiceIdentities(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ServiceIdentityResponse, error)
	// CreateServiceIdentity creates a new key pair and certificate.
	// The key and certificate are not retained and can never be retrieved again.
	CreateServiceIdentity(ctx context.Context, in *CreateServiceIdentityRequest, opts ...grpc.CallOption) (*CreateServiceIdentityResponse, error)
	// GetAuthorities returns the authorities currently in use.
	GetAuthorities(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Authorities, error)
}

type serviceIdentityServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewServiceIdentityServiceClient(cc grpc.ClientConnInterface) ServiceIdentityServiceClient {
	return &serviceIdentityServiceClient{cc}
}

func (c *serviceIdentityServiceClient) GetServiceIdentities(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ServiceIdentityResponse, error) {
	out := new(ServiceIdentityResponse)
	err := c.cc.Invoke(ctx, "/v1.ServiceIdentityService/GetServiceIdentities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceIdentityServiceClient) CreateServiceIdentity(ctx context.Context, in *CreateServiceIdentityRequest, opts ...grpc.CallOption) (*CreateServiceIdentityResponse, error) {
	out := new(CreateServiceIdentityResponse)
	err := c.cc.Invoke(ctx, "/v1.ServiceIdentityService/CreateServiceIdentity", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceIdentityServiceClient) GetAuthorities(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Authorities, error) {
	out := new(Authorities)
	err := c.cc.Invoke(ctx, "/v1.ServiceIdentityService/GetAuthorities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ServiceIdentityServiceServer is the server API for ServiceIdentityService service.
type ServiceIdentityServiceServer interface {
	GetServiceIdentities(context.Context, *Empty) (*ServiceIdentityResponse, error)
	// CreateServiceIdentity creates a new key pair and certificate.
	// The key and certificate are not retained and can never be retrieved again.
	CreateServiceIdentity(context.Context, *CreateServiceIdentityRequest) (*CreateServiceIdentityResponse, error)
	// GetAuthorities returns the authorities currently in use.
	GetAuthorities(context.Context, *Empty) (*Authorities, error)
}

// UnimplementedServiceIdentityServiceServer can be embedded to have forward compatible implementations.
type UnimplementedServiceIdentityServiceServer struct {
}

func (*UnimplementedServiceIdentityServiceServer) GetServiceIdentities(ctx context.Context, req *Empty) (*ServiceIdentityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServiceIdentities not implemented")
}
func (*UnimplementedServiceIdentityServiceServer) CreateServiceIdentity(ctx context.Context, req *CreateServiceIdentityRequest) (*CreateServiceIdentityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateServiceIdentity not implemented")
}
func (*UnimplementedServiceIdentityServiceServer) GetAuthorities(ctx context.Context, req *Empty) (*Authorities, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAuthorities not implemented")
}

func RegisterServiceIdentityServiceServer(s *grpc.Server, srv ServiceIdentityServiceServer) {
	s.RegisterService(&_ServiceIdentityService_serviceDesc, srv)
}

func _ServiceIdentityService_GetServiceIdentities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceIdentityServiceServer).GetServiceIdentities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ServiceIdentityService/GetServiceIdentities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceIdentityServiceServer).GetServiceIdentities(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceIdentityService_CreateServiceIdentity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceIdentityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceIdentityServiceServer).CreateServiceIdentity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ServiceIdentityService/CreateServiceIdentity",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceIdentityServiceServer).CreateServiceIdentity(ctx, req.(*CreateServiceIdentityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceIdentityService_GetAuthorities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceIdentityServiceServer).GetAuthorities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ServiceIdentityService/GetAuthorities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceIdentityServiceServer).GetAuthorities(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

var _ServiceIdentityService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.ServiceIdentityService",
	HandlerType: (*ServiceIdentityServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetServiceIdentities",
			Handler:    _ServiceIdentityService_GetServiceIdentities_Handler,
		},
		{
			MethodName: "CreateServiceIdentity",
			Handler:    _ServiceIdentityService_CreateServiceIdentity_Handler,
		},
		{
			MethodName: "GetAuthorities",
			Handler:    _ServiceIdentityService_GetAuthorities_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/service_identity_service.proto",
}

func (m *ServiceIdentityResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceIdentityResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServiceIdentityResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Identities) > 0 {
		for iNdEx := len(m.Identities) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Identities[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintServiceIdentityService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *CreateServiceIdentityRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CreateServiceIdentityRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CreateServiceIdentityRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Type != 0 {
		i = encodeVarintServiceIdentityService(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintServiceIdentityService(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CreateServiceIdentityResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CreateServiceIdentityResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CreateServiceIdentityResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PrivateKeyPem) > 0 {
		i -= len(m.PrivateKeyPem)
		copy(dAtA[i:], m.PrivateKeyPem)
		i = encodeVarintServiceIdentityService(dAtA, i, uint64(len(m.PrivateKeyPem)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.CertificatePem) > 0 {
		i -= len(m.CertificatePem)
		copy(dAtA[i:], m.CertificatePem)
		i = encodeVarintServiceIdentityService(dAtA, i, uint64(len(m.CertificatePem)))
		i--
		dAtA[i] = 0x12
	}
	if m.Identity != nil {
		{
			size, err := m.Identity.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintServiceIdentityService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Authority) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Authority) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Authority) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.CertificatePem) > 0 {
		i -= len(m.CertificatePem)
		copy(dAtA[i:], m.CertificatePem)
		i = encodeVarintServiceIdentityService(dAtA, i, uint64(len(m.CertificatePem)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Authorities) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Authorities) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Authorities) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Authorities) > 0 {
		for iNdEx := len(m.Authorities) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Authorities[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintServiceIdentityService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintServiceIdentityService(dAtA []byte, offset int, v uint64) int {
	offset -= sovServiceIdentityService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ServiceIdentityResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Identities) > 0 {
		for _, e := range m.Identities {
			l = e.Size()
			n += 1 + l + sovServiceIdentityService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CreateServiceIdentityRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovServiceIdentityService(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovServiceIdentityService(uint64(m.Type))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CreateServiceIdentityResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Identity != nil {
		l = m.Identity.Size()
		n += 1 + l + sovServiceIdentityService(uint64(l))
	}
	l = len(m.CertificatePem)
	if l > 0 {
		n += 1 + l + sovServiceIdentityService(uint64(l))
	}
	l = len(m.PrivateKeyPem)
	if l > 0 {
		n += 1 + l + sovServiceIdentityService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Authority) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CertificatePem)
	if l > 0 {
		n += 1 + l + sovServiceIdentityService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Authorities) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Authorities) > 0 {
		for _, e := range m.Authorities {
			l = e.Size()
			n += 1 + l + sovServiceIdentityService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovServiceIdentityService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozServiceIdentityService(x uint64) (n int) {
	return sovServiceIdentityService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ServiceIdentityResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowServiceIdentityService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServiceIdentityResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServiceIdentityResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Identities", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowServiceIdentityService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthServiceIdentityService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthServiceIdentityService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Identities = append(m.Identities, &storage.ServiceIdentity{})
			if err := m.Identities[len(m.Identities)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipServiceIdentityService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthServiceIdentityService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CreateServiceIdentityRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowServiceIdentityService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreateServiceIdentityRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreateServiceIdentityRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowServiceIdentityService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthServiceIdentityService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthServiceIdentityService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowServiceIdentityService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= storage.ServiceType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipServiceIdentityService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthServiceIdentityService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CreateServiceIdentityResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowServiceIdentityService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreateServiceIdentityResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreateServiceIdentityResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Identity", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowServiceIdentityService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthServiceIdentityService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthServiceIdentityService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Identity == nil {
				m.Identity = &storage.ServiceIdentity{}
			}
			if err := m.Identity.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CertificatePem", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowServiceIdentityService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthServiceIdentityService
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthServiceIdentityService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CertificatePem = append(m.CertificatePem[:0], dAtA[iNdEx:postIndex]...)
			if m.CertificatePem == nil {
				m.CertificatePem = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrivateKeyPem", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowServiceIdentityService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthServiceIdentityService
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthServiceIdentityService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrivateKeyPem = append(m.PrivateKeyPem[:0], dAtA[iNdEx:postIndex]...)
			if m.PrivateKeyPem == nil {
				m.PrivateKeyPem = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipServiceIdentityService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthServiceIdentityService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Authority) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowServiceIdentityService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Authority: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Authority: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CertificatePem", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowServiceIdentityService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthServiceIdentityService
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthServiceIdentityService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CertificatePem = append(m.CertificatePem[:0], dAtA[iNdEx:postIndex]...)
			if m.CertificatePem == nil {
				m.CertificatePem = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipServiceIdentityService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthServiceIdentityService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Authorities) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowServiceIdentityService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Authorities: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Authorities: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Authorities", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowServiceIdentityService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthServiceIdentityService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthServiceIdentityService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Authorities = append(m.Authorities, &Authority{})
			if err := m.Authorities[len(m.Authorities)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipServiceIdentityService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthServiceIdentityService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipServiceIdentityService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowServiceIdentityService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowServiceIdentityService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowServiceIdentityService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthServiceIdentityService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupServiceIdentityService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthServiceIdentityService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthServiceIdentityService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowServiceIdentityService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupServiceIdentityService = fmt.Errorf("proto: unexpected end of group")
)
