// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/signature_integration_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ListSignatureIntegrationsResponse struct {
	Integrations         []*storage.SignatureIntegration `protobuf:"bytes,1,rep,name=integrations,proto3" json:"integrations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *ListSignatureIntegrationsResponse) Reset()         { *m = ListSignatureIntegrationsResponse{} }
func (m *ListSignatureIntegrationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSignatureIntegrationsResponse) ProtoMessage()    {}
func (*ListSignatureIntegrationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_dda2156ddd73baf3, []int{0}
}
func (m *ListSignatureIntegrationsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListSignatureIntegrationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListSignatureIntegrationsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListSignatureIntegrationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSignatureIntegrationsResponse.Merge(m, src)
}
func (m *ListSignatureIntegrationsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListSignatureIntegrationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSignatureIntegrationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSignatureIntegrationsResponse proto.InternalMessageInfo

func (m *ListSignatureIntegrationsResponse) GetIntegrations() []*storage.SignatureIntegration {
	if m != nil {
		return m.Integrations
	}
	return nil
}

func (m *ListSignatureIntegrationsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListSignatureIntegrationsResponse) Clone() *ListSignatureIntegrationsResponse {
	if m == nil {
		return nil
	}
	cloned := new(ListSignatureIntegrationsResponse)
	*cloned = *m

	if m.Integrations != nil {
		cloned.Integrations = make([]*storage.SignatureIntegration, len(m.Integrations))
		for idx, v := range m.Integrations {
			cloned.Integrations[idx] = v.Clone()
		}
	}
	return cloned
}

func init() {
	proto.RegisterType((*ListSignatureIntegrationsResponse)(nil), "v1.ListSignatureIntegrationsResponse")
}

func init() {
	proto.RegisterFile("api/v1/signature_integration_service.proto", fileDescriptor_dda2156ddd73baf3)
}

var fileDescriptor_dda2156ddd73baf3 = []byte{
	// 382 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x92, 0x4f, 0x4b, 0xe3, 0x40,
	0x18, 0xc6, 0x9b, 0xee, 0xb2, 0xb0, 0xb3, 0x7b, 0x58, 0x66, 0x0f, 0x6d, 0xd3, 0xdd, 0xd0, 0xa6,
	0x2a, 0xda, 0xc3, 0x84, 0xd4, 0x9b, 0x37, 0x4b, 0x45, 0x0a, 0x1e, 0x4a, 0x7b, 0x11, 0x2f, 0x65,
	0x8c, 0xaf, 0x61, 0xb0, 0x9d, 0x09, 0x33, 0xd3, 0x60, 0x11, 0x3d, 0xf8, 0x15, 0xbc, 0xf8, 0x91,
	0x3c, 0x0a, 0x82, 0x67, 0xa9, 0x7e, 0x10, 0xc9, 0x1f, 0x69, 0x0b, 0x69, 0x23, 0xde, 0xc2, 0xcb,
	0xf3, 0xbc, 0xbf, 0xe7, 0x79, 0x33, 0xa8, 0x49, 0x03, 0xe6, 0x84, 0xae, 0xa3, 0x98, 0xcf, 0xa9,
	0x9e, 0x48, 0x18, 0x32, 0xae, 0xc1, 0x97, 0x54, 0x33, 0xc1, 0x87, 0x0a, 0x64, 0xc8, 0x3c, 0x20,
	0x81, 0x14, 0x5a, 0xe0, 0x62, 0xe8, 0x9a, 0xff, 0x7c, 0x21, 0xfc, 0x11, 0x38, 0x91, 0x8d, 0x72,
	0x2e, 0x74, 0x2c, 0x54, 0x89, 0xc2, 0xc4, 0xe9, 0x36, 0x18, 0x07, 0x7a, 0x9a, 0xce, 0xfe, 0xa6,
	0x33, 0x4f, 0x8c, 0xc7, 0x82, 0xa7, 0xc3, 0x86, 0xd2, 0x42, 0x52, 0x1f, 0xb2, 0xb9, 0x89, 0xc8,
	0x3e, 0x47, 0xf5, 0x23, 0xa6, 0xf4, 0xe0, 0x43, 0xd2, 0x9d, 0x2b, 0x54, 0x1f, 0x54, 0x20, 0xb8,
	0x02, 0xbc, 0x8f, 0x7e, 0x2f, 0x38, 0x55, 0xd9, 0xa8, 0x7d, 0xdb, 0xfe, 0xd5, 0xfa, 0x4f, 0x52,
	0x00, 0xc9, 0x72, 0xf7, 0x97, 0x2c, 0xad, 0xe7, 0xef, 0xa8, 0x9a, 0x25, 0x1b, 0x24, 0xed, 0x71,
	0x80, 0x2a, 0x2b, 0x73, 0xe0, 0x9f, 0x24, 0x74, 0xc9, 0x41, 0xd4, 0xd7, 0xdc, 0x8c, 0x3e, 0x73,
	0x13, 0xdb, 0xf5, 0xdb, 0xa7, 0xb7, 0xbb, 0x62, 0x15, 0x57, 0x96, 0xee, 0xbe, 0x98, 0x08, 0x4b,
	0x54, 0x3a, 0x84, 0xcc, 0x35, 0xf8, 0x4f, 0x04, 0xe9, 0x83, 0x12, 0x13, 0xe9, 0x41, 0x7b, 0xda,
	0xed, 0x98, 0xeb, 0xbb, 0xda, 0x5b, 0x31, 0xae, 0x86, 0xad, 0x95, 0x38, 0xe7, 0x8a, 0x9d, 0x5d,
	0xe3, 0x1b, 0x54, 0xee, 0x89, 0xec, 0xec, 0x78, 0x3d, 0x22, 0x2f, 0xc1, 0x46, 0x9c, 0xc0, 0xb2,
	0x57, 0x17, 0xde, 0x33, 0x9a, 0x98, 0xa3, 0x52, 0x6f, 0xf2, 0x25, 0xfc, 0xfc, 0x17, 0xd8, 0x3b,
	0x31, 0xaa, 0x61, 0xe6, 0x94, 0x8d, 0x78, 0x14, 0x99, 0x1d, 0x18, 0x81, 0x86, 0x4f, 0x9e, 0x79,
	0x81, 0x92, 0x9e, 0xb4, 0x99, 0x43, 0x69, 0x93, 0x87, 0x99, 0x65, 0x3c, 0xce, 0x2c, 0xe3, 0x65,
	0x66, 0x19, 0xf7, 0xaf, 0x56, 0x01, 0x95, 0x99, 0x20, 0x4a, 0x53, 0xef, 0x42, 0x8a, 0xcb, 0xe4,
	0x95, 0x13, 0x1a, 0x30, 0x12, 0xba, 0x27, 0xc5, 0xd0, 0x3d, 0x2e, 0x9c, 0xfe, 0x88, 0x67, 0xbb,
	0xef, 0x01, 0x00, 0x00, 0xff, 0xff, 0x2c, 0x89, 0xa6, 0x36, 0x97, 0x03, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SignatureIntegrationServiceClient is the client API for SignatureIntegrationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type SignatureIntegrationServiceClient interface {
	ListSignatureIntegrations(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ListSignatureIntegrationsResponse, error)
	GetSignatureIntegration(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.SignatureIntegration, error)
	// Integration id should not be set.
	// Returns signature integration with id filled.
	PostSignatureIntegration(ctx context.Context, in *storage.SignatureIntegration, opts ...grpc.CallOption) (*storage.SignatureIntegration, error)
	PutSignatureIntegration(ctx context.Context, in *storage.SignatureIntegration, opts ...grpc.CallOption) (*Empty, error)
	DeleteSignatureIntegration(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error)
}

type signatureIntegrationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSignatureIntegrationServiceClient(cc grpc.ClientConnInterface) SignatureIntegrationServiceClient {
	return &signatureIntegrationServiceClient{cc}
}

func (c *signatureIntegrationServiceClient) ListSignatureIntegrations(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ListSignatureIntegrationsResponse, error) {
	out := new(ListSignatureIntegrationsResponse)
	err := c.cc.Invoke(ctx, "/v1.SignatureIntegrationService/ListSignatureIntegrations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *signatureIntegrationServiceClient) GetSignatureIntegration(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.SignatureIntegration, error) {
	out := new(storage.SignatureIntegration)
	err := c.cc.Invoke(ctx, "/v1.SignatureIntegrationService/GetSignatureIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *signatureIntegrationServiceClient) PostSignatureIntegration(ctx context.Context, in *storage.SignatureIntegration, opts ...grpc.CallOption) (*storage.SignatureIntegration, error) {
	out := new(storage.SignatureIntegration)
	err := c.cc.Invoke(ctx, "/v1.SignatureIntegrationService/PostSignatureIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *signatureIntegrationServiceClient) PutSignatureIntegration(ctx context.Context, in *storage.SignatureIntegration, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.SignatureIntegrationService/PutSignatureIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *signatureIntegrationServiceClient) DeleteSignatureIntegration(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.SignatureIntegrationService/DeleteSignatureIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SignatureIntegrationServiceServer is the server API for SignatureIntegrationService service.
type SignatureIntegrationServiceServer interface {
	ListSignatureIntegrations(context.Context, *Empty) (*ListSignatureIntegrationsResponse, error)
	GetSignatureIntegration(context.Context, *ResourceByID) (*storage.SignatureIntegration, error)
	// Integration id should not be set.
	// Returns signature integration with id filled.
	PostSignatureIntegration(context.Context, *storage.SignatureIntegration) (*storage.SignatureIntegration, error)
	PutSignatureIntegration(context.Context, *storage.SignatureIntegration) (*Empty, error)
	DeleteSignatureIntegration(context.Context, *ResourceByID) (*Empty, error)
}

// UnimplementedSignatureIntegrationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSignatureIntegrationServiceServer struct {
}

func (*UnimplementedSignatureIntegrationServiceServer) ListSignatureIntegrations(ctx context.Context, req *Empty) (*ListSignatureIntegrationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSignatureIntegrations not implemented")
}
func (*UnimplementedSignatureIntegrationServiceServer) GetSignatureIntegration(ctx context.Context, req *ResourceByID) (*storage.SignatureIntegration, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSignatureIntegration not implemented")
}
func (*UnimplementedSignatureIntegrationServiceServer) PostSignatureIntegration(ctx context.Context, req *storage.SignatureIntegration) (*storage.SignatureIntegration, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PostSignatureIntegration not implemented")
}
func (*UnimplementedSignatureIntegrationServiceServer) PutSignatureIntegration(ctx context.Context, req *storage.SignatureIntegration) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PutSignatureIntegration not implemented")
}
func (*UnimplementedSignatureIntegrationServiceServer) DeleteSignatureIntegration(ctx context.Context, req *ResourceByID) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSignatureIntegration not implemented")
}

func RegisterSignatureIntegrationServiceServer(s *grpc.Server, srv SignatureIntegrationServiceServer) {
	s.RegisterService(&_SignatureIntegrationService_serviceDesc, srv)
}

func _SignatureIntegrationService_ListSignatureIntegrations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SignatureIntegrationServiceServer).ListSignatureIntegrations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.SignatureIntegrationService/ListSignatureIntegrations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SignatureIntegrationServiceServer).ListSignatureIntegrations(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SignatureIntegrationService_GetSignatureIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SignatureIntegrationServiceServer).GetSignatureIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.SignatureIntegrationService/GetSignatureIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SignatureIntegrationServiceServer).GetSignatureIntegration(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _SignatureIntegrationService_PostSignatureIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.SignatureIntegration)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SignatureIntegrationServiceServer).PostSignatureIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.SignatureIntegrationService/PostSignatureIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SignatureIntegrationServiceServer).PostSignatureIntegration(ctx, req.(*storage.SignatureIntegration))
	}
	return interceptor(ctx, in, info, handler)
}

func _SignatureIntegrationService_PutSignatureIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.SignatureIntegration)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SignatureIntegrationServiceServer).PutSignatureIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.SignatureIntegrationService/PutSignatureIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SignatureIntegrationServiceServer).PutSignatureIntegration(ctx, req.(*storage.SignatureIntegration))
	}
	return interceptor(ctx, in, info, handler)
}

func _SignatureIntegrationService_DeleteSignatureIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SignatureIntegrationServiceServer).DeleteSignatureIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.SignatureIntegrationService/DeleteSignatureIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SignatureIntegrationServiceServer).DeleteSignatureIntegration(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

var _SignatureIntegrationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.SignatureIntegrationService",
	HandlerType: (*SignatureIntegrationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListSignatureIntegrations",
			Handler:    _SignatureIntegrationService_ListSignatureIntegrations_Handler,
		},
		{
			MethodName: "GetSignatureIntegration",
			Handler:    _SignatureIntegrationService_GetSignatureIntegration_Handler,
		},
		{
			MethodName: "PostSignatureIntegration",
			Handler:    _SignatureIntegrationService_PostSignatureIntegration_Handler,
		},
		{
			MethodName: "PutSignatureIntegration",
			Handler:    _SignatureIntegrationService_PutSignatureIntegration_Handler,
		},
		{
			MethodName: "DeleteSignatureIntegration",
			Handler:    _SignatureIntegrationService_DeleteSignatureIntegration_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/signature_integration_service.proto",
}

func (m *ListSignatureIntegrationsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListSignatureIntegrationsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListSignatureIntegrationsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Integrations) > 0 {
		for iNdEx := len(m.Integrations) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Integrations[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSignatureIntegrationService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintSignatureIntegrationService(dAtA []byte, offset int, v uint64) int {
	offset -= sovSignatureIntegrationService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ListSignatureIntegrationsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Integrations) > 0 {
		for _, e := range m.Integrations {
			l = e.Size()
			n += 1 + l + sovSignatureIntegrationService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovSignatureIntegrationService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozSignatureIntegrationService(x uint64) (n int) {
	return sovSignatureIntegrationService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ListSignatureIntegrationsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSignatureIntegrationService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListSignatureIntegrationsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListSignatureIntegrationsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Integrations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignatureIntegrationService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSignatureIntegrationService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSignatureIntegrationService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Integrations = append(m.Integrations, &storage.SignatureIntegration{})
			if err := m.Integrations[len(m.Integrations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSignatureIntegrationService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSignatureIntegrationService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSignatureIntegrationService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSignatureIntegrationService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSignatureIntegrationService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSignatureIntegrationService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthSignatureIntegrationService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupSignatureIntegrationService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthSignatureIntegrationService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthSignatureIntegrationService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSignatureIntegrationService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupSignatureIntegrationService = fmt.Errorf("proto: unexpected end of group")
)
