// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/summary_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type SummaryCountsResponse struct {
	NumAlerts            int64    `protobuf:"varint,1,opt,name=num_alerts,json=numAlerts,proto3" json:"num_alerts,omitempty"`
	NumClusters          int64    `protobuf:"varint,2,opt,name=num_clusters,json=numClusters,proto3" json:"num_clusters,omitempty"`
	NumDeployments       int64    `protobuf:"varint,3,opt,name=num_deployments,json=numDeployments,proto3" json:"num_deployments,omitempty"`
	NumImages            int64    `protobuf:"varint,4,opt,name=num_images,json=numImages,proto3" json:"num_images,omitempty"`
	NumSecrets           int64    `protobuf:"varint,5,opt,name=num_secrets,json=numSecrets,proto3" json:"num_secrets,omitempty"`
	NumNodes             int64    `protobuf:"varint,6,opt,name=num_nodes,json=numNodes,proto3" json:"num_nodes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SummaryCountsResponse) Reset()         { *m = SummaryCountsResponse{} }
func (m *SummaryCountsResponse) String() string { return proto.CompactTextString(m) }
func (*SummaryCountsResponse) ProtoMessage()    {}
func (*SummaryCountsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7f191278ca02d609, []int{0}
}
func (m *SummaryCountsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SummaryCountsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SummaryCountsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SummaryCountsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SummaryCountsResponse.Merge(m, src)
}
func (m *SummaryCountsResponse) XXX_Size() int {
	return m.Size()
}
func (m *SummaryCountsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SummaryCountsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SummaryCountsResponse proto.InternalMessageInfo

func (m *SummaryCountsResponse) GetNumAlerts() int64 {
	if m != nil {
		return m.NumAlerts
	}
	return 0
}

func (m *SummaryCountsResponse) GetNumClusters() int64 {
	if m != nil {
		return m.NumClusters
	}
	return 0
}

func (m *SummaryCountsResponse) GetNumDeployments() int64 {
	if m != nil {
		return m.NumDeployments
	}
	return 0
}

func (m *SummaryCountsResponse) GetNumImages() int64 {
	if m != nil {
		return m.NumImages
	}
	return 0
}

func (m *SummaryCountsResponse) GetNumSecrets() int64 {
	if m != nil {
		return m.NumSecrets
	}
	return 0
}

func (m *SummaryCountsResponse) GetNumNodes() int64 {
	if m != nil {
		return m.NumNodes
	}
	return 0
}

func (m *SummaryCountsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SummaryCountsResponse) Clone() *SummaryCountsResponse {
	if m == nil {
		return nil
	}
	cloned := new(SummaryCountsResponse)
	*cloned = *m

	return cloned
}

func init() {
	proto.RegisterType((*SummaryCountsResponse)(nil), "v1.SummaryCountsResponse")
}

func init() { proto.RegisterFile("api/v1/summary_service.proto", fileDescriptor_7f191278ca02d609) }

var fileDescriptor_7f191278ca02d609 = []byte{
	// 341 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x6c, 0x91, 0xcf, 0x4a, 0xc3, 0x40,
	0x10, 0x87, 0x9b, 0x54, 0x8b, 0x5d, 0xa5, 0xca, 0xa2, 0x10, 0x63, 0x8d, 0xda, 0x8b, 0x9e, 0x12,
	0xa2, 0x4f, 0xa0, 0x55, 0xc4, 0x8b, 0x87, 0xd6, 0x83, 0x78, 0x09, 0x6b, 0x3a, 0x96, 0x60, 0x76,
	0x37, 0x64, 0x76, 0x83, 0xbd, 0xfa, 0x0a, 0x5e, 0x7c, 0x24, 0x8f, 0x82, 0x0f, 0xa0, 0x54, 0x1f,
	0x44, 0x76, 0x53, 0xff, 0x81, 0xb7, 0xe4, 0x9b, 0x6f, 0x66, 0x98, 0xdf, 0x92, 0x2e, 0x2b, 0xb2,
	0xa8, 0x8a, 0x23, 0xd4, 0x9c, 0xb3, 0x72, 0x92, 0x20, 0x94, 0x55, 0x96, 0x42, 0x58, 0x94, 0x52,
	0x49, 0xea, 0x56, 0xb1, 0xdf, 0x1d, 0x4b, 0x39, 0xce, 0x21, 0x32, 0x22, 0x13, 0x42, 0x2a, 0xa6,
	0x32, 0x29, 0xb0, 0x36, 0x7c, 0x3a, 0xeb, 0x07, 0x5e, 0xa8, 0x49, 0xcd, 0x7a, 0xaf, 0x0e, 0x59,
	0x1b, 0xd6, 0xf3, 0xfa, 0x52, 0x0b, 0x85, 0x03, 0xc0, 0x42, 0x0a, 0x04, 0xba, 0x49, 0x88, 0xd0,
	0x3c, 0x61, 0x39, 0x94, 0x0a, 0x3d, 0x67, 0xdb, 0xd9, 0x6b, 0x0e, 0xda, 0x42, 0xf3, 0x43, 0x0b,
	0xe8, 0x0e, 0x59, 0x32, 0xe5, 0x34, 0xd7, 0xa8, 0xa0, 0x44, 0xcf, 0xb5, 0xc2, 0xa2, 0xd0, 0xbc,
	0x3f, 0x43, 0x74, 0x97, 0x2c, 0x1b, 0x65, 0x04, 0x45, 0x2e, 0x27, 0x1c, 0x84, 0x42, 0xaf, 0x69,
	0xad, 0x8e, 0xd0, 0xfc, 0xf8, 0x87, 0x7e, 0xad, 0xca, 0x38, 0x1b, 0x03, 0x7a, 0x73, 0xdf, 0xab,
	0xce, 0x2c, 0xa0, 0x5b, 0xc4, 0x8c, 0x4d, 0x10, 0xd2, 0x12, 0x14, 0x7a, 0xf3, 0xb6, 0x6e, 0x3a,
	0x86, 0x35, 0xa1, 0x1b, 0xc4, 0xd8, 0x89, 0x90, 0x23, 0x40, 0xaf, 0x65, 0xcb, 0x0b, 0x42, 0xf3,
	0x73, 0xf3, 0xbf, 0x7f, 0x43, 0x3a, 0xb3, 0x03, 0x87, 0x75, 0x5e, 0xf4, 0x82, 0xac, 0x9c, 0x82,
	0xfa, 0x73, 0x35, 0x6d, 0x87, 0x55, 0x1c, 0x9e, 0x98, 0x60, 0xfc, 0x75, 0xf3, 0xf9, 0x6f, 0x26,
	0x3d, 0xff, 0xfe, 0xe5, 0xe3, 0xc1, 0x5d, 0xa5, 0xf4, 0xd7, 0x33, 0x44, 0xa9, 0x75, 0x8e, 0xc2,
	0xa7, 0x69, 0xe0, 0x3c, 0x4f, 0x03, 0xe7, 0x6d, 0x1a, 0x38, 0x8f, 0xef, 0x41, 0x83, 0x78, 0x99,
	0x0c, 0x51, 0xb1, 0xf4, 0xb6, 0x94, 0x77, 0x75, 0xdc, 0x21, 0x2b, 0xb2, 0xb0, 0x8a, 0xaf, 0xdc,
	0x2a, 0xbe, 0x6c, 0x5c, 0xb7, 0x2c, 0x3b, 0xf8, 0x0c, 0x00, 0x00, 0xff, 0xff, 0x74, 0x02, 0x1b,
	0xc5, 0xd8, 0x01, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SummaryServiceClient is the client API for SummaryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type SummaryServiceClient interface {
	GetSummaryCounts(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*SummaryCountsResponse, error)
}

type summaryServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSummaryServiceClient(cc grpc.ClientConnInterface) SummaryServiceClient {
	return &summaryServiceClient{cc}
}

func (c *summaryServiceClient) GetSummaryCounts(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*SummaryCountsResponse, error) {
	out := new(SummaryCountsResponse)
	err := c.cc.Invoke(ctx, "/v1.SummaryService/GetSummaryCounts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SummaryServiceServer is the server API for SummaryService service.
type SummaryServiceServer interface {
	GetSummaryCounts(context.Context, *Empty) (*SummaryCountsResponse, error)
}

// UnimplementedSummaryServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSummaryServiceServer struct {
}

func (*UnimplementedSummaryServiceServer) GetSummaryCounts(ctx context.Context, req *Empty) (*SummaryCountsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSummaryCounts not implemented")
}

func RegisterSummaryServiceServer(s *grpc.Server, srv SummaryServiceServer) {
	s.RegisterService(&_SummaryService_serviceDesc, srv)
}

func _SummaryService_GetSummaryCounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SummaryServiceServer).GetSummaryCounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.SummaryService/GetSummaryCounts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SummaryServiceServer).GetSummaryCounts(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

var _SummaryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.SummaryService",
	HandlerType: (*SummaryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetSummaryCounts",
			Handler:    _SummaryService_GetSummaryCounts_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/summary_service.proto",
}

func (m *SummaryCountsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SummaryCountsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SummaryCountsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.NumNodes != 0 {
		i = encodeVarintSummaryService(dAtA, i, uint64(m.NumNodes))
		i--
		dAtA[i] = 0x30
	}
	if m.NumSecrets != 0 {
		i = encodeVarintSummaryService(dAtA, i, uint64(m.NumSecrets))
		i--
		dAtA[i] = 0x28
	}
	if m.NumImages != 0 {
		i = encodeVarintSummaryService(dAtA, i, uint64(m.NumImages))
		i--
		dAtA[i] = 0x20
	}
	if m.NumDeployments != 0 {
		i = encodeVarintSummaryService(dAtA, i, uint64(m.NumDeployments))
		i--
		dAtA[i] = 0x18
	}
	if m.NumClusters != 0 {
		i = encodeVarintSummaryService(dAtA, i, uint64(m.NumClusters))
		i--
		dAtA[i] = 0x10
	}
	if m.NumAlerts != 0 {
		i = encodeVarintSummaryService(dAtA, i, uint64(m.NumAlerts))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintSummaryService(dAtA []byte, offset int, v uint64) int {
	offset -= sovSummaryService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *SummaryCountsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NumAlerts != 0 {
		n += 1 + sovSummaryService(uint64(m.NumAlerts))
	}
	if m.NumClusters != 0 {
		n += 1 + sovSummaryService(uint64(m.NumClusters))
	}
	if m.NumDeployments != 0 {
		n += 1 + sovSummaryService(uint64(m.NumDeployments))
	}
	if m.NumImages != 0 {
		n += 1 + sovSummaryService(uint64(m.NumImages))
	}
	if m.NumSecrets != 0 {
		n += 1 + sovSummaryService(uint64(m.NumSecrets))
	}
	if m.NumNodes != 0 {
		n += 1 + sovSummaryService(uint64(m.NumNodes))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovSummaryService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozSummaryService(x uint64) (n int) {
	return sovSummaryService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *SummaryCountsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSummaryService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SummaryCountsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SummaryCountsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumAlerts", wireType)
			}
			m.NumAlerts = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSummaryService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumAlerts |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumClusters", wireType)
			}
			m.NumClusters = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSummaryService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumClusters |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumDeployments", wireType)
			}
			m.NumDeployments = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSummaryService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumDeployments |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumImages", wireType)
			}
			m.NumImages = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSummaryService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumImages |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumSecrets", wireType)
			}
			m.NumSecrets = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSummaryService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumSecrets |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumNodes", wireType)
			}
			m.NumNodes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSummaryService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumNodes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSummaryService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSummaryService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSummaryService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSummaryService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSummaryService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSummaryService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthSummaryService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupSummaryService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthSummaryService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthSummaryService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSummaryService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupSummaryService = fmt.Errorf("proto: unexpected end of group")
)
