// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: internalapi/central/hello.proto

package central

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type HelmManagedConfigInit struct {
	ClusterConfig        *storage.CompleteClusterConfig `protobuf:"bytes,1,opt,name=cluster_config,json=clusterConfig,proto3" json:"cluster_config,omitempty"`
	ClusterName          string                         `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	ClusterId            string                         `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	NotHelmManaged       bool                           `protobuf:"varint,4,opt,name=not_helm_managed,json=notHelmManaged,proto3" json:"not_helm_managed,omitempty"` // Deprecated: Do not use.
	ManagedBy            storage.ManagerType            `protobuf:"varint,5,opt,name=managed_by,json=managedBy,proto3,enum=storage.ManagerType" json:"managed_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *HelmManagedConfigInit) Reset()         { *m = HelmManagedConfigInit{} }
func (m *HelmManagedConfigInit) String() string { return proto.CompactTextString(m) }
func (*HelmManagedConfigInit) ProtoMessage()    {}
func (*HelmManagedConfigInit) Descriptor() ([]byte, []int) {
	return fileDescriptor_ce25d1bd48ec88b4, []int{0}
}
func (m *HelmManagedConfigInit) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HelmManagedConfigInit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HelmManagedConfigInit.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HelmManagedConfigInit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HelmManagedConfigInit.Merge(m, src)
}
func (m *HelmManagedConfigInit) XXX_Size() int {
	return m.Size()
}
func (m *HelmManagedConfigInit) XXX_DiscardUnknown() {
	xxx_messageInfo_HelmManagedConfigInit.DiscardUnknown(m)
}

var xxx_messageInfo_HelmManagedConfigInit proto.InternalMessageInfo

func (m *HelmManagedConfigInit) GetClusterConfig() *storage.CompleteClusterConfig {
	if m != nil {
		return m.ClusterConfig
	}
	return nil
}

func (m *HelmManagedConfigInit) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *HelmManagedConfigInit) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (m *HelmManagedConfigInit) GetNotHelmManaged() bool {
	if m != nil {
		return m.NotHelmManaged
	}
	return false
}

func (m *HelmManagedConfigInit) GetManagedBy() storage.ManagerType {
	if m != nil {
		return m.ManagedBy
	}
	return storage.ManagerType_MANAGER_TYPE_UNKNOWN
}

func (m *HelmManagedConfigInit) MessageClone() proto.Message {
	return m.Clone()
}
func (m *HelmManagedConfigInit) Clone() *HelmManagedConfigInit {
	if m == nil {
		return nil
	}
	cloned := new(HelmManagedConfigInit)
	*cloned = *m

	cloned.ClusterConfig = m.ClusterConfig.Clone()
	return cloned
}

type SensorHello struct {
	SensorVersion            string                                  `protobuf:"bytes,1,opt,name=sensor_version,json=sensorVersion,proto3" json:"sensor_version,omitempty"`
	Capabilities             []string                                `protobuf:"bytes,2,rep,name=capabilities,proto3" json:"capabilities,omitempty"`
	DeploymentIdentification *storage.SensorDeploymentIdentification `protobuf:"bytes,5,opt,name=deployment_identification,json=deploymentIdentification,proto3" json:"deployment_identification,omitempty"`
	HelmManagedConfigInit    *HelmManagedConfigInit                  `protobuf:"bytes,3,opt,name=helm_managed_config_init,json=helmManagedConfigInit,proto3" json:"helm_managed_config_init,omitempty"`
	// Policy version sensor understands. If unset, central will try to guess it.
	PolicyVersion        string   `protobuf:"bytes,4,opt,name=policy_version,json=policyVersion,proto3" json:"policy_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SensorHello) Reset()         { *m = SensorHello{} }
func (m *SensorHello) String() string { return proto.CompactTextString(m) }
func (*SensorHello) ProtoMessage()    {}
func (*SensorHello) Descriptor() ([]byte, []int) {
	return fileDescriptor_ce25d1bd48ec88b4, []int{1}
}
func (m *SensorHello) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SensorHello) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SensorHello.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SensorHello) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SensorHello.Merge(m, src)
}
func (m *SensorHello) XXX_Size() int {
	return m.Size()
}
func (m *SensorHello) XXX_DiscardUnknown() {
	xxx_messageInfo_SensorHello.DiscardUnknown(m)
}

var xxx_messageInfo_SensorHello proto.InternalMessageInfo

func (m *SensorHello) GetSensorVersion() string {
	if m != nil {
		return m.SensorVersion
	}
	return ""
}

func (m *SensorHello) GetCapabilities() []string {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

func (m *SensorHello) GetDeploymentIdentification() *storage.SensorDeploymentIdentification {
	if m != nil {
		return m.DeploymentIdentification
	}
	return nil
}

func (m *SensorHello) GetHelmManagedConfigInit() *HelmManagedConfigInit {
	if m != nil {
		return m.HelmManagedConfigInit
	}
	return nil
}

func (m *SensorHello) GetPolicyVersion() string {
	if m != nil {
		return m.PolicyVersion
	}
	return ""
}

func (m *SensorHello) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SensorHello) Clone() *SensorHello {
	if m == nil {
		return nil
	}
	cloned := new(SensorHello)
	*cloned = *m

	if m.Capabilities != nil {
		cloned.Capabilities = make([]string, len(m.Capabilities))
		copy(cloned.Capabilities, m.Capabilities)
	}
	cloned.DeploymentIdentification = m.DeploymentIdentification.Clone()
	cloned.HelmManagedConfigInit = m.HelmManagedConfigInit.Clone()
	return cloned
}

type CentralHello struct {
	ClusterId            string            `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	CertBundle           map[string]string `protobuf:"bytes,2,rep,name=cert_bundle,json=certBundle,proto3" json:"cert_bundle,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CentralHello) Reset()         { *m = CentralHello{} }
func (m *CentralHello) String() string { return proto.CompactTextString(m) }
func (*CentralHello) ProtoMessage()    {}
func (*CentralHello) Descriptor() ([]byte, []int) {
	return fileDescriptor_ce25d1bd48ec88b4, []int{2}
}
func (m *CentralHello) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CentralHello) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CentralHello.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CentralHello) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CentralHello.Merge(m, src)
}
func (m *CentralHello) XXX_Size() int {
	return m.Size()
}
func (m *CentralHello) XXX_DiscardUnknown() {
	xxx_messageInfo_CentralHello.DiscardUnknown(m)
}

var xxx_messageInfo_CentralHello proto.InternalMessageInfo

func (m *CentralHello) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CentralHello) GetCertBundle() map[string]string {
	if m != nil {
		return m.CertBundle
	}
	return nil
}

func (m *CentralHello) MessageClone() proto.Message {
	return m.Clone()
}
func (m *CentralHello) Clone() *CentralHello {
	if m == nil {
		return nil
	}
	cloned := new(CentralHello)
	*cloned = *m

	if m.CertBundle != nil {
		cloned.CertBundle = make(map[string]string, len(m.CertBundle))
		for k, v := range m.CertBundle {
			cloned.CertBundle[k] = v
		}
	}
	return cloned
}

func init() {
	proto.RegisterType((*HelmManagedConfigInit)(nil), "central.HelmManagedConfigInit")
	proto.RegisterType((*SensorHello)(nil), "central.SensorHello")
	proto.RegisterType((*CentralHello)(nil), "central.CentralHello")
	proto.RegisterMapType((map[string]string)(nil), "central.CentralHello.CertBundleEntry")
}

func init() { proto.RegisterFile("internalapi/central/hello.proto", fileDescriptor_ce25d1bd48ec88b4) }

var fileDescriptor_ce25d1bd48ec88b4 = []byte{
	// 496 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x74, 0x93, 0xc1, 0x6e, 0xd3, 0x40,
	0x10, 0x86, 0x59, 0xa7, 0x01, 0x32, 0x49, 0x43, 0xb5, 0x6a, 0x24, 0xb7, 0x12, 0x21, 0x44, 0x8a,
	0xc8, 0x01, 0x39, 0x52, 0x7a, 0x41, 0x48, 0x5c, 0x62, 0x8a, 0x9a, 0x03, 0x1c, 0x0c, 0x02, 0x89,
	0x8b, 0xb5, 0xb1, 0xa7, 0xc9, 0x8a, 0xf5, 0xae, 0xb5, 0xde, 0x54, 0xf2, 0x99, 0x97, 0xe0, 0x41,
	0x38, 0x73, 0xe6, 0xc8, 0x23, 0xa0, 0xf0, 0x22, 0x28, 0xde, 0x8d, 0x95, 0x54, 0xed, 0xcd, 0xf3,
	0xcf, 0xe7, 0xd9, 0xd9, 0x7f, 0x66, 0xe1, 0x19, 0x97, 0x06, 0xb5, 0x64, 0x82, 0xe5, 0x7c, 0x92,
	0xa0, 0x34, 0x9a, 0x89, 0xc9, 0x0a, 0x85, 0x50, 0x41, 0xae, 0x95, 0x51, 0xf4, 0x91, 0x13, 0xcf,
	0x7b, 0x85, 0x51, 0x9a, 0x2d, 0x71, 0x92, 0x88, 0x75, 0x61, 0x50, 0xdb, 0xfc, 0xf0, 0xbb, 0x07,
	0xbd, 0x2b, 0x14, 0xd9, 0x7b, 0x26, 0xd9, 0x12, 0xd3, 0x50, 0xc9, 0x6b, 0xbe, 0x9c, 0x4b, 0x6e,
	0xe8, 0x25, 0x74, 0x1d, 0x1a, 0x27, 0x95, 0xea, 0x93, 0x01, 0x19, 0xb7, 0xa7, 0xfd, 0xc0, 0x55,
	0x0a, 0x42, 0x95, 0xe5, 0x02, 0x0d, 0x86, 0x16, 0xb3, 0xff, 0x46, 0xc7, 0xc9, 0x7e, 0x48, 0x9f,
	0x43, 0x67, 0x57, 0x46, 0xb2, 0x0c, 0x7d, 0x6f, 0x40, 0xc6, 0xad, 0xa8, 0xed, 0xb4, 0x0f, 0x2c,
	0x43, 0xfa, 0x14, 0x60, 0x87, 0xf0, 0xd4, 0x6f, 0x54, 0x40, 0xcb, 0x29, 0xf3, 0x94, 0xbe, 0x84,
	0x13, 0xa9, 0x4c, 0xbc, 0x42, 0x91, 0xc5, 0x99, 0x6d, 0xd3, 0x3f, 0x1a, 0x90, 0xf1, 0xe3, 0x99,
	0xe7, 0x93, 0xa8, 0x2b, 0x95, 0xd9, 0xbb, 0x00, 0xbd, 0x00, 0x70, 0x50, 0xbc, 0x28, 0xfd, 0xe6,
	0x80, 0x8c, 0xbb, 0xd3, 0xd3, 0xba, 0x65, 0x4b, 0xe9, 0x4f, 0x65, 0x8e, 0x51, 0xcb, 0x71, 0xb3,
	0x72, 0xf8, 0xcb, 0x83, 0xf6, 0x47, 0x94, 0x85, 0xd2, 0x57, 0x5b, 0xef, 0xe8, 0x08, 0xba, 0x45,
	0x15, 0xc6, 0x37, 0xa8, 0x0b, 0xae, 0x64, 0x75, 0xf7, 0x56, 0x74, 0x6c, 0xd5, 0xcf, 0x56, 0xa4,
	0x43, 0xe8, 0x24, 0x2c, 0x67, 0x0b, 0x2e, 0xb8, 0xe1, 0x58, 0xf8, 0xde, 0xa0, 0x31, 0x6e, 0x45,
	0x07, 0x1a, 0x4d, 0xe1, 0x2c, 0xc5, 0x5c, 0xa8, 0x32, 0x43, 0x69, 0x62, 0x9e, 0xa2, 0x34, 0xfc,
	0x9a, 0x27, 0xcc, 0x6c, 0xab, 0x36, 0x2b, 0x47, 0x5f, 0xd4, 0xed, 0xd9, 0x1e, 0xde, 0xd6, 0xfc,
	0xfc, 0x00, 0x8f, 0xfc, 0xf4, 0x9e, 0x0c, 0xfd, 0x02, 0xfe, 0xbe, 0x3f, 0x6e, 0x62, 0x31, 0x97,
	0xdc, 0x54, 0x86, 0x6e, 0xc7, 0xe6, 0x36, 0x21, 0xb8, 0x73, 0xdc, 0x51, 0x6f, 0x75, 0xe7, 0x16,
	0x8c, 0xa0, 0x9b, 0x2b, 0xc1, 0x93, 0xb2, 0x76, 0xe2, 0xc8, 0x3a, 0x61, 0x55, 0xe7, 0xc4, 0xf0,
	0x27, 0x81, 0x4e, 0x68, 0xeb, 0x5b, 0x07, 0x0f, 0x67, 0x4a, 0x6e, 0xcf, 0xf4, 0x1d, 0xb4, 0x13,
	0xd4, 0x26, 0x5e, 0xac, 0x65, 0x2a, 0xb0, 0x32, 0xae, 0x3d, 0x1d, 0xd5, 0x2d, 0xee, 0x97, 0x0a,
	0x42, 0xd4, 0x66, 0x56, 0x71, 0x97, 0xd2, 0xe8, 0x32, 0x82, 0xa4, 0x16, 0xce, 0xdf, 0xc0, 0x93,
	0x5b, 0x69, 0x7a, 0x02, 0x8d, 0x6f, 0x58, 0xba, 0x23, 0xb7, 0x9f, 0xf4, 0x14, 0x9a, 0x37, 0x4c,
	0xac, 0x77, 0xbb, 0x67, 0x83, 0xd7, 0xde, 0x2b, 0x32, 0x3b, 0xfb, 0xbd, 0xe9, 0x93, 0x3f, 0x9b,
	0x3e, 0xf9, 0xbb, 0xe9, 0x93, 0x1f, 0xff, 0xfa, 0x0f, 0xbe, 0xee, 0xde, 0xcb, 0xe2, 0x61, 0xf5,
	0x3e, 0x2e, 0xfe, 0x07, 0x00, 0x00, 0xff, 0xff, 0xfe, 0x83, 0xbf, 0xcc, 0x62, 0x03, 0x00, 0x00,
}

func (m *HelmManagedConfigInit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HelmManagedConfigInit) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HelmManagedConfigInit) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ManagedBy != 0 {
		i = encodeVarintHello(dAtA, i, uint64(m.ManagedBy))
		i--
		dAtA[i] = 0x28
	}
	if m.NotHelmManaged {
		i--
		if m.NotHelmManaged {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintHello(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintHello(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x12
	}
	if m.ClusterConfig != nil {
		{
			size, err := m.ClusterConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintHello(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SensorHello) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SensorHello) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorHello) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.DeploymentIdentification != nil {
		{
			size, err := m.DeploymentIdentification.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintHello(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.PolicyVersion) > 0 {
		i -= len(m.PolicyVersion)
		copy(dAtA[i:], m.PolicyVersion)
		i = encodeVarintHello(dAtA, i, uint64(len(m.PolicyVersion)))
		i--
		dAtA[i] = 0x22
	}
	if m.HelmManagedConfigInit != nil {
		{
			size, err := m.HelmManagedConfigInit.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintHello(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Capabilities) > 0 {
		for iNdEx := len(m.Capabilities) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Capabilities[iNdEx])
			copy(dAtA[i:], m.Capabilities[iNdEx])
			i = encodeVarintHello(dAtA, i, uint64(len(m.Capabilities[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.SensorVersion) > 0 {
		i -= len(m.SensorVersion)
		copy(dAtA[i:], m.SensorVersion)
		i = encodeVarintHello(dAtA, i, uint64(len(m.SensorVersion)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CentralHello) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CentralHello) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CentralHello) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.CertBundle) > 0 {
		for k := range m.CertBundle {
			v := m.CertBundle[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintHello(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintHello(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintHello(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintHello(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintHello(dAtA []byte, offset int, v uint64) int {
	offset -= sovHello(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *HelmManagedConfigInit) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ClusterConfig != nil {
		l = m.ClusterConfig.Size()
		n += 1 + l + sovHello(uint64(l))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovHello(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovHello(uint64(l))
	}
	if m.NotHelmManaged {
		n += 2
	}
	if m.ManagedBy != 0 {
		n += 1 + sovHello(uint64(m.ManagedBy))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SensorHello) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SensorVersion)
	if l > 0 {
		n += 1 + l + sovHello(uint64(l))
	}
	if len(m.Capabilities) > 0 {
		for _, s := range m.Capabilities {
			l = len(s)
			n += 1 + l + sovHello(uint64(l))
		}
	}
	if m.HelmManagedConfigInit != nil {
		l = m.HelmManagedConfigInit.Size()
		n += 1 + l + sovHello(uint64(l))
	}
	l = len(m.PolicyVersion)
	if l > 0 {
		n += 1 + l + sovHello(uint64(l))
	}
	if m.DeploymentIdentification != nil {
		l = m.DeploymentIdentification.Size()
		n += 1 + l + sovHello(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CentralHello) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovHello(uint64(l))
	}
	if len(m.CertBundle) > 0 {
		for k, v := range m.CertBundle {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovHello(uint64(len(k))) + 1 + len(v) + sovHello(uint64(len(v)))
			n += mapEntrySize + 1 + sovHello(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovHello(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozHello(x uint64) (n int) {
	return sovHello(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *HelmManagedConfigInit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHello
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HelmManagedConfigInit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HelmManagedConfigInit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHello
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHello
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHello
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ClusterConfig == nil {
				m.ClusterConfig = &storage.CompleteClusterConfig{}
			}
			if err := m.ClusterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHello
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHello
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHello
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHello
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHello
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHello
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotHelmManaged", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHello
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NotHelmManaged = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ManagedBy", wireType)
			}
			m.ManagedBy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHello
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ManagedBy |= storage.ManagerType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipHello(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthHello
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SensorHello) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHello
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SensorHello: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SensorHello: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SensorVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHello
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHello
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHello
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SensorVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Capabilities", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHello
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHello
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHello
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Capabilities = append(m.Capabilities, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HelmManagedConfigInit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHello
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHello
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHello
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HelmManagedConfigInit == nil {
				m.HelmManagedConfigInit = &HelmManagedConfigInit{}
			}
			if err := m.HelmManagedConfigInit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PolicyVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHello
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHello
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHello
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PolicyVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentIdentification", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHello
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHello
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHello
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeploymentIdentification == nil {
				m.DeploymentIdentification = &storage.SensorDeploymentIdentification{}
			}
			if err := m.DeploymentIdentification.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHello(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthHello
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CentralHello) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHello
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CentralHello: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CentralHello: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHello
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHello
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHello
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CertBundle", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHello
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHello
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHello
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CertBundle == nil {
				m.CertBundle = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowHello
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowHello
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthHello
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthHello
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowHello
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthHello
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthHello
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipHello(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthHello
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.CertBundle[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHello(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthHello
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipHello(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowHello
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowHello
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowHello
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthHello
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupHello
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthHello
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthHello        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowHello          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupHello = fmt.Errorf("proto: unexpected end of group")
)
