// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: internalapi/central/sensor_events.proto

package central

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	compliance "github.com/stackrox/rox/generated/internalapi/compliance"
	storage "github.com/stackrox/rox/generated/storage"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ResourceAction int32

const (
	ResourceAction_UNSET_ACTION_RESOURCE ResourceAction = 0
	ResourceAction_CREATE_RESOURCE       ResourceAction = 1
	ResourceAction_REMOVE_RESOURCE       ResourceAction = 2
	ResourceAction_UPDATE_RESOURCE       ResourceAction = 3
)

var ResourceAction_name = map[int32]string{
	0: "UNSET_ACTION_RESOURCE",
	1: "CREATE_RESOURCE",
	2: "REMOVE_RESOURCE",
	3: "UPDATE_RESOURCE",
}

var ResourceAction_value = map[string]int32{
	"UNSET_ACTION_RESOURCE": 0,
	"CREATE_RESOURCE":       1,
	"REMOVE_RESOURCE":       2,
	"UPDATE_RESOURCE":       3,
}

func (x ResourceAction) String() string {
	return proto.EnumName(ResourceAction_name, int32(x))
}

func (ResourceAction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{0}
}

type AlertResults_Source int32

const (
	AlertResults_DEPLOYMENT_EVENT AlertResults_Source = 0
	AlertResults_AUDIT_EVENT      AlertResults_Source = 1
)

var AlertResults_Source_name = map[int32]string{
	0: "DEPLOYMENT_EVENT",
	1: "AUDIT_EVENT",
}

var AlertResults_Source_value = map[string]int32{
	"DEPLOYMENT_EVENT": 0,
	"AUDIT_EVENT":      1,
}

func (x AlertResults_Source) String() string {
	return proto.EnumName(AlertResults_Source_name, int32(x))
}

func (AlertResults_Source) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{1, 0}
}

type ReprocessDeploymentRisk struct {
	DeploymentId         string   `protobuf:"bytes,1,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReprocessDeploymentRisk) Reset()         { *m = ReprocessDeploymentRisk{} }
func (m *ReprocessDeploymentRisk) String() string { return proto.CompactTextString(m) }
func (*ReprocessDeploymentRisk) ProtoMessage()    {}
func (*ReprocessDeploymentRisk) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{0}
}
func (m *ReprocessDeploymentRisk) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReprocessDeploymentRisk) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReprocessDeploymentRisk.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReprocessDeploymentRisk) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReprocessDeploymentRisk.Merge(m, src)
}
func (m *ReprocessDeploymentRisk) XXX_Size() int {
	return m.Size()
}
func (m *ReprocessDeploymentRisk) XXX_DiscardUnknown() {
	xxx_messageInfo_ReprocessDeploymentRisk.DiscardUnknown(m)
}

var xxx_messageInfo_ReprocessDeploymentRisk proto.InternalMessageInfo

func (m *ReprocessDeploymentRisk) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *ReprocessDeploymentRisk) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ReprocessDeploymentRisk) Clone() *ReprocessDeploymentRisk {
	if m == nil {
		return nil
	}
	cloned := new(ReprocessDeploymentRisk)
	*cloned = *m

	return cloned
}

type AlertResults struct {
	// Only relevant if source == DEPLOYMENT.
	DeploymentId         string                 `protobuf:"bytes,1,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	Alerts               []*storage.Alert       `protobuf:"bytes,2,rep,name=alerts,proto3" json:"alerts,omitempty"`
	Stage                storage.LifecycleStage `protobuf:"varint,3,opt,name=stage,proto3,enum=storage.LifecycleStage" json:"stage,omitempty"`
	Source               AlertResults_Source    `protobuf:"varint,4,opt,name=source,proto3,enum=central.AlertResults_Source" json:"source,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *AlertResults) Reset()         { *m = AlertResults{} }
func (m *AlertResults) String() string { return proto.CompactTextString(m) }
func (*AlertResults) ProtoMessage()    {}
func (*AlertResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{1}
}
func (m *AlertResults) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AlertResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AlertResults.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AlertResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AlertResults.Merge(m, src)
}
func (m *AlertResults) XXX_Size() int {
	return m.Size()
}
func (m *AlertResults) XXX_DiscardUnknown() {
	xxx_messageInfo_AlertResults.DiscardUnknown(m)
}

var xxx_messageInfo_AlertResults proto.InternalMessageInfo

func (m *AlertResults) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *AlertResults) GetAlerts() []*storage.Alert {
	if m != nil {
		return m.Alerts
	}
	return nil
}

func (m *AlertResults) GetStage() storage.LifecycleStage {
	if m != nil {
		return m.Stage
	}
	return storage.LifecycleStage_DEPLOY
}

func (m *AlertResults) GetSource() AlertResults_Source {
	if m != nil {
		return m.Source
	}
	return AlertResults_DEPLOYMENT_EVENT
}

func (m *AlertResults) MessageClone() proto.Message {
	return m.Clone()
}
func (m *AlertResults) Clone() *AlertResults {
	if m == nil {
		return nil
	}
	cloned := new(AlertResults)
	*cloned = *m

	if m.Alerts != nil {
		cloned.Alerts = make([]*storage.Alert, len(m.Alerts))
		for idx, v := range m.Alerts {
			cloned.Alerts[idx] = v.Clone()
		}
	}
	return cloned
}

type Timing struct {
	Dispatcher           string   `protobuf:"bytes,1,opt,name=dispatcher,proto3" json:"dispatcher,omitempty"`
	Resource             string   `protobuf:"bytes,2,opt,name=resource,proto3" json:"resource,omitempty"`
	Nanos                int64    `protobuf:"varint,3,opt,name=nanos,proto3" json:"nanos,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Timing) Reset()         { *m = Timing{} }
func (m *Timing) String() string { return proto.CompactTextString(m) }
func (*Timing) ProtoMessage()    {}
func (*Timing) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{2}
}
func (m *Timing) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Timing) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Timing.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Timing) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Timing.Merge(m, src)
}
func (m *Timing) XXX_Size() int {
	return m.Size()
}
func (m *Timing) XXX_DiscardUnknown() {
	xxx_messageInfo_Timing.DiscardUnknown(m)
}

var xxx_messageInfo_Timing proto.InternalMessageInfo

func (m *Timing) GetDispatcher() string {
	if m != nil {
		return m.Dispatcher
	}
	return ""
}

func (m *Timing) GetResource() string {
	if m != nil {
		return m.Resource
	}
	return ""
}

func (m *Timing) GetNanos() int64 {
	if m != nil {
		return m.Nanos
	}
	return 0
}

func (m *Timing) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Timing) Clone() *Timing {
	if m == nil {
		return nil
	}
	cloned := new(Timing)
	*cloned = *m

	return cloned
}

// Next tag: 24.
type SensorEvent struct {
	// These fields may be duplicated in the individual events, but avoid the need to branch all the time
	Id     string         `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Action ResourceAction `protobuf:"varint,2,opt,name=action,proto3,enum=central.ResourceAction" json:"action,omitempty"`
	Timing *Timing        `protobuf:"bytes,3,opt,name=timing,proto3" json:"timing,omitempty"`
	// Types that are valid to be assigned to Resource:
	//	*SensorEvent_NetworkPolicy
	//	*SensorEvent_Deployment
	//	*SensorEvent_Pod
	//	*SensorEvent_Namespace
	//	*SensorEvent_Secret
	//	*SensorEvent_Node
	//	*SensorEvent_ServiceAccount
	//	*SensorEvent_Role
	//	*SensorEvent_Binding
	//	*SensorEvent_ProcessIndicator
	//	*SensorEvent_ProviderMetadata
	//	*SensorEvent_Synced
	//	*SensorEvent_OrchestratorMetadata
	//	*SensorEvent_ImageIntegration
	//	*SensorEvent_ReprocessDeployment
	//	*SensorEvent_AlertResults
	//	*SensorEvent_ComplianceOperatorResult
	//	*SensorEvent_ComplianceOperatorProfile
	//	*SensorEvent_ComplianceOperatorRule
	//	*SensorEvent_ComplianceOperatorScanSettingBinding
	//	*SensorEvent_ComplianceOperatorScan
	Resource             isSensorEvent_Resource `protobuf_oneof:"resource"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *SensorEvent) Reset()         { *m = SensorEvent{} }
func (m *SensorEvent) String() string { return proto.CompactTextString(m) }
func (*SensorEvent) ProtoMessage()    {}
func (*SensorEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{3}
}
func (m *SensorEvent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SensorEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SensorEvent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SensorEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SensorEvent.Merge(m, src)
}
func (m *SensorEvent) XXX_Size() int {
	return m.Size()
}
func (m *SensorEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_SensorEvent.DiscardUnknown(m)
}

var xxx_messageInfo_SensorEvent proto.InternalMessageInfo

type isSensorEvent_Resource interface {
	isSensorEvent_Resource()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isSensorEvent_Resource
}

type SensorEvent_NetworkPolicy struct {
	NetworkPolicy *storage.NetworkPolicy `protobuf:"bytes,4,opt,name=network_policy,json=networkPolicy,proto3,oneof" json:"network_policy,omitempty"`
}
type SensorEvent_Deployment struct {
	Deployment *storage.Deployment `protobuf:"bytes,5,opt,name=deployment,proto3,oneof" json:"deployment,omitempty"`
}
type SensorEvent_Pod struct {
	Pod *storage.Pod `protobuf:"bytes,19,opt,name=pod,proto3,oneof" json:"pod,omitempty"`
}
type SensorEvent_Namespace struct {
	Namespace *storage.NamespaceMetadata `protobuf:"bytes,6,opt,name=namespace,proto3,oneof" json:"namespace,omitempty"`
}
type SensorEvent_Secret struct {
	Secret *storage.Secret `protobuf:"bytes,7,opt,name=secret,proto3,oneof" json:"secret,omitempty"`
}
type SensorEvent_Node struct {
	Node *storage.Node `protobuf:"bytes,9,opt,name=node,proto3,oneof" json:"node,omitempty"`
}
type SensorEvent_ServiceAccount struct {
	ServiceAccount *storage.ServiceAccount `protobuf:"bytes,14,opt,name=service_account,json=serviceAccount,proto3,oneof" json:"service_account,omitempty"`
}
type SensorEvent_Role struct {
	Role *storage.K8SRole `protobuf:"bytes,15,opt,name=role,proto3,oneof" json:"role,omitempty"`
}
type SensorEvent_Binding struct {
	Binding *storage.K8SRoleBinding `protobuf:"bytes,16,opt,name=binding,proto3,oneof" json:"binding,omitempty"`
}
type SensorEvent_ProcessIndicator struct {
	ProcessIndicator *storage.ProcessIndicator `protobuf:"bytes,8,opt,name=process_indicator,json=processIndicator,proto3,oneof" json:"process_indicator,omitempty"`
}
type SensorEvent_ProviderMetadata struct {
	ProviderMetadata *storage.ProviderMetadata `protobuf:"bytes,10,opt,name=provider_metadata,json=providerMetadata,proto3,oneof" json:"provider_metadata,omitempty"`
}
type SensorEvent_Synced struct {
	Synced *SensorEvent_ResourcesSynced `protobuf:"bytes,11,opt,name=synced,proto3,oneof" json:"synced,omitempty"`
}
type SensorEvent_OrchestratorMetadata struct {
	OrchestratorMetadata *storage.OrchestratorMetadata `protobuf:"bytes,12,opt,name=orchestrator_metadata,json=orchestratorMetadata,proto3,oneof" json:"orchestrator_metadata,omitempty"`
}
type SensorEvent_ImageIntegration struct {
	ImageIntegration *storage.ImageIntegration `protobuf:"bytes,13,opt,name=image_integration,json=imageIntegration,proto3,oneof" json:"image_integration,omitempty"`
}
type SensorEvent_ReprocessDeployment struct {
	ReprocessDeployment *ReprocessDeploymentRisk `protobuf:"bytes,17,opt,name=reprocess_deployment,json=reprocessDeployment,proto3,oneof" json:"reprocess_deployment,omitempty"`
}
type SensorEvent_AlertResults struct {
	AlertResults *AlertResults `protobuf:"bytes,18,opt,name=alert_results,json=alertResults,proto3,oneof" json:"alert_results,omitempty"`
}
type SensorEvent_ComplianceOperatorResult struct {
	ComplianceOperatorResult *storage.ComplianceOperatorCheckResult `protobuf:"bytes,20,opt,name=compliance_operator_result,json=complianceOperatorResult,proto3,oneof" json:"compliance_operator_result,omitempty"`
}
type SensorEvent_ComplianceOperatorProfile struct {
	ComplianceOperatorProfile *storage.ComplianceOperatorProfile `protobuf:"bytes,21,opt,name=compliance_operator_profile,json=complianceOperatorProfile,proto3,oneof" json:"compliance_operator_profile,omitempty"`
}
type SensorEvent_ComplianceOperatorRule struct {
	ComplianceOperatorRule *storage.ComplianceOperatorRule `protobuf:"bytes,22,opt,name=compliance_operator_rule,json=complianceOperatorRule,proto3,oneof" json:"compliance_operator_rule,omitempty"`
}
type SensorEvent_ComplianceOperatorScanSettingBinding struct {
	ComplianceOperatorScanSettingBinding *storage.ComplianceOperatorScanSettingBinding `protobuf:"bytes,23,opt,name=compliance_operator_scan_setting_binding,json=complianceOperatorScanSettingBinding,proto3,oneof" json:"compliance_operator_scan_setting_binding,omitempty"`
}
type SensorEvent_ComplianceOperatorScan struct {
	ComplianceOperatorScan *storage.ComplianceOperatorScan `protobuf:"bytes,24,opt,name=compliance_operator_scan,json=complianceOperatorScan,proto3,oneof" json:"compliance_operator_scan,omitempty"`
}

func (*SensorEvent_NetworkPolicy) isSensorEvent_Resource() {}
func (m *SensorEvent_NetworkPolicy) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_NetworkPolicy)
	*cloned = *m

	cloned.NetworkPolicy = m.NetworkPolicy.Clone()
	return cloned
}
func (*SensorEvent_Deployment) isSensorEvent_Resource() {}
func (m *SensorEvent_Deployment) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_Deployment)
	*cloned = *m

	cloned.Deployment = m.Deployment.Clone()
	return cloned
}
func (*SensorEvent_Pod) isSensorEvent_Resource() {}
func (m *SensorEvent_Pod) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_Pod)
	*cloned = *m

	cloned.Pod = m.Pod.Clone()
	return cloned
}
func (*SensorEvent_Namespace) isSensorEvent_Resource() {}
func (m *SensorEvent_Namespace) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_Namespace)
	*cloned = *m

	cloned.Namespace = m.Namespace.Clone()
	return cloned
}
func (*SensorEvent_Secret) isSensorEvent_Resource() {}
func (m *SensorEvent_Secret) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_Secret)
	*cloned = *m

	cloned.Secret = m.Secret.Clone()
	return cloned
}
func (*SensorEvent_Node) isSensorEvent_Resource() {}
func (m *SensorEvent_Node) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_Node)
	*cloned = *m

	cloned.Node = m.Node.Clone()
	return cloned
}
func (*SensorEvent_ServiceAccount) isSensorEvent_Resource() {}
func (m *SensorEvent_ServiceAccount) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_ServiceAccount)
	*cloned = *m

	cloned.ServiceAccount = m.ServiceAccount.Clone()
	return cloned
}
func (*SensorEvent_Role) isSensorEvent_Resource() {}
func (m *SensorEvent_Role) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_Role)
	*cloned = *m

	cloned.Role = m.Role.Clone()
	return cloned
}
func (*SensorEvent_Binding) isSensorEvent_Resource() {}
func (m *SensorEvent_Binding) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_Binding)
	*cloned = *m

	cloned.Binding = m.Binding.Clone()
	return cloned
}
func (*SensorEvent_ProcessIndicator) isSensorEvent_Resource() {}
func (m *SensorEvent_ProcessIndicator) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_ProcessIndicator)
	*cloned = *m

	cloned.ProcessIndicator = m.ProcessIndicator.Clone()
	return cloned
}
func (*SensorEvent_ProviderMetadata) isSensorEvent_Resource() {}
func (m *SensorEvent_ProviderMetadata) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_ProviderMetadata)
	*cloned = *m

	cloned.ProviderMetadata = m.ProviderMetadata.Clone()
	return cloned
}
func (*SensorEvent_Synced) isSensorEvent_Resource() {}
func (m *SensorEvent_Synced) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_Synced)
	*cloned = *m

	cloned.Synced = m.Synced.Clone()
	return cloned
}
func (*SensorEvent_OrchestratorMetadata) isSensorEvent_Resource() {}
func (m *SensorEvent_OrchestratorMetadata) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_OrchestratorMetadata)
	*cloned = *m

	cloned.OrchestratorMetadata = m.OrchestratorMetadata.Clone()
	return cloned
}
func (*SensorEvent_ImageIntegration) isSensorEvent_Resource() {}
func (m *SensorEvent_ImageIntegration) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_ImageIntegration)
	*cloned = *m

	cloned.ImageIntegration = m.ImageIntegration.Clone()
	return cloned
}
func (*SensorEvent_ReprocessDeployment) isSensorEvent_Resource() {}
func (m *SensorEvent_ReprocessDeployment) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_ReprocessDeployment)
	*cloned = *m

	cloned.ReprocessDeployment = m.ReprocessDeployment.Clone()
	return cloned
}
func (*SensorEvent_AlertResults) isSensorEvent_Resource() {}
func (m *SensorEvent_AlertResults) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_AlertResults)
	*cloned = *m

	cloned.AlertResults = m.AlertResults.Clone()
	return cloned
}
func (*SensorEvent_ComplianceOperatorResult) isSensorEvent_Resource() {}
func (m *SensorEvent_ComplianceOperatorResult) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_ComplianceOperatorResult)
	*cloned = *m

	cloned.ComplianceOperatorResult = m.ComplianceOperatorResult.Clone()
	return cloned
}
func (*SensorEvent_ComplianceOperatorProfile) isSensorEvent_Resource() {}
func (m *SensorEvent_ComplianceOperatorProfile) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_ComplianceOperatorProfile)
	*cloned = *m

	cloned.ComplianceOperatorProfile = m.ComplianceOperatorProfile.Clone()
	return cloned
}
func (*SensorEvent_ComplianceOperatorRule) isSensorEvent_Resource() {}
func (m *SensorEvent_ComplianceOperatorRule) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_ComplianceOperatorRule)
	*cloned = *m

	cloned.ComplianceOperatorRule = m.ComplianceOperatorRule.Clone()
	return cloned
}
func (*SensorEvent_ComplianceOperatorScanSettingBinding) isSensorEvent_Resource() {}
func (m *SensorEvent_ComplianceOperatorScanSettingBinding) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_ComplianceOperatorScanSettingBinding)
	*cloned = *m

	cloned.ComplianceOperatorScanSettingBinding = m.ComplianceOperatorScanSettingBinding.Clone()
	return cloned
}
func (*SensorEvent_ComplianceOperatorScan) isSensorEvent_Resource() {}
func (m *SensorEvent_ComplianceOperatorScan) Clone() isSensorEvent_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_ComplianceOperatorScan)
	*cloned = *m

	cloned.ComplianceOperatorScan = m.ComplianceOperatorScan.Clone()
	return cloned
}

func (m *SensorEvent) GetResource() isSensorEvent_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *SensorEvent) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SensorEvent) GetAction() ResourceAction {
	if m != nil {
		return m.Action
	}
	return ResourceAction_UNSET_ACTION_RESOURCE
}

func (m *SensorEvent) GetTiming() *Timing {
	if m != nil {
		return m.Timing
	}
	return nil
}

func (m *SensorEvent) GetNetworkPolicy() *storage.NetworkPolicy {
	if x, ok := m.GetResource().(*SensorEvent_NetworkPolicy); ok {
		return x.NetworkPolicy
	}
	return nil
}

func (m *SensorEvent) GetDeployment() *storage.Deployment {
	if x, ok := m.GetResource().(*SensorEvent_Deployment); ok {
		return x.Deployment
	}
	return nil
}

func (m *SensorEvent) GetPod() *storage.Pod {
	if x, ok := m.GetResource().(*SensorEvent_Pod); ok {
		return x.Pod
	}
	return nil
}

func (m *SensorEvent) GetNamespace() *storage.NamespaceMetadata {
	if x, ok := m.GetResource().(*SensorEvent_Namespace); ok {
		return x.Namespace
	}
	return nil
}

func (m *SensorEvent) GetSecret() *storage.Secret {
	if x, ok := m.GetResource().(*SensorEvent_Secret); ok {
		return x.Secret
	}
	return nil
}

func (m *SensorEvent) GetNode() *storage.Node {
	if x, ok := m.GetResource().(*SensorEvent_Node); ok {
		return x.Node
	}
	return nil
}

func (m *SensorEvent) GetServiceAccount() *storage.ServiceAccount {
	if x, ok := m.GetResource().(*SensorEvent_ServiceAccount); ok {
		return x.ServiceAccount
	}
	return nil
}

func (m *SensorEvent) GetRole() *storage.K8SRole {
	if x, ok := m.GetResource().(*SensorEvent_Role); ok {
		return x.Role
	}
	return nil
}

func (m *SensorEvent) GetBinding() *storage.K8SRoleBinding {
	if x, ok := m.GetResource().(*SensorEvent_Binding); ok {
		return x.Binding
	}
	return nil
}

func (m *SensorEvent) GetProcessIndicator() *storage.ProcessIndicator {
	if x, ok := m.GetResource().(*SensorEvent_ProcessIndicator); ok {
		return x.ProcessIndicator
	}
	return nil
}

func (m *SensorEvent) GetProviderMetadata() *storage.ProviderMetadata {
	if x, ok := m.GetResource().(*SensorEvent_ProviderMetadata); ok {
		return x.ProviderMetadata
	}
	return nil
}

func (m *SensorEvent) GetSynced() *SensorEvent_ResourcesSynced {
	if x, ok := m.GetResource().(*SensorEvent_Synced); ok {
		return x.Synced
	}
	return nil
}

func (m *SensorEvent) GetOrchestratorMetadata() *storage.OrchestratorMetadata {
	if x, ok := m.GetResource().(*SensorEvent_OrchestratorMetadata); ok {
		return x.OrchestratorMetadata
	}
	return nil
}

func (m *SensorEvent) GetImageIntegration() *storage.ImageIntegration {
	if x, ok := m.GetResource().(*SensorEvent_ImageIntegration); ok {
		return x.ImageIntegration
	}
	return nil
}

func (m *SensorEvent) GetReprocessDeployment() *ReprocessDeploymentRisk {
	if x, ok := m.GetResource().(*SensorEvent_ReprocessDeployment); ok {
		return x.ReprocessDeployment
	}
	return nil
}

func (m *SensorEvent) GetAlertResults() *AlertResults {
	if x, ok := m.GetResource().(*SensorEvent_AlertResults); ok {
		return x.AlertResults
	}
	return nil
}

func (m *SensorEvent) GetComplianceOperatorResult() *storage.ComplianceOperatorCheckResult {
	if x, ok := m.GetResource().(*SensorEvent_ComplianceOperatorResult); ok {
		return x.ComplianceOperatorResult
	}
	return nil
}

func (m *SensorEvent) GetComplianceOperatorProfile() *storage.ComplianceOperatorProfile {
	if x, ok := m.GetResource().(*SensorEvent_ComplianceOperatorProfile); ok {
		return x.ComplianceOperatorProfile
	}
	return nil
}

func (m *SensorEvent) GetComplianceOperatorRule() *storage.ComplianceOperatorRule {
	if x, ok := m.GetResource().(*SensorEvent_ComplianceOperatorRule); ok {
		return x.ComplianceOperatorRule
	}
	return nil
}

func (m *SensorEvent) GetComplianceOperatorScanSettingBinding() *storage.ComplianceOperatorScanSettingBinding {
	if x, ok := m.GetResource().(*SensorEvent_ComplianceOperatorScanSettingBinding); ok {
		return x.ComplianceOperatorScanSettingBinding
	}
	return nil
}

func (m *SensorEvent) GetComplianceOperatorScan() *storage.ComplianceOperatorScan {
	if x, ok := m.GetResource().(*SensorEvent_ComplianceOperatorScan); ok {
		return x.ComplianceOperatorScan
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SensorEvent) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SensorEvent_NetworkPolicy)(nil),
		(*SensorEvent_Deployment)(nil),
		(*SensorEvent_Pod)(nil),
		(*SensorEvent_Namespace)(nil),
		(*SensorEvent_Secret)(nil),
		(*SensorEvent_Node)(nil),
		(*SensorEvent_ServiceAccount)(nil),
		(*SensorEvent_Role)(nil),
		(*SensorEvent_Binding)(nil),
		(*SensorEvent_ProcessIndicator)(nil),
		(*SensorEvent_ProviderMetadata)(nil),
		(*SensorEvent_Synced)(nil),
		(*SensorEvent_OrchestratorMetadata)(nil),
		(*SensorEvent_ImageIntegration)(nil),
		(*SensorEvent_ReprocessDeployment)(nil),
		(*SensorEvent_AlertResults)(nil),
		(*SensorEvent_ComplianceOperatorResult)(nil),
		(*SensorEvent_ComplianceOperatorProfile)(nil),
		(*SensorEvent_ComplianceOperatorRule)(nil),
		(*SensorEvent_ComplianceOperatorScanSettingBinding)(nil),
		(*SensorEvent_ComplianceOperatorScan)(nil),
	}
}

func (m *SensorEvent) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SensorEvent) Clone() *SensorEvent {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent)
	*cloned = *m

	cloned.Timing = m.Timing.Clone()
	if m.Resource != nil {
		cloned.Resource = m.Resource.Clone()
	}
	return cloned
}

type SensorEvent_ResourcesSynced struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SensorEvent_ResourcesSynced) Reset()         { *m = SensorEvent_ResourcesSynced{} }
func (m *SensorEvent_ResourcesSynced) String() string { return proto.CompactTextString(m) }
func (*SensorEvent_ResourcesSynced) ProtoMessage()    {}
func (*SensorEvent_ResourcesSynced) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{3, 0}
}
func (m *SensorEvent_ResourcesSynced) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SensorEvent_ResourcesSynced) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SensorEvent_ResourcesSynced.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SensorEvent_ResourcesSynced) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SensorEvent_ResourcesSynced.Merge(m, src)
}
func (m *SensorEvent_ResourcesSynced) XXX_Size() int {
	return m.Size()
}
func (m *SensorEvent_ResourcesSynced) XXX_DiscardUnknown() {
	xxx_messageInfo_SensorEvent_ResourcesSynced.DiscardUnknown(m)
}

var xxx_messageInfo_SensorEvent_ResourcesSynced proto.InternalMessageInfo

func (m *SensorEvent_ResourcesSynced) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SensorEvent_ResourcesSynced) Clone() *SensorEvent_ResourcesSynced {
	if m == nil {
		return nil
	}
	cloned := new(SensorEvent_ResourcesSynced)
	*cloned = *m

	return cloned
}

type SensorEnforcement struct {
	Enforcement storage.EnforcementAction `protobuf:"varint,1,opt,name=enforcement,proto3,enum=storage.EnforcementAction" json:"enforcement,omitempty"`
	// Types that are valid to be assigned to Resource:
	//	*SensorEnforcement_Deployment
	//	*SensorEnforcement_ContainerInstance
	Resource             isSensorEnforcement_Resource `protobuf_oneof:"resource"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *SensorEnforcement) Reset()         { *m = SensorEnforcement{} }
func (m *SensorEnforcement) String() string { return proto.CompactTextString(m) }
func (*SensorEnforcement) ProtoMessage()    {}
func (*SensorEnforcement) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{4}
}
func (m *SensorEnforcement) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SensorEnforcement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SensorEnforcement.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SensorEnforcement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SensorEnforcement.Merge(m, src)
}
func (m *SensorEnforcement) XXX_Size() int {
	return m.Size()
}
func (m *SensorEnforcement) XXX_DiscardUnknown() {
	xxx_messageInfo_SensorEnforcement.DiscardUnknown(m)
}

var xxx_messageInfo_SensorEnforcement proto.InternalMessageInfo

type isSensorEnforcement_Resource interface {
	isSensorEnforcement_Resource()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isSensorEnforcement_Resource
}

type SensorEnforcement_Deployment struct {
	Deployment *DeploymentEnforcement `protobuf:"bytes,2,opt,name=deployment,proto3,oneof" json:"deployment,omitempty"`
}
type SensorEnforcement_ContainerInstance struct {
	ContainerInstance *ContainerInstanceEnforcement `protobuf:"bytes,3,opt,name=container_instance,json=containerInstance,proto3,oneof" json:"container_instance,omitempty"`
}

func (*SensorEnforcement_Deployment) isSensorEnforcement_Resource() {}
func (m *SensorEnforcement_Deployment) Clone() isSensorEnforcement_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEnforcement_Deployment)
	*cloned = *m

	cloned.Deployment = m.Deployment.Clone()
	return cloned
}
func (*SensorEnforcement_ContainerInstance) isSensorEnforcement_Resource() {}
func (m *SensorEnforcement_ContainerInstance) Clone() isSensorEnforcement_Resource {
	if m == nil {
		return nil
	}
	cloned := new(SensorEnforcement_ContainerInstance)
	*cloned = *m

	cloned.ContainerInstance = m.ContainerInstance.Clone()
	return cloned
}

func (m *SensorEnforcement) GetResource() isSensorEnforcement_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *SensorEnforcement) GetEnforcement() storage.EnforcementAction {
	if m != nil {
		return m.Enforcement
	}
	return storage.EnforcementAction_UNSET_ENFORCEMENT
}

func (m *SensorEnforcement) GetDeployment() *DeploymentEnforcement {
	if x, ok := m.GetResource().(*SensorEnforcement_Deployment); ok {
		return x.Deployment
	}
	return nil
}

func (m *SensorEnforcement) GetContainerInstance() *ContainerInstanceEnforcement {
	if x, ok := m.GetResource().(*SensorEnforcement_ContainerInstance); ok {
		return x.ContainerInstance
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SensorEnforcement) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SensorEnforcement_Deployment)(nil),
		(*SensorEnforcement_ContainerInstance)(nil),
	}
}

func (m *SensorEnforcement) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SensorEnforcement) Clone() *SensorEnforcement {
	if m == nil {
		return nil
	}
	cloned := new(SensorEnforcement)
	*cloned = *m

	if m.Resource != nil {
		cloned.Resource = m.Resource.Clone()
	}
	return cloned
}

type DeploymentEnforcement struct {
	DeploymentId         string   `protobuf:"bytes,1,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	DeploymentName       string   `protobuf:"bytes,2,opt,name=deployment_name,json=deploymentName,proto3" json:"deployment_name,omitempty"`
	DeploymentType       string   `protobuf:"bytes,3,opt,name=deployment_type,json=deploymentType,proto3" json:"deployment_type,omitempty"`
	Namespace            string   `protobuf:"bytes,4,opt,name=namespace,proto3" json:"namespace,omitempty"`
	AlertId              string   `protobuf:"bytes,5,opt,name=alert_id,json=alertId,proto3" json:"alert_id,omitempty"`
	PolicyName           string   `protobuf:"bytes,6,opt,name=policy_name,json=policyName,proto3" json:"policy_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeploymentEnforcement) Reset()         { *m = DeploymentEnforcement{} }
func (m *DeploymentEnforcement) String() string { return proto.CompactTextString(m) }
func (*DeploymentEnforcement) ProtoMessage()    {}
func (*DeploymentEnforcement) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{5}
}
func (m *DeploymentEnforcement) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentEnforcement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentEnforcement.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentEnforcement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentEnforcement.Merge(m, src)
}
func (m *DeploymentEnforcement) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentEnforcement) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentEnforcement.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentEnforcement proto.InternalMessageInfo

func (m *DeploymentEnforcement) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *DeploymentEnforcement) GetDeploymentName() string {
	if m != nil {
		return m.DeploymentName
	}
	return ""
}

func (m *DeploymentEnforcement) GetDeploymentType() string {
	if m != nil {
		return m.DeploymentType
	}
	return ""
}

func (m *DeploymentEnforcement) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *DeploymentEnforcement) GetAlertId() string {
	if m != nil {
		return m.AlertId
	}
	return ""
}

func (m *DeploymentEnforcement) GetPolicyName() string {
	if m != nil {
		return m.PolicyName
	}
	return ""
}

func (m *DeploymentEnforcement) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DeploymentEnforcement) Clone() *DeploymentEnforcement {
	if m == nil {
		return nil
	}
	cloned := new(DeploymentEnforcement)
	*cloned = *m

	return cloned
}

type ContainerInstanceEnforcement struct {
	PodId                 string                 `protobuf:"bytes,2,opt,name=pod_id,json=podId,proto3" json:"pod_id,omitempty"`
	DeploymentEnforcement *DeploymentEnforcement `protobuf:"bytes,3,opt,name=deployment_enforcement,json=deploymentEnforcement,proto3" json:"deployment_enforcement,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}               `json:"-"`
	XXX_unrecognized      []byte                 `json:"-"`
	XXX_sizecache         int32                  `json:"-"`
}

func (m *ContainerInstanceEnforcement) Reset()         { *m = ContainerInstanceEnforcement{} }
func (m *ContainerInstanceEnforcement) String() string { return proto.CompactTextString(m) }
func (*ContainerInstanceEnforcement) ProtoMessage()    {}
func (*ContainerInstanceEnforcement) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{6}
}
func (m *ContainerInstanceEnforcement) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerInstanceEnforcement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerInstanceEnforcement.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerInstanceEnforcement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerInstanceEnforcement.Merge(m, src)
}
func (m *ContainerInstanceEnforcement) XXX_Size() int {
	return m.Size()
}
func (m *ContainerInstanceEnforcement) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerInstanceEnforcement.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerInstanceEnforcement proto.InternalMessageInfo

func (m *ContainerInstanceEnforcement) GetPodId() string {
	if m != nil {
		return m.PodId
	}
	return ""
}

func (m *ContainerInstanceEnforcement) GetDeploymentEnforcement() *DeploymentEnforcement {
	if m != nil {
		return m.DeploymentEnforcement
	}
	return nil
}

func (m *ContainerInstanceEnforcement) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ContainerInstanceEnforcement) Clone() *ContainerInstanceEnforcement {
	if m == nil {
		return nil
	}
	cloned := new(ContainerInstanceEnforcement)
	*cloned = *m

	cloned.DeploymentEnforcement = m.DeploymentEnforcement.Clone()
	return cloned
}

type ScrapeCommand struct {
	ScrapeId string `protobuf:"bytes,1,opt,name=scrape_id,json=scrapeId,proto3" json:"scrape_id,omitempty"`
	// Types that are valid to be assigned to Command:
	//	*ScrapeCommand_StartScrape
	//	*ScrapeCommand_KillScrape
	Command              isScrapeCommand_Command `protobuf_oneof:"command"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ScrapeCommand) Reset()         { *m = ScrapeCommand{} }
func (m *ScrapeCommand) String() string { return proto.CompactTextString(m) }
func (*ScrapeCommand) ProtoMessage()    {}
func (*ScrapeCommand) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{7}
}
func (m *ScrapeCommand) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScrapeCommand) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScrapeCommand.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScrapeCommand) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScrapeCommand.Merge(m, src)
}
func (m *ScrapeCommand) XXX_Size() int {
	return m.Size()
}
func (m *ScrapeCommand) XXX_DiscardUnknown() {
	xxx_messageInfo_ScrapeCommand.DiscardUnknown(m)
}

var xxx_messageInfo_ScrapeCommand proto.InternalMessageInfo

type isScrapeCommand_Command interface {
	isScrapeCommand_Command()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isScrapeCommand_Command
}

type ScrapeCommand_StartScrape struct {
	StartScrape *StartScrape `protobuf:"bytes,2,opt,name=start_scrape,json=startScrape,proto3,oneof" json:"start_scrape,omitempty"`
}
type ScrapeCommand_KillScrape struct {
	KillScrape *KillScrape `protobuf:"bytes,3,opt,name=kill_scrape,json=killScrape,proto3,oneof" json:"kill_scrape,omitempty"`
}

func (*ScrapeCommand_StartScrape) isScrapeCommand_Command() {}
func (m *ScrapeCommand_StartScrape) Clone() isScrapeCommand_Command {
	if m == nil {
		return nil
	}
	cloned := new(ScrapeCommand_StartScrape)
	*cloned = *m

	cloned.StartScrape = m.StartScrape.Clone()
	return cloned
}
func (*ScrapeCommand_KillScrape) isScrapeCommand_Command() {}
func (m *ScrapeCommand_KillScrape) Clone() isScrapeCommand_Command {
	if m == nil {
		return nil
	}
	cloned := new(ScrapeCommand_KillScrape)
	*cloned = *m

	cloned.KillScrape = m.KillScrape.Clone()
	return cloned
}

func (m *ScrapeCommand) GetCommand() isScrapeCommand_Command {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *ScrapeCommand) GetScrapeId() string {
	if m != nil {
		return m.ScrapeId
	}
	return ""
}

func (m *ScrapeCommand) GetStartScrape() *StartScrape {
	if x, ok := m.GetCommand().(*ScrapeCommand_StartScrape); ok {
		return x.StartScrape
	}
	return nil
}

func (m *ScrapeCommand) GetKillScrape() *KillScrape {
	if x, ok := m.GetCommand().(*ScrapeCommand_KillScrape); ok {
		return x.KillScrape
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ScrapeCommand) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ScrapeCommand_StartScrape)(nil),
		(*ScrapeCommand_KillScrape)(nil),
	}
}

func (m *ScrapeCommand) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ScrapeCommand) Clone() *ScrapeCommand {
	if m == nil {
		return nil
	}
	cloned := new(ScrapeCommand)
	*cloned = *m

	if m.Command != nil {
		cloned.Command = m.Command.Clone()
	}
	return cloned
}

type StartScrape struct {
	// Dictates the hosts we expect results from.
	Hostnames []string `protobuf:"bytes,1,rep,name=hostnames,proto3" json:"hostnames,omitempty"`
	// Dictates which standards the compliance pods should run.
	Standards            []string `protobuf:"bytes,2,rep,name=standards,proto3" json:"standards,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartScrape) Reset()         { *m = StartScrape{} }
func (m *StartScrape) String() string { return proto.CompactTextString(m) }
func (*StartScrape) ProtoMessage()    {}
func (*StartScrape) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{8}
}
func (m *StartScrape) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StartScrape) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StartScrape.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StartScrape) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartScrape.Merge(m, src)
}
func (m *StartScrape) XXX_Size() int {
	return m.Size()
}
func (m *StartScrape) XXX_DiscardUnknown() {
	xxx_messageInfo_StartScrape.DiscardUnknown(m)
}

var xxx_messageInfo_StartScrape proto.InternalMessageInfo

func (m *StartScrape) GetHostnames() []string {
	if m != nil {
		return m.Hostnames
	}
	return nil
}

func (m *StartScrape) GetStandards() []string {
	if m != nil {
		return m.Standards
	}
	return nil
}

func (m *StartScrape) MessageClone() proto.Message {
	return m.Clone()
}
func (m *StartScrape) Clone() *StartScrape {
	if m == nil {
		return nil
	}
	cloned := new(StartScrape)
	*cloned = *m

	if m.Hostnames != nil {
		cloned.Hostnames = make([]string, len(m.Hostnames))
		copy(cloned.Hostnames, m.Hostnames)
	}
	if m.Standards != nil {
		cloned.Standards = make([]string, len(m.Standards))
		copy(cloned.Standards, m.Standards)
	}
	return cloned
}

type KillScrape struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KillScrape) Reset()         { *m = KillScrape{} }
func (m *KillScrape) String() string { return proto.CompactTextString(m) }
func (*KillScrape) ProtoMessage()    {}
func (*KillScrape) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{9}
}
func (m *KillScrape) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KillScrape) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KillScrape.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KillScrape) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KillScrape.Merge(m, src)
}
func (m *KillScrape) XXX_Size() int {
	return m.Size()
}
func (m *KillScrape) XXX_DiscardUnknown() {
	xxx_messageInfo_KillScrape.DiscardUnknown(m)
}

var xxx_messageInfo_KillScrape proto.InternalMessageInfo

func (m *KillScrape) MessageClone() proto.Message {
	return m.Clone()
}
func (m *KillScrape) Clone() *KillScrape {
	if m == nil {
		return nil
	}
	cloned := new(KillScrape)
	*cloned = *m

	return cloned
}

type ScrapeUpdate struct {
	ScrapeId string `protobuf:"bytes,1,opt,name=scrape_id,json=scrapeId,proto3" json:"scrape_id,omitempty"`
	// Types that are valid to be assigned to Update:
	//	*ScrapeUpdate_ComplianceReturn
	//	*ScrapeUpdate_ScrapeStarted
	//	*ScrapeUpdate_ScrapeKilled
	Update               isScrapeUpdate_Update `protobuf_oneof:"update"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ScrapeUpdate) Reset()         { *m = ScrapeUpdate{} }
func (m *ScrapeUpdate) String() string { return proto.CompactTextString(m) }
func (*ScrapeUpdate) ProtoMessage()    {}
func (*ScrapeUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{10}
}
func (m *ScrapeUpdate) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScrapeUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScrapeUpdate.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScrapeUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScrapeUpdate.Merge(m, src)
}
func (m *ScrapeUpdate) XXX_Size() int {
	return m.Size()
}
func (m *ScrapeUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_ScrapeUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_ScrapeUpdate proto.InternalMessageInfo

type isScrapeUpdate_Update interface {
	isScrapeUpdate_Update()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isScrapeUpdate_Update
}

type ScrapeUpdate_ComplianceReturn struct {
	ComplianceReturn *compliance.ComplianceReturn `protobuf:"bytes,2,opt,name=compliance_return,json=complianceReturn,proto3,oneof" json:"compliance_return,omitempty"`
}
type ScrapeUpdate_ScrapeStarted struct {
	ScrapeStarted *ScrapeStarted `protobuf:"bytes,3,opt,name=scrape_started,json=scrapeStarted,proto3,oneof" json:"scrape_started,omitempty"`
}
type ScrapeUpdate_ScrapeKilled struct {
	ScrapeKilled *ScrapeKilled `protobuf:"bytes,4,opt,name=scrape_killed,json=scrapeKilled,proto3,oneof" json:"scrape_killed,omitempty"`
}

func (*ScrapeUpdate_ComplianceReturn) isScrapeUpdate_Update() {}
func (m *ScrapeUpdate_ComplianceReturn) Clone() isScrapeUpdate_Update {
	if m == nil {
		return nil
	}
	cloned := new(ScrapeUpdate_ComplianceReturn)
	*cloned = *m

	cloned.ComplianceReturn = m.ComplianceReturn.Clone()
	return cloned
}
func (*ScrapeUpdate_ScrapeStarted) isScrapeUpdate_Update() {}
func (m *ScrapeUpdate_ScrapeStarted) Clone() isScrapeUpdate_Update {
	if m == nil {
		return nil
	}
	cloned := new(ScrapeUpdate_ScrapeStarted)
	*cloned = *m

	cloned.ScrapeStarted = m.ScrapeStarted.Clone()
	return cloned
}
func (*ScrapeUpdate_ScrapeKilled) isScrapeUpdate_Update() {}
func (m *ScrapeUpdate_ScrapeKilled) Clone() isScrapeUpdate_Update {
	if m == nil {
		return nil
	}
	cloned := new(ScrapeUpdate_ScrapeKilled)
	*cloned = *m

	cloned.ScrapeKilled = m.ScrapeKilled.Clone()
	return cloned
}

func (m *ScrapeUpdate) GetUpdate() isScrapeUpdate_Update {
	if m != nil {
		return m.Update
	}
	return nil
}

func (m *ScrapeUpdate) GetScrapeId() string {
	if m != nil {
		return m.ScrapeId
	}
	return ""
}

func (m *ScrapeUpdate) GetComplianceReturn() *compliance.ComplianceReturn {
	if x, ok := m.GetUpdate().(*ScrapeUpdate_ComplianceReturn); ok {
		return x.ComplianceReturn
	}
	return nil
}

func (m *ScrapeUpdate) GetScrapeStarted() *ScrapeStarted {
	if x, ok := m.GetUpdate().(*ScrapeUpdate_ScrapeStarted); ok {
		return x.ScrapeStarted
	}
	return nil
}

func (m *ScrapeUpdate) GetScrapeKilled() *ScrapeKilled {
	if x, ok := m.GetUpdate().(*ScrapeUpdate_ScrapeKilled); ok {
		return x.ScrapeKilled
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ScrapeUpdate) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ScrapeUpdate_ComplianceReturn)(nil),
		(*ScrapeUpdate_ScrapeStarted)(nil),
		(*ScrapeUpdate_ScrapeKilled)(nil),
	}
}

func (m *ScrapeUpdate) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ScrapeUpdate) Clone() *ScrapeUpdate {
	if m == nil {
		return nil
	}
	cloned := new(ScrapeUpdate)
	*cloned = *m

	if m.Update != nil {
		cloned.Update = m.Update.Clone()
	}
	return cloned
}

type ScrapeStarted struct {
	ErrorMessage         string   `protobuf:"bytes,1,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScrapeStarted) Reset()         { *m = ScrapeStarted{} }
func (m *ScrapeStarted) String() string { return proto.CompactTextString(m) }
func (*ScrapeStarted) ProtoMessage()    {}
func (*ScrapeStarted) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{11}
}
func (m *ScrapeStarted) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScrapeStarted) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScrapeStarted.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScrapeStarted) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScrapeStarted.Merge(m, src)
}
func (m *ScrapeStarted) XXX_Size() int {
	return m.Size()
}
func (m *ScrapeStarted) XXX_DiscardUnknown() {
	xxx_messageInfo_ScrapeStarted.DiscardUnknown(m)
}

var xxx_messageInfo_ScrapeStarted proto.InternalMessageInfo

func (m *ScrapeStarted) GetErrorMessage() string {
	if m != nil {
		return m.ErrorMessage
	}
	return ""
}

func (m *ScrapeStarted) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ScrapeStarted) Clone() *ScrapeStarted {
	if m == nil {
		return nil
	}
	cloned := new(ScrapeStarted)
	*cloned = *m

	return cloned
}

type ScrapeKilled struct {
	ErrorMessage         string   `protobuf:"bytes,1,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScrapeKilled) Reset()         { *m = ScrapeKilled{} }
func (m *ScrapeKilled) String() string { return proto.CompactTextString(m) }
func (*ScrapeKilled) ProtoMessage()    {}
func (*ScrapeKilled) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{12}
}
func (m *ScrapeKilled) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScrapeKilled) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScrapeKilled.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScrapeKilled) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScrapeKilled.Merge(m, src)
}
func (m *ScrapeKilled) XXX_Size() int {
	return m.Size()
}
func (m *ScrapeKilled) XXX_DiscardUnknown() {
	xxx_messageInfo_ScrapeKilled.DiscardUnknown(m)
}

var xxx_messageInfo_ScrapeKilled proto.InternalMessageInfo

func (m *ScrapeKilled) GetErrorMessage() string {
	if m != nil {
		return m.ErrorMessage
	}
	return ""
}

func (m *ScrapeKilled) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ScrapeKilled) Clone() *ScrapeKilled {
	if m == nil {
		return nil
	}
	cloned := new(ScrapeKilled)
	*cloned = *m

	return cloned
}

type NetworkPoliciesCommand struct {
	SeqId                int64                           `protobuf:"varint,1,opt,name=seq_id,json=seqId,proto3" json:"seq_id,omitempty"`
	Payload              *NetworkPoliciesCommand_Payload `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *NetworkPoliciesCommand) Reset()         { *m = NetworkPoliciesCommand{} }
func (m *NetworkPoliciesCommand) String() string { return proto.CompactTextString(m) }
func (*NetworkPoliciesCommand) ProtoMessage()    {}
func (*NetworkPoliciesCommand) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{13}
}
func (m *NetworkPoliciesCommand) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkPoliciesCommand) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkPoliciesCommand.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkPoliciesCommand) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPoliciesCommand.Merge(m, src)
}
func (m *NetworkPoliciesCommand) XXX_Size() int {
	return m.Size()
}
func (m *NetworkPoliciesCommand) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPoliciesCommand.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPoliciesCommand proto.InternalMessageInfo

func (m *NetworkPoliciesCommand) GetSeqId() int64 {
	if m != nil {
		return m.SeqId
	}
	return 0
}

func (m *NetworkPoliciesCommand) GetPayload() *NetworkPoliciesCommand_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *NetworkPoliciesCommand) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkPoliciesCommand) Clone() *NetworkPoliciesCommand {
	if m == nil {
		return nil
	}
	cloned := new(NetworkPoliciesCommand)
	*cloned = *m

	cloned.Payload = m.Payload.Clone()
	return cloned
}

type NetworkPoliciesCommand_Apply struct {
	ApplyId              string                             `protobuf:"bytes,1,opt,name=apply_id,json=applyId,proto3" json:"apply_id,omitempty"`
	Modification         *storage.NetworkPolicyModification `protobuf:"bytes,2,opt,name=modification,proto3" json:"modification,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *NetworkPoliciesCommand_Apply) Reset()         { *m = NetworkPoliciesCommand_Apply{} }
func (m *NetworkPoliciesCommand_Apply) String() string { return proto.CompactTextString(m) }
func (*NetworkPoliciesCommand_Apply) ProtoMessage()    {}
func (*NetworkPoliciesCommand_Apply) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{13, 0}
}
func (m *NetworkPoliciesCommand_Apply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkPoliciesCommand_Apply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkPoliciesCommand_Apply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkPoliciesCommand_Apply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPoliciesCommand_Apply.Merge(m, src)
}
func (m *NetworkPoliciesCommand_Apply) XXX_Size() int {
	return m.Size()
}
func (m *NetworkPoliciesCommand_Apply) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPoliciesCommand_Apply.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPoliciesCommand_Apply proto.InternalMessageInfo

func (m *NetworkPoliciesCommand_Apply) GetApplyId() string {
	if m != nil {
		return m.ApplyId
	}
	return ""
}

func (m *NetworkPoliciesCommand_Apply) GetModification() *storage.NetworkPolicyModification {
	if m != nil {
		return m.Modification
	}
	return nil
}

func (m *NetworkPoliciesCommand_Apply) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkPoliciesCommand_Apply) Clone() *NetworkPoliciesCommand_Apply {
	if m == nil {
		return nil
	}
	cloned := new(NetworkPoliciesCommand_Apply)
	*cloned = *m

	cloned.Modification = m.Modification.Clone()
	return cloned
}

type NetworkPoliciesCommand_Payload struct {
	// Types that are valid to be assigned to Cmd:
	//	*NetworkPoliciesCommand_Payload_Apply
	Cmd                  isNetworkPoliciesCommand_Payload_Cmd `protobuf_oneof:"cmd"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *NetworkPoliciesCommand_Payload) Reset()         { *m = NetworkPoliciesCommand_Payload{} }
func (m *NetworkPoliciesCommand_Payload) String() string { return proto.CompactTextString(m) }
func (*NetworkPoliciesCommand_Payload) ProtoMessage()    {}
func (*NetworkPoliciesCommand_Payload) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{13, 1}
}
func (m *NetworkPoliciesCommand_Payload) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkPoliciesCommand_Payload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkPoliciesCommand_Payload.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkPoliciesCommand_Payload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPoliciesCommand_Payload.Merge(m, src)
}
func (m *NetworkPoliciesCommand_Payload) XXX_Size() int {
	return m.Size()
}
func (m *NetworkPoliciesCommand_Payload) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPoliciesCommand_Payload.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPoliciesCommand_Payload proto.InternalMessageInfo

type isNetworkPoliciesCommand_Payload_Cmd interface {
	isNetworkPoliciesCommand_Payload_Cmd()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isNetworkPoliciesCommand_Payload_Cmd
}

type NetworkPoliciesCommand_Payload_Apply struct {
	Apply *NetworkPoliciesCommand_Apply `protobuf:"bytes,1,opt,name=apply,proto3,oneof" json:"apply,omitempty"`
}

func (*NetworkPoliciesCommand_Payload_Apply) isNetworkPoliciesCommand_Payload_Cmd() {}
func (m *NetworkPoliciesCommand_Payload_Apply) Clone() isNetworkPoliciesCommand_Payload_Cmd {
	if m == nil {
		return nil
	}
	cloned := new(NetworkPoliciesCommand_Payload_Apply)
	*cloned = *m

	cloned.Apply = m.Apply.Clone()
	return cloned
}

func (m *NetworkPoliciesCommand_Payload) GetCmd() isNetworkPoliciesCommand_Payload_Cmd {
	if m != nil {
		return m.Cmd
	}
	return nil
}

func (m *NetworkPoliciesCommand_Payload) GetApply() *NetworkPoliciesCommand_Apply {
	if x, ok := m.GetCmd().(*NetworkPoliciesCommand_Payload_Apply); ok {
		return x.Apply
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*NetworkPoliciesCommand_Payload) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*NetworkPoliciesCommand_Payload_Apply)(nil),
	}
}

func (m *NetworkPoliciesCommand_Payload) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkPoliciesCommand_Payload) Clone() *NetworkPoliciesCommand_Payload {
	if m == nil {
		return nil
	}
	cloned := new(NetworkPoliciesCommand_Payload)
	*cloned = *m

	if m.Cmd != nil {
		cloned.Cmd = m.Cmd.Clone()
	}
	return cloned
}

type NetworkPoliciesResponse struct {
	SeqId                int64                            `protobuf:"varint,1,opt,name=seq_id,json=seqId,proto3" json:"seq_id,omitempty"`
	Payload              *NetworkPoliciesResponse_Payload `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *NetworkPoliciesResponse) Reset()         { *m = NetworkPoliciesResponse{} }
func (m *NetworkPoliciesResponse) String() string { return proto.CompactTextString(m) }
func (*NetworkPoliciesResponse) ProtoMessage()    {}
func (*NetworkPoliciesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{14}
}
func (m *NetworkPoliciesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkPoliciesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkPoliciesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkPoliciesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPoliciesResponse.Merge(m, src)
}
func (m *NetworkPoliciesResponse) XXX_Size() int {
	return m.Size()
}
func (m *NetworkPoliciesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPoliciesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPoliciesResponse proto.InternalMessageInfo

func (m *NetworkPoliciesResponse) GetSeqId() int64 {
	if m != nil {
		return m.SeqId
	}
	return 0
}

func (m *NetworkPoliciesResponse) GetPayload() *NetworkPoliciesResponse_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *NetworkPoliciesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkPoliciesResponse) Clone() *NetworkPoliciesResponse {
	if m == nil {
		return nil
	}
	cloned := new(NetworkPoliciesResponse)
	*cloned = *m

	cloned.Payload = m.Payload.Clone()
	return cloned
}

type NetworkPoliciesResponse_Apply struct {
	ApplyId              string                             `protobuf:"bytes,1,opt,name=apply_id,json=applyId,proto3" json:"apply_id,omitempty"`
	UndoModification     *storage.NetworkPolicyModification `protobuf:"bytes,2,opt,name=undo_modification,json=undoModification,proto3" json:"undo_modification,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *NetworkPoliciesResponse_Apply) Reset()         { *m = NetworkPoliciesResponse_Apply{} }
func (m *NetworkPoliciesResponse_Apply) String() string { return proto.CompactTextString(m) }
func (*NetworkPoliciesResponse_Apply) ProtoMessage()    {}
func (*NetworkPoliciesResponse_Apply) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{14, 0}
}
func (m *NetworkPoliciesResponse_Apply) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkPoliciesResponse_Apply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkPoliciesResponse_Apply.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkPoliciesResponse_Apply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPoliciesResponse_Apply.Merge(m, src)
}
func (m *NetworkPoliciesResponse_Apply) XXX_Size() int {
	return m.Size()
}
func (m *NetworkPoliciesResponse_Apply) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPoliciesResponse_Apply.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPoliciesResponse_Apply proto.InternalMessageInfo

func (m *NetworkPoliciesResponse_Apply) GetApplyId() string {
	if m != nil {
		return m.ApplyId
	}
	return ""
}

func (m *NetworkPoliciesResponse_Apply) GetUndoModification() *storage.NetworkPolicyModification {
	if m != nil {
		return m.UndoModification
	}
	return nil
}

func (m *NetworkPoliciesResponse_Apply) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkPoliciesResponse_Apply) Clone() *NetworkPoliciesResponse_Apply {
	if m == nil {
		return nil
	}
	cloned := new(NetworkPoliciesResponse_Apply)
	*cloned = *m

	cloned.UndoModification = m.UndoModification.Clone()
	return cloned
}

type NetworkPoliciesResponse_Error struct {
	Message              string   `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NetworkPoliciesResponse_Error) Reset()         { *m = NetworkPoliciesResponse_Error{} }
func (m *NetworkPoliciesResponse_Error) String() string { return proto.CompactTextString(m) }
func (*NetworkPoliciesResponse_Error) ProtoMessage()    {}
func (*NetworkPoliciesResponse_Error) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{14, 1}
}
func (m *NetworkPoliciesResponse_Error) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkPoliciesResponse_Error) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkPoliciesResponse_Error.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkPoliciesResponse_Error) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPoliciesResponse_Error.Merge(m, src)
}
func (m *NetworkPoliciesResponse_Error) XXX_Size() int {
	return m.Size()
}
func (m *NetworkPoliciesResponse_Error) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPoliciesResponse_Error.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPoliciesResponse_Error proto.InternalMessageInfo

func (m *NetworkPoliciesResponse_Error) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *NetworkPoliciesResponse_Error) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkPoliciesResponse_Error) Clone() *NetworkPoliciesResponse_Error {
	if m == nil {
		return nil
	}
	cloned := new(NetworkPoliciesResponse_Error)
	*cloned = *m

	return cloned
}

type NetworkPoliciesResponse_Payload struct {
	// Types that are valid to be assigned to Cmd:
	//	*NetworkPoliciesResponse_Payload_Error
	//	*NetworkPoliciesResponse_Payload_Apply
	Cmd                  isNetworkPoliciesResponse_Payload_Cmd `protobuf_oneof:"cmd"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *NetworkPoliciesResponse_Payload) Reset()         { *m = NetworkPoliciesResponse_Payload{} }
func (m *NetworkPoliciesResponse_Payload) String() string { return proto.CompactTextString(m) }
func (*NetworkPoliciesResponse_Payload) ProtoMessage()    {}
func (*NetworkPoliciesResponse_Payload) Descriptor() ([]byte, []int) {
	return fileDescriptor_6ea3082f8d4cc74c, []int{14, 2}
}
func (m *NetworkPoliciesResponse_Payload) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkPoliciesResponse_Payload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkPoliciesResponse_Payload.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkPoliciesResponse_Payload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPoliciesResponse_Payload.Merge(m, src)
}
func (m *NetworkPoliciesResponse_Payload) XXX_Size() int {
	return m.Size()
}
func (m *NetworkPoliciesResponse_Payload) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPoliciesResponse_Payload.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPoliciesResponse_Payload proto.InternalMessageInfo

type isNetworkPoliciesResponse_Payload_Cmd interface {
	isNetworkPoliciesResponse_Payload_Cmd()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isNetworkPoliciesResponse_Payload_Cmd
}

type NetworkPoliciesResponse_Payload_Error struct {
	Error *NetworkPoliciesResponse_Error `protobuf:"bytes,1,opt,name=error,proto3,oneof" json:"error,omitempty"`
}
type NetworkPoliciesResponse_Payload_Apply struct {
	Apply *NetworkPoliciesResponse_Apply `protobuf:"bytes,2,opt,name=apply,proto3,oneof" json:"apply,omitempty"`
}

func (*NetworkPoliciesResponse_Payload_Error) isNetworkPoliciesResponse_Payload_Cmd() {}
func (m *NetworkPoliciesResponse_Payload_Error) Clone() isNetworkPoliciesResponse_Payload_Cmd {
	if m == nil {
		return nil
	}
	cloned := new(NetworkPoliciesResponse_Payload_Error)
	*cloned = *m

	cloned.Error = m.Error.Clone()
	return cloned
}
func (*NetworkPoliciesResponse_Payload_Apply) isNetworkPoliciesResponse_Payload_Cmd() {}
func (m *NetworkPoliciesResponse_Payload_Apply) Clone() isNetworkPoliciesResponse_Payload_Cmd {
	if m == nil {
		return nil
	}
	cloned := new(NetworkPoliciesResponse_Payload_Apply)
	*cloned = *m

	cloned.Apply = m.Apply.Clone()
	return cloned
}

func (m *NetworkPoliciesResponse_Payload) GetCmd() isNetworkPoliciesResponse_Payload_Cmd {
	if m != nil {
		return m.Cmd
	}
	return nil
}

func (m *NetworkPoliciesResponse_Payload) GetError() *NetworkPoliciesResponse_Error {
	if x, ok := m.GetCmd().(*NetworkPoliciesResponse_Payload_Error); ok {
		return x.Error
	}
	return nil
}

func (m *NetworkPoliciesResponse_Payload) GetApply() *NetworkPoliciesResponse_Apply {
	if x, ok := m.GetCmd().(*NetworkPoliciesResponse_Payload_Apply); ok {
		return x.Apply
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*NetworkPoliciesResponse_Payload) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*NetworkPoliciesResponse_Payload_Error)(nil),
		(*NetworkPoliciesResponse_Payload_Apply)(nil),
	}
}

func (m *NetworkPoliciesResponse_Payload) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkPoliciesResponse_Payload) Clone() *NetworkPoliciesResponse_Payload {
	if m == nil {
		return nil
	}
	cloned := new(NetworkPoliciesResponse_Payload)
	*cloned = *m

	if m.Cmd != nil {
		cloned.Cmd = m.Cmd.Clone()
	}
	return cloned
}

func init() {
	proto.RegisterEnum("central.ResourceAction", ResourceAction_name, ResourceAction_value)
	proto.RegisterEnum("central.AlertResults_Source", AlertResults_Source_name, AlertResults_Source_value)
	proto.RegisterType((*ReprocessDeploymentRisk)(nil), "central.ReprocessDeploymentRisk")
	proto.RegisterType((*AlertResults)(nil), "central.AlertResults")
	proto.RegisterType((*Timing)(nil), "central.Timing")
	proto.RegisterType((*SensorEvent)(nil), "central.SensorEvent")
	proto.RegisterType((*SensorEvent_ResourcesSynced)(nil), "central.SensorEvent.ResourcesSynced")
	proto.RegisterType((*SensorEnforcement)(nil), "central.SensorEnforcement")
	proto.RegisterType((*DeploymentEnforcement)(nil), "central.DeploymentEnforcement")
	proto.RegisterType((*ContainerInstanceEnforcement)(nil), "central.ContainerInstanceEnforcement")
	proto.RegisterType((*ScrapeCommand)(nil), "central.ScrapeCommand")
	proto.RegisterType((*StartScrape)(nil), "central.StartScrape")
	proto.RegisterType((*KillScrape)(nil), "central.KillScrape")
	proto.RegisterType((*ScrapeUpdate)(nil), "central.ScrapeUpdate")
	proto.RegisterType((*ScrapeStarted)(nil), "central.ScrapeStarted")
	proto.RegisterType((*ScrapeKilled)(nil), "central.ScrapeKilled")
	proto.RegisterType((*NetworkPoliciesCommand)(nil), "central.NetworkPoliciesCommand")
	proto.RegisterType((*NetworkPoliciesCommand_Apply)(nil), "central.NetworkPoliciesCommand.Apply")
	proto.RegisterType((*NetworkPoliciesCommand_Payload)(nil), "central.NetworkPoliciesCommand.Payload")
	proto.RegisterType((*NetworkPoliciesResponse)(nil), "central.NetworkPoliciesResponse")
	proto.RegisterType((*NetworkPoliciesResponse_Apply)(nil), "central.NetworkPoliciesResponse.Apply")
	proto.RegisterType((*NetworkPoliciesResponse_Error)(nil), "central.NetworkPoliciesResponse.Error")
	proto.RegisterType((*NetworkPoliciesResponse_Payload)(nil), "central.NetworkPoliciesResponse.Payload")
}

func init() {
	proto.RegisterFile("internalapi/central/sensor_events.proto", fileDescriptor_6ea3082f8d4cc74c)
}

var fileDescriptor_6ea3082f8d4cc74c = []byte{
	// 1726 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x58, 0xcd, 0x73, 0x1b, 0x49,
	0x15, 0x1f, 0x49, 0x91, 0x64, 0x3f, 0xc9, 0xb2, 0xdd, 0xb6, 0xec, 0xb1, 0xd6, 0xeb, 0x78, 0x95,
	0x25, 0x31, 0x14, 0x6b, 0x57, 0x25, 0x0b, 0x05, 0x14, 0x04, 0x6c, 0x47, 0x94, 0x54, 0x59, 0x7f,
	0x54, 0xcb, 0x4e, 0x15, 0xcb, 0x61, 0x6a, 0x32, 0xdd, 0x76, 0x66, 0x3d, 0x9a, 0x9e, 0xed, 0x1e,
	0x85, 0xd2, 0x91, 0x13, 0x17, 0x0e, 0x1c, 0xb9, 0x71, 0xe7, 0xc2, 0xbf, 0xc1, 0x91, 0x3f, 0x81,
	0x0a, 0x17, 0xae, 0x9c, 0xe0, 0x48, 0xf5, 0xc7, 0xcc, 0xb4, 0x64, 0xd9, 0x71, 0xed, 0x6d, 0xfa,
	0xf7, 0x7e, 0xef, 0xb3, 0xbb, 0xdf, 0x6b, 0x09, 0x9e, 0x85, 0x71, 0x4a, 0x79, 0xec, 0x47, 0x7e,
	0x12, 0x1e, 0x04, 0x34, 0x4e, 0xb9, 0x1f, 0x1d, 0x08, 0x1a, 0x0b, 0xc6, 0x3d, 0xfa, 0x9e, 0xc6,
	0xa9, 0xd8, 0x4f, 0x38, 0x4b, 0x19, 0xaa, 0x1b, 0x61, 0xe7, 0x87, 0x53, 0x1a, 0x6c, 0x94, 0x44,
	0xa1, 0x1f, 0x07, 0xd4, 0xfa, 0xf4, 0x88, 0x9f, 0xfa, 0x5a, 0xad, 0xb3, 0x26, 0x52, 0xc6, 0xfd,
	0x6b, 0x7a, 0xe0, 0x47, 0x94, 0xa7, 0x06, 0x6c, 0x67, 0x60, 0x10, 0x8d, 0x45, 0x4a, 0xb9, 0x81,
	0xdd, 0x0c, 0x26, 0x34, 0x89, 0xd8, 0x64, 0x44, 0xe3, 0x4c, 0x61, 0x37, 0x93, 0xc4, 0xfe, 0x88,
	0x8a, 0xc4, 0x0f, 0xa8, 0x37, 0xa2, 0xa9, 0x6f, 0xf9, 0xd9, 0xce, 0x19, 0x34, 0xfd, 0x1d, 0xe3,
	0x37, 0x5e, 0xc2, 0xa2, 0x30, 0x98, 0x18, 0x29, 0xca, 0xa5, 0x8c, 0x50, 0x83, 0xad, 0x67, 0x98,
	0xa0, 0x01, 0xa7, 0x99, 0xa7, 0x4f, 0x0b, 0x94, 0xbf, 0x0f, 0x03, 0xea, 0xf9, 0x41, 0xc0, 0xc6,
	0x79, 0x20, 0xb9, 0x21, 0xfe, 0xd6, 0x0f, 0x66, 0x0d, 0x4d, 0xb9, 0x7c, 0x9c, 0xa3, 0x9c, 0x05,
	0x54, 0x08, 0x2f, 0x8c, 0x49, 0x18, 0xf8, 0x29, 0xe3, 0xb3, 0x84, 0x70, 0xe4, 0x5f, 0x53, 0x4f,
	0x56, 0xf5, 0x9a, 0xfb, 0x69, 0xc8, 0x62, 0x43, 0xf8, 0x2c, 0xaf, 0x52, 0x51, 0x59, 0x96, 0x50,
	0x5e, 0xd8, 0xe8, 0xbe, 0x84, 0x4d, 0x4c, 0x8d, 0x83, 0x57, 0x79, 0xd1, 0x70, 0x28, 0x6e, 0xd0,
	0x13, 0x58, 0x2a, 0xca, 0xe8, 0x85, 0xc4, 0x2d, 0xed, 0x96, 0xf6, 0x16, 0x71, 0xb3, 0x00, 0x07,
	0xa4, 0xfb, 0x9f, 0x12, 0x34, 0x0f, 0xe5, 0xc6, 0x60, 0x2a, 0xc6, 0x51, 0x2a, 0x1e, 0xa4, 0x85,
	0x9e, 0x42, 0x4d, 0xed, 0xa6, 0x70, 0xcb, 0xbb, 0x95, 0xbd, 0xc6, 0xf3, 0xd6, 0xbe, 0x89, 0x74,
	0x5f, 0xdb, 0x32, 0x52, 0xf4, 0x05, 0x54, 0x45, 0xea, 0x5f, 0x53, 0xb7, 0xb2, 0x5b, 0xda, 0x6b,
	0x3d, 0xdf, 0xcc, 0x69, 0x5f, 0x85, 0x57, 0x34, 0x98, 0x04, 0x11, 0x1d, 0x4a, 0x31, 0xd6, 0x2c,
	0xf4, 0x25, 0xd4, 0x04, 0x1b, 0xf3, 0x80, 0xba, 0x8f, 0x14, 0x7f, 0x7b, 0xdf, 0x1c, 0xb9, 0x7d,
	0x3b, 0xc4, 0xfd, 0xa1, 0xe2, 0x60, 0xc3, 0xed, 0x1e, 0x40, 0x4d, 0x23, 0x68, 0x1d, 0x56, 0x5e,
	0xf5, 0xce, 0xbf, 0x3a, 0xfb, 0xcd, 0x49, 0xef, 0xf4, 0xc2, 0xeb, 0xbd, 0xe9, 0x9d, 0x5e, 0xac,
	0x38, 0x68, 0x19, 0x1a, 0x87, 0x97, 0xaf, 0x06, 0x19, 0x50, 0xea, 0x7e, 0x0d, 0xb5, 0x8b, 0x70,
	0x14, 0xc6, 0xd7, 0x68, 0x07, 0x80, 0x84, 0x22, 0xf1, 0xd3, 0xe0, 0x1d, 0xe5, 0x26, 0x53, 0x0b,
	0x41, 0x1d, 0x58, 0xe0, 0xd4, 0x84, 0x54, 0x56, 0xd2, 0x7c, 0x8d, 0xd6, 0xa1, 0x1a, 0xfb, 0x31,
	0x13, 0x2a, 0xb7, 0x0a, 0xd6, 0x8b, 0xee, 0xff, 0x9a, 0xd0, 0x18, 0xaa, 0xcb, 0xd3, 0x93, 0x77,
	0x07, 0xb5, 0xa0, 0x9c, 0xd7, 0xb0, 0x1c, 0x12, 0x74, 0x00, 0x35, 0x3f, 0x90, 0x5b, 0xac, 0xec,
	0xc9, 0x92, 0x64, 0x29, 0x62, 0x63, 0xf8, 0x50, 0x89, 0xb1, 0xa1, 0xa1, 0x67, 0x50, 0x4b, 0x55,
	0xb0, 0xca, 0x4f, 0xe3, 0xf9, 0x72, 0xae, 0xa0, 0x73, 0xc0, 0x46, 0x8c, 0x7e, 0x09, 0xad, 0xe9,
	0x93, 0xaf, 0x8a, 0xd8, 0x78, 0xbe, 0x91, 0x17, 0xfd, 0x54, 0x8b, 0xcf, 0x95, 0xb4, 0xef, 0xe0,
	0xa5, 0xd8, 0x06, 0xd0, 0x8f, 0x00, 0x8a, 0x4d, 0x76, 0xab, 0x4a, 0x79, 0x2d, 0x57, 0x2e, 0x0e,
	0x57, 0xdf, 0xc1, 0x16, 0x11, 0xed, 0x42, 0x25, 0x61, 0xc4, 0x5d, 0x53, 0xfc, 0x66, 0xce, 0x3f,
	0x67, 0xa4, 0xef, 0x60, 0x29, 0x42, 0x3f, 0x83, 0xc5, 0xfc, 0xd6, 0xba, 0x35, 0xc5, 0xeb, 0x14,
	0x41, 0x65, 0x92, 0x13, 0x73, 0x9d, 0xfb, 0x0e, 0x2e, 0xe8, 0xe8, 0xfb, 0x50, 0xd3, 0xb7, 0xd3,
	0xad, 0x9b, 0xf4, 0x33, 0xc5, 0xa1, 0x82, 0xfb, 0x0e, 0x36, 0x04, 0xf4, 0x04, 0x1e, 0xc9, 0xcb,
	0xed, 0x2e, 0x2a, 0xe2, 0x52, 0xe1, 0x81, 0x11, 0xda, 0x77, 0xb0, 0x12, 0xa2, 0x23, 0x58, 0x9e,
	0xb9, 0xd7, 0x6e, 0x4b, 0xf1, 0x37, 0x2d, 0xc3, 0x4a, 0x7e, 0xa8, 0xc5, 0x7d, 0x07, 0xb7, 0xc4,
	0x14, 0x82, 0x9e, 0xc2, 0x23, 0xce, 0x22, 0xea, 0x2e, 0x2b, 0xc5, 0x95, 0x5c, 0xf1, 0xf5, 0x4f,
	0x04, 0x66, 0x91, 0xf2, 0x25, 0xe5, 0xe8, 0x05, 0xd4, 0xdf, 0xca, 0x3b, 0x1f, 0x5f, 0xbb, 0x2b,
	0x33, 0x3e, 0x0c, 0xf5, 0x48, 0x8b, 0xfb, 0x0e, 0xce, 0x98, 0xa8, 0x0f, 0xab, 0xb7, 0xfa, 0x85,
	0xbb, 0xa0, 0xd4, 0xb7, 0x8a, 0xe2, 0x6a, 0xc6, 0x20, 0x23, 0xf4, 0x1d, 0xbc, 0x92, 0xcc, 0x60,
	0xc6, 0xd2, 0xfb, 0x90, 0x50, 0x9e, 0xf7, 0x4a, 0x17, 0x6e, 0x5b, 0x52, 0x0c, 0xab, 0xfa, 0x2b,
	0xc9, 0x0c, 0x86, 0x5e, 0x42, 0x4d, 0x4c, 0xe2, 0x80, 0x12, 0xb7, 0xa1, 0xd4, 0x3f, 0xcf, 0xcf,
	0xa0, 0x75, 0xd4, 0xf3, 0x03, 0x2c, 0x86, 0x8a, 0xab, 0x76, 0x46, 0x7d, 0xa1, 0x0b, 0x68, 0x33,
	0x1e, 0xbc, 0xa3, 0x22, 0x55, 0xad, 0xab, 0x88, 0xa6, 0xa9, 0xcc, 0x7d, 0x9a, 0x47, 0x73, 0x66,
	0xb1, 0xac, 0x88, 0xd6, 0xd9, 0x1c, 0x5c, 0xe6, 0x77, 0xab, 0x71, 0xba, 0x4b, 0x33, 0xf9, 0x0d,
	0x24, 0x63, 0x50, 0x10, 0x64, 0x7e, 0xe1, 0x0c, 0x86, 0x2e, 0x61, 0x9d, 0x67, 0x4d, 0xd4, 0xb3,
	0xee, 0xc0, 0xaa, 0x32, 0xb6, 0x6b, 0x5d, 0xd1, 0xb9, 0x9d, 0xb6, 0xef, 0xe0, 0x35, 0x7e, 0x5b,
	0x84, 0x7e, 0x0e, 0x4b, 0xaa, 0x0f, 0x7a, 0x5c, 0x37, 0x2e, 0x17, 0x29, 0x7b, 0xed, 0xb9, 0x5d,
	0xad, 0xef, 0xe0, 0xa6, 0x6f, 0x37, 0xe2, 0x2b, 0xe8, 0xcc, 0x69, 0xfb, 0xc6, 0x96, 0xbb, 0xae,
	0x4c, 0x3d, 0xcd, 0xf3, 0x3c, 0xce, 0xa9, 0x67, 0x86, 0x79, 0xfc, 0x8e, 0x06, 0x37, 0xda, 0x58,
	0xdf, 0xc1, 0x6e, 0x70, 0x8b, 0xa0, 0x65, 0x88, 0xc0, 0x27, 0xf3, 0xfc, 0x24, 0x9c, 0x5d, 0x85,
	0x11, 0x75, 0xdb, 0xca, 0x51, 0xf7, 0x1e, 0x47, 0xe7, 0x9a, 0xd9, 0x77, 0xf0, 0x56, 0x70, 0x97,
	0x10, 0xfd, 0x16, 0xdc, 0xb9, 0xd9, 0x8c, 0x23, 0xea, 0x6e, 0x28, 0x17, 0x8f, 0xef, 0x71, 0x81,
	0xc7, 0xca, 0xfe, 0x46, 0x30, 0x57, 0x82, 0xfe, 0x50, 0x82, 0xbd, 0x79, 0xd6, 0x45, 0xe0, 0xc7,
	0x9e, 0xa0, 0x69, 0x1a, 0xc6, 0xd7, 0x5e, 0x76, 0x15, 0x37, 0x95, 0xb7, 0x2f, 0xee, 0xf1, 0x36,
	0x0c, 0xfc, 0x78, 0xa8, 0xb5, 0x8a, 0x0b, 0xfa, 0x79, 0xf0, 0x00, 0xde, 0x5d, 0x69, 0xca, 0x40,
	0x5c, 0xf7, 0xa3, 0x69, 0x4a, 0x83, 0xf3, 0xd3, 0x94, 0x92, 0xce, 0x2a, 0x2c, 0xcf, 0xdc, 0xb1,
	0x23, 0x28, 0x06, 0x54, 0xf7, 0xbf, 0x25, 0x58, 0x35, 0xf7, 0x31, 0xbe, 0x62, 0x3c, 0xa0, 0xe6,
	0x10, 0x36, 0x68, 0xb1, 0x54, 0x93, 0xa8, 0x65, 0xb5, 0x5f, 0x8b, 0x6a, 0x06, 0x8f, 0x4d, 0x47,
	0xbf, 0x9a, 0x9a, 0x09, 0x65, 0x95, 0xc1, 0x4e, 0x7e, 0x7e, 0x8b, 0xb3, 0x6e, 0x99, 0x99, 0x19,
	0x0f, 0x6f, 0x00, 0x05, 0x2c, 0x4e, 0xfd, 0x30, 0xa6, 0xdc, 0x0b, 0x63, 0x91, 0xca, 0xb4, 0xcc,
	0x2c, 0xfb, 0x5e, 0x6e, 0xe9, 0x38, 0xa3, 0x0c, 0x0c, 0x63, 0xda, 0xe0, 0x6a, 0x30, 0x2b, 0x9f,
	0xca, 0xfc, 0xdf, 0x25, 0x68, 0xcf, 0x8d, 0xe5, 0x61, 0xaf, 0x99, 0x67, 0xb0, 0x6c, 0x91, 0xe4,
	0xec, 0x31, 0xc3, 0xbe, 0x55, 0xc0, 0x72, 0x4c, 0xcd, 0x10, 0xd3, 0x49, 0xa2, 0x13, 0x99, 0x22,
	0x5e, 0x4c, 0x12, 0x8a, 0xb6, 0xed, 0x89, 0xf7, 0x48, 0x51, 0xac, 0x99, 0xb6, 0x05, 0x0b, 0xba,
	0x2f, 0x84, 0x44, 0x8d, 0xd9, 0x45, 0x5c, 0x57, 0xeb, 0x01, 0x41, 0x8f, 0xa1, 0xa1, 0x87, 0xb7,
	0x0e, 0xa3, 0xa6, 0x5f, 0x24, 0x1a, 0x92, 0x21, 0x74, 0xff, 0x58, 0x82, 0xed, 0xfb, 0x8a, 0x85,
	0xda, 0x50, 0x4b, 0x18, 0x91, 0xa6, 0x75, 0x0e, 0xd5, 0x84, 0x91, 0x01, 0x41, 0x97, 0xb0, 0x61,
	0x85, 0x6e, 0x9f, 0x88, 0xca, 0x43, 0x36, 0x15, 0xb7, 0xc9, 0x3c, 0xb8, 0xfb, 0xd7, 0x12, 0x2c,
	0x0d, 0x03, 0xee, 0x27, 0xf4, 0x98, 0x8d, 0x46, 0x7e, 0x4c, 0xd0, 0x27, 0xb0, 0x28, 0x14, 0x50,
	0x54, 0x7b, 0x41, 0x03, 0x03, 0x82, 0x7e, 0x0a, 0x4d, 0x91, 0xfa, 0x3c, 0xf5, 0x34, 0x62, 0x0e,
	0xd4, 0x7a, 0x31, 0x4e, 0xa4, 0x50, 0xdb, 0xeb, 0x3b, 0xb8, 0x21, 0x8a, 0x25, 0xfa, 0x31, 0x34,
	0x6e, 0xc2, 0x28, 0xca, 0x34, 0x2b, 0xe6, 0x79, 0x92, 0x69, 0xbe, 0x0e, 0xa3, 0x28, 0x57, 0x84,
	0x9b, 0x7c, 0x75, 0xb4, 0x08, 0xf5, 0x40, 0x87, 0xd6, 0x1d, 0x40, 0xc3, 0x72, 0x20, 0x37, 0xe9,
	0x1d, 0x13, 0xa9, 0xda, 0x17, 0xb7, 0xb4, 0x5b, 0x91, 0x9b, 0x94, 0x03, 0x52, 0x2a, 0x8b, 0x4b,
	0x7c, 0x4e, 0xf4, 0x2b, 0x77, 0x11, 0x17, 0x40, 0xb7, 0x09, 0x50, 0x78, 0xec, 0xfe, 0xbe, 0x0c,
	0x4d, 0xfd, 0x79, 0x99, 0x10, 0x3f, 0xa5, 0xf7, 0x17, 0xe1, 0x35, 0xac, 0x5a, 0x3d, 0x82, 0xd3,
	0x74, 0xcc, 0x63, 0x53, 0x89, 0xed, 0xfd, 0x42, 0x62, 0xf5, 0x07, 0xac, 0x38, 0x72, 0x74, 0x05,
	0x33, 0x98, 0x7c, 0xf5, 0x19, 0x4f, 0xaa, 0x58, 0x94, 0x98, 0xca, 0x6c, 0x14, 0x35, 0x55, 0xe2,
	0xa1, 0x96, 0xca, 0x57, 0x9f, 0xb0, 0x01, 0x39, 0xa4, 0x8c, 0x01, 0x59, 0x34, 0x4a, 0xcc, 0xab,
	0xb1, 0x3d, 0xa3, 0xff, 0x5a, 0x09, 0xe5, 0x90, 0x12, 0xd6, 0xfa, 0x68, 0x01, 0x6a, 0x63, 0x95,
	0x72, 0xf7, 0xcb, 0xec, 0x20, 0x64, 0x86, 0x9f, 0xc0, 0x12, 0xe5, 0x5c, 0x4d, 0x7b, 0x21, 0xe4,
	0x6f, 0x00, 0x73, 0xf5, 0x14, 0x78, 0xa2, 0xb1, 0xee, 0x8b, 0xac, 0x70, 0xda, 0xde, 0xc3, 0x94,
	0xfe, 0x56, 0x86, 0x0d, 0xfb, 0x2d, 0x1b, 0x52, 0x91, 0x9d, 0xbe, 0xb6, 0x7c, 0x2e, 0x7e, 0x9b,
	0x55, 0xbd, 0x82, 0xab, 0x82, 0x7e, 0x3b, 0x20, 0xe8, 0x10, 0xea, 0x89, 0x3f, 0x89, 0x98, 0x4f,
	0x4c, 0xa1, 0x9f, 0xe5, 0xe9, 0xcd, 0x37, 0xb4, 0x7f, 0xae, 0xe9, 0x38, 0xd3, 0xeb, 0x7c, 0x03,
	0xd5, 0xc3, 0x24, 0x89, 0x26, 0xea, 0xf6, 0xca, 0x8f, 0x62, 0x6b, 0xeb, 0x6a, 0x3d, 0x20, 0xe8,
	0xd7, 0xd0, 0x1c, 0x31, 0x12, 0x5e, 0xc9, 0x07, 0x58, 0xf6, 0xc4, 0xb7, 0x67, 0xe7, 0xd4, 0x03,
	0xfc, 0xc4, 0x62, 0xe2, 0x29, 0xbd, 0xce, 0x19, 0xd4, 0x8d, 0x7f, 0xf4, 0x0b, 0xa8, 0x2a, 0xeb,
	0xca, 0x95, 0xdd, 0x31, 0xef, 0x88, 0x5b, 0xc5, 0xd8, 0x77, 0xb0, 0xd6, 0x3a, 0xaa, 0x42, 0x25,
	0x18, 0x91, 0xee, 0x5f, 0x2a, 0xb0, 0x39, 0xa3, 0x80, 0xa9, 0x48, 0x58, 0x2c, 0xe8, 0x5d, 0x25,
	0x3b, 0x9a, 0x2d, 0xd9, 0xde, 0x5d, 0xae, 0x33, 0x4b, 0xb7, 0x6b, 0x26, 0x1e, 0x50, 0xb3, 0x33,
	0x58, 0x1d, 0xc7, 0x84, 0x79, 0xdf, 0xb1, 0x70, 0x2b, 0x52, 0xd9, 0x46, 0x3a, 0x9f, 0x41, 0xb5,
	0x27, 0x4f, 0x0b, 0x72, 0xa1, 0x3e, 0x7d, 0x8a, 0xb2, 0x65, 0xe7, 0x4f, 0xa5, 0xa2, 0xc0, 0x2f,
	0xa1, 0xaa, 0x0e, 0x97, 0x29, 0xf0, 0xd3, 0x8f, 0x66, 0xa9, 0x8c, 0xcb, 0x0a, 0x2b, 0x35, 0xa9,
	0xaf, 0x37, 0xa8, 0xfc, 0x40, 0xfd, 0xb9, 0x3b, 0xf4, 0x83, 0x6f, 0xa0, 0x35, 0xfd, 0x03, 0x10,
	0x6d, 0x41, 0xfb, 0xf2, 0x74, 0xd8, 0xbb, 0xf0, 0x0e, 0x8f, 0x2f, 0x06, 0x67, 0xa7, 0x1e, 0xee,
	0x0d, 0xcf, 0x2e, 0xf1, 0x71, 0x6f, 0xc5, 0x41, 0x6b, 0xb0, 0x7c, 0x8c, 0x7b, 0x87, 0x17, 0xbd,
	0x02, 0x2c, 0x49, 0x10, 0xf7, 0x4e, 0xce, 0xde, 0x58, 0x60, 0x59, 0x82, 0x97, 0xe7, 0xaf, 0xa6,
	0x98, 0x95, 0xa3, 0xad, 0xbf, 0x7f, 0xd8, 0x29, 0xfd, 0xe3, 0xc3, 0x4e, 0xe9, 0x9f, 0x1f, 0x76,
	0x4a, 0x7f, 0xfe, 0xd7, 0x8e, 0xf3, 0x75, 0xf6, 0xd7, 0xce, 0xdb, 0x9a, 0xfa, 0x57, 0xe1, 0xc5,
	0xff, 0x03, 0x00, 0x00, 0xff, 0xff, 0x51, 0x7a, 0x19, 0x1c, 0x15, 0x12, 0x00, 0x00,
}

func (m *ReprocessDeploymentRisk) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReprocessDeploymentRisk) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReprocessDeploymentRisk) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AlertResults) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AlertResults) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AlertResults) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Source != 0 {
		i = encodeVarintSensorEvents(dAtA, i, uint64(m.Source))
		i--
		dAtA[i] = 0x20
	}
	if m.Stage != 0 {
		i = encodeVarintSensorEvents(dAtA, i, uint64(m.Stage))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Alerts) > 0 {
		for iNdEx := len(m.Alerts) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Alerts[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSensorEvents(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Timing) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Timing) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Timing) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Nanos != 0 {
		i = encodeVarintSensorEvents(dAtA, i, uint64(m.Nanos))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Resource) > 0 {
		i -= len(m.Resource)
		copy(dAtA[i:], m.Resource)
		i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.Resource)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Dispatcher) > 0 {
		i -= len(m.Dispatcher)
		copy(dAtA[i:], m.Dispatcher)
		i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.Dispatcher)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SensorEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SensorEvent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Resource != nil {
		{
			size := m.Resource.Size()
			i -= size
			if _, err := m.Resource.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Timing != nil {
		{
			size, err := m.Timing.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Action != 0 {
		i = encodeVarintSensorEvents(dAtA, i, uint64(m.Action))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SensorEvent_NetworkPolicy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_NetworkPolicy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.NetworkPolicy != nil {
		{
			size, err := m.NetworkPolicy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_Deployment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_Deployment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Deployment != nil {
		{
			size, err := m.Deployment.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_Namespace) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_Namespace) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Namespace != nil {
		{
			size, err := m.Namespace.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_Secret) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_Secret) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Secret != nil {
		{
			size, err := m.Secret.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_ProcessIndicator) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_ProcessIndicator) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ProcessIndicator != nil {
		{
			size, err := m.ProcessIndicator.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_Node) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_Node) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Node != nil {
		{
			size, err := m.Node.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_ProviderMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_ProviderMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ProviderMetadata != nil {
		{
			size, err := m.ProviderMetadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_Synced) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_Synced) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Synced != nil {
		{
			size, err := m.Synced.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_OrchestratorMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_OrchestratorMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.OrchestratorMetadata != nil {
		{
			size, err := m.OrchestratorMetadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_ImageIntegration) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_ImageIntegration) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ImageIntegration != nil {
		{
			size, err := m.ImageIntegration.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_ServiceAccount) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_ServiceAccount) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ServiceAccount != nil {
		{
			size, err := m.ServiceAccount.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x72
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_Role) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_Role) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Role != nil {
		{
			size, err := m.Role.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x7a
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_Binding) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_Binding) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Binding != nil {
		{
			size, err := m.Binding.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_ReprocessDeployment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_ReprocessDeployment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ReprocessDeployment != nil {
		{
			size, err := m.ReprocessDeployment.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_AlertResults) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_AlertResults) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.AlertResults != nil {
		{
			size, err := m.AlertResults.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_Pod) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_Pod) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Pod != nil {
		{
			size, err := m.Pod.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x9a
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_ComplianceOperatorResult) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_ComplianceOperatorResult) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ComplianceOperatorResult != nil {
		{
			size, err := m.ComplianceOperatorResult.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_ComplianceOperatorProfile) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_ComplianceOperatorProfile) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ComplianceOperatorProfile != nil {
		{
			size, err := m.ComplianceOperatorProfile.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_ComplianceOperatorRule) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_ComplianceOperatorRule) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ComplianceOperatorRule != nil {
		{
			size, err := m.ComplianceOperatorRule.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb2
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_ComplianceOperatorScanSettingBinding) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_ComplianceOperatorScanSettingBinding) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ComplianceOperatorScanSettingBinding != nil {
		{
			size, err := m.ComplianceOperatorScanSettingBinding.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xba
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_ComplianceOperatorScan) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_ComplianceOperatorScan) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ComplianceOperatorScan != nil {
		{
			size, err := m.ComplianceOperatorScan.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc2
	}
	return len(dAtA) - i, nil
}
func (m *SensorEvent_ResourcesSynced) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SensorEvent_ResourcesSynced) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEvent_ResourcesSynced) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *SensorEnforcement) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SensorEnforcement) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEnforcement) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Resource != nil {
		{
			size := m.Resource.Size()
			i -= size
			if _, err := m.Resource.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Enforcement != 0 {
		i = encodeVarintSensorEvents(dAtA, i, uint64(m.Enforcement))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SensorEnforcement_Deployment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEnforcement_Deployment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Deployment != nil {
		{
			size, err := m.Deployment.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *SensorEnforcement_ContainerInstance) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorEnforcement_ContainerInstance) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ContainerInstance != nil {
		{
			size, err := m.ContainerInstance.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *DeploymentEnforcement) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentEnforcement) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentEnforcement) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PolicyName) > 0 {
		i -= len(m.PolicyName)
		copy(dAtA[i:], m.PolicyName)
		i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.PolicyName)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.AlertId) > 0 {
		i -= len(m.AlertId)
		copy(dAtA[i:], m.AlertId)
		i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.AlertId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.DeploymentType) > 0 {
		i -= len(m.DeploymentType)
		copy(dAtA[i:], m.DeploymentType)
		i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.DeploymentType)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.DeploymentName) > 0 {
		i -= len(m.DeploymentName)
		copy(dAtA[i:], m.DeploymentName)
		i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.DeploymentName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContainerInstanceEnforcement) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerInstanceEnforcement) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerInstanceEnforcement) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.DeploymentEnforcement != nil {
		{
			size, err := m.DeploymentEnforcement.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.PodId) > 0 {
		i -= len(m.PodId)
		copy(dAtA[i:], m.PodId)
		i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.PodId)))
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}

func (m *ScrapeCommand) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScrapeCommand) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScrapeCommand) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Command != nil {
		{
			size := m.Command.Size()
			i -= size
			if _, err := m.Command.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.ScrapeId) > 0 {
		i -= len(m.ScrapeId)
		copy(dAtA[i:], m.ScrapeId)
		i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.ScrapeId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ScrapeCommand_StartScrape) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScrapeCommand_StartScrape) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.StartScrape != nil {
		{
			size, err := m.StartScrape.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *ScrapeCommand_KillScrape) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScrapeCommand_KillScrape) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.KillScrape != nil {
		{
			size, err := m.KillScrape.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *StartScrape) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StartScrape) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StartScrape) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Standards) > 0 {
		for iNdEx := len(m.Standards) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Standards[iNdEx])
			copy(dAtA[i:], m.Standards[iNdEx])
			i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.Standards[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Hostnames) > 0 {
		for iNdEx := len(m.Hostnames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Hostnames[iNdEx])
			copy(dAtA[i:], m.Hostnames[iNdEx])
			i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.Hostnames[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *KillScrape) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KillScrape) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KillScrape) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ScrapeUpdate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScrapeUpdate) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScrapeUpdate) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Update != nil {
		{
			size := m.Update.Size()
			i -= size
			if _, err := m.Update.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.ScrapeId) > 0 {
		i -= len(m.ScrapeId)
		copy(dAtA[i:], m.ScrapeId)
		i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.ScrapeId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ScrapeUpdate_ComplianceReturn) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScrapeUpdate_ComplianceReturn) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ComplianceReturn != nil {
		{
			size, err := m.ComplianceReturn.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *ScrapeUpdate_ScrapeStarted) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScrapeUpdate_ScrapeStarted) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ScrapeStarted != nil {
		{
			size, err := m.ScrapeStarted.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *ScrapeUpdate_ScrapeKilled) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScrapeUpdate_ScrapeKilled) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ScrapeKilled != nil {
		{
			size, err := m.ScrapeKilled.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *ScrapeStarted) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScrapeStarted) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScrapeStarted) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ErrorMessage) > 0 {
		i -= len(m.ErrorMessage)
		copy(dAtA[i:], m.ErrorMessage)
		i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.ErrorMessage)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ScrapeKilled) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScrapeKilled) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScrapeKilled) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ErrorMessage) > 0 {
		i -= len(m.ErrorMessage)
		copy(dAtA[i:], m.ErrorMessage)
		i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.ErrorMessage)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkPoliciesCommand) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkPoliciesCommand) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPoliciesCommand) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Payload != nil {
		{
			size, err := m.Payload.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.SeqId != 0 {
		i = encodeVarintSensorEvents(dAtA, i, uint64(m.SeqId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *NetworkPoliciesCommand_Apply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkPoliciesCommand_Apply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPoliciesCommand_Apply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Modification != nil {
		{
			size, err := m.Modification.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.ApplyId) > 0 {
		i -= len(m.ApplyId)
		copy(dAtA[i:], m.ApplyId)
		i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.ApplyId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkPoliciesCommand_Payload) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkPoliciesCommand_Payload) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPoliciesCommand_Payload) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Cmd != nil {
		{
			size := m.Cmd.Size()
			i -= size
			if _, err := m.Cmd.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *NetworkPoliciesCommand_Payload_Apply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPoliciesCommand_Payload_Apply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Apply != nil {
		{
			size, err := m.Apply.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *NetworkPoliciesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkPoliciesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPoliciesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Payload != nil {
		{
			size, err := m.Payload.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.SeqId != 0 {
		i = encodeVarintSensorEvents(dAtA, i, uint64(m.SeqId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *NetworkPoliciesResponse_Apply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkPoliciesResponse_Apply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPoliciesResponse_Apply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.UndoModification != nil {
		{
			size, err := m.UndoModification.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.ApplyId) > 0 {
		i -= len(m.ApplyId)
		copy(dAtA[i:], m.ApplyId)
		i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.ApplyId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkPoliciesResponse_Error) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkPoliciesResponse_Error) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPoliciesResponse_Error) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintSensorEvents(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkPoliciesResponse_Payload) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkPoliciesResponse_Payload) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPoliciesResponse_Payload) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Cmd != nil {
		{
			size := m.Cmd.Size()
			i -= size
			if _, err := m.Cmd.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *NetworkPoliciesResponse_Payload_Error) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPoliciesResponse_Payload_Error) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *NetworkPoliciesResponse_Payload_Apply) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPoliciesResponse_Payload_Apply) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Apply != nil {
		{
			size, err := m.Apply.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSensorEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func encodeVarintSensorEvents(dAtA []byte, offset int, v uint64) int {
	offset -= sovSensorEvents(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ReprocessDeploymentRisk) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AlertResults) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	if len(m.Alerts) > 0 {
		for _, e := range m.Alerts {
			l = e.Size()
			n += 1 + l + sovSensorEvents(uint64(l))
		}
	}
	if m.Stage != 0 {
		n += 1 + sovSensorEvents(uint64(m.Stage))
	}
	if m.Source != 0 {
		n += 1 + sovSensorEvents(uint64(m.Source))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Timing) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Dispatcher)
	if l > 0 {
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	l = len(m.Resource)
	if l > 0 {
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	if m.Nanos != 0 {
		n += 1 + sovSensorEvents(uint64(m.Nanos))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SensorEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	if m.Action != 0 {
		n += 1 + sovSensorEvents(uint64(m.Action))
	}
	if m.Timing != nil {
		l = m.Timing.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	if m.Resource != nil {
		n += m.Resource.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SensorEvent_NetworkPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NetworkPolicy != nil {
		l = m.NetworkPolicy.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_Deployment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Deployment != nil {
		l = m.Deployment.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_Namespace) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Namespace != nil {
		l = m.Namespace.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_Secret) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Secret != nil {
		l = m.Secret.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_ProcessIndicator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ProcessIndicator != nil {
		l = m.ProcessIndicator.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_Node) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Node != nil {
		l = m.Node.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_ProviderMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ProviderMetadata != nil {
		l = m.ProviderMetadata.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_Synced) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Synced != nil {
		l = m.Synced.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_OrchestratorMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.OrchestratorMetadata != nil {
		l = m.OrchestratorMetadata.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_ImageIntegration) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ImageIntegration != nil {
		l = m.ImageIntegration.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_ServiceAccount) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ServiceAccount != nil {
		l = m.ServiceAccount.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_Role) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Role != nil {
		l = m.Role.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_Binding) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Binding != nil {
		l = m.Binding.Size()
		n += 2 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_ReprocessDeployment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ReprocessDeployment != nil {
		l = m.ReprocessDeployment.Size()
		n += 2 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_AlertResults) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AlertResults != nil {
		l = m.AlertResults.Size()
		n += 2 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_Pod) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Pod != nil {
		l = m.Pod.Size()
		n += 2 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_ComplianceOperatorResult) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ComplianceOperatorResult != nil {
		l = m.ComplianceOperatorResult.Size()
		n += 2 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_ComplianceOperatorProfile) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ComplianceOperatorProfile != nil {
		l = m.ComplianceOperatorProfile.Size()
		n += 2 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_ComplianceOperatorRule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ComplianceOperatorRule != nil {
		l = m.ComplianceOperatorRule.Size()
		n += 2 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_ComplianceOperatorScanSettingBinding) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ComplianceOperatorScanSettingBinding != nil {
		l = m.ComplianceOperatorScanSettingBinding.Size()
		n += 2 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_ComplianceOperatorScan) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ComplianceOperatorScan != nil {
		l = m.ComplianceOperatorScan.Size()
		n += 2 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEvent_ResourcesSynced) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SensorEnforcement) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Enforcement != 0 {
		n += 1 + sovSensorEvents(uint64(m.Enforcement))
	}
	if m.Resource != nil {
		n += m.Resource.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SensorEnforcement_Deployment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Deployment != nil {
		l = m.Deployment.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *SensorEnforcement_ContainerInstance) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ContainerInstance != nil {
		l = m.ContainerInstance.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *DeploymentEnforcement) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	l = len(m.DeploymentName)
	if l > 0 {
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	l = len(m.DeploymentType)
	if l > 0 {
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	l = len(m.AlertId)
	if l > 0 {
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	l = len(m.PolicyName)
	if l > 0 {
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContainerInstanceEnforcement) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PodId)
	if l > 0 {
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	if m.DeploymentEnforcement != nil {
		l = m.DeploymentEnforcement.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScrapeCommand) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ScrapeId)
	if l > 0 {
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	if m.Command != nil {
		n += m.Command.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScrapeCommand_StartScrape) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StartScrape != nil {
		l = m.StartScrape.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *ScrapeCommand_KillScrape) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.KillScrape != nil {
		l = m.KillScrape.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *StartScrape) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Hostnames) > 0 {
		for _, s := range m.Hostnames {
			l = len(s)
			n += 1 + l + sovSensorEvents(uint64(l))
		}
	}
	if len(m.Standards) > 0 {
		for _, s := range m.Standards {
			l = len(s)
			n += 1 + l + sovSensorEvents(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *KillScrape) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScrapeUpdate) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ScrapeId)
	if l > 0 {
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	if m.Update != nil {
		n += m.Update.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScrapeUpdate_ComplianceReturn) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ComplianceReturn != nil {
		l = m.ComplianceReturn.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *ScrapeUpdate_ScrapeStarted) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ScrapeStarted != nil {
		l = m.ScrapeStarted.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *ScrapeUpdate_ScrapeKilled) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ScrapeKilled != nil {
		l = m.ScrapeKilled.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *ScrapeStarted) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ErrorMessage)
	if l > 0 {
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScrapeKilled) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ErrorMessage)
	if l > 0 {
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkPoliciesCommand) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SeqId != 0 {
		n += 1 + sovSensorEvents(uint64(m.SeqId))
	}
	if m.Payload != nil {
		l = m.Payload.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkPoliciesCommand_Apply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ApplyId)
	if l > 0 {
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	if m.Modification != nil {
		l = m.Modification.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkPoliciesCommand_Payload) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Cmd != nil {
		n += m.Cmd.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkPoliciesCommand_Payload_Apply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Apply != nil {
		l = m.Apply.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *NetworkPoliciesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SeqId != 0 {
		n += 1 + sovSensorEvents(uint64(m.SeqId))
	}
	if m.Payload != nil {
		l = m.Payload.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkPoliciesResponse_Apply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ApplyId)
	if l > 0 {
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	if m.UndoModification != nil {
		l = m.UndoModification.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkPoliciesResponse_Error) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkPoliciesResponse_Payload) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Cmd != nil {
		n += m.Cmd.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkPoliciesResponse_Payload_Error) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}
func (m *NetworkPoliciesResponse_Payload_Apply) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Apply != nil {
		l = m.Apply.Size()
		n += 1 + l + sovSensorEvents(uint64(l))
	}
	return n
}

func sovSensorEvents(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozSensorEvents(x uint64) (n int) {
	return sovSensorEvents(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ReprocessDeploymentRisk) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReprocessDeploymentRisk: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReprocessDeploymentRisk: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AlertResults) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AlertResults: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AlertResults: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Alerts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Alerts = append(m.Alerts, &storage.Alert{})
			if err := m.Alerts[len(m.Alerts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stage", wireType)
			}
			m.Stage = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Stage |= storage.LifecycleStage(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			m.Source = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Source |= AlertResults_Source(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Timing) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Timing: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Timing: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dispatcher", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Dispatcher = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resource = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nanos", wireType)
			}
			m.Nanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Nanos |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SensorEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SensorEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SensorEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			m.Action = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Action |= ResourceAction(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timing", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timing == nil {
				m.Timing = &Timing{}
			}
			if err := m.Timing.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.NetworkPolicy{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_NetworkPolicy{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.Deployment{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_Deployment{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.NamespaceMetadata{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_Namespace{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secret", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.Secret{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_Secret{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessIndicator", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.ProcessIndicator{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_ProcessIndicator{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Node", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.Node{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_Node{v}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProviderMetadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.ProviderMetadata{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_ProviderMetadata{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Synced", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SensorEvent_ResourcesSynced{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_Synced{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrchestratorMetadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.OrchestratorMetadata{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_OrchestratorMetadata{v}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ImageIntegration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.ImageIntegration{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_ImageIntegration{v}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceAccount", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.ServiceAccount{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_ServiceAccount{v}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.K8SRole{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_Role{v}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Binding", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.K8SRoleBinding{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_Binding{v}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReprocessDeployment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ReprocessDeploymentRisk{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_ReprocessDeployment{v}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlertResults", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AlertResults{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_AlertResults{v}
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pod", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.Pod{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_Pod{v}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ComplianceOperatorResult", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.ComplianceOperatorCheckResult{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_ComplianceOperatorResult{v}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ComplianceOperatorProfile", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.ComplianceOperatorProfile{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_ComplianceOperatorProfile{v}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ComplianceOperatorRule", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.ComplianceOperatorRule{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_ComplianceOperatorRule{v}
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ComplianceOperatorScanSettingBinding", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.ComplianceOperatorScanSettingBinding{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_ComplianceOperatorScanSettingBinding{v}
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ComplianceOperatorScan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.ComplianceOperatorScan{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEvent_ComplianceOperatorScan{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SensorEvent_ResourcesSynced) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourcesSynced: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourcesSynced: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SensorEnforcement) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SensorEnforcement: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SensorEnforcement: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Enforcement", wireType)
			}
			m.Enforcement = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Enforcement |= storage.EnforcementAction(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DeploymentEnforcement{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEnforcement_Deployment{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerInstance", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ContainerInstanceEnforcement{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &SensorEnforcement_ContainerInstance{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentEnforcement) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentEnforcement: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentEnforcement: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlertId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AlertId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PolicyName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PolicyName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerInstanceEnforcement) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContainerInstanceEnforcement: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContainerInstanceEnforcement: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PodId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentEnforcement", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeploymentEnforcement == nil {
				m.DeploymentEnforcement = &DeploymentEnforcement{}
			}
			if err := m.DeploymentEnforcement.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScrapeCommand) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScrapeCommand: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScrapeCommand: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScrapeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ScrapeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartScrape", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &StartScrape{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Command = &ScrapeCommand_StartScrape{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KillScrape", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &KillScrape{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Command = &ScrapeCommand_KillScrape{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StartScrape) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StartScrape: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StartScrape: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostnames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hostnames = append(m.Hostnames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Standards", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Standards = append(m.Standards, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KillScrape) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KillScrape: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KillScrape: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScrapeUpdate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScrapeUpdate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScrapeUpdate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScrapeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ScrapeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ComplianceReturn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &compliance.ComplianceReturn{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Update = &ScrapeUpdate_ComplianceReturn{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScrapeStarted", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ScrapeStarted{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Update = &ScrapeUpdate_ScrapeStarted{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScrapeKilled", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ScrapeKilled{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Update = &ScrapeUpdate_ScrapeKilled{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScrapeStarted) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScrapeStarted: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScrapeStarted: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorMessage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScrapeKilled) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScrapeKilled: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScrapeKilled: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorMessage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkPoliciesCommand) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkPoliciesCommand: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkPoliciesCommand: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeqId", wireType)
			}
			m.SeqId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SeqId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Payload", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Payload == nil {
				m.Payload = &NetworkPoliciesCommand_Payload{}
			}
			if err := m.Payload.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkPoliciesCommand_Apply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Apply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Apply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplyId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApplyId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Modification", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Modification == nil {
				m.Modification = &storage.NetworkPolicyModification{}
			}
			if err := m.Modification.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkPoliciesCommand_Payload) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Payload: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Payload: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Apply", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &NetworkPoliciesCommand_Apply{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Cmd = &NetworkPoliciesCommand_Payload_Apply{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkPoliciesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkPoliciesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkPoliciesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeqId", wireType)
			}
			m.SeqId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SeqId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Payload", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Payload == nil {
				m.Payload = &NetworkPoliciesResponse_Payload{}
			}
			if err := m.Payload.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkPoliciesResponse_Apply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Apply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Apply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplyId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApplyId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UndoModification", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UndoModification == nil {
				m.UndoModification = &storage.NetworkPolicyModification{}
			}
			if err := m.UndoModification.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkPoliciesResponse_Error) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Error: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Error: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkPoliciesResponse_Payload) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Payload: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Payload: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &NetworkPoliciesResponse_Error{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Cmd = &NetworkPoliciesResponse_Payload_Error{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Apply", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSensorEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &NetworkPoliciesResponse_Apply{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Cmd = &NetworkPoliciesResponse_Payload_Apply{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSensorEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSensorEvents(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSensorEvents
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSensorEvents
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthSensorEvents
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupSensorEvents
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthSensorEvents
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthSensorEvents        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSensorEvents          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupSensorEvents = fmt.Errorf("proto: unexpected end of group")
)
