// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: internalapi/sensor/admission_control.proto

package sensor

import (
	fmt "fmt"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	central "github.com/stackrox/rox/generated/internalapi/central"
	storage "github.com/stackrox/rox/generated/storage"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type AdmissionControlSettings struct {
	ClusterConfig              *storage.DynamicClusterConfig `protobuf:"bytes,1,opt,name=cluster_config,json=clusterConfig,proto3" json:"cluster_config,omitempty"`
	EnforcedDeployTimePolicies *storage.PolicyList           `protobuf:"bytes,2,opt,name=enforced_deploy_time_policies,json=enforcedDeployTimePolicies,proto3" json:"enforced_deploy_time_policies,omitempty"`
	Timestamp                  *types.Timestamp              `protobuf:"bytes,3,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	CacheVersion               string                        `protobuf:"bytes,4,opt,name=cache_version,json=cacheVersion,proto3" json:"cache_version,omitempty"`
	CentralEndpoint            string                        `protobuf:"bytes,5,opt,name=central_endpoint,json=centralEndpoint,proto3" json:"central_endpoint,omitempty"`
	ClusterId                  string                        `protobuf:"bytes,6,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	RuntimePolicies            *storage.PolicyList           `protobuf:"bytes,7,opt,name=runtime_policies,json=runtimePolicies,proto3" json:"runtime_policies,omitempty"`
	XXX_NoUnkeyedLiteral       struct{}                      `json:"-"`
	XXX_unrecognized           []byte                        `json:"-"`
	XXX_sizecache              int32                         `json:"-"`
}

func (m *AdmissionControlSettings) Reset()         { *m = AdmissionControlSettings{} }
func (m *AdmissionControlSettings) String() string { return proto.CompactTextString(m) }
func (*AdmissionControlSettings) ProtoMessage()    {}
func (*AdmissionControlSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_c391cfbe1d10cdc6, []int{0}
}
func (m *AdmissionControlSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdmissionControlSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AdmissionControlSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AdmissionControlSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdmissionControlSettings.Merge(m, src)
}
func (m *AdmissionControlSettings) XXX_Size() int {
	return m.Size()
}
func (m *AdmissionControlSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_AdmissionControlSettings.DiscardUnknown(m)
}

var xxx_messageInfo_AdmissionControlSettings proto.InternalMessageInfo

func (m *AdmissionControlSettings) GetClusterConfig() *storage.DynamicClusterConfig {
	if m != nil {
		return m.ClusterConfig
	}
	return nil
}

func (m *AdmissionControlSettings) GetEnforcedDeployTimePolicies() *storage.PolicyList {
	if m != nil {
		return m.EnforcedDeployTimePolicies
	}
	return nil
}

func (m *AdmissionControlSettings) GetTimestamp() *types.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *AdmissionControlSettings) GetCacheVersion() string {
	if m != nil {
		return m.CacheVersion
	}
	return ""
}

func (m *AdmissionControlSettings) GetCentralEndpoint() string {
	if m != nil {
		return m.CentralEndpoint
	}
	return ""
}

func (m *AdmissionControlSettings) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *AdmissionControlSettings) GetRuntimePolicies() *storage.PolicyList {
	if m != nil {
		return m.RuntimePolicies
	}
	return nil
}

func (m *AdmissionControlSettings) MessageClone() proto.Message {
	return m.Clone()
}
func (m *AdmissionControlSettings) Clone() *AdmissionControlSettings {
	if m == nil {
		return nil
	}
	cloned := new(AdmissionControlSettings)
	*cloned = *m

	cloned.ClusterConfig = m.ClusterConfig.Clone()
	cloned.EnforcedDeployTimePolicies = m.EnforcedDeployTimePolicies.Clone()
	cloned.Timestamp = m.Timestamp.Clone()
	cloned.RuntimePolicies = m.RuntimePolicies.Clone()
	return cloned
}

type AdmissionControlAlerts struct {
	AlertResults         []*central.AlertResults `protobuf:"bytes,1,rep,name=alert_results,json=alertResults,proto3" json:"alert_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *AdmissionControlAlerts) Reset()         { *m = AdmissionControlAlerts{} }
func (m *AdmissionControlAlerts) String() string { return proto.CompactTextString(m) }
func (*AdmissionControlAlerts) ProtoMessage()    {}
func (*AdmissionControlAlerts) Descriptor() ([]byte, []int) {
	return fileDescriptor_c391cfbe1d10cdc6, []int{1}
}
func (m *AdmissionControlAlerts) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdmissionControlAlerts) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AdmissionControlAlerts.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AdmissionControlAlerts) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdmissionControlAlerts.Merge(m, src)
}
func (m *AdmissionControlAlerts) XXX_Size() int {
	return m.Size()
}
func (m *AdmissionControlAlerts) XXX_DiscardUnknown() {
	xxx_messageInfo_AdmissionControlAlerts.DiscardUnknown(m)
}

var xxx_messageInfo_AdmissionControlAlerts proto.InternalMessageInfo

func (m *AdmissionControlAlerts) GetAlertResults() []*central.AlertResults {
	if m != nil {
		return m.AlertResults
	}
	return nil
}

func (m *AdmissionControlAlerts) MessageClone() proto.Message {
	return m.Clone()
}
func (m *AdmissionControlAlerts) Clone() *AdmissionControlAlerts {
	if m == nil {
		return nil
	}
	cloned := new(AdmissionControlAlerts)
	*cloned = *m

	if m.AlertResults != nil {
		cloned.AlertResults = make([]*central.AlertResults, len(m.AlertResults))
		for idx, v := range m.AlertResults {
			cloned.AlertResults[idx] = v.Clone()
		}
	}
	return cloned
}

type AdmCtrlUpdateResourceRequest struct {
	Action central.ResourceAction `protobuf:"varint,1,opt,name=action,proto3,enum=central.ResourceAction" json:"action,omitempty"`
	// Types that are valid to be assigned to Resource:
	//	*AdmCtrlUpdateResourceRequest_Deployment
	//	*AdmCtrlUpdateResourceRequest_Pod
	//	*AdmCtrlUpdateResourceRequest_Namespace
	//	*AdmCtrlUpdateResourceRequest_Synced
	Resource             isAdmCtrlUpdateResourceRequest_Resource `protobuf_oneof:"resource"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *AdmCtrlUpdateResourceRequest) Reset()         { *m = AdmCtrlUpdateResourceRequest{} }
func (m *AdmCtrlUpdateResourceRequest) String() string { return proto.CompactTextString(m) }
func (*AdmCtrlUpdateResourceRequest) ProtoMessage()    {}
func (*AdmCtrlUpdateResourceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c391cfbe1d10cdc6, []int{2}
}
func (m *AdmCtrlUpdateResourceRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdmCtrlUpdateResourceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AdmCtrlUpdateResourceRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AdmCtrlUpdateResourceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdmCtrlUpdateResourceRequest.Merge(m, src)
}
func (m *AdmCtrlUpdateResourceRequest) XXX_Size() int {
	return m.Size()
}
func (m *AdmCtrlUpdateResourceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AdmCtrlUpdateResourceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AdmCtrlUpdateResourceRequest proto.InternalMessageInfo

type isAdmCtrlUpdateResourceRequest_Resource interface {
	isAdmCtrlUpdateResourceRequest_Resource()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isAdmCtrlUpdateResourceRequest_Resource
}

type AdmCtrlUpdateResourceRequest_Deployment struct {
	Deployment *storage.Deployment `protobuf:"bytes,2,opt,name=deployment,proto3,oneof" json:"deployment,omitempty"`
}
type AdmCtrlUpdateResourceRequest_Pod struct {
	Pod *storage.Pod `protobuf:"bytes,3,opt,name=pod,proto3,oneof" json:"pod,omitempty"`
}
type AdmCtrlUpdateResourceRequest_Namespace struct {
	Namespace *storage.NamespaceMetadata `protobuf:"bytes,4,opt,name=namespace,proto3,oneof" json:"namespace,omitempty"`
}
type AdmCtrlUpdateResourceRequest_Synced struct {
	Synced *AdmCtrlUpdateResourceRequest_ResourcesSynced `protobuf:"bytes,5,opt,name=synced,proto3,oneof" json:"synced,omitempty"`
}

func (*AdmCtrlUpdateResourceRequest_Deployment) isAdmCtrlUpdateResourceRequest_Resource() {}
func (m *AdmCtrlUpdateResourceRequest_Deployment) Clone() isAdmCtrlUpdateResourceRequest_Resource {
	if m == nil {
		return nil
	}
	cloned := new(AdmCtrlUpdateResourceRequest_Deployment)
	*cloned = *m

	cloned.Deployment = m.Deployment.Clone()
	return cloned
}
func (*AdmCtrlUpdateResourceRequest_Pod) isAdmCtrlUpdateResourceRequest_Resource() {}
func (m *AdmCtrlUpdateResourceRequest_Pod) Clone() isAdmCtrlUpdateResourceRequest_Resource {
	if m == nil {
		return nil
	}
	cloned := new(AdmCtrlUpdateResourceRequest_Pod)
	*cloned = *m

	cloned.Pod = m.Pod.Clone()
	return cloned
}
func (*AdmCtrlUpdateResourceRequest_Namespace) isAdmCtrlUpdateResourceRequest_Resource() {}
func (m *AdmCtrlUpdateResourceRequest_Namespace) Clone() isAdmCtrlUpdateResourceRequest_Resource {
	if m == nil {
		return nil
	}
	cloned := new(AdmCtrlUpdateResourceRequest_Namespace)
	*cloned = *m

	cloned.Namespace = m.Namespace.Clone()
	return cloned
}
func (*AdmCtrlUpdateResourceRequest_Synced) isAdmCtrlUpdateResourceRequest_Resource() {}
func (m *AdmCtrlUpdateResourceRequest_Synced) Clone() isAdmCtrlUpdateResourceRequest_Resource {
	if m == nil {
		return nil
	}
	cloned := new(AdmCtrlUpdateResourceRequest_Synced)
	*cloned = *m

	cloned.Synced = m.Synced.Clone()
	return cloned
}

func (m *AdmCtrlUpdateResourceRequest) GetResource() isAdmCtrlUpdateResourceRequest_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *AdmCtrlUpdateResourceRequest) GetAction() central.ResourceAction {
	if m != nil {
		return m.Action
	}
	return central.ResourceAction_UNSET_ACTION_RESOURCE
}

func (m *AdmCtrlUpdateResourceRequest) GetDeployment() *storage.Deployment {
	if x, ok := m.GetResource().(*AdmCtrlUpdateResourceRequest_Deployment); ok {
		return x.Deployment
	}
	return nil
}

func (m *AdmCtrlUpdateResourceRequest) GetPod() *storage.Pod {
	if x, ok := m.GetResource().(*AdmCtrlUpdateResourceRequest_Pod); ok {
		return x.Pod
	}
	return nil
}

func (m *AdmCtrlUpdateResourceRequest) GetNamespace() *storage.NamespaceMetadata {
	if x, ok := m.GetResource().(*AdmCtrlUpdateResourceRequest_Namespace); ok {
		return x.Namespace
	}
	return nil
}

func (m *AdmCtrlUpdateResourceRequest) GetSynced() *AdmCtrlUpdateResourceRequest_ResourcesSynced {
	if x, ok := m.GetResource().(*AdmCtrlUpdateResourceRequest_Synced); ok {
		return x.Synced
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AdmCtrlUpdateResourceRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AdmCtrlUpdateResourceRequest_Deployment)(nil),
		(*AdmCtrlUpdateResourceRequest_Pod)(nil),
		(*AdmCtrlUpdateResourceRequest_Namespace)(nil),
		(*AdmCtrlUpdateResourceRequest_Synced)(nil),
	}
}

func (m *AdmCtrlUpdateResourceRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *AdmCtrlUpdateResourceRequest) Clone() *AdmCtrlUpdateResourceRequest {
	if m == nil {
		return nil
	}
	cloned := new(AdmCtrlUpdateResourceRequest)
	*cloned = *m

	if m.Resource != nil {
		cloned.Resource = m.Resource.Clone()
	}
	return cloned
}

type AdmCtrlUpdateResourceRequest_ResourcesSynced struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AdmCtrlUpdateResourceRequest_ResourcesSynced) Reset() {
	*m = AdmCtrlUpdateResourceRequest_ResourcesSynced{}
}
func (m *AdmCtrlUpdateResourceRequest_ResourcesSynced) String() string {
	return proto.CompactTextString(m)
}
func (*AdmCtrlUpdateResourceRequest_ResourcesSynced) ProtoMessage() {}
func (*AdmCtrlUpdateResourceRequest_ResourcesSynced) Descriptor() ([]byte, []int) {
	return fileDescriptor_c391cfbe1d10cdc6, []int{2, 0}
}
func (m *AdmCtrlUpdateResourceRequest_ResourcesSynced) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdmCtrlUpdateResourceRequest_ResourcesSynced) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AdmCtrlUpdateResourceRequest_ResourcesSynced.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AdmCtrlUpdateResourceRequest_ResourcesSynced) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdmCtrlUpdateResourceRequest_ResourcesSynced.Merge(m, src)
}
func (m *AdmCtrlUpdateResourceRequest_ResourcesSynced) XXX_Size() int {
	return m.Size()
}
func (m *AdmCtrlUpdateResourceRequest_ResourcesSynced) XXX_DiscardUnknown() {
	xxx_messageInfo_AdmCtrlUpdateResourceRequest_ResourcesSynced.DiscardUnknown(m)
}

var xxx_messageInfo_AdmCtrlUpdateResourceRequest_ResourcesSynced proto.InternalMessageInfo

func (m *AdmCtrlUpdateResourceRequest_ResourcesSynced) MessageClone() proto.Message {
	return m.Clone()
}
func (m *AdmCtrlUpdateResourceRequest_ResourcesSynced) Clone() *AdmCtrlUpdateResourceRequest_ResourcesSynced {
	if m == nil {
		return nil
	}
	cloned := new(AdmCtrlUpdateResourceRequest_ResourcesSynced)
	*cloned = *m

	return cloned
}

func init() {
	proto.RegisterType((*AdmissionControlSettings)(nil), "sensor.AdmissionControlSettings")
	proto.RegisterType((*AdmissionControlAlerts)(nil), "sensor.AdmissionControlAlerts")
	proto.RegisterType((*AdmCtrlUpdateResourceRequest)(nil), "sensor.AdmCtrlUpdateResourceRequest")
	proto.RegisterType((*AdmCtrlUpdateResourceRequest_ResourcesSynced)(nil), "sensor.AdmCtrlUpdateResourceRequest.ResourcesSynced")
}

func init() {
	proto.RegisterFile("internalapi/sensor/admission_control.proto", fileDescriptor_c391cfbe1d10cdc6)
}

var fileDescriptor_c391cfbe1d10cdc6 = []byte{
	// 592 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x94, 0xcf, 0x6e, 0x13, 0x31,
	0x10, 0xc6, 0xb3, 0x0d, 0x04, 0xe2, 0xfe, 0xc5, 0x50, 0x58, 0x45, 0x34, 0x44, 0xe5, 0x40, 0xe1,
	0xb0, 0x91, 0x02, 0x48, 0xa8, 0x07, 0xa4, 0x34, 0x41, 0x0a, 0x12, 0x54, 0x95, 0x5b, 0x7a, 0xe0,
	0xb2, 0x72, 0xed, 0x69, 0xb0, 0xb4, 0x6b, 0x2f, 0xb6, 0xb7, 0x52, 0xde, 0x84, 0x2b, 0x6f, 0xc3,
	0x11, 0x89, 0x17, 0x40, 0xe5, 0x45, 0xd0, 0x7a, 0xed, 0x6d, 0x28, 0x82, 0x5b, 0xfc, 0x7d, 0x3f,
	0x8f, 0xe6, 0x9b, 0x59, 0x07, 0x3d, 0x13, 0xd2, 0x82, 0x96, 0x34, 0xa3, 0x85, 0x18, 0x1a, 0x90,
	0x46, 0xe9, 0x21, 0xe5, 0xb9, 0x30, 0x46, 0x28, 0x99, 0x32, 0x25, 0xad, 0x56, 0x59, 0x52, 0x68,
	0x65, 0x15, 0xee, 0xd4, 0x7e, 0x6f, 0xdb, 0x58, 0xa5, 0xe9, 0x1c, 0x86, 0x2c, 0x2b, 0x8d, 0x05,
	0x5d, 0xdb, 0xbd, 0x41, 0x90, 0x25, 0xcd, 0xc1, 0x14, 0x94, 0x41, 0x9a, 0x83, 0xa5, 0x9c, 0x5a,
	0xea, 0x89, 0x38, 0x10, 0x1c, 0x8a, 0x4c, 0x2d, 0x72, 0x90, 0xd6, 0x3b, 0xf7, 0x82, 0x53, 0xa8,
	0x4c, 0xb0, 0x85, 0x57, 0x1f, 0xcd, 0x95, 0x9a, 0x67, 0x30, 0x74, 0xa7, 0xb3, 0xf2, 0x7c, 0x68,
	0x45, 0x0e, 0xc6, 0xd2, 0xbc, 0xf0, 0xc0, 0x93, 0xe5, 0xee, 0x19, 0x48, 0xab, 0x69, 0xe6, 0x53,
	0xa4, 0x70, 0x01, 0xd2, 0x9a, 0x1a, 0xdc, 0xfd, 0xda, 0x46, 0xf1, 0x38, 0xc4, 0x9a, 0xd4, 0xa9,
	0x8e, 0xc1, 0x5a, 0x21, 0xe7, 0x06, 0x4f, 0xd1, 0x86, 0x4f, 0x52, 0x05, 0x3e, 0x17, 0xf3, 0x38,
	0x1a, 0x44, 0x7b, 0xab, 0xa3, 0x9d, 0xc4, 0x77, 0x95, 0x4c, 0x17, 0x92, 0xe6, 0x82, 0x4d, 0x6a,
	0x6a, 0xe2, 0x20, 0xb2, 0xce, 0x96, 0x8f, 0xf8, 0x14, 0xed, 0x80, 0x3c, 0x57, 0x9a, 0x01, 0x4f,
	0xeb, 0x7c, 0x69, 0xd5, 0x6e, 0xea, 0x12, 0x09, 0x30, 0xf1, 0x8a, 0x2b, 0x7a, 0xb7, 0x29, 0x7a,
	0xe4, 0xa2, 0xbe, 0x13, 0xc6, 0x92, 0x5e, 0xb8, 0x39, 0x75, 0x17, 0x4f, 0x44, 0x0e, 0x47, 0xfe,
	0x1a, 0x7e, 0x85, 0xba, 0x4d, 0xec, 0xb8, 0xed, 0x6a, 0xf4, 0x92, 0x7a, 0x30, 0x49, 0x18, 0x4c,
	0x72, 0x12, 0x08, 0x72, 0x05, 0xe3, 0xc7, 0x68, 0x9d, 0x51, 0xf6, 0x09, 0xd2, 0x0b, 0xd0, 0x55,
	0xee, 0xf8, 0xc6, 0x20, 0xda, 0xeb, 0x92, 0x35, 0x27, 0x9e, 0xd6, 0x1a, 0x7e, 0x8a, 0xb6, 0xfc,
	0xe0, 0x52, 0x90, 0xbc, 0x50, 0x42, 0xda, 0xf8, 0xa6, 0xe3, 0x36, 0xbd, 0xfe, 0xc6, 0xcb, 0x78,
	0x07, 0xa1, 0x30, 0x27, 0xc1, 0xe3, 0x8e, 0x83, 0xba, 0x5e, 0x79, 0xcb, 0xf1, 0x6b, 0xb4, 0xa5,
	0x4b, 0xf9, 0x67, 0xe6, 0x5b, 0xff, 0xce, 0xbc, 0xe9, 0xe1, 0x10, 0x74, 0xf7, 0x04, 0xdd, 0xbf,
	0xbe, 0xa2, 0x71, 0x06, 0xda, 0x1a, 0xbc, 0x8f, 0xd6, 0x69, 0xf5, 0x2b, 0xd5, 0x60, 0xca, 0xcc,
	0x9a, 0x38, 0x1a, 0xb4, 0xf7, 0x56, 0x47, 0xdb, 0x89, 0xef, 0x30, 0x71, 0x1c, 0xa9, 0x4d, 0xb2,
	0x46, 0x97, 0x4e, 0xbb, 0x3f, 0x56, 0xd0, 0xc3, 0x31, 0xcf, 0x27, 0x56, 0x67, 0x1f, 0x0a, 0x4e,
	0x2d, 0x10, 0x30, 0xaa, 0xd4, 0x0c, 0x08, 0x7c, 0x2e, 0xc1, 0x58, 0x3c, 0x44, 0x1d, 0xca, 0x6c,
	0x35, 0x9e, 0x6a, 0xeb, 0x1b, 0xa3, 0x07, 0x4d, 0xd5, 0x40, 0x8e, 0x9d, 0x4d, 0x3c, 0x86, 0x5f,
	0x22, 0x74, 0xf5, 0xfd, 0xfe, 0xb5, 0xd5, 0x69, 0x63, 0xcd, 0x5a, 0x64, 0x09, 0xc4, 0x03, 0xd4,
	0x2e, 0x14, 0xf7, 0x1b, 0x5c, 0x5b, 0x9a, 0x08, 0x9f, 0xb5, 0x48, 0x65, 0xe1, 0x7d, 0xd4, 0x6d,
	0x9e, 0x8e, 0xdb, 0x55, 0xb5, 0xe9, 0xc0, 0x1d, 0x06, 0xe7, 0xbd, 0x7f, 0x53, 0xb3, 0x16, 0xb9,
	0xc2, 0xf1, 0x21, 0xea, 0x98, 0x85, 0x64, 0xc0, 0xdd, 0xf2, 0x56, 0x47, 0x2f, 0x92, 0xfa, 0x19,
	0x24, 0xff, 0xcb, 0xde, 0x24, 0x34, 0xc7, 0xee, 0xee, 0xac, 0x45, 0x7c, 0x95, 0xde, 0x1d, 0xb4,
	0x79, 0xcd, 0x3c, 0x40, 0xe8, 0xb6, 0xf6, 0xd2, 0x41, 0xfc, 0xed, 0xb2, 0x1f, 0x7d, 0xbf, 0xec,
	0x47, 0x3f, 0x2f, 0xfb, 0xd1, 0x97, 0x5f, 0xfd, 0xd6, 0x47, 0xff, 0xe7, 0x70, 0xd6, 0x71, 0xdf,
	0xe4, 0xf3, 0xdf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x64, 0xdf, 0xc2, 0x8a, 0x59, 0x04, 0x00, 0x00,
}

func (m *AdmissionControlSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdmissionControlSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AdmissionControlSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RuntimePolicies != nil {
		{
			size, err := m.RuntimePolicies.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAdmissionControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAdmissionControl(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.CentralEndpoint) > 0 {
		i -= len(m.CentralEndpoint)
		copy(dAtA[i:], m.CentralEndpoint)
		i = encodeVarintAdmissionControl(dAtA, i, uint64(len(m.CentralEndpoint)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.CacheVersion) > 0 {
		i -= len(m.CacheVersion)
		copy(dAtA[i:], m.CacheVersion)
		i = encodeVarintAdmissionControl(dAtA, i, uint64(len(m.CacheVersion)))
		i--
		dAtA[i] = 0x22
	}
	if m.Timestamp != nil {
		{
			size, err := m.Timestamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAdmissionControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.EnforcedDeployTimePolicies != nil {
		{
			size, err := m.EnforcedDeployTimePolicies.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAdmissionControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.ClusterConfig != nil {
		{
			size, err := m.ClusterConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAdmissionControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AdmissionControlAlerts) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdmissionControlAlerts) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AdmissionControlAlerts) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AlertResults) > 0 {
		for iNdEx := len(m.AlertResults) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.AlertResults[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAdmissionControl(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *AdmCtrlUpdateResourceRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdmCtrlUpdateResourceRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AdmCtrlUpdateResourceRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Resource != nil {
		{
			size := m.Resource.Size()
			i -= size
			if _, err := m.Resource.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Action != 0 {
		i = encodeVarintAdmissionControl(dAtA, i, uint64(m.Action))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *AdmCtrlUpdateResourceRequest_Deployment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AdmCtrlUpdateResourceRequest_Deployment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Deployment != nil {
		{
			size, err := m.Deployment.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAdmissionControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *AdmCtrlUpdateResourceRequest_Pod) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AdmCtrlUpdateResourceRequest_Pod) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Pod != nil {
		{
			size, err := m.Pod.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAdmissionControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *AdmCtrlUpdateResourceRequest_Namespace) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AdmCtrlUpdateResourceRequest_Namespace) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Namespace != nil {
		{
			size, err := m.Namespace.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAdmissionControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *AdmCtrlUpdateResourceRequest_Synced) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AdmCtrlUpdateResourceRequest_Synced) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Synced != nil {
		{
			size, err := m.Synced.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAdmissionControl(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *AdmCtrlUpdateResourceRequest_ResourcesSynced) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdmCtrlUpdateResourceRequest_ResourcesSynced) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AdmCtrlUpdateResourceRequest_ResourcesSynced) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func encodeVarintAdmissionControl(dAtA []byte, offset int, v uint64) int {
	offset -= sovAdmissionControl(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *AdmissionControlSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ClusterConfig != nil {
		l = m.ClusterConfig.Size()
		n += 1 + l + sovAdmissionControl(uint64(l))
	}
	if m.EnforcedDeployTimePolicies != nil {
		l = m.EnforcedDeployTimePolicies.Size()
		n += 1 + l + sovAdmissionControl(uint64(l))
	}
	if m.Timestamp != nil {
		l = m.Timestamp.Size()
		n += 1 + l + sovAdmissionControl(uint64(l))
	}
	l = len(m.CacheVersion)
	if l > 0 {
		n += 1 + l + sovAdmissionControl(uint64(l))
	}
	l = len(m.CentralEndpoint)
	if l > 0 {
		n += 1 + l + sovAdmissionControl(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAdmissionControl(uint64(l))
	}
	if m.RuntimePolicies != nil {
		l = m.RuntimePolicies.Size()
		n += 1 + l + sovAdmissionControl(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AdmissionControlAlerts) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.AlertResults) > 0 {
		for _, e := range m.AlertResults {
			l = e.Size()
			n += 1 + l + sovAdmissionControl(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AdmCtrlUpdateResourceRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Action != 0 {
		n += 1 + sovAdmissionControl(uint64(m.Action))
	}
	if m.Resource != nil {
		n += m.Resource.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AdmCtrlUpdateResourceRequest_Deployment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Deployment != nil {
		l = m.Deployment.Size()
		n += 1 + l + sovAdmissionControl(uint64(l))
	}
	return n
}
func (m *AdmCtrlUpdateResourceRequest_Pod) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Pod != nil {
		l = m.Pod.Size()
		n += 1 + l + sovAdmissionControl(uint64(l))
	}
	return n
}
func (m *AdmCtrlUpdateResourceRequest_Namespace) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Namespace != nil {
		l = m.Namespace.Size()
		n += 1 + l + sovAdmissionControl(uint64(l))
	}
	return n
}
func (m *AdmCtrlUpdateResourceRequest_Synced) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Synced != nil {
		l = m.Synced.Size()
		n += 1 + l + sovAdmissionControl(uint64(l))
	}
	return n
}
func (m *AdmCtrlUpdateResourceRequest_ResourcesSynced) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovAdmissionControl(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozAdmissionControl(x uint64) (n int) {
	return sovAdmissionControl(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *AdmissionControlSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmissionControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdmissionControlSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdmissionControlSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmissionControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ClusterConfig == nil {
				m.ClusterConfig = &storage.DynamicClusterConfig{}
			}
			if err := m.ClusterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnforcedDeployTimePolicies", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmissionControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EnforcedDeployTimePolicies == nil {
				m.EnforcedDeployTimePolicies = &storage.PolicyList{}
			}
			if err := m.EnforcedDeployTimePolicies.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmissionControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timestamp == nil {
				m.Timestamp = &types.Timestamp{}
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CacheVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmissionControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CacheVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CentralEndpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmissionControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CentralEndpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmissionControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimePolicies", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmissionControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RuntimePolicies == nil {
				m.RuntimePolicies = &storage.PolicyList{}
			}
			if err := m.RuntimePolicies.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmissionControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdmissionControlAlerts) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmissionControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdmissionControlAlerts: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdmissionControlAlerts: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlertResults", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmissionControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AlertResults = append(m.AlertResults, &central.AlertResults{})
			if err := m.AlertResults[len(m.AlertResults)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmissionControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdmCtrlUpdateResourceRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmissionControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdmCtrlUpdateResourceRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdmCtrlUpdateResourceRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			m.Action = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmissionControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Action |= central.ResourceAction(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmissionControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.Deployment{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &AdmCtrlUpdateResourceRequest_Deployment{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pod", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmissionControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.Pod{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &AdmCtrlUpdateResourceRequest_Pod{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmissionControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.NamespaceMetadata{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &AdmCtrlUpdateResourceRequest_Namespace{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Synced", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmissionControl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdmCtrlUpdateResourceRequest_ResourcesSynced{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &AdmCtrlUpdateResourceRequest_Synced{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmissionControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdmCtrlUpdateResourceRequest_ResourcesSynced) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmissionControl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourcesSynced: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourcesSynced: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAdmissionControl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAdmissionControl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAdmissionControl(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAdmissionControl
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAdmissionControl
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAdmissionControl
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthAdmissionControl
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupAdmissionControl
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthAdmissionControl
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthAdmissionControl        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAdmissionControl          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupAdmissionControl = fmt.Errorf("proto: unexpected end of group")
)
