// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: internalapi/sensor/network_connection_info.proto

package sensor

import (
	fmt "fmt"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type NetworkConnectionInfo struct {
	// Network connections that were added from the last time state was sent.
	UpdatedConnections []*NetworkConnection `protobuf:"bytes,1,rep,name=updated_connections,json=updatedConnections,proto3" json:"updated_connections,omitempty"`
	// Listening endpoints that were added from the last time state was sent.
	UpdatedEndpoints []*NetworkEndpoint `protobuf:"bytes,3,rep,name=updated_endpoints,json=updatedEndpoints,proto3" json:"updated_endpoints,omitempty"`
	//For active connections, the timestamp of the entire message serves as the latest timestamp
	//that connection was deemed active
	Time                 *types.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *NetworkConnectionInfo) Reset()         { *m = NetworkConnectionInfo{} }
func (m *NetworkConnectionInfo) String() string { return proto.CompactTextString(m) }
func (*NetworkConnectionInfo) ProtoMessage()    {}
func (*NetworkConnectionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_d36d90689c926f7f, []int{0}
}
func (m *NetworkConnectionInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkConnectionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkConnectionInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkConnectionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkConnectionInfo.Merge(m, src)
}
func (m *NetworkConnectionInfo) XXX_Size() int {
	return m.Size()
}
func (m *NetworkConnectionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkConnectionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkConnectionInfo proto.InternalMessageInfo

func (m *NetworkConnectionInfo) GetUpdatedConnections() []*NetworkConnection {
	if m != nil {
		return m.UpdatedConnections
	}
	return nil
}

func (m *NetworkConnectionInfo) GetUpdatedEndpoints() []*NetworkEndpoint {
	if m != nil {
		return m.UpdatedEndpoints
	}
	return nil
}

func (m *NetworkConnectionInfo) GetTime() *types.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

func (m *NetworkConnectionInfo) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkConnectionInfo) Clone() *NetworkConnectionInfo {
	if m == nil {
		return nil
	}
	cloned := new(NetworkConnectionInfo)
	*cloned = *m

	if m.UpdatedConnections != nil {
		cloned.UpdatedConnections = make([]*NetworkConnection, len(m.UpdatedConnections))
		for idx, v := range m.UpdatedConnections {
			cloned.UpdatedConnections[idx] = v.Clone()
		}
	}
	if m.UpdatedEndpoints != nil {
		cloned.UpdatedEndpoints = make([]*NetworkEndpoint, len(m.UpdatedEndpoints))
		for idx, v := range m.UpdatedEndpoints {
			cloned.UpdatedEndpoints[idx] = v.Clone()
		}
	}
	cloned.Time = m.Time.Clone()
	return cloned
}

// NetworkConnection tracks connection information about client and server.
type NetworkConnection struct {
	SocketFamily  SocketFamily       `protobuf:"varint,1,opt,name=socket_family,json=socketFamily,proto3,enum=sensor.SocketFamily" json:"socket_family,omitempty"`
	LocalAddress  *NetworkAddress    `protobuf:"bytes,2,opt,name=local_address,json=localAddress,proto3" json:"local_address,omitempty"`
	RemoteAddress *NetworkAddress    `protobuf:"bytes,3,opt,name=remote_address,json=remoteAddress,proto3" json:"remote_address,omitempty"`
	Protocol      storage.L4Protocol `protobuf:"varint,4,opt,name=protocol,proto3,enum=storage.L4Protocol" json:"protocol,omitempty"`
	Role          ClientServerRole   `protobuf:"varint,5,opt,name=role,proto3,enum=sensor.ClientServerRole" json:"role,omitempty"`
	ContainerId   string             `protobuf:"bytes,6,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// If this connection was closed, this gives the timestamp when it was closed. If this is unset, we treat it as an
	// open connection.
	CloseTimestamp       *types.Timestamp `protobuf:"bytes,11,opt,name=close_timestamp,json=closeTimestamp,proto3" json:"close_timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *NetworkConnection) Reset()         { *m = NetworkConnection{} }
func (m *NetworkConnection) String() string { return proto.CompactTextString(m) }
func (*NetworkConnection) ProtoMessage()    {}
func (*NetworkConnection) Descriptor() ([]byte, []int) {
	return fileDescriptor_d36d90689c926f7f, []int{1}
}
func (m *NetworkConnection) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkConnection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkConnection.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkConnection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkConnection.Merge(m, src)
}
func (m *NetworkConnection) XXX_Size() int {
	return m.Size()
}
func (m *NetworkConnection) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkConnection.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkConnection proto.InternalMessageInfo

func (m *NetworkConnection) GetSocketFamily() SocketFamily {
	if m != nil {
		return m.SocketFamily
	}
	return SocketFamily_SOCKET_FAMILY_UNKNOWN
}

func (m *NetworkConnection) GetLocalAddress() *NetworkAddress {
	if m != nil {
		return m.LocalAddress
	}
	return nil
}

func (m *NetworkConnection) GetRemoteAddress() *NetworkAddress {
	if m != nil {
		return m.RemoteAddress
	}
	return nil
}

func (m *NetworkConnection) GetProtocol() storage.L4Protocol {
	if m != nil {
		return m.Protocol
	}
	return storage.L4Protocol_L4_PROTOCOL_UNKNOWN
}

func (m *NetworkConnection) GetRole() ClientServerRole {
	if m != nil {
		return m.Role
	}
	return ClientServerRole_ROLE_UNKNOWN
}

func (m *NetworkConnection) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

func (m *NetworkConnection) GetCloseTimestamp() *types.Timestamp {
	if m != nil {
		return m.CloseTimestamp
	}
	return nil
}

func (m *NetworkConnection) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkConnection) Clone() *NetworkConnection {
	if m == nil {
		return nil
	}
	cloned := new(NetworkConnection)
	*cloned = *m

	cloned.LocalAddress = m.LocalAddress.Clone()
	cloned.RemoteAddress = m.RemoteAddress.Clone()
	cloned.CloseTimestamp = m.CloseTimestamp.Clone()
	return cloned
}

type NetworkEndpoint struct {
	SocketFamily SocketFamily       `protobuf:"varint,1,opt,name=socket_family,json=socketFamily,proto3,enum=sensor.SocketFamily" json:"socket_family,omitempty"`
	Protocol     storage.L4Protocol `protobuf:"varint,2,opt,name=protocol,proto3,enum=storage.L4Protocol" json:"protocol,omitempty"`
	// The address_data part might be empty to indicate "all interfaces", or to simply save space.
	ListenAddress *NetworkAddress `protobuf:"bytes,3,opt,name=listen_address,json=listenAddress,proto3" json:"listen_address,omitempty"`
	ContainerId   string          `protobuf:"bytes,4,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// If we're no longer listening on this endpoint, this gives the timestamp when the listen socket
	// was shutdown. If this is unset, we treat it as an actively listening endpoint.
	CloseTimestamp       *types.Timestamp `protobuf:"bytes,5,opt,name=close_timestamp,json=closeTimestamp,proto3" json:"close_timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *NetworkEndpoint) Reset()         { *m = NetworkEndpoint{} }
func (m *NetworkEndpoint) String() string { return proto.CompactTextString(m) }
func (*NetworkEndpoint) ProtoMessage()    {}
func (*NetworkEndpoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_d36d90689c926f7f, []int{2}
}
func (m *NetworkEndpoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkEndpoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkEndpoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkEndpoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkEndpoint.Merge(m, src)
}
func (m *NetworkEndpoint) XXX_Size() int {
	return m.Size()
}
func (m *NetworkEndpoint) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkEndpoint.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkEndpoint proto.InternalMessageInfo

func (m *NetworkEndpoint) GetSocketFamily() SocketFamily {
	if m != nil {
		return m.SocketFamily
	}
	return SocketFamily_SOCKET_FAMILY_UNKNOWN
}

func (m *NetworkEndpoint) GetProtocol() storage.L4Protocol {
	if m != nil {
		return m.Protocol
	}
	return storage.L4Protocol_L4_PROTOCOL_UNKNOWN
}

func (m *NetworkEndpoint) GetListenAddress() *NetworkAddress {
	if m != nil {
		return m.ListenAddress
	}
	return nil
}

func (m *NetworkEndpoint) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

func (m *NetworkEndpoint) GetCloseTimestamp() *types.Timestamp {
	if m != nil {
		return m.CloseTimestamp
	}
	return nil
}

func (m *NetworkEndpoint) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkEndpoint) Clone() *NetworkEndpoint {
	if m == nil {
		return nil
	}
	cloned := new(NetworkEndpoint)
	*cloned = *m

	cloned.ListenAddress = m.ListenAddress.Clone()
	cloned.CloseTimestamp = m.CloseTimestamp.Clone()
	return cloned
}

type NetworkAddress struct {
	AddressData []byte `protobuf:"bytes,1,opt,name=address_data,json=addressData,proto3" json:"address_data,omitempty"`
	Port        uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Represents an IPV4 or IPV6 network. First 4/16 bytes representing network address whereas following byte represents
	// the length of network prefix. If used, this field must have 5 or 17 bytes; otherwise it should be discarded.
	// `ip_network` and `address_data` usage should be mutually exclusive.
	IpNetwork            []byte   `protobuf:"bytes,3,opt,name=ip_network,json=ipNetwork,proto3" json:"ip_network,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NetworkAddress) Reset()         { *m = NetworkAddress{} }
func (m *NetworkAddress) String() string { return proto.CompactTextString(m) }
func (*NetworkAddress) ProtoMessage()    {}
func (*NetworkAddress) Descriptor() ([]byte, []int) {
	return fileDescriptor_d36d90689c926f7f, []int{3}
}
func (m *NetworkAddress) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkAddress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkAddress.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkAddress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkAddress.Merge(m, src)
}
func (m *NetworkAddress) XXX_Size() int {
	return m.Size()
}
func (m *NetworkAddress) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkAddress.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkAddress proto.InternalMessageInfo

func (m *NetworkAddress) GetAddressData() []byte {
	if m != nil {
		return m.AddressData
	}
	return nil
}

func (m *NetworkAddress) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *NetworkAddress) GetIpNetwork() []byte {
	if m != nil {
		return m.IpNetwork
	}
	return nil
}

func (m *NetworkAddress) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkAddress) Clone() *NetworkAddress {
	if m == nil {
		return nil
	}
	cloned := new(NetworkAddress)
	*cloned = *m

	if m.AddressData != nil {
		cloned.AddressData = make([]byte, len(m.AddressData))
		copy(cloned.AddressData, m.AddressData)
	}
	if m.IpNetwork != nil {
		cloned.IpNetwork = make([]byte, len(m.IpNetwork))
		copy(cloned.IpNetwork, m.IpNetwork)
	}
	return cloned
}

func init() {
	proto.RegisterType((*NetworkConnectionInfo)(nil), "sensor.NetworkConnectionInfo")
	proto.RegisterType((*NetworkConnection)(nil), "sensor.NetworkConnection")
	proto.RegisterType((*NetworkEndpoint)(nil), "sensor.NetworkEndpoint")
	proto.RegisterType((*NetworkAddress)(nil), "sensor.NetworkAddress")
}

func init() {
	proto.RegisterFile("internalapi/sensor/network_connection_info.proto", fileDescriptor_d36d90689c926f7f)
}

var fileDescriptor_d36d90689c926f7f = []byte{
	// 540 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x54, 0x4d, 0x6f, 0xd3, 0x40,
	0x10, 0xc5, 0x49, 0x1a, 0xd1, 0xcd, 0x47, 0xe9, 0x96, 0x0f, 0x13, 0x44, 0x08, 0x39, 0xa0, 0x1c,
	0x90, 0x83, 0x02, 0x17, 0x84, 0x7a, 0x80, 0x14, 0xa4, 0x22, 0x84, 0xd0, 0x96, 0x13, 0x17, 0x6b,
	0x6b, 0x8f, 0xa3, 0x55, 0x37, 0x3b, 0xd6, 0xee, 0x86, 0x8a, 0x9f, 0xc1, 0x8d, 0x1f, 0xc0, 0x8f,
	0xe1, 0xc8, 0x95, 0x1b, 0x0a, 0x7f, 0x82, 0x23, 0xea, 0x7a, 0x6d, 0x42, 0x2a, 0x95, 0x20, 0x6e,
	0xde, 0x79, 0xef, 0xcd, 0xbe, 0x79, 0x63, 0x9b, 0x3c, 0x10, 0xca, 0x82, 0x56, 0x5c, 0xf2, 0x5c,
	0x8c, 0x0d, 0x28, 0x83, 0x7a, 0xac, 0xc0, 0x9e, 0xa2, 0x3e, 0x89, 0x13, 0x54, 0x0a, 0x12, 0x2b,
	0x50, 0xc5, 0x42, 0x65, 0x18, 0xe5, 0x1a, 0x2d, 0xd2, 0x66, 0xc1, 0xea, 0xdd, 0x99, 0x21, 0xce,
	0x24, 0x8c, 0x5d, 0xf5, 0x78, 0x91, 0x8d, 0xad, 0x98, 0x83, 0xb1, 0x7c, 0x9e, 0x17, 0xc4, 0xde,
	0xbd, 0x0b, 0x5a, 0x83, 0x5a, 0xcc, 0x8d, 0xe7, 0xf5, 0x8c, 0x45, 0xcd, 0x67, 0x50, 0x81, 0x99,
	0xc4, 0xd3, 0x02, 0x1b, 0x7e, 0x0b, 0xc8, 0xb5, 0xd7, 0x45, 0x79, 0x5a, 0xb9, 0x39, 0x54, 0x19,
	0xd2, 0x97, 0x64, 0x6f, 0x91, 0xa7, 0xdc, 0x42, 0xba, 0xe2, 0xd3, 0x84, 0xc1, 0xa0, 0x3e, 0x6a,
	0x4d, 0x6e, 0x46, 0xc5, 0x7d, 0xd1, 0x39, 0x2d, 0xa3, 0x5e, 0xf5, 0xbb, 0x64, 0xe8, 0x01, 0xd9,
	0x2d, 0x7b, 0x81, 0x4a, 0x73, 0x14, 0xca, 0x9a, 0xb0, 0xee, 0x3a, 0xdd, 0x58, 0xeb, 0xf4, 0xdc,
	0xe3, 0xec, 0x8a, 0x57, 0x94, 0x05, 0x43, 0x23, 0xd2, 0x38, 0x8b, 0x20, 0xac, 0x0d, 0x82, 0x51,
	0x6b, 0xd2, 0x8b, 0x8a, 0x7c, 0xa2, 0x32, 0x9f, 0xe8, 0x6d, 0x99, 0x0f, 0x73, 0xbc, 0xe1, 0xc7,
	0x3a, 0xd9, 0x3d, 0xe7, 0x8f, 0x3e, 0x26, 0x1d, 0x83, 0xc9, 0x09, 0xd8, 0x38, 0xe3, 0x73, 0x21,
	0x3f, 0x84, 0xc1, 0x20, 0x18, 0x75, 0x27, 0x57, 0x4b, 0x1f, 0x47, 0x0e, 0x7c, 0xe1, 0x30, 0xd6,
	0x36, 0x2b, 0x27, 0xfa, 0x84, 0x74, 0x24, 0x26, 0x5c, 0xc6, 0x3c, 0x4d, 0x35, 0x18, 0xe3, 0x9d,
	0x5c, 0x5f, 0x1b, 0xe1, 0x69, 0x81, 0xb2, 0xb6, 0x23, 0xfb, 0x13, 0xdd, 0x27, 0x5d, 0x0d, 0x73,
	0xb4, 0x50, 0xa9, 0xeb, 0x17, 0xaa, 0x3b, 0x05, 0xbb, 0x94, 0x8f, 0xc9, 0x65, 0x37, 0x68, 0x82,
	0x32, 0x6c, 0x38, 0xc7, 0x7b, 0x91, 0xdf, 0x6b, 0xf4, 0xea, 0xd1, 0x1b, 0x0f, 0xb1, 0x8a, 0x44,
	0xef, 0x93, 0x86, 0x46, 0x09, 0xe1, 0x96, 0x23, 0x87, 0xe5, 0x2d, 0x53, 0x29, 0x40, 0xd9, 0x23,
	0xd0, 0xef, 0x41, 0x33, 0x94, 0xc0, 0x1c, 0x8b, 0xde, 0x25, 0xed, 0x04, 0x95, 0xe5, 0x42, 0x81,
	0x8e, 0x45, 0x1a, 0x36, 0x07, 0xc1, 0x68, 0x9b, 0xb5, 0xaa, 0xda, 0x61, 0x4a, 0xa7, 0x64, 0x27,
	0x91, 0x68, 0x20, 0xae, 0xde, 0xc3, 0xb0, 0xf5, 0xd7, 0x4d, 0x74, 0x9d, 0xa4, 0x3a, 0x0f, 0x3f,
	0xd7, 0xc8, 0xce, 0xda, 0xa6, 0xff, 0x67, 0x23, 0xab, 0xa9, 0xd4, 0x36, 0x49, 0x65, 0x9f, 0x74,
	0xa5, 0x30, 0x16, 0xd4, 0xa6, 0x5b, 0x28, 0xd8, 0xe5, 0x16, 0xd6, 0x63, 0x6a, 0x6c, 0x14, 0xd3,
	0xd6, 0x3f, 0xc7, 0x94, 0x91, 0xee, 0x9f, 0x46, 0xce, 0x6e, 0xf6, 0x8e, 0xe3, 0x94, 0x5b, 0xee,
	0x32, 0x6a, 0xb3, 0x96, 0xaf, 0x1d, 0x70, 0xcb, 0x29, 0x25, 0x8d, 0x1c, 0xb5, 0x75, 0x41, 0x74,
	0x98, 0x7b, 0xa6, 0xb7, 0x09, 0x11, 0x79, 0xec, 0x3f, 0x7c, 0x37, 0x6b, 0x9b, 0x6d, 0x8b, 0xdc,
	0x37, 0x7f, 0x76, 0xeb, 0xcb, 0xb2, 0x1f, 0x7c, 0x5d, 0xf6, 0x83, 0xef, 0xcb, 0x7e, 0xf0, 0xe9,
	0x47, 0xff, 0xd2, 0x3b, 0xff, 0xf7, 0xf9, 0x19, 0x04, 0xc7, 0x4d, 0x67, 0xf4, 0xe1, 0xaf, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xb2, 0x0a, 0xd3, 0x09, 0xc3, 0x04, 0x00, 0x00,
}

func (m *NetworkConnectionInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkConnectionInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkConnectionInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.UpdatedEndpoints) > 0 {
		for iNdEx := len(m.UpdatedEndpoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.UpdatedEndpoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkConnectionInfo(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Time != nil {
		{
			size, err := m.Time.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkConnectionInfo(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.UpdatedConnections) > 0 {
		for iNdEx := len(m.UpdatedConnections) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.UpdatedConnections[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkConnectionInfo(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *NetworkConnection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkConnection) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkConnection) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CloseTimestamp != nil {
		{
			size, err := m.CloseTimestamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkConnectionInfo(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintNetworkConnectionInfo(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0x32
	}
	if m.Role != 0 {
		i = encodeVarintNetworkConnectionInfo(dAtA, i, uint64(m.Role))
		i--
		dAtA[i] = 0x28
	}
	if m.Protocol != 0 {
		i = encodeVarintNetworkConnectionInfo(dAtA, i, uint64(m.Protocol))
		i--
		dAtA[i] = 0x20
	}
	if m.RemoteAddress != nil {
		{
			size, err := m.RemoteAddress.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkConnectionInfo(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.LocalAddress != nil {
		{
			size, err := m.LocalAddress.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkConnectionInfo(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.SocketFamily != 0 {
		i = encodeVarintNetworkConnectionInfo(dAtA, i, uint64(m.SocketFamily))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *NetworkEndpoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkEndpoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkEndpoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CloseTimestamp != nil {
		{
			size, err := m.CloseTimestamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkConnectionInfo(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintNetworkConnectionInfo(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0x22
	}
	if m.ListenAddress != nil {
		{
			size, err := m.ListenAddress.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkConnectionInfo(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Protocol != 0 {
		i = encodeVarintNetworkConnectionInfo(dAtA, i, uint64(m.Protocol))
		i--
		dAtA[i] = 0x10
	}
	if m.SocketFamily != 0 {
		i = encodeVarintNetworkConnectionInfo(dAtA, i, uint64(m.SocketFamily))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *NetworkAddress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkAddress) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkAddress) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.IpNetwork) > 0 {
		i -= len(m.IpNetwork)
		copy(dAtA[i:], m.IpNetwork)
		i = encodeVarintNetworkConnectionInfo(dAtA, i, uint64(len(m.IpNetwork)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Port != 0 {
		i = encodeVarintNetworkConnectionInfo(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x10
	}
	if len(m.AddressData) > 0 {
		i -= len(m.AddressData)
		copy(dAtA[i:], m.AddressData)
		i = encodeVarintNetworkConnectionInfo(dAtA, i, uint64(len(m.AddressData)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintNetworkConnectionInfo(dAtA []byte, offset int, v uint64) int {
	offset -= sovNetworkConnectionInfo(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *NetworkConnectionInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.UpdatedConnections) > 0 {
		for _, e := range m.UpdatedConnections {
			l = e.Size()
			n += 1 + l + sovNetworkConnectionInfo(uint64(l))
		}
	}
	if m.Time != nil {
		l = m.Time.Size()
		n += 1 + l + sovNetworkConnectionInfo(uint64(l))
	}
	if len(m.UpdatedEndpoints) > 0 {
		for _, e := range m.UpdatedEndpoints {
			l = e.Size()
			n += 1 + l + sovNetworkConnectionInfo(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkConnection) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SocketFamily != 0 {
		n += 1 + sovNetworkConnectionInfo(uint64(m.SocketFamily))
	}
	if m.LocalAddress != nil {
		l = m.LocalAddress.Size()
		n += 1 + l + sovNetworkConnectionInfo(uint64(l))
	}
	if m.RemoteAddress != nil {
		l = m.RemoteAddress.Size()
		n += 1 + l + sovNetworkConnectionInfo(uint64(l))
	}
	if m.Protocol != 0 {
		n += 1 + sovNetworkConnectionInfo(uint64(m.Protocol))
	}
	if m.Role != 0 {
		n += 1 + sovNetworkConnectionInfo(uint64(m.Role))
	}
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovNetworkConnectionInfo(uint64(l))
	}
	if m.CloseTimestamp != nil {
		l = m.CloseTimestamp.Size()
		n += 1 + l + sovNetworkConnectionInfo(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkEndpoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SocketFamily != 0 {
		n += 1 + sovNetworkConnectionInfo(uint64(m.SocketFamily))
	}
	if m.Protocol != 0 {
		n += 1 + sovNetworkConnectionInfo(uint64(m.Protocol))
	}
	if m.ListenAddress != nil {
		l = m.ListenAddress.Size()
		n += 1 + l + sovNetworkConnectionInfo(uint64(l))
	}
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovNetworkConnectionInfo(uint64(l))
	}
	if m.CloseTimestamp != nil {
		l = m.CloseTimestamp.Size()
		n += 1 + l + sovNetworkConnectionInfo(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkAddress) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.AddressData)
	if l > 0 {
		n += 1 + l + sovNetworkConnectionInfo(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovNetworkConnectionInfo(uint64(m.Port))
	}
	l = len(m.IpNetwork)
	if l > 0 {
		n += 1 + l + sovNetworkConnectionInfo(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovNetworkConnectionInfo(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozNetworkConnectionInfo(x uint64) (n int) {
	return sovNetworkConnectionInfo(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *NetworkConnectionInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkConnectionInfo
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkConnectionInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkConnectionInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdatedConnections", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UpdatedConnections = append(m.UpdatedConnections, &NetworkConnection{})
			if err := m.UpdatedConnections[len(m.UpdatedConnections)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Time == nil {
				m.Time = &types.Timestamp{}
			}
			if err := m.Time.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdatedEndpoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UpdatedEndpoints = append(m.UpdatedEndpoints, &NetworkEndpoint{})
			if err := m.UpdatedEndpoints[len(m.UpdatedEndpoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkConnectionInfo(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkConnection) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkConnectionInfo
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkConnection: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkConnection: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SocketFamily", wireType)
			}
			m.SocketFamily = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SocketFamily |= SocketFamily(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalAddress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LocalAddress == nil {
				m.LocalAddress = &NetworkAddress{}
			}
			if err := m.LocalAddress.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoteAddress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RemoteAddress == nil {
				m.RemoteAddress = &NetworkAddress{}
			}
			if err := m.RemoteAddress.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			m.Protocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Protocol |= storage.L4Protocol(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			m.Role = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Role |= ClientServerRole(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CloseTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CloseTimestamp == nil {
				m.CloseTimestamp = &types.Timestamp{}
			}
			if err := m.CloseTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkConnectionInfo(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkEndpoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkConnectionInfo
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkEndpoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkEndpoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SocketFamily", wireType)
			}
			m.SocketFamily = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SocketFamily |= SocketFamily(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			m.Protocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Protocol |= storage.L4Protocol(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListenAddress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ListenAddress == nil {
				m.ListenAddress = &NetworkAddress{}
			}
			if err := m.ListenAddress.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CloseTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CloseTimestamp == nil {
				m.CloseTimestamp = &types.Timestamp{}
			}
			if err := m.CloseTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkConnectionInfo(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkAddress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkConnectionInfo
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkAddress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkAddress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddressData", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AddressData = append(m.AddressData[:0], dAtA[iNdEx:postIndex]...)
			if m.AddressData == nil {
				m.AddressData = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IpNetwork", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IpNetwork = append(m.IpNetwork[:0], dAtA[iNdEx:postIndex]...)
			if m.IpNetwork == nil {
				m.IpNetwork = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkConnectionInfo(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkConnectionInfo
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipNetworkConnectionInfo(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowNetworkConnectionInfo
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNetworkConnectionInfo
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthNetworkConnectionInfo
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupNetworkConnectionInfo
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthNetworkConnectionInfo
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthNetworkConnectionInfo        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowNetworkConnectionInfo          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupNetworkConnectionInfo = fmt.Errorf("proto: unexpected end of group")
)
