// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: internalapi/sensor/network_connection_iservice.proto

package sensor

import (
	context "context"
	encoding_binary "encoding/binary"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type NetworkConnectionInfoMessage struct {
	// Types that are valid to be assigned to Msg:
	//	*NetworkConnectionInfoMessage_Register
	//	*NetworkConnectionInfoMessage_Info
	Msg                  isNetworkConnectionInfoMessage_Msg `protobuf_oneof:"msg"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *NetworkConnectionInfoMessage) Reset()         { *m = NetworkConnectionInfoMessage{} }
func (m *NetworkConnectionInfoMessage) String() string { return proto.CompactTextString(m) }
func (*NetworkConnectionInfoMessage) ProtoMessage()    {}
func (*NetworkConnectionInfoMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_6dc4e32683ddd49f, []int{0}
}
func (m *NetworkConnectionInfoMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkConnectionInfoMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkConnectionInfoMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkConnectionInfoMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkConnectionInfoMessage.Merge(m, src)
}
func (m *NetworkConnectionInfoMessage) XXX_Size() int {
	return m.Size()
}
func (m *NetworkConnectionInfoMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkConnectionInfoMessage.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkConnectionInfoMessage proto.InternalMessageInfo

type isNetworkConnectionInfoMessage_Msg interface {
	isNetworkConnectionInfoMessage_Msg()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isNetworkConnectionInfoMessage_Msg
}

type NetworkConnectionInfoMessage_Register struct {
	Register *CollectorRegisterRequest `protobuf:"bytes,1,opt,name=register,proto3,oneof" json:"register,omitempty"`
}
type NetworkConnectionInfoMessage_Info struct {
	Info *NetworkConnectionInfo `protobuf:"bytes,2,opt,name=info,proto3,oneof" json:"info,omitempty"`
}

func (*NetworkConnectionInfoMessage_Register) isNetworkConnectionInfoMessage_Msg() {}
func (m *NetworkConnectionInfoMessage_Register) Clone() isNetworkConnectionInfoMessage_Msg {
	if m == nil {
		return nil
	}
	cloned := new(NetworkConnectionInfoMessage_Register)
	*cloned = *m

	cloned.Register = m.Register.Clone()
	return cloned
}
func (*NetworkConnectionInfoMessage_Info) isNetworkConnectionInfoMessage_Msg() {}
func (m *NetworkConnectionInfoMessage_Info) Clone() isNetworkConnectionInfoMessage_Msg {
	if m == nil {
		return nil
	}
	cloned := new(NetworkConnectionInfoMessage_Info)
	*cloned = *m

	cloned.Info = m.Info.Clone()
	return cloned
}

func (m *NetworkConnectionInfoMessage) GetMsg() isNetworkConnectionInfoMessage_Msg {
	if m != nil {
		return m.Msg
	}
	return nil
}

func (m *NetworkConnectionInfoMessage) GetRegister() *CollectorRegisterRequest {
	if x, ok := m.GetMsg().(*NetworkConnectionInfoMessage_Register); ok {
		return x.Register
	}
	return nil
}

func (m *NetworkConnectionInfoMessage) GetInfo() *NetworkConnectionInfo {
	if x, ok := m.GetMsg().(*NetworkConnectionInfoMessage_Info); ok {
		return x.Info
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*NetworkConnectionInfoMessage) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*NetworkConnectionInfoMessage_Register)(nil),
		(*NetworkConnectionInfoMessage_Info)(nil),
	}
}

func (m *NetworkConnectionInfoMessage) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkConnectionInfoMessage) Clone() *NetworkConnectionInfoMessage {
	if m == nil {
		return nil
	}
	cloned := new(NetworkConnectionInfoMessage)
	*cloned = *m

	if m.Msg != nil {
		cloned.Msg = m.Msg.Clone()
	}
	return cloned
}

type NetworkFlowsControlMessage struct {
	PublicIpAddresses    *IPAddressList `protobuf:"bytes,1,opt,name=public_ip_addresses,json=publicIpAddresses,proto3" json:"public_ip_addresses,omitempty"`
	IpNetworks           *IPNetworkList `protobuf:"bytes,2,opt,name=ip_networks,json=ipNetworks,proto3" json:"ip_networks,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *NetworkFlowsControlMessage) Reset()         { *m = NetworkFlowsControlMessage{} }
func (m *NetworkFlowsControlMessage) String() string { return proto.CompactTextString(m) }
func (*NetworkFlowsControlMessage) ProtoMessage()    {}
func (*NetworkFlowsControlMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_6dc4e32683ddd49f, []int{1}
}
func (m *NetworkFlowsControlMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkFlowsControlMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkFlowsControlMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkFlowsControlMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkFlowsControlMessage.Merge(m, src)
}
func (m *NetworkFlowsControlMessage) XXX_Size() int {
	return m.Size()
}
func (m *NetworkFlowsControlMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkFlowsControlMessage.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkFlowsControlMessage proto.InternalMessageInfo

func (m *NetworkFlowsControlMessage) GetPublicIpAddresses() *IPAddressList {
	if m != nil {
		return m.PublicIpAddresses
	}
	return nil
}

func (m *NetworkFlowsControlMessage) GetIpNetworks() *IPNetworkList {
	if m != nil {
		return m.IpNetworks
	}
	return nil
}

func (m *NetworkFlowsControlMessage) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkFlowsControlMessage) Clone() *NetworkFlowsControlMessage {
	if m == nil {
		return nil
	}
	cloned := new(NetworkFlowsControlMessage)
	*cloned = *m

	cloned.PublicIpAddresses = m.PublicIpAddresses.Clone()
	cloned.IpNetworks = m.IpNetworks.Clone()
	return cloned
}

type IPAddressList struct {
	// A list of IPv4 addresses, encoded in correct byte order (i.e., 127.0.0.1 is encoded as 0x7f000001). On a
	// little-endian system, you must convert to big endian to interpret the value as a binary address.
	Ipv4Addresses []uint32 `protobuf:"fixed32,1,rep,packed,name=ipv4_addresses,json=ipv4Addresses,proto3" json:"ipv4_addresses,omitempty"`
	// A list of IPv6 addresses, as uint64 pairs. Each pair is ordered in network order (big endian, i.e., first high,
	// then low); each uint64 is encoded in the correct byte order and may need to be converted to big endian on little
	// endian System. E.g., the IPv6 address ::1 (local loopback) is encoded as a `0` uint64 followed by a `1` uint64.
	// This field must always have an even number of values; otherwise it should be discarded.
	Ipv6Addresses        []uint64 `protobuf:"fixed64,2,rep,packed,name=ipv6_addresses,json=ipv6Addresses,proto3" json:"ipv6_addresses,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IPAddressList) Reset()         { *m = IPAddressList{} }
func (m *IPAddressList) String() string { return proto.CompactTextString(m) }
func (*IPAddressList) ProtoMessage()    {}
func (*IPAddressList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6dc4e32683ddd49f, []int{2}
}
func (m *IPAddressList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IPAddressList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IPAddressList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IPAddressList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IPAddressList.Merge(m, src)
}
func (m *IPAddressList) XXX_Size() int {
	return m.Size()
}
func (m *IPAddressList) XXX_DiscardUnknown() {
	xxx_messageInfo_IPAddressList.DiscardUnknown(m)
}

var xxx_messageInfo_IPAddressList proto.InternalMessageInfo

func (m *IPAddressList) GetIpv4Addresses() []uint32 {
	if m != nil {
		return m.Ipv4Addresses
	}
	return nil
}

func (m *IPAddressList) GetIpv6Addresses() []uint64 {
	if m != nil {
		return m.Ipv6Addresses
	}
	return nil
}

func (m *IPAddressList) MessageClone() proto.Message {
	return m.Clone()
}
func (m *IPAddressList) Clone() *IPAddressList {
	if m == nil {
		return nil
	}
	cloned := new(IPAddressList)
	*cloned = *m

	if m.Ipv4Addresses != nil {
		cloned.Ipv4Addresses = make([]uint32, len(m.Ipv4Addresses))
		copy(cloned.Ipv4Addresses, m.Ipv4Addresses)
	}
	if m.Ipv6Addresses != nil {
		cloned.Ipv6Addresses = make([]uint64, len(m.Ipv6Addresses))
		copy(cloned.Ipv6Addresses, m.Ipv6Addresses)
	}
	return cloned
}

type IPNetworkList struct {
	// A list of IPv4 networks, as a sequence of bytes. First four bytes represent IP followed by the byte representing
	// the network prefix length. Each sequence encoded in correct byte order (i.e., 127.0.0.1/8 is encoded as 0x7f0000018).
	// On a little-endian system, you must convert to big endian to interpret the value as a binary address.
	// This field must always have an 5x number of values; otherwise it should be discarded.
	Ipv4Networks []byte `protobuf:"bytes,1,opt,name=ipv4_networks,json=ipv4Networks,proto3" json:"ipv4_networks,omitempty"`
	// A list of IPv6 networks, as a sequence of bytes. First 16 bytes representing IP followed by the byte representing
	// the network prefix length. Each IP sequence is ordered in network order (big endian, i.e., first high, then low).
	// Each order is encoded in the correct byte order and may need to be converted to big endian on little endian System.
	// This field must always have an 17x number of values; otherwise it should be discarded.
	Ipv6Networks         []byte   `protobuf:"bytes,2,opt,name=ipv6_networks,json=ipv6Networks,proto3" json:"ipv6_networks,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IPNetworkList) Reset()         { *m = IPNetworkList{} }
func (m *IPNetworkList) String() string { return proto.CompactTextString(m) }
func (*IPNetworkList) ProtoMessage()    {}
func (*IPNetworkList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6dc4e32683ddd49f, []int{3}
}
func (m *IPNetworkList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IPNetworkList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IPNetworkList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IPNetworkList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IPNetworkList.Merge(m, src)
}
func (m *IPNetworkList) XXX_Size() int {
	return m.Size()
}
func (m *IPNetworkList) XXX_DiscardUnknown() {
	xxx_messageInfo_IPNetworkList.DiscardUnknown(m)
}

var xxx_messageInfo_IPNetworkList proto.InternalMessageInfo

func (m *IPNetworkList) GetIpv4Networks() []byte {
	if m != nil {
		return m.Ipv4Networks
	}
	return nil
}

func (m *IPNetworkList) GetIpv6Networks() []byte {
	if m != nil {
		return m.Ipv6Networks
	}
	return nil
}

func (m *IPNetworkList) MessageClone() proto.Message {
	return m.Clone()
}
func (m *IPNetworkList) Clone() *IPNetworkList {
	if m == nil {
		return nil
	}
	cloned := new(IPNetworkList)
	*cloned = *m

	if m.Ipv4Networks != nil {
		cloned.Ipv4Networks = make([]byte, len(m.Ipv4Networks))
		copy(cloned.Ipv4Networks, m.Ipv4Networks)
	}
	if m.Ipv6Networks != nil {
		cloned.Ipv6Networks = make([]byte, len(m.Ipv6Networks))
		copy(cloned.Ipv6Networks, m.Ipv6Networks)
	}
	return cloned
}

func init() {
	proto.RegisterType((*NetworkConnectionInfoMessage)(nil), "sensor.NetworkConnectionInfoMessage")
	proto.RegisterType((*NetworkFlowsControlMessage)(nil), "sensor.NetworkFlowsControlMessage")
	proto.RegisterType((*IPAddressList)(nil), "sensor.IPAddressList")
	proto.RegisterType((*IPNetworkList)(nil), "sensor.IPNetworkList")
}

func init() {
	proto.RegisterFile("internalapi/sensor/network_connection_iservice.proto", fileDescriptor_6dc4e32683ddd49f)
}

var fileDescriptor_6dc4e32683ddd49f = []byte{
	// 414 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x92, 0xdf, 0xee, 0xd2, 0x30,
	0x1c, 0xc5, 0x29, 0x28, 0x9a, 0x02, 0x26, 0xd6, 0x98, 0xe0, 0xd4, 0x85, 0x4c, 0x4d, 0x76, 0x05,
	0x04, 0xc8, 0x2e, 0x4d, 0x80, 0x68, 0x20, 0x51, 0x43, 0xe6, 0x95, 0x26, 0x66, 0x19, 0xa3, 0x60,
	0xe3, 0x6c, 0x6b, 0xbf, 0x05, 0x9e, 0xc1, 0x37, 0x30, 0xfa, 0x42, 0x5e, 0xfa, 0x08, 0x06, 0x5f,
	0xc2, 0x4b, 0xb3, 0xb5, 0xe3, 0x8f, 0x99, 0xe6, 0x77, 0xb9, 0xee, 0x73, 0xbe, 0xe7, 0xb4, 0xe7,
	0x8b, 0x47, 0x8c, 0x6b, 0xaa, 0x78, 0x9c, 0xc6, 0x92, 0xf5, 0x80, 0x72, 0x10, 0xaa, 0xc7, 0xa9,
	0xde, 0x0b, 0xf5, 0x21, 0x4a, 0x04, 0xe7, 0x34, 0xd1, 0x4c, 0xf0, 0x88, 0x01, 0x55, 0x3b, 0x96,
	0xd0, 0xae, 0x54, 0x42, 0x0b, 0x52, 0x37, 0xa4, 0xe3, 0x95, 0xa8, 0x13, 0x91, 0xa6, 0x34, 0xd1,
	0x42, 0x19, 0xd6, 0xe9, 0x5f, 0xd1, 0x81, 0xaf, 0x85, 0x51, 0x78, 0x5f, 0x11, 0x7e, 0xf0, 0xca,
	0x10, 0xd3, 0x23, 0x30, 0xe7, 0x6b, 0xf1, 0x92, 0x02, 0xc4, 0x1b, 0x4a, 0x9e, 0xe2, 0x9b, 0x8a,
	0x6e, 0x18, 0x68, 0xaa, 0xda, 0xa8, 0x83, 0xfc, 0xc6, 0xa0, 0xd3, 0x35, 0x93, 0xbb, 0xd3, 0xc2,
	0x3d, 0xb4, 0x40, 0x48, 0x3f, 0x6d, 0x29, 0xe8, 0x59, 0x25, 0x3c, 0x6a, 0xc8, 0x10, 0x5f, 0xcb,
	0xec, 0xda, 0xd5, 0x5c, 0xfb, 0xb0, 0xd0, 0x96, 0x7a, 0xce, 0x2a, 0x61, 0x0e, 0x4f, 0xae, 0xe3,
	0xda, 0x47, 0xd8, 0x78, 0xdf, 0x10, 0x76, 0x2c, 0xf8, 0x3c, 0x15, 0x7b, 0x98, 0x0a, 0xae, 0x95,
	0x48, 0x8b, 0x68, 0xcf, 0xf0, 0x1d, 0xb9, 0x5d, 0xa6, 0x2c, 0x89, 0x98, 0x8c, 0xe2, 0xd5, 0x4a,
	0x51, 0x00, 0x0a, 0x36, 0xe5, 0xdd, 0xc2, 0x69, 0xbe, 0x18, 0x9b, 0x5f, 0x2f, 0x18, 0xe8, 0xf0,
	0xb6, 0x51, 0xcc, 0xe5, 0xb8, 0xe0, 0x49, 0x80, 0x1b, 0x4c, 0x46, 0xf6, 0x99, 0xc0, 0x06, 0x3d,
	0x93, 0xdb, 0x04, 0xb9, 0x1c, 0x33, 0x69, 0x3f, 0xc1, 0x7b, 0x87, 0x5b, 0x17, 0xb3, 0xc9, 0x13,
	0x7c, 0x8b, 0xc9, 0xdd, 0xe8, 0x22, 0x4a, 0xcd, 0xbf, 0x11, 0xb6, 0xb2, 0xd3, 0x93, 0x9f, 0xc1,
	0x82, 0x33, 0xac, 0xda, 0xa9, 0xf9, 0xf5, 0x1c, 0x0b, 0x8e, 0x98, 0xf7, 0x26, 0x1b, 0x7f, 0xe6,
	0x4d, 0x1e, 0xe1, 0x7c, 0xd0, 0x29, 0x69, 0x76, 0xd1, 0x66, 0xd8, 0xcc, 0x0e, 0x8b, 0x50, 0x16,
	0x0a, 0x2e, 0xaf, 0x63, 0xa0, 0xa0, 0x80, 0x06, 0x9f, 0xff, 0x55, 0xfa, 0x6b, 0xb3, 0x79, 0x84,
	0xe1, 0x7b, 0x8b, 0x2d, 0xbc, 0x2f, 0x65, 0xc8, 0xe3, 0xff, 0x76, 0x68, 0xcb, 0x71, 0xbc, 0xbf,
	0xa8, 0x92, 0x02, 0x7d, 0xd4, 0x47, 0x93, 0xfb, 0xdf, 0x0f, 0x2e, 0xfa, 0x71, 0x70, 0xd1, 0xcf,
	0x83, 0x8b, 0xbe, 0xfc, 0x72, 0x2b, 0x6f, 0xed, 0xc2, 0xff, 0x46, 0x68, 0x59, 0xcf, 0x97, 0x74,
	0xf8, 0x27, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x49, 0x22, 0xb5, 0x3a, 0x03, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// NetworkConnectionInfoServiceClient is the client API for NetworkConnectionInfoService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type NetworkConnectionInfoServiceClient interface {
	// Note: the response is a stream due to a bug in the C++ GRPC client library. The server is not expected to
	// send anything via this stream.
	PushNetworkConnectionInfo(ctx context.Context, opts ...grpc.CallOption) (NetworkConnectionInfoService_PushNetworkConnectionInfoClient, error)
}

type networkConnectionInfoServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewNetworkConnectionInfoServiceClient(cc grpc.ClientConnInterface) NetworkConnectionInfoServiceClient {
	return &networkConnectionInfoServiceClient{cc}
}

func (c *networkConnectionInfoServiceClient) PushNetworkConnectionInfo(ctx context.Context, opts ...grpc.CallOption) (NetworkConnectionInfoService_PushNetworkConnectionInfoClient, error) {
	stream, err := c.cc.NewStream(ctx, &_NetworkConnectionInfoService_serviceDesc.Streams[0], "/sensor.NetworkConnectionInfoService/PushNetworkConnectionInfo", opts...)
	if err != nil {
		return nil, err
	}
	x := &networkConnectionInfoServicePushNetworkConnectionInfoClient{stream}
	return x, nil
}

type NetworkConnectionInfoService_PushNetworkConnectionInfoClient interface {
	Send(*NetworkConnectionInfoMessage) error
	Recv() (*NetworkFlowsControlMessage, error)
	grpc.ClientStream
}

type networkConnectionInfoServicePushNetworkConnectionInfoClient struct {
	grpc.ClientStream
}

func (x *networkConnectionInfoServicePushNetworkConnectionInfoClient) Send(m *NetworkConnectionInfoMessage) error {
	return x.ClientStream.SendMsg(m)
}

func (x *networkConnectionInfoServicePushNetworkConnectionInfoClient) Recv() (*NetworkFlowsControlMessage, error) {
	m := new(NetworkFlowsControlMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// NetworkConnectionInfoServiceServer is the server API for NetworkConnectionInfoService service.
type NetworkConnectionInfoServiceServer interface {
	// Note: the response is a stream due to a bug in the C++ GRPC client library. The server is not expected to
	// send anything via this stream.
	PushNetworkConnectionInfo(NetworkConnectionInfoService_PushNetworkConnectionInfoServer) error
}

// UnimplementedNetworkConnectionInfoServiceServer can be embedded to have forward compatible implementations.
type UnimplementedNetworkConnectionInfoServiceServer struct {
}

func (*UnimplementedNetworkConnectionInfoServiceServer) PushNetworkConnectionInfo(srv NetworkConnectionInfoService_PushNetworkConnectionInfoServer) error {
	return status.Errorf(codes.Unimplemented, "method PushNetworkConnectionInfo not implemented")
}

func RegisterNetworkConnectionInfoServiceServer(s *grpc.Server, srv NetworkConnectionInfoServiceServer) {
	s.RegisterService(&_NetworkConnectionInfoService_serviceDesc, srv)
}

func _NetworkConnectionInfoService_PushNetworkConnectionInfo_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(NetworkConnectionInfoServiceServer).PushNetworkConnectionInfo(&networkConnectionInfoServicePushNetworkConnectionInfoServer{stream})
}

type NetworkConnectionInfoService_PushNetworkConnectionInfoServer interface {
	Send(*NetworkFlowsControlMessage) error
	Recv() (*NetworkConnectionInfoMessage, error)
	grpc.ServerStream
}

type networkConnectionInfoServicePushNetworkConnectionInfoServer struct {
	grpc.ServerStream
}

func (x *networkConnectionInfoServicePushNetworkConnectionInfoServer) Send(m *NetworkFlowsControlMessage) error {
	return x.ServerStream.SendMsg(m)
}

func (x *networkConnectionInfoServicePushNetworkConnectionInfoServer) Recv() (*NetworkConnectionInfoMessage, error) {
	m := new(NetworkConnectionInfoMessage)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _NetworkConnectionInfoService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "sensor.NetworkConnectionInfoService",
	HandlerType: (*NetworkConnectionInfoServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "PushNetworkConnectionInfo",
			Handler:       _NetworkConnectionInfoService_PushNetworkConnectionInfo_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "internalapi/sensor/network_connection_iservice.proto",
}

func (m *NetworkConnectionInfoMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkConnectionInfoMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkConnectionInfoMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Msg != nil {
		{
			size := m.Msg.Size()
			i -= size
			if _, err := m.Msg.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *NetworkConnectionInfoMessage_Register) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkConnectionInfoMessage_Register) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Register != nil {
		{
			size, err := m.Register.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkConnectionIservice(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *NetworkConnectionInfoMessage_Info) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkConnectionInfoMessage_Info) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Info != nil {
		{
			size, err := m.Info.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkConnectionIservice(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *NetworkFlowsControlMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkFlowsControlMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkFlowsControlMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IpNetworks != nil {
		{
			size, err := m.IpNetworks.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkConnectionIservice(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.PublicIpAddresses != nil {
		{
			size, err := m.PublicIpAddresses.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkConnectionIservice(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IPAddressList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IPAddressList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IPAddressList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Ipv6Addresses) > 0 {
		for iNdEx := len(m.Ipv6Addresses) - 1; iNdEx >= 0; iNdEx-- {
			i -= 8
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.Ipv6Addresses[iNdEx]))
		}
		i = encodeVarintNetworkConnectionIservice(dAtA, i, uint64(len(m.Ipv6Addresses)*8))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Ipv4Addresses) > 0 {
		for iNdEx := len(m.Ipv4Addresses) - 1; iNdEx >= 0; iNdEx-- {
			i -= 4
			encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(m.Ipv4Addresses[iNdEx]))
		}
		i = encodeVarintNetworkConnectionIservice(dAtA, i, uint64(len(m.Ipv4Addresses)*4))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IPNetworkList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IPNetworkList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IPNetworkList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Ipv6Networks) > 0 {
		i -= len(m.Ipv6Networks)
		copy(dAtA[i:], m.Ipv6Networks)
		i = encodeVarintNetworkConnectionIservice(dAtA, i, uint64(len(m.Ipv6Networks)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Ipv4Networks) > 0 {
		i -= len(m.Ipv4Networks)
		copy(dAtA[i:], m.Ipv4Networks)
		i = encodeVarintNetworkConnectionIservice(dAtA, i, uint64(len(m.Ipv4Networks)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintNetworkConnectionIservice(dAtA []byte, offset int, v uint64) int {
	offset -= sovNetworkConnectionIservice(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *NetworkConnectionInfoMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Msg != nil {
		n += m.Msg.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkConnectionInfoMessage_Register) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Register != nil {
		l = m.Register.Size()
		n += 1 + l + sovNetworkConnectionIservice(uint64(l))
	}
	return n
}
func (m *NetworkConnectionInfoMessage_Info) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Info != nil {
		l = m.Info.Size()
		n += 1 + l + sovNetworkConnectionIservice(uint64(l))
	}
	return n
}
func (m *NetworkFlowsControlMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PublicIpAddresses != nil {
		l = m.PublicIpAddresses.Size()
		n += 1 + l + sovNetworkConnectionIservice(uint64(l))
	}
	if m.IpNetworks != nil {
		l = m.IpNetworks.Size()
		n += 1 + l + sovNetworkConnectionIservice(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IPAddressList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Ipv4Addresses) > 0 {
		n += 1 + sovNetworkConnectionIservice(uint64(len(m.Ipv4Addresses)*4)) + len(m.Ipv4Addresses)*4
	}
	if len(m.Ipv6Addresses) > 0 {
		n += 1 + sovNetworkConnectionIservice(uint64(len(m.Ipv6Addresses)*8)) + len(m.Ipv6Addresses)*8
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IPNetworkList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Ipv4Networks)
	if l > 0 {
		n += 1 + l + sovNetworkConnectionIservice(uint64(l))
	}
	l = len(m.Ipv6Networks)
	if l > 0 {
		n += 1 + l + sovNetworkConnectionIservice(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovNetworkConnectionIservice(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozNetworkConnectionIservice(x uint64) (n int) {
	return sovNetworkConnectionIservice(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *NetworkConnectionInfoMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkConnectionIservice
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkConnectionInfoMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkConnectionInfoMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Register", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionIservice
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkConnectionIservice
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkConnectionIservice
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CollectorRegisterRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Msg = &NetworkConnectionInfoMessage_Register{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionIservice
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkConnectionIservice
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkConnectionIservice
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &NetworkConnectionInfo{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Msg = &NetworkConnectionInfoMessage_Info{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkConnectionIservice(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkConnectionIservice
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkFlowsControlMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkConnectionIservice
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkFlowsControlMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkFlowsControlMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PublicIpAddresses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionIservice
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkConnectionIservice
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkConnectionIservice
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PublicIpAddresses == nil {
				m.PublicIpAddresses = &IPAddressList{}
			}
			if err := m.PublicIpAddresses.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IpNetworks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionIservice
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkConnectionIservice
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkConnectionIservice
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IpNetworks == nil {
				m.IpNetworks = &IPNetworkList{}
			}
			if err := m.IpNetworks.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkConnectionIservice(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkConnectionIservice
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IPAddressList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkConnectionIservice
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IPAddressList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IPAddressList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 5 {
				var v uint32
				if (iNdEx + 4) > l {
					return io.ErrUnexpectedEOF
				}
				v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
				iNdEx += 4
				m.Ipv4Addresses = append(m.Ipv4Addresses, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowNetworkConnectionIservice
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthNetworkConnectionIservice
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthNetworkConnectionIservice
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				elementCount = packedLen / 4
				if elementCount != 0 && len(m.Ipv4Addresses) == 0 {
					m.Ipv4Addresses = make([]uint32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint32
					if (iNdEx + 4) > l {
						return io.ErrUnexpectedEOF
					}
					v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
					iNdEx += 4
					m.Ipv4Addresses = append(m.Ipv4Addresses, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Ipv4Addresses", wireType)
			}
		case 2:
			if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				m.Ipv6Addresses = append(m.Ipv6Addresses, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowNetworkConnectionIservice
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthNetworkConnectionIservice
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthNetworkConnectionIservice
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				elementCount = packedLen / 8
				if elementCount != 0 && len(m.Ipv6Addresses) == 0 {
					m.Ipv6Addresses = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					m.Ipv6Addresses = append(m.Ipv6Addresses, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Ipv6Addresses", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkConnectionIservice(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkConnectionIservice
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IPNetworkList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkConnectionIservice
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IPNetworkList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IPNetworkList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ipv4Networks", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionIservice
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthNetworkConnectionIservice
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkConnectionIservice
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ipv4Networks = append(m.Ipv4Networks[:0], dAtA[iNdEx:postIndex]...)
			if m.Ipv4Networks == nil {
				m.Ipv4Networks = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ipv6Networks", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkConnectionIservice
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthNetworkConnectionIservice
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkConnectionIservice
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ipv6Networks = append(m.Ipv6Networks[:0], dAtA[iNdEx:postIndex]...)
			if m.Ipv6Networks == nil {
				m.Ipv6Networks = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkConnectionIservice(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkConnectionIservice
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipNetworkConnectionIservice(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowNetworkConnectionIservice
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNetworkConnectionIservice
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNetworkConnectionIservice
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthNetworkConnectionIservice
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupNetworkConnectionIservice
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthNetworkConnectionIservice
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthNetworkConnectionIservice        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowNetworkConnectionIservice          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupNetworkConnectionIservice = fmt.Errorf("proto: unexpected end of group")
)
