// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: shared/license/license.proto

package licenseproto

import (
	fmt "fmt"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type License struct {
	Metadata             *License_Metadata     `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	SupportContact       *License_Contact      `protobuf:"bytes,2,opt,name=support_contact,json=supportContact,proto3" json:"support_contact,omitempty"`
	Restrictions         *License_Restrictions `protobuf:"bytes,3,opt,name=restrictions,proto3" json:"restrictions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *License) Reset()         { *m = License{} }
func (m *License) String() string { return proto.CompactTextString(m) }
func (*License) ProtoMessage()    {}
func (*License) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d66812ae03ea278, []int{0}
}
func (m *License) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *License) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_License.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *License) XXX_Merge(src proto.Message) {
	xxx_messageInfo_License.Merge(m, src)
}
func (m *License) XXX_Size() int {
	return m.Size()
}
func (m *License) XXX_DiscardUnknown() {
	xxx_messageInfo_License.DiscardUnknown(m)
}

var xxx_messageInfo_License proto.InternalMessageInfo

func (m *License) GetMetadata() *License_Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *License) GetSupportContact() *License_Contact {
	if m != nil {
		return m.SupportContact
	}
	return nil
}

func (m *License) GetRestrictions() *License_Restrictions {
	if m != nil {
		return m.Restrictions
	}
	return nil
}

func (m *License) MessageClone() proto.Message {
	return m.Clone()
}
func (m *License) Clone() *License {
	if m == nil {
		return nil
	}
	cloned := new(License)
	*cloned = *m

	cloned.Metadata = m.Metadata.Clone()
	cloned.SupportContact = m.SupportContact.Clone()
	cloned.Restrictions = m.Restrictions.Clone()
	return cloned
}

type License_Contact struct {
	Phone                string   `protobuf:"bytes,1,opt,name=phone,proto3" json:"phone,omitempty"`
	Email                string   `protobuf:"bytes,2,opt,name=email,proto3" json:"email,omitempty"`
	Url                  string   `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
	Name                 string   `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *License_Contact) Reset()         { *m = License_Contact{} }
func (m *License_Contact) String() string { return proto.CompactTextString(m) }
func (*License_Contact) ProtoMessage()    {}
func (*License_Contact) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d66812ae03ea278, []int{0, 0}
}
func (m *License_Contact) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *License_Contact) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_License_Contact.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *License_Contact) XXX_Merge(src proto.Message) {
	xxx_messageInfo_License_Contact.Merge(m, src)
}
func (m *License_Contact) XXX_Size() int {
	return m.Size()
}
func (m *License_Contact) XXX_DiscardUnknown() {
	xxx_messageInfo_License_Contact.DiscardUnknown(m)
}

var xxx_messageInfo_License_Contact proto.InternalMessageInfo

func (m *License_Contact) GetPhone() string {
	if m != nil {
		return m.Phone
	}
	return ""
}

func (m *License_Contact) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

func (m *License_Contact) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *License_Contact) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *License_Contact) MessageClone() proto.Message {
	return m.Clone()
}
func (m *License_Contact) Clone() *License_Contact {
	if m == nil {
		return nil
	}
	cloned := new(License_Contact)
	*cloned = *m

	return cloned
}

type License_Metadata struct {
	Id                   string           `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	SigningKeyId         string           `protobuf:"bytes,2,opt,name=signing_key_id,json=signingKeyId,proto3" json:"signing_key_id,omitempty"`
	IssueDate            *types.Timestamp `protobuf:"bytes,3,opt,name=issue_date,json=issueDate,proto3" json:"issue_date,omitempty"`
	LicensedForId        string           `protobuf:"bytes,4,opt,name=licensed_for_id,json=licensedForId,proto3" json:"licensed_for_id,omitempty"`
	LicensedForName      string           `protobuf:"bytes,5,opt,name=licensed_for_name,json=licensedForName,proto3" json:"licensed_for_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *License_Metadata) Reset()         { *m = License_Metadata{} }
func (m *License_Metadata) String() string { return proto.CompactTextString(m) }
func (*License_Metadata) ProtoMessage()    {}
func (*License_Metadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d66812ae03ea278, []int{0, 1}
}
func (m *License_Metadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *License_Metadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_License_Metadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *License_Metadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_License_Metadata.Merge(m, src)
}
func (m *License_Metadata) XXX_Size() int {
	return m.Size()
}
func (m *License_Metadata) XXX_DiscardUnknown() {
	xxx_messageInfo_License_Metadata.DiscardUnknown(m)
}

var xxx_messageInfo_License_Metadata proto.InternalMessageInfo

func (m *License_Metadata) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *License_Metadata) GetSigningKeyId() string {
	if m != nil {
		return m.SigningKeyId
	}
	return ""
}

func (m *License_Metadata) GetIssueDate() *types.Timestamp {
	if m != nil {
		return m.IssueDate
	}
	return nil
}

func (m *License_Metadata) GetLicensedForId() string {
	if m != nil {
		return m.LicensedForId
	}
	return ""
}

func (m *License_Metadata) GetLicensedForName() string {
	if m != nil {
		return m.LicensedForName
	}
	return ""
}

func (m *License_Metadata) MessageClone() proto.Message {
	return m.Clone()
}
func (m *License_Metadata) Clone() *License_Metadata {
	if m == nil {
		return nil
	}
	cloned := new(License_Metadata)
	*cloned = *m

	cloned.IssueDate = m.IssueDate.Clone()
	return cloned
}

type License_Restrictions struct {
	NotValidBefore *types.Timestamp `protobuf:"bytes,1,opt,name=not_valid_before,json=notValidBefore,proto3" json:"not_valid_before,omitempty"`
	NotValidAfter  *types.Timestamp `protobuf:"bytes,2,opt,name=not_valid_after,json=notValidAfter,proto3" json:"not_valid_after,omitempty"`
	// URL for on-line license enforcement. Must be set unless allow_offline is true.
	EnforcementUrl string `protobuf:"bytes,3,opt,name=enforcement_url,json=enforcementUrl,proto3" json:"enforcement_url,omitempty"`
	// Allow offline use (i.e., no online license enforcement).
	AllowOffline bool `protobuf:"varint,4,opt,name=allow_offline,json=allowOffline,proto3" json:"allow_offline,omitempty"`
	// Maximum number of nodes. Must be set unless no_node_restriction is true.
	MaxNodes int32 `protobuf:"varint,5,opt,name=max_nodes,json=maxNodes,proto3" json:"max_nodes,omitempty"`
	// Do not restrict the number of nodes.
	NoNodeRestriction bool `protobuf:"varint,6,opt,name=no_node_restriction,json=noNodeRestriction,proto3" json:"no_node_restriction,omitempty"`
	// Build flavors of the product this license is valid for (e.g., "development" or "release"). Must be set unless
	// no_build_flavor_restriction is true.
	BuildFlavors []string `protobuf:"bytes,7,rep,name=build_flavors,json=buildFlavors,proto3" json:"build_flavors,omitempty"`
	// Do not restrict license to certain build flavors.
	NoBuildFlavorRestriction bool `protobuf:"varint,8,opt,name=no_build_flavor_restriction,json=noBuildFlavorRestriction,proto3" json:"no_build_flavor_restriction,omitempty"`
	// Deployment environments that are valid for the product, such as `gcp` or `gcp/ultra-current-825`. Must be
	// set unless no_deployment_environment_restriction is true.
	DeploymentEnvironments []string `protobuf:"bytes,9,rep,name=deployment_environments,json=deploymentEnvironments,proto3" json:"deployment_environments,omitempty"`
	// Do not restrict license to certain deployment environments.
	NoDeploymentEnvironmentRestriction bool     `protobuf:"varint,10,opt,name=no_deployment_environment_restriction,json=noDeploymentEnvironmentRestriction,proto3" json:"no_deployment_environment_restriction,omitempty"`
	XXX_NoUnkeyedLiteral               struct{} `json:"-"`
	XXX_unrecognized                   []byte   `json:"-"`
	XXX_sizecache                      int32    `json:"-"`
}

func (m *License_Restrictions) Reset()         { *m = License_Restrictions{} }
func (m *License_Restrictions) String() string { return proto.CompactTextString(m) }
func (*License_Restrictions) ProtoMessage()    {}
func (*License_Restrictions) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d66812ae03ea278, []int{0, 2}
}
func (m *License_Restrictions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *License_Restrictions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_License_Restrictions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *License_Restrictions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_License_Restrictions.Merge(m, src)
}
func (m *License_Restrictions) XXX_Size() int {
	return m.Size()
}
func (m *License_Restrictions) XXX_DiscardUnknown() {
	xxx_messageInfo_License_Restrictions.DiscardUnknown(m)
}

var xxx_messageInfo_License_Restrictions proto.InternalMessageInfo

func (m *License_Restrictions) GetNotValidBefore() *types.Timestamp {
	if m != nil {
		return m.NotValidBefore
	}
	return nil
}

func (m *License_Restrictions) GetNotValidAfter() *types.Timestamp {
	if m != nil {
		return m.NotValidAfter
	}
	return nil
}

func (m *License_Restrictions) GetEnforcementUrl() string {
	if m != nil {
		return m.EnforcementUrl
	}
	return ""
}

func (m *License_Restrictions) GetAllowOffline() bool {
	if m != nil {
		return m.AllowOffline
	}
	return false
}

func (m *License_Restrictions) GetMaxNodes() int32 {
	if m != nil {
		return m.MaxNodes
	}
	return 0
}

func (m *License_Restrictions) GetNoNodeRestriction() bool {
	if m != nil {
		return m.NoNodeRestriction
	}
	return false
}

func (m *License_Restrictions) GetBuildFlavors() []string {
	if m != nil {
		return m.BuildFlavors
	}
	return nil
}

func (m *License_Restrictions) GetNoBuildFlavorRestriction() bool {
	if m != nil {
		return m.NoBuildFlavorRestriction
	}
	return false
}

func (m *License_Restrictions) GetDeploymentEnvironments() []string {
	if m != nil {
		return m.DeploymentEnvironments
	}
	return nil
}

func (m *License_Restrictions) GetNoDeploymentEnvironmentRestriction() bool {
	if m != nil {
		return m.NoDeploymentEnvironmentRestriction
	}
	return false
}

func (m *License_Restrictions) MessageClone() proto.Message {
	return m.Clone()
}
func (m *License_Restrictions) Clone() *License_Restrictions {
	if m == nil {
		return nil
	}
	cloned := new(License_Restrictions)
	*cloned = *m

	cloned.NotValidBefore = m.NotValidBefore.Clone()
	cloned.NotValidAfter = m.NotValidAfter.Clone()
	if m.BuildFlavors != nil {
		cloned.BuildFlavors = make([]string, len(m.BuildFlavors))
		copy(cloned.BuildFlavors, m.BuildFlavors)
	}
	if m.DeploymentEnvironments != nil {
		cloned.DeploymentEnvironments = make([]string, len(m.DeploymentEnvironments))
		copy(cloned.DeploymentEnvironments, m.DeploymentEnvironments)
	}
	return cloned
}

func init() {
	proto.RegisterType((*License)(nil), "license.License")
	proto.RegisterType((*License_Contact)(nil), "license.License.Contact")
	proto.RegisterType((*License_Metadata)(nil), "license.License.Metadata")
	proto.RegisterType((*License_Restrictions)(nil), "license.License.Restrictions")
}

func init() { proto.RegisterFile("shared/license/license.proto", fileDescriptor_0d66812ae03ea278) }

var fileDescriptor_0d66812ae03ea278 = []byte{
	// 614 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x52, 0xcd, 0x6e, 0x13, 0x31,
	0x10, 0x26, 0xfd, 0x4b, 0x32, 0xa4, 0x49, 0x6b, 0x10, 0x2c, 0x29, 0x84, 0xaa, 0xfc, 0x8a, 0xc3,
	0x56, 0x80, 0x10, 0x70, 0xe0, 0xd0, 0x50, 0x2a, 0x55, 0x40, 0x11, 0x2b, 0xe0, 0x00, 0x07, 0xcb,
	0x5d, 0x7b, 0x53, 0xab, 0xbb, 0x9e, 0x95, 0xed, 0x84, 0xf6, 0x4d, 0x90, 0x38, 0xf2, 0x32, 0xdc,
	0xe0, 0x11, 0x50, 0x79, 0x11, 0xb4, 0x5e, 0x2f, 0xd9, 0xa8, 0x55, 0x4f, 0xf6, 0x7c, 0xfe, 0xbe,
	0x6f, 0x66, 0x3c, 0x03, 0xd7, 0xcd, 0x01, 0xd3, 0x82, 0x6f, 0xa6, 0x32, 0x16, 0xca, 0x88, 0xea,
	0x0c, 0x73, 0x8d, 0x16, 0x49, 0xd3, 0x87, 0xfd, 0x9b, 0x23, 0xc4, 0x51, 0x2a, 0x36, 0x1d, 0xbc,
	0x3f, 0x4e, 0x36, 0xad, 0xcc, 0x84, 0xb1, 0x2c, 0xcb, 0x4b, 0xe6, 0xc6, 0xf7, 0x16, 0x34, 0xdf,
	0x94, 0x64, 0xf2, 0x04, 0x5a, 0x99, 0xb0, 0x8c, 0x33, 0xcb, 0x82, 0xc6, 0x7a, 0xe3, 0xfe, 0xc5,
	0x47, 0xd7, 0xc2, 0xca, 0xd7, 0x73, 0xc2, 0xb7, 0x9e, 0x10, 0xfd, 0xa7, 0x92, 0x2d, 0xe8, 0x99,
	0x71, 0x9e, 0xa3, 0xb6, 0x34, 0x46, 0x65, 0x59, 0x6c, 0x83, 0x39, 0xa7, 0x0e, 0x4e, 0xa9, 0x5f,
	0x96, 0xef, 0x51, 0xd7, 0x0b, 0x7c, 0x4c, 0xb6, 0xa0, 0xa3, 0x85, 0xb1, 0x5a, 0xc6, 0x56, 0xa2,
	0x32, 0xc1, 0xbc, 0xd3, 0xdf, 0x38, 0xa5, 0x8f, 0x6a, 0xa4, 0x68, 0x46, 0xd2, 0xff, 0x02, 0xcd,
	0xca, 0xed, 0x32, 0x2c, 0xe6, 0x07, 0xa8, 0x84, 0x6b, 0xa2, 0x1d, 0x95, 0x41, 0x81, 0x8a, 0x8c,
	0xc9, 0xd4, 0x15, 0xd7, 0x8e, 0xca, 0x80, 0xac, 0xc0, 0xfc, 0x58, 0xa7, 0x2e, 0x61, 0x3b, 0x2a,
	0xae, 0x84, 0xc0, 0x82, 0x62, 0x99, 0x08, 0x16, 0x1c, 0xe4, 0xee, 0xfd, 0x5f, 0x0d, 0x68, 0x55,
	0x9d, 0x93, 0x2e, 0xcc, 0x49, 0xee, 0xbd, 0xe7, 0x24, 0x27, 0xb7, 0xa1, 0x6b, 0xe4, 0x48, 0x49,
	0x35, 0xa2, 0x87, 0xe2, 0x98, 0x4a, 0xee, 0x33, 0x74, 0x3c, 0xfa, 0x5a, 0x1c, 0xef, 0x72, 0xf2,
	0x1c, 0x40, 0x1a, 0x33, 0x16, 0x94, 0x33, 0x2b, 0x7c, 0x83, 0xfd, 0xb0, 0x1c, 0x4f, 0x58, 0x8d,
	0x27, 0xfc, 0x50, 0x8d, 0x27, 0x6a, 0x3b, 0xf6, 0x36, 0xb3, 0x82, 0xdc, 0x85, 0x9e, 0xff, 0x08,
	0x4e, 0x13, 0xd4, 0x45, 0x86, 0xb2, 0xb8, 0xe5, 0x0a, 0xde, 0x41, 0xbd, 0xcb, 0xc9, 0x03, 0x58,
	0x9d, 0xe1, 0xb9, 0x36, 0x16, 0x1d, 0xb3, 0x57, 0x63, 0xee, 0x15, 0x1d, 0xfd, 0x58, 0x80, 0x4e,
	0xfd, 0x37, 0xc9, 0x36, 0xac, 0x28, 0xb4, 0x74, 0xc2, 0x52, 0xc9, 0xe9, 0xbe, 0x48, 0x50, 0x0b,
	0xbf, 0x04, 0xe7, 0x55, 0xd9, 0x55, 0x68, 0x3f, 0x15, 0x92, 0xa1, 0x53, 0x90, 0x21, 0xf4, 0xa6,
	0x2e, 0x2c, 0xb1, 0x42, 0xfb, 0x5d, 0x38, 0xcf, 0x64, 0xb9, 0x32, 0xd9, 0x2a, 0x04, 0xe4, 0x1e,
	0xf4, 0x84, 0x4a, 0x50, 0xc7, 0x22, 0x13, 0xca, 0xd2, 0xe9, 0x78, 0xba, 0x35, 0xf8, 0xa3, 0x4e,
	0xc9, 0x2d, 0x58, 0x66, 0x69, 0x8a, 0x5f, 0x29, 0x26, 0x49, 0x2a, 0x55, 0x39, 0xb2, 0x56, 0xd4,
	0x71, 0xe0, 0xbb, 0x12, 0x23, 0x6b, 0xd0, 0xce, 0xd8, 0x11, 0x55, 0xc8, 0x85, 0x71, 0x9f, 0xb1,
	0x18, 0xb5, 0x32, 0x76, 0xb4, 0x57, 0xc4, 0x24, 0x84, 0x4b, 0x0a, 0xdd, 0x1b, 0xad, 0x2d, 0x53,
	0xb0, 0xe4, 0x7c, 0x56, 0x15, 0x16, 0xac, 0xda, 0x2f, 0x15, 0x19, 0xf7, 0xc7, 0x32, 0xe5, 0x34,
	0x49, 0xd9, 0x04, 0xb5, 0x09, 0x9a, 0xeb, 0xf3, 0xc5, 0xa4, 0x1d, 0xb8, 0x53, 0x62, 0xe4, 0x05,
	0xac, 0x29, 0xa4, 0x75, 0xde, 0x8c, 0x79, 0xcb, 0x99, 0x07, 0x0a, 0x87, 0x53, 0x51, 0x3d, 0xc7,
	0x53, 0xb8, 0xca, 0x45, 0x9e, 0xe2, 0xb1, 0xeb, 0x5e, 0xa8, 0x89, 0xd4, 0xa8, 0x8a, 0xbb, 0x09,
	0xda, 0x2e, 0xdb, 0x95, 0xe9, 0xf3, 0xab, 0xda, 0x2b, 0x79, 0x0f, 0x77, 0x14, 0xd2, 0xb3, 0xb5,
	0x33, 0x15, 0x80, 0xab, 0x60, 0x43, 0xe1, 0xf6, 0x59, 0x46, 0xb5, 0x5a, 0x86, 0xcf, 0x7e, 0x9e,
	0x0c, 0x1a, 0xbf, 0x4f, 0x06, 0x8d, 0x3f, 0x27, 0x83, 0xc6, 0xb7, 0xbf, 0x83, 0x0b, 0x10, 0x48,
	0x0c, 0x8d, 0x65, 0xf1, 0xa1, 0xc6, 0xa3, 0x72, 0x96, 0x21, 0xcb, 0x65, 0x38, 0x79, 0xf8, 0xb9,
	0xe3, 0x57, 0xac, 0x1c, 0xf0, 0x92, 0x3b, 0x1e, 0xff, 0x0b, 0x00, 0x00, 0xff, 0xff, 0x0f, 0x90,
	0x48, 0x79, 0xa8, 0x04, 0x00, 0x00,
}

func (m *License) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *License) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *License) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Restrictions != nil {
		{
			size, err := m.Restrictions.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintLicense(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.SupportContact != nil {
		{
			size, err := m.SupportContact.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintLicense(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintLicense(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *License_Contact) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *License_Contact) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *License_Contact) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintLicense(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintLicense(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Email) > 0 {
		i -= len(m.Email)
		copy(dAtA[i:], m.Email)
		i = encodeVarintLicense(dAtA, i, uint64(len(m.Email)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Phone) > 0 {
		i -= len(m.Phone)
		copy(dAtA[i:], m.Phone)
		i = encodeVarintLicense(dAtA, i, uint64(len(m.Phone)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *License_Metadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *License_Metadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *License_Metadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.LicensedForName) > 0 {
		i -= len(m.LicensedForName)
		copy(dAtA[i:], m.LicensedForName)
		i = encodeVarintLicense(dAtA, i, uint64(len(m.LicensedForName)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.LicensedForId) > 0 {
		i -= len(m.LicensedForId)
		copy(dAtA[i:], m.LicensedForId)
		i = encodeVarintLicense(dAtA, i, uint64(len(m.LicensedForId)))
		i--
		dAtA[i] = 0x22
	}
	if m.IssueDate != nil {
		{
			size, err := m.IssueDate.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintLicense(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.SigningKeyId) > 0 {
		i -= len(m.SigningKeyId)
		copy(dAtA[i:], m.SigningKeyId)
		i = encodeVarintLicense(dAtA, i, uint64(len(m.SigningKeyId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintLicense(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *License_Restrictions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *License_Restrictions) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *License_Restrictions) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.NoDeploymentEnvironmentRestriction {
		i--
		if m.NoDeploymentEnvironmentRestriction {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if len(m.DeploymentEnvironments) > 0 {
		for iNdEx := len(m.DeploymentEnvironments) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.DeploymentEnvironments[iNdEx])
			copy(dAtA[i:], m.DeploymentEnvironments[iNdEx])
			i = encodeVarintLicense(dAtA, i, uint64(len(m.DeploymentEnvironments[iNdEx])))
			i--
			dAtA[i] = 0x4a
		}
	}
	if m.NoBuildFlavorRestriction {
		i--
		if m.NoBuildFlavorRestriction {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if len(m.BuildFlavors) > 0 {
		for iNdEx := len(m.BuildFlavors) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.BuildFlavors[iNdEx])
			copy(dAtA[i:], m.BuildFlavors[iNdEx])
			i = encodeVarintLicense(dAtA, i, uint64(len(m.BuildFlavors[iNdEx])))
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.NoNodeRestriction {
		i--
		if m.NoNodeRestriction {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.MaxNodes != 0 {
		i = encodeVarintLicense(dAtA, i, uint64(m.MaxNodes))
		i--
		dAtA[i] = 0x28
	}
	if m.AllowOffline {
		i--
		if m.AllowOffline {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.EnforcementUrl) > 0 {
		i -= len(m.EnforcementUrl)
		copy(dAtA[i:], m.EnforcementUrl)
		i = encodeVarintLicense(dAtA, i, uint64(len(m.EnforcementUrl)))
		i--
		dAtA[i] = 0x1a
	}
	if m.NotValidAfter != nil {
		{
			size, err := m.NotValidAfter.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintLicense(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.NotValidBefore != nil {
		{
			size, err := m.NotValidBefore.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintLicense(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintLicense(dAtA []byte, offset int, v uint64) int {
	offset -= sovLicense(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *License) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovLicense(uint64(l))
	}
	if m.SupportContact != nil {
		l = m.SupportContact.Size()
		n += 1 + l + sovLicense(uint64(l))
	}
	if m.Restrictions != nil {
		l = m.Restrictions.Size()
		n += 1 + l + sovLicense(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *License_Contact) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Phone)
	if l > 0 {
		n += 1 + l + sovLicense(uint64(l))
	}
	l = len(m.Email)
	if l > 0 {
		n += 1 + l + sovLicense(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovLicense(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovLicense(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *License_Metadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovLicense(uint64(l))
	}
	l = len(m.SigningKeyId)
	if l > 0 {
		n += 1 + l + sovLicense(uint64(l))
	}
	if m.IssueDate != nil {
		l = m.IssueDate.Size()
		n += 1 + l + sovLicense(uint64(l))
	}
	l = len(m.LicensedForId)
	if l > 0 {
		n += 1 + l + sovLicense(uint64(l))
	}
	l = len(m.LicensedForName)
	if l > 0 {
		n += 1 + l + sovLicense(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *License_Restrictions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NotValidBefore != nil {
		l = m.NotValidBefore.Size()
		n += 1 + l + sovLicense(uint64(l))
	}
	if m.NotValidAfter != nil {
		l = m.NotValidAfter.Size()
		n += 1 + l + sovLicense(uint64(l))
	}
	l = len(m.EnforcementUrl)
	if l > 0 {
		n += 1 + l + sovLicense(uint64(l))
	}
	if m.AllowOffline {
		n += 2
	}
	if m.MaxNodes != 0 {
		n += 1 + sovLicense(uint64(m.MaxNodes))
	}
	if m.NoNodeRestriction {
		n += 2
	}
	if len(m.BuildFlavors) > 0 {
		for _, s := range m.BuildFlavors {
			l = len(s)
			n += 1 + l + sovLicense(uint64(l))
		}
	}
	if m.NoBuildFlavorRestriction {
		n += 2
	}
	if len(m.DeploymentEnvironments) > 0 {
		for _, s := range m.DeploymentEnvironments {
			l = len(s)
			n += 1 + l + sovLicense(uint64(l))
		}
	}
	if m.NoDeploymentEnvironmentRestriction {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovLicense(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozLicense(x uint64) (n int) {
	return sovLicense(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *License) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLicense
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: License: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: License: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLicense
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLicense
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &License_Metadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SupportContact", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLicense
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLicense
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SupportContact == nil {
				m.SupportContact = &License_Contact{}
			}
			if err := m.SupportContact.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Restrictions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLicense
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLicense
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Restrictions == nil {
				m.Restrictions = &License_Restrictions{}
			}
			if err := m.Restrictions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLicense(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLicense
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *License_Contact) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLicense
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Contact: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Contact: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Phone", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLicense
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLicense
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Phone = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Email", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLicense
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLicense
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Email = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLicense
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLicense
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLicense
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLicense
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLicense(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLicense
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *License_Metadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLicense
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Metadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Metadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLicense
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLicense
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SigningKeyId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLicense
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLicense
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SigningKeyId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IssueDate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLicense
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLicense
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IssueDate == nil {
				m.IssueDate = &types.Timestamp{}
			}
			if err := m.IssueDate.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LicensedForId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLicense
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLicense
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LicensedForId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LicensedForName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLicense
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLicense
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LicensedForName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLicense(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLicense
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *License_Restrictions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLicense
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Restrictions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Restrictions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotValidBefore", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLicense
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLicense
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NotValidBefore == nil {
				m.NotValidBefore = &types.Timestamp{}
			}
			if err := m.NotValidBefore.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotValidAfter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLicense
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLicense
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NotValidAfter == nil {
				m.NotValidAfter = &types.Timestamp{}
			}
			if err := m.NotValidAfter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnforcementUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLicense
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLicense
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EnforcementUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowOffline", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AllowOffline = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxNodes", wireType)
			}
			m.MaxNodes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxNodes |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoNodeRestriction", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoNodeRestriction = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BuildFlavors", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLicense
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLicense
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BuildFlavors = append(m.BuildFlavors, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoBuildFlavorRestriction", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoBuildFlavorRestriction = bool(v != 0)
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentEnvironments", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLicense
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLicense
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentEnvironments = append(m.DeploymentEnvironments, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoDeploymentEnvironmentRestriction", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoDeploymentEnvironmentRestriction = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipLicense(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLicense
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipLicense(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowLicense
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowLicense
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthLicense
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupLicense
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthLicense
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthLicense        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowLicense          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupLicense = fmt.Errorf("proto: unexpected end of group")
)
