// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/alert.proto

package storage

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ViolationState int32

const (
	ViolationState_ACTIVE    ViolationState = 0
	ViolationState_SNOOZED   ViolationState = 1
	ViolationState_RESOLVED  ViolationState = 2
	ViolationState_ATTEMPTED ViolationState = 3
)

var ViolationState_name = map[int32]string{
	0: "ACTIVE",
	1: "SNOOZED",
	2: "RESOLVED",
	3: "ATTEMPTED",
}

var ViolationState_value = map[string]int32{
	"ACTIVE":    0,
	"SNOOZED":   1,
	"RESOLVED":  2,
	"ATTEMPTED": 3,
}

func (x ViolationState) String() string {
	return proto.EnumName(ViolationState_name, int32(x))
}

func (ViolationState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{0}
}

type Alert_Resource_ResourceType int32

const (
	Alert_Resource_UNKNOWN    Alert_Resource_ResourceType = 0
	Alert_Resource_SECRETS    Alert_Resource_ResourceType = 1
	Alert_Resource_CONFIGMAPS Alert_Resource_ResourceType = 2
)

var Alert_Resource_ResourceType_name = map[int32]string{
	0: "UNKNOWN",
	1: "SECRETS",
	2: "CONFIGMAPS",
}

var Alert_Resource_ResourceType_value = map[string]int32{
	"UNKNOWN":    0,
	"SECRETS":    1,
	"CONFIGMAPS": 2,
}

func (x Alert_Resource_ResourceType) String() string {
	return proto.EnumName(Alert_Resource_ResourceType_name, int32(x))
}

func (Alert_Resource_ResourceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{0, 1, 0}
}

type Alert_Violation_Type int32

const (
	Alert_Violation_GENERIC      Alert_Violation_Type = 0
	Alert_Violation_K8S_EVENT    Alert_Violation_Type = 1
	Alert_Violation_NETWORK_FLOW Alert_Violation_Type = 2
)

var Alert_Violation_Type_name = map[int32]string{
	0: "GENERIC",
	1: "K8S_EVENT",
	2: "NETWORK_FLOW",
}

var Alert_Violation_Type_value = map[string]int32{
	"GENERIC":      0,
	"K8S_EVENT":    1,
	"NETWORK_FLOW": 2,
}

func (x Alert_Violation_Type) String() string {
	return proto.EnumName(Alert_Violation_Type_name, int32(x))
}

func (Alert_Violation_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{0, 2, 0}
}

// A special ListAlert-only enumeration of all resource types. Unlike Alert.Resource.ResourceType this also includes deployment as a type
// This must be kept in sync with Alert.Resource.ResourceType (excluding the deployment value)
type ListAlert_ResourceType int32

const (
	ListAlert_DEPLOYMENT ListAlert_ResourceType = 0
	ListAlert_SECRETS    ListAlert_ResourceType = 1
	ListAlert_CONFIGMAPS ListAlert_ResourceType = 2
)

var ListAlert_ResourceType_name = map[int32]string{
	0: "DEPLOYMENT",
	1: "SECRETS",
	2: "CONFIGMAPS",
}

var ListAlert_ResourceType_value = map[string]int32{
	"DEPLOYMENT": 0,
	"SECRETS":    1,
	"CONFIGMAPS": 2,
}

func (x ListAlert_ResourceType) String() string {
	return proto.EnumName(ListAlert_ResourceType_name, int32(x))
}

func (ListAlert_ResourceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{1, 0}
}

type Alert struct {
	Id             string         `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" sensorhash:"ignore" sql:"pk"`
	Policy         *Policy        `protobuf:"bytes,2,opt,name=policy,proto3" json:"policy,omitempty"`
	LifecycleStage LifecycleStage `protobuf:"varint,3,opt,name=lifecycle_stage,json=lifecycleStage,proto3,enum=storage.LifecycleStage" json:"lifecycle_stage,omitempty"`
	// Types that are valid to be assigned to Entity:
	//	*Alert_Deployment_
	//	*Alert_Image
	//	*Alert_Resource_
	Entity isAlert_Entity `protobuf_oneof:"Entity"`
	// For run-time phase alert, a maximum of 40 violations are retained.
	Violations       []*Alert_Violation      `protobuf:"bytes,5,rep,name=violations,proto3" json:"violations,omitempty" sensorhash:"ignore" search:"-"`
	ProcessViolation *Alert_ProcessViolation `protobuf:"bytes,13,opt,name=process_violation,json=processViolation,proto3" json:"process_violation,omitempty" search:"-"`
	Enforcement      *Alert_Enforcement      `protobuf:"bytes,6,opt,name=enforcement,proto3" json:"enforcement,omitempty"`
	Time             *types.Timestamp        `protobuf:"bytes,7,opt,name=time,proto3" json:"time,omitempty" sensorhash:"ignore"`
	FirstOccurred    *types.Timestamp        `protobuf:"bytes,10,opt,name=first_occurred,json=firstOccurred,proto3" json:"first_occurred,omitempty" sensorhash:"ignore"`
	// The time at which the alert was resolved. Only set if ViolationState is RESOLVED.
	ResolvedAt           *types.Timestamp `protobuf:"bytes,17,opt,name=resolved_at,json=resolvedAt,proto3" json:"resolved_at,omitempty" sensorhash:"ignore"`
	State                ViolationState   `protobuf:"varint,11,opt,name=state,proto3,enum=storage.ViolationState" json:"state,omitempty" search:"Violation State,store"`
	SnoozeTill           *types.Timestamp `protobuf:"bytes,12,opt,name=snooze_till,json=snoozeTill,proto3" json:"snooze_till,omitempty"`
	Tags                 []string         `protobuf:"bytes,14,rep,name=tags,proto3" json:"tags,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Alert) Reset()         { *m = Alert{} }
func (m *Alert) String() string { return proto.CompactTextString(m) }
func (*Alert) ProtoMessage()    {}
func (*Alert) Descriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{0}
}
func (m *Alert) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Alert) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Alert.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Alert) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Alert.Merge(m, src)
}
func (m *Alert) XXX_Size() int {
	return m.Size()
}
func (m *Alert) XXX_DiscardUnknown() {
	xxx_messageInfo_Alert.DiscardUnknown(m)
}

var xxx_messageInfo_Alert proto.InternalMessageInfo

type isAlert_Entity interface {
	isAlert_Entity()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isAlert_Entity
}

type Alert_Deployment_ struct {
	Deployment *Alert_Deployment `protobuf:"bytes,4,opt,name=deployment,proto3,oneof" json:"deployment,omitempty" sensorhash:"ignore"`
}
type Alert_Image struct {
	Image *ContainerImage `protobuf:"bytes,15,opt,name=image,proto3,oneof" json:"image,omitempty"`
}
type Alert_Resource_ struct {
	Resource *Alert_Resource `protobuf:"bytes,16,opt,name=resource,proto3,oneof" json:"resource,omitempty"`
}

func (*Alert_Deployment_) isAlert_Entity() {}
func (m *Alert_Deployment_) Clone() isAlert_Entity {
	if m == nil {
		return nil
	}
	cloned := new(Alert_Deployment_)
	*cloned = *m

	cloned.Deployment = m.Deployment.Clone()
	return cloned
}
func (*Alert_Image) isAlert_Entity() {}
func (m *Alert_Image) Clone() isAlert_Entity {
	if m == nil {
		return nil
	}
	cloned := new(Alert_Image)
	*cloned = *m

	cloned.Image = m.Image.Clone()
	return cloned
}
func (*Alert_Resource_) isAlert_Entity() {}
func (m *Alert_Resource_) Clone() isAlert_Entity {
	if m == nil {
		return nil
	}
	cloned := new(Alert_Resource_)
	*cloned = *m

	cloned.Resource = m.Resource.Clone()
	return cloned
}

func (m *Alert) GetEntity() isAlert_Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *Alert) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Alert) GetPolicy() *Policy {
	if m != nil {
		return m.Policy
	}
	return nil
}

func (m *Alert) GetLifecycleStage() LifecycleStage {
	if m != nil {
		return m.LifecycleStage
	}
	return LifecycleStage_DEPLOY
}

func (m *Alert) GetDeployment() *Alert_Deployment {
	if x, ok := m.GetEntity().(*Alert_Deployment_); ok {
		return x.Deployment
	}
	return nil
}

func (m *Alert) GetImage() *ContainerImage {
	if x, ok := m.GetEntity().(*Alert_Image); ok {
		return x.Image
	}
	return nil
}

func (m *Alert) GetResource() *Alert_Resource {
	if x, ok := m.GetEntity().(*Alert_Resource_); ok {
		return x.Resource
	}
	return nil
}

func (m *Alert) GetViolations() []*Alert_Violation {
	if m != nil {
		return m.Violations
	}
	return nil
}

func (m *Alert) GetProcessViolation() *Alert_ProcessViolation {
	if m != nil {
		return m.ProcessViolation
	}
	return nil
}

func (m *Alert) GetEnforcement() *Alert_Enforcement {
	if m != nil {
		return m.Enforcement
	}
	return nil
}

func (m *Alert) GetTime() *types.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

func (m *Alert) GetFirstOccurred() *types.Timestamp {
	if m != nil {
		return m.FirstOccurred
	}
	return nil
}

func (m *Alert) GetResolvedAt() *types.Timestamp {
	if m != nil {
		return m.ResolvedAt
	}
	return nil
}

func (m *Alert) GetState() ViolationState {
	if m != nil {
		return m.State
	}
	return ViolationState_ACTIVE
}

func (m *Alert) GetSnoozeTill() *types.Timestamp {
	if m != nil {
		return m.SnoozeTill
	}
	return nil
}

func (m *Alert) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Alert) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Alert_Deployment_)(nil),
		(*Alert_Image)(nil),
		(*Alert_Resource_)(nil),
	}
}

func (m *Alert) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Alert) Clone() *Alert {
	if m == nil {
		return nil
	}
	cloned := new(Alert)
	*cloned = *m

	cloned.Policy = m.Policy.Clone()
	if m.Entity != nil {
		cloned.Entity = m.Entity.Clone()
	}
	if m.Violations != nil {
		cloned.Violations = make([]*Alert_Violation, len(m.Violations))
		for idx, v := range m.Violations {
			cloned.Violations[idx] = v.Clone()
		}
	}
	cloned.ProcessViolation = m.ProcessViolation.Clone()
	cloned.Enforcement = m.Enforcement.Clone()
	cloned.Time = m.Time.Clone()
	cloned.FirstOccurred = m.FirstOccurred.Clone()
	cloned.ResolvedAt = m.ResolvedAt.Clone()
	cloned.SnoozeTill = m.SnoozeTill.Clone()
	if m.Tags != nil {
		cloned.Tags = make([]string, len(m.Tags))
		copy(cloned.Tags, m.Tags)
	}
	return cloned
}

type Alert_Deployment struct {
	Id                   string                        `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" search:"Deployment ID,store,hidden"`
	Name                 string                        `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty" search:"Deployment,store"`
	Type                 string                        `protobuf:"bytes,4,opt,name=type,proto3" json:"type,omitempty"`
	Namespace            string                        `protobuf:"bytes,5,opt,name=namespace,proto3" json:"namespace,omitempty"`
	NamespaceId          string                        `protobuf:"bytes,16,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	Labels               map[string]string             `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ClusterId            string                        `protobuf:"bytes,9,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	ClusterName          string                        `protobuf:"bytes,10,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	Containers           []*Alert_Deployment_Container `protobuf:"bytes,11,rep,name=containers,proto3" json:"containers,omitempty"`
	Annotations          map[string]string             `protobuf:"bytes,14,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Inactive             bool                          `protobuf:"varint,15,opt,name=inactive,proto3" json:"inactive,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *Alert_Deployment) Reset()         { *m = Alert_Deployment{} }
func (m *Alert_Deployment) String() string { return proto.CompactTextString(m) }
func (*Alert_Deployment) ProtoMessage()    {}
func (*Alert_Deployment) Descriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{0, 0}
}
func (m *Alert_Deployment) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Alert_Deployment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Alert_Deployment.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Alert_Deployment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Alert_Deployment.Merge(m, src)
}
func (m *Alert_Deployment) XXX_Size() int {
	return m.Size()
}
func (m *Alert_Deployment) XXX_DiscardUnknown() {
	xxx_messageInfo_Alert_Deployment.DiscardUnknown(m)
}

var xxx_messageInfo_Alert_Deployment proto.InternalMessageInfo

func (m *Alert_Deployment) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Alert_Deployment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Alert_Deployment) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Alert_Deployment) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *Alert_Deployment) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *Alert_Deployment) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Alert_Deployment) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *Alert_Deployment) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *Alert_Deployment) GetContainers() []*Alert_Deployment_Container {
	if m != nil {
		return m.Containers
	}
	return nil
}

func (m *Alert_Deployment) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *Alert_Deployment) GetInactive() bool {
	if m != nil {
		return m.Inactive
	}
	return false
}

func (m *Alert_Deployment) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Alert_Deployment) Clone() *Alert_Deployment {
	if m == nil {
		return nil
	}
	cloned := new(Alert_Deployment)
	*cloned = *m

	if m.Labels != nil {
		cloned.Labels = make(map[string]string, len(m.Labels))
		for k, v := range m.Labels {
			cloned.Labels[k] = v
		}
	}
	if m.Containers != nil {
		cloned.Containers = make([]*Alert_Deployment_Container, len(m.Containers))
		for idx, v := range m.Containers {
			cloned.Containers[idx] = v.Clone()
		}
	}
	if m.Annotations != nil {
		cloned.Annotations = make(map[string]string, len(m.Annotations))
		for k, v := range m.Annotations {
			cloned.Annotations[k] = v
		}
	}
	return cloned
}

type Alert_Deployment_Container struct {
	Image                *ContainerImage `protobuf:"bytes,3,opt,name=image,proto3" json:"image,omitempty"`
	Name                 string          `protobuf:"bytes,10,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Alert_Deployment_Container) Reset()         { *m = Alert_Deployment_Container{} }
func (m *Alert_Deployment_Container) String() string { return proto.CompactTextString(m) }
func (*Alert_Deployment_Container) ProtoMessage()    {}
func (*Alert_Deployment_Container) Descriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{0, 0, 1}
}
func (m *Alert_Deployment_Container) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Alert_Deployment_Container) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Alert_Deployment_Container.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Alert_Deployment_Container) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Alert_Deployment_Container.Merge(m, src)
}
func (m *Alert_Deployment_Container) XXX_Size() int {
	return m.Size()
}
func (m *Alert_Deployment_Container) XXX_DiscardUnknown() {
	xxx_messageInfo_Alert_Deployment_Container.DiscardUnknown(m)
}

var xxx_messageInfo_Alert_Deployment_Container proto.InternalMessageInfo

func (m *Alert_Deployment_Container) GetImage() *ContainerImage {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *Alert_Deployment_Container) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Alert_Deployment_Container) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Alert_Deployment_Container) Clone() *Alert_Deployment_Container {
	if m == nil {
		return nil
	}
	cloned := new(Alert_Deployment_Container)
	*cloned = *m

	cloned.Image = m.Image.Clone()
	return cloned
}

// Represents an alert on a kubernetes resource (configmaps, secrets, etc.)
type Alert_Resource struct {
	ResourceType         Alert_Resource_ResourceType `protobuf:"varint,1,opt,name=resource_type,json=resourceType,proto3,enum=storage.Alert_Resource_ResourceType" json:"resource_type,omitempty"`
	Name                 string                      `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	ClusterId            string                      `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	ClusterName          string                      `protobuf:"bytes,4,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	Namespace            string                      `protobuf:"bytes,5,opt,name=namespace,proto3" json:"namespace,omitempty"`
	NamespaceId          string                      `protobuf:"bytes,6,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *Alert_Resource) Reset()         { *m = Alert_Resource{} }
func (m *Alert_Resource) String() string { return proto.CompactTextString(m) }
func (*Alert_Resource) ProtoMessage()    {}
func (*Alert_Resource) Descriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{0, 1}
}
func (m *Alert_Resource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Alert_Resource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Alert_Resource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Alert_Resource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Alert_Resource.Merge(m, src)
}
func (m *Alert_Resource) XXX_Size() int {
	return m.Size()
}
func (m *Alert_Resource) XXX_DiscardUnknown() {
	xxx_messageInfo_Alert_Resource.DiscardUnknown(m)
}

var xxx_messageInfo_Alert_Resource proto.InternalMessageInfo

func (m *Alert_Resource) GetResourceType() Alert_Resource_ResourceType {
	if m != nil {
		return m.ResourceType
	}
	return Alert_Resource_UNKNOWN
}

func (m *Alert_Resource) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Alert_Resource) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *Alert_Resource) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *Alert_Resource) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *Alert_Resource) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *Alert_Resource) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Alert_Resource) Clone() *Alert_Resource {
	if m == nil {
		return nil
	}
	cloned := new(Alert_Resource)
	*cloned = *m

	return cloned
}

type Alert_Violation struct {
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// Types that are valid to be assigned to MessageAttributes:
	//	*Alert_Violation_KeyValueAttrs_
	//	*Alert_Violation_NetworkFlowInfo_
	MessageAttributes isAlert_Violation_MessageAttributes `protobuf_oneof:"MessageAttributes"`
	// 'type' is for internal use only.
	Type Alert_Violation_Type `protobuf:"varint,5,opt,name=type,proto3,enum=storage.Alert_Violation_Type" json:"type,omitempty"`
	// Indicates violation time. This field differs from top-level field 'time' which represents last time the alert
	// occurred in case of multiple occurrences of the policy alert. As of 55.0, this field is set only for kubernetes
	// event violations, but may not be limited to it in future.
	Time                 *types.Timestamp `protobuf:"bytes,6,opt,name=time,proto3" json:"time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Alert_Violation) Reset()         { *m = Alert_Violation{} }
func (m *Alert_Violation) String() string { return proto.CompactTextString(m) }
func (*Alert_Violation) ProtoMessage()    {}
func (*Alert_Violation) Descriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{0, 2}
}
func (m *Alert_Violation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Alert_Violation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Alert_Violation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Alert_Violation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Alert_Violation.Merge(m, src)
}
func (m *Alert_Violation) XXX_Size() int {
	return m.Size()
}
func (m *Alert_Violation) XXX_DiscardUnknown() {
	xxx_messageInfo_Alert_Violation.DiscardUnknown(m)
}

var xxx_messageInfo_Alert_Violation proto.InternalMessageInfo

type isAlert_Violation_MessageAttributes interface {
	isAlert_Violation_MessageAttributes()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isAlert_Violation_MessageAttributes
}

type Alert_Violation_KeyValueAttrs_ struct {
	KeyValueAttrs *Alert_Violation_KeyValueAttrs `protobuf:"bytes,4,opt,name=key_value_attrs,json=keyValueAttrs,proto3,oneof" json:"key_value_attrs,omitempty"`
}
type Alert_Violation_NetworkFlowInfo_ struct {
	NetworkFlowInfo *Alert_Violation_NetworkFlowInfo `protobuf:"bytes,7,opt,name=network_flow_info,json=networkFlowInfo,proto3,oneof" json:"network_flow_info,omitempty"`
}

func (*Alert_Violation_KeyValueAttrs_) isAlert_Violation_MessageAttributes() {}
func (m *Alert_Violation_KeyValueAttrs_) Clone() isAlert_Violation_MessageAttributes {
	if m == nil {
		return nil
	}
	cloned := new(Alert_Violation_KeyValueAttrs_)
	*cloned = *m

	cloned.KeyValueAttrs = m.KeyValueAttrs.Clone()
	return cloned
}
func (*Alert_Violation_NetworkFlowInfo_) isAlert_Violation_MessageAttributes() {}
func (m *Alert_Violation_NetworkFlowInfo_) Clone() isAlert_Violation_MessageAttributes {
	if m == nil {
		return nil
	}
	cloned := new(Alert_Violation_NetworkFlowInfo_)
	*cloned = *m

	cloned.NetworkFlowInfo = m.NetworkFlowInfo.Clone()
	return cloned
}

func (m *Alert_Violation) GetMessageAttributes() isAlert_Violation_MessageAttributes {
	if m != nil {
		return m.MessageAttributes
	}
	return nil
}

func (m *Alert_Violation) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *Alert_Violation) GetKeyValueAttrs() *Alert_Violation_KeyValueAttrs {
	if x, ok := m.GetMessageAttributes().(*Alert_Violation_KeyValueAttrs_); ok {
		return x.KeyValueAttrs
	}
	return nil
}

func (m *Alert_Violation) GetNetworkFlowInfo() *Alert_Violation_NetworkFlowInfo {
	if x, ok := m.GetMessageAttributes().(*Alert_Violation_NetworkFlowInfo_); ok {
		return x.NetworkFlowInfo
	}
	return nil
}

func (m *Alert_Violation) GetType() Alert_Violation_Type {
	if m != nil {
		return m.Type
	}
	return Alert_Violation_GENERIC
}

func (m *Alert_Violation) GetTime() *types.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Alert_Violation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Alert_Violation_KeyValueAttrs_)(nil),
		(*Alert_Violation_NetworkFlowInfo_)(nil),
	}
}

func (m *Alert_Violation) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Alert_Violation) Clone() *Alert_Violation {
	if m == nil {
		return nil
	}
	cloned := new(Alert_Violation)
	*cloned = *m

	if m.MessageAttributes != nil {
		cloned.MessageAttributes = m.MessageAttributes.Clone()
	}
	cloned.Time = m.Time.Clone()
	return cloned
}

type Alert_Violation_KeyValueAttrs struct {
	Attrs                []*Alert_Violation_KeyValueAttrs_KeyValueAttr `protobuf:"bytes,1,rep,name=attrs,proto3" json:"attrs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                      `json:"-"`
	XXX_unrecognized     []byte                                        `json:"-"`
	XXX_sizecache        int32                                         `json:"-"`
}

func (m *Alert_Violation_KeyValueAttrs) Reset()         { *m = Alert_Violation_KeyValueAttrs{} }
func (m *Alert_Violation_KeyValueAttrs) String() string { return proto.CompactTextString(m) }
func (*Alert_Violation_KeyValueAttrs) ProtoMessage()    {}
func (*Alert_Violation_KeyValueAttrs) Descriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{0, 2, 0}
}
func (m *Alert_Violation_KeyValueAttrs) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Alert_Violation_KeyValueAttrs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Alert_Violation_KeyValueAttrs.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Alert_Violation_KeyValueAttrs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Alert_Violation_KeyValueAttrs.Merge(m, src)
}
func (m *Alert_Violation_KeyValueAttrs) XXX_Size() int {
	return m.Size()
}
func (m *Alert_Violation_KeyValueAttrs) XXX_DiscardUnknown() {
	xxx_messageInfo_Alert_Violation_KeyValueAttrs.DiscardUnknown(m)
}

var xxx_messageInfo_Alert_Violation_KeyValueAttrs proto.InternalMessageInfo

func (m *Alert_Violation_KeyValueAttrs) GetAttrs() []*Alert_Violation_KeyValueAttrs_KeyValueAttr {
	if m != nil {
		return m.Attrs
	}
	return nil
}

func (m *Alert_Violation_KeyValueAttrs) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Alert_Violation_KeyValueAttrs) Clone() *Alert_Violation_KeyValueAttrs {
	if m == nil {
		return nil
	}
	cloned := new(Alert_Violation_KeyValueAttrs)
	*cloned = *m

	if m.Attrs != nil {
		cloned.Attrs = make([]*Alert_Violation_KeyValueAttrs_KeyValueAttr, len(m.Attrs))
		for idx, v := range m.Attrs {
			cloned.Attrs[idx] = v.Clone()
		}
	}
	return cloned
}

type Alert_Violation_KeyValueAttrs_KeyValueAttr struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Alert_Violation_KeyValueAttrs_KeyValueAttr) Reset() {
	*m = Alert_Violation_KeyValueAttrs_KeyValueAttr{}
}
func (m *Alert_Violation_KeyValueAttrs_KeyValueAttr) String() string {
	return proto.CompactTextString(m)
}
func (*Alert_Violation_KeyValueAttrs_KeyValueAttr) ProtoMessage() {}
func (*Alert_Violation_KeyValueAttrs_KeyValueAttr) Descriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{0, 2, 0, 0}
}
func (m *Alert_Violation_KeyValueAttrs_KeyValueAttr) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Alert_Violation_KeyValueAttrs_KeyValueAttr) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Alert_Violation_KeyValueAttrs_KeyValueAttr.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Alert_Violation_KeyValueAttrs_KeyValueAttr) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Alert_Violation_KeyValueAttrs_KeyValueAttr.Merge(m, src)
}
func (m *Alert_Violation_KeyValueAttrs_KeyValueAttr) XXX_Size() int {
	return m.Size()
}
func (m *Alert_Violation_KeyValueAttrs_KeyValueAttr) XXX_DiscardUnknown() {
	xxx_messageInfo_Alert_Violation_KeyValueAttrs_KeyValueAttr.DiscardUnknown(m)
}

var xxx_messageInfo_Alert_Violation_KeyValueAttrs_KeyValueAttr proto.InternalMessageInfo

func (m *Alert_Violation_KeyValueAttrs_KeyValueAttr) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Alert_Violation_KeyValueAttrs_KeyValueAttr) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *Alert_Violation_KeyValueAttrs_KeyValueAttr) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Alert_Violation_KeyValueAttrs_KeyValueAttr) Clone() *Alert_Violation_KeyValueAttrs_KeyValueAttr {
	if m == nil {
		return nil
	}
	cloned := new(Alert_Violation_KeyValueAttrs_KeyValueAttr)
	*cloned = *m

	return cloned
}

type Alert_Violation_NetworkFlowInfo struct {
	Protocol             L4Protocol                              `protobuf:"varint,1,opt,name=protocol,proto3,enum=storage.L4Protocol" json:"protocol,omitempty"`
	Source               *Alert_Violation_NetworkFlowInfo_Entity `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	Destination          *Alert_Violation_NetworkFlowInfo_Entity `protobuf:"bytes,3,opt,name=destination,proto3" json:"destination,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *Alert_Violation_NetworkFlowInfo) Reset()         { *m = Alert_Violation_NetworkFlowInfo{} }
func (m *Alert_Violation_NetworkFlowInfo) String() string { return proto.CompactTextString(m) }
func (*Alert_Violation_NetworkFlowInfo) ProtoMessage()    {}
func (*Alert_Violation_NetworkFlowInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{0, 2, 1}
}
func (m *Alert_Violation_NetworkFlowInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Alert_Violation_NetworkFlowInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Alert_Violation_NetworkFlowInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Alert_Violation_NetworkFlowInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Alert_Violation_NetworkFlowInfo.Merge(m, src)
}
func (m *Alert_Violation_NetworkFlowInfo) XXX_Size() int {
	return m.Size()
}
func (m *Alert_Violation_NetworkFlowInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_Alert_Violation_NetworkFlowInfo.DiscardUnknown(m)
}

var xxx_messageInfo_Alert_Violation_NetworkFlowInfo proto.InternalMessageInfo

func (m *Alert_Violation_NetworkFlowInfo) GetProtocol() L4Protocol {
	if m != nil {
		return m.Protocol
	}
	return L4Protocol_L4_PROTOCOL_UNKNOWN
}

func (m *Alert_Violation_NetworkFlowInfo) GetSource() *Alert_Violation_NetworkFlowInfo_Entity {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Alert_Violation_NetworkFlowInfo) GetDestination() *Alert_Violation_NetworkFlowInfo_Entity {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *Alert_Violation_NetworkFlowInfo) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Alert_Violation_NetworkFlowInfo) Clone() *Alert_Violation_NetworkFlowInfo {
	if m == nil {
		return nil
	}
	cloned := new(Alert_Violation_NetworkFlowInfo)
	*cloned = *m

	cloned.Source = m.Source.Clone()
	cloned.Destination = m.Destination.Clone()
	return cloned
}

type Alert_Violation_NetworkFlowInfo_Entity struct {
	Name                 string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	EntityType           NetworkEntityInfo_Type `protobuf:"varint,2,opt,name=entity_type,json=entityType,proto3,enum=storage.NetworkEntityInfo_Type" json:"entity_type,omitempty"`
	DeploymentNamespace  string                 `protobuf:"bytes,3,opt,name=deployment_namespace,json=deploymentNamespace,proto3" json:"deployment_namespace,omitempty"`
	DeploymentType       string                 `protobuf:"bytes,5,opt,name=deployment_type,json=deploymentType,proto3" json:"deployment_type,omitempty"`
	Port                 int32                  `protobuf:"varint,6,opt,name=port,proto3" json:"port,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *Alert_Violation_NetworkFlowInfo_Entity) Reset() {
	*m = Alert_Violation_NetworkFlowInfo_Entity{}
}
func (m *Alert_Violation_NetworkFlowInfo_Entity) String() string { return proto.CompactTextString(m) }
func (*Alert_Violation_NetworkFlowInfo_Entity) ProtoMessage()    {}
func (*Alert_Violation_NetworkFlowInfo_Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{0, 2, 1, 0}
}
func (m *Alert_Violation_NetworkFlowInfo_Entity) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Alert_Violation_NetworkFlowInfo_Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Alert_Violation_NetworkFlowInfo_Entity.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Alert_Violation_NetworkFlowInfo_Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Alert_Violation_NetworkFlowInfo_Entity.Merge(m, src)
}
func (m *Alert_Violation_NetworkFlowInfo_Entity) XXX_Size() int {
	return m.Size()
}
func (m *Alert_Violation_NetworkFlowInfo_Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_Alert_Violation_NetworkFlowInfo_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_Alert_Violation_NetworkFlowInfo_Entity proto.InternalMessageInfo

func (m *Alert_Violation_NetworkFlowInfo_Entity) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Alert_Violation_NetworkFlowInfo_Entity) GetEntityType() NetworkEntityInfo_Type {
	if m != nil {
		return m.EntityType
	}
	return NetworkEntityInfo_UNKNOWN_TYPE
}

func (m *Alert_Violation_NetworkFlowInfo_Entity) GetDeploymentNamespace() string {
	if m != nil {
		return m.DeploymentNamespace
	}
	return ""
}

func (m *Alert_Violation_NetworkFlowInfo_Entity) GetDeploymentType() string {
	if m != nil {
		return m.DeploymentType
	}
	return ""
}

func (m *Alert_Violation_NetworkFlowInfo_Entity) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *Alert_Violation_NetworkFlowInfo_Entity) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Alert_Violation_NetworkFlowInfo_Entity) Clone() *Alert_Violation_NetworkFlowInfo_Entity {
	if m == nil {
		return nil
	}
	cloned := new(Alert_Violation_NetworkFlowInfo_Entity)
	*cloned = *m

	return cloned
}

type Alert_ProcessViolation struct {
	Message              string              `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	Processes            []*ProcessIndicator `protobuf:"bytes,2,rep,name=processes,proto3" json:"processes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Alert_ProcessViolation) Reset()         { *m = Alert_ProcessViolation{} }
func (m *Alert_ProcessViolation) String() string { return proto.CompactTextString(m) }
func (*Alert_ProcessViolation) ProtoMessage()    {}
func (*Alert_ProcessViolation) Descriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{0, 3}
}
func (m *Alert_ProcessViolation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Alert_ProcessViolation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Alert_ProcessViolation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Alert_ProcessViolation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Alert_ProcessViolation.Merge(m, src)
}
func (m *Alert_ProcessViolation) XXX_Size() int {
	return m.Size()
}
func (m *Alert_ProcessViolation) XXX_DiscardUnknown() {
	xxx_messageInfo_Alert_ProcessViolation.DiscardUnknown(m)
}

var xxx_messageInfo_Alert_ProcessViolation proto.InternalMessageInfo

func (m *Alert_ProcessViolation) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *Alert_ProcessViolation) GetProcesses() []*ProcessIndicator {
	if m != nil {
		return m.Processes
	}
	return nil
}

func (m *Alert_ProcessViolation) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Alert_ProcessViolation) Clone() *Alert_ProcessViolation {
	if m == nil {
		return nil
	}
	cloned := new(Alert_ProcessViolation)
	*cloned = *m

	if m.Processes != nil {
		cloned.Processes = make([]*ProcessIndicator, len(m.Processes))
		for idx, v := range m.Processes {
			cloned.Processes[idx] = v.Clone()
		}
	}
	return cloned
}

type Alert_Enforcement struct {
	Action               EnforcementAction `protobuf:"varint,1,opt,name=action,proto3,enum=storage.EnforcementAction" json:"action,omitempty"`
	Message              string            `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Alert_Enforcement) Reset()         { *m = Alert_Enforcement{} }
func (m *Alert_Enforcement) String() string { return proto.CompactTextString(m) }
func (*Alert_Enforcement) ProtoMessage()    {}
func (*Alert_Enforcement) Descriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{0, 4}
}
func (m *Alert_Enforcement) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Alert_Enforcement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Alert_Enforcement.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Alert_Enforcement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Alert_Enforcement.Merge(m, src)
}
func (m *Alert_Enforcement) XXX_Size() int {
	return m.Size()
}
func (m *Alert_Enforcement) XXX_DiscardUnknown() {
	xxx_messageInfo_Alert_Enforcement.DiscardUnknown(m)
}

var xxx_messageInfo_Alert_Enforcement proto.InternalMessageInfo

func (m *Alert_Enforcement) GetAction() EnforcementAction {
	if m != nil {
		return m.Action
	}
	return EnforcementAction_UNSET_ENFORCEMENT
}

func (m *Alert_Enforcement) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *Alert_Enforcement) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Alert_Enforcement) Clone() *Alert_Enforcement {
	if m == nil {
		return nil
	}
	cloned := new(Alert_Enforcement)
	*cloned = *m

	return cloned
}

type ListAlert struct {
	Id                string                      `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	LifecycleStage    LifecycleStage              `protobuf:"varint,2,opt,name=lifecycle_stage,json=lifecycleStage,proto3,enum=storage.LifecycleStage" json:"lifecycle_stage,omitempty" search:"Lifecycle Stage,store"`
	Time              *types.Timestamp            `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty" search:"Violation Time"`
	Policy            *ListAlertPolicy            `protobuf:"bytes,4,opt,name=policy,proto3" json:"policy,omitempty"`
	State             ViolationState              `protobuf:"varint,6,opt,name=state,proto3,enum=storage.ViolationState" json:"state,omitempty" search:"Violation State,store"`
	EnforcementCount  int32                       `protobuf:"varint,7,opt,name=enforcement_count,json=enforcementCount,proto3" json:"enforcement_count,omitempty"`
	Tags              []string                    `protobuf:"bytes,8,rep,name=tags,proto3" json:"tags,omitempty" search:"Tag,store"`
	EnforcementAction EnforcementAction           `protobuf:"varint,9,opt,name=enforcement_action,json=enforcementAction,proto3,enum=storage.EnforcementAction" json:"enforcement_action,omitempty" search:"Enforcement"`
	CommonEntityInfo  *ListAlert_CommonEntityInfo `protobuf:"bytes,10,opt,name=common_entity_info,json=commonEntityInfo,proto3" json:"common_entity_info,omitempty"`
	// Tags 5, 11-15 reserved for this oneof. Next available tag: 12
	//
	// Types that are valid to be assigned to Entity:
	//	*ListAlert_Deployment
	//	*ListAlert_Resource
	Entity               isListAlert_Entity `protobuf_oneof:"Entity"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ListAlert) Reset()         { *m = ListAlert{} }
func (m *ListAlert) String() string { return proto.CompactTextString(m) }
func (*ListAlert) ProtoMessage()    {}
func (*ListAlert) Descriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{1}
}
func (m *ListAlert) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListAlert) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListAlert.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListAlert) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAlert.Merge(m, src)
}
func (m *ListAlert) XXX_Size() int {
	return m.Size()
}
func (m *ListAlert) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAlert.DiscardUnknown(m)
}

var xxx_messageInfo_ListAlert proto.InternalMessageInfo

type isListAlert_Entity interface {
	isListAlert_Entity()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isListAlert_Entity
}

type ListAlert_Deployment struct {
	Deployment *ListAlertDeployment `protobuf:"bytes,5,opt,name=deployment,proto3,oneof" json:"deployment,omitempty"`
}
type ListAlert_Resource struct {
	Resource *ListAlert_ResourceEntity `protobuf:"bytes,11,opt,name=resource,proto3,oneof" json:"resource,omitempty"`
}

func (*ListAlert_Deployment) isListAlert_Entity() {}
func (m *ListAlert_Deployment) Clone() isListAlert_Entity {
	if m == nil {
		return nil
	}
	cloned := new(ListAlert_Deployment)
	*cloned = *m

	cloned.Deployment = m.Deployment.Clone()
	return cloned
}
func (*ListAlert_Resource) isListAlert_Entity() {}
func (m *ListAlert_Resource) Clone() isListAlert_Entity {
	if m == nil {
		return nil
	}
	cloned := new(ListAlert_Resource)
	*cloned = *m

	cloned.Resource = m.Resource.Clone()
	return cloned
}

func (m *ListAlert) GetEntity() isListAlert_Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *ListAlert) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ListAlert) GetLifecycleStage() LifecycleStage {
	if m != nil {
		return m.LifecycleStage
	}
	return LifecycleStage_DEPLOY
}

func (m *ListAlert) GetTime() *types.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

func (m *ListAlert) GetPolicy() *ListAlertPolicy {
	if m != nil {
		return m.Policy
	}
	return nil
}

func (m *ListAlert) GetState() ViolationState {
	if m != nil {
		return m.State
	}
	return ViolationState_ACTIVE
}

func (m *ListAlert) GetEnforcementCount() int32 {
	if m != nil {
		return m.EnforcementCount
	}
	return 0
}

func (m *ListAlert) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *ListAlert) GetEnforcementAction() EnforcementAction {
	if m != nil {
		return m.EnforcementAction
	}
	return EnforcementAction_UNSET_ENFORCEMENT
}

func (m *ListAlert) GetCommonEntityInfo() *ListAlert_CommonEntityInfo {
	if m != nil {
		return m.CommonEntityInfo
	}
	return nil
}

func (m *ListAlert) GetDeployment() *ListAlertDeployment {
	if x, ok := m.GetEntity().(*ListAlert_Deployment); ok {
		return x.Deployment
	}
	return nil
}

func (m *ListAlert) GetResource() *ListAlert_ResourceEntity {
	if x, ok := m.GetEntity().(*ListAlert_Resource); ok {
		return x.Resource
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ListAlert) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ListAlert_Deployment)(nil),
		(*ListAlert_Resource)(nil),
	}
}

func (m *ListAlert) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListAlert) Clone() *ListAlert {
	if m == nil {
		return nil
	}
	cloned := new(ListAlert)
	*cloned = *m

	cloned.Time = m.Time.Clone()
	cloned.Policy = m.Policy.Clone()
	if m.Tags != nil {
		cloned.Tags = make([]string, len(m.Tags))
		copy(cloned.Tags, m.Tags)
	}
	cloned.CommonEntityInfo = m.CommonEntityInfo.Clone()
	if m.Entity != nil {
		cloned.Entity = m.Entity.Clone()
	}
	return cloned
}

// Fields common to all entities that an alert might belong to.
type ListAlert_CommonEntityInfo struct {
	ClusterName          string                 `protobuf:"bytes,1,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty" search:"Cluster,store"`
	Namespace            string                 `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty" search:"Namespace,store"`
	ClusterId            string                 `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty" search:"Cluster ID,store"`
	NamespaceId          string                 `protobuf:"bytes,4,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty" search:"Namespace ID"`
	ResourceType         ListAlert_ResourceType `protobuf:"varint,5,opt,name=resource_type,json=resourceType,proto3,enum=storage.ListAlert_ResourceType" json:"resource_type,omitempty" search:"Resource Type,store"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *ListAlert_CommonEntityInfo) Reset()         { *m = ListAlert_CommonEntityInfo{} }
func (m *ListAlert_CommonEntityInfo) String() string { return proto.CompactTextString(m) }
func (*ListAlert_CommonEntityInfo) ProtoMessage()    {}
func (*ListAlert_CommonEntityInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{1, 0}
}
func (m *ListAlert_CommonEntityInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListAlert_CommonEntityInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListAlert_CommonEntityInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListAlert_CommonEntityInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAlert_CommonEntityInfo.Merge(m, src)
}
func (m *ListAlert_CommonEntityInfo) XXX_Size() int {
	return m.Size()
}
func (m *ListAlert_CommonEntityInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAlert_CommonEntityInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ListAlert_CommonEntityInfo proto.InternalMessageInfo

func (m *ListAlert_CommonEntityInfo) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *ListAlert_CommonEntityInfo) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ListAlert_CommonEntityInfo) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListAlert_CommonEntityInfo) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *ListAlert_CommonEntityInfo) GetResourceType() ListAlert_ResourceType {
	if m != nil {
		return m.ResourceType
	}
	return ListAlert_DEPLOYMENT
}

func (m *ListAlert_CommonEntityInfo) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListAlert_CommonEntityInfo) Clone() *ListAlert_CommonEntityInfo {
	if m == nil {
		return nil
	}
	cloned := new(ListAlert_CommonEntityInfo)
	*cloned = *m

	return cloned
}

type ListAlert_ResourceEntity struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty" search:"Resource"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAlert_ResourceEntity) Reset()         { *m = ListAlert_ResourceEntity{} }
func (m *ListAlert_ResourceEntity) String() string { return proto.CompactTextString(m) }
func (*ListAlert_ResourceEntity) ProtoMessage()    {}
func (*ListAlert_ResourceEntity) Descriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{1, 1}
}
func (m *ListAlert_ResourceEntity) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListAlert_ResourceEntity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListAlert_ResourceEntity.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListAlert_ResourceEntity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAlert_ResourceEntity.Merge(m, src)
}
func (m *ListAlert_ResourceEntity) XXX_Size() int {
	return m.Size()
}
func (m *ListAlert_ResourceEntity) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAlert_ResourceEntity.DiscardUnknown(m)
}

var xxx_messageInfo_ListAlert_ResourceEntity proto.InternalMessageInfo

func (m *ListAlert_ResourceEntity) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListAlert_ResourceEntity) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListAlert_ResourceEntity) Clone() *ListAlert_ResourceEntity {
	if m == nil {
		return nil
	}
	cloned := new(ListAlert_ResourceEntity)
	*cloned = *m

	return cloned
}

type ListAlertPolicy struct {
	Id          string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" search:"Policy ID,store,hidden"`
	Name        string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty" search:"Policy,store"`
	Severity    Severity `protobuf:"varint,3,opt,name=severity,proto3,enum=storage.Severity" json:"severity,omitempty" search:"Severity,store"`
	Description string   `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	Categories  []string `protobuf:"bytes,5,rep,name=categories,proto3" json:"categories,omitempty" search:"Category,store"`
	// For internal use only.
	DeveloperInternalFields *ListAlertPolicy_DevFields `protobuf:"bytes,6,opt,name=developer_internal_fields,json=developerInternalFields,proto3" json:"developer_internal_fields,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}                   `json:"-"`
	XXX_unrecognized        []byte                     `json:"-"`
	XXX_sizecache           int32                      `json:"-"`
}

func (m *ListAlertPolicy) Reset()         { *m = ListAlertPolicy{} }
func (m *ListAlertPolicy) String() string { return proto.CompactTextString(m) }
func (*ListAlertPolicy) ProtoMessage()    {}
func (*ListAlertPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{2}
}
func (m *ListAlertPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListAlertPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListAlertPolicy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListAlertPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAlertPolicy.Merge(m, src)
}
func (m *ListAlertPolicy) XXX_Size() int {
	return m.Size()
}
func (m *ListAlertPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAlertPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_ListAlertPolicy proto.InternalMessageInfo

func (m *ListAlertPolicy) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ListAlertPolicy) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListAlertPolicy) GetSeverity() Severity {
	if m != nil {
		return m.Severity
	}
	return Severity_UNSET_SEVERITY
}

func (m *ListAlertPolicy) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ListAlertPolicy) GetCategories() []string {
	if m != nil {
		return m.Categories
	}
	return nil
}

func (m *ListAlertPolicy) GetDeveloperInternalFields() *ListAlertPolicy_DevFields {
	if m != nil {
		return m.DeveloperInternalFields
	}
	return nil
}

func (m *ListAlertPolicy) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListAlertPolicy) Clone() *ListAlertPolicy {
	if m == nil {
		return nil
	}
	cloned := new(ListAlertPolicy)
	*cloned = *m

	if m.Categories != nil {
		cloned.Categories = make([]string, len(m.Categories))
		copy(cloned.Categories, m.Categories)
	}
	cloned.DeveloperInternalFields = m.DeveloperInternalFields.Clone()
	return cloned
}

type ListAlertPolicy_DevFields struct {
	SORTName             string   `protobuf:"bytes,6,opt,name=SORT_name,json=SORTName,proto3" json:"SORT_name,omitempty" search:"SORT_Policy,hidden,analyzer=keyword"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAlertPolicy_DevFields) Reset()         { *m = ListAlertPolicy_DevFields{} }
func (m *ListAlertPolicy_DevFields) String() string { return proto.CompactTextString(m) }
func (*ListAlertPolicy_DevFields) ProtoMessage()    {}
func (*ListAlertPolicy_DevFields) Descriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{2, 0}
}
func (m *ListAlertPolicy_DevFields) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListAlertPolicy_DevFields) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListAlertPolicy_DevFields.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListAlertPolicy_DevFields) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAlertPolicy_DevFields.Merge(m, src)
}
func (m *ListAlertPolicy_DevFields) XXX_Size() int {
	return m.Size()
}
func (m *ListAlertPolicy_DevFields) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAlertPolicy_DevFields.DiscardUnknown(m)
}

var xxx_messageInfo_ListAlertPolicy_DevFields proto.InternalMessageInfo

func (m *ListAlertPolicy_DevFields) GetSORTName() string {
	if m != nil {
		return m.SORTName
	}
	return ""
}

func (m *ListAlertPolicy_DevFields) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListAlertPolicy_DevFields) Clone() *ListAlertPolicy_DevFields {
	if m == nil {
		return nil
	}
	cloned := new(ListAlertPolicy_DevFields)
	*cloned = *m

	return cloned
}

type ListAlertDeployment struct {
	Id   string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" search:"Deployment ID,store,hidden"`
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty" search:"Deployment,store"`
	// This field is deprecated and can be found in CommonEntityInfo. It will be removed from here in a future release.
	ClusterName string `protobuf:"bytes,4,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"` // Deprecated: Do not use.
	// This field is deprecated and can be found in CommonEntityInfo. It will be removed from here in a future release.
	Namespace string `protobuf:"bytes,5,opt,name=namespace,proto3" json:"namespace,omitempty"` // Deprecated: Do not use.
	// This field is deprecated and can be found in CommonEntityInfo. It will be removed from here in a future release.
	ClusterId string `protobuf:"bytes,6,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	Inactive  bool   `protobuf:"varint,7,opt,name=inactive,proto3" json:"inactive,omitempty" search:"Inactive Deployment"`
	// This field is deprecated and can be found in CommonEntityInfo. It will be removed from here in a future release.
	NamespaceId          string   `protobuf:"bytes,8,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"` // Deprecated: Do not use.
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAlertDeployment) Reset()         { *m = ListAlertDeployment{} }
func (m *ListAlertDeployment) String() string { return proto.CompactTextString(m) }
func (*ListAlertDeployment) ProtoMessage()    {}
func (*ListAlertDeployment) Descriptor() ([]byte, []int) {
	return fileDescriptor_bfba8812535cd55e, []int{3}
}
func (m *ListAlertDeployment) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListAlertDeployment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListAlertDeployment.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListAlertDeployment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAlertDeployment.Merge(m, src)
}
func (m *ListAlertDeployment) XXX_Size() int {
	return m.Size()
}
func (m *ListAlertDeployment) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAlertDeployment.DiscardUnknown(m)
}

var xxx_messageInfo_ListAlertDeployment proto.InternalMessageInfo

func (m *ListAlertDeployment) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ListAlertDeployment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Deprecated: Do not use.
func (m *ListAlertDeployment) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

// Deprecated: Do not use.
func (m *ListAlertDeployment) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

// Deprecated: Do not use.
func (m *ListAlertDeployment) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListAlertDeployment) GetInactive() bool {
	if m != nil {
		return m.Inactive
	}
	return false
}

// Deprecated: Do not use.
func (m *ListAlertDeployment) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *ListAlertDeployment) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListAlertDeployment) Clone() *ListAlertDeployment {
	if m == nil {
		return nil
	}
	cloned := new(ListAlertDeployment)
	*cloned = *m

	return cloned
}

func init() {
	proto.RegisterEnum("storage.ViolationState", ViolationState_name, ViolationState_value)
	proto.RegisterEnum("storage.Alert_Resource_ResourceType", Alert_Resource_ResourceType_name, Alert_Resource_ResourceType_value)
	proto.RegisterEnum("storage.Alert_Violation_Type", Alert_Violation_Type_name, Alert_Violation_Type_value)
	proto.RegisterEnum("storage.ListAlert_ResourceType", ListAlert_ResourceType_name, ListAlert_ResourceType_value)
	proto.RegisterType((*Alert)(nil), "storage.Alert")
	proto.RegisterType((*Alert_Deployment)(nil), "storage.Alert.Deployment")
	proto.RegisterMapType((map[string]string)(nil), "storage.Alert.Deployment.AnnotationsEntry")
	proto.RegisterMapType((map[string]string)(nil), "storage.Alert.Deployment.LabelsEntry")
	proto.RegisterType((*Alert_Deployment_Container)(nil), "storage.Alert.Deployment.Container")
	proto.RegisterType((*Alert_Resource)(nil), "storage.Alert.Resource")
	proto.RegisterType((*Alert_Violation)(nil), "storage.Alert.Violation")
	proto.RegisterType((*Alert_Violation_KeyValueAttrs)(nil), "storage.Alert.Violation.KeyValueAttrs")
	proto.RegisterType((*Alert_Violation_KeyValueAttrs_KeyValueAttr)(nil), "storage.Alert.Violation.KeyValueAttrs.KeyValueAttr")
	proto.RegisterType((*Alert_Violation_NetworkFlowInfo)(nil), "storage.Alert.Violation.NetworkFlowInfo")
	proto.RegisterType((*Alert_Violation_NetworkFlowInfo_Entity)(nil), "storage.Alert.Violation.NetworkFlowInfo.Entity")
	proto.RegisterType((*Alert_ProcessViolation)(nil), "storage.Alert.ProcessViolation")
	proto.RegisterType((*Alert_Enforcement)(nil), "storage.Alert.Enforcement")
	proto.RegisterType((*ListAlert)(nil), "storage.ListAlert")
	proto.RegisterType((*ListAlert_CommonEntityInfo)(nil), "storage.ListAlert.CommonEntityInfo")
	proto.RegisterType((*ListAlert_ResourceEntity)(nil), "storage.ListAlert.ResourceEntity")
	proto.RegisterType((*ListAlertPolicy)(nil), "storage.ListAlertPolicy")
	proto.RegisterType((*ListAlertPolicy_DevFields)(nil), "storage.ListAlertPolicy.DevFields")
	proto.RegisterType((*ListAlertDeployment)(nil), "storage.ListAlertDeployment")
}

func init() { proto.RegisterFile("storage/alert.proto", fileDescriptor_bfba8812535cd55e) }

var fileDescriptor_bfba8812535cd55e = []byte{
	// 2052 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0xcd, 0x72, 0xdb, 0xc8,
	0x11, 0x16, 0x49, 0x91, 0x22, 0x9b, 0x12, 0x05, 0x8d, 0xbc, 0x6b, 0x08, 0xb1, 0x0d, 0x2e, 0x9c,
	0x8d, 0x15, 0xc7, 0xa6, 0xbc, 0xb6, 0x93, 0x75, 0x64, 0x7b, 0xb3, 0x22, 0x45, 0x59, 0xb4, 0x24,
	0x52, 0x1e, 0x31, 0x72, 0xc5, 0xd9, 0x0a, 0x0b, 0x06, 0x47, 0x34, 0x4a, 0x10, 0xc0, 0x00, 0x90,
	0x1c, 0xee, 0x53, 0xa4, 0x72, 0xca, 0x13, 0xe4, 0x9a, 0xd7, 0xd8, 0x53, 0x6a, 0x8f, 0x39, 0x24,
	0xac, 0x94, 0xf3, 0x04, 0xe1, 0x13, 0xa4, 0x30, 0x3f, 0xf8, 0xa3, 0x64, 0x79, 0x5d, 0xa9, 0xdc,
	0x30, 0xfd, 0x37, 0x3d, 0x3d, 0xdd, 0x3d, 0x5f, 0x03, 0x96, 0x3d, 0xdf, 0x71, 0xf5, 0x01, 0x59,
	0xd3, 0x2d, 0xe2, 0xfa, 0xb5, 0xa1, 0xeb, 0xf8, 0x0e, 0x9a, 0xe3, 0x44, 0x45, 0x1d, 0x38, 0xce,
	0xc0, 0x22, 0x6b, 0x94, 0xfc, 0xfa, 0xf4, 0x68, 0xcd, 0x37, 0x4f, 0x88, 0xe7, 0xeb, 0x27, 0x43,
	0x26, 0xa9, 0xc8, 0x42, 0xbd, 0x4f, 0x86, 0x96, 0x33, 0x3a, 0x21, 0x36, 0xb7, 0xa1, 0x28, 0x82,
	0x63, 0x13, 0xff, 0xad, 0xe3, 0x1e, 0xf7, 0x8e, 0x2c, 0xe7, 0x2d, 0xe7, 0x5d, 0x11, 0xbc, 0xa1,
	0x63, 0x99, 0xc6, 0x88, 0x53, 0xd5, 0x90, 0xea, 0x3a, 0x06, 0xf1, 0xbc, 0x9e, 0x69, 0xf7, 0x4d,
	0x43, 0xf7, 0x1d, 0x57, 0xa8, 0x0d, 0x9c, 0x81, 0x43, 0x3f, 0xd7, 0x82, 0x2f, 0x46, 0xd5, 0xfe,
	0xb8, 0x02, 0xf9, 0x8d, 0xc0, 0x79, 0x74, 0x0f, 0xb2, 0x66, 0x5f, 0xce, 0x54, 0x33, 0xab, 0xa5,
	0x7a, 0x75, 0x32, 0x56, 0xaf, 0x79, 0xc4, 0xf6, 0x1c, 0xf7, 0x8d, 0xee, 0xbd, 0x59, 0xd7, 0xcc,
	0x81, 0xed, 0xb8, 0x44, 0xab, 0x7a, 0xbf, 0xb7, 0xd6, 0xb5, 0xe1, 0xb1, 0x86, 0xb3, 0x66, 0x1f,
	0xdd, 0x82, 0x02, 0x73, 0x41, 0xce, 0x56, 0x33, 0xab, 0xe5, 0xfb, 0x8b, 0x35, 0xee, 0x43, 0x6d,
	0x9f, 0x92, 0x31, 0x67, 0xa3, 0xaf, 0x61, 0xd1, 0x32, 0x8f, 0x88, 0x31, 0x32, 0x2c, 0xd2, 0xf3,
	0x7c, 0x7d, 0x40, 0xe4, 0x5c, 0x35, 0xb3, 0x5a, 0xb9, 0x7f, 0x35, 0xd4, 0xd8, 0x15, 0xfc, 0x83,
	0x80, 0x8d, 0x2b, 0x56, 0x62, 0x8d, 0xba, 0x00, 0x51, 0x8c, 0xe4, 0x59, 0xba, 0xdd, 0x4a, 0xa8,
	0x4c, 0x0f, 0x50, 0xdb, 0x0c, 0x05, 0xea, 0x57, 0x27, 0x63, 0x75, 0xf9, 0x1c, 0xff, 0xb7, 0x67,
	0x70, 0xcc, 0x0e, 0x5a, 0x83, 0xbc, 0x79, 0x12, 0x78, 0xb3, 0x48, 0x0d, 0x46, 0xde, 0x34, 0x1c,
	0xdb, 0xd7, 0x4d, 0x9b, 0xb8, 0xad, 0x80, 0xbd, 0x3d, 0x83, 0x99, 0x1c, 0xfa, 0x39, 0x14, 0x5d,
	0xe2, 0x39, 0xa7, 0xae, 0x41, 0x64, 0x29, 0xa5, 0xc3, 0x9c, 0xc0, 0x9c, 0xbd, 0x3d, 0x83, 0x43,
	0x51, 0xf4, 0x0d, 0xc0, 0x99, 0xe9, 0x58, 0xba, 0x6f, 0x3a, 0xb6, 0x27, 0xe7, 0xab, 0xb9, 0xd5,
	0xf2, 0x7d, 0x39, 0xa5, 0x78, 0x28, 0x04, 0xea, 0xda, 0x64, 0xac, 0xde, 0x38, 0x37, 0xf8, 0x44,
	0x77, 0x8d, 0x37, 0xeb, 0xda, 0x5d, 0x0d, 0xc7, 0xec, 0xa1, 0x6f, 0x60, 0x49, 0xdc, 0x79, 0x48,
	0x95, 0x17, 0xa8, 0x77, 0x6a, 0x6a, 0x93, 0x7d, 0x26, 0x17, 0xed, 0x55, 0x99, 0x8c, 0x55, 0x88,
	0xd9, 0x95, 0x86, 0x29, 0x09, 0xf4, 0x04, 0xca, 0xc4, 0x3e, 0x72, 0x5c, 0x83, 0xd0, 0xd0, 0x17,
	0xa8, 0x5d, 0x25, 0x65, 0xb7, 0x19, 0x49, 0xe0, 0xb8, 0x38, 0x7a, 0x06, 0xb3, 0x41, 0xd2, 0xcb,
	0x73, 0x5c, 0x8d, 0x55, 0x44, 0x4d, 0x54, 0x44, 0xad, 0x2b, 0x2a, 0xe2, 0xc2, 0x2b, 0xc3, 0xd4,
	0x00, 0x7a, 0x05, 0x95, 0x23, 0xd3, 0xf5, 0xfc, 0x9e, 0x63, 0x18, 0xa7, 0xae, 0x4b, 0xfa, 0x32,
	0x7c, 0xbc, 0xc9, 0x05, 0x6a, 0xaa, 0xc3, 0x2d, 0xa1, 0x2e, 0x94, 0x83, 0xab, 0xb2, 0xce, 0x48,
	0xbf, 0xa7, 0xfb, 0xf2, 0xd2, 0xc7, 0x1b, 0x06, 0x61, 0x67, 0xc3, 0x47, 0x2f, 0x20, 0xef, 0xf9,
	0xba, 0x4f, 0xe4, 0x72, 0x2a, 0xd5, 0xc3, 0xd8, 0x1e, 0x04, 0x6c, 0x71, 0xdd, 0xec, 0x0a, 0x42,
	0x5e, 0x95, 0x32, 0xef, 0x04, 0x3a, 0x44, 0xc3, 0xcc, 0x12, 0x7a, 0x0c, 0x65, 0xcf, 0x76, 0x9c,
	0x6f, 0x49, 0xcf, 0x37, 0x2d, 0x4b, 0x9e, 0xbf, 0xcc, 0x51, 0x0c, 0x4c, 0xbc, 0x6b, 0x5a, 0x16,
	0x42, 0x30, 0xeb, 0xeb, 0x03, 0x4f, 0xae, 0x54, 0x73, 0xab, 0x25, 0x4c, 0xbf, 0x95, 0xef, 0xf2,
	0x00, 0x51, 0xd9, 0xa0, 0x2f, 0x63, 0x2d, 0xe0, 0xd6, 0x64, 0xac, 0xde, 0x14, 0x6e, 0x45, 0x32,
	0xd5, 0xd6, 0x26, 0x73, 0xea, 0xce, 0x1b, 0xb3, 0xdf, 0x27, 0x36, 0xeb, 0x04, 0x5f, 0xc0, 0xac,
	0xad, 0x9f, 0x10, 0xda, 0x07, 0x4a, 0xf5, 0xeb, 0x93, 0xb1, 0xba, 0x32, 0xad, 0x2a, 0x0e, 0x43,
	0x45, 0xa9, 0x3b, 0xa3, 0x21, 0xa1, 0xb5, 0x1c, 0xb8, 0x33, 0x1a, 0x12, 0x74, 0x0d, 0x4a, 0x01,
	0xcf, 0x1b, 0xea, 0x06, 0x91, 0xf3, 0x94, 0x11, 0x11, 0xd0, 0x67, 0x30, 0x1f, 0x2e, 0x7a, 0x66,
	0x9f, 0x16, 0x60, 0x09, 0x97, 0x43, 0x5a, 0xab, 0x8f, 0x9e, 0x42, 0xc1, 0xd2, 0x5f, 0x13, 0xcb,
	0x93, 0xe7, 0x68, 0x91, 0x7d, 0x7e, 0x61, 0x8b, 0xa8, 0xed, 0x52, 0xb9, 0xa6, 0xed, 0xbb, 0x23,
	0xcc, 0x95, 0xd0, 0x75, 0x00, 0xc3, 0x3a, 0xf5, 0x7c, 0xe2, 0x06, 0xf6, 0x4b, 0xcc, 0x01, 0x4e,
	0x69, 0xf5, 0x03, 0x07, 0x04, 0x9b, 0x9e, 0x16, 0x98, 0x03, 0x9c, 0xd6, 0x0e, 0x4e, 0xd5, 0x00,
	0x30, 0x44, 0xef, 0xf0, 0xe4, 0x32, 0x75, 0xe2, 0xe6, 0xc5, 0x4e, 0x84, 0x7d, 0x06, 0xc7, 0xd4,
	0xd0, 0x2e, 0x94, 0x75, 0xdb, 0x76, 0x7c, 0xde, 0x2f, 0x2a, 0xd4, 0xca, 0xed, 0x8b, 0xad, 0x6c,
	0x44, 0xc2, 0xec, 0x3c, 0x71, 0x75, 0xa4, 0x40, 0xd1, 0xb4, 0x75, 0xc3, 0x37, 0xcf, 0x58, 0x9f,
	0x2b, 0xe2, 0x70, 0xad, 0xfc, 0x12, 0xca, 0xb1, 0x38, 0x20, 0x09, 0x72, 0xc7, 0x64, 0xc4, 0x12,
	0x00, 0x07, 0x9f, 0xe8, 0x0a, 0xe4, 0xcf, 0x74, 0xeb, 0x94, 0xdf, 0x2c, 0x66, 0x8b, 0xf5, 0xec,
	0xa3, 0x8c, 0xd2, 0x86, 0x52, 0xe8, 0x3d, 0xba, 0x2b, 0x1a, 0x69, 0xee, 0xbd, 0x8d, 0x54, 0xb4,
	0x51, 0xc4, 0xd3, 0x85, 0x05, 0x90, 0x7e, 0x2b, 0x5f, 0x81, 0x94, 0x3e, 0xc7, 0x0f, 0xf2, 0xe7,
	0x2f, 0x59, 0x28, 0x8a, 0xe6, 0x8b, 0x5a, 0xb0, 0x20, 0x9a, 0x6f, 0x8f, 0x66, 0x59, 0x86, 0xd6,
	0xe0, 0x8f, 0x2f, 0x68, 0xd6, 0xe1, 0x47, 0x77, 0x34, 0x24, 0x78, 0xde, 0x8d, 0xad, 0x42, 0x5f,
	0xb3, 0x91, 0xaf, 0xa9, 0x3c, 0xc9, 0x5d, 0x96, 0x27, 0xb3, 0xd3, 0x79, 0xf2, 0xc3, 0x32, 0xbd,
	0x30, 0x95, 0xe9, 0xda, 0x23, 0x98, 0x8f, 0x3b, 0x8d, 0xca, 0x30, 0xf7, 0xeb, 0xf6, 0x4e, 0xbb,
	0xf3, 0xb2, 0x2d, 0xcd, 0x04, 0x8b, 0x83, 0x66, 0x03, 0x37, 0xbb, 0x07, 0x52, 0x06, 0x55, 0x00,
	0x1a, 0x9d, 0xf6, 0x56, 0xeb, 0xd9, 0xde, 0xc6, 0xfe, 0x81, 0x94, 0x55, 0xbe, 0x9f, 0x83, 0x52,
	0xd4, 0xde, 0x65, 0x98, 0x3b, 0x21, 0x9e, 0x17, 0xdc, 0x1d, 0x0b, 0xb3, 0x58, 0xa2, 0x7d, 0x58,
	0x3c, 0x26, 0xa3, 0x1e, 0x8d, 0x70, 0x4f, 0xf7, 0x7d, 0xd7, 0xe3, 0xef, 0xee, 0x4f, 0x2e, 0x7a,
	0xb9, 0x6a, 0x3b, 0x64, 0x74, 0x18, 0x88, 0x6f, 0x04, 0xd2, 0xdb, 0x33, 0x78, 0xe1, 0x38, 0x4e,
	0x40, 0x87, 0xb0, 0x14, 0x87, 0x33, 0x3d, 0xd3, 0x3e, 0x72, 0xf8, 0xcb, 0xb0, 0x7a, 0xa1, 0xcd,
	0x36, 0xd3, 0xd8, 0xb2, 0x9c, 0xb7, 0x2d, 0xfb, 0xc8, 0xd9, 0x9e, 0xc1, 0x8b, 0x76, 0x92, 0x14,
	0x74, 0x1f, 0x7a, 0xc9, 0x79, 0x7a, 0xc9, 0xd7, 0x2f, 0x34, 0x45, 0x6f, 0x97, 0x75, 0x9a, 0x1a,
	0x7f, 0x97, 0x0a, 0x97, 0xb6, 0x50, 0x2a, 0xa7, 0xfc, 0x29, 0x03, 0x0b, 0x89, 0xd3, 0xa1, 0x16,
	0xe4, 0x59, 0x50, 0x32, 0xb4, 0x3c, 0x1f, 0x7c, 0x58, 0x50, 0x12, 0x2b, 0xcc, 0x2c, 0x28, 0xbf,
	0x80, 0xf9, 0x38, 0xf9, 0x43, 0xd3, 0x5e, 0xf9, 0x6b, 0x0e, 0x16, 0x53, 0xe1, 0x41, 0x6b, 0x50,
	0xa4, 0x87, 0x30, 0x1c, 0x8b, 0x27, 0xfd, 0x72, 0x84, 0xb1, 0x1e, 0xee, 0x73, 0x16, 0x0e, 0x85,
	0xd0, 0x33, 0x28, 0x70, 0x40, 0xc3, 0x40, 0xdc, 0xda, 0x87, 0xde, 0x44, 0xad, 0x69, 0xfb, 0xa6,
	0x3f, 0xc2, 0x5c, 0x1d, 0xbd, 0x80, 0x72, 0x9f, 0x78, 0xbe, 0x69, 0x33, 0x00, 0x92, 0xfb, 0x38,
	0x6b, 0x71, 0x1b, 0xca, 0xdf, 0x32, 0x50, 0x60, 0xf4, 0xb0, 0x0c, 0x33, 0xb1, 0x32, 0xfc, 0x3a,
	0x80, 0x26, 0x01, 0x97, 0xd5, 0x78, 0x96, 0x1e, 0x37, 0x82, 0x3c, 0x7c, 0x07, 0x66, 0x80, 0xee,
	0x41, 0x13, 0x00, 0x98, 0x0e, 0xad, 0x9a, 0x2f, 0xe0, 0x4a, 0x04, 0x07, 0x7b, 0x51, 0x45, 0xb2,
	0x92, 0x5e, 0x8e, 0x78, 0xed, 0xb0, 0x36, 0x6f, 0xc1, 0x62, 0x4c, 0x25, 0xcc, 0xbb, 0x12, 0xae,
	0x44, 0x64, 0xd1, 0x38, 0x86, 0x8e, 0xcb, 0x10, 0x53, 0x1e, 0xd3, 0x6f, 0xed, 0x21, 0xcc, 0x8a,
	0x6a, 0x7d, 0xd6, 0x6c, 0x37, 0x71, 0xab, 0x21, 0xcd, 0xa0, 0x05, 0x28, 0xed, 0x3c, 0x3a, 0xe8,
	0x35, 0x0f, 0x9b, 0xed, 0xae, 0x94, 0x41, 0x12, 0xcc, 0xb7, 0x9b, 0xdd, 0x97, 0x1d, 0xbc, 0xd3,
	0xdb, 0xda, 0xed, 0xbc, 0x94, 0xb2, 0xf5, 0x65, 0x58, 0xda, 0x63, 0x45, 0x19, 0xa4, 0x87, 0xf9,
	0xfa, 0xd4, 0x27, 0xde, 0xf3, 0xd9, 0x62, 0x56, 0xca, 0x3d, 0x9f, 0x2d, 0xe6, 0xa4, 0x59, 0x85,
	0x80, 0x94, 0x46, 0x76, 0xef, 0x29, 0xec, 0x2f, 0xa1, 0xc4, 0x51, 0x1e, 0xf1, 0xe4, 0x2c, 0xcd,
	0xde, 0x08, 0x4a, 0x73, 0x3b, 0x2d, 0x31, 0x3c, 0xe0, 0x48, 0x56, 0xf9, 0x2d, 0x94, 0x63, 0x40,
	0x0f, 0xdd, 0x87, 0x42, 0xf0, 0x8c, 0x38, 0x36, 0x4f, 0xb4, 0x08, 0x14, 0xc6, 0xa4, 0x36, 0xa8,
	0x04, 0xe6, 0x92, 0x71, 0xaf, 0xb2, 0x09, 0xaf, 0xea, 0x45, 0x71, 0xd5, 0xda, 0x3f, 0x4b, 0x50,
	0xda, 0x35, 0x3d, 0x9f, 0x8d, 0x25, 0x95, 0x08, 0x93, 0x50, 0xa8, 0xd1, 0x9f, 0x9e, 0x25, 0xb2,
	0xef, 0x9d, 0x25, 0x92, 0x00, 0x2b, 0xe4, 0x55, 0x29, 0x53, 0x60, 0x92, 0xf4, 0xbc, 0xb1, 0xc3,
	0xfb, 0x43, 0xee, 0x52, 0x2c, 0xf8, 0xa3, 0xc9, 0x58, 0xbd, 0x3a, 0x0d, 0xdf, 0x02, 0x01, 0x81,
	0x5d, 0xef, 0x85, 0x73, 0x12, 0x6b, 0xa0, 0x72, 0xcc, 0x53, 0x7e, 0xcc, 0xd4, 0xc0, 0x14, 0x62,
	0xc7, 0xc2, 0xff, 0x0c, 0x3b, 0xfe, 0x0c, 0x96, 0x62, 0xc0, 0xbc, 0x67, 0x38, 0xa7, 0xb6, 0x4f,
	0x9b, 0x6f, 0x1e, 0x4b, 0x31, 0x46, 0x23, 0xa0, 0xa3, 0xdb, 0x1c, 0x2b, 0x16, 0x03, 0xac, 0x58,
	0xff, 0x74, 0x32, 0x56, 0x91, 0xd8, 0xa5, 0xab, 0x0f, 0x42, 0x20, 0x17, 0xc8, 0x20, 0x03, 0x50,
	0xdc, 0x30, 0x4f, 0x89, 0xd2, 0x65, 0x29, 0x51, 0x97, 0x27, 0x63, 0xf5, 0x8a, 0xb0, 0x1a, 0x63,
	0x6b, 0x38, 0xee, 0x28, 0x13, 0x46, 0x2f, 0x00, 0x19, 0xce, 0xc9, 0x89, 0x63, 0xf7, 0x78, 0xc5,
	0xd3, 0xb7, 0x83, 0x8d, 0x00, 0x37, 0xa7, 0xc3, 0x59, 0x6b, 0x50, 0xe1, 0xa8, 0xf4, 0xb1, 0x64,
	0xa4, 0x28, 0xe8, 0xab, 0xc4, 0x48, 0x99, 0xa7, 0xa6, 0xae, 0x4d, 0x9b, 0x8a, 0x70, 0x56, 0x6a,
	0x78, 0xfc, 0x55, 0x6c, 0x16, 0x2c, 0x53, 0xed, 0xcf, 0xce, 0x71, 0x44, 0x3c, 0xd2, 0x6c, 0xe3,
	0xf8, 0x54, 0xa8, 0xfc, 0x27, 0x0b, 0x52, 0xda, 0x4f, 0xf4, 0x34, 0x85, 0x1d, 0x18, 0x18, 0x57,
	0x26, 0x63, 0xf5, 0x53, 0x11, 0xab, 0x06, 0xe3, 0x8b, 0x5b, 0x48, 0xe0, 0x8a, 0xf5, 0x38, 0xae,
	0x60, 0x68, 0xfc, 0xda, 0x64, 0xac, 0xca, 0x42, 0x37, 0xec, 0x63, 0x42, 0x3b, 0x86, 0x3a, 0x9e,
	0x4c, 0xa3, 0x9a, 0x24, 0x94, 0xe7, 0x1b, 0x87, 0x23, 0x80, 0x16, 0x07, 0x3d, 0x4f, 0x52, 0x98,
	0x85, 0x82, 0x9e, 0xfa, 0xca, 0x64, 0xac, 0x7e, 0x32, 0xb5, 0x79, 0xb5, 0xb5, 0xa9, 0x25, 0x81,
	0xfb, 0x51, 0x1a, 0xb0, 0xe5, 0x53, 0xcd, 0x7c, 0x3a, 0xa2, 0x41, 0x23, 0x15, 0x3f, 0x2a, 0x98,
	0x7d, 0xc1, 0xa9, 0x06, 0x2c, 0xe1, 0x62, 0x02, 0xcd, 0x29, 0x8f, 0xa1, 0x92, 0xbc, 0x11, 0xf4,
	0xd3, 0xf8, 0xc3, 0x52, 0xff, 0x64, 0x32, 0x56, 0x97, 0xd2, 0xf6, 0xf8, 0xc8, 0xa2, 0x3d, 0x4e,
	0x61, 0xae, 0x0a, 0xc0, 0x66, 0x73, 0x7f, 0xb7, 0xf3, 0x9b, 0xbd, 0xa0, 0x73, 0xbf, 0x1f, 0x76,
	0xc5, 0xfa, 0xdb, 0x3f, 0x72, 0xb0, 0x98, 0x2a, 0x7c, 0xf4, 0x20, 0x36, 0x79, 0xdd, 0x9c, 0x8c,
	0x55, 0x55, 0xf8, 0xc0, 0xf8, 0xe7, 0x4f, 0x5d, 0x77, 0x13, 0x53, 0x57, 0x22, 0xd4, 0x4c, 0x2d,
	0x39, 0x71, 0x3d, 0x87, 0xa2, 0x47, 0xce, 0x88, 0x6b, 0xfa, 0x23, 0xfe, 0xfb, 0x65, 0x29, 0x0c,
	0xef, 0x01, 0x67, 0x24, 0xdb, 0x99, 0xa0, 0x0a, 0x3b, 0xa1, 0x3e, 0xaa, 0xd2, 0xc7, 0xde, 0x70,
	0xcd, 0x21, 0xad, 0x76, 0x8e, 0x70, 0x63, 0x24, 0xf4, 0x18, 0xc0, 0xd0, 0x7d, 0x32, 0x70, 0x5c,
	0x93, 0xb0, 0x7f, 0x1e, 0xa5, 0xa4, 0xf1, 0x06, 0xe3, 0x86, 0xc6, 0x63, 0xe2, 0xe8, 0x77, 0xb0,
	0xd2, 0x27, 0x67, 0xc4, 0x72, 0x86, 0x41, 0x32, 0xda, 0x3e, 0x71, 0x6d, 0xdd, 0xea, 0x1d, 0x99,
	0xc4, 0xea, 0x7b, 0x1c, 0xb3, 0x69, 0x17, 0x35, 0xd1, 0xda, 0x26, 0x39, 0xdb, 0xa2, 0x92, 0xf8,
	0x6a, 0x68, 0xa4, 0xc5, 0x6d, 0x30, 0x86, 0xf2, 0x0a, 0x4a, 0xa1, 0x14, 0xda, 0x83, 0xd2, 0x41,
	0x07, 0x77, 0x59, 0xbd, 0x51, 0xa8, 0x5d, 0xbf, 0x37, 0x19, 0xab, 0x77, 0xc2, 0x28, 0x04, 0x4c,
	0x1e, 0x50, 0x16, 0xfe, 0x3b, 0xba, 0xad, 0x5b, 0xa3, 0x6f, 0x89, 0xfb, 0xf4, 0x98, 0x8c, 0xde,
	0x3a, 0x6e, 0x5f, 0xc3, 0xc5, 0x40, 0x2a, 0x48, 0x70, 0xed, 0xef, 0x59, 0x58, 0x3e, 0xa7, 0x7b,
	0xfc, 0x5f, 0x87, 0xeb, 0xcf, 0xcf, 0x9b, 0x40, 0xea, 0x59, 0x39, 0x93, 0xec, 0x16, 0xd5, 0xa9,
	0x29, 0x84, 0xca, 0x24, 0x26, 0x91, 0x78, 0x4f, 0x28, 0x44, 0x22, 0xf1, 0xc2, 0x8f, 0xe6, 0xcb,
	0xe0, 0x3d, 0x29, 0x26, 0x8b, 0xb2, 0xc5, 0x79, 0xd5, 0xc8, 0x57, 0x2d, 0x9a, 0x40, 0x03, 0x4f,
	0x13, 0x6d, 0xa3, 0x18, 0x79, 0x1a, 0xeb, 0x0f, 0x0c, 0xe7, 0xdc, 0xde, 0x82, 0x4a, 0xf2, 0x01,
	0x44, 0x00, 0x85, 0x8d, 0x46, 0xb7, 0x75, 0xd8, 0xe4, 0xe5, 0xd7, 0xee, 0x74, 0x5e, 0x35, 0x37,
	0xa5, 0x0c, 0x9a, 0x87, 0x22, 0x6e, 0x1e, 0x74, 0x76, 0x0f, 0x9b, 0x9b, 0x52, 0x36, 0x80, 0x58,
	0x1b, 0xdd, 0x6e, 0x73, 0x6f, 0xbf, 0xdb, 0xdc, 0x94, 0x72, 0xf5, 0x87, 0xdf, 0xbd, 0xbb, 0x91,
	0xf9, 0xfe, 0xdd, 0x8d, 0xcc, 0xbf, 0xde, 0xdd, 0xc8, 0xfc, 0xf9, 0xdf, 0x37, 0x66, 0x60, 0xc5,
	0x74, 0x6a, 0x9e, 0xaf, 0x1b, 0xc7, 0xae, 0xf3, 0x07, 0xf6, 0xca, 0x8b, 0xf4, 0x7a, 0x25, 0x7e,
	0xe7, 0xbe, 0x2e, 0x50, 0xfa, 0x83, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0xa9, 0xd2, 0xbc, 0xc8,
	0xf5, 0x15, 0x00, 0x00,
}

func (m *Alert) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Alert) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Alert) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ResolvedAt != nil {
		{
			size, err := m.ResolvedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if m.Entity != nil {
		{
			size := m.Entity.Size()
			i -= size
			if _, err := m.Entity.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAlert(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x72
		}
	}
	if m.ProcessViolation != nil {
		{
			size, err := m.ProcessViolation.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	if m.SnoozeTill != nil {
		{
			size, err := m.SnoozeTill.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if m.State != 0 {
		i = encodeVarintAlert(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x58
	}
	if m.FirstOccurred != nil {
		{
			size, err := m.FirstOccurred.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.Time != nil {
		{
			size, err := m.Time.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.Enforcement != nil {
		{
			size, err := m.Enforcement.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.Violations) > 0 {
		for iNdEx := len(m.Violations) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Violations[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAlert(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.LifecycleStage != 0 {
		i = encodeVarintAlert(dAtA, i, uint64(m.LifecycleStage))
		i--
		dAtA[i] = 0x18
	}
	if m.Policy != nil {
		{
			size, err := m.Policy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Alert_Deployment_) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Alert_Deployment_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Deployment != nil {
		{
			size, err := m.Deployment.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *Alert_Image) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Alert_Image) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Image != nil {
		{
			size, err := m.Image.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x7a
	}
	return len(dAtA) - i, nil
}
func (m *Alert_Resource_) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Alert_Resource_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Resource != nil {
		{
			size, err := m.Resource.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	return len(dAtA) - i, nil
}
func (m *Alert_Deployment) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Alert_Deployment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Alert_Deployment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if m.Inactive {
		i--
		if m.Inactive {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x78
	}
	if len(m.Annotations) > 0 {
		for k := range m.Annotations {
			v := m.Annotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintAlert(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAlert(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAlert(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x72
		}
	}
	if len(m.Containers) > 0 {
		for iNdEx := len(m.Containers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Containers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAlert(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x5a
		}
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintAlert(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAlert(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAlert(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Alert_Deployment_Container) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Alert_Deployment_Container) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Alert_Deployment_Container) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x52
	}
	if m.Image != nil {
		{
			size, err := m.Image.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}

func (m *Alert_Resource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Alert_Resource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Alert_Resource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if m.ResourceType != 0 {
		i = encodeVarintAlert(dAtA, i, uint64(m.ResourceType))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Alert_Violation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Alert_Violation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Alert_Violation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MessageAttributes != nil {
		{
			size := m.MessageAttributes.Size()
			i -= size
			if _, err := m.MessageAttributes.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Time != nil {
		{
			size, err := m.Time.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.Type != 0 {
		i = encodeVarintAlert(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Alert_Violation_KeyValueAttrs_) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Alert_Violation_KeyValueAttrs_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.KeyValueAttrs != nil {
		{
			size, err := m.KeyValueAttrs.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *Alert_Violation_NetworkFlowInfo_) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Alert_Violation_NetworkFlowInfo_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.NetworkFlowInfo != nil {
		{
			size, err := m.NetworkFlowInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *Alert_Violation_KeyValueAttrs) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Alert_Violation_KeyValueAttrs) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Alert_Violation_KeyValueAttrs) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Attrs) > 0 {
		for iNdEx := len(m.Attrs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attrs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAlert(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Alert_Violation_KeyValueAttrs_KeyValueAttr) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Alert_Violation_KeyValueAttrs_KeyValueAttr) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Alert_Violation_KeyValueAttrs_KeyValueAttr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Alert_Violation_NetworkFlowInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Alert_Violation_NetworkFlowInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Alert_Violation_NetworkFlowInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Destination != nil {
		{
			size, err := m.Destination.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Source != nil {
		{
			size, err := m.Source.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Protocol != 0 {
		i = encodeVarintAlert(dAtA, i, uint64(m.Protocol))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Alert_Violation_NetworkFlowInfo_Entity) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Alert_Violation_NetworkFlowInfo_Entity) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Alert_Violation_NetworkFlowInfo_Entity) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Port != 0 {
		i = encodeVarintAlert(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x30
	}
	if len(m.DeploymentType) > 0 {
		i -= len(m.DeploymentType)
		copy(dAtA[i:], m.DeploymentType)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.DeploymentType)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.DeploymentNamespace) > 0 {
		i -= len(m.DeploymentNamespace)
		copy(dAtA[i:], m.DeploymentNamespace)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.DeploymentNamespace)))
		i--
		dAtA[i] = 0x1a
	}
	if m.EntityType != 0 {
		i = encodeVarintAlert(dAtA, i, uint64(m.EntityType))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Alert_ProcessViolation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Alert_ProcessViolation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Alert_ProcessViolation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Processes) > 0 {
		for iNdEx := len(m.Processes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Processes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAlert(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Alert_Enforcement) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Alert_Enforcement) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Alert_Enforcement) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x12
	}
	if m.Action != 0 {
		i = encodeVarintAlert(dAtA, i, uint64(m.Action))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ListAlert) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListAlert) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListAlert) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Entity != nil {
		{
			size := m.Entity.Size()
			i -= size
			if _, err := m.Entity.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.CommonEntityInfo != nil {
		{
			size, err := m.CommonEntityInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.EnforcementAction != 0 {
		i = encodeVarintAlert(dAtA, i, uint64(m.EnforcementAction))
		i--
		dAtA[i] = 0x48
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintAlert(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if m.EnforcementCount != 0 {
		i = encodeVarintAlert(dAtA, i, uint64(m.EnforcementCount))
		i--
		dAtA[i] = 0x38
	}
	if m.State != 0 {
		i = encodeVarintAlert(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x30
	}
	if m.Policy != nil {
		{
			size, err := m.Policy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Time != nil {
		{
			size, err := m.Time.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.LifecycleStage != 0 {
		i = encodeVarintAlert(dAtA, i, uint64(m.LifecycleStage))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListAlert_Deployment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListAlert_Deployment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Deployment != nil {
		{
			size, err := m.Deployment.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *ListAlert_Resource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListAlert_Resource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Resource != nil {
		{
			size, err := m.Resource.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	return len(dAtA) - i, nil
}
func (m *ListAlert_CommonEntityInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListAlert_CommonEntityInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListAlert_CommonEntityInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ResourceType != 0 {
		i = encodeVarintAlert(dAtA, i, uint64(m.ResourceType))
		i--
		dAtA[i] = 0x28
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListAlert_ResourceEntity) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListAlert_ResourceEntity) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListAlert_ResourceEntity) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListAlertPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListAlertPolicy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListAlertPolicy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.DeveloperInternalFields != nil {
		{
			size, err := m.DeveloperInternalFields.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlert(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.Categories) > 0 {
		for iNdEx := len(m.Categories) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Categories[iNdEx])
			copy(dAtA[i:], m.Categories[iNdEx])
			i = encodeVarintAlert(dAtA, i, uint64(len(m.Categories[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if m.Severity != 0 {
		i = encodeVarintAlert(dAtA, i, uint64(m.Severity))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListAlertPolicy_DevFields) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListAlertPolicy_DevFields) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListAlertPolicy_DevFields) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.SORTName) > 0 {
		i -= len(m.SORTName)
		copy(dAtA[i:], m.SORTName)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.SORTName)))
		i--
		dAtA[i] = 0x32
	}
	return len(dAtA) - i, nil
}

func (m *ListAlertDeployment) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListAlertDeployment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListAlertDeployment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0x42
	}
	if m.Inactive {
		i--
		if m.Inactive {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintAlert(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintAlert(dAtA []byte, offset int, v uint64) int {
	offset -= sovAlert(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Alert) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.Policy != nil {
		l = m.Policy.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.LifecycleStage != 0 {
		n += 1 + sovAlert(uint64(m.LifecycleStage))
	}
	if m.Entity != nil {
		n += m.Entity.Size()
	}
	if len(m.Violations) > 0 {
		for _, e := range m.Violations {
			l = e.Size()
			n += 1 + l + sovAlert(uint64(l))
		}
	}
	if m.Enforcement != nil {
		l = m.Enforcement.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.Time != nil {
		l = m.Time.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.FirstOccurred != nil {
		l = m.FirstOccurred.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovAlert(uint64(m.State))
	}
	if m.SnoozeTill != nil {
		l = m.SnoozeTill.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.ProcessViolation != nil {
		l = m.ProcessViolation.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAlert(uint64(l))
		}
	}
	if m.ResolvedAt != nil {
		l = m.ResolvedAt.Size()
		n += 2 + l + sovAlert(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Alert_Deployment_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Deployment != nil {
		l = m.Deployment.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	return n
}
func (m *Alert_Image) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Image != nil {
		l = m.Image.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	return n
}
func (m *Alert_Resource_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Resource != nil {
		l = m.Resource.Size()
		n += 2 + l + sovAlert(uint64(l))
	}
	return n
}
func (m *Alert_Deployment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAlert(uint64(len(k))) + 1 + len(v) + sovAlert(uint64(len(v)))
			n += mapEntrySize + 1 + sovAlert(uint64(mapEntrySize))
		}
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	if len(m.Containers) > 0 {
		for _, e := range m.Containers {
			l = e.Size()
			n += 1 + l + sovAlert(uint64(l))
		}
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAlert(uint64(len(k))) + 1 + len(v) + sovAlert(uint64(len(v)))
			n += mapEntrySize + 1 + sovAlert(uint64(mapEntrySize))
		}
	}
	if m.Inactive {
		n += 2
	}
	l = len(m.NamespaceId)
	if l > 0 {
		n += 2 + l + sovAlert(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Alert_Deployment_Container) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Image != nil {
		l = m.Image.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Alert_Resource) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ResourceType != 0 {
		n += 1 + sovAlert(uint64(m.ResourceType))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Alert_Violation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.MessageAttributes != nil {
		n += m.MessageAttributes.Size()
	}
	if m.Type != 0 {
		n += 1 + sovAlert(uint64(m.Type))
	}
	if m.Time != nil {
		l = m.Time.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Alert_Violation_KeyValueAttrs_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.KeyValueAttrs != nil {
		l = m.KeyValueAttrs.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	return n
}
func (m *Alert_Violation_NetworkFlowInfo_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NetworkFlowInfo != nil {
		l = m.NetworkFlowInfo.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	return n
}
func (m *Alert_Violation_KeyValueAttrs) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Attrs) > 0 {
		for _, e := range m.Attrs {
			l = e.Size()
			n += 1 + l + sovAlert(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Alert_Violation_KeyValueAttrs_KeyValueAttr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Alert_Violation_NetworkFlowInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Protocol != 0 {
		n += 1 + sovAlert(uint64(m.Protocol))
	}
	if m.Source != nil {
		l = m.Source.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.Destination != nil {
		l = m.Destination.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Alert_Violation_NetworkFlowInfo_Entity) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.EntityType != 0 {
		n += 1 + sovAlert(uint64(m.EntityType))
	}
	l = len(m.DeploymentNamespace)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	l = len(m.DeploymentType)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovAlert(uint64(m.Port))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Alert_ProcessViolation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	if len(m.Processes) > 0 {
		for _, e := range m.Processes {
			l = e.Size()
			n += 1 + l + sovAlert(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Alert_Enforcement) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Action != 0 {
		n += 1 + sovAlert(uint64(m.Action))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListAlert) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.LifecycleStage != 0 {
		n += 1 + sovAlert(uint64(m.LifecycleStage))
	}
	if m.Time != nil {
		l = m.Time.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.Policy != nil {
		l = m.Policy.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.Entity != nil {
		n += m.Entity.Size()
	}
	if m.State != 0 {
		n += 1 + sovAlert(uint64(m.State))
	}
	if m.EnforcementCount != 0 {
		n += 1 + sovAlert(uint64(m.EnforcementCount))
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovAlert(uint64(l))
		}
	}
	if m.EnforcementAction != 0 {
		n += 1 + sovAlert(uint64(m.EnforcementAction))
	}
	if m.CommonEntityInfo != nil {
		l = m.CommonEntityInfo.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListAlert_Deployment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Deployment != nil {
		l = m.Deployment.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	return n
}
func (m *ListAlert_Resource) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Resource != nil {
		l = m.Resource.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	return n
}
func (m *ListAlert_CommonEntityInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.ResourceType != 0 {
		n += 1 + sovAlert(uint64(m.ResourceType))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListAlert_ResourceEntity) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListAlertPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.Severity != 0 {
		n += 1 + sovAlert(uint64(m.Severity))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	if len(m.Categories) > 0 {
		for _, s := range m.Categories {
			l = len(s)
			n += 1 + l + sovAlert(uint64(l))
		}
	}
	if m.DeveloperInternalFields != nil {
		l = m.DeveloperInternalFields.Size()
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListAlertPolicy_DevFields) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SORTName)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListAlertDeployment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.Inactive {
		n += 2
	}
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovAlert(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovAlert(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozAlert(x uint64) (n int) {
	return sovAlert(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Alert) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Alert: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Alert: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Policy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Policy == nil {
				m.Policy = &Policy{}
			}
			if err := m.Policy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LifecycleStage", wireType)
			}
			m.LifecycleStage = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LifecycleStage |= LifecycleStage(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Alert_Deployment{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Entity = &Alert_Deployment_{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Violations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Violations = append(m.Violations, &Alert_Violation{})
			if err := m.Violations[len(m.Violations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Enforcement", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Enforcement == nil {
				m.Enforcement = &Alert_Enforcement{}
			}
			if err := m.Enforcement.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Time == nil {
				m.Time = &types.Timestamp{}
			}
			if err := m.Time.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstOccurred", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FirstOccurred == nil {
				m.FirstOccurred = &types.Timestamp{}
			}
			if err := m.FirstOccurred.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= ViolationState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SnoozeTill", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SnoozeTill == nil {
				m.SnoozeTill = &types.Timestamp{}
			}
			if err := m.SnoozeTill.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessViolation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProcessViolation == nil {
				m.ProcessViolation = &Alert_ProcessViolation{}
			}
			if err := m.ProcessViolation.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tags = append(m.Tags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ContainerImage{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Entity = &Alert_Image{v}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Alert_Resource{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Entity = &Alert_Resource_{v}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolvedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResolvedAt == nil {
				m.ResolvedAt = &types.Timestamp{}
			}
			if err := m.ResolvedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Alert_Deployment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Deployment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Deployment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAlert
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAlert
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAlert
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthAlert
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAlert
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthAlert
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthAlert
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAlert(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthAlert
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Containers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Containers = append(m.Containers, &Alert_Deployment_Container{})
			if err := m.Containers[len(m.Containers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Annotations == nil {
				m.Annotations = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAlert
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAlert
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAlert
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthAlert
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAlert
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthAlert
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthAlert
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAlert(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthAlert
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Annotations[mapkey] = mapvalue
			iNdEx = postIndex
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Inactive", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Inactive = bool(v != 0)
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Alert_Deployment_Container) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Container: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Container: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Image == nil {
				m.Image = &ContainerImage{}
			}
			if err := m.Image.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Alert_Resource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Resource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Resource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceType", wireType)
			}
			m.ResourceType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ResourceType |= Alert_Resource_ResourceType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Alert_Violation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Violation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Violation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyValueAttrs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Alert_Violation_KeyValueAttrs{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.MessageAttributes = &Alert_Violation_KeyValueAttrs_{v}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= Alert_Violation_Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Time == nil {
				m.Time = &types.Timestamp{}
			}
			if err := m.Time.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkFlowInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Alert_Violation_NetworkFlowInfo{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.MessageAttributes = &Alert_Violation_NetworkFlowInfo_{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Alert_Violation_KeyValueAttrs) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeyValueAttrs: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeyValueAttrs: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attrs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attrs = append(m.Attrs, &Alert_Violation_KeyValueAttrs_KeyValueAttr{})
			if err := m.Attrs[len(m.Attrs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Alert_Violation_KeyValueAttrs_KeyValueAttr) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeyValueAttr: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeyValueAttr: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Alert_Violation_NetworkFlowInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkFlowInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkFlowInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			m.Protocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Protocol |= L4Protocol(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Source == nil {
				m.Source = &Alert_Violation_NetworkFlowInfo_Entity{}
			}
			if err := m.Source.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Destination", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Destination == nil {
				m.Destination = &Alert_Violation_NetworkFlowInfo_Entity{}
			}
			if err := m.Destination.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Alert_Violation_NetworkFlowInfo_Entity) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Entity: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Entity: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EntityType", wireType)
			}
			m.EntityType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EntityType |= NetworkEntityInfo_Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAlert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Alert_ProcessViolation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessViolation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessViolation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Processes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Processes = append(m.Processes, &ProcessIndicator{})
			if err := m.Processes[len(m.Processes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Alert_Enforcement) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Enforcement: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Enforcement: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			m.Action = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Action |= EnforcementAction(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListAlert) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListAlert: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListAlert: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LifecycleStage", wireType)
			}
			m.LifecycleStage = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LifecycleStage |= LifecycleStage(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Time == nil {
				m.Time = &types.Timestamp{}
			}
			if err := m.Time.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Policy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Policy == nil {
				m.Policy = &ListAlertPolicy{}
			}
			if err := m.Policy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ListAlertDeployment{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Entity = &ListAlert_Deployment{v}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= ViolationState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnforcementCount", wireType)
			}
			m.EnforcementCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EnforcementCount |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tags = append(m.Tags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnforcementAction", wireType)
			}
			m.EnforcementAction = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EnforcementAction |= EnforcementAction(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommonEntityInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CommonEntityInfo == nil {
				m.CommonEntityInfo = &ListAlert_CommonEntityInfo{}
			}
			if err := m.CommonEntityInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ListAlert_ResourceEntity{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Entity = &ListAlert_Resource{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListAlert_CommonEntityInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommonEntityInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommonEntityInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceType", wireType)
			}
			m.ResourceType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ResourceType |= ListAlert_ResourceType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAlert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListAlert_ResourceEntity) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceEntity: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceEntity: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListAlertPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListAlertPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListAlertPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Severity", wireType)
			}
			m.Severity = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Severity |= Severity(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Categories", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Categories = append(m.Categories, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeveloperInternalFields", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeveloperInternalFields == nil {
				m.DeveloperInternalFields = &ListAlertPolicy_DevFields{}
			}
			if err := m.DeveloperInternalFields.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListAlertPolicy_DevFields) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DevFields: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DevFields: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SORTName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SORTName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListAlertDeployment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListAlertDeployment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListAlertDeployment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Inactive", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Inactive = bool(v != 0)
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlert
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlert
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAlert(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAlert
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAlert
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthAlert
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupAlert
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthAlert
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthAlert        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAlert          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupAlert = fmt.Errorf("proto: unexpected end of group")
)
