// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/config.proto

package storage

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type BannerConfig_Size int32

const (
	BannerConfig_UNSET  BannerConfig_Size = 0
	BannerConfig_SMALL  BannerConfig_Size = 1
	BannerConfig_MEDIUM BannerConfig_Size = 2
	BannerConfig_LARGE  BannerConfig_Size = 3
)

var BannerConfig_Size_name = map[int32]string{
	0: "UNSET",
	1: "SMALL",
	2: "MEDIUM",
	3: "LARGE",
}

var BannerConfig_Size_value = map[string]int32{
	"UNSET":  0,
	"SMALL":  1,
	"MEDIUM": 2,
	"LARGE":  3,
}

func (x BannerConfig_Size) String() string {
	return proto.EnumName(BannerConfig_Size_name, int32(x))
}

func (BannerConfig_Size) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_33903d79f8815efc, []int{1, 0}
}

type LoginNotice struct {
	Enabled              bool     `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Text                 string   `protobuf:"bytes,2,opt,name=text,proto3" json:"text,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LoginNotice) Reset()         { *m = LoginNotice{} }
func (m *LoginNotice) String() string { return proto.CompactTextString(m) }
func (*LoginNotice) ProtoMessage()    {}
func (*LoginNotice) Descriptor() ([]byte, []int) {
	return fileDescriptor_33903d79f8815efc, []int{0}
}
func (m *LoginNotice) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LoginNotice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LoginNotice.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LoginNotice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoginNotice.Merge(m, src)
}
func (m *LoginNotice) XXX_Size() int {
	return m.Size()
}
func (m *LoginNotice) XXX_DiscardUnknown() {
	xxx_messageInfo_LoginNotice.DiscardUnknown(m)
}

var xxx_messageInfo_LoginNotice proto.InternalMessageInfo

func (m *LoginNotice) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *LoginNotice) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *LoginNotice) MessageClone() proto.Message {
	return m.Clone()
}
func (m *LoginNotice) Clone() *LoginNotice {
	if m == nil {
		return nil
	}
	cloned := new(LoginNotice)
	*cloned = *m

	return cloned
}

type BannerConfig struct {
	Enabled              bool              `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Text                 string            `protobuf:"bytes,2,opt,name=text,proto3" json:"text,omitempty"`
	Size_                BannerConfig_Size `protobuf:"varint,3,opt,name=size,proto3,enum=storage.BannerConfig_Size" json:"size,omitempty"`
	Color                string            `protobuf:"bytes,4,opt,name=color,proto3" json:"color,omitempty"`
	BackgroundColor      string            `protobuf:"bytes,5,opt,name=background_color,json=backgroundColor,proto3" json:"background_color,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *BannerConfig) Reset()         { *m = BannerConfig{} }
func (m *BannerConfig) String() string { return proto.CompactTextString(m) }
func (*BannerConfig) ProtoMessage()    {}
func (*BannerConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_33903d79f8815efc, []int{1}
}
func (m *BannerConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BannerConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BannerConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BannerConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BannerConfig.Merge(m, src)
}
func (m *BannerConfig) XXX_Size() int {
	return m.Size()
}
func (m *BannerConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_BannerConfig.DiscardUnknown(m)
}

var xxx_messageInfo_BannerConfig proto.InternalMessageInfo

func (m *BannerConfig) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *BannerConfig) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *BannerConfig) GetSize_() BannerConfig_Size {
	if m != nil {
		return m.Size_
	}
	return BannerConfig_UNSET
}

func (m *BannerConfig) GetColor() string {
	if m != nil {
		return m.Color
	}
	return ""
}

func (m *BannerConfig) GetBackgroundColor() string {
	if m != nil {
		return m.BackgroundColor
	}
	return ""
}

func (m *BannerConfig) MessageClone() proto.Message {
	return m.Clone()
}
func (m *BannerConfig) Clone() *BannerConfig {
	if m == nil {
		return nil
	}
	cloned := new(BannerConfig)
	*cloned = *m

	return cloned
}

type PublicConfig struct {
	LoginNotice          *LoginNotice  `protobuf:"bytes,1,opt,name=login_notice,json=loginNotice,proto3" json:"login_notice,omitempty"`
	Header               *BannerConfig `protobuf:"bytes,2,opt,name=header,proto3" json:"header,omitempty"`
	Footer               *BannerConfig `protobuf:"bytes,3,opt,name=footer,proto3" json:"footer,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *PublicConfig) Reset()         { *m = PublicConfig{} }
func (m *PublicConfig) String() string { return proto.CompactTextString(m) }
func (*PublicConfig) ProtoMessage()    {}
func (*PublicConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_33903d79f8815efc, []int{2}
}
func (m *PublicConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PublicConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PublicConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PublicConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PublicConfig.Merge(m, src)
}
func (m *PublicConfig) XXX_Size() int {
	return m.Size()
}
func (m *PublicConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PublicConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PublicConfig proto.InternalMessageInfo

func (m *PublicConfig) GetLoginNotice() *LoginNotice {
	if m != nil {
		return m.LoginNotice
	}
	return nil
}

func (m *PublicConfig) GetHeader() *BannerConfig {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *PublicConfig) GetFooter() *BannerConfig {
	if m != nil {
		return m.Footer
	}
	return nil
}

func (m *PublicConfig) MessageClone() proto.Message {
	return m.Clone()
}
func (m *PublicConfig) Clone() *PublicConfig {
	if m == nil {
		return nil
	}
	cloned := new(PublicConfig)
	*cloned = *m

	cloned.LoginNotice = m.LoginNotice.Clone()
	cloned.Header = m.Header.Clone()
	cloned.Footer = m.Footer.Clone()
	return cloned
}

type AlertRetentionConfig struct {
	ResolvedDeployRetentionDurationDays int32 `protobuf:"varint,1,opt,name=resolved_deploy_retention_duration_days,json=resolvedDeployRetentionDurationDays,proto3" json:"resolved_deploy_retention_duration_days,omitempty"`
	// This runtime alert retention configuration takes precedence after `allRuntimeRetentionDurationDays`.
	DeletedRuntimeRetentionDurationDays int32 `protobuf:"varint,2,opt,name=deleted_runtime_retention_duration_days,json=deletedRuntimeRetentionDurationDays,proto3" json:"deleted_runtime_retention_duration_days,omitempty"`
	// This runtime alert retention configuration has highest precedence. All runtime alerts, including attempted
	// alerts and deleted deployment alerts, are deleted even if respective retention is longer.
	AllRuntimeRetentionDurationDays      int32 `protobuf:"varint,3,opt,name=all_runtime_retention_duration_days,json=allRuntimeRetentionDurationDays,proto3" json:"all_runtime_retention_duration_days,omitempty"`
	AttemptedDeployRetentionDurationDays int32 `protobuf:"varint,4,opt,name=attempted_deploy_retention_duration_days,json=attemptedDeployRetentionDurationDays,proto3" json:"attempted_deploy_retention_duration_days,omitempty"`
	// This runtime alert retention configuration has lowest precedence.
	AttemptedRuntimeRetentionDurationDays int32    `protobuf:"varint,5,opt,name=attempted_runtime_retention_duration_days,json=attemptedRuntimeRetentionDurationDays,proto3" json:"attempted_runtime_retention_duration_days,omitempty"`
	XXX_NoUnkeyedLiteral                  struct{} `json:"-"`
	XXX_unrecognized                      []byte   `json:"-"`
	XXX_sizecache                         int32    `json:"-"`
}

func (m *AlertRetentionConfig) Reset()         { *m = AlertRetentionConfig{} }
func (m *AlertRetentionConfig) String() string { return proto.CompactTextString(m) }
func (*AlertRetentionConfig) ProtoMessage()    {}
func (*AlertRetentionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_33903d79f8815efc, []int{3}
}
func (m *AlertRetentionConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AlertRetentionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AlertRetentionConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AlertRetentionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AlertRetentionConfig.Merge(m, src)
}
func (m *AlertRetentionConfig) XXX_Size() int {
	return m.Size()
}
func (m *AlertRetentionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_AlertRetentionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_AlertRetentionConfig proto.InternalMessageInfo

func (m *AlertRetentionConfig) GetResolvedDeployRetentionDurationDays() int32 {
	if m != nil {
		return m.ResolvedDeployRetentionDurationDays
	}
	return 0
}

func (m *AlertRetentionConfig) GetDeletedRuntimeRetentionDurationDays() int32 {
	if m != nil {
		return m.DeletedRuntimeRetentionDurationDays
	}
	return 0
}

func (m *AlertRetentionConfig) GetAllRuntimeRetentionDurationDays() int32 {
	if m != nil {
		return m.AllRuntimeRetentionDurationDays
	}
	return 0
}

func (m *AlertRetentionConfig) GetAttemptedDeployRetentionDurationDays() int32 {
	if m != nil {
		return m.AttemptedDeployRetentionDurationDays
	}
	return 0
}

func (m *AlertRetentionConfig) GetAttemptedRuntimeRetentionDurationDays() int32 {
	if m != nil {
		return m.AttemptedRuntimeRetentionDurationDays
	}
	return 0
}

func (m *AlertRetentionConfig) MessageClone() proto.Message {
	return m.Clone()
}
func (m *AlertRetentionConfig) Clone() *AlertRetentionConfig {
	if m == nil {
		return nil
	}
	cloned := new(AlertRetentionConfig)
	*cloned = *m

	return cloned
}

// next available tag: 5
type PrivateConfig struct {
	// Types that are valid to be assigned to AlertRetention:
	//	*PrivateConfig_DEPRECATEDAlertRetentionDurationDays
	//	*PrivateConfig_AlertConfig
	AlertRetention                      isPrivateConfig_AlertRetention `protobuf_oneof:"alert_retention"`
	ImageRetentionDurationDays          int32                          `protobuf:"varint,2,opt,name=image_retention_duration_days,json=imageRetentionDurationDays,proto3" json:"image_retention_duration_days,omitempty"`
	ExpiredVulnReqRetentionDurationDays int32                          `protobuf:"varint,4,opt,name=expired_vuln_req_retention_duration_days,json=expiredVulnReqRetentionDurationDays,proto3" json:"expired_vuln_req_retention_duration_days,omitempty"`
	XXX_NoUnkeyedLiteral                struct{}                       `json:"-"`
	XXX_unrecognized                    []byte                         `json:"-"`
	XXX_sizecache                       int32                          `json:"-"`
}

func (m *PrivateConfig) Reset()         { *m = PrivateConfig{} }
func (m *PrivateConfig) String() string { return proto.CompactTextString(m) }
func (*PrivateConfig) ProtoMessage()    {}
func (*PrivateConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_33903d79f8815efc, []int{4}
}
func (m *PrivateConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PrivateConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PrivateConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PrivateConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrivateConfig.Merge(m, src)
}
func (m *PrivateConfig) XXX_Size() int {
	return m.Size()
}
func (m *PrivateConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PrivateConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PrivateConfig proto.InternalMessageInfo

type isPrivateConfig_AlertRetention interface {
	isPrivateConfig_AlertRetention()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isPrivateConfig_AlertRetention
}

type PrivateConfig_DEPRECATEDAlertRetentionDurationDays struct {
	DEPRECATEDAlertRetentionDurationDays int32 `protobuf:"varint,1,opt,name=DEPRECATED_alert_retention_duration_days,json=DEPRECATEDAlertRetentionDurationDays,proto3,oneof" json:"DEPRECATED_alert_retention_duration_days,omitempty"`
}
type PrivateConfig_AlertConfig struct {
	AlertConfig *AlertRetentionConfig `protobuf:"bytes,3,opt,name=alert_config,json=alertConfig,proto3,oneof" json:"alert_config,omitempty"`
}

func (*PrivateConfig_DEPRECATEDAlertRetentionDurationDays) isPrivateConfig_AlertRetention() {}
func (m *PrivateConfig_DEPRECATEDAlertRetentionDurationDays) Clone() isPrivateConfig_AlertRetention {
	if m == nil {
		return nil
	}
	cloned := new(PrivateConfig_DEPRECATEDAlertRetentionDurationDays)
	*cloned = *m

	return cloned
}
func (*PrivateConfig_AlertConfig) isPrivateConfig_AlertRetention() {}
func (m *PrivateConfig_AlertConfig) Clone() isPrivateConfig_AlertRetention {
	if m == nil {
		return nil
	}
	cloned := new(PrivateConfig_AlertConfig)
	*cloned = *m

	cloned.AlertConfig = m.AlertConfig.Clone()
	return cloned
}

func (m *PrivateConfig) GetAlertRetention() isPrivateConfig_AlertRetention {
	if m != nil {
		return m.AlertRetention
	}
	return nil
}

func (m *PrivateConfig) GetDEPRECATEDAlertRetentionDurationDays() int32 {
	if x, ok := m.GetAlertRetention().(*PrivateConfig_DEPRECATEDAlertRetentionDurationDays); ok {
		return x.DEPRECATEDAlertRetentionDurationDays
	}
	return 0
}

func (m *PrivateConfig) GetAlertConfig() *AlertRetentionConfig {
	if x, ok := m.GetAlertRetention().(*PrivateConfig_AlertConfig); ok {
		return x.AlertConfig
	}
	return nil
}

func (m *PrivateConfig) GetImageRetentionDurationDays() int32 {
	if m != nil {
		return m.ImageRetentionDurationDays
	}
	return 0
}

func (m *PrivateConfig) GetExpiredVulnReqRetentionDurationDays() int32 {
	if m != nil {
		return m.ExpiredVulnReqRetentionDurationDays
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PrivateConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PrivateConfig_DEPRECATEDAlertRetentionDurationDays)(nil),
		(*PrivateConfig_AlertConfig)(nil),
	}
}

func (m *PrivateConfig) MessageClone() proto.Message {
	return m.Clone()
}
func (m *PrivateConfig) Clone() *PrivateConfig {
	if m == nil {
		return nil
	}
	cloned := new(PrivateConfig)
	*cloned = *m

	if m.AlertRetention != nil {
		cloned.AlertRetention = m.AlertRetention.Clone()
	}
	return cloned
}

type Config struct {
	PublicConfig         *PublicConfig  `protobuf:"bytes,1,opt,name=public_config,json=publicConfig,proto3" json:"public_config,omitempty"`
	PrivateConfig        *PrivateConfig `protobuf:"bytes,2,opt,name=private_config,json=privateConfig,proto3" json:"private_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Config) Reset()         { *m = Config{} }
func (m *Config) String() string { return proto.CompactTextString(m) }
func (*Config) ProtoMessage()    {}
func (*Config) Descriptor() ([]byte, []int) {
	return fileDescriptor_33903d79f8815efc, []int{5}
}
func (m *Config) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Config) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Config.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Config) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Config.Merge(m, src)
}
func (m *Config) XXX_Size() int {
	return m.Size()
}
func (m *Config) XXX_DiscardUnknown() {
	xxx_messageInfo_Config.DiscardUnknown(m)
}

var xxx_messageInfo_Config proto.InternalMessageInfo

func (m *Config) GetPublicConfig() *PublicConfig {
	if m != nil {
		return m.PublicConfig
	}
	return nil
}

func (m *Config) GetPrivateConfig() *PrivateConfig {
	if m != nil {
		return m.PrivateConfig
	}
	return nil
}

func (m *Config) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Config) Clone() *Config {
	if m == nil {
		return nil
	}
	cloned := new(Config)
	*cloned = *m

	cloned.PublicConfig = m.PublicConfig.Clone()
	cloned.PrivateConfig = m.PrivateConfig.Clone()
	return cloned
}

func init() {
	proto.RegisterEnum("storage.BannerConfig_Size", BannerConfig_Size_name, BannerConfig_Size_value)
	proto.RegisterType((*LoginNotice)(nil), "storage.LoginNotice")
	proto.RegisterType((*BannerConfig)(nil), "storage.BannerConfig")
	proto.RegisterType((*PublicConfig)(nil), "storage.PublicConfig")
	proto.RegisterType((*AlertRetentionConfig)(nil), "storage.AlertRetentionConfig")
	proto.RegisterType((*PrivateConfig)(nil), "storage.PrivateConfig")
	proto.RegisterType((*Config)(nil), "storage.Config")
}

func init() { proto.RegisterFile("storage/config.proto", fileDescriptor_33903d79f8815efc) }

var fileDescriptor_33903d79f8815efc = []byte{
	// 643 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x94, 0xdd, 0x4e, 0x13, 0x41,
	0x14, 0xc7, 0xbb, 0xfd, 0x42, 0x4e, 0x0b, 0xd4, 0x4d, 0x35, 0x95, 0x84, 0x4a, 0x16, 0x8c, 0xe5,
	0xc2, 0x9a, 0x80, 0x89, 0x89, 0xc6, 0x8b, 0x96, 0x36, 0x62, 0x52, 0x08, 0x19, 0x3e, 0x42, 0xbc,
	0xd9, 0x4c, 0xbb, 0x87, 0xba, 0x61, 0xd8, 0x59, 0xa6, 0xb3, 0x84, 0x72, 0xeb, 0x4b, 0xf8, 0x02,
	0xbe, 0x88, 0x57, 0x5e, 0x7a, 0xed, 0x95, 0xa9, 0x2f, 0x62, 0x76, 0x76, 0xb6, 0x5d, 0x48, 0x69,
	0xe3, 0xdd, 0xcc, 0xc9, 0xff, 0xfc, 0x72, 0xfe, 0xe7, 0xcc, 0x19, 0x28, 0x0f, 0x24, 0x17, 0xb4,
	0x8f, 0xaf, 0x7b, 0xdc, 0x3b, 0x77, 0xfb, 0x75, 0x5f, 0x70, 0xc9, 0xcd, 0x05, 0x1d, 0xb5, 0xde,
	0x43, 0xa1, 0xc3, 0xfb, 0xae, 0x77, 0xc0, 0xa5, 0xdb, 0x43, 0xb3, 0x02, 0x0b, 0xe8, 0xd1, 0x2e,
	0x43, 0xa7, 0x62, 0xac, 0x1b, 0xb5, 0x47, 0x24, 0xbe, 0x9a, 0x26, 0x64, 0x25, 0xde, 0xc8, 0x4a,
	0x7a, 0xdd, 0xa8, 0x2d, 0x12, 0x75, 0xb6, 0x46, 0x06, 0x14, 0x9b, 0xd4, 0xf3, 0x50, 0xec, 0x2a,
	0xf8, 0xff, 0xa5, 0x9b, 0x75, 0xc8, 0x0e, 0xdc, 0x5b, 0xac, 0x64, 0xd6, 0x8d, 0xda, 0xf2, 0xf6,
	0x6a, 0x5d, 0xd7, 0x54, 0x4f, 0x22, 0xeb, 0x47, 0xee, 0x2d, 0x12, 0xa5, 0x33, 0xcb, 0x90, 0xeb,
	0x71, 0xc6, 0x45, 0x25, 0xab, 0x20, 0xd1, 0xc5, 0xdc, 0x82, 0x52, 0x97, 0xf6, 0x2e, 0xfa, 0x82,
	0x07, 0x9e, 0x63, 0x47, 0x82, 0x9c, 0x12, 0xac, 0x4c, 0xe2, 0xbb, 0x61, 0xd8, 0xda, 0x81, 0x6c,
	0x88, 0x33, 0x17, 0x21, 0x77, 0x72, 0x70, 0xd4, 0x3e, 0x2e, 0xa5, 0xc2, 0xe3, 0xd1, 0x7e, 0xa3,
	0xd3, 0x29, 0x19, 0x26, 0x40, 0x7e, 0xbf, 0xdd, 0xfa, 0x74, 0xb2, 0x5f, 0x4a, 0x87, 0xe1, 0x4e,
	0x83, 0x7c, 0x6c, 0x97, 0x32, 0xd6, 0x77, 0x03, 0x8a, 0x87, 0x41, 0x97, 0xb9, 0x3d, 0x6d, 0xf2,
	0x2d, 0x14, 0x59, 0xd8, 0x32, 0xdb, 0x53, 0x3d, 0x53, 0x4e, 0x0b, 0xdb, 0xe5, 0x71, 0xf9, 0x89,
	0x7e, 0x92, 0x02, 0x4b, 0x34, 0xf7, 0x15, 0xe4, 0xbf, 0x20, 0x75, 0x50, 0xa8, 0x2e, 0x14, 0xb6,
	0x9f, 0x4c, 0x75, 0x4c, 0xb4, 0x28, 0x94, 0x9f, 0x73, 0x2e, 0x51, 0xa8, 0x06, 0x3d, 0x2c, 0x8f,
	0x44, 0xd6, 0x8f, 0x0c, 0x94, 0x1b, 0x0c, 0x85, 0x24, 0x28, 0xd1, 0x93, 0x2e, 0xf7, 0x74, 0xbd,
	0xc7, 0xf0, 0x52, 0xe0, 0x80, 0xb3, 0x6b, 0x74, 0x6c, 0x07, 0x7d, 0xc6, 0x87, 0xb6, 0x88, 0x25,
	0xb6, 0x13, 0x08, 0x1a, 0x1d, 0xe8, 0x70, 0xa0, 0xac, 0xe4, 0xc8, 0x46, 0x2c, 0x6f, 0x29, 0xf5,
	0x98, 0xd7, 0xd2, 0xda, 0x16, 0x1d, 0x0e, 0x42, 0xaa, 0x83, 0x0c, 0x25, 0x3a, 0xb6, 0x08, 0x3c,
	0xe9, 0x5e, 0xe2, 0x83, 0xd4, 0x74, 0x44, 0xd5, 0x72, 0x12, 0xa9, 0xa7, 0x53, 0x3b, 0xb0, 0x41,
	0x19, 0x9b, 0x4b, 0xcc, 0x28, 0xe2, 0x73, 0xca, 0xd8, 0x4c, 0xda, 0x29, 0xd4, 0xa8, 0x94, 0x78,
	0xe9, 0xcb, 0xf9, 0xd6, 0xb3, 0x0a, 0xb9, 0x39, 0xd6, 0xcf, 0xf2, 0x7e, 0x06, 0x5b, 0x13, 0xee,
	0xbc, 0x5a, 0x73, 0x0a, 0xfc, 0x62, 0x9c, 0x30, 0xab, 0x62, 0xeb, 0x77, 0x1a, 0x96, 0x0e, 0x85,
	0x7b, 0x4d, 0x25, 0xea, 0xe9, 0x9d, 0x41, 0xad, 0xd5, 0x3e, 0x24, 0xed, 0xdd, 0xc6, 0x71, 0xbb,
	0x65, 0xd3, 0x70, 0xc0, 0xb3, 0xc7, 0xb7, 0x97, 0x22, 0x9b, 0x93, 0x8c, 0xbb, 0x2f, 0xe2, 0x8e,
	0x8b, 0x26, 0x14, 0x23, 0x5c, 0xf4, 0x33, 0xe8, 0x57, 0xb6, 0x36, 0x7e, 0x65, 0xd3, 0x1e, 0xd3,
	0x5e, 0x8a, 0x14, 0x54, 0x92, 0xae, 0xae, 0x01, 0x6b, 0xee, 0x25, 0xed, 0xcf, 0x9b, 0xfd, 0xaa,
	0x12, 0x4d, 0x2f, 0xe3, 0x04, 0x6a, 0x78, 0xe3, 0xbb, 0x02, 0x1d, 0xfb, 0x3a, 0x60, 0x9e, 0x2d,
	0xf0, 0x6a, 0xce, 0x90, 0x36, 0xb4, 0xfe, 0x34, 0x60, 0x1e, 0xc1, 0xab, 0xa9, 0xd8, 0xe6, 0x63,
	0x58, 0xb9, 0xd7, 0x2c, 0xeb, 0xab, 0x01, 0x79, 0x5d, 0xf7, 0x3b, 0x58, 0xf2, 0xd5, 0x4e, 0xc7,
	0xe6, 0x8d, 0x7b, 0x2b, 0x96, 0xdc, 0x78, 0x52, 0xf4, 0x93, 0xfb, 0xff, 0x01, 0x96, 0xfd, 0x68,
	0x44, 0x71, 0x72, 0xb4, 0xce, 0x4f, 0x27, 0xc9, 0xc9, 0x09, 0x92, 0x25, 0x3f, 0x79, 0x6d, 0xbe,
	0xf9, 0x39, 0xaa, 0x1a, 0xbf, 0x46, 0x55, 0xe3, 0xcf, 0xa8, 0x6a, 0x7c, 0xfb, 0x5b, 0x4d, 0xc1,
	0x33, 0x97, 0xd7, 0x07, 0x92, 0xf6, 0x2e, 0x04, 0xbf, 0x89, 0xfe, 0xe7, 0x98, 0xf4, 0x39, 0xfe,
	0xa7, 0xbb, 0x79, 0x15, 0xdf, 0xf9, 0x17, 0x00, 0x00, 0xff, 0xff, 0xd6, 0xb3, 0x1e, 0x3e, 0xcf,
	0x05, 0x00, 0x00,
}

func (m *LoginNotice) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LoginNotice) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LoginNotice) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Text) > 0 {
		i -= len(m.Text)
		copy(dAtA[i:], m.Text)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Text)))
		i--
		dAtA[i] = 0x12
	}
	if m.Enabled {
		i--
		if m.Enabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *BannerConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BannerConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BannerConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.BackgroundColor) > 0 {
		i -= len(m.BackgroundColor)
		copy(dAtA[i:], m.BackgroundColor)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.BackgroundColor)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Color) > 0 {
		i -= len(m.Color)
		copy(dAtA[i:], m.Color)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Color)))
		i--
		dAtA[i] = 0x22
	}
	if m.Size_ != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.Size_))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Text) > 0 {
		i -= len(m.Text)
		copy(dAtA[i:], m.Text)
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Text)))
		i--
		dAtA[i] = 0x12
	}
	if m.Enabled {
		i--
		if m.Enabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PublicConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PublicConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PublicConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Footer != nil {
		{
			size, err := m.Footer.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Header != nil {
		{
			size, err := m.Header.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.LoginNotice != nil {
		{
			size, err := m.LoginNotice.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AlertRetentionConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AlertRetentionConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AlertRetentionConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.AttemptedRuntimeRetentionDurationDays != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.AttemptedRuntimeRetentionDurationDays))
		i--
		dAtA[i] = 0x28
	}
	if m.AttemptedDeployRetentionDurationDays != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.AttemptedDeployRetentionDurationDays))
		i--
		dAtA[i] = 0x20
	}
	if m.AllRuntimeRetentionDurationDays != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.AllRuntimeRetentionDurationDays))
		i--
		dAtA[i] = 0x18
	}
	if m.DeletedRuntimeRetentionDurationDays != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.DeletedRuntimeRetentionDurationDays))
		i--
		dAtA[i] = 0x10
	}
	if m.ResolvedDeployRetentionDurationDays != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.ResolvedDeployRetentionDurationDays))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PrivateConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrivateConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrivateConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ExpiredVulnReqRetentionDurationDays != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.ExpiredVulnReqRetentionDurationDays))
		i--
		dAtA[i] = 0x20
	}
	if m.AlertRetention != nil {
		{
			size := m.AlertRetention.Size()
			i -= size
			if _, err := m.AlertRetention.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.ImageRetentionDurationDays != 0 {
		i = encodeVarintConfig(dAtA, i, uint64(m.ImageRetentionDurationDays))
		i--
		dAtA[i] = 0x10
	}
	return len(dAtA) - i, nil
}

func (m *PrivateConfig_DEPRECATEDAlertRetentionDurationDays) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrivateConfig_DEPRECATEDAlertRetentionDurationDays) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintConfig(dAtA, i, uint64(m.DEPRECATEDAlertRetentionDurationDays))
	i--
	dAtA[i] = 0x8
	return len(dAtA) - i, nil
}
func (m *PrivateConfig_AlertConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrivateConfig_AlertConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.AlertConfig != nil {
		{
			size, err := m.AlertConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *Config) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Config) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Config) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.PrivateConfig != nil {
		{
			size, err := m.PrivateConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.PublicConfig != nil {
		{
			size, err := m.PublicConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfig(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintConfig(dAtA []byte, offset int, v uint64) int {
	offset -= sovConfig(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *LoginNotice) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Enabled {
		n += 2
	}
	l = len(m.Text)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BannerConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Enabled {
		n += 2
	}
	l = len(m.Text)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.Size_ != 0 {
		n += 1 + sovConfig(uint64(m.Size_))
	}
	l = len(m.Color)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.BackgroundColor)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PublicConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LoginNotice != nil {
		l = m.LoginNotice.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.Footer != nil {
		l = m.Footer.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AlertRetentionConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ResolvedDeployRetentionDurationDays != 0 {
		n += 1 + sovConfig(uint64(m.ResolvedDeployRetentionDurationDays))
	}
	if m.DeletedRuntimeRetentionDurationDays != 0 {
		n += 1 + sovConfig(uint64(m.DeletedRuntimeRetentionDurationDays))
	}
	if m.AllRuntimeRetentionDurationDays != 0 {
		n += 1 + sovConfig(uint64(m.AllRuntimeRetentionDurationDays))
	}
	if m.AttemptedDeployRetentionDurationDays != 0 {
		n += 1 + sovConfig(uint64(m.AttemptedDeployRetentionDurationDays))
	}
	if m.AttemptedRuntimeRetentionDurationDays != 0 {
		n += 1 + sovConfig(uint64(m.AttemptedRuntimeRetentionDurationDays))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PrivateConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AlertRetention != nil {
		n += m.AlertRetention.Size()
	}
	if m.ImageRetentionDurationDays != 0 {
		n += 1 + sovConfig(uint64(m.ImageRetentionDurationDays))
	}
	if m.ExpiredVulnReqRetentionDurationDays != 0 {
		n += 1 + sovConfig(uint64(m.ExpiredVulnReqRetentionDurationDays))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PrivateConfig_DEPRECATEDAlertRetentionDurationDays) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovConfig(uint64(m.DEPRECATEDAlertRetentionDurationDays))
	return n
}
func (m *PrivateConfig_AlertConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AlertConfig != nil {
		l = m.AlertConfig.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *Config) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PublicConfig != nil {
		l = m.PublicConfig.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.PrivateConfig != nil {
		l = m.PrivateConfig.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovConfig(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozConfig(x uint64) (n int) {
	return sovConfig(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *LoginNotice) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LoginNotice: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LoginNotice: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Enabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Enabled = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Text", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Text = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BannerConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BannerConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BannerConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Enabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Enabled = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Text", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Text = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size_", wireType)
			}
			m.Size_ = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Size_ |= BannerConfig_Size(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Color", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Color = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BackgroundColor", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BackgroundColor = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PublicConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PublicConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PublicConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoginNotice", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LoginNotice == nil {
				m.LoginNotice = &LoginNotice{}
			}
			if err := m.LoginNotice.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Header == nil {
				m.Header = &BannerConfig{}
			}
			if err := m.Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Footer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Footer == nil {
				m.Footer = &BannerConfig{}
			}
			if err := m.Footer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AlertRetentionConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AlertRetentionConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AlertRetentionConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolvedDeployRetentionDurationDays", wireType)
			}
			m.ResolvedDeployRetentionDurationDays = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ResolvedDeployRetentionDurationDays |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedRuntimeRetentionDurationDays", wireType)
			}
			m.DeletedRuntimeRetentionDurationDays = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DeletedRuntimeRetentionDurationDays |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllRuntimeRetentionDurationDays", wireType)
			}
			m.AllRuntimeRetentionDurationDays = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AllRuntimeRetentionDurationDays |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttemptedDeployRetentionDurationDays", wireType)
			}
			m.AttemptedDeployRetentionDurationDays = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AttemptedDeployRetentionDurationDays |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttemptedRuntimeRetentionDurationDays", wireType)
			}
			m.AttemptedRuntimeRetentionDurationDays = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AttemptedRuntimeRetentionDurationDays |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrivateConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrivateConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrivateConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DEPRECATEDAlertRetentionDurationDays", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AlertRetention = &PrivateConfig_DEPRECATEDAlertRetentionDurationDays{v}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ImageRetentionDurationDays", wireType)
			}
			m.ImageRetentionDurationDays = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ImageRetentionDurationDays |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlertConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AlertRetentionConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.AlertRetention = &PrivateConfig_AlertConfig{v}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpiredVulnReqRetentionDurationDays", wireType)
			}
			m.ExpiredVulnReqRetentionDurationDays = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExpiredVulnReqRetentionDurationDays |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Config) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Config: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Config: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PublicConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PublicConfig == nil {
				m.PublicConfig = &PublicConfig{}
			}
			if err := m.PublicConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrivateConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PrivateConfig == nil {
				m.PrivateConfig = &PrivateConfig{}
			}
			if err := m.PrivateConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConfig(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthConfig
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupConfig
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthConfig
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthConfig        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConfig          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupConfig = fmt.Errorf("proto: unexpected end of group")
)
