// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/cve.proto

package storage

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// VulnerabilityState indicates if vulnerability is being observed or deferred(/suppressed). By default, it vulnerabilities are observed.
type VulnerabilityState int32

const (
	VulnerabilityState_OBSERVED       VulnerabilityState = 0
	VulnerabilityState_DEFERRED       VulnerabilityState = 1
	VulnerabilityState_FALSE_POSITIVE VulnerabilityState = 2
)

var VulnerabilityState_name = map[int32]string{
	0: "OBSERVED",
	1: "DEFERRED",
	2: "FALSE_POSITIVE",
}

var VulnerabilityState_value = map[string]int32{
	"OBSERVED":       0,
	"DEFERRED":       1,
	"FALSE_POSITIVE": 2,
}

func (x VulnerabilityState) String() string {
	return proto.EnumName(VulnerabilityState_name, int32(x))
}

func (VulnerabilityState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{0}
}

type VulnerabilitySeverity int32

const (
	VulnerabilitySeverity_UNKNOWN_VULNERABILITY_SEVERITY   VulnerabilitySeverity = 0
	VulnerabilitySeverity_LOW_VULNERABILITY_SEVERITY       VulnerabilitySeverity = 1
	VulnerabilitySeverity_MODERATE_VULNERABILITY_SEVERITY  VulnerabilitySeverity = 2
	VulnerabilitySeverity_IMPORTANT_VULNERABILITY_SEVERITY VulnerabilitySeverity = 3
	VulnerabilitySeverity_CRITICAL_VULNERABILITY_SEVERITY  VulnerabilitySeverity = 4
)

var VulnerabilitySeverity_name = map[int32]string{
	0: "UNKNOWN_VULNERABILITY_SEVERITY",
	1: "LOW_VULNERABILITY_SEVERITY",
	2: "MODERATE_VULNERABILITY_SEVERITY",
	3: "IMPORTANT_VULNERABILITY_SEVERITY",
	4: "CRITICAL_VULNERABILITY_SEVERITY",
}

var VulnerabilitySeverity_value = map[string]int32{
	"UNKNOWN_VULNERABILITY_SEVERITY":   0,
	"LOW_VULNERABILITY_SEVERITY":       1,
	"MODERATE_VULNERABILITY_SEVERITY":  2,
	"IMPORTANT_VULNERABILITY_SEVERITY": 3,
	"CRITICAL_VULNERABILITY_SEVERITY":  4,
}

func (x VulnerabilitySeverity) String() string {
	return proto.EnumName(VulnerabilitySeverity_name, int32(x))
}

func (VulnerabilitySeverity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{1}
}

type CVE_ScoreVersion int32

const (
	CVE_V2      CVE_ScoreVersion = 0
	CVE_V3      CVE_ScoreVersion = 1
	CVE_UNKNOWN CVE_ScoreVersion = 2
)

var CVE_ScoreVersion_name = map[int32]string{
	0: "V2",
	1: "V3",
	2: "UNKNOWN",
}

var CVE_ScoreVersion_value = map[string]int32{
	"V2":      0,
	"V3":      1,
	"UNKNOWN": 2,
}

func (x CVE_ScoreVersion) String() string {
	return proto.EnumName(CVE_ScoreVersion_name, int32(x))
}

func (CVE_ScoreVersion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{0, 0}
}

type CVE_CVEType int32

const (
	CVE_UNKNOWN_CVE   CVE_CVEType = 0
	CVE_IMAGE_CVE     CVE_CVEType = 1
	CVE_K8S_CVE       CVE_CVEType = 2
	CVE_ISTIO_CVE     CVE_CVEType = 3
	CVE_NODE_CVE      CVE_CVEType = 4
	CVE_OPENSHIFT_CVE CVE_CVEType = 5
)

var CVE_CVEType_name = map[int32]string{
	0: "UNKNOWN_CVE",
	1: "IMAGE_CVE",
	2: "K8S_CVE",
	3: "ISTIO_CVE",
	4: "NODE_CVE",
	5: "OPENSHIFT_CVE",
}

var CVE_CVEType_value = map[string]int32{
	"UNKNOWN_CVE":   0,
	"IMAGE_CVE":     1,
	"K8S_CVE":       2,
	"ISTIO_CVE":     3,
	"NODE_CVE":      4,
	"OPENSHIFT_CVE": 5,
}

func (x CVE_CVEType) String() string {
	return proto.EnumName(CVE_CVEType_name, int32(x))
}

func (CVE_CVEType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{0, 1}
}

type CVSSV2_Impact int32

const (
	CVSSV2_IMPACT_NONE     CVSSV2_Impact = 0
	CVSSV2_IMPACT_PARTIAL  CVSSV2_Impact = 1
	CVSSV2_IMPACT_COMPLETE CVSSV2_Impact = 2
)

var CVSSV2_Impact_name = map[int32]string{
	0: "IMPACT_NONE",
	1: "IMPACT_PARTIAL",
	2: "IMPACT_COMPLETE",
}

var CVSSV2_Impact_value = map[string]int32{
	"IMPACT_NONE":     0,
	"IMPACT_PARTIAL":  1,
	"IMPACT_COMPLETE": 2,
}

func (x CVSSV2_Impact) String() string {
	return proto.EnumName(CVSSV2_Impact_name, int32(x))
}

func (CVSSV2_Impact) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{1, 0}
}

type CVSSV2_AttackVector int32

const (
	CVSSV2_ATTACK_LOCAL    CVSSV2_AttackVector = 0
	CVSSV2_ATTACK_ADJACENT CVSSV2_AttackVector = 1
	CVSSV2_ATTACK_NETWORK  CVSSV2_AttackVector = 2
)

var CVSSV2_AttackVector_name = map[int32]string{
	0: "ATTACK_LOCAL",
	1: "ATTACK_ADJACENT",
	2: "ATTACK_NETWORK",
}

var CVSSV2_AttackVector_value = map[string]int32{
	"ATTACK_LOCAL":    0,
	"ATTACK_ADJACENT": 1,
	"ATTACK_NETWORK":  2,
}

func (x CVSSV2_AttackVector) String() string {
	return proto.EnumName(CVSSV2_AttackVector_name, int32(x))
}

func (CVSSV2_AttackVector) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{1, 1}
}

type CVSSV2_AccessComplexity int32

const (
	CVSSV2_ACCESS_HIGH   CVSSV2_AccessComplexity = 0
	CVSSV2_ACCESS_MEDIUM CVSSV2_AccessComplexity = 1
	CVSSV2_ACCESS_LOW    CVSSV2_AccessComplexity = 2
)

var CVSSV2_AccessComplexity_name = map[int32]string{
	0: "ACCESS_HIGH",
	1: "ACCESS_MEDIUM",
	2: "ACCESS_LOW",
}

var CVSSV2_AccessComplexity_value = map[string]int32{
	"ACCESS_HIGH":   0,
	"ACCESS_MEDIUM": 1,
	"ACCESS_LOW":    2,
}

func (x CVSSV2_AccessComplexity) String() string {
	return proto.EnumName(CVSSV2_AccessComplexity_name, int32(x))
}

func (CVSSV2_AccessComplexity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{1, 2}
}

type CVSSV2_Authentication int32

const (
	CVSSV2_AUTH_MULTIPLE CVSSV2_Authentication = 0
	CVSSV2_AUTH_SINGLE   CVSSV2_Authentication = 1
	CVSSV2_AUTH_NONE     CVSSV2_Authentication = 2
)

var CVSSV2_Authentication_name = map[int32]string{
	0: "AUTH_MULTIPLE",
	1: "AUTH_SINGLE",
	2: "AUTH_NONE",
}

var CVSSV2_Authentication_value = map[string]int32{
	"AUTH_MULTIPLE": 0,
	"AUTH_SINGLE":   1,
	"AUTH_NONE":     2,
}

func (x CVSSV2_Authentication) String() string {
	return proto.EnumName(CVSSV2_Authentication_name, int32(x))
}

func (CVSSV2_Authentication) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{1, 3}
}

type CVSSV2_Severity int32

const (
	CVSSV2_UNKNOWN CVSSV2_Severity = 0
	CVSSV2_LOW     CVSSV2_Severity = 1
	CVSSV2_MEDIUM  CVSSV2_Severity = 2
	CVSSV2_HIGH    CVSSV2_Severity = 3
)

var CVSSV2_Severity_name = map[int32]string{
	0: "UNKNOWN",
	1: "LOW",
	2: "MEDIUM",
	3: "HIGH",
}

var CVSSV2_Severity_value = map[string]int32{
	"UNKNOWN": 0,
	"LOW":     1,
	"MEDIUM":  2,
	"HIGH":    3,
}

func (x CVSSV2_Severity) String() string {
	return proto.EnumName(CVSSV2_Severity_name, int32(x))
}

func (CVSSV2_Severity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{1, 4}
}

type CVSSV3_Impact int32

const (
	CVSSV3_IMPACT_NONE CVSSV3_Impact = 0
	CVSSV3_IMPACT_LOW  CVSSV3_Impact = 1
	CVSSV3_IMPACT_HIGH CVSSV3_Impact = 2
)

var CVSSV3_Impact_name = map[int32]string{
	0: "IMPACT_NONE",
	1: "IMPACT_LOW",
	2: "IMPACT_HIGH",
}

var CVSSV3_Impact_value = map[string]int32{
	"IMPACT_NONE": 0,
	"IMPACT_LOW":  1,
	"IMPACT_HIGH": 2,
}

func (x CVSSV3_Impact) String() string {
	return proto.EnumName(CVSSV3_Impact_name, int32(x))
}

func (CVSSV3_Impact) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{2, 0}
}

type CVSSV3_AttackVector int32

const (
	CVSSV3_ATTACK_LOCAL    CVSSV3_AttackVector = 0
	CVSSV3_ATTACK_ADJACENT CVSSV3_AttackVector = 1
	CVSSV3_ATTACK_NETWORK  CVSSV3_AttackVector = 2
	CVSSV3_ATTACK_PHYSICAL CVSSV3_AttackVector = 3
)

var CVSSV3_AttackVector_name = map[int32]string{
	0: "ATTACK_LOCAL",
	1: "ATTACK_ADJACENT",
	2: "ATTACK_NETWORK",
	3: "ATTACK_PHYSICAL",
}

var CVSSV3_AttackVector_value = map[string]int32{
	"ATTACK_LOCAL":    0,
	"ATTACK_ADJACENT": 1,
	"ATTACK_NETWORK":  2,
	"ATTACK_PHYSICAL": 3,
}

func (x CVSSV3_AttackVector) String() string {
	return proto.EnumName(CVSSV3_AttackVector_name, int32(x))
}

func (CVSSV3_AttackVector) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{2, 1}
}

type CVSSV3_Complexity int32

const (
	CVSSV3_COMPLEXITY_LOW  CVSSV3_Complexity = 0
	CVSSV3_COMPLEXITY_HIGH CVSSV3_Complexity = 1
)

var CVSSV3_Complexity_name = map[int32]string{
	0: "COMPLEXITY_LOW",
	1: "COMPLEXITY_HIGH",
}

var CVSSV3_Complexity_value = map[string]int32{
	"COMPLEXITY_LOW":  0,
	"COMPLEXITY_HIGH": 1,
}

func (x CVSSV3_Complexity) String() string {
	return proto.EnumName(CVSSV3_Complexity_name, int32(x))
}

func (CVSSV3_Complexity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{2, 2}
}

type CVSSV3_Privileges int32

const (
	CVSSV3_PRIVILEGE_NONE CVSSV3_Privileges = 0
	CVSSV3_PRIVILEGE_LOW  CVSSV3_Privileges = 1
	CVSSV3_PRIVILEGE_HIGH CVSSV3_Privileges = 2
)

var CVSSV3_Privileges_name = map[int32]string{
	0: "PRIVILEGE_NONE",
	1: "PRIVILEGE_LOW",
	2: "PRIVILEGE_HIGH",
}

var CVSSV3_Privileges_value = map[string]int32{
	"PRIVILEGE_NONE": 0,
	"PRIVILEGE_LOW":  1,
	"PRIVILEGE_HIGH": 2,
}

func (x CVSSV3_Privileges) String() string {
	return proto.EnumName(CVSSV3_Privileges_name, int32(x))
}

func (CVSSV3_Privileges) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{2, 3}
}

type CVSSV3_UserInteraction int32

const (
	CVSSV3_UI_NONE     CVSSV3_UserInteraction = 0
	CVSSV3_UI_REQUIRED CVSSV3_UserInteraction = 1
)

var CVSSV3_UserInteraction_name = map[int32]string{
	0: "UI_NONE",
	1: "UI_REQUIRED",
}

var CVSSV3_UserInteraction_value = map[string]int32{
	"UI_NONE":     0,
	"UI_REQUIRED": 1,
}

func (x CVSSV3_UserInteraction) String() string {
	return proto.EnumName(CVSSV3_UserInteraction_name, int32(x))
}

func (CVSSV3_UserInteraction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{2, 4}
}

type CVSSV3_Scope int32

const (
	CVSSV3_UNCHANGED CVSSV3_Scope = 0
	CVSSV3_CHANGED   CVSSV3_Scope = 1
)

var CVSSV3_Scope_name = map[int32]string{
	0: "UNCHANGED",
	1: "CHANGED",
}

var CVSSV3_Scope_value = map[string]int32{
	"UNCHANGED": 0,
	"CHANGED":   1,
}

func (x CVSSV3_Scope) String() string {
	return proto.EnumName(CVSSV3_Scope_name, int32(x))
}

func (CVSSV3_Scope) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{2, 5}
}

type CVSSV3_Severity int32

const (
	CVSSV3_UNKNOWN  CVSSV3_Severity = 0
	CVSSV3_NONE     CVSSV3_Severity = 1
	CVSSV3_LOW      CVSSV3_Severity = 2
	CVSSV3_MEDIUM   CVSSV3_Severity = 3
	CVSSV3_HIGH     CVSSV3_Severity = 4
	CVSSV3_CRITICAL CVSSV3_Severity = 5
)

var CVSSV3_Severity_name = map[int32]string{
	0: "UNKNOWN",
	1: "NONE",
	2: "LOW",
	3: "MEDIUM",
	4: "HIGH",
	5: "CRITICAL",
}

var CVSSV3_Severity_value = map[string]int32{
	"UNKNOWN":  0,
	"NONE":     1,
	"LOW":      2,
	"MEDIUM":   3,
	"HIGH":     4,
	"CRITICAL": 5,
}

func (x CVSSV3_Severity) String() string {
	return proto.EnumName(CVSSV3_Severity_name, int32(x))
}

func (CVSSV3_Severity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{2, 6}
}

// Next Tag: 19
type CVE struct {
	Id          string  `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" search:"CVE,store"`
	Cvss        float32 `protobuf:"fixed32,2,opt,name=cvss,proto3" json:"cvss,omitempty" search:"CVSS,store"`
	ImpactScore float32 `protobuf:"fixed32,14,opt,name=impact_score,json=impactScore,proto3" json:"impact_score,omitempty" search:"Impact Score"`
	// For internal purposes only. This will only be populated prior to upsert into datastore.
	Type        CVE_CVEType      `protobuf:"varint,3,opt,name=type,proto3,enum=storage.CVE_CVEType" json:"type,omitempty"`
	Types       []CVE_CVEType    `protobuf:"varint,18,rep,packed,name=types,proto3,enum=storage.CVE_CVEType" json:"types,omitempty" search:"CVE Type,store"`
	Summary     string           `protobuf:"bytes,4,opt,name=summary,proto3" json:"summary,omitempty"`
	Link        string           `protobuf:"bytes,5,opt,name=link,proto3" json:"link,omitempty"`
	PublishedOn *types.Timestamp `protobuf:"bytes,6,opt,name=published_on,json=publishedOn,proto3" json:"published_on,omitempty" search:"CVE Published On"`
	// Time when the CVE was first seen in the system.
	CreatedAt            *types.Timestamp               `protobuf:"bytes,15,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty" search:"CVE Created Time"`
	LastModified         *types.Timestamp               `protobuf:"bytes,7,opt,name=last_modified,json=lastModified,proto3" json:"last_modified,omitempty"`
	References           []*CVE_Reference               `protobuf:"bytes,8,rep,name=references,proto3" json:"references,omitempty"`
	ScoreVersion         CVE_ScoreVersion               `protobuf:"varint,9,opt,name=score_version,json=scoreVersion,proto3,enum=storage.CVE_ScoreVersion" json:"score_version,omitempty"`
	CvssV2               *CVSSV2                        `protobuf:"bytes,10,opt,name=cvss_v2,json=cvssV2,proto3" json:"cvss_v2,omitempty"`
	CvssV3               *CVSSV3                        `protobuf:"bytes,11,opt,name=cvss_v3,json=cvssV3,proto3" json:"cvss_v3,omitempty"`
	Suppressed           bool                           `protobuf:"varint,12,opt,name=suppressed,proto3" json:"suppressed,omitempty" search:"CVE Snoozed"`
	SuppressActivation   *types.Timestamp               `protobuf:"bytes,16,opt,name=suppress_activation,json=suppressActivation,proto3" json:"suppress_activation,omitempty"`
	SuppressExpiry       *types.Timestamp               `protobuf:"bytes,17,opt,name=suppress_expiry,json=suppressExpiry,proto3" json:"suppress_expiry,omitempty" search:"CVE Snooze Expiry,hidden"`
	DistroSpecifics      map[string]*CVE_DistroSpecific `protobuf:"bytes,19,rep,name=distro_specifics,json=distroSpecifics,proto3" json:"distro_specifics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Severity             VulnerabilitySeverity          `protobuf:"varint,20,opt,name=severity,proto3,enum=storage.VulnerabilitySeverity" json:"severity,omitempty" search:"Severity"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *CVE) Reset()         { *m = CVE{} }
func (m *CVE) String() string { return proto.CompactTextString(m) }
func (*CVE) ProtoMessage()    {}
func (*CVE) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{0}
}
func (m *CVE) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CVE) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CVE.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CVE) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CVE.Merge(m, src)
}
func (m *CVE) XXX_Size() int {
	return m.Size()
}
func (m *CVE) XXX_DiscardUnknown() {
	xxx_messageInfo_CVE.DiscardUnknown(m)
}

var xxx_messageInfo_CVE proto.InternalMessageInfo

func (m *CVE) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *CVE) GetCvss() float32 {
	if m != nil {
		return m.Cvss
	}
	return 0
}

func (m *CVE) GetImpactScore() float32 {
	if m != nil {
		return m.ImpactScore
	}
	return 0
}

func (m *CVE) GetType() CVE_CVEType {
	if m != nil {
		return m.Type
	}
	return CVE_UNKNOWN_CVE
}

func (m *CVE) GetTypes() []CVE_CVEType {
	if m != nil {
		return m.Types
	}
	return nil
}

func (m *CVE) GetSummary() string {
	if m != nil {
		return m.Summary
	}
	return ""
}

func (m *CVE) GetLink() string {
	if m != nil {
		return m.Link
	}
	return ""
}

func (m *CVE) GetPublishedOn() *types.Timestamp {
	if m != nil {
		return m.PublishedOn
	}
	return nil
}

func (m *CVE) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *CVE) GetLastModified() *types.Timestamp {
	if m != nil {
		return m.LastModified
	}
	return nil
}

func (m *CVE) GetReferences() []*CVE_Reference {
	if m != nil {
		return m.References
	}
	return nil
}

func (m *CVE) GetScoreVersion() CVE_ScoreVersion {
	if m != nil {
		return m.ScoreVersion
	}
	return CVE_V2
}

func (m *CVE) GetCvssV2() *CVSSV2 {
	if m != nil {
		return m.CvssV2
	}
	return nil
}

func (m *CVE) GetCvssV3() *CVSSV3 {
	if m != nil {
		return m.CvssV3
	}
	return nil
}

func (m *CVE) GetSuppressed() bool {
	if m != nil {
		return m.Suppressed
	}
	return false
}

func (m *CVE) GetSuppressActivation() *types.Timestamp {
	if m != nil {
		return m.SuppressActivation
	}
	return nil
}

func (m *CVE) GetSuppressExpiry() *types.Timestamp {
	if m != nil {
		return m.SuppressExpiry
	}
	return nil
}

func (m *CVE) GetDistroSpecifics() map[string]*CVE_DistroSpecific {
	if m != nil {
		return m.DistroSpecifics
	}
	return nil
}

func (m *CVE) GetSeverity() VulnerabilitySeverity {
	if m != nil {
		return m.Severity
	}
	return VulnerabilitySeverity_UNKNOWN_VULNERABILITY_SEVERITY
}

func (m *CVE) MessageClone() proto.Message {
	return m.Clone()
}
func (m *CVE) Clone() *CVE {
	if m == nil {
		return nil
	}
	cloned := new(CVE)
	*cloned = *m

	if m.Types != nil {
		cloned.Types = make([]CVE_CVEType, len(m.Types))
		copy(cloned.Types, m.Types)
	}
	cloned.PublishedOn = m.PublishedOn.Clone()
	cloned.CreatedAt = m.CreatedAt.Clone()
	cloned.LastModified = m.LastModified.Clone()
	if m.References != nil {
		cloned.References = make([]*CVE_Reference, len(m.References))
		for idx, v := range m.References {
			cloned.References[idx] = v.Clone()
		}
	}
	cloned.CvssV2 = m.CvssV2.Clone()
	cloned.CvssV3 = m.CvssV3.Clone()
	cloned.SuppressActivation = m.SuppressActivation.Clone()
	cloned.SuppressExpiry = m.SuppressExpiry.Clone()
	if m.DistroSpecifics != nil {
		cloned.DistroSpecifics = make(map[string]*CVE_DistroSpecific, len(m.DistroSpecifics))
		for k, v := range m.DistroSpecifics {
			cloned.DistroSpecifics[k] = v.Clone()
		}
	}
	return cloned
}

type CVE_Reference struct {
	URI                  string   `protobuf:"bytes,1,opt,name=URI,proto3" json:"URI,omitempty"`
	Tags                 []string `protobuf:"bytes,2,rep,name=tags,proto3" json:"tags,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CVE_Reference) Reset()         { *m = CVE_Reference{} }
func (m *CVE_Reference) String() string { return proto.CompactTextString(m) }
func (*CVE_Reference) ProtoMessage()    {}
func (*CVE_Reference) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{0, 0}
}
func (m *CVE_Reference) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CVE_Reference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CVE_Reference.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CVE_Reference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CVE_Reference.Merge(m, src)
}
func (m *CVE_Reference) XXX_Size() int {
	return m.Size()
}
func (m *CVE_Reference) XXX_DiscardUnknown() {
	xxx_messageInfo_CVE_Reference.DiscardUnknown(m)
}

var xxx_messageInfo_CVE_Reference proto.InternalMessageInfo

func (m *CVE_Reference) GetURI() string {
	if m != nil {
		return m.URI
	}
	return ""
}

func (m *CVE_Reference) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CVE_Reference) MessageClone() proto.Message {
	return m.Clone()
}
func (m *CVE_Reference) Clone() *CVE_Reference {
	if m == nil {
		return nil
	}
	cloned := new(CVE_Reference)
	*cloned = *m

	if m.Tags != nil {
		cloned.Tags = make([]string, len(m.Tags))
		copy(cloned.Tags, m.Tags)
	}
	return cloned
}

type CVE_DistroSpecific struct {
	Severity             VulnerabilitySeverity `protobuf:"varint,1,opt,name=severity,proto3,enum=storage.VulnerabilitySeverity" json:"severity,omitempty"`
	Cvss                 float32               `protobuf:"fixed32,2,opt,name=cvss,proto3" json:"cvss,omitempty"`
	ScoreVersion         CVE_ScoreVersion      `protobuf:"varint,3,opt,name=score_version,json=scoreVersion,proto3,enum=storage.CVE_ScoreVersion" json:"score_version,omitempty"`
	CvssV2               *CVSSV2               `protobuf:"bytes,4,opt,name=cvss_v2,json=cvssV2,proto3" json:"cvss_v2,omitempty"`
	CvssV3               *CVSSV3               `protobuf:"bytes,5,opt,name=cvss_v3,json=cvssV3,proto3" json:"cvss_v3,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *CVE_DistroSpecific) Reset()         { *m = CVE_DistroSpecific{} }
func (m *CVE_DistroSpecific) String() string { return proto.CompactTextString(m) }
func (*CVE_DistroSpecific) ProtoMessage()    {}
func (*CVE_DistroSpecific) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{0, 1}
}
func (m *CVE_DistroSpecific) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CVE_DistroSpecific) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CVE_DistroSpecific.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CVE_DistroSpecific) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CVE_DistroSpecific.Merge(m, src)
}
func (m *CVE_DistroSpecific) XXX_Size() int {
	return m.Size()
}
func (m *CVE_DistroSpecific) XXX_DiscardUnknown() {
	xxx_messageInfo_CVE_DistroSpecific.DiscardUnknown(m)
}

var xxx_messageInfo_CVE_DistroSpecific proto.InternalMessageInfo

func (m *CVE_DistroSpecific) GetSeverity() VulnerabilitySeverity {
	if m != nil {
		return m.Severity
	}
	return VulnerabilitySeverity_UNKNOWN_VULNERABILITY_SEVERITY
}

func (m *CVE_DistroSpecific) GetCvss() float32 {
	if m != nil {
		return m.Cvss
	}
	return 0
}

func (m *CVE_DistroSpecific) GetScoreVersion() CVE_ScoreVersion {
	if m != nil {
		return m.ScoreVersion
	}
	return CVE_V2
}

func (m *CVE_DistroSpecific) GetCvssV2() *CVSSV2 {
	if m != nil {
		return m.CvssV2
	}
	return nil
}

func (m *CVE_DistroSpecific) GetCvssV3() *CVSSV3 {
	if m != nil {
		return m.CvssV3
	}
	return nil
}

func (m *CVE_DistroSpecific) MessageClone() proto.Message {
	return m.Clone()
}
func (m *CVE_DistroSpecific) Clone() *CVE_DistroSpecific {
	if m == nil {
		return nil
	}
	cloned := new(CVE_DistroSpecific)
	*cloned = *m

	cloned.CvssV2 = m.CvssV2.Clone()
	cloned.CvssV3 = m.CvssV3.Clone()
	return cloned
}

type CVSSV2 struct {
	Vector               string                  `protobuf:"bytes,1,opt,name=vector,proto3" json:"vector,omitempty"`
	AttackVector         CVSSV2_AttackVector     `protobuf:"varint,2,opt,name=attack_vector,json=attackVector,proto3,enum=storage.CVSSV2_AttackVector" json:"attack_vector,omitempty"`
	AccessComplexity     CVSSV2_AccessComplexity `protobuf:"varint,3,opt,name=access_complexity,json=accessComplexity,proto3,enum=storage.CVSSV2_AccessComplexity" json:"access_complexity,omitempty"`
	Authentication       CVSSV2_Authentication   `protobuf:"varint,4,opt,name=authentication,proto3,enum=storage.CVSSV2_Authentication" json:"authentication,omitempty"`
	Confidentiality      CVSSV2_Impact           `protobuf:"varint,5,opt,name=confidentiality,proto3,enum=storage.CVSSV2_Impact" json:"confidentiality,omitempty"`
	Integrity            CVSSV2_Impact           `protobuf:"varint,6,opt,name=integrity,proto3,enum=storage.CVSSV2_Impact" json:"integrity,omitempty"`
	Availability         CVSSV2_Impact           `protobuf:"varint,7,opt,name=availability,proto3,enum=storage.CVSSV2_Impact" json:"availability,omitempty"`
	ExploitabilityScore  float32                 `protobuf:"fixed32,8,opt,name=exploitability_score,json=exploitabilityScore,proto3" json:"exploitability_score,omitempty"`
	ImpactScore          float32                 `protobuf:"fixed32,9,opt,name=impact_score,json=impactScore,proto3" json:"impact_score,omitempty"`
	Score                float32                 `protobuf:"fixed32,10,opt,name=score,proto3" json:"score,omitempty"`
	Severity             CVSSV2_Severity         `protobuf:"varint,11,opt,name=severity,proto3,enum=storage.CVSSV2_Severity" json:"severity,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *CVSSV2) Reset()         { *m = CVSSV2{} }
func (m *CVSSV2) String() string { return proto.CompactTextString(m) }
func (*CVSSV2) ProtoMessage()    {}
func (*CVSSV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{1}
}
func (m *CVSSV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CVSSV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CVSSV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CVSSV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CVSSV2.Merge(m, src)
}
func (m *CVSSV2) XXX_Size() int {
	return m.Size()
}
func (m *CVSSV2) XXX_DiscardUnknown() {
	xxx_messageInfo_CVSSV2.DiscardUnknown(m)
}

var xxx_messageInfo_CVSSV2 proto.InternalMessageInfo

func (m *CVSSV2) GetVector() string {
	if m != nil {
		return m.Vector
	}
	return ""
}

func (m *CVSSV2) GetAttackVector() CVSSV2_AttackVector {
	if m != nil {
		return m.AttackVector
	}
	return CVSSV2_ATTACK_LOCAL
}

func (m *CVSSV2) GetAccessComplexity() CVSSV2_AccessComplexity {
	if m != nil {
		return m.AccessComplexity
	}
	return CVSSV2_ACCESS_HIGH
}

func (m *CVSSV2) GetAuthentication() CVSSV2_Authentication {
	if m != nil {
		return m.Authentication
	}
	return CVSSV2_AUTH_MULTIPLE
}

func (m *CVSSV2) GetConfidentiality() CVSSV2_Impact {
	if m != nil {
		return m.Confidentiality
	}
	return CVSSV2_IMPACT_NONE
}

func (m *CVSSV2) GetIntegrity() CVSSV2_Impact {
	if m != nil {
		return m.Integrity
	}
	return CVSSV2_IMPACT_NONE
}

func (m *CVSSV2) GetAvailability() CVSSV2_Impact {
	if m != nil {
		return m.Availability
	}
	return CVSSV2_IMPACT_NONE
}

func (m *CVSSV2) GetExploitabilityScore() float32 {
	if m != nil {
		return m.ExploitabilityScore
	}
	return 0
}

func (m *CVSSV2) GetImpactScore() float32 {
	if m != nil {
		return m.ImpactScore
	}
	return 0
}

func (m *CVSSV2) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *CVSSV2) GetSeverity() CVSSV2_Severity {
	if m != nil {
		return m.Severity
	}
	return CVSSV2_UNKNOWN
}

func (m *CVSSV2) MessageClone() proto.Message {
	return m.Clone()
}
func (m *CVSSV2) Clone() *CVSSV2 {
	if m == nil {
		return nil
	}
	cloned := new(CVSSV2)
	*cloned = *m

	return cloned
}

type CVSSV3 struct {
	Vector               string                 `protobuf:"bytes,1,opt,name=vector,proto3" json:"vector,omitempty"`
	ExploitabilityScore  float32                `protobuf:"fixed32,2,opt,name=exploitability_score,json=exploitabilityScore,proto3" json:"exploitability_score,omitempty"`
	ImpactScore          float32                `protobuf:"fixed32,3,opt,name=impact_score,json=impactScore,proto3" json:"impact_score,omitempty"`
	AttackVector         CVSSV3_AttackVector    `protobuf:"varint,4,opt,name=attack_vector,json=attackVector,proto3,enum=storage.CVSSV3_AttackVector" json:"attack_vector,omitempty"`
	AttackComplexity     CVSSV3_Complexity      `protobuf:"varint,5,opt,name=attack_complexity,json=attackComplexity,proto3,enum=storage.CVSSV3_Complexity" json:"attack_complexity,omitempty"`
	PrivilegesRequired   CVSSV3_Privileges      `protobuf:"varint,6,opt,name=privileges_required,json=privilegesRequired,proto3,enum=storage.CVSSV3_Privileges" json:"privileges_required,omitempty"`
	UserInteraction      CVSSV3_UserInteraction `protobuf:"varint,7,opt,name=user_interaction,json=userInteraction,proto3,enum=storage.CVSSV3_UserInteraction" json:"user_interaction,omitempty"`
	Scope                CVSSV3_Scope           `protobuf:"varint,8,opt,name=scope,proto3,enum=storage.CVSSV3_Scope" json:"scope,omitempty"`
	Confidentiality      CVSSV3_Impact          `protobuf:"varint,9,opt,name=confidentiality,proto3,enum=storage.CVSSV3_Impact" json:"confidentiality,omitempty"`
	Integrity            CVSSV3_Impact          `protobuf:"varint,10,opt,name=integrity,proto3,enum=storage.CVSSV3_Impact" json:"integrity,omitempty"`
	Availability         CVSSV3_Impact          `protobuf:"varint,11,opt,name=availability,proto3,enum=storage.CVSSV3_Impact" json:"availability,omitempty"`
	Score                float32                `protobuf:"fixed32,12,opt,name=score,proto3" json:"score,omitempty"`
	Severity             CVSSV3_Severity        `protobuf:"varint,13,opt,name=severity,proto3,enum=storage.CVSSV3_Severity" json:"severity,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *CVSSV3) Reset()         { *m = CVSSV3{} }
func (m *CVSSV3) String() string { return proto.CompactTextString(m) }
func (*CVSSV3) ProtoMessage()    {}
func (*CVSSV3) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7bf0cfd04430357, []int{2}
}
func (m *CVSSV3) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CVSSV3) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CVSSV3.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CVSSV3) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CVSSV3.Merge(m, src)
}
func (m *CVSSV3) XXX_Size() int {
	return m.Size()
}
func (m *CVSSV3) XXX_DiscardUnknown() {
	xxx_messageInfo_CVSSV3.DiscardUnknown(m)
}

var xxx_messageInfo_CVSSV3 proto.InternalMessageInfo

func (m *CVSSV3) GetVector() string {
	if m != nil {
		return m.Vector
	}
	return ""
}

func (m *CVSSV3) GetExploitabilityScore() float32 {
	if m != nil {
		return m.ExploitabilityScore
	}
	return 0
}

func (m *CVSSV3) GetImpactScore() float32 {
	if m != nil {
		return m.ImpactScore
	}
	return 0
}

func (m *CVSSV3) GetAttackVector() CVSSV3_AttackVector {
	if m != nil {
		return m.AttackVector
	}
	return CVSSV3_ATTACK_LOCAL
}

func (m *CVSSV3) GetAttackComplexity() CVSSV3_Complexity {
	if m != nil {
		return m.AttackComplexity
	}
	return CVSSV3_COMPLEXITY_LOW
}

func (m *CVSSV3) GetPrivilegesRequired() CVSSV3_Privileges {
	if m != nil {
		return m.PrivilegesRequired
	}
	return CVSSV3_PRIVILEGE_NONE
}

func (m *CVSSV3) GetUserInteraction() CVSSV3_UserInteraction {
	if m != nil {
		return m.UserInteraction
	}
	return CVSSV3_UI_NONE
}

func (m *CVSSV3) GetScope() CVSSV3_Scope {
	if m != nil {
		return m.Scope
	}
	return CVSSV3_UNCHANGED
}

func (m *CVSSV3) GetConfidentiality() CVSSV3_Impact {
	if m != nil {
		return m.Confidentiality
	}
	return CVSSV3_IMPACT_NONE
}

func (m *CVSSV3) GetIntegrity() CVSSV3_Impact {
	if m != nil {
		return m.Integrity
	}
	return CVSSV3_IMPACT_NONE
}

func (m *CVSSV3) GetAvailability() CVSSV3_Impact {
	if m != nil {
		return m.Availability
	}
	return CVSSV3_IMPACT_NONE
}

func (m *CVSSV3) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *CVSSV3) GetSeverity() CVSSV3_Severity {
	if m != nil {
		return m.Severity
	}
	return CVSSV3_UNKNOWN
}

func (m *CVSSV3) MessageClone() proto.Message {
	return m.Clone()
}
func (m *CVSSV3) Clone() *CVSSV3 {
	if m == nil {
		return nil
	}
	cloned := new(CVSSV3)
	*cloned = *m

	return cloned
}

func init() {
	proto.RegisterEnum("storage.VulnerabilityState", VulnerabilityState_name, VulnerabilityState_value)
	proto.RegisterEnum("storage.VulnerabilitySeverity", VulnerabilitySeverity_name, VulnerabilitySeverity_value)
	proto.RegisterEnum("storage.CVE_ScoreVersion", CVE_ScoreVersion_name, CVE_ScoreVersion_value)
	proto.RegisterEnum("storage.CVE_CVEType", CVE_CVEType_name, CVE_CVEType_value)
	proto.RegisterEnum("storage.CVSSV2_Impact", CVSSV2_Impact_name, CVSSV2_Impact_value)
	proto.RegisterEnum("storage.CVSSV2_AttackVector", CVSSV2_AttackVector_name, CVSSV2_AttackVector_value)
	proto.RegisterEnum("storage.CVSSV2_AccessComplexity", CVSSV2_AccessComplexity_name, CVSSV2_AccessComplexity_value)
	proto.RegisterEnum("storage.CVSSV2_Authentication", CVSSV2_Authentication_name, CVSSV2_Authentication_value)
	proto.RegisterEnum("storage.CVSSV2_Severity", CVSSV2_Severity_name, CVSSV2_Severity_value)
	proto.RegisterEnum("storage.CVSSV3_Impact", CVSSV3_Impact_name, CVSSV3_Impact_value)
	proto.RegisterEnum("storage.CVSSV3_AttackVector", CVSSV3_AttackVector_name, CVSSV3_AttackVector_value)
	proto.RegisterEnum("storage.CVSSV3_Complexity", CVSSV3_Complexity_name, CVSSV3_Complexity_value)
	proto.RegisterEnum("storage.CVSSV3_Privileges", CVSSV3_Privileges_name, CVSSV3_Privileges_value)
	proto.RegisterEnum("storage.CVSSV3_UserInteraction", CVSSV3_UserInteraction_name, CVSSV3_UserInteraction_value)
	proto.RegisterEnum("storage.CVSSV3_Scope", CVSSV3_Scope_name, CVSSV3_Scope_value)
	proto.RegisterEnum("storage.CVSSV3_Severity", CVSSV3_Severity_name, CVSSV3_Severity_value)
	proto.RegisterType((*CVE)(nil), "storage.CVE")
	proto.RegisterMapType((map[string]*CVE_DistroSpecific)(nil), "storage.CVE.DistroSpecificsEntry")
	proto.RegisterType((*CVE_Reference)(nil), "storage.CVE.Reference")
	proto.RegisterType((*CVE_DistroSpecific)(nil), "storage.CVE.DistroSpecific")
	proto.RegisterType((*CVSSV2)(nil), "storage.CVSSV2")
	proto.RegisterType((*CVSSV3)(nil), "storage.CVSSV3")
}

func init() { proto.RegisterFile("storage/cve.proto", fileDescriptor_d7bf0cfd04430357) }

var fileDescriptor_d7bf0cfd04430357 = []byte{
	// 1718 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0x7f, 0x6e, 0xdb, 0xc8,
	0x15, 0x36, 0x29, 0x59, 0x96, 0x9e, 0x7e, 0xd1, 0x63, 0x27, 0xcb, 0x78, 0x5b, 0x4b, 0xe1, 0xb6,
	0x85, 0xb1, 0x59, 0xd8, 0x88, 0x94, 0x2e, 0x02, 0xa3, 0x68, 0x4b, 0x49, 0xb4, 0xcd, 0xb5, 0x7e,
	0xed, 0x90, 0x52, 0x36, 0x45, 0x51, 0x82, 0xa1, 0xc6, 0x0e, 0x1b, 0x59, 0x54, 0x49, 0x4a, 0x88,
	0x7a, 0x84, 0x9e, 0xa0, 0x07, 0xe8, 0x09, 0x7a, 0x8a, 0x02, 0xfd, 0xa7, 0x27, 0x30, 0x8a, 0xf4,
	0x06, 0x46, 0x0f, 0x50, 0xcc, 0x90, 0x94, 0x28, 0x59, 0x72, 0xdc, 0xa2, 0x7f, 0x04, 0xe2, 0x7c,
	0xf3, 0xbd, 0xc7, 0x37, 0xef, 0xbd, 0xef, 0x71, 0x62, 0xd8, 0xf5, 0x7c, 0xc7, 0x35, 0xaf, 0xc9,
	0x89, 0x35, 0x25, 0xc7, 0x63, 0xd7, 0xf1, 0x1d, 0xb4, 0x13, 0x42, 0x07, 0xa5, 0x6b, 0xc7, 0xb9,
	0x1e, 0x92, 0x13, 0x06, 0xbf, 0x9b, 0x5c, 0x9d, 0xf8, 0xf6, 0x0d, 0xf1, 0x7c, 0xf3, 0x66, 0x1c,
	0x30, 0x0f, 0xf6, 0xaf, 0x9d, 0x6b, 0x87, 0x3d, 0x9e, 0xd0, 0xa7, 0x00, 0x95, 0xfe, 0x9a, 0x87,
	0x44, 0xbd, 0xaf, 0xa0, 0x9f, 0x01, 0x6f, 0x0f, 0x44, 0xae, 0xcc, 0x1d, 0x65, 0x6a, 0x4f, 0xef,
	0x6e, 0x4b, 0xc8, 0x23, 0xa6, 0x6b, 0xbd, 0x3f, 0x95, 0xea, 0x7d, 0xe5, 0x1b, 0xfa, 0x0e, 0x22,
	0x61, 0xde, 0x1e, 0xa0, 0x17, 0x90, 0xb4, 0xa6, 0x9e, 0x27, 0xf2, 0x65, 0xee, 0x88, 0xaf, 0x7d,
	0x71, 0x77, 0x5b, 0xda, 0x5b, 0x30, 0x35, 0x2d, 0xa2, 0x32, 0x12, 0xfa, 0x05, 0xe4, 0xec, 0x9b,
	0xb1, 0x69, 0xf9, 0x86, 0x67, 0x39, 0x2e, 0x11, 0x0b, 0xcc, 0xe8, 0xd9, 0xdd, 0x6d, 0xe9, 0x49,
	0x64, 0xa4, 0xb2, 0xfd, 0xb2, 0x66, 0x31, 0xb3, 0x6c, 0x40, 0x67, 0x2b, 0x74, 0x04, 0x49, 0x7f,
	0x36, 0x26, 0x62, 0xa2, 0xcc, 0x1d, 0x15, 0x2a, 0xfb, 0xc7, 0xe1, 0x49, 0x8f, 0xeb, 0x7d, 0x85,
	0xfe, 0xd3, 0x67, 0x63, 0x82, 0x19, 0x03, 0x9d, 0xc3, 0x36, 0xfd, 0xf5, 0x44, 0x54, 0x4e, 0x6c,
	0xa2, 0xd6, 0xbe, 0xbc, 0xbb, 0x2d, 0x7d, 0x11, 0x3b, 0x55, 0x99, 0xa2, 0x51, 0xbc, 0x81, 0x3d,
	0x12, 0x61, 0xc7, 0x9b, 0xdc, 0xdc, 0x98, 0xee, 0x4c, 0x4c, 0xd2, 0x54, 0xe0, 0x68, 0x89, 0x10,
	0x24, 0x87, 0xf6, 0xe8, 0x83, 0xb8, 0xcd, 0x60, 0xf6, 0x8c, 0x7e, 0x0b, 0xb9, 0xf1, 0xe4, 0xdd,
	0xd0, 0xf6, 0xde, 0x93, 0x81, 0xe1, 0x8c, 0xc4, 0x54, 0x99, 0x3b, 0xca, 0x56, 0x0e, 0x8e, 0x83,
	0x4a, 0x1c, 0x47, 0x95, 0x38, 0xd6, 0xa3, 0x4a, 0xd4, 0x7e, 0x7c, 0x77, 0x5b, 0x7a, 0x16, 0x8f,
	0xa1, 0x1b, 0xd9, 0x97, 0x3b, 0x23, 0x09, 0x67, 0xe7, 0xee, 0x3a, 0x23, 0xf4, 0x03, 0x80, 0xe5,
	0x12, 0xd3, 0x27, 0x03, 0xc3, 0xf4, 0xc5, 0xe2, 0x7f, 0xef, 0xbb, 0x1e, 0x58, 0x97, 0x29, 0x45,
	0xc2, 0x99, 0xd0, 0x99, 0xec, 0xa3, 0x5f, 0x41, 0x7e, 0x68, 0x7a, 0xbe, 0x71, 0xe3, 0x0c, 0xec,
	0x2b, 0x9b, 0x0c, 0xc4, 0x9d, 0xcf, 0x39, 0xc7, 0x39, 0x6a, 0xd0, 0x0a, 0xf9, 0xe8, 0x5b, 0x00,
	0x97, 0x5c, 0x11, 0x97, 0x8c, 0x2c, 0xe2, 0x89, 0xe9, 0x72, 0xe2, 0x28, 0x5b, 0x79, 0xba, 0x94,
	0x74, 0x1c, 0x6d, 0xe3, 0x18, 0x13, 0xfd, 0x12, 0xf2, 0xac, 0x11, 0x8c, 0x29, 0x71, 0x3d, 0xdb,
	0x19, 0x89, 0x19, 0x56, 0xda, 0x67, 0x4b, 0xa6, 0xac, 0xf8, 0xfd, 0x80, 0x80, 0x73, 0x5e, 0x6c,
	0x85, 0x8e, 0x60, 0x87, 0xf6, 0x95, 0x31, 0xad, 0x88, 0xc0, 0x42, 0x2e, 0xc6, 0x2c, 0x35, 0xad,
	0x5f, 0xc1, 0x29, 0xba, 0xdf, 0xaf, 0x2c, 0x98, 0x55, 0x31, 0xbb, 0x8e, 0x59, 0x0d, 0x99, 0x55,
	0xf4, 0x1a, 0xc0, 0x9b, 0x8c, 0xc7, 0x2e, 0xf1, 0x3c, 0x32, 0x10, 0x73, 0x65, 0xee, 0x28, 0x5d,
	0x13, 0xef, 0x6e, 0x4b, 0xfb, 0xf1, 0x54, 0x6a, 0x23, 0xc7, 0xf9, 0x23, 0x19, 0x48, 0x38, 0xc6,
	0x45, 0x97, 0xb0, 0x17, 0xad, 0x0c, 0xd3, 0xf2, 0xed, 0xa9, 0xe9, 0xd3, 0x33, 0x09, 0x9f, 0x4d,
	0x26, 0x8a, 0xcc, 0xe4, 0xb9, 0x15, 0xfa, 0x3d, 0x14, 0xe7, 0xce, 0xc8, 0xc7, 0xb1, 0xed, 0xce,
	0xc4, 0xdd, 0xcf, 0x96, 0xfc, 0xa7, 0x77, 0xb7, 0xa5, 0xe7, 0xf7, 0xe3, 0x2c, 0x2b, 0xcc, 0xc1,
	0x37, 0xef, 0xed, 0xc1, 0x80, 0x8c, 0x24, 0x5c, 0x88, 0x3c, 0x07, 0x38, 0x6a, 0x82, 0x30, 0xb0,
	0x3d, 0xdf, 0x75, 0x0c, 0x6f, 0x4c, 0x2c, 0xfb, 0xca, 0xb6, 0x3c, 0x71, 0x8f, 0x15, 0xf1, 0xf9,
	0x52, 0x25, 0x1a, 0x8c, 0xa4, 0x45, 0x1c, 0x65, 0xe4, 0xbb, 0x33, 0x5c, 0x1c, 0x2c, 0xa3, 0xe8,
	0x7b, 0x48, 0x7b, 0x64, 0x4a, 0x5c, 0xdb, 0x9f, 0x89, 0xfb, 0xac, 0x9e, 0x87, 0x73, 0x2f, 0xfd,
	0xc9, 0x70, 0x44, 0x5c, 0xf3, 0x9d, 0x3d, 0xb4, 0xfd, 0x99, 0x16, 0xb2, 0x6a, 0x4f, 0xee, 0x6e,
	0x4b, 0xbb, 0x51, 0xd8, 0x11, 0x2a, 0xe1, 0xb9, 0x9b, 0x83, 0x97, 0x90, 0x99, 0x37, 0x10, 0x12,
	0x20, 0xd1, 0xc3, 0x6a, 0x30, 0x9a, 0x30, 0x7d, 0xa4, 0x5a, 0xf4, 0xcd, 0x6b, 0x3a, 0x83, 0x12,
	0x54, 0x8b, 0xf4, 0xf9, 0xe0, 0xdf, 0x1c, 0x14, 0x96, 0xe3, 0x45, 0xa7, 0xb1, 0xc0, 0xb8, 0xc7,
	0x04, 0xb6, 0x88, 0x80, 0xbe, 0x62, 0x31, 0xe6, 0xc2, 0x69, 0x76, 0xaf, 0x7b, 0x13, 0xff, 0x73,
	0xf7, 0x26, 0x1f, 0xdd, 0xbd, 0xdb, 0x0f, 0x76, 0xef, 0x81, 0x01, 0xfb, 0xeb, 0xaa, 0x44, 0x93,
	0xf6, 0x81, 0xcc, 0xa2, 0xa4, 0x7d, 0x20, 0x33, 0xf4, 0x12, 0xb6, 0xa7, 0xe6, 0x70, 0x42, 0xd8,
	0x91, 0xb2, 0x95, 0x2f, 0x1f, 0xa8, 0x34, 0x0e, 0x98, 0xa7, 0xfc, 0x6b, 0x4e, 0x7a, 0x01, 0xb9,
	0xf8, 0x91, 0x50, 0x0a, 0xf8, 0x7e, 0x45, 0xd8, 0x62, 0xbf, 0x55, 0x81, 0x43, 0x59, 0xd8, 0xe9,
	0xb5, 0x2f, 0xdb, 0x9d, 0x37, 0x6d, 0x81, 0x97, 0xae, 0x60, 0x27, 0x9c, 0xb6, 0xa8, 0x08, 0xd9,
	0x10, 0x37, 0xea, 0x7d, 0x45, 0xd8, 0x42, 0x79, 0xc8, 0xa8, 0x2d, 0xf9, 0x5c, 0x61, 0x4b, 0x66,
	0x77, 0xf9, 0x5a, 0x63, 0x0b, 0x9e, 0xed, 0x69, 0xba, 0xda, 0x61, 0xcb, 0x04, 0xca, 0x41, 0xba,
	0xdd, 0x69, 0x04, 0xcc, 0x24, 0xda, 0x85, 0x7c, 0xa7, 0xab, 0xb4, 0xb5, 0x0b, 0xf5, 0x4c, 0x67,
	0xd0, 0xb6, 0xf4, 0x97, 0x1d, 0x48, 0x05, 0x29, 0x43, 0x4f, 0x21, 0x35, 0x25, 0x96, 0xef, 0xb8,
	0xe1, 0x59, 0xc3, 0x15, 0x92, 0x21, 0x6f, 0xfa, 0xbe, 0x69, 0x7d, 0x30, 0xc2, 0x6d, 0x9e, 0x15,
	0xeb, 0x47, 0x2b, 0x29, 0x3f, 0x96, 0x19, 0xa9, 0xcf, 0x38, 0x38, 0x67, 0xc6, 0x56, 0xa8, 0x05,
	0xbb, 0xa6, 0x65, 0x51, 0x41, 0x5a, 0xce, 0xcd, 0x78, 0x48, 0x3e, 0xd2, 0x46, 0x0a, 0x6a, 0x5e,
	0xbe, 0xe7, 0x86, 0x11, 0xeb, 0x73, 0x1e, 0x16, 0xcc, 0x15, 0x04, 0x9d, 0x41, 0xc1, 0x9c, 0xf8,
	0xef, 0xc9, 0xc8, 0xb7, 0xad, 0x60, 0x52, 0x24, 0x57, 0x9a, 0x32, 0xf2, 0xb5, 0xc4, 0xc2, 0x2b,
	0x56, 0xe8, 0xd7, 0x50, 0xb4, 0x9c, 0xd1, 0x95, 0x3d, 0xa0, 0x98, 0x49, 0xfb, 0x97, 0x35, 0x49,
	0x61, 0x69, 0x02, 0x33, 0x47, 0xc1, 0xb7, 0x15, 0xaf, 0xd2, 0xd1, 0x2b, 0xc8, 0xd8, 0x23, 0x9f,
	0x5c, 0x33, 0x65, 0xa4, 0x1e, 0xb4, 0x5d, 0x10, 0xd1, 0x29, 0xe4, 0xcc, 0xa9, 0x69, 0x0f, 0x43,
	0xd1, 0xb0, 0x8f, 0xc6, 0x66, 0xc3, 0x25, 0x2e, 0x7a, 0x09, 0xfb, 0xe4, 0xe3, 0x78, 0xe8, 0xd8,
	0x7e, 0x88, 0x84, 0x17, 0x82, 0x34, 0x93, 0xd7, 0xde, 0xf2, 0x5e, 0xf0, 0xf5, 0x7f, 0xbe, 0x72,
	0x77, 0xc8, 0x30, 0xea, 0xd2, 0x05, 0x61, 0x1f, 0xb6, 0x83, 0x3d, 0x60, 0x7b, 0xc1, 0x02, 0xbd,
	0x8a, 0xc9, 0x3e, 0xcb, 0x62, 0x14, 0x57, 0x63, 0xbc, 0x2f, 0x78, 0xa9, 0x06, 0xa9, 0x20, 0x72,
	0xda, 0xb9, 0x6a, 0xab, 0x2b, 0xd7, 0x75, 0xa3, 0xdd, 0x69, 0xd3, 0xce, 0x45, 0x50, 0x08, 0x81,
	0xae, 0x8c, 0x75, 0x55, 0x6e, 0x0a, 0x1c, 0xda, 0x83, 0x62, 0x88, 0xd5, 0x3b, 0xad, 0x6e, 0x53,
	0xd1, 0x15, 0x81, 0x97, 0x54, 0xc8, 0xc5, 0xdb, 0x09, 0x09, 0x90, 0x93, 0x75, 0x5d, 0xae, 0x5f,
	0x1a, 0xcd, 0x4e, 0x5d, 0x6e, 0x0a, 0x5b, 0xd4, 0x2c, 0x44, 0xe4, 0xc6, 0x77, 0x72, 0x5d, 0x69,
	0xeb, 0x02, 0x47, 0xfd, 0x87, 0x60, 0x5b, 0xd1, 0xdf, 0x74, 0xf0, 0xa5, 0xc0, 0x4b, 0x67, 0x20,
	0xac, 0xb6, 0x14, 0x0d, 0x4c, 0xae, 0xd7, 0x15, 0x4d, 0x33, 0x2e, 0xd4, 0xf3, 0x0b, 0x61, 0x8b,
	0x2a, 0x23, 0x04, 0x5a, 0x4a, 0x43, 0xed, 0xb5, 0x04, 0x0e, 0x15, 0x00, 0x42, 0xa8, 0xd9, 0x79,
	0x23, 0xf0, 0x52, 0x1d, 0x0a, 0xcb, 0xed, 0xc4, 0x8c, 0x7a, 0xfa, 0x85, 0xd1, 0xea, 0x35, 0x75,
	0xb5, 0xdb, 0xa4, 0x07, 0xa4, 0x8e, 0x29, 0xa4, 0xa9, 0xed, 0xf3, 0x26, 0x15, 0x67, 0x1e, 0x32,
	0x0c, 0x60, 0x09, 0xe0, 0xa5, 0x6f, 0x21, 0x1d, 0x65, 0x2c, 0xae, 0xf7, 0x2d, 0xb4, 0x03, 0x09,
	0xfa, 0x1a, 0x0e, 0x01, 0xa4, 0xc2, 0x10, 0x78, 0x94, 0x86, 0x24, 0x8b, 0x2f, 0x21, 0xfd, 0x29,
	0x13, 0xca, 0xb4, 0xba, 0x51, 0xa6, 0x9b, 0x1a, 0x83, 0x7f, 0x7c, 0x63, 0x24, 0xee, 0x37, 0xc6,
	0x3d, 0xf1, 0x27, 0xd7, 0x89, 0xbf, 0xfa, 0x90, 0xf8, 0xcf, 0x61, 0x37, 0x74, 0x11, 0x13, 0x7f,
	0xa0, 0xb3, 0x83, 0x55, 0x37, 0x4b, 0xb2, 0x67, 0x46, 0xb1, 0xaa, 0x5d, 0xc2, 0xde, 0xd8, 0xb5,
	0xa7, 0xf6, 0x90, 0x5c, 0x13, 0xcf, 0x70, 0xc9, 0x1f, 0x26, 0xb6, 0x4b, 0x06, 0xa1, 0xec, 0xee,
	0xb9, 0xea, 0xce, 0xa9, 0x18, 0x2d, 0xcc, 0x70, 0x68, 0x85, 0xbe, 0x03, 0x61, 0xe2, 0x11, 0xd7,
	0xa0, 0xaa, 0x74, 0xe9, 0x9d, 0xc3, 0x19, 0x85, 0x3a, 0x2c, 0xad, 0x7a, 0xea, 0x79, 0xc4, 0x55,
	0x17, 0x34, 0x5c, 0x9c, 0x2c, 0x03, 0xe8, 0x05, 0x53, 0xcf, 0x38, 0x10, 0x61, 0xa1, 0xf2, 0x64,
	0xd5, 0x81, 0x46, 0x37, 0x71, 0xc0, 0x59, 0x37, 0x74, 0x32, 0xeb, 0xf4, 0x5f, 0x7d, 0xdc, 0xd0,
	0x81, 0x07, 0x6d, 0x1f, 0x18, 0x3a, 0xd9, 0x07, 0x0d, 0x97, 0x87, 0xce, 0x7c, 0x3c, 0xe4, 0x36,
	0x8d, 0x87, 0xfc, 0xba, 0xf1, 0x50, 0x5d, 0x37, 0x1e, 0x4e, 0x37, 0x8f, 0x87, 0x02, 0x40, 0x08,
	0x04, 0x5a, 0x58, 0x10, 0x98, 0x0c, 0x78, 0xe9, 0x77, 0xff, 0xb7, 0xb1, 0x10, 0x23, 0x76, 0x2f,
	0xde, 0x6a, 0x2a, 0xb5, 0x4e, 0x48, 0x3f, 0x07, 0x88, 0xf5, 0x1b, 0x82, 0x42, 0x30, 0x92, 0x7e,
	0x50, 0xf5, 0xb7, 0x2c, 0x24, 0xe6, 0x3f, 0x86, 0xb1, 0xb0, 0x38, 0xe9, 0x1c, 0x60, 0xd1, 0x6d,
	0xd4, 0xac, 0x8b, 0xd5, 0xbe, 0xda, 0x54, 0xce, 0x95, 0xe8, 0x64, 0xbb, 0x90, 0x5f, 0x60, 0xc1,
	0xe1, 0x96, 0x68, 0xe1, 0xf9, 0x4e, 0xa0, 0xb8, 0xd2, 0x6c, 0x6c, 0x4a, 0xa8, 0x91, 0x1b, 0x7a,
	0x15, 0x50, 0x0d, 0xac, 0x7c, 0xdf, 0x53, 0xb1, 0xd2, 0x10, 0x38, 0xe9, 0x2b, 0xd8, 0x66, 0xcd,
	0x45, 0xe7, 0x4c, 0xaf, 0x5d, 0xbf, 0x90, 0xdb, 0xe7, 0x4a, 0x43, 0xd8, 0xa2, 0x56, 0xd1, 0x82,
	0x93, 0xda, 0x9b, 0x86, 0x4e, 0x1a, 0x92, 0xcc, 0x31, 0x17, 0x8d, 0x1f, 0x3e, 0x36, 0x7e, 0x12,
	0xf3, 0xf1, 0x93, 0xa4, 0xd7, 0x88, 0x3a, 0x56, 0x75, 0x96, 0xa5, 0xed, 0xaf, 0x1b, 0x80, 0x96,
	0x2f, 0x7d, 0xbe, 0xe9, 0x13, 0xca, 0xe9, 0xd4, 0x34, 0x05, 0xf7, 0x59, 0x00, 0x39, 0x48, 0x37,
	0x94, 0x33, 0x05, 0xb3, 0x30, 0xe9, 0x59, 0xcf, 0xe4, 0xa6, 0xa6, 0x18, 0xdd, 0x8e, 0xa6, 0xea,
	0x2a, 0xbd, 0xa9, 0x7c, 0xfd, 0x77, 0x0e, 0x9e, 0xac, 0xbd, 0x3b, 0x22, 0x09, 0x0e, 0xa3, 0x0b,
	0x4f, 0xbf, 0xd7, 0x6c, 0x2b, 0x58, 0xae, 0xa9, 0x4d, 0x9a, 0x6e, 0x4d, 0xe9, 0x2b, 0x58, 0xd5,
	0xdf, 0x0a, 0x5b, 0xe8, 0x10, 0x0e, 0x9a, 0x9d, 0x37, 0x9b, 0xf6, 0x39, 0xf4, 0x15, 0x94, 0x5a,
	0x9d, 0x86, 0x82, 0x65, 0x5d, 0xd9, 0x44, 0xe2, 0xd1, 0x4f, 0xa0, 0xac, 0xb6, 0xba, 0x1d, 0xac,
	0xcb, 0x6d, 0x7d, 0x13, 0x2b, 0x41, 0x5d, 0x45, 0x87, 0xdf, 0x44, 0x4a, 0xd6, 0x5e, 0xfd, 0xed,
	0xd3, 0x21, 0xf7, 0x8f, 0x4f, 0x87, 0xdc, 0x3f, 0x3f, 0x1d, 0x72, 0x7f, 0xfe, 0xd7, 0xe1, 0x16,
	0x3c, 0xb3, 0x9d, 0x63, 0x8f, 0xf6, 0xaa, 0xeb, 0x7c, 0x0c, 0xfe, 0xc7, 0x11, 0x89, 0xe3, 0x37,
	0xd1, 0x5f, 0x1a, 0xde, 0xa5, 0x18, 0x5e, 0xfd, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x7b, 0x51,
	0x36, 0xb2, 0x8e, 0x10, 0x00, 0x00,
}

func (m *CVE) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CVE) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CVE) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Severity != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.Severity))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa0
	}
	if len(m.DistroSpecifics) > 0 {
		for k := range m.DistroSpecifics {
			v := m.DistroSpecifics[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintCve(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintCve(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintCve(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x9a
		}
	}
	if len(m.Types) > 0 {
		dAtA3 := make([]byte, len(m.Types)*10)
		var j2 int
		for _, num := range m.Types {
			for num >= 1<<7 {
				dAtA3[j2] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j2++
			}
			dAtA3[j2] = uint8(num)
			j2++
		}
		i -= j2
		copy(dAtA[i:], dAtA3[:j2])
		i = encodeVarintCve(dAtA, i, uint64(j2))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if m.SuppressExpiry != nil {
		{
			size, err := m.SuppressExpiry.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCve(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if m.SuppressActivation != nil {
		{
			size, err := m.SuppressActivation.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCve(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCve(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x7a
	}
	if m.ImpactScore != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.ImpactScore))))
		i--
		dAtA[i] = 0x75
	}
	if m.Suppressed {
		i--
		if m.Suppressed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x60
	}
	if m.CvssV3 != nil {
		{
			size, err := m.CvssV3.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCve(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.CvssV2 != nil {
		{
			size, err := m.CvssV2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCve(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.ScoreVersion != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.ScoreVersion))
		i--
		dAtA[i] = 0x48
	}
	if len(m.References) > 0 {
		for iNdEx := len(m.References) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.References[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintCve(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x42
		}
	}
	if m.LastModified != nil {
		{
			size, err := m.LastModified.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCve(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.PublishedOn != nil {
		{
			size, err := m.PublishedOn.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCve(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.Link) > 0 {
		i -= len(m.Link)
		copy(dAtA[i:], m.Link)
		i = encodeVarintCve(dAtA, i, uint64(len(m.Link)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Summary) > 0 {
		i -= len(m.Summary)
		copy(dAtA[i:], m.Summary)
		i = encodeVarintCve(dAtA, i, uint64(len(m.Summary)))
		i--
		dAtA[i] = 0x22
	}
	if m.Type != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x18
	}
	if m.Cvss != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.Cvss))))
		i--
		dAtA[i] = 0x15
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintCve(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CVE_Reference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CVE_Reference) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CVE_Reference) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintCve(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.URI) > 0 {
		i -= len(m.URI)
		copy(dAtA[i:], m.URI)
		i = encodeVarintCve(dAtA, i, uint64(len(m.URI)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CVE_DistroSpecific) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CVE_DistroSpecific) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CVE_DistroSpecific) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CvssV3 != nil {
		{
			size, err := m.CvssV3.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCve(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.CvssV2 != nil {
		{
			size, err := m.CvssV2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCve(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.ScoreVersion != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.ScoreVersion))
		i--
		dAtA[i] = 0x18
	}
	if m.Cvss != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.Cvss))))
		i--
		dAtA[i] = 0x15
	}
	if m.Severity != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.Severity))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CVSSV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CVSSV2) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CVSSV2) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Severity != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.Severity))
		i--
		dAtA[i] = 0x58
	}
	if m.Score != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.Score))))
		i--
		dAtA[i] = 0x55
	}
	if m.ImpactScore != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.ImpactScore))))
		i--
		dAtA[i] = 0x4d
	}
	if m.ExploitabilityScore != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.ExploitabilityScore))))
		i--
		dAtA[i] = 0x45
	}
	if m.Availability != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.Availability))
		i--
		dAtA[i] = 0x38
	}
	if m.Integrity != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.Integrity))
		i--
		dAtA[i] = 0x30
	}
	if m.Confidentiality != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.Confidentiality))
		i--
		dAtA[i] = 0x28
	}
	if m.Authentication != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.Authentication))
		i--
		dAtA[i] = 0x20
	}
	if m.AccessComplexity != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.AccessComplexity))
		i--
		dAtA[i] = 0x18
	}
	if m.AttackVector != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.AttackVector))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Vector) > 0 {
		i -= len(m.Vector)
		copy(dAtA[i:], m.Vector)
		i = encodeVarintCve(dAtA, i, uint64(len(m.Vector)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CVSSV3) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CVSSV3) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CVSSV3) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Severity != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.Severity))
		i--
		dAtA[i] = 0x68
	}
	if m.Score != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.Score))))
		i--
		dAtA[i] = 0x65
	}
	if m.Availability != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.Availability))
		i--
		dAtA[i] = 0x58
	}
	if m.Integrity != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.Integrity))
		i--
		dAtA[i] = 0x50
	}
	if m.Confidentiality != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.Confidentiality))
		i--
		dAtA[i] = 0x48
	}
	if m.Scope != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.Scope))
		i--
		dAtA[i] = 0x40
	}
	if m.UserInteraction != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.UserInteraction))
		i--
		dAtA[i] = 0x38
	}
	if m.PrivilegesRequired != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.PrivilegesRequired))
		i--
		dAtA[i] = 0x30
	}
	if m.AttackComplexity != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.AttackComplexity))
		i--
		dAtA[i] = 0x28
	}
	if m.AttackVector != 0 {
		i = encodeVarintCve(dAtA, i, uint64(m.AttackVector))
		i--
		dAtA[i] = 0x20
	}
	if m.ImpactScore != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.ImpactScore))))
		i--
		dAtA[i] = 0x1d
	}
	if m.ExploitabilityScore != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.ExploitabilityScore))))
		i--
		dAtA[i] = 0x15
	}
	if len(m.Vector) > 0 {
		i -= len(m.Vector)
		copy(dAtA[i:], m.Vector)
		i = encodeVarintCve(dAtA, i, uint64(len(m.Vector)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintCve(dAtA []byte, offset int, v uint64) int {
	offset -= sovCve(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *CVE) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovCve(uint64(l))
	}
	if m.Cvss != 0 {
		n += 5
	}
	if m.Type != 0 {
		n += 1 + sovCve(uint64(m.Type))
	}
	l = len(m.Summary)
	if l > 0 {
		n += 1 + l + sovCve(uint64(l))
	}
	l = len(m.Link)
	if l > 0 {
		n += 1 + l + sovCve(uint64(l))
	}
	if m.PublishedOn != nil {
		l = m.PublishedOn.Size()
		n += 1 + l + sovCve(uint64(l))
	}
	if m.LastModified != nil {
		l = m.LastModified.Size()
		n += 1 + l + sovCve(uint64(l))
	}
	if len(m.References) > 0 {
		for _, e := range m.References {
			l = e.Size()
			n += 1 + l + sovCve(uint64(l))
		}
	}
	if m.ScoreVersion != 0 {
		n += 1 + sovCve(uint64(m.ScoreVersion))
	}
	if m.CvssV2 != nil {
		l = m.CvssV2.Size()
		n += 1 + l + sovCve(uint64(l))
	}
	if m.CvssV3 != nil {
		l = m.CvssV3.Size()
		n += 1 + l + sovCve(uint64(l))
	}
	if m.Suppressed {
		n += 2
	}
	if m.ImpactScore != 0 {
		n += 5
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovCve(uint64(l))
	}
	if m.SuppressActivation != nil {
		l = m.SuppressActivation.Size()
		n += 2 + l + sovCve(uint64(l))
	}
	if m.SuppressExpiry != nil {
		l = m.SuppressExpiry.Size()
		n += 2 + l + sovCve(uint64(l))
	}
	if len(m.Types) > 0 {
		l = 0
		for _, e := range m.Types {
			l += sovCve(uint64(e))
		}
		n += 2 + sovCve(uint64(l)) + l
	}
	if len(m.DistroSpecifics) > 0 {
		for k, v := range m.DistroSpecifics {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovCve(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovCve(uint64(len(k))) + l
			n += mapEntrySize + 2 + sovCve(uint64(mapEntrySize))
		}
	}
	if m.Severity != 0 {
		n += 2 + sovCve(uint64(m.Severity))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CVE_Reference) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.URI)
	if l > 0 {
		n += 1 + l + sovCve(uint64(l))
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovCve(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CVE_DistroSpecific) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Severity != 0 {
		n += 1 + sovCve(uint64(m.Severity))
	}
	if m.Cvss != 0 {
		n += 5
	}
	if m.ScoreVersion != 0 {
		n += 1 + sovCve(uint64(m.ScoreVersion))
	}
	if m.CvssV2 != nil {
		l = m.CvssV2.Size()
		n += 1 + l + sovCve(uint64(l))
	}
	if m.CvssV3 != nil {
		l = m.CvssV3.Size()
		n += 1 + l + sovCve(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CVSSV2) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Vector)
	if l > 0 {
		n += 1 + l + sovCve(uint64(l))
	}
	if m.AttackVector != 0 {
		n += 1 + sovCve(uint64(m.AttackVector))
	}
	if m.AccessComplexity != 0 {
		n += 1 + sovCve(uint64(m.AccessComplexity))
	}
	if m.Authentication != 0 {
		n += 1 + sovCve(uint64(m.Authentication))
	}
	if m.Confidentiality != 0 {
		n += 1 + sovCve(uint64(m.Confidentiality))
	}
	if m.Integrity != 0 {
		n += 1 + sovCve(uint64(m.Integrity))
	}
	if m.Availability != 0 {
		n += 1 + sovCve(uint64(m.Availability))
	}
	if m.ExploitabilityScore != 0 {
		n += 5
	}
	if m.ImpactScore != 0 {
		n += 5
	}
	if m.Score != 0 {
		n += 5
	}
	if m.Severity != 0 {
		n += 1 + sovCve(uint64(m.Severity))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CVSSV3) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Vector)
	if l > 0 {
		n += 1 + l + sovCve(uint64(l))
	}
	if m.ExploitabilityScore != 0 {
		n += 5
	}
	if m.ImpactScore != 0 {
		n += 5
	}
	if m.AttackVector != 0 {
		n += 1 + sovCve(uint64(m.AttackVector))
	}
	if m.AttackComplexity != 0 {
		n += 1 + sovCve(uint64(m.AttackComplexity))
	}
	if m.PrivilegesRequired != 0 {
		n += 1 + sovCve(uint64(m.PrivilegesRequired))
	}
	if m.UserInteraction != 0 {
		n += 1 + sovCve(uint64(m.UserInteraction))
	}
	if m.Scope != 0 {
		n += 1 + sovCve(uint64(m.Scope))
	}
	if m.Confidentiality != 0 {
		n += 1 + sovCve(uint64(m.Confidentiality))
	}
	if m.Integrity != 0 {
		n += 1 + sovCve(uint64(m.Integrity))
	}
	if m.Availability != 0 {
		n += 1 + sovCve(uint64(m.Availability))
	}
	if m.Score != 0 {
		n += 5
	}
	if m.Severity != 0 {
		n += 1 + sovCve(uint64(m.Severity))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovCve(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozCve(x uint64) (n int) {
	return sovCve(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *CVE) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCve
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CVE: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CVE: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCve
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCve
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cvss", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.Cvss = float32(math.Float32frombits(v))
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= CVE_CVEType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Summary", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCve
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCve
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Summary = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Link", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCve
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCve
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Link = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PublishedOn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCve
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCve
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PublishedOn == nil {
				m.PublishedOn = &types.Timestamp{}
			}
			if err := m.PublishedOn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastModified", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCve
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCve
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastModified == nil {
				m.LastModified = &types.Timestamp{}
			}
			if err := m.LastModified.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field References", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCve
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCve
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.References = append(m.References, &CVE_Reference{})
			if err := m.References[len(m.References)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScoreVersion", wireType)
			}
			m.ScoreVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScoreVersion |= CVE_ScoreVersion(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CvssV2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCve
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCve
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CvssV2 == nil {
				m.CvssV2 = &CVSSV2{}
			}
			if err := m.CvssV2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CvssV3", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCve
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCve
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CvssV3 == nil {
				m.CvssV3 = &CVSSV3{}
			}
			if err := m.CvssV3.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Suppressed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Suppressed = bool(v != 0)
		case 14:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field ImpactScore", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.ImpactScore = float32(math.Float32frombits(v))
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCve
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCve
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SuppressActivation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCve
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCve
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SuppressActivation == nil {
				m.SuppressActivation = &types.Timestamp{}
			}
			if err := m.SuppressActivation.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SuppressExpiry", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCve
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCve
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SuppressExpiry == nil {
				m.SuppressExpiry = &types.Timestamp{}
			}
			if err := m.SuppressExpiry.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 18:
			if wireType == 0 {
				var v CVE_CVEType
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowCve
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= CVE_CVEType(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Types = append(m.Types, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowCve
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthCve
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthCve
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.Types) == 0 {
					m.Types = make([]CVE_CVEType, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v CVE_CVEType
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCve
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= CVE_CVEType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Types = append(m.Types, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Types", wireType)
			}
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DistroSpecifics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCve
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCve
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DistroSpecifics == nil {
				m.DistroSpecifics = make(map[string]*CVE_DistroSpecific)
			}
			var mapkey string
			var mapvalue *CVE_DistroSpecific
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowCve
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCve
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthCve
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthCve
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCve
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthCve
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthCve
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &CVE_DistroSpecific{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipCve(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthCve
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DistroSpecifics[mapkey] = mapvalue
			iNdEx = postIndex
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Severity", wireType)
			}
			m.Severity = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Severity |= VulnerabilitySeverity(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCve(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCve
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CVE_Reference) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCve
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reference: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reference: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field URI", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCve
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCve
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.URI = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCve
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCve
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tags = append(m.Tags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCve(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCve
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CVE_DistroSpecific) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCve
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DistroSpecific: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DistroSpecific: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Severity", wireType)
			}
			m.Severity = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Severity |= VulnerabilitySeverity(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cvss", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.Cvss = float32(math.Float32frombits(v))
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScoreVersion", wireType)
			}
			m.ScoreVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScoreVersion |= CVE_ScoreVersion(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CvssV2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCve
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCve
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CvssV2 == nil {
				m.CvssV2 = &CVSSV2{}
			}
			if err := m.CvssV2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CvssV3", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCve
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCve
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CvssV3 == nil {
				m.CvssV3 = &CVSSV3{}
			}
			if err := m.CvssV3.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCve(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCve
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CVSSV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCve
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CVSSV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CVSSV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Vector", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCve
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCve
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Vector = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttackVector", wireType)
			}
			m.AttackVector = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AttackVector |= CVSSV2_AttackVector(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessComplexity", wireType)
			}
			m.AccessComplexity = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AccessComplexity |= CVSSV2_AccessComplexity(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Authentication", wireType)
			}
			m.Authentication = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Authentication |= CVSSV2_Authentication(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Confidentiality", wireType)
			}
			m.Confidentiality = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Confidentiality |= CVSSV2_Impact(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Integrity", wireType)
			}
			m.Integrity = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Integrity |= CVSSV2_Impact(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Availability", wireType)
			}
			m.Availability = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Availability |= CVSSV2_Impact(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExploitabilityScore", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.ExploitabilityScore = float32(math.Float32frombits(v))
		case 9:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field ImpactScore", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.ImpactScore = float32(math.Float32frombits(v))
		case 10:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field Score", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.Score = float32(math.Float32frombits(v))
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Severity", wireType)
			}
			m.Severity = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Severity |= CVSSV2_Severity(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCve(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCve
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CVSSV3) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCve
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CVSSV3: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CVSSV3: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Vector", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCve
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCve
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Vector = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExploitabilityScore", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.ExploitabilityScore = float32(math.Float32frombits(v))
		case 3:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field ImpactScore", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.ImpactScore = float32(math.Float32frombits(v))
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttackVector", wireType)
			}
			m.AttackVector = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AttackVector |= CVSSV3_AttackVector(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttackComplexity", wireType)
			}
			m.AttackComplexity = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AttackComplexity |= CVSSV3_Complexity(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrivilegesRequired", wireType)
			}
			m.PrivilegesRequired = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PrivilegesRequired |= CVSSV3_Privileges(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserInteraction", wireType)
			}
			m.UserInteraction = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UserInteraction |= CVSSV3_UserInteraction(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scope", wireType)
			}
			m.Scope = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Scope |= CVSSV3_Scope(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Confidentiality", wireType)
			}
			m.Confidentiality = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Confidentiality |= CVSSV3_Impact(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Integrity", wireType)
			}
			m.Integrity = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Integrity |= CVSSV3_Impact(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Availability", wireType)
			}
			m.Availability = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Availability |= CVSSV3_Impact(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field Score", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.Score = float32(math.Float32frombits(v))
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Severity", wireType)
			}
			m.Severity = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCve
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Severity |= CVSSV3_Severity(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCve(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCve
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCve(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCve
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCve
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCve
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthCve
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupCve
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthCve
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthCve        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCve          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupCve = fmt.Errorf("proto: unexpected end of group")
)
