// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/external_backup.proto

package storage

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ExternalBackup struct {
	Id            string    `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Name          string    `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Type          string    `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	Schedule      *Schedule `protobuf:"bytes,4,opt,name=schedule,proto3" json:"schedule,omitempty"`
	BackupsToKeep int32     `protobuf:"varint,5,opt,name=backups_to_keep,json=backupsToKeep,proto3" json:"backups_to_keep,omitempty"`
	// Types that are valid to be assigned to Config:
	//	*ExternalBackup_S3
	//	*ExternalBackup_Gcs
	Config isExternalBackup_Config `protobuf_oneof:"Config"`
	// Types that are valid to be assigned to IncludeCertificatesOpt:
	//	*ExternalBackup_IncludeCertificates
	IncludeCertificatesOpt isExternalBackup_IncludeCertificatesOpt `protobuf_oneof:"include_certificates_opt"`
	XXX_NoUnkeyedLiteral   struct{}                                `json:"-"`
	XXX_unrecognized       []byte                                  `json:"-"`
	XXX_sizecache          int32                                   `json:"-"`
}

func (m *ExternalBackup) Reset()         { *m = ExternalBackup{} }
func (m *ExternalBackup) String() string { return proto.CompactTextString(m) }
func (*ExternalBackup) ProtoMessage()    {}
func (*ExternalBackup) Descriptor() ([]byte, []int) {
	return fileDescriptor_38dc9102c7d6c41e, []int{0}
}
func (m *ExternalBackup) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExternalBackup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExternalBackup.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExternalBackup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalBackup.Merge(m, src)
}
func (m *ExternalBackup) XXX_Size() int {
	return m.Size()
}
func (m *ExternalBackup) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalBackup.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalBackup proto.InternalMessageInfo

type isExternalBackup_Config interface {
	isExternalBackup_Config()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isExternalBackup_Config
}
type isExternalBackup_IncludeCertificatesOpt interface {
	isExternalBackup_IncludeCertificatesOpt()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isExternalBackup_IncludeCertificatesOpt
}

type ExternalBackup_S3 struct {
	S3 *S3Config `protobuf:"bytes,6,opt,name=s3,proto3,oneof" json:"s3,omitempty"`
}
type ExternalBackup_Gcs struct {
	Gcs *GCSConfig `protobuf:"bytes,7,opt,name=gcs,proto3,oneof" json:"gcs,omitempty"`
}
type ExternalBackup_IncludeCertificates struct {
	IncludeCertificates bool `protobuf:"varint,8,opt,name=include_certificates,json=includeCertificates,proto3,oneof" json:"include_certificates,omitempty"`
}

func (*ExternalBackup_S3) isExternalBackup_Config() {}
func (m *ExternalBackup_S3) Clone() isExternalBackup_Config {
	if m == nil {
		return nil
	}
	cloned := new(ExternalBackup_S3)
	*cloned = *m

	cloned.S3 = m.S3.Clone()
	return cloned
}
func (*ExternalBackup_Gcs) isExternalBackup_Config() {}
func (m *ExternalBackup_Gcs) Clone() isExternalBackup_Config {
	if m == nil {
		return nil
	}
	cloned := new(ExternalBackup_Gcs)
	*cloned = *m

	cloned.Gcs = m.Gcs.Clone()
	return cloned
}
func (*ExternalBackup_IncludeCertificates) isExternalBackup_IncludeCertificatesOpt() {}
func (m *ExternalBackup_IncludeCertificates) Clone() isExternalBackup_IncludeCertificatesOpt {
	if m == nil {
		return nil
	}
	cloned := new(ExternalBackup_IncludeCertificates)
	*cloned = *m

	return cloned
}

func (m *ExternalBackup) GetConfig() isExternalBackup_Config {
	if m != nil {
		return m.Config
	}
	return nil
}
func (m *ExternalBackup) GetIncludeCertificatesOpt() isExternalBackup_IncludeCertificatesOpt {
	if m != nil {
		return m.IncludeCertificatesOpt
	}
	return nil
}

func (m *ExternalBackup) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ExternalBackup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ExternalBackup) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *ExternalBackup) GetSchedule() *Schedule {
	if m != nil {
		return m.Schedule
	}
	return nil
}

func (m *ExternalBackup) GetBackupsToKeep() int32 {
	if m != nil {
		return m.BackupsToKeep
	}
	return 0
}

func (m *ExternalBackup) GetS3() *S3Config {
	if x, ok := m.GetConfig().(*ExternalBackup_S3); ok {
		return x.S3
	}
	return nil
}

func (m *ExternalBackup) GetGcs() *GCSConfig {
	if x, ok := m.GetConfig().(*ExternalBackup_Gcs); ok {
		return x.Gcs
	}
	return nil
}

// Deprecated: Do not use.
func (m *ExternalBackup) GetIncludeCertificates() bool {
	if x, ok := m.GetIncludeCertificatesOpt().(*ExternalBackup_IncludeCertificates); ok {
		return x.IncludeCertificates
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ExternalBackup) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ExternalBackup_S3)(nil),
		(*ExternalBackup_Gcs)(nil),
		(*ExternalBackup_IncludeCertificates)(nil),
	}
}

func (m *ExternalBackup) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ExternalBackup) Clone() *ExternalBackup {
	if m == nil {
		return nil
	}
	cloned := new(ExternalBackup)
	*cloned = *m

	cloned.Schedule = m.Schedule.Clone()
	if m.Config != nil {
		cloned.Config = m.Config.Clone()
	}
	if m.IncludeCertificatesOpt != nil {
		cloned.IncludeCertificatesOpt = m.IncludeCertificatesOpt.Clone()
	}
	return cloned
}

type S3Config struct {
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	UseIam bool   `protobuf:"varint,2,opt,name=use_iam,json=useIam,proto3" json:"use_iam,omitempty" scrub:"dependent"`
	// The access key ID for the storage integration. The server will mask the value of this credential in responses and logs.
	AccessKeyId string `protobuf:"bytes,3,opt,name=access_key_id,json=accessKeyId,proto3" json:"access_key_id,omitempty" scrub:"always"`
	// The secret access key for the storage integration. The server will mask the value of this credential in responses and logs.
	SecretAccessKey      string   `protobuf:"bytes,4,opt,name=secret_access_key,json=secretAccessKey,proto3" json:"secret_access_key,omitempty" scrub:"always"`
	Region               string   `protobuf:"bytes,5,opt,name=region,proto3" json:"region,omitempty"`
	ObjectPrefix         string   `protobuf:"bytes,6,opt,name=object_prefix,json=objectPrefix,proto3" json:"object_prefix,omitempty"`
	Endpoint             string   `protobuf:"bytes,7,opt,name=endpoint,proto3" json:"endpoint,omitempty" scrub:"dependent" validate:"nolocalendpoint"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *S3Config) Reset()         { *m = S3Config{} }
func (m *S3Config) String() string { return proto.CompactTextString(m) }
func (*S3Config) ProtoMessage()    {}
func (*S3Config) Descriptor() ([]byte, []int) {
	return fileDescriptor_38dc9102c7d6c41e, []int{1}
}
func (m *S3Config) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *S3Config) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_S3Config.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *S3Config) XXX_Merge(src proto.Message) {
	xxx_messageInfo_S3Config.Merge(m, src)
}
func (m *S3Config) XXX_Size() int {
	return m.Size()
}
func (m *S3Config) XXX_DiscardUnknown() {
	xxx_messageInfo_S3Config.DiscardUnknown(m)
}

var xxx_messageInfo_S3Config proto.InternalMessageInfo

func (m *S3Config) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *S3Config) GetUseIam() bool {
	if m != nil {
		return m.UseIam
	}
	return false
}

func (m *S3Config) GetAccessKeyId() string {
	if m != nil {
		return m.AccessKeyId
	}
	return ""
}

func (m *S3Config) GetSecretAccessKey() string {
	if m != nil {
		return m.SecretAccessKey
	}
	return ""
}

func (m *S3Config) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *S3Config) GetObjectPrefix() string {
	if m != nil {
		return m.ObjectPrefix
	}
	return ""
}

func (m *S3Config) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *S3Config) MessageClone() proto.Message {
	return m.Clone()
}
func (m *S3Config) Clone() *S3Config {
	if m == nil {
		return nil
	}
	cloned := new(S3Config)
	*cloned = *m

	return cloned
}

type GCSConfig struct {
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// The service account for the storage integration. The server will mask the value of this credential in responses and logs.
	ServiceAccount       string   `protobuf:"bytes,2,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty" scrub:"always"`
	ObjectPrefix         string   `protobuf:"bytes,3,opt,name=object_prefix,json=objectPrefix,proto3" json:"object_prefix,omitempty"`
	UseWorkloadId        bool     `protobuf:"varint,4,opt,name=use_workload_id,json=useWorkloadId,proto3" json:"use_workload_id,omitempty" scrub:"dependent"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GCSConfig) Reset()         { *m = GCSConfig{} }
func (m *GCSConfig) String() string { return proto.CompactTextString(m) }
func (*GCSConfig) ProtoMessage()    {}
func (*GCSConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_38dc9102c7d6c41e, []int{2}
}
func (m *GCSConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GCSConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GCSConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GCSConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GCSConfig.Merge(m, src)
}
func (m *GCSConfig) XXX_Size() int {
	return m.Size()
}
func (m *GCSConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_GCSConfig.DiscardUnknown(m)
}

var xxx_messageInfo_GCSConfig proto.InternalMessageInfo

func (m *GCSConfig) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *GCSConfig) GetServiceAccount() string {
	if m != nil {
		return m.ServiceAccount
	}
	return ""
}

func (m *GCSConfig) GetObjectPrefix() string {
	if m != nil {
		return m.ObjectPrefix
	}
	return ""
}

func (m *GCSConfig) GetUseWorkloadId() bool {
	if m != nil {
		return m.UseWorkloadId
	}
	return false
}

func (m *GCSConfig) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GCSConfig) Clone() *GCSConfig {
	if m == nil {
		return nil
	}
	cloned := new(GCSConfig)
	*cloned = *m

	return cloned
}

func init() {
	proto.RegisterType((*ExternalBackup)(nil), "storage.ExternalBackup")
	proto.RegisterType((*S3Config)(nil), "storage.S3Config")
	proto.RegisterType((*GCSConfig)(nil), "storage.GCSConfig")
}

func init() { proto.RegisterFile("storage/external_backup.proto", fileDescriptor_38dc9102c7d6c41e) }

var fileDescriptor_38dc9102c7d6c41e = []byte{
	// 586 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x93, 0x41, 0x6b, 0xd4, 0x40,
	0x14, 0xc7, 0x9b, 0xb4, 0xdd, 0x66, 0xa7, 0xee, 0x2e, 0x1d, 0x6b, 0x89, 0x05, 0xb7, 0x4b, 0x0a,
	0x65, 0x0f, 0xba, 0x15, 0x57, 0x14, 0x2a, 0x0a, 0x4d, 0x11, 0x5b, 0xea, 0x41, 0x52, 0x41, 0xf0,
	0x12, 0x66, 0x67, 0x5e, 0xd7, 0x31, 0x69, 0x26, 0x64, 0x26, 0x6d, 0xf7, 0x9b, 0xf8, 0x81, 0x3c,
	0x08, 0x5e, 0xbc, 0x78, 0x2d, 0x52, 0xbf, 0xc1, 0x7e, 0x02, 0xc9, 0xcc, 0x64, 0x15, 0xbb, 0x7a,
	0x7b, 0xf9, 0xe7, 0xf7, 0xfe, 0x99, 0xf7, 0xfe, 0x19, 0x74, 0x4f, 0x2a, 0x51, 0x90, 0x31, 0xec,
	0xc2, 0xa5, 0x82, 0x22, 0x23, 0x69, 0x3c, 0x22, 0x34, 0x29, 0xf3, 0x41, 0x5e, 0x08, 0x25, 0xf0,
	0x8a, 0x7d, 0xbd, 0xb9, 0x51, 0x73, 0x92, 0x7e, 0x00, 0x56, 0xa6, 0x60, 0x80, 0xcd, 0xf5, 0xb1,
	0x18, 0x0b, 0x5d, 0xee, 0x56, 0x95, 0x51, 0x83, 0xaf, 0x2e, 0x6a, 0xbf, 0xb4, 0x86, 0xa1, 0xf6,
	0xc3, 0x6d, 0xe4, 0x72, 0xe6, 0x3b, 0x3d, 0xa7, 0xdf, 0x8c, 0x5c, 0xce, 0x30, 0x46, 0x4b, 0x19,
	0x39, 0x03, 0xdf, 0xd5, 0x8a, 0xae, 0x2b, 0x4d, 0x4d, 0x72, 0xf0, 0x17, 0x8d, 0x56, 0xd5, 0xf8,
	0x01, 0xf2, 0xea, 0x4f, 0xfa, 0x4b, 0x3d, 0xa7, 0xbf, 0xfa, 0x68, 0x6d, 0x60, 0xcf, 0x32, 0x38,
	0xb1, 0x2f, 0xa2, 0x19, 0x82, 0x77, 0x50, 0xc7, 0x0c, 0x20, 0x63, 0x25, 0xe2, 0x04, 0x20, 0xf7,
	0x97, 0x7b, 0x4e, 0x7f, 0x39, 0x6a, 0x59, 0xf9, 0xad, 0x38, 0x06, 0xc8, 0xf1, 0x36, 0x72, 0xe5,
	0xd0, 0x6f, 0xfc, 0x6d, 0x38, 0x3c, 0x10, 0xd9, 0x29, 0x1f, 0x1f, 0x2e, 0x44, 0xae, 0x1c, 0xe2,
	0x1d, 0xb4, 0x38, 0xa6, 0xd2, 0x5f, 0xd1, 0x14, 0x9e, 0x51, 0xaf, 0x0e, 0x4e, 0x66, 0x58, 0x05,
	0xe0, 0xa7, 0x68, 0x9d, 0x67, 0x34, 0x2d, 0x19, 0xc4, 0x14, 0x0a, 0xc5, 0x4f, 0x39, 0x25, 0x0a,
	0xa4, 0xef, 0xf5, 0x9c, 0xbe, 0x17, 0xba, 0xbe, 0x73, 0xe8, 0x44, 0xb7, 0x2d, 0x71, 0xf0, 0x07,
	0x10, 0x7a, 0xa8, 0x61, 0x9c, 0xc2, 0x4d, 0xe4, 0xcf, 0xb3, 0x88, 0x45, 0xae, 0x82, 0xef, 0x2e,
	0xf2, 0xea, 0x93, 0xe1, 0x0d, 0xd4, 0x18, 0x95, 0x34, 0x01, 0x65, 0x77, 0x69, 0x9f, 0xf0, 0x00,
	0xad, 0x94, 0x12, 0x62, 0x4e, 0xce, 0xf4, 0x4a, 0xbd, 0xf0, 0xce, 0xf4, 0x6a, 0x6b, 0x4d, 0xd2,
	0xa2, 0x1c, 0xed, 0x05, 0x0c, 0x72, 0xc8, 0x18, 0x64, 0x2a, 0x88, 0x1a, 0xa5, 0x84, 0x23, 0x72,
	0x86, 0x9f, 0xa0, 0x16, 0xa1, 0x14, 0xa4, 0x8c, 0x13, 0x98, 0xc4, 0x9c, 0x99, 0xa5, 0x87, 0x78,
	0x7a, 0xb5, 0xd5, 0xb6, 0x5d, 0x24, 0xbd, 0x20, 0x13, 0x19, 0x44, 0xab, 0x06, 0x3c, 0x86, 0xc9,
	0x11, 0xc3, 0x2f, 0xd0, 0x9a, 0x04, 0x5a, 0x80, 0x8a, 0x7f, 0xb7, 0xeb, 0x60, 0xe6, 0xf7, 0x76,
	0x0c, 0xbc, 0x5f, 0x3b, 0x54, 0xe7, 0x2f, 0x60, 0xcc, 0x45, 0xa6, 0x73, 0x69, 0x46, 0xf6, 0x09,
	0x6f, 0xa3, 0x96, 0x18, 0x7d, 0x04, 0xaa, 0xe2, 0xbc, 0x80, 0x53, 0x7e, 0xa9, 0xb3, 0x69, 0x46,
	0xb7, 0x8c, 0xf8, 0x46, 0x6b, 0xf8, 0x35, 0xf2, 0x20, 0x63, 0xb9, 0xe0, 0x99, 0xd2, 0xa9, 0x34,
	0xc3, 0x87, 0xd3, 0xab, 0xad, 0xfb, 0x37, 0xa6, 0xec, 0x9d, 0x93, 0x94, 0x33, 0xa2, 0x60, 0x2f,
	0xc8, 0x44, 0x2a, 0x28, 0x49, 0xeb, 0xb6, 0x20, 0x9a, 0x39, 0x04, 0x9f, 0x1d, 0xd4, 0x9c, 0x65,
	0xf9, 0xcf, 0xc5, 0x3e, 0x43, 0x1d, 0x09, 0xc5, 0x39, 0xa7, 0x50, 0x4d, 0x2c, 0xca, 0x4c, 0x99,
	0x7f, 0x76, 0xee, 0xb8, 0x6d, 0x8b, 0xee, 0x1b, 0xf2, 0xe6, 0x54, 0x8b, 0x73, 0xa6, 0x7a, 0x8e,
	0x3a, 0x55, 0x74, 0x17, 0xa2, 0x48, 0x52, 0x41, 0x58, 0x15, 0xc6, 0xd2, 0xff, 0x22, 0x6c, 0x95,
	0x12, 0xde, 0x59, 0xf8, 0x88, 0x85, 0x8f, 0xbf, 0x5c, 0x77, 0x9d, 0x6f, 0xd7, 0x5d, 0xe7, 0xc7,
	0x75, 0xd7, 0xf9, 0xf4, 0xb3, 0xbb, 0x80, 0xee, 0x72, 0x31, 0x90, 0x8a, 0xd0, 0xa4, 0x10, 0x97,
	0xe6, 0x46, 0xd6, 0xff, 0xee, 0xfb, 0xfa, 0x42, 0x8f, 0x1a, 0x5a, 0x1f, 0xfe, 0x0a, 0x00, 0x00,
	0xff, 0xff, 0xd1, 0x70, 0x69, 0x42, 0x01, 0x04, 0x00, 0x00,
}

func (m *ExternalBackup) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExternalBackup) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExternalBackup) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IncludeCertificatesOpt != nil {
		{
			size := m.IncludeCertificatesOpt.Size()
			i -= size
			if _, err := m.IncludeCertificatesOpt.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Config != nil {
		{
			size := m.Config.Size()
			i -= size
			if _, err := m.Config.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.BackupsToKeep != 0 {
		i = encodeVarintExternalBackup(dAtA, i, uint64(m.BackupsToKeep))
		i--
		dAtA[i] = 0x28
	}
	if m.Schedule != nil {
		{
			size, err := m.Schedule.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExternalBackup(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintExternalBackup(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintExternalBackup(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintExternalBackup(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ExternalBackup_S3) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExternalBackup_S3) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.S3 != nil {
		{
			size, err := m.S3.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExternalBackup(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	return len(dAtA) - i, nil
}
func (m *ExternalBackup_Gcs) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExternalBackup_Gcs) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Gcs != nil {
		{
			size, err := m.Gcs.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExternalBackup(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *ExternalBackup_IncludeCertificates) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExternalBackup_IncludeCertificates) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i--
	if m.IncludeCertificates {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x40
	return len(dAtA) - i, nil
}
func (m *S3Config) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *S3Config) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *S3Config) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Endpoint) > 0 {
		i -= len(m.Endpoint)
		copy(dAtA[i:], m.Endpoint)
		i = encodeVarintExternalBackup(dAtA, i, uint64(len(m.Endpoint)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.ObjectPrefix) > 0 {
		i -= len(m.ObjectPrefix)
		copy(dAtA[i:], m.ObjectPrefix)
		i = encodeVarintExternalBackup(dAtA, i, uint64(len(m.ObjectPrefix)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Region) > 0 {
		i -= len(m.Region)
		copy(dAtA[i:], m.Region)
		i = encodeVarintExternalBackup(dAtA, i, uint64(len(m.Region)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.SecretAccessKey) > 0 {
		i -= len(m.SecretAccessKey)
		copy(dAtA[i:], m.SecretAccessKey)
		i = encodeVarintExternalBackup(dAtA, i, uint64(len(m.SecretAccessKey)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.AccessKeyId) > 0 {
		i -= len(m.AccessKeyId)
		copy(dAtA[i:], m.AccessKeyId)
		i = encodeVarintExternalBackup(dAtA, i, uint64(len(m.AccessKeyId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.UseIam {
		i--
		if m.UseIam {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Bucket) > 0 {
		i -= len(m.Bucket)
		copy(dAtA[i:], m.Bucket)
		i = encodeVarintExternalBackup(dAtA, i, uint64(len(m.Bucket)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GCSConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCSConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GCSConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.UseWorkloadId {
		i--
		if m.UseWorkloadId {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.ObjectPrefix) > 0 {
		i -= len(m.ObjectPrefix)
		copy(dAtA[i:], m.ObjectPrefix)
		i = encodeVarintExternalBackup(dAtA, i, uint64(len(m.ObjectPrefix)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ServiceAccount) > 0 {
		i -= len(m.ServiceAccount)
		copy(dAtA[i:], m.ServiceAccount)
		i = encodeVarintExternalBackup(dAtA, i, uint64(len(m.ServiceAccount)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Bucket) > 0 {
		i -= len(m.Bucket)
		copy(dAtA[i:], m.Bucket)
		i = encodeVarintExternalBackup(dAtA, i, uint64(len(m.Bucket)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintExternalBackup(dAtA []byte, offset int, v uint64) int {
	offset -= sovExternalBackup(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ExternalBackup) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovExternalBackup(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovExternalBackup(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovExternalBackup(uint64(l))
	}
	if m.Schedule != nil {
		l = m.Schedule.Size()
		n += 1 + l + sovExternalBackup(uint64(l))
	}
	if m.BackupsToKeep != 0 {
		n += 1 + sovExternalBackup(uint64(m.BackupsToKeep))
	}
	if m.Config != nil {
		n += m.Config.Size()
	}
	if m.IncludeCertificatesOpt != nil {
		n += m.IncludeCertificatesOpt.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExternalBackup_S3) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.S3 != nil {
		l = m.S3.Size()
		n += 1 + l + sovExternalBackup(uint64(l))
	}
	return n
}
func (m *ExternalBackup_Gcs) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Gcs != nil {
		l = m.Gcs.Size()
		n += 1 + l + sovExternalBackup(uint64(l))
	}
	return n
}
func (m *ExternalBackup_IncludeCertificates) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 2
	return n
}
func (m *S3Config) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Bucket)
	if l > 0 {
		n += 1 + l + sovExternalBackup(uint64(l))
	}
	if m.UseIam {
		n += 2
	}
	l = len(m.AccessKeyId)
	if l > 0 {
		n += 1 + l + sovExternalBackup(uint64(l))
	}
	l = len(m.SecretAccessKey)
	if l > 0 {
		n += 1 + l + sovExternalBackup(uint64(l))
	}
	l = len(m.Region)
	if l > 0 {
		n += 1 + l + sovExternalBackup(uint64(l))
	}
	l = len(m.ObjectPrefix)
	if l > 0 {
		n += 1 + l + sovExternalBackup(uint64(l))
	}
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovExternalBackup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GCSConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Bucket)
	if l > 0 {
		n += 1 + l + sovExternalBackup(uint64(l))
	}
	l = len(m.ServiceAccount)
	if l > 0 {
		n += 1 + l + sovExternalBackup(uint64(l))
	}
	l = len(m.ObjectPrefix)
	if l > 0 {
		n += 1 + l + sovExternalBackup(uint64(l))
	}
	if m.UseWorkloadId {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovExternalBackup(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozExternalBackup(x uint64) (n int) {
	return sovExternalBackup(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ExternalBackup) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExternalBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExternalBackup: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExternalBackup: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExternalBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExternalBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExternalBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExternalBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExternalBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExternalBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schedule", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExternalBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExternalBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Schedule == nil {
				m.Schedule = &Schedule{}
			}
			if err := m.Schedule.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BackupsToKeep", wireType)
			}
			m.BackupsToKeep = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BackupsToKeep |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field S3", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExternalBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExternalBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &S3Config{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Config = &ExternalBackup_S3{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gcs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExternalBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExternalBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GCSConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Config = &ExternalBackup_Gcs{v}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludeCertificates", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.IncludeCertificatesOpt = &ExternalBackup_IncludeCertificates{b}
		default:
			iNdEx = preIndex
			skippy, err := skipExternalBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthExternalBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *S3Config) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExternalBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: S3Config: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: S3Config: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bucket", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExternalBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExternalBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bucket = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseIam", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UseIam = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessKeyId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExternalBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExternalBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessKeyId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretAccessKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExternalBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExternalBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SecretAccessKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Region", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExternalBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExternalBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Region = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectPrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExternalBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExternalBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ObjectPrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExternalBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExternalBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExternalBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthExternalBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GCSConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExternalBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCSConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCSConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bucket", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExternalBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExternalBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bucket = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceAccount", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExternalBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExternalBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceAccount = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectPrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExternalBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExternalBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ObjectPrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseWorkloadId", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UseWorkloadId = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipExternalBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthExternalBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipExternalBackup(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowExternalBackup
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowExternalBackup
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthExternalBackup
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupExternalBackup
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthExternalBackup
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthExternalBackup        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowExternalBackup          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupExternalBackup = fmt.Errorf("proto: unexpected end of group")
)
