// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/http_endpoint.proto

package storage

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type HTTPEndpointConfig struct {
	Endpoint      string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty" scrub:"dependent"`
	SkipTlsVerify bool   `protobuf:"varint,2,opt,name=skip_tls_verify,json=skipTlsVerify,proto3" json:"skip_tls_verify,omitempty"`
	CaCert        string `protobuf:"bytes,3,opt,name=ca_cert,json=caCert,proto3" json:"ca_cert,omitempty"`
	Username      string `protobuf:"bytes,4,opt,name=username,proto3" json:"username,omitempty" scrub:"dependent"`
	// The password for the integration. The server will mask the value of this credential in responses and logs.
	Password string          `protobuf:"bytes,5,opt,name=password,proto3" json:"password,omitempty" scrub:"always"`
	Headers  []*KeyValuePair `protobuf:"bytes,6,rep,name=headers,proto3" json:"headers,omitempty"`
	// The client certificate in PEM format for the integration.
	ClientCertPem string `protobuf:"bytes,7,opt,name=client_cert_pem,json=clientCertPem,proto3" json:"client_cert_pem,omitempty"`
	// The client key in PEM format for the integration. The server will mask the value of this credential in responses and logs.
	ClientKeyPem         string   `protobuf:"bytes,8,opt,name=client_key_pem,json=clientKeyPem,proto3" json:"client_key_pem,omitempty" scrub:"always"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HTTPEndpointConfig) Reset()         { *m = HTTPEndpointConfig{} }
func (m *HTTPEndpointConfig) String() string { return proto.CompactTextString(m) }
func (*HTTPEndpointConfig) ProtoMessage()    {}
func (*HTTPEndpointConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_511533d120983170, []int{0}
}
func (m *HTTPEndpointConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPEndpointConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTPEndpointConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTPEndpointConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPEndpointConfig.Merge(m, src)
}
func (m *HTTPEndpointConfig) XXX_Size() int {
	return m.Size()
}
func (m *HTTPEndpointConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPEndpointConfig.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPEndpointConfig proto.InternalMessageInfo

func (m *HTTPEndpointConfig) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *HTTPEndpointConfig) GetSkipTlsVerify() bool {
	if m != nil {
		return m.SkipTlsVerify
	}
	return false
}

func (m *HTTPEndpointConfig) GetCaCert() string {
	if m != nil {
		return m.CaCert
	}
	return ""
}

func (m *HTTPEndpointConfig) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *HTTPEndpointConfig) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func (m *HTTPEndpointConfig) GetHeaders() []*KeyValuePair {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *HTTPEndpointConfig) GetClientCertPem() string {
	if m != nil {
		return m.ClientCertPem
	}
	return ""
}

func (m *HTTPEndpointConfig) GetClientKeyPem() string {
	if m != nil {
		return m.ClientKeyPem
	}
	return ""
}

func (m *HTTPEndpointConfig) MessageClone() proto.Message {
	return m.Clone()
}
func (m *HTTPEndpointConfig) Clone() *HTTPEndpointConfig {
	if m == nil {
		return nil
	}
	cloned := new(HTTPEndpointConfig)
	*cloned = *m

	if m.Headers != nil {
		cloned.Headers = make([]*KeyValuePair, len(m.Headers))
		for idx, v := range m.Headers {
			cloned.Headers[idx] = v.Clone()
		}
	}
	return cloned
}

func init() {
	proto.RegisterType((*HTTPEndpointConfig)(nil), "storage.HTTPEndpointConfig")
}

func init() { proto.RegisterFile("storage/http_endpoint.proto", fileDescriptor_511533d120983170) }

var fileDescriptor_511533d120983170 = []byte{
	// 369 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x91, 0xcf, 0x6a, 0xea, 0x40,
	0x14, 0xc6, 0x8d, 0xde, 0x6b, 0x72, 0xe7, 0x5e, 0xbd, 0xdc, 0x41, 0xb9, 0xa9, 0x85, 0x28, 0x59,
	0x14, 0x57, 0x91, 0xfe, 0x59, 0x94, 0x2e, 0x95, 0x42, 0xc1, 0x4d, 0x08, 0x22, 0xa5, 0x9b, 0x30,
	0x26, 0xc7, 0x18, 0x4c, 0x66, 0xc2, 0xcc, 0x58, 0x9b, 0x37, 0xe9, 0x23, 0x75, 0xd9, 0x27, 0x90,
	0x62, 0xdf, 0xc0, 0x07, 0x28, 0x25, 0xff, 0xdc, 0xb5, 0xbb, 0xf0, 0x9d, 0xdf, 0xf7, 0x9d, 0x2f,
	0x73, 0xd0, 0xa9, 0x90, 0x8c, 0x93, 0x00, 0x46, 0x2b, 0x29, 0x13, 0x17, 0xa8, 0x9f, 0xb0, 0x90,
	0x4a, 0x2b, 0xe1, 0x4c, 0x32, 0xac, 0x96, 0xc3, 0x5e, 0x27, 0x60, 0x01, 0xcb, 0xb5, 0x51, 0xf6,
	0x55, 0x8c, 0x7b, 0x9d, 0xca, 0xeb, 0xb1, 0x38, 0x66, 0xb4, 0x50, 0xcd, 0x8f, 0x3a, 0xc2, 0x77,
	0xb3, 0x99, 0x7d, 0x5b, 0x66, 0x4d, 0x18, 0x5d, 0x86, 0x01, 0x3e, 0x47, 0x5a, 0x95, 0xae, 0x2b,
	0x03, 0x65, 0xf8, 0x6b, 0xdc, 0x3d, 0xec, 0xfa, 0xff, 0x84, 0xc7, 0x37, 0x8b, 0x1b, 0xd3, 0x87,
	0x04, 0xa8, 0x0f, 0x54, 0x9a, 0xce, 0x11, 0xc3, 0x67, 0xe8, 0xaf, 0x58, 0x87, 0x89, 0x2b, 0x23,
	0xe1, 0x3e, 0x02, 0x0f, 0x97, 0xa9, 0x5e, 0x1f, 0x28, 0x43, 0xcd, 0x69, 0x65, 0xf2, 0x2c, 0x12,
	0xf3, 0x5c, 0xc4, 0xff, 0x91, 0xea, 0x11, 0xd7, 0x03, 0x2e, 0xf5, 0x46, 0x96, 0xec, 0x34, 0x3d,
	0x32, 0x01, 0x2e, 0xb3, 0x9d, 0x1b, 0x01, 0x9c, 0x92, 0x18, 0xf4, 0x1f, 0xdf, 0xee, 0xac, 0x30,
	0x6c, 0x21, 0x2d, 0x21, 0x42, 0x6c, 0x19, 0xf7, 0xf5, 0x9f, 0xb9, 0x05, 0x1f, 0x76, 0xfd, 0x76,
	0x69, 0x21, 0xd1, 0x96, 0xa4, 0xc2, 0x74, 0x8e, 0x0c, 0x1e, 0x21, 0x75, 0x05, 0xc4, 0x07, 0x2e,
	0xf4, 0xe6, 0xa0, 0x31, 0xfc, 0x7d, 0xd1, 0xb5, 0xca, 0x57, 0xb1, 0xa6, 0x90, 0xce, 0x49, 0xb4,
	0x01, 0x9b, 0x84, 0xdc, 0xa9, 0xa8, 0xec, 0xa7, 0xbc, 0x28, 0x04, 0x2a, 0xf3, 0xc2, 0x6e, 0x02,
	0xb1, 0xae, 0xe6, 0xa5, 0x5b, 0x85, 0x9c, 0x15, 0xb7, 0x21, 0xc6, 0xd7, 0xa8, 0x5d, 0x72, 0x6b,
	0x48, 0x73, 0x4c, 0xfb, 0xb2, 0xce, 0x9f, 0x82, 0x9c, 0x42, 0x6a, 0x43, 0x3c, 0xbe, 0x7a, 0xd9,
	0x1b, 0xca, 0xeb, 0xde, 0x50, 0xde, 0xf6, 0x86, 0xf2, 0xfc, 0x6e, 0xd4, 0xd0, 0x49, 0xc8, 0x2c,
	0x21, 0x89, 0xb7, 0xe6, 0xec, 0xa9, 0xb8, 0x52, 0x55, 0xf2, 0xa1, 0x3a, 0xf1, 0x7d, 0x6d, 0xd1,
	0xcc, 0x27, 0x97, 0x9f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x4c, 0xfb, 0x44, 0xaa, 0x13, 0x02, 0x00,
	0x00,
}

func (m *HTTPEndpointConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPEndpointConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTPEndpointConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ClientKeyPem) > 0 {
		i -= len(m.ClientKeyPem)
		copy(dAtA[i:], m.ClientKeyPem)
		i = encodeVarintHttpEndpoint(dAtA, i, uint64(len(m.ClientKeyPem)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.ClientCertPem) > 0 {
		i -= len(m.ClientCertPem)
		copy(dAtA[i:], m.ClientCertPem)
		i = encodeVarintHttpEndpoint(dAtA, i, uint64(len(m.ClientCertPem)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Headers) > 0 {
		for iNdEx := len(m.Headers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Headers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintHttpEndpoint(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Password) > 0 {
		i -= len(m.Password)
		copy(dAtA[i:], m.Password)
		i = encodeVarintHttpEndpoint(dAtA, i, uint64(len(m.Password)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Username) > 0 {
		i -= len(m.Username)
		copy(dAtA[i:], m.Username)
		i = encodeVarintHttpEndpoint(dAtA, i, uint64(len(m.Username)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.CaCert) > 0 {
		i -= len(m.CaCert)
		copy(dAtA[i:], m.CaCert)
		i = encodeVarintHttpEndpoint(dAtA, i, uint64(len(m.CaCert)))
		i--
		dAtA[i] = 0x1a
	}
	if m.SkipTlsVerify {
		i--
		if m.SkipTlsVerify {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Endpoint) > 0 {
		i -= len(m.Endpoint)
		copy(dAtA[i:], m.Endpoint)
		i = encodeVarintHttpEndpoint(dAtA, i, uint64(len(m.Endpoint)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintHttpEndpoint(dAtA []byte, offset int, v uint64) int {
	offset -= sovHttpEndpoint(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *HTTPEndpointConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovHttpEndpoint(uint64(l))
	}
	if m.SkipTlsVerify {
		n += 2
	}
	l = len(m.CaCert)
	if l > 0 {
		n += 1 + l + sovHttpEndpoint(uint64(l))
	}
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovHttpEndpoint(uint64(l))
	}
	l = len(m.Password)
	if l > 0 {
		n += 1 + l + sovHttpEndpoint(uint64(l))
	}
	if len(m.Headers) > 0 {
		for _, e := range m.Headers {
			l = e.Size()
			n += 1 + l + sovHttpEndpoint(uint64(l))
		}
	}
	l = len(m.ClientCertPem)
	if l > 0 {
		n += 1 + l + sovHttpEndpoint(uint64(l))
	}
	l = len(m.ClientKeyPem)
	if l > 0 {
		n += 1 + l + sovHttpEndpoint(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovHttpEndpoint(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozHttpEndpoint(x uint64) (n int) {
	return sovHttpEndpoint(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *HTTPEndpointConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHttpEndpoint
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPEndpointConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPEndpointConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpEndpoint
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttpEndpoint
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttpEndpoint
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SkipTlsVerify", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpEndpoint
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SkipTlsVerify = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CaCert", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpEndpoint
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttpEndpoint
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttpEndpoint
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CaCert = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpEndpoint
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttpEndpoint
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttpEndpoint
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Password", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpEndpoint
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttpEndpoint
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttpEndpoint
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Password = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpEndpoint
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpEndpoint
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpEndpoint
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Headers = append(m.Headers, &KeyValuePair{})
			if err := m.Headers[len(m.Headers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientCertPem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpEndpoint
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttpEndpoint
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttpEndpoint
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientCertPem = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientKeyPem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpEndpoint
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttpEndpoint
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttpEndpoint
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientKeyPem = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHttpEndpoint(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthHttpEndpoint
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipHttpEndpoint(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowHttpEndpoint
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowHttpEndpoint
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowHttpEndpoint
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthHttpEndpoint
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupHttpEndpoint
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthHttpEndpoint
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthHttpEndpoint        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowHttpEndpoint          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupHttpEndpoint = fmt.Errorf("proto: unexpected end of group")
)
