// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/image.proto

package storage

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type SourceType int32

const (
	SourceType_OS                SourceType = 0
	SourceType_PYTHON            SourceType = 1
	SourceType_JAVA              SourceType = 2
	SourceType_RUBY              SourceType = 3
	SourceType_NODEJS            SourceType = 4
	SourceType_DOTNETCORERUNTIME SourceType = 5
	SourceType_INFRASTRUCTURE    SourceType = 6
)

var SourceType_name = map[int32]string{
	0: "OS",
	1: "PYTHON",
	2: "JAVA",
	3: "RUBY",
	4: "NODEJS",
	5: "DOTNETCORERUNTIME",
	6: "INFRASTRUCTURE",
}

var SourceType_value = map[string]int32{
	"OS":                0,
	"PYTHON":            1,
	"JAVA":              2,
	"RUBY":              3,
	"NODEJS":            4,
	"DOTNETCORERUNTIME": 5,
	"INFRASTRUCTURE":    6,
}

func (x SourceType) String() string {
	return proto.EnumName(SourceType_name, int32(x))
}

func (SourceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{0}
}

type Image_Note int32

const (
	Image_MISSING_METADATA  Image_Note = 0
	Image_MISSING_SCAN_DATA Image_Note = 1
)

var Image_Note_name = map[int32]string{
	0: "MISSING_METADATA",
	1: "MISSING_SCAN_DATA",
}

var Image_Note_value = map[string]int32{
	"MISSING_METADATA":  0,
	"MISSING_SCAN_DATA": 1,
}

func (x Image_Note) String() string {
	return proto.EnumName(Image_Note_name, int32(x))
}

func (Image_Note) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{0, 0}
}

type ImageScan_Note int32

const (
	ImageScan_UNSET                           ImageScan_Note = 0
	ImageScan_OS_UNAVAILABLE                  ImageScan_Note = 1
	ImageScan_PARTIAL_SCAN_DATA               ImageScan_Note = 2
	ImageScan_OS_CVES_UNAVAILABLE             ImageScan_Note = 3
	ImageScan_OS_CVES_STALE                   ImageScan_Note = 4
	ImageScan_LANGUAGE_CVES_UNAVAILABLE       ImageScan_Note = 5
	ImageScan_CERTIFIED_RHEL_SCAN_UNAVAILABLE ImageScan_Note = 6
)

var ImageScan_Note_name = map[int32]string{
	0: "UNSET",
	1: "OS_UNAVAILABLE",
	2: "PARTIAL_SCAN_DATA",
	3: "OS_CVES_UNAVAILABLE",
	4: "OS_CVES_STALE",
	5: "LANGUAGE_CVES_UNAVAILABLE",
	6: "CERTIFIED_RHEL_SCAN_UNAVAILABLE",
}

var ImageScan_Note_value = map[string]int32{
	"UNSET":                           0,
	"OS_UNAVAILABLE":                  1,
	"PARTIAL_SCAN_DATA":               2,
	"OS_CVES_UNAVAILABLE":             3,
	"OS_CVES_STALE":                   4,
	"LANGUAGE_CVES_UNAVAILABLE":       5,
	"CERTIFIED_RHEL_SCAN_UNAVAILABLE": 6,
}

func (x ImageScan_Note) String() string {
	return proto.EnumName(ImageScan_Note_name, int32(x))
}

func (ImageScan_Note) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{2, 0}
}

// Status represents the status of the result.
type ImageSignatureVerificationResult_Status int32

const (
	ImageSignatureVerificationResult_UNSET ImageSignatureVerificationResult_Status = 0
	// VERIFIED is set when the signature's verification was successful.
	ImageSignatureVerificationResult_VERIFIED ImageSignatureVerificationResult_Status = 1
	// FAILED_VERIFICATION is set when the signature's verification failed.
	ImageSignatureVerificationResult_FAILED_VERIFICATION ImageSignatureVerificationResult_Status = 2
	// INVALID_SIGNATURE_ALGO is set when the signature's algorithm is invalid and unsupported.
	ImageSignatureVerificationResult_INVALID_SIGNATURE_ALGO ImageSignatureVerificationResult_Status = 3
	// CORRUPTED_SIGNATURE is set when the raw signature is corrupted, i.e. wrong base64 encoding.
	ImageSignatureVerificationResult_CORRUPTED_SIGNATURE ImageSignatureVerificationResult_Status = 4
	// GENERIC_ERROR is set when an error occurred during verification that cannot be associated with a specific
	// status.
	ImageSignatureVerificationResult_GENERIC_ERROR ImageSignatureVerificationResult_Status = 5
)

var ImageSignatureVerificationResult_Status_name = map[int32]string{
	0: "UNSET",
	1: "VERIFIED",
	2: "FAILED_VERIFICATION",
	3: "INVALID_SIGNATURE_ALGO",
	4: "CORRUPTED_SIGNATURE",
	5: "GENERIC_ERROR",
}

var ImageSignatureVerificationResult_Status_value = map[string]int32{
	"UNSET":                  0,
	"VERIFIED":               1,
	"FAILED_VERIFICATION":    2,
	"INVALID_SIGNATURE_ALGO": 3,
	"CORRUPTED_SIGNATURE":    4,
	"GENERIC_ERROR":          5,
}

func (x ImageSignatureVerificationResult_Status) String() string {
	return proto.EnumName(ImageSignatureVerificationResult_Status_name, int32(x))
}

func (ImageSignatureVerificationResult_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{4, 0}
}

// Next Tag: 18
type Image struct {
	Id                        string                          `protobuf:"bytes,4,opt,name=id,proto3" json:"id,omitempty" search:"Image Sha,store,hidden"`
	Name                      *ImageName                      `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Metadata                  *ImageMetadata                  `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Scan                      *ImageScan                      `protobuf:"bytes,3,opt,name=scan,proto3" json:"scan,omitempty" policy:"Image Scan"`
	SignatureVerificationData *ImageSignatureVerificationData `protobuf:"bytes,15,opt,name=signature_verification_data,json=signatureVerificationData,proto3" json:"signature_verification_data,omitempty"`
	Signature                 *ImageSignature                 `protobuf:"bytes,16,opt,name=signature,proto3" json:"signature,omitempty"`
	// Types that are valid to be assigned to SetComponents:
	//	*Image_Components
	SetComponents isImage_SetComponents `protobuf_oneof:"set_components"`
	// Types that are valid to be assigned to SetCves:
	//	*Image_Cves
	SetCves isImage_SetCves `protobuf_oneof:"set_cves"`
	// Types that are valid to be assigned to SetFixable:
	//	*Image_FixableCves
	SetFixable     isImage_SetFixable `protobuf_oneof:"set_fixable"`
	LastUpdated    *types.Timestamp   `protobuf:"bytes,5,opt,name=last_updated,json=lastUpdated,proto3" json:"last_updated,omitempty" search:"Last Updated,hidden"`
	NotPullable    bool               `protobuf:"varint,10,opt,name=not_pullable,json=notPullable,proto3" json:"not_pullable,omitempty"`
	IsClusterLocal bool               `protobuf:"varint,17,opt,name=is_cluster_local,json=isClusterLocal,proto3" json:"is_cluster_local,omitempty"`
	Priority       int64              `protobuf:"varint,11,opt,name=priority,proto3" json:"priority,omitempty"`
	RiskScore      float32            `protobuf:"fixed32,12,opt,name=risk_score,json=riskScore,proto3" json:"risk_score,omitempty" search:"Risk Score,hidden"`
	// Types that are valid to be assigned to SetTopCvss:
	//	*Image_TopCvss
	SetTopCvss           isImage_SetTopCvss `protobuf_oneof:"set_top_cvss"`
	Notes                []Image_Note       `protobuf:"varint,14,rep,packed,name=notes,proto3,enum=storage.Image_Note" json:"notes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Image) Reset()         { *m = Image{} }
func (m *Image) String() string { return proto.CompactTextString(m) }
func (*Image) ProtoMessage()    {}
func (*Image) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{0}
}
func (m *Image) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Image) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Image.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Image) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Image.Merge(m, src)
}
func (m *Image) XXX_Size() int {
	return m.Size()
}
func (m *Image) XXX_DiscardUnknown() {
	xxx_messageInfo_Image.DiscardUnknown(m)
}

var xxx_messageInfo_Image proto.InternalMessageInfo

type isImage_SetComponents interface {
	isImage_SetComponents()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isImage_SetComponents
}
type isImage_SetCves interface {
	isImage_SetCves()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isImage_SetCves
}
type isImage_SetFixable interface {
	isImage_SetFixable()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isImage_SetFixable
}
type isImage_SetTopCvss interface {
	isImage_SetTopCvss()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isImage_SetTopCvss
}

type Image_Components struct {
	Components int32 `protobuf:"varint,7,opt,name=components,proto3,oneof" json:"components,omitempty" search:"Component Count,store,hidden"`
}
type Image_Cves struct {
	Cves int32 `protobuf:"varint,8,opt,name=cves,proto3,oneof" json:"cves,omitempty" search:"CVE Count,store,hidden"`
}
type Image_FixableCves struct {
	FixableCves int32 `protobuf:"varint,9,opt,name=fixable_cves,json=fixableCves,proto3,oneof" json:"fixable_cves,omitempty" search:"Fixable CVE Count,store,hidden"`
}
type Image_TopCvss struct {
	TopCvss float32 `protobuf:"fixed32,13,opt,name=top_cvss,json=topCvss,proto3,oneof" json:"top_cvss,omitempty" search:"Image Top CVSS,store"`
}

func (*Image_Components) isImage_SetComponents() {}
func (m *Image_Components) Clone() isImage_SetComponents {
	if m == nil {
		return nil
	}
	cloned := new(Image_Components)
	*cloned = *m

	return cloned
}
func (*Image_Cves) isImage_SetCves() {}
func (m *Image_Cves) Clone() isImage_SetCves {
	if m == nil {
		return nil
	}
	cloned := new(Image_Cves)
	*cloned = *m

	return cloned
}
func (*Image_FixableCves) isImage_SetFixable() {}
func (m *Image_FixableCves) Clone() isImage_SetFixable {
	if m == nil {
		return nil
	}
	cloned := new(Image_FixableCves)
	*cloned = *m

	return cloned
}
func (*Image_TopCvss) isImage_SetTopCvss() {}
func (m *Image_TopCvss) Clone() isImage_SetTopCvss {
	if m == nil {
		return nil
	}
	cloned := new(Image_TopCvss)
	*cloned = *m

	return cloned
}

func (m *Image) GetSetComponents() isImage_SetComponents {
	if m != nil {
		return m.SetComponents
	}
	return nil
}
func (m *Image) GetSetCves() isImage_SetCves {
	if m != nil {
		return m.SetCves
	}
	return nil
}
func (m *Image) GetSetFixable() isImage_SetFixable {
	if m != nil {
		return m.SetFixable
	}
	return nil
}
func (m *Image) GetSetTopCvss() isImage_SetTopCvss {
	if m != nil {
		return m.SetTopCvss
	}
	return nil
}

func (m *Image) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Image) GetName() *ImageName {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *Image) GetMetadata() *ImageMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Image) GetScan() *ImageScan {
	if m != nil {
		return m.Scan
	}
	return nil
}

func (m *Image) GetSignatureVerificationData() *ImageSignatureVerificationData {
	if m != nil {
		return m.SignatureVerificationData
	}
	return nil
}

func (m *Image) GetSignature() *ImageSignature {
	if m != nil {
		return m.Signature
	}
	return nil
}

func (m *Image) GetComponents() int32 {
	if x, ok := m.GetSetComponents().(*Image_Components); ok {
		return x.Components
	}
	return 0
}

func (m *Image) GetCves() int32 {
	if x, ok := m.GetSetCves().(*Image_Cves); ok {
		return x.Cves
	}
	return 0
}

func (m *Image) GetFixableCves() int32 {
	if x, ok := m.GetSetFixable().(*Image_FixableCves); ok {
		return x.FixableCves
	}
	return 0
}

func (m *Image) GetLastUpdated() *types.Timestamp {
	if m != nil {
		return m.LastUpdated
	}
	return nil
}

func (m *Image) GetNotPullable() bool {
	if m != nil {
		return m.NotPullable
	}
	return false
}

func (m *Image) GetIsClusterLocal() bool {
	if m != nil {
		return m.IsClusterLocal
	}
	return false
}

func (m *Image) GetPriority() int64 {
	if m != nil {
		return m.Priority
	}
	return 0
}

func (m *Image) GetRiskScore() float32 {
	if m != nil {
		return m.RiskScore
	}
	return 0
}

func (m *Image) GetTopCvss() float32 {
	if x, ok := m.GetSetTopCvss().(*Image_TopCvss); ok {
		return x.TopCvss
	}
	return 0
}

func (m *Image) GetNotes() []Image_Note {
	if m != nil {
		return m.Notes
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Image) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Image_Components)(nil),
		(*Image_Cves)(nil),
		(*Image_FixableCves)(nil),
		(*Image_TopCvss)(nil),
	}
}

func (m *Image) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Image) Clone() *Image {
	if m == nil {
		return nil
	}
	cloned := new(Image)
	*cloned = *m

	cloned.Name = m.Name.Clone()
	cloned.Metadata = m.Metadata.Clone()
	cloned.Scan = m.Scan.Clone()
	cloned.SignatureVerificationData = m.SignatureVerificationData.Clone()
	cloned.Signature = m.Signature.Clone()
	if m.SetComponents != nil {
		cloned.SetComponents = m.SetComponents.Clone()
	}
	if m.SetCves != nil {
		cloned.SetCves = m.SetCves.Clone()
	}
	if m.SetFixable != nil {
		cloned.SetFixable = m.SetFixable.Clone()
	}
	cloned.LastUpdated = m.LastUpdated.Clone()
	if m.SetTopCvss != nil {
		cloned.SetTopCvss = m.SetTopCvss.Clone()
	}
	if m.Notes != nil {
		cloned.Notes = make([]Image_Note, len(m.Notes))
		copy(cloned.Notes, m.Notes)
	}
	return cloned
}

type DataSource struct {
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Name                 string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DataSource) Reset()         { *m = DataSource{} }
func (m *DataSource) String() string { return proto.CompactTextString(m) }
func (*DataSource) ProtoMessage()    {}
func (*DataSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{1}
}
func (m *DataSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DataSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DataSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DataSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataSource.Merge(m, src)
}
func (m *DataSource) XXX_Size() int {
	return m.Size()
}
func (m *DataSource) XXX_DiscardUnknown() {
	xxx_messageInfo_DataSource.DiscardUnknown(m)
}

var xxx_messageInfo_DataSource proto.InternalMessageInfo

func (m *DataSource) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *DataSource) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DataSource) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DataSource) Clone() *DataSource {
	if m == nil {
		return nil
	}
	cloned := new(DataSource)
	*cloned = *m

	return cloned
}

// Next tag: 7
type ImageScan struct {
	ScannerVersion  string                        `protobuf:"bytes,6,opt,name=scanner_version,json=scannerVersion,proto3" json:"scanner_version,omitempty"`
	ScanTime        *types.Timestamp              `protobuf:"bytes,1,opt,name=scan_time,json=scanTime,proto3" json:"scan_time,omitempty" search:"Image Scan Time,store"`
	Components      []*EmbeddedImageScanComponent `protobuf:"bytes,2,rep,name=components,proto3" json:"components,omitempty"`
	OperatingSystem string                        `protobuf:"bytes,4,opt,name=operating_system,json=operatingSystem,proto3" json:"operating_system,omitempty" search:"Image OS,store"`
	// DataSource contains information about which integration was used to scan the image
	DataSource           *DataSource      `protobuf:"bytes,3,opt,name=data_source,json=dataSource,proto3" json:"data_source,omitempty"`
	Notes                []ImageScan_Note `protobuf:"varint,5,rep,packed,name=notes,proto3,enum=storage.ImageScan_Note" json:"notes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ImageScan) Reset()         { *m = ImageScan{} }
func (m *ImageScan) String() string { return proto.CompactTextString(m) }
func (*ImageScan) ProtoMessage()    {}
func (*ImageScan) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{2}
}
func (m *ImageScan) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImageScan) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImageScan.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImageScan) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageScan.Merge(m, src)
}
func (m *ImageScan) XXX_Size() int {
	return m.Size()
}
func (m *ImageScan) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageScan.DiscardUnknown(m)
}

var xxx_messageInfo_ImageScan proto.InternalMessageInfo

func (m *ImageScan) GetScannerVersion() string {
	if m != nil {
		return m.ScannerVersion
	}
	return ""
}

func (m *ImageScan) GetScanTime() *types.Timestamp {
	if m != nil {
		return m.ScanTime
	}
	return nil
}

func (m *ImageScan) GetComponents() []*EmbeddedImageScanComponent {
	if m != nil {
		return m.Components
	}
	return nil
}

func (m *ImageScan) GetOperatingSystem() string {
	if m != nil {
		return m.OperatingSystem
	}
	return ""
}

func (m *ImageScan) GetDataSource() *DataSource {
	if m != nil {
		return m.DataSource
	}
	return nil
}

func (m *ImageScan) GetNotes() []ImageScan_Note {
	if m != nil {
		return m.Notes
	}
	return nil
}

func (m *ImageScan) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ImageScan) Clone() *ImageScan {
	if m == nil {
		return nil
	}
	cloned := new(ImageScan)
	*cloned = *m

	cloned.ScanTime = m.ScanTime.Clone()
	if m.Components != nil {
		cloned.Components = make([]*EmbeddedImageScanComponent, len(m.Components))
		for idx, v := range m.Components {
			cloned.Components[idx] = v.Clone()
		}
	}
	cloned.DataSource = m.DataSource.Clone()
	if m.Notes != nil {
		cloned.Notes = make([]ImageScan_Note, len(m.Notes))
		copy(cloned.Notes, m.Notes)
	}
	return cloned
}

type ImageSignatureVerificationData struct {
	Results              []*ImageSignatureVerificationResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                            `json:"-"`
	XXX_unrecognized     []byte                              `json:"-"`
	XXX_sizecache        int32                               `json:"-"`
}

func (m *ImageSignatureVerificationData) Reset()         { *m = ImageSignatureVerificationData{} }
func (m *ImageSignatureVerificationData) String() string { return proto.CompactTextString(m) }
func (*ImageSignatureVerificationData) ProtoMessage()    {}
func (*ImageSignatureVerificationData) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{3}
}
func (m *ImageSignatureVerificationData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImageSignatureVerificationData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImageSignatureVerificationData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImageSignatureVerificationData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageSignatureVerificationData.Merge(m, src)
}
func (m *ImageSignatureVerificationData) XXX_Size() int {
	return m.Size()
}
func (m *ImageSignatureVerificationData) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageSignatureVerificationData.DiscardUnknown(m)
}

var xxx_messageInfo_ImageSignatureVerificationData proto.InternalMessageInfo

func (m *ImageSignatureVerificationData) GetResults() []*ImageSignatureVerificationResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *ImageSignatureVerificationData) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ImageSignatureVerificationData) Clone() *ImageSignatureVerificationData {
	if m == nil {
		return nil
	}
	cloned := new(ImageSignatureVerificationData)
	*cloned = *m

	if m.Results != nil {
		cloned.Results = make([]*ImageSignatureVerificationResult, len(m.Results))
		for idx, v := range m.Results {
			cloned.Results[idx] = v.Clone()
		}
	}
	return cloned
}

// Next Tag: 4
type ImageSignatureVerificationResult struct {
	VerificationTime *types.Timestamp `protobuf:"bytes,1,opt,name=verification_time,json=verificationTime,proto3" json:"verification_time,omitempty"`
	// verifier_id correlates to the ID of the signature integration used to verify the signature.
	VerifierId string                                  `protobuf:"bytes,2,opt,name=verifier_id,json=verifierId,proto3" json:"verifier_id,omitempty"`
	Status     ImageSignatureVerificationResult_Status `protobuf:"varint,3,opt,name=status,proto3,enum=storage.ImageSignatureVerificationResult_Status" json:"status,omitempty"`
	// description is set in the case of an error with the specific error's message. Otherwise, this will not be set.
	Description          string   `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImageSignatureVerificationResult) Reset()         { *m = ImageSignatureVerificationResult{} }
func (m *ImageSignatureVerificationResult) String() string { return proto.CompactTextString(m) }
func (*ImageSignatureVerificationResult) ProtoMessage()    {}
func (*ImageSignatureVerificationResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{4}
}
func (m *ImageSignatureVerificationResult) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImageSignatureVerificationResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImageSignatureVerificationResult.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImageSignatureVerificationResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageSignatureVerificationResult.Merge(m, src)
}
func (m *ImageSignatureVerificationResult) XXX_Size() int {
	return m.Size()
}
func (m *ImageSignatureVerificationResult) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageSignatureVerificationResult.DiscardUnknown(m)
}

var xxx_messageInfo_ImageSignatureVerificationResult proto.InternalMessageInfo

func (m *ImageSignatureVerificationResult) GetVerificationTime() *types.Timestamp {
	if m != nil {
		return m.VerificationTime
	}
	return nil
}

func (m *ImageSignatureVerificationResult) GetVerifierId() string {
	if m != nil {
		return m.VerifierId
	}
	return ""
}

func (m *ImageSignatureVerificationResult) GetStatus() ImageSignatureVerificationResult_Status {
	if m != nil {
		return m.Status
	}
	return ImageSignatureVerificationResult_UNSET
}

func (m *ImageSignatureVerificationResult) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ImageSignatureVerificationResult) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ImageSignatureVerificationResult) Clone() *ImageSignatureVerificationResult {
	if m == nil {
		return nil
	}
	cloned := new(ImageSignatureVerificationResult)
	*cloned = *m

	cloned.VerificationTime = m.VerificationTime.Clone()
	return cloned
}

// Next Tag: 13
type EmbeddedImageScanComponent struct {
	Name    string                   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty" search:"Component,store"`
	Version string                   `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty" search:"Component Version,store"`
	License *License                 `protobuf:"bytes,3,opt,name=license,proto3" json:"license,omitempty"`
	Vulns   []*EmbeddedVulnerability `protobuf:"bytes,4,rep,name=vulns,proto3" json:"vulns,omitempty"`
	// Types that are valid to be assigned to HasLayerIndex:
	//	*EmbeddedImageScanComponent_LayerIndex
	HasLayerIndex isEmbeddedImageScanComponent_HasLayerIndex `protobuf_oneof:"has_layer_index"`
	Priority      int64                                      `protobuf:"varint,6,opt,name=priority,proto3" json:"priority,omitempty"`
	Source        SourceType                                 `protobuf:"varint,7,opt,name=source,proto3,enum=storage.SourceType" json:"source,omitempty"`
	Location      string                                     `protobuf:"bytes,8,opt,name=location,proto3" json:"location,omitempty"`
	// Types that are valid to be assigned to SetTopCvss:
	//	*EmbeddedImageScanComponent_TopCvss
	SetTopCvss isEmbeddedImageScanComponent_SetTopCvss `protobuf_oneof:"set_top_cvss"`
	RiskScore  float32                                 `protobuf:"fixed32,10,opt,name=risk_score,json=riskScore,proto3" json:"risk_score,omitempty"`
	// Component version that fixes all the fixable vulnerabilities in this component.
	FixedBy string `protobuf:"bytes,11,opt,name=fixed_by,json=fixedBy,proto3" json:"fixed_by,omitempty"`
	// Values are cleared after moving to cache, remove them from the grpc return as well
	Executables          []*EmbeddedImageScanComponent_Executable `protobuf:"bytes,12,rep,name=executables,proto3" json:"-"`
	XXX_NoUnkeyedLiteral struct{}                                 `json:"-"`
	XXX_unrecognized     []byte                                   `json:"-"`
	XXX_sizecache        int32                                    `json:"-"`
}

func (m *EmbeddedImageScanComponent) Reset()         { *m = EmbeddedImageScanComponent{} }
func (m *EmbeddedImageScanComponent) String() string { return proto.CompactTextString(m) }
func (*EmbeddedImageScanComponent) ProtoMessage()    {}
func (*EmbeddedImageScanComponent) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{5}
}
func (m *EmbeddedImageScanComponent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EmbeddedImageScanComponent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EmbeddedImageScanComponent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EmbeddedImageScanComponent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EmbeddedImageScanComponent.Merge(m, src)
}
func (m *EmbeddedImageScanComponent) XXX_Size() int {
	return m.Size()
}
func (m *EmbeddedImageScanComponent) XXX_DiscardUnknown() {
	xxx_messageInfo_EmbeddedImageScanComponent.DiscardUnknown(m)
}

var xxx_messageInfo_EmbeddedImageScanComponent proto.InternalMessageInfo

type isEmbeddedImageScanComponent_HasLayerIndex interface {
	isEmbeddedImageScanComponent_HasLayerIndex()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isEmbeddedImageScanComponent_HasLayerIndex
}
type isEmbeddedImageScanComponent_SetTopCvss interface {
	isEmbeddedImageScanComponent_SetTopCvss()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isEmbeddedImageScanComponent_SetTopCvss
}

type EmbeddedImageScanComponent_LayerIndex struct {
	LayerIndex int32 `protobuf:"varint,5,opt,name=layer_index,json=layerIndex,proto3,oneof" json:"layer_index,omitempty"`
}
type EmbeddedImageScanComponent_TopCvss struct {
	TopCvss float32 `protobuf:"fixed32,9,opt,name=top_cvss,json=topCvss,proto3,oneof" json:"top_cvss,omitempty"`
}

func (*EmbeddedImageScanComponent_LayerIndex) isEmbeddedImageScanComponent_HasLayerIndex() {}
func (m *EmbeddedImageScanComponent_LayerIndex) Clone() isEmbeddedImageScanComponent_HasLayerIndex {
	if m == nil {
		return nil
	}
	cloned := new(EmbeddedImageScanComponent_LayerIndex)
	*cloned = *m

	return cloned
}
func (*EmbeddedImageScanComponent_TopCvss) isEmbeddedImageScanComponent_SetTopCvss() {}
func (m *EmbeddedImageScanComponent_TopCvss) Clone() isEmbeddedImageScanComponent_SetTopCvss {
	if m == nil {
		return nil
	}
	cloned := new(EmbeddedImageScanComponent_TopCvss)
	*cloned = *m

	return cloned
}

func (m *EmbeddedImageScanComponent) GetHasLayerIndex() isEmbeddedImageScanComponent_HasLayerIndex {
	if m != nil {
		return m.HasLayerIndex
	}
	return nil
}
func (m *EmbeddedImageScanComponent) GetSetTopCvss() isEmbeddedImageScanComponent_SetTopCvss {
	if m != nil {
		return m.SetTopCvss
	}
	return nil
}

func (m *EmbeddedImageScanComponent) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EmbeddedImageScanComponent) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *EmbeddedImageScanComponent) GetLicense() *License {
	if m != nil {
		return m.License
	}
	return nil
}

func (m *EmbeddedImageScanComponent) GetVulns() []*EmbeddedVulnerability {
	if m != nil {
		return m.Vulns
	}
	return nil
}

func (m *EmbeddedImageScanComponent) GetLayerIndex() int32 {
	if x, ok := m.GetHasLayerIndex().(*EmbeddedImageScanComponent_LayerIndex); ok {
		return x.LayerIndex
	}
	return 0
}

func (m *EmbeddedImageScanComponent) GetPriority() int64 {
	if m != nil {
		return m.Priority
	}
	return 0
}

func (m *EmbeddedImageScanComponent) GetSource() SourceType {
	if m != nil {
		return m.Source
	}
	return SourceType_OS
}

func (m *EmbeddedImageScanComponent) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *EmbeddedImageScanComponent) GetTopCvss() float32 {
	if x, ok := m.GetSetTopCvss().(*EmbeddedImageScanComponent_TopCvss); ok {
		return x.TopCvss
	}
	return 0
}

func (m *EmbeddedImageScanComponent) GetRiskScore() float32 {
	if m != nil {
		return m.RiskScore
	}
	return 0
}

func (m *EmbeddedImageScanComponent) GetFixedBy() string {
	if m != nil {
		return m.FixedBy
	}
	return ""
}

func (m *EmbeddedImageScanComponent) GetExecutables() []*EmbeddedImageScanComponent_Executable {
	if m != nil {
		return m.Executables
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*EmbeddedImageScanComponent) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*EmbeddedImageScanComponent_LayerIndex)(nil),
		(*EmbeddedImageScanComponent_TopCvss)(nil),
	}
}

func (m *EmbeddedImageScanComponent) MessageClone() proto.Message {
	return m.Clone()
}
func (m *EmbeddedImageScanComponent) Clone() *EmbeddedImageScanComponent {
	if m == nil {
		return nil
	}
	cloned := new(EmbeddedImageScanComponent)
	*cloned = *m

	cloned.License = m.License.Clone()
	if m.Vulns != nil {
		cloned.Vulns = make([]*EmbeddedVulnerability, len(m.Vulns))
		for idx, v := range m.Vulns {
			cloned.Vulns[idx] = v.Clone()
		}
	}
	if m.HasLayerIndex != nil {
		cloned.HasLayerIndex = m.HasLayerIndex.Clone()
	}
	if m.SetTopCvss != nil {
		cloned.SetTopCvss = m.SetTopCvss.Clone()
	}
	if m.Executables != nil {
		cloned.Executables = make([]*EmbeddedImageScanComponent_Executable, len(m.Executables))
		for idx, v := range m.Executables {
			cloned.Executables[idx] = v.Clone()
		}
	}
	return cloned
}

type EmbeddedImageScanComponent_Executable struct {
	Path                 string   `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Dependencies         []string `protobuf:"bytes,2,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EmbeddedImageScanComponent_Executable) Reset()         { *m = EmbeddedImageScanComponent_Executable{} }
func (m *EmbeddedImageScanComponent_Executable) String() string { return proto.CompactTextString(m) }
func (*EmbeddedImageScanComponent_Executable) ProtoMessage()    {}
func (*EmbeddedImageScanComponent_Executable) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{5, 0}
}
func (m *EmbeddedImageScanComponent_Executable) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EmbeddedImageScanComponent_Executable) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EmbeddedImageScanComponent_Executable.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EmbeddedImageScanComponent_Executable) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EmbeddedImageScanComponent_Executable.Merge(m, src)
}
func (m *EmbeddedImageScanComponent_Executable) XXX_Size() int {
	return m.Size()
}
func (m *EmbeddedImageScanComponent_Executable) XXX_DiscardUnknown() {
	xxx_messageInfo_EmbeddedImageScanComponent_Executable.DiscardUnknown(m)
}

var xxx_messageInfo_EmbeddedImageScanComponent_Executable proto.InternalMessageInfo

func (m *EmbeddedImageScanComponent_Executable) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *EmbeddedImageScanComponent_Executable) GetDependencies() []string {
	if m != nil {
		return m.Dependencies
	}
	return nil
}

func (m *EmbeddedImageScanComponent_Executable) MessageClone() proto.Message {
	return m.Clone()
}
func (m *EmbeddedImageScanComponent_Executable) Clone() *EmbeddedImageScanComponent_Executable {
	if m == nil {
		return nil
	}
	cloned := new(EmbeddedImageScanComponent_Executable)
	*cloned = *m

	if m.Dependencies != nil {
		cloned.Dependencies = make([]string, len(m.Dependencies))
		copy(cloned.Dependencies, m.Dependencies)
	}
	return cloned
}

type License struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Type                 string   `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	Url                  string   `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *License) Reset()         { *m = License{} }
func (m *License) String() string { return proto.CompactTextString(m) }
func (*License) ProtoMessage()    {}
func (*License) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{6}
}
func (m *License) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *License) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_License.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *License) XXX_Merge(src proto.Message) {
	xxx_messageInfo_License.Merge(m, src)
}
func (m *License) XXX_Size() int {
	return m.Size()
}
func (m *License) XXX_DiscardUnknown() {
	xxx_messageInfo_License.DiscardUnknown(m)
}

var xxx_messageInfo_License proto.InternalMessageInfo

func (m *License) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *License) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *License) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *License) MessageClone() proto.Message {
	return m.Clone()
}
func (m *License) Clone() *License {
	if m == nil {
		return nil
	}
	cloned := new(License)
	*cloned = *m

	return cloned
}

// If any fields of ImageMetadata are modified including subfields, please check pkg/images/enricher/metadata.go
// to ensure that those changes will be automatically picked up
// Next Tag: 6
type ImageMetadata struct {
	// V1Metadata contains all of the V1 docker data. In the normal case we will get this because the image is a
	// V1 image OR because the v2 manifest has a link to it in it's config.
	// See https://docs.docker.com/registry/spec/manifest-v2-2/#image-manifest-field-descriptions
	// The only time we will not get it is in the rare caseof a strictly V2 image schema
	V1 *V1Metadata `protobuf:"bytes,1,opt,name=v1,proto3" json:"v1,omitempty"`
	// We should always get V2 metadata unless the registry is old or the image is strictly V1
	V2 *V2Metadata `protobuf:"bytes,2,opt,name=v2,proto3" json:"v2,omitempty"`
	// We never need both sets of layers so consolidate them. They will be ordered by oldest->newest
	LayerShas []string `protobuf:"bytes,3,rep,name=layer_shas,json=layerShas,proto3" json:"layer_shas,omitempty"`
	// DataSource contains information about which integration was used to pull the metadata
	DataSource *DataSource `protobuf:"bytes,4,opt,name=data_source,json=dataSource,proto3" json:"data_source,omitempty"`
	// Version is used to determine if the metadata needs to be re-pulled
	Version              uint64   `protobuf:"varint,5,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImageMetadata) Reset()         { *m = ImageMetadata{} }
func (m *ImageMetadata) String() string { return proto.CompactTextString(m) }
func (*ImageMetadata) ProtoMessage()    {}
func (*ImageMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{7}
}
func (m *ImageMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImageMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImageMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImageMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageMetadata.Merge(m, src)
}
func (m *ImageMetadata) XXX_Size() int {
	return m.Size()
}
func (m *ImageMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ImageMetadata proto.InternalMessageInfo

func (m *ImageMetadata) GetV1() *V1Metadata {
	if m != nil {
		return m.V1
	}
	return nil
}

func (m *ImageMetadata) GetV2() *V2Metadata {
	if m != nil {
		return m.V2
	}
	return nil
}

func (m *ImageMetadata) GetLayerShas() []string {
	if m != nil {
		return m.LayerShas
	}
	return nil
}

func (m *ImageMetadata) GetDataSource() *DataSource {
	if m != nil {
		return m.DataSource
	}
	return nil
}

func (m *ImageMetadata) GetVersion() uint64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *ImageMetadata) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ImageMetadata) Clone() *ImageMetadata {
	if m == nil {
		return nil
	}
	cloned := new(ImageMetadata)
	*cloned = *m

	cloned.V1 = m.V1.Clone()
	cloned.V2 = m.V2.Clone()
	if m.LayerShas != nil {
		cloned.LayerShas = make([]string, len(m.LayerShas))
		copy(cloned.LayerShas, m.LayerShas)
	}
	cloned.DataSource = m.DataSource.Clone()
	return cloned
}

type ImageSignature struct {
	Signatures           []*Signature `protobuf:"bytes,1,rep,name=signatures,proto3" json:"signatures,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ImageSignature) Reset()         { *m = ImageSignature{} }
func (m *ImageSignature) String() string { return proto.CompactTextString(m) }
func (*ImageSignature) ProtoMessage()    {}
func (*ImageSignature) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{8}
}
func (m *ImageSignature) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImageSignature) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImageSignature.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImageSignature) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageSignature.Merge(m, src)
}
func (m *ImageSignature) XXX_Size() int {
	return m.Size()
}
func (m *ImageSignature) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageSignature.DiscardUnknown(m)
}

var xxx_messageInfo_ImageSignature proto.InternalMessageInfo

func (m *ImageSignature) GetSignatures() []*Signature {
	if m != nil {
		return m.Signatures
	}
	return nil
}

func (m *ImageSignature) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ImageSignature) Clone() *ImageSignature {
	if m == nil {
		return nil
	}
	cloned := new(ImageSignature)
	*cloned = *m

	if m.Signatures != nil {
		cloned.Signatures = make([]*Signature, len(m.Signatures))
		for idx, v := range m.Signatures {
			cloned.Signatures[idx] = v.Clone()
		}
	}
	return cloned
}

type Signature struct {
	// Types that are valid to be assigned to Signature:
	//	*Signature_Cosign
	Signature            isSignature_Signature `protobuf_oneof:"Signature"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Signature) Reset()         { *m = Signature{} }
func (m *Signature) String() string { return proto.CompactTextString(m) }
func (*Signature) ProtoMessage()    {}
func (*Signature) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{9}
}
func (m *Signature) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Signature) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Signature.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Signature) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Signature.Merge(m, src)
}
func (m *Signature) XXX_Size() int {
	return m.Size()
}
func (m *Signature) XXX_DiscardUnknown() {
	xxx_messageInfo_Signature.DiscardUnknown(m)
}

var xxx_messageInfo_Signature proto.InternalMessageInfo

type isSignature_Signature interface {
	isSignature_Signature()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isSignature_Signature
}

type Signature_Cosign struct {
	Cosign *CosignSignature `protobuf:"bytes,1,opt,name=cosign,proto3,oneof" json:"cosign,omitempty"`
}

func (*Signature_Cosign) isSignature_Signature() {}
func (m *Signature_Cosign) Clone() isSignature_Signature {
	if m == nil {
		return nil
	}
	cloned := new(Signature_Cosign)
	*cloned = *m

	cloned.Cosign = m.Cosign.Clone()
	return cloned
}

func (m *Signature) GetSignature() isSignature_Signature {
	if m != nil {
		return m.Signature
	}
	return nil
}

func (m *Signature) GetCosign() *CosignSignature {
	if x, ok := m.GetSignature().(*Signature_Cosign); ok {
		return x.Cosign
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Signature) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Signature_Cosign)(nil),
	}
}

func (m *Signature) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Signature) Clone() *Signature {
	if m == nil {
		return nil
	}
	cloned := new(Signature)
	*cloned = *m

	if m.Signature != nil {
		cloned.Signature = m.Signature.Clone()
	}
	return cloned
}

type CosignSignature struct {
	RawSignature         []byte   `protobuf:"bytes,1,opt,name=raw_signature,json=rawSignature,proto3" json:"raw_signature,omitempty"`
	SignaturePayload     []byte   `protobuf:"bytes,2,opt,name=signature_payload,json=signaturePayload,proto3" json:"signature_payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CosignSignature) Reset()         { *m = CosignSignature{} }
func (m *CosignSignature) String() string { return proto.CompactTextString(m) }
func (*CosignSignature) ProtoMessage()    {}
func (*CosignSignature) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{10}
}
func (m *CosignSignature) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CosignSignature) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CosignSignature.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CosignSignature) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CosignSignature.Merge(m, src)
}
func (m *CosignSignature) XXX_Size() int {
	return m.Size()
}
func (m *CosignSignature) XXX_DiscardUnknown() {
	xxx_messageInfo_CosignSignature.DiscardUnknown(m)
}

var xxx_messageInfo_CosignSignature proto.InternalMessageInfo

func (m *CosignSignature) GetRawSignature() []byte {
	if m != nil {
		return m.RawSignature
	}
	return nil
}

func (m *CosignSignature) GetSignaturePayload() []byte {
	if m != nil {
		return m.SignaturePayload
	}
	return nil
}

func (m *CosignSignature) MessageClone() proto.Message {
	return m.Clone()
}
func (m *CosignSignature) Clone() *CosignSignature {
	if m == nil {
		return nil
	}
	cloned := new(CosignSignature)
	*cloned = *m

	if m.RawSignature != nil {
		cloned.RawSignature = make([]byte, len(m.RawSignature))
		copy(cloned.RawSignature, m.RawSignature)
	}
	if m.SignaturePayload != nil {
		cloned.SignaturePayload = make([]byte, len(m.SignaturePayload))
		copy(cloned.SignaturePayload, m.SignaturePayload)
	}
	return cloned
}

type V2Metadata struct {
	Digest               string   `protobuf:"bytes,1,opt,name=digest,proto3" json:"digest,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *V2Metadata) Reset()         { *m = V2Metadata{} }
func (m *V2Metadata) String() string { return proto.CompactTextString(m) }
func (*V2Metadata) ProtoMessage()    {}
func (*V2Metadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{11}
}
func (m *V2Metadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *V2Metadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_V2Metadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *V2Metadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_V2Metadata.Merge(m, src)
}
func (m *V2Metadata) XXX_Size() int {
	return m.Size()
}
func (m *V2Metadata) XXX_DiscardUnknown() {
	xxx_messageInfo_V2Metadata.DiscardUnknown(m)
}

var xxx_messageInfo_V2Metadata proto.InternalMessageInfo

func (m *V2Metadata) GetDigest() string {
	if m != nil {
		return m.Digest
	}
	return ""
}

func (m *V2Metadata) MessageClone() proto.Message {
	return m.Clone()
}
func (m *V2Metadata) Clone() *V2Metadata {
	if m == nil {
		return nil
	}
	cloned := new(V2Metadata)
	*cloned = *m

	return cloned
}

type V1Metadata struct {
	Digest               string            `protobuf:"bytes,1,opt,name=digest,proto3" json:"digest,omitempty"`
	Created              *types.Timestamp  `protobuf:"bytes,2,opt,name=created,proto3" json:"created,omitempty" search:"Image Created Time,store"`
	Author               string            `protobuf:"bytes,3,opt,name=author,proto3" json:"author,omitempty"`
	Layers               []*ImageLayer     `protobuf:"bytes,4,rep,name=layers,proto3" json:"layers,omitempty"`
	User                 string            `protobuf:"bytes,5,opt,name=user,proto3" json:"user,omitempty" search:"Image User"`
	Command              []string          `protobuf:"bytes,6,rep,name=command,proto3" json:"command,omitempty" search:"Image Command"`
	Entrypoint           []string          `protobuf:"bytes,7,rep,name=entrypoint,proto3" json:"entrypoint,omitempty" search:"Image Entrypoint"`
	Volumes              []string          `protobuf:"bytes,8,rep,name=volumes,proto3" json:"volumes,omitempty" search:"Image Volumes"`
	Labels               map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" search:"Image Label,store" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *V1Metadata) Reset()         { *m = V1Metadata{} }
func (m *V1Metadata) String() string { return proto.CompactTextString(m) }
func (*V1Metadata) ProtoMessage()    {}
func (*V1Metadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{12}
}
func (m *V1Metadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *V1Metadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_V1Metadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *V1Metadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_V1Metadata.Merge(m, src)
}
func (m *V1Metadata) XXX_Size() int {
	return m.Size()
}
func (m *V1Metadata) XXX_DiscardUnknown() {
	xxx_messageInfo_V1Metadata.DiscardUnknown(m)
}

var xxx_messageInfo_V1Metadata proto.InternalMessageInfo

func (m *V1Metadata) GetDigest() string {
	if m != nil {
		return m.Digest
	}
	return ""
}

func (m *V1Metadata) GetCreated() *types.Timestamp {
	if m != nil {
		return m.Created
	}
	return nil
}

func (m *V1Metadata) GetAuthor() string {
	if m != nil {
		return m.Author
	}
	return ""
}

func (m *V1Metadata) GetLayers() []*ImageLayer {
	if m != nil {
		return m.Layers
	}
	return nil
}

func (m *V1Metadata) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *V1Metadata) GetCommand() []string {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *V1Metadata) GetEntrypoint() []string {
	if m != nil {
		return m.Entrypoint
	}
	return nil
}

func (m *V1Metadata) GetVolumes() []string {
	if m != nil {
		return m.Volumes
	}
	return nil
}

func (m *V1Metadata) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *V1Metadata) MessageClone() proto.Message {
	return m.Clone()
}
func (m *V1Metadata) Clone() *V1Metadata {
	if m == nil {
		return nil
	}
	cloned := new(V1Metadata)
	*cloned = *m

	cloned.Created = m.Created.Clone()
	if m.Layers != nil {
		cloned.Layers = make([]*ImageLayer, len(m.Layers))
		for idx, v := range m.Layers {
			cloned.Layers[idx] = v.Clone()
		}
	}
	if m.Command != nil {
		cloned.Command = make([]string, len(m.Command))
		copy(cloned.Command, m.Command)
	}
	if m.Entrypoint != nil {
		cloned.Entrypoint = make([]string, len(m.Entrypoint))
		copy(cloned.Entrypoint, m.Entrypoint)
	}
	if m.Volumes != nil {
		cloned.Volumes = make([]string, len(m.Volumes))
		copy(cloned.Volumes, m.Volumes)
	}
	if m.Labels != nil {
		cloned.Labels = make(map[string]string, len(m.Labels))
		for k, v := range m.Labels {
			cloned.Labels[k] = v
		}
	}
	return cloned
}

type ImageLayer struct {
	Instruction          string           `protobuf:"bytes,1,opt,name=instruction,proto3" json:"instruction,omitempty" search:"Dockerfile Instruction Keyword,store"`
	Value                string           `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty" search:"Dockerfile Instruction Value,store"`
	Created              *types.Timestamp `protobuf:"bytes,3,opt,name=created,proto3" json:"created,omitempty"`
	Author               string           `protobuf:"bytes,4,opt,name=author,proto3" json:"author,omitempty"`
	Empty                bool             `protobuf:"varint,6,opt,name=empty,proto3" json:"empty,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ImageLayer) Reset()         { *m = ImageLayer{} }
func (m *ImageLayer) String() string { return proto.CompactTextString(m) }
func (*ImageLayer) ProtoMessage()    {}
func (*ImageLayer) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{13}
}
func (m *ImageLayer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImageLayer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImageLayer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImageLayer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageLayer.Merge(m, src)
}
func (m *ImageLayer) XXX_Size() int {
	return m.Size()
}
func (m *ImageLayer) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageLayer.DiscardUnknown(m)
}

var xxx_messageInfo_ImageLayer proto.InternalMessageInfo

func (m *ImageLayer) GetInstruction() string {
	if m != nil {
		return m.Instruction
	}
	return ""
}

func (m *ImageLayer) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *ImageLayer) GetCreated() *types.Timestamp {
	if m != nil {
		return m.Created
	}
	return nil
}

func (m *ImageLayer) GetAuthor() string {
	if m != nil {
		return m.Author
	}
	return ""
}

func (m *ImageLayer) GetEmpty() bool {
	if m != nil {
		return m.Empty
	}
	return false
}

func (m *ImageLayer) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ImageLayer) Clone() *ImageLayer {
	if m == nil {
		return nil
	}
	cloned := new(ImageLayer)
	*cloned = *m

	cloned.Created = m.Created.Clone()
	return cloned
}

type ImageName struct {
	Registry             string   `protobuf:"bytes,1,opt,name=registry,proto3" json:"registry,omitempty" search:"Image Registry,store"`
	Remote               string   `protobuf:"bytes,2,opt,name=remote,proto3" json:"remote,omitempty" search:"Image Remote,store"`
	Tag                  string   `protobuf:"bytes,3,opt,name=tag,proto3" json:"tag,omitempty" search:"Image Tag,store"`
	FullName             string   `protobuf:"bytes,4,opt,name=full_name,json=fullName,proto3" json:"full_name,omitempty" search:"Image,store,analyzer=standard"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImageName) Reset()         { *m = ImageName{} }
func (m *ImageName) String() string { return proto.CompactTextString(m) }
func (*ImageName) ProtoMessage()    {}
func (*ImageName) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{14}
}
func (m *ImageName) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImageName) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImageName.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImageName) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageName.Merge(m, src)
}
func (m *ImageName) XXX_Size() int {
	return m.Size()
}
func (m *ImageName) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageName.DiscardUnknown(m)
}

var xxx_messageInfo_ImageName proto.InternalMessageInfo

func (m *ImageName) GetRegistry() string {
	if m != nil {
		return m.Registry
	}
	return ""
}

func (m *ImageName) GetRemote() string {
	if m != nil {
		return m.Remote
	}
	return ""
}

func (m *ImageName) GetTag() string {
	if m != nil {
		return m.Tag
	}
	return ""
}

func (m *ImageName) GetFullName() string {
	if m != nil {
		return m.FullName
	}
	return ""
}

func (m *ImageName) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ImageName) Clone() *ImageName {
	if m == nil {
		return nil
	}
	cloned := new(ImageName)
	*cloned = *m

	return cloned
}

type ListImage struct {
	Id   string `protobuf:"bytes,7,opt,name=id,proto3" json:"id,omitempty"`
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are valid to be assigned to SetComponents:
	//	*ListImage_Components
	SetComponents isListImage_SetComponents `protobuf_oneof:"set_components"`
	// Types that are valid to be assigned to SetCves:
	//	*ListImage_Cves
	SetCves isListImage_SetCves `protobuf_oneof:"set_cves"`
	// Types that are valid to be assigned to SetFixable:
	//	*ListImage_FixableCves
	SetFixable           isListImage_SetFixable `protobuf_oneof:"set_fixable"`
	Created              *types.Timestamp       `protobuf:"bytes,6,opt,name=created,proto3" json:"created,omitempty"`
	LastUpdated          *types.Timestamp       `protobuf:"bytes,8,opt,name=last_updated,json=lastUpdated,proto3" json:"last_updated,omitempty"`
	Priority             int64                  `protobuf:"varint,10,opt,name=priority,proto3" json:"priority,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *ListImage) Reset()         { *m = ListImage{} }
func (m *ListImage) String() string { return proto.CompactTextString(m) }
func (*ListImage) ProtoMessage()    {}
func (*ListImage) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{15}
}
func (m *ListImage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListImage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListImage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListImage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListImage.Merge(m, src)
}
func (m *ListImage) XXX_Size() int {
	return m.Size()
}
func (m *ListImage) XXX_DiscardUnknown() {
	xxx_messageInfo_ListImage.DiscardUnknown(m)
}

var xxx_messageInfo_ListImage proto.InternalMessageInfo

type isListImage_SetComponents interface {
	isListImage_SetComponents()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isListImage_SetComponents
}
type isListImage_SetCves interface {
	isListImage_SetCves()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isListImage_SetCves
}
type isListImage_SetFixable interface {
	isListImage_SetFixable()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isListImage_SetFixable
}

type ListImage_Components struct {
	Components int32 `protobuf:"varint,3,opt,name=components,proto3,oneof" json:"components,omitempty"`
}
type ListImage_Cves struct {
	Cves int32 `protobuf:"varint,4,opt,name=cves,proto3,oneof" json:"cves,omitempty"`
}
type ListImage_FixableCves struct {
	FixableCves int32 `protobuf:"varint,5,opt,name=fixable_cves,json=fixableCves,proto3,oneof" json:"fixable_cves,omitempty"`
}

func (*ListImage_Components) isListImage_SetComponents() {}
func (m *ListImage_Components) Clone() isListImage_SetComponents {
	if m == nil {
		return nil
	}
	cloned := new(ListImage_Components)
	*cloned = *m

	return cloned
}
func (*ListImage_Cves) isListImage_SetCves() {}
func (m *ListImage_Cves) Clone() isListImage_SetCves {
	if m == nil {
		return nil
	}
	cloned := new(ListImage_Cves)
	*cloned = *m

	return cloned
}
func (*ListImage_FixableCves) isListImage_SetFixable() {}
func (m *ListImage_FixableCves) Clone() isListImage_SetFixable {
	if m == nil {
		return nil
	}
	cloned := new(ListImage_FixableCves)
	*cloned = *m

	return cloned
}

func (m *ListImage) GetSetComponents() isListImage_SetComponents {
	if m != nil {
		return m.SetComponents
	}
	return nil
}
func (m *ListImage) GetSetCves() isListImage_SetCves {
	if m != nil {
		return m.SetCves
	}
	return nil
}
func (m *ListImage) GetSetFixable() isListImage_SetFixable {
	if m != nil {
		return m.SetFixable
	}
	return nil
}

func (m *ListImage) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ListImage) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListImage) GetComponents() int32 {
	if x, ok := m.GetSetComponents().(*ListImage_Components); ok {
		return x.Components
	}
	return 0
}

func (m *ListImage) GetCves() int32 {
	if x, ok := m.GetSetCves().(*ListImage_Cves); ok {
		return x.Cves
	}
	return 0
}

func (m *ListImage) GetFixableCves() int32 {
	if x, ok := m.GetSetFixable().(*ListImage_FixableCves); ok {
		return x.FixableCves
	}
	return 0
}

func (m *ListImage) GetCreated() *types.Timestamp {
	if m != nil {
		return m.Created
	}
	return nil
}

func (m *ListImage) GetLastUpdated() *types.Timestamp {
	if m != nil {
		return m.LastUpdated
	}
	return nil
}

func (m *ListImage) GetPriority() int64 {
	if m != nil {
		return m.Priority
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ListImage) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ListImage_Components)(nil),
		(*ListImage_Cves)(nil),
		(*ListImage_FixableCves)(nil),
	}
}

func (m *ListImage) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListImage) Clone() *ListImage {
	if m == nil {
		return nil
	}
	cloned := new(ListImage)
	*cloned = *m

	if m.SetComponents != nil {
		cloned.SetComponents = m.SetComponents.Clone()
	}
	if m.SetCves != nil {
		cloned.SetCves = m.SetCves.Clone()
	}
	if m.SetFixable != nil {
		cloned.SetFixable = m.SetFixable.Clone()
	}
	cloned.Created = m.Created.Clone()
	cloned.LastUpdated = m.LastUpdated.Clone()
	return cloned
}

type ImageComponentEdge struct {
	// base 64 encoded Image:Component ids.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	/// Layer that contains this component
	//
	// Types that are valid to be assigned to HasLayerIndex:
	//	*ImageComponentEdge_LayerIndex
	HasLayerIndex        isImageComponentEdge_HasLayerIndex `protobuf_oneof:"has_layer_index"`
	Location             string                             `protobuf:"bytes,3,opt,name=location,proto3" json:"location,omitempty" search:"Component Location,store,hidden"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *ImageComponentEdge) Reset()         { *m = ImageComponentEdge{} }
func (m *ImageComponentEdge) String() string { return proto.CompactTextString(m) }
func (*ImageComponentEdge) ProtoMessage()    {}
func (*ImageComponentEdge) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{16}
}
func (m *ImageComponentEdge) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImageComponentEdge) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImageComponentEdge.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImageComponentEdge) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageComponentEdge.Merge(m, src)
}
func (m *ImageComponentEdge) XXX_Size() int {
	return m.Size()
}
func (m *ImageComponentEdge) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageComponentEdge.DiscardUnknown(m)
}

var xxx_messageInfo_ImageComponentEdge proto.InternalMessageInfo

type isImageComponentEdge_HasLayerIndex interface {
	isImageComponentEdge_HasLayerIndex()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isImageComponentEdge_HasLayerIndex
}

type ImageComponentEdge_LayerIndex struct {
	LayerIndex int32 `protobuf:"varint,2,opt,name=layer_index,json=layerIndex,proto3,oneof" json:"layer_index,omitempty"`
}

func (*ImageComponentEdge_LayerIndex) isImageComponentEdge_HasLayerIndex() {}
func (m *ImageComponentEdge_LayerIndex) Clone() isImageComponentEdge_HasLayerIndex {
	if m == nil {
		return nil
	}
	cloned := new(ImageComponentEdge_LayerIndex)
	*cloned = *m

	return cloned
}

func (m *ImageComponentEdge) GetHasLayerIndex() isImageComponentEdge_HasLayerIndex {
	if m != nil {
		return m.HasLayerIndex
	}
	return nil
}

func (m *ImageComponentEdge) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ImageComponentEdge) GetLayerIndex() int32 {
	if x, ok := m.GetHasLayerIndex().(*ImageComponentEdge_LayerIndex); ok {
		return x.LayerIndex
	}
	return 0
}

func (m *ImageComponentEdge) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ImageComponentEdge) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ImageComponentEdge_LayerIndex)(nil),
	}
}

func (m *ImageComponentEdge) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ImageComponentEdge) Clone() *ImageComponentEdge {
	if m == nil {
		return nil
	}
	cloned := new(ImageComponentEdge)
	*cloned = *m

	if m.HasLayerIndex != nil {
		cloned.HasLayerIndex = m.HasLayerIndex.Clone()
	}
	return cloned
}

type ImageCVEEdge struct {
	// base 64 encoded Image:CVE ids.
	Id                   string             `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	FirstImageOccurrence *types.Timestamp   `protobuf:"bytes,2,opt,name=first_image_occurrence,json=firstImageOccurrence,proto3" json:"first_image_occurrence,omitempty" search:"First Image Occurrence Timestamp,hidden"`
	State                VulnerabilityState `protobuf:"varint,3,opt,name=state,proto3,enum=storage.VulnerabilityState" json:"state,omitempty" search:"Vulnerability State"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ImageCVEEdge) Reset()         { *m = ImageCVEEdge{} }
func (m *ImageCVEEdge) String() string { return proto.CompactTextString(m) }
func (*ImageCVEEdge) ProtoMessage()    {}
func (*ImageCVEEdge) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{17}
}
func (m *ImageCVEEdge) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImageCVEEdge) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImageCVEEdge.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImageCVEEdge) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageCVEEdge.Merge(m, src)
}
func (m *ImageCVEEdge) XXX_Size() int {
	return m.Size()
}
func (m *ImageCVEEdge) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageCVEEdge.DiscardUnknown(m)
}

var xxx_messageInfo_ImageCVEEdge proto.InternalMessageInfo

func (m *ImageCVEEdge) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ImageCVEEdge) GetFirstImageOccurrence() *types.Timestamp {
	if m != nil {
		return m.FirstImageOccurrence
	}
	return nil
}

func (m *ImageCVEEdge) GetState() VulnerabilityState {
	if m != nil {
		return m.State
	}
	return VulnerabilityState_OBSERVED
}

func (m *ImageCVEEdge) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ImageCVEEdge) Clone() *ImageCVEEdge {
	if m == nil {
		return nil
	}
	cloned := new(ImageCVEEdge)
	*cloned = *m

	cloned.FirstImageOccurrence = m.FirstImageOccurrence.Clone()
	return cloned
}

type WatchedImage struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WatchedImage) Reset()         { *m = WatchedImage{} }
func (m *WatchedImage) String() string { return proto.CompactTextString(m) }
func (*WatchedImage) ProtoMessage()    {}
func (*WatchedImage) Descriptor() ([]byte, []int) {
	return fileDescriptor_c926ac8b7cb24b2e, []int{18}
}
func (m *WatchedImage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WatchedImage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WatchedImage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WatchedImage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WatchedImage.Merge(m, src)
}
func (m *WatchedImage) XXX_Size() int {
	return m.Size()
}
func (m *WatchedImage) XXX_DiscardUnknown() {
	xxx_messageInfo_WatchedImage.DiscardUnknown(m)
}

var xxx_messageInfo_WatchedImage proto.InternalMessageInfo

func (m *WatchedImage) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *WatchedImage) MessageClone() proto.Message {
	return m.Clone()
}
func (m *WatchedImage) Clone() *WatchedImage {
	if m == nil {
		return nil
	}
	cloned := new(WatchedImage)
	*cloned = *m

	return cloned
}

func init() {
	proto.RegisterEnum("storage.SourceType", SourceType_name, SourceType_value)
	proto.RegisterEnum("storage.Image_Note", Image_Note_name, Image_Note_value)
	proto.RegisterEnum("storage.ImageScan_Note", ImageScan_Note_name, ImageScan_Note_value)
	proto.RegisterEnum("storage.ImageSignatureVerificationResult_Status", ImageSignatureVerificationResult_Status_name, ImageSignatureVerificationResult_Status_value)
	proto.RegisterType((*Image)(nil), "storage.Image")
	proto.RegisterType((*DataSource)(nil), "storage.DataSource")
	proto.RegisterType((*ImageScan)(nil), "storage.ImageScan")
	proto.RegisterType((*ImageSignatureVerificationData)(nil), "storage.ImageSignatureVerificationData")
	proto.RegisterType((*ImageSignatureVerificationResult)(nil), "storage.ImageSignatureVerificationResult")
	proto.RegisterType((*EmbeddedImageScanComponent)(nil), "storage.EmbeddedImageScanComponent")
	proto.RegisterType((*EmbeddedImageScanComponent_Executable)(nil), "storage.EmbeddedImageScanComponent.Executable")
	proto.RegisterType((*License)(nil), "storage.License")
	proto.RegisterType((*ImageMetadata)(nil), "storage.ImageMetadata")
	proto.RegisterType((*ImageSignature)(nil), "storage.ImageSignature")
	proto.RegisterType((*Signature)(nil), "storage.Signature")
	proto.RegisterType((*CosignSignature)(nil), "storage.CosignSignature")
	proto.RegisterType((*V2Metadata)(nil), "storage.V2Metadata")
	proto.RegisterType((*V1Metadata)(nil), "storage.V1Metadata")
	proto.RegisterMapType((map[string]string)(nil), "storage.V1Metadata.LabelsEntry")
	proto.RegisterType((*ImageLayer)(nil), "storage.ImageLayer")
	proto.RegisterType((*ImageName)(nil), "storage.ImageName")
	proto.RegisterType((*ListImage)(nil), "storage.ListImage")
	proto.RegisterType((*ImageComponentEdge)(nil), "storage.ImageComponentEdge")
	proto.RegisterType((*ImageCVEEdge)(nil), "storage.ImageCVEEdge")
	proto.RegisterType((*WatchedImage)(nil), "storage.WatchedImage")
}

func init() { proto.RegisterFile("storage/image.proto", fileDescriptor_c926ac8b7cb24b2e) }

var fileDescriptor_c926ac8b7cb24b2e = []byte{
	// 2384 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x58, 0x4d, 0x73, 0x1b, 0xc7,
	0xd1, 0xe6, 0xe2, 0x1b, 0x0d, 0x88, 0x5a, 0x8e, 0xf8, 0x4a, 0x10, 0x69, 0x71, 0x57, 0x4b, 0x7f,
	0xd0, 0x96, 0x0d, 0x49, 0xb4, 0xde, 0x4a, 0xec, 0x2a, 0x39, 0x05, 0x80, 0x2b, 0x12, 0x32, 0x04,
	0xb0, 0x06, 0x20, 0x5c, 0x8e, 0x0f, 0x5b, 0xcb, 0xdd, 0x21, 0xb8, 0x45, 0x60, 0x17, 0xb5, 0xb3,
	0xa0, 0x85, 0x1c, 0x73, 0xc8, 0x3d, 0x39, 0xe5, 0x07, 0xe4, 0x98, 0x53, 0xfe, 0x40, 0xae, 0x3e,
	0xfa, 0x17, 0xa0, 0x52, 0xce, 0x2d, 0x47, 0x9c, 0x93, 0xaa, 0xd4, 0xcc, 0x7e, 0x83, 0xa4, 0xc4,
	0xdc, 0x66, 0x7b, 0x9e, 0xee, 0x99, 0x9d, 0xee, 0xe9, 0x7e, 0x7a, 0xe0, 0x1e, 0xf5, 0x1c, 0x57,
	0x1f, 0x91, 0xa7, 0xd6, 0x44, 0x1f, 0x91, 0xfa, 0xd4, 0x75, 0x3c, 0x07, 0x15, 0x03, 0xe1, 0x96,
	0x34, 0x72, 0x9c, 0xd1, 0x98, 0x3c, 0xe5, 0xe2, 0xd3, 0xd9, 0xd9, 0x53, 0xcf, 0x9a, 0x10, 0xea,
	0xe9, 0x93, 0xa9, 0x8f, 0xdc, 0xda, 0x08, 0xd5, 0x8d, 0xcb, 0x40, 0x79, 0x6b, 0x3b, 0x14, 0x5d,
	0xce, 0xc6, 0x36, 0x71, 0xf5, 0x53, 0x6b, 0x6c, 0x79, 0xf3, 0x60, 0x72, 0x73, 0xe4, 0x8c, 0x1c,
	0x3e, 0x7c, 0xca, 0x46, 0xbe, 0x54, 0xf9, 0x7b, 0x09, 0xf2, 0x6d, 0xb6, 0x3e, 0xfa, 0x12, 0x32,
	0x96, 0x59, 0xcb, 0xc9, 0xc2, 0x5e, 0xb9, 0xb9, 0xbb, 0x5c, 0x48, 0x12, 0x25, 0xba, 0x6b, 0x9c,
	0x7f, 0xad, 0xf0, 0x69, 0xb9, 0x7f, 0xae, 0x7f, 0xce, 0xcc, 0x93, 0xcf, 0xcf, 0x2d, 0xd3, 0x24,
	0xb6, 0x82, 0x33, 0x96, 0x89, 0x3e, 0x86, 0x9c, 0xad, 0x4f, 0x48, 0x4d, 0x90, 0x85, 0xbd, 0xca,
	0x3e, 0xaa, 0x07, 0x1b, 0xa8, 0x73, 0x9d, 0xae, 0x3e, 0x21, 0x98, 0xcf, 0xa3, 0x7d, 0x28, 0x4d,
	0x88, 0xa7, 0x9b, 0xba, 0xa7, 0xd7, 0x32, 0x1c, 0x7b, 0x3f, 0x8d, 0x7d, 0x13, 0xcc, 0xe2, 0x08,
	0x87, 0x7e, 0x03, 0x39, 0x6a, 0xe8, 0x76, 0x2d, 0x7b, 0x9d, 0xed, 0xbe, 0xa1, 0xdb, 0xcd, 0x07,
	0xcb, 0x85, 0x74, 0x6f, 0xea, 0x8c, 0x2d, 0x63, 0x1e, 0x6d, 0xd3, 0xd0, 0x6d, 0x05, 0x73, 0x45,
	0x34, 0x82, 0x6d, 0x6a, 0x8d, 0x6c, 0xdd, 0x9b, 0xb9, 0x44, 0xbb, 0x24, 0xae, 0x75, 0x66, 0x19,
	0xba, 0x67, 0x39, 0xb6, 0xc6, 0xf7, 0x71, 0x97, 0xdb, 0xfd, 0x64, 0xc5, 0x6e, 0xa8, 0x30, 0x4c,
	0xe0, 0x0f, 0xd8, 0xc6, 0x1e, 0xd2, 0x9b, 0xa6, 0xd0, 0xff, 0x43, 0x39, 0x9a, 0xac, 0x89, 0xdc,
	0xec, 0x83, 0x1b, 0xcc, 0xe2, 0x18, 0x89, 0xbe, 0x05, 0x30, 0x9c, 0xc9, 0xd4, 0xb1, 0x89, 0xed,
	0xd1, 0x5a, 0x51, 0x16, 0xf6, 0xf2, 0xcd, 0x4f, 0x97, 0x0b, 0xe9, 0xa3, 0xf0, 0xe4, 0x5b, 0xe1,
	0xac, 0xdc, 0x72, 0x66, 0xb6, 0x97, 0x3e, 0xff, 0xa3, 0x35, 0x9c, 0x50, 0x47, 0x5f, 0x41, 0xce,
	0xb8, 0x24, 0xb4, 0x56, 0xe2, 0x66, 0x52, 0x0e, 0x6c, 0x0d, 0xd5, 0x6b, 0x0d, 0x08, 0x98, 0xab,
	0xa0, 0x63, 0xa8, 0x9e, 0x59, 0x6f, 0xf5, 0xd3, 0x31, 0xd1, 0xb8, 0x89, 0x32, 0x37, 0xf1, 0x64,
	0xb9, 0x90, 0x3e, 0x09, 0x4d, 0xbc, 0xf2, 0xe7, 0xe5, 0x9b, 0x4c, 0x65, 0x70, 0x25, 0x30, 0xd1,
	0x62, 0x16, 0x35, 0xa8, 0x8e, 0x75, 0xea, 0x69, 0xb3, 0xa9, 0xa9, 0x7b, 0xc4, 0xac, 0xe5, 0xf9,
	0x99, 0x6c, 0xd5, 0xfd, 0x98, 0xae, 0x87, 0x31, 0x5d, 0x1f, 0x84, 0x31, 0xdd, 0x94, 0x97, 0x0b,
	0xe9, 0x83, 0x70, 0xb5, 0x8e, 0x4e, 0x3d, 0xf9, 0xc4, 0xd7, 0x8d, 0xc2, 0xad, 0xc2, 0x2c, 0x06,
	0x42, 0xf4, 0x18, 0xaa, 0xb6, 0xe3, 0x69, 0xd3, 0xd9, 0x78, 0xcc, 0x16, 0xad, 0x81, 0x2c, 0xec,
	0x95, 0x70, 0xc5, 0x76, 0xbc, 0xe3, 0x40, 0x84, 0xf6, 0x40, 0xb4, 0xa8, 0x66, 0x8c, 0x67, 0xd4,
	0x23, 0xae, 0x36, 0x76, 0x0c, 0x7d, 0x5c, 0xdb, 0xe0, 0xb0, 0x75, 0x8b, 0xb6, 0x7c, 0x71, 0x87,
	0x49, 0xd1, 0x16, 0x94, 0xa6, 0xae, 0xe5, 0xb8, 0x96, 0x37, 0xaf, 0x55, 0x64, 0x61, 0x2f, 0x8b,
	0xa3, 0x6f, 0xf4, 0x12, 0xc0, 0xb5, 0xe8, 0x85, 0x46, 0x0d, 0xc7, 0x25, 0xb5, 0xaa, 0x2c, 0xec,
	0x65, 0x9a, 0x3b, 0xcb, 0x85, 0xb4, 0x15, 0xee, 0x15, 0x5b, 0xf4, 0x42, 0xee, 0x1b, 0xc9, 0x8b,
	0x51, 0x66, 0x1a, 0x5c, 0x84, 0xbe, 0x81, 0x92, 0xe7, 0x4c, 0x35, 0xe3, 0x92, 0xd2, 0xda, 0x1d,
	0xae, 0xfc, 0x78, 0xb9, 0x90, 0x1e, 0xa5, 0xaf, 0xd6, 0xc0, 0x99, 0xca, 0xad, 0x61, 0xbf, 0xef,
	0x9f, 0xa9, 0x72, 0x94, 0xc5, 0x45, 0xcf, 0x99, 0xb6, 0x2e, 0x29, 0x45, 0x9f, 0x42, 0xde, 0x76,
	0x3c, 0x42, 0x6b, 0xeb, 0x72, 0x76, 0x6f, 0x7d, 0xff, 0x5e, 0x3a, 0xaa, 0xea, 0x5d, 0xc7, 0x23,
	0xd8, 0x47, 0x28, 0x5f, 0x42, 0x8e, 0x7d, 0xa2, 0x4d, 0x10, 0xdf, 0xb4, 0xfb, 0xfd, 0x76, 0xf7,
	0x50, 0x7b, 0xa3, 0x0e, 0x1a, 0x07, 0x8d, 0x41, 0x43, 0x5c, 0x43, 0xff, 0x07, 0x1b, 0xa1, 0xb4,
	0xdf, 0x6a, 0x74, 0x35, 0x2e, 0x16, 0x9a, 0x22, 0xac, 0x53, 0xe2, 0x69, 0x71, 0x1c, 0x35, 0x01,
	0x4a, 0x5c, 0x72, 0x49, 0x68, 0xf3, 0x0e, 0x54, 0xd8, 0x38, 0xf0, 0x6c, 0x73, 0x1d, 0xaa, 0xec,
	0x33, 0xfc, 0xa1, 0xd7, 0xb9, 0x52, 0x41, 0x2c, 0x2a, 0xcf, 0x00, 0xd8, 0x25, 0xe8, 0x3b, 0x33,
	0xd7, 0x20, 0x68, 0x9d, 0x67, 0x11, 0x96, 0x0e, 0xca, 0x3c, 0x41, 0xa0, 0x20, 0x41, 0x64, 0xb8,
	0x84, 0x8f, 0x95, 0xbf, 0xe5, 0xa0, 0x1c, 0x5d, 0x62, 0xf4, 0x09, 0xdc, 0x65, 0xb7, 0xd5, 0x26,
	0x2e, 0xbb, 0xa3, 0xd4, 0x72, 0xec, 0x5a, 0x81, 0x83, 0xd7, 0x03, 0xf1, 0xd0, 0x97, 0xa2, 0x1f,
	0xa0, 0xcc, 0x24, 0x1a, 0x4b, 0x84, 0x41, 0xc2, 0x79, 0x57, 0x44, 0x29, 0xcb, 0x85, 0xb4, 0xb3,
	0x92, 0xc3, 0x0c, 0xdd, 0x96, 0x19, 0x22, 0x38, 0x69, 0x5c, 0x62, 0x06, 0x99, 0x00, 0xb5, 0x52,
	0x77, 0x31, 0x23, 0x67, 0xf7, 0x2a, 0xfb, 0xbb, 0xd1, 0x69, 0xab, 0x93, 0x53, 0x62, 0x9a, 0xc4,
	0x8c, 0x76, 0x1d, 0xdd, 0xcc, 0xd4, 0x1d, 0x7c, 0x05, 0xa2, 0x33, 0x25, 0xae, 0xee, 0x59, 0xf6,
	0x48, 0xa3, 0x73, 0xea, 0x91, 0x49, 0x90, 0x50, 0xb7, 0x97, 0x0b, 0xe9, 0x41, 0x7a, 0x33, 0xbd,
	0xd0, 0xdf, 0xf8, 0x6e, 0xa4, 0xd4, 0xe7, 0x3a, 0xe8, 0x05, 0x54, 0x58, 0x86, 0xd2, 0x28, 0x3f,
	0xd3, 0x20, 0x01, 0xc6, 0xbe, 0x8f, 0x8f, 0x1b, 0x83, 0x19, 0x1f, 0xfd, 0x17, 0x61, 0xac, 0xe4,
	0x79, 0xac, 0x3c, 0xb8, 0x9a, 0x30, 0x53, 0xf1, 0xf2, 0x57, 0x21, 0x08, 0x98, 0x32, 0xe4, 0x4f,
	0xba, 0x7d, 0x75, 0x20, 0xae, 0x21, 0x04, 0xeb, 0xbd, 0xbe, 0x76, 0xd2, 0x6d, 0x0c, 0x1b, 0xed,
	0x4e, 0xa3, 0xd9, 0x51, 0x45, 0x81, 0x45, 0xce, 0x71, 0x03, 0x0f, 0xda, 0x8d, 0x4e, 0x22, 0x72,
	0x32, 0xe8, 0x01, 0xdc, 0xeb, 0xf5, 0xb5, 0xd6, 0x50, 0x4d, 0xe3, 0xb3, 0x68, 0x03, 0xee, 0x84,
	0x13, 0xfd, 0x41, 0xa3, 0xa3, 0x8a, 0x39, 0xf4, 0x08, 0x1e, 0x76, 0x1a, 0xdd, 0xc3, 0x93, 0xc6,
	0xa1, 0x7a, 0x55, 0x23, 0x8f, 0x76, 0x41, 0x6a, 0xa9, 0x78, 0xd0, 0x7e, 0xd5, 0x56, 0x0f, 0x34,
	0x7c, 0xa4, 0x06, 0x0b, 0x25, 0x41, 0x05, 0x85, 0xc0, 0xce, 0xbb, 0x13, 0x34, 0x6a, 0x41, 0xd1,
	0x25, 0x74, 0x36, 0xf6, 0x68, 0x4d, 0xe0, 0xfe, 0xfb, 0xf4, 0x16, 0xa9, 0x1d, 0x73, 0x0d, 0x1c,
	0x6a, 0x2a, 0xff, 0xc9, 0x80, 0xfc, 0x3e, 0x34, 0x3a, 0x84, 0x8d, 0x54, 0x39, 0xb9, 0x5d, 0x44,
	0x62, 0x31, 0xa9, 0xc4, 0xa3, 0x4e, 0x82, 0x8a, 0x2f, 0x23, 0xae, 0x66, 0x99, 0xc1, 0x25, 0x81,
	0x50, 0xd4, 0x36, 0xd1, 0x11, 0x14, 0xa8, 0xa7, 0x7b, 0x33, 0xca, 0x83, 0x60, 0x7d, 0xff, 0xd9,
	0xad, 0x7f, 0xa9, 0xde, 0xe7, 0x7a, 0x38, 0xd0, 0x47, 0x32, 0x54, 0x4c, 0x42, 0x0d, 0xd7, 0x9a,
	0x32, 0x8c, 0x1f, 0x96, 0x38, 0x29, 0x52, 0x7e, 0x2f, 0x40, 0xc1, 0x57, 0x4a, 0x86, 0x44, 0x15,
	0x4a, 0x43, 0x15, 0x73, 0xdf, 0x88, 0x02, 0xf3, 0xfa, 0xab, 0x46, 0xbb, 0xa3, 0x1e, 0x68, 0xbe,
	0xb0, 0xd5, 0x18, 0xb4, 0x7b, 0x5d, 0x31, 0x83, 0xb6, 0xe0, 0x7e, 0xbb, 0x3b, 0x6c, 0x74, 0xda,
	0x07, 0x5a, 0xbf, 0x7d, 0xd8, 0x6d, 0x0c, 0x4e, 0xb0, 0xaa, 0x35, 0x3a, 0x87, 0x3d, 0x31, 0xcb,
	0x94, 0x5a, 0x3d, 0x8c, 0x4f, 0x8e, 0x07, 0x6a, 0x62, 0x56, 0xcc, 0xb1, 0x50, 0x39, 0x54, 0xbb,
	0x2a, 0x6e, 0xb7, 0x34, 0x15, 0xe3, 0x1e, 0x16, 0xf3, 0xca, 0x1f, 0xf3, 0xb0, 0x75, 0xf3, 0x6d,
	0x43, 0xcf, 0x12, 0x7c, 0xa3, 0xdc, 0xfc, 0x60, 0xb9, 0x90, 0x6a, 0x57, 0x8a, 0x65, 0x78, 0xad,
	0x7c, 0xe6, 0xf1, 0x0d, 0x14, 0xc3, 0xb4, 0xc2, 0x8f, 0xb7, 0xf9, 0xe1, 0x72, 0x21, 0xc9, 0x57,
	0x2b, 0x6c, 0x90, 0x65, 0x42, 0xe5, 0x50, 0x09, 0x7d, 0x06, 0xc5, 0xb1, 0x65, 0x10, 0x9b, 0x86,
	0xf7, 0x50, 0x8c, 0x5c, 0xd0, 0xf1, 0xe5, 0x38, 0x04, 0xa0, 0x17, 0x90, 0x67, 0xcc, 0x8b, 0xd6,
	0x72, 0x3c, 0xfe, 0x76, 0xae, 0xe4, 0x8f, 0x61, 0x92, 0x97, 0x61, 0x1f, 0x8c, 0x1e, 0x43, 0x65,
	0xac, 0xcf, 0x59, 0x04, 0xd8, 0x26, 0x79, 0xcb, 0x6b, 0x65, 0x9e, 0x15, 0x77, 0x2e, 0x6c, 0x33,
	0x59, 0xaa, 0x42, 0x15, 0x56, 0x2a, 0xd4, 0x13, 0x28, 0x04, 0x79, 0xa2, 0xc8, 0x43, 0x24, 0xce,
	0x13, 0x7e, 0x5e, 0x18, 0xcc, 0xa7, 0x04, 0x07, 0x10, 0x66, 0x88, 0x55, 0x42, 0x1e, 0x02, 0x25,
	0x1e, 0x02, 0xd1, 0x37, 0xda, 0x4e, 0xd4, 0x2a, 0x46, 0x01, 0x32, 0x47, 0x42, 0x5c, 0x88, 0x1e,
	0xa5, 0xea, 0x20, 0x2b, 0xb7, 0x99, 0x64, 0x9d, 0x7b, 0x08, 0xa5, 0x33, 0xeb, 0x2d, 0x31, 0xb5,
	0x53, 0xbf, 0x84, 0x96, 0x71, 0x91, 0x7f, 0x37, 0xe7, 0xe8, 0x3b, 0xa8, 0x90, 0xb7, 0xc4, 0x98,
	0x79, 0xac, 0x86, 0xd0, 0x5a, 0x95, 0x1f, 0x4d, 0xfd, 0x16, 0xa9, 0xb5, 0xae, 0x46, 0x6a, 0xcd,
	0xfc, 0xbf, 0x16, 0x92, 0xf0, 0x05, 0x4e, 0x5a, 0xda, 0x3a, 0x00, 0x88, 0x11, 0xac, 0xd0, 0x4c,
	0x75, 0xef, 0x3c, 0x28, 0x3d, 0x7c, 0x8c, 0x14, 0xa8, 0x9a, 0x64, 0x4a, 0x6c, 0x93, 0xd8, 0x86,
	0x45, 0xfc, 0xb4, 0x5e, 0xc6, 0x29, 0x59, 0x73, 0x03, 0xee, 0x9e, 0xeb, 0x54, 0x4b, 0x78, 0x60,
	0xb5, 0xce, 0x29, 0x2d, 0x28, 0x06, 0xae, 0x8e, 0xca, 0x99, 0x10, 0x97, 0x33, 0x26, 0xf3, 0xe6,
	0xd3, 0xa8, 0xc4, 0xb1, 0x31, 0x12, 0x21, 0x3b, 0x73, 0xc7, 0x3c, 0x62, 0xca, 0x98, 0x0d, 0x95,
	0x9f, 0x04, 0xb8, 0x93, 0x62, 0xba, 0x68, 0x17, 0x32, 0x97, 0xcf, 0x83, 0xb4, 0x11, 0x3b, 0x6d,
	0xf8, 0x3c, 0xa2, 0xc2, 0x99, 0xcb, 0xe7, 0x1c, 0xb4, 0x1f, 0x50, 0xe6, 0x04, 0x68, 0x3f, 0x01,
	0xda, 0x67, 0xce, 0xf1, 0xf7, 0x4f, 0xcf, 0x75, 0x96, 0x29, 0xd8, 0x5f, 0x96, 0xb9, 0xa4, 0x7f,
	0xae, 0xd3, 0xd5, 0x72, 0x92, 0xbb, 0x5d, 0x39, 0xa9, 0xc5, 0x17, 0x87, 0x85, 0x64, 0x2e, 0xba,
	0x12, 0xca, 0x01, 0xac, 0xa7, 0xb3, 0x0f, 0xda, 0x07, 0x88, 0x68, 0x6d, 0x98, 0x7d, 0x63, 0xc2,
	0x1e, 0x93, 0xdf, 0x04, 0x4a, 0xe9, 0x40, 0x39, 0x69, 0xa0, 0x60, 0x38, 0x6c, 0x32, 0x38, 0x8f,
	0x5a, 0xa4, 0xdc, 0xe2, 0xe2, 0x08, 0x79, 0xb4, 0x86, 0x03, 0x64, 0xb3, 0x92, 0x30, 0xa0, 0x18,
	0x70, 0x77, 0x05, 0x89, 0x76, 0xe1, 0x8e, 0xab, 0xff, 0xa8, 0xc5, 0xcc, 0x9c, 0x99, 0xae, 0xe2,
	0xaa, 0xab, 0xff, 0x18, 0x83, 0x9e, 0xc0, 0x46, 0xdc, 0x23, 0x4c, 0xf5, 0xf9, 0xd8, 0xd1, 0xfd,
	0x3c, 0x5c, 0xc5, 0x62, 0x34, 0x71, 0xec, 0xcb, 0x95, 0x0f, 0x01, 0xe2, 0x93, 0x47, 0xf7, 0xa1,
	0x60, 0x5a, 0x23, 0x42, 0xbd, 0x20, 0x1a, 0x82, 0x2f, 0x46, 0x6f, 0x20, 0xf6, 0xe2, 0x4d, 0x30,
	0xf4, 0x03, 0x14, 0x0d, 0x97, 0x70, 0x7a, 0x9c, 0x79, 0x2f, 0x99, 0xf9, 0x68, 0xb9, 0x90, 0x1e,
	0xa7, 0xf9, 0x43, 0xcb, 0x57, 0x4e, 0xf1, 0x99, 0xd0, 0x22, 0x5b, 0x54, 0x9f, 0x79, 0xe7, 0x8e,
	0x1b, 0x84, 0x60, 0xf0, 0xc5, 0x92, 0x05, 0x8f, 0x8b, 0x30, 0x45, 0xad, 0x10, 0xca, 0x0e, 0x9b,
	0xc3, 0x01, 0x04, 0x3d, 0x81, 0xdc, 0x8c, 0x12, 0x97, 0xbb, 0xbf, 0xec, 0x37, 0x5b, 0xe9, 0x2d,
	0x9c, 0x50, 0xe2, 0x2a, 0x98, 0x83, 0xd0, 0x0b, 0x28, 0x1a, 0xce, 0x64, 0xa2, 0xdb, 0x66, 0xad,
	0xc0, 0x02, 0xb0, 0xb9, 0xb5, 0x5c, 0x48, 0xf7, 0x57, 0xb6, 0xec, 0x03, 0xd8, 0x3e, 0xfd, 0x11,
	0xa3, 0xd7, 0xc4, 0xf6, 0xdc, 0xf9, 0xd4, 0xb1, 0x6c, 0xaf, 0x56, 0xe4, 0x8a, 0x8f, 0x96, 0x0b,
	0xe9, 0x61, 0x5a, 0x51, 0x8d, 0x30, 0x0a, 0x4e, 0x28, 0xb0, 0x45, 0x2f, 0x9d, 0xf1, 0x6c, 0xc2,
	0xfb, 0x9e, 0x1b, 0x16, 0x1d, 0xfa, 0x00, 0x96, 0xd2, 0xfd, 0x11, 0xfa, 0x8e, 0x1d, 0xc2, 0x29,
	0x19, 0xb3, 0x34, 0xc7, 0x0e, 0x41, 0xba, 0xe6, 0xf2, 0xd5, 0x3b, 0x1c, 0xc1, 0x17, 0x4e, 0x13,
	0x7e, 0xdf, 0x2a, 0x9f, 0x0e, 0x8f, 0x3d, 0x30, 0xb7, 0xf5, 0x15, 0x54, 0x12, 0x6a, 0x2c, 0x09,
	0x5c, 0x90, 0x79, 0xe0, 0x76, 0x36, 0x44, 0x9b, 0x90, 0xbf, 0xd4, 0xc7, 0xb3, 0x30, 0x57, 0xf8,
	0x1f, 0x5f, 0x67, 0x7e, 0x2d, 0x28, 0x7f, 0xca, 0x00, 0xc4, 0x2e, 0x40, 0x7d, 0xa8, 0x58, 0x36,
	0xf5, 0xdc, 0x99, 0xc1, 0x53, 0xb5, 0x5f, 0xee, 0x9e, 0x2f, 0x17, 0xd2, 0x17, 0xe1, 0x36, 0x0e,
	0x1c, 0xe3, 0x82, 0xb8, 0x67, 0xd6, 0x98, 0xc8, 0xed, 0x18, 0x29, 0x7f, 0x4b, 0xe6, 0x3f, 0x3a,
	0xae, 0x19, 0xee, 0x2c, 0x69, 0x05, 0xa9, 0xa9, 0xd5, 0x9b, 0x4f, 0x97, 0x0b, 0xe9, 0xc9, 0x7b,
	0xcc, 0x0d, 0x19, 0x3e, 0x34, 0xe6, 0x6b, 0x73, 0x4f, 0x07, 0x81, 0x9b, 0x7d, 0x2f, 0xe7, 0xb9,
	0x26, 0x22, 0x73, 0xa9, 0x88, 0xdc, 0x84, 0x3c, 0x99, 0x4c, 0x83, 0xba, 0x56, 0xc2, 0xfe, 0xc7,
	0xeb, 0x5c, 0x29, 0x2f, 0x16, 0x94, 0x7f, 0x0b, 0x41, 0xa3, 0xd0, 0x65, 0x79, 0xf6, 0x25, 0x94,
	0x5c, 0x32, 0xb2, 0xa8, 0xe7, 0x06, 0x67, 0x7a, 0x5d, 0x2f, 0x85, 0x03, 0x44, 0xc4, 0xf0, 0x43,
	0x15, 0xf4, 0x2b, 0x28, 0xb8, 0x64, 0xe2, 0x78, 0xe1, 0xef, 0x4b, 0xcb, 0x85, 0xb4, 0xbd, 0xaa,
	0xcc, 0xe6, 0x23, 0xaf, 0xfa, 0x70, 0x54, 0x87, 0xac, 0xa7, 0x8f, 0xfc, 0x8b, 0x94, 0xa6, 0x1c,
	0x41, 0xfb, 0xa6, 0x8f, 0x42, 0x15, 0x06, 0x44, 0x87, 0x50, 0x3e, 0x9b, 0x8d, 0xc7, 0x1a, 0x2f,
	0x14, 0x3e, 0xfd, 0xff, 0x6c, 0xb9, 0x90, 0x3e, 0x4e, 0x69, 0x05, 0xfd, 0xb3, 0x6e, 0xeb, 0xe3,
	0xf9, 0xef, 0x88, 0xfb, 0x92, 0x7a, 0xba, 0x6d, 0xea, 0xae, 0xa9, 0xe0, 0x12, 0x53, 0x66, 0x3f,
	0xac, 0xfc, 0x9c, 0x81, 0x72, 0xc7, 0xa2, 0x9e, 0xff, 0x3e, 0xe3, 0x77, 0x56, 0xc5, 0x77, 0x75,
	0x56, 0x48, 0x4e, 0x75, 0x31, 0xd9, 0x90, 0x49, 0x24, 0x5a, 0x94, 0xcd, 0xe0, 0x99, 0x20, 0xc7,
	0xe7, 0xc2, 0x17, 0x80, 0xdd, 0x95, 0x17, 0x00, 0x9f, 0x83, 0xac, 0x34, 0xf5, 0x09, 0xbf, 0x17,
	0x6e, 0xef, 0xf7, 0x97, 0x2b, 0x4f, 0x01, 0xa5, 0xf7, 0xaa, 0xa6, 0x1a, 0xfd, 0x24, 0xf3, 0x81,
	0x34, 0xf3, 0xf9, 0x9f, 0x9a, 0xd7, 0xd7, 0xb9, 0x52, 0x59, 0x04, 0xe5, 0x2f, 0x02, 0x20, 0x7e,
	0x9c, 0x11, 0xcb, 0x50, 0xcd, 0xd1, 0xd5, 0xae, 0x75, 0x85, 0x92, 0x65, 0xae, 0xa1, 0x64, 0x47,
	0x09, 0x26, 0xe5, 0x87, 0xc6, 0xe7, 0xcb, 0x85, 0xb4, 0x77, 0x95, 0x58, 0x76, 0x02, 0xd4, 0xca,
	0xeb, 0x59, 0xa4, 0x7d, 0x0d, 0x03, 0x61, 0x81, 0x5f, 0xf5, 0xb7, 0x39, 0x54, 0xaf, 0xdd, 0xe0,
	0x1f, 0x04, 0xb8, 0x7f, 0x66, 0xb9, 0xd4, 0xd3, 0xf8, 0xe3, 0xa1, 0xe6, 0x18, 0xc6, 0xcc, 0x75,
	0x89, 0x6d, 0x90, 0x5b, 0x14, 0x93, 0x17, 0xcb, 0x85, 0xf4, 0x2c, 0x7e, 0xd9, 0x71, 0xa9, 0x27,
	0x07, 0x2d, 0x69, 0x64, 0x45, 0x8e, 0xd0, 0xd1, 0x86, 0x37, 0xf9, 0x7a, 0x1c, 0x18, 0xe3, 0x50,
	0x1f, 0xf2, 0xac, 0xc1, 0x20, 0x41, 0x7f, 0xb2, 0x1d, 0xa7, 0xd2, 0x24, 0xd5, 0x65, 0x6d, 0x05,
	0x49, 0xbf, 0xf1, 0xa4, 0xe6, 0x65, 0x0e, 0x50, 0xb0, 0x6f, 0x4b, 0x51, 0xa0, 0xfa, 0x9d, 0xee,
	0x19, 0xe7, 0x01, 0x2b, 0xbc, 0x8e, 0x75, 0x7d, 0x76, 0x01, 0x10, 0xf3, 0x5b, 0x54, 0x80, 0x4c,
	0xaf, 0x2f, 0xae, 0x21, 0x80, 0xc2, 0xf1, 0xf7, 0x83, 0xa3, 0x5e, 0x57, 0x14, 0x50, 0x09, 0x72,
	0xaf, 0x1b, 0x43, 0xd6, 0xab, 0x96, 0x20, 0x87, 0x4f, 0x9a, 0xdf, 0x8b, 0x59, 0x36, 0xdf, 0xed,
	0x1d, 0xa8, 0xaf, 0xfb, 0x62, 0x8e, 0x35, 0xb6, 0x07, 0xbd, 0x41, 0x57, 0x1d, 0xb4, 0x7a, 0x58,
	0xc5, 0x27, 0xdd, 0x41, 0xfb, 0x0d, 0xeb, 0x46, 0x11, 0xac, 0xb7, 0xbb, 0xaf, 0x70, 0xa3, 0x3f,
	0xc0, 0x27, 0x2d, 0xde, 0xa8, 0x14, 0x9a, 0x2f, 0x7e, 0xfa, 0x65, 0x47, 0xf8, 0xf9, 0x97, 0x1d,
	0xe1, 0x1f, 0xbf, 0xec, 0x08, 0x7f, 0xfe, 0xe7, 0xce, 0x1a, 0x3c, 0xb4, 0x9c, 0x3a, 0xf5, 0x74,
	0xe3, 0xc2, 0x75, 0xde, 0xfa, 0x67, 0x1c, 0xfe, 0xf9, 0x6f, 0xc3, 0x27, 0xdc, 0xd3, 0x02, 0x97,
	0x7f, 0xf9, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x50, 0x54, 0x1f, 0xca, 0xe9, 0x15, 0x00, 0x00,
}

func (m *Image) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Image) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Image) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IsClusterLocal {
		i--
		if m.IsClusterLocal {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x88
	}
	if m.Signature != nil {
		{
			size, err := m.Signature.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if m.SignatureVerificationData != nil {
		{
			size, err := m.SignatureVerificationData.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x7a
	}
	if len(m.Notes) > 0 {
		dAtA4 := make([]byte, len(m.Notes)*10)
		var j3 int
		for _, num := range m.Notes {
			for num >= 1<<7 {
				dAtA4[j3] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j3++
			}
			dAtA4[j3] = uint8(num)
			j3++
		}
		i -= j3
		copy(dAtA[i:], dAtA4[:j3])
		i = encodeVarintImage(dAtA, i, uint64(j3))
		i--
		dAtA[i] = 0x72
	}
	if m.SetTopCvss != nil {
		{
			size := m.SetTopCvss.Size()
			i -= size
			if _, err := m.SetTopCvss.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.RiskScore != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.RiskScore))))
		i--
		dAtA[i] = 0x65
	}
	if m.Priority != 0 {
		i = encodeVarintImage(dAtA, i, uint64(m.Priority))
		i--
		dAtA[i] = 0x58
	}
	if m.NotPullable {
		i--
		if m.NotPullable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if m.SetFixable != nil {
		{
			size := m.SetFixable.Size()
			i -= size
			if _, err := m.SetFixable.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.SetCves != nil {
		{
			size := m.SetCves.Size()
			i -= size
			if _, err := m.SetCves.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.SetComponents != nil {
		{
			size := m.SetComponents.Size()
			i -= size
			if _, err := m.SetComponents.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.LastUpdated != nil {
		{
			size, err := m.LastUpdated.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0x22
	}
	if m.Scan != nil {
		{
			size, err := m.Scan.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Name != nil {
		{
			size, err := m.Name.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Image_Components) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Image_Components) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintImage(dAtA, i, uint64(m.Components))
	i--
	dAtA[i] = 0x38
	return len(dAtA) - i, nil
}
func (m *Image_Cves) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Image_Cves) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintImage(dAtA, i, uint64(m.Cves))
	i--
	dAtA[i] = 0x40
	return len(dAtA) - i, nil
}
func (m *Image_FixableCves) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Image_FixableCves) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintImage(dAtA, i, uint64(m.FixableCves))
	i--
	dAtA[i] = 0x48
	return len(dAtA) - i, nil
}
func (m *Image_TopCvss) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Image_TopCvss) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 4
	encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.TopCvss))))
	i--
	dAtA[i] = 0x6d
	return len(dAtA) - i, nil
}
func (m *DataSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DataSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ImageScan) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImageScan) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageScan) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ScannerVersion) > 0 {
		i -= len(m.ScannerVersion)
		copy(dAtA[i:], m.ScannerVersion)
		i = encodeVarintImage(dAtA, i, uint64(len(m.ScannerVersion)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Notes) > 0 {
		dAtA10 := make([]byte, len(m.Notes)*10)
		var j9 int
		for _, num := range m.Notes {
			for num >= 1<<7 {
				dAtA10[j9] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j9++
			}
			dAtA10[j9] = uint8(num)
			j9++
		}
		i -= j9
		copy(dAtA[i:], dAtA10[:j9])
		i = encodeVarintImage(dAtA, i, uint64(j9))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.OperatingSystem) > 0 {
		i -= len(m.OperatingSystem)
		copy(dAtA[i:], m.OperatingSystem)
		i = encodeVarintImage(dAtA, i, uint64(len(m.OperatingSystem)))
		i--
		dAtA[i] = 0x22
	}
	if m.DataSource != nil {
		{
			size, err := m.DataSource.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Components) > 0 {
		for iNdEx := len(m.Components) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Components[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintImage(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.ScanTime != nil {
		{
			size, err := m.ScanTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ImageSignatureVerificationData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImageSignatureVerificationData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageSignatureVerificationData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Results) > 0 {
		for iNdEx := len(m.Results) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Results[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintImage(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ImageSignatureVerificationResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImageSignatureVerificationResult) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageSignatureVerificationResult) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if m.Status != 0 {
		i = encodeVarintImage(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x18
	}
	if len(m.VerifierId) > 0 {
		i -= len(m.VerifierId)
		copy(dAtA[i:], m.VerifierId)
		i = encodeVarintImage(dAtA, i, uint64(len(m.VerifierId)))
		i--
		dAtA[i] = 0x12
	}
	if m.VerificationTime != nil {
		{
			size, err := m.VerificationTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EmbeddedImageScanComponent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EmbeddedImageScanComponent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EmbeddedImageScanComponent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Executables) > 0 {
		for iNdEx := len(m.Executables) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Executables[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintImage(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x62
		}
	}
	if len(m.FixedBy) > 0 {
		i -= len(m.FixedBy)
		copy(dAtA[i:], m.FixedBy)
		i = encodeVarintImage(dAtA, i, uint64(len(m.FixedBy)))
		i--
		dAtA[i] = 0x5a
	}
	if m.RiskScore != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.RiskScore))))
		i--
		dAtA[i] = 0x55
	}
	if m.SetTopCvss != nil {
		{
			size := m.SetTopCvss.Size()
			i -= size
			if _, err := m.SetTopCvss.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Location) > 0 {
		i -= len(m.Location)
		copy(dAtA[i:], m.Location)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Location)))
		i--
		dAtA[i] = 0x42
	}
	if m.Source != 0 {
		i = encodeVarintImage(dAtA, i, uint64(m.Source))
		i--
		dAtA[i] = 0x38
	}
	if m.Priority != 0 {
		i = encodeVarintImage(dAtA, i, uint64(m.Priority))
		i--
		dAtA[i] = 0x30
	}
	if m.HasLayerIndex != nil {
		{
			size := m.HasLayerIndex.Size()
			i -= size
			if _, err := m.HasLayerIndex.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Vulns) > 0 {
		for iNdEx := len(m.Vulns) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Vulns[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintImage(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.License != nil {
		{
			size, err := m.License.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EmbeddedImageScanComponent_LayerIndex) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EmbeddedImageScanComponent_LayerIndex) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintImage(dAtA, i, uint64(m.LayerIndex))
	i--
	dAtA[i] = 0x28
	return len(dAtA) - i, nil
}
func (m *EmbeddedImageScanComponent_TopCvss) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EmbeddedImageScanComponent_TopCvss) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 4
	encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.TopCvss))))
	i--
	dAtA[i] = 0x4d
	return len(dAtA) - i, nil
}
func (m *EmbeddedImageScanComponent_Executable) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EmbeddedImageScanComponent_Executable) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EmbeddedImageScanComponent_Executable) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Dependencies) > 0 {
		for iNdEx := len(m.Dependencies) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Dependencies[iNdEx])
			copy(dAtA[i:], m.Dependencies[iNdEx])
			i = encodeVarintImage(dAtA, i, uint64(len(m.Dependencies[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *License) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *License) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *License) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ImageMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImageMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Version != 0 {
		i = encodeVarintImage(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x28
	}
	if m.DataSource != nil {
		{
			size, err := m.DataSource.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.LayerShas) > 0 {
		for iNdEx := len(m.LayerShas) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.LayerShas[iNdEx])
			copy(dAtA[i:], m.LayerShas[iNdEx])
			i = encodeVarintImage(dAtA, i, uint64(len(m.LayerShas[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.V2 != nil {
		{
			size, err := m.V2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.V1 != nil {
		{
			size, err := m.V1.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ImageSignature) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImageSignature) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageSignature) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Signatures) > 0 {
		for iNdEx := len(m.Signatures) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Signatures[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintImage(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Signature) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Signature) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Signature) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Signature != nil {
		{
			size := m.Signature.Size()
			i -= size
			if _, err := m.Signature.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *Signature_Cosign) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Signature_Cosign) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Cosign != nil {
		{
			size, err := m.Cosign.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *CosignSignature) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CosignSignature) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CosignSignature) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.SignaturePayload) > 0 {
		i -= len(m.SignaturePayload)
		copy(dAtA[i:], m.SignaturePayload)
		i = encodeVarintImage(dAtA, i, uint64(len(m.SignaturePayload)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.RawSignature) > 0 {
		i -= len(m.RawSignature)
		copy(dAtA[i:], m.RawSignature)
		i = encodeVarintImage(dAtA, i, uint64(len(m.RawSignature)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *V2Metadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *V2Metadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *V2Metadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Digest) > 0 {
		i -= len(m.Digest)
		copy(dAtA[i:], m.Digest)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Digest)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *V1Metadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *V1Metadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *V1Metadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintImage(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintImage(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintImage(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.Volumes) > 0 {
		for iNdEx := len(m.Volumes) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Volumes[iNdEx])
			copy(dAtA[i:], m.Volumes[iNdEx])
			i = encodeVarintImage(dAtA, i, uint64(len(m.Volumes[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.Entrypoint) > 0 {
		for iNdEx := len(m.Entrypoint) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Entrypoint[iNdEx])
			copy(dAtA[i:], m.Entrypoint[iNdEx])
			i = encodeVarintImage(dAtA, i, uint64(len(m.Entrypoint[iNdEx])))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.Command) > 0 {
		for iNdEx := len(m.Command) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Command[iNdEx])
			copy(dAtA[i:], m.Command[iNdEx])
			i = encodeVarintImage(dAtA, i, uint64(len(m.Command[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.User) > 0 {
		i -= len(m.User)
		copy(dAtA[i:], m.User)
		i = encodeVarintImage(dAtA, i, uint64(len(m.User)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Layers) > 0 {
		for iNdEx := len(m.Layers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Layers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintImage(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Author) > 0 {
		i -= len(m.Author)
		copy(dAtA[i:], m.Author)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Author)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Created != nil {
		{
			size, err := m.Created.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Digest) > 0 {
		i -= len(m.Digest)
		copy(dAtA[i:], m.Digest)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Digest)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ImageLayer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImageLayer) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageLayer) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Empty {
		i--
		if m.Empty {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if len(m.Author) > 0 {
		i -= len(m.Author)
		copy(dAtA[i:], m.Author)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Author)))
		i--
		dAtA[i] = 0x22
	}
	if m.Created != nil {
		{
			size, err := m.Created.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Instruction) > 0 {
		i -= len(m.Instruction)
		copy(dAtA[i:], m.Instruction)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Instruction)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ImageName) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImageName) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageName) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.FullName) > 0 {
		i -= len(m.FullName)
		copy(dAtA[i:], m.FullName)
		i = encodeVarintImage(dAtA, i, uint64(len(m.FullName)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Tag) > 0 {
		i -= len(m.Tag)
		copy(dAtA[i:], m.Tag)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Tag)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Remote) > 0 {
		i -= len(m.Remote)
		copy(dAtA[i:], m.Remote)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Remote)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Registry) > 0 {
		i -= len(m.Registry)
		copy(dAtA[i:], m.Registry)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Registry)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListImage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListImage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListImage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Priority != 0 {
		i = encodeVarintImage(dAtA, i, uint64(m.Priority))
		i--
		dAtA[i] = 0x50
	}
	if m.LastUpdated != nil {
		{
			size, err := m.LastUpdated.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0x3a
	}
	if m.Created != nil {
		{
			size, err := m.Created.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.SetFixable != nil {
		{
			size := m.SetFixable.Size()
			i -= size
			if _, err := m.SetFixable.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.SetCves != nil {
		{
			size := m.SetCves.Size()
			i -= size
			if _, err := m.SetCves.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.SetComponents != nil {
		{
			size := m.SetComponents.Size()
			i -= size
			if _, err := m.SetComponents.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}

func (m *ListImage_Components) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListImage_Components) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintImage(dAtA, i, uint64(m.Components))
	i--
	dAtA[i] = 0x18
	return len(dAtA) - i, nil
}
func (m *ListImage_Cves) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListImage_Cves) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintImage(dAtA, i, uint64(m.Cves))
	i--
	dAtA[i] = 0x20
	return len(dAtA) - i, nil
}
func (m *ListImage_FixableCves) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListImage_FixableCves) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintImage(dAtA, i, uint64(m.FixableCves))
	i--
	dAtA[i] = 0x28
	return len(dAtA) - i, nil
}
func (m *ImageComponentEdge) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImageComponentEdge) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageComponentEdge) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Location) > 0 {
		i -= len(m.Location)
		copy(dAtA[i:], m.Location)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Location)))
		i--
		dAtA[i] = 0x1a
	}
	if m.HasLayerIndex != nil {
		{
			size := m.HasLayerIndex.Size()
			i -= size
			if _, err := m.HasLayerIndex.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ImageComponentEdge_LayerIndex) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageComponentEdge_LayerIndex) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintImage(dAtA, i, uint64(m.LayerIndex))
	i--
	dAtA[i] = 0x10
	return len(dAtA) - i, nil
}
func (m *ImageCVEEdge) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImageCVEEdge) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageCVEEdge) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.State != 0 {
		i = encodeVarintImage(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x18
	}
	if m.FirstImageOccurrence != nil {
		{
			size, err := m.FirstImageOccurrence.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WatchedImage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WatchedImage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WatchedImage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintImage(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintImage(dAtA []byte, offset int, v uint64) int {
	offset -= sovImage(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Image) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = m.Name.Size()
		n += 1 + l + sovImage(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovImage(uint64(l))
	}
	if m.Scan != nil {
		l = m.Scan.Size()
		n += 1 + l + sovImage(uint64(l))
	}
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.LastUpdated != nil {
		l = m.LastUpdated.Size()
		n += 1 + l + sovImage(uint64(l))
	}
	if m.SetComponents != nil {
		n += m.SetComponents.Size()
	}
	if m.SetCves != nil {
		n += m.SetCves.Size()
	}
	if m.SetFixable != nil {
		n += m.SetFixable.Size()
	}
	if m.NotPullable {
		n += 2
	}
	if m.Priority != 0 {
		n += 1 + sovImage(uint64(m.Priority))
	}
	if m.RiskScore != 0 {
		n += 5
	}
	if m.SetTopCvss != nil {
		n += m.SetTopCvss.Size()
	}
	if len(m.Notes) > 0 {
		l = 0
		for _, e := range m.Notes {
			l += sovImage(uint64(e))
		}
		n += 1 + sovImage(uint64(l)) + l
	}
	if m.SignatureVerificationData != nil {
		l = m.SignatureVerificationData.Size()
		n += 1 + l + sovImage(uint64(l))
	}
	if m.Signature != nil {
		l = m.Signature.Size()
		n += 2 + l + sovImage(uint64(l))
	}
	if m.IsClusterLocal {
		n += 3
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Image_Components) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovImage(uint64(m.Components))
	return n
}
func (m *Image_Cves) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovImage(uint64(m.Cves))
	return n
}
func (m *Image_FixableCves) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovImage(uint64(m.FixableCves))
	return n
}
func (m *Image_TopCvss) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 5
	return n
}
func (m *DataSource) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ImageScan) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ScanTime != nil {
		l = m.ScanTime.Size()
		n += 1 + l + sovImage(uint64(l))
	}
	if len(m.Components) > 0 {
		for _, e := range m.Components {
			l = e.Size()
			n += 1 + l + sovImage(uint64(l))
		}
	}
	if m.DataSource != nil {
		l = m.DataSource.Size()
		n += 1 + l + sovImage(uint64(l))
	}
	l = len(m.OperatingSystem)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if len(m.Notes) > 0 {
		l = 0
		for _, e := range m.Notes {
			l += sovImage(uint64(e))
		}
		n += 1 + sovImage(uint64(l)) + l
	}
	l = len(m.ScannerVersion)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ImageSignatureVerificationData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Results) > 0 {
		for _, e := range m.Results {
			l = e.Size()
			n += 1 + l + sovImage(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ImageSignatureVerificationResult) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.VerificationTime != nil {
		l = m.VerificationTime.Size()
		n += 1 + l + sovImage(uint64(l))
	}
	l = len(m.VerifierId)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovImage(uint64(m.Status))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EmbeddedImageScanComponent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.License != nil {
		l = m.License.Size()
		n += 1 + l + sovImage(uint64(l))
	}
	if len(m.Vulns) > 0 {
		for _, e := range m.Vulns {
			l = e.Size()
			n += 1 + l + sovImage(uint64(l))
		}
	}
	if m.HasLayerIndex != nil {
		n += m.HasLayerIndex.Size()
	}
	if m.Priority != 0 {
		n += 1 + sovImage(uint64(m.Priority))
	}
	if m.Source != 0 {
		n += 1 + sovImage(uint64(m.Source))
	}
	l = len(m.Location)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.SetTopCvss != nil {
		n += m.SetTopCvss.Size()
	}
	if m.RiskScore != 0 {
		n += 5
	}
	l = len(m.FixedBy)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if len(m.Executables) > 0 {
		for _, e := range m.Executables {
			l = e.Size()
			n += 1 + l + sovImage(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EmbeddedImageScanComponent_LayerIndex) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovImage(uint64(m.LayerIndex))
	return n
}
func (m *EmbeddedImageScanComponent_TopCvss) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 5
	return n
}
func (m *EmbeddedImageScanComponent_Executable) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if len(m.Dependencies) > 0 {
		for _, s := range m.Dependencies {
			l = len(s)
			n += 1 + l + sovImage(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *License) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ImageMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.V1 != nil {
		l = m.V1.Size()
		n += 1 + l + sovImage(uint64(l))
	}
	if m.V2 != nil {
		l = m.V2.Size()
		n += 1 + l + sovImage(uint64(l))
	}
	if len(m.LayerShas) > 0 {
		for _, s := range m.LayerShas {
			l = len(s)
			n += 1 + l + sovImage(uint64(l))
		}
	}
	if m.DataSource != nil {
		l = m.DataSource.Size()
		n += 1 + l + sovImage(uint64(l))
	}
	if m.Version != 0 {
		n += 1 + sovImage(uint64(m.Version))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ImageSignature) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Signatures) > 0 {
		for _, e := range m.Signatures {
			l = e.Size()
			n += 1 + l + sovImage(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Signature) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Signature != nil {
		n += m.Signature.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Signature_Cosign) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Cosign != nil {
		l = m.Cosign.Size()
		n += 1 + l + sovImage(uint64(l))
	}
	return n
}
func (m *CosignSignature) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.RawSignature)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	l = len(m.SignaturePayload)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *V2Metadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Digest)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *V1Metadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Digest)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.Created != nil {
		l = m.Created.Size()
		n += 1 + l + sovImage(uint64(l))
	}
	l = len(m.Author)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if len(m.Layers) > 0 {
		for _, e := range m.Layers {
			l = e.Size()
			n += 1 + l + sovImage(uint64(l))
		}
	}
	l = len(m.User)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if len(m.Command) > 0 {
		for _, s := range m.Command {
			l = len(s)
			n += 1 + l + sovImage(uint64(l))
		}
	}
	if len(m.Entrypoint) > 0 {
		for _, s := range m.Entrypoint {
			l = len(s)
			n += 1 + l + sovImage(uint64(l))
		}
	}
	if len(m.Volumes) > 0 {
		for _, s := range m.Volumes {
			l = len(s)
			n += 1 + l + sovImage(uint64(l))
		}
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovImage(uint64(len(k))) + 1 + len(v) + sovImage(uint64(len(v)))
			n += mapEntrySize + 1 + sovImage(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ImageLayer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Instruction)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.Created != nil {
		l = m.Created.Size()
		n += 1 + l + sovImage(uint64(l))
	}
	l = len(m.Author)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.Empty {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ImageName) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Registry)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	l = len(m.Remote)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	l = len(m.Tag)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	l = len(m.FullName)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListImage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.SetComponents != nil {
		n += m.SetComponents.Size()
	}
	if m.SetCves != nil {
		n += m.SetCves.Size()
	}
	if m.SetFixable != nil {
		n += m.SetFixable.Size()
	}
	if m.Created != nil {
		l = m.Created.Size()
		n += 1 + l + sovImage(uint64(l))
	}
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.LastUpdated != nil {
		l = m.LastUpdated.Size()
		n += 1 + l + sovImage(uint64(l))
	}
	if m.Priority != 0 {
		n += 1 + sovImage(uint64(m.Priority))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListImage_Components) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovImage(uint64(m.Components))
	return n
}
func (m *ListImage_Cves) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovImage(uint64(m.Cves))
	return n
}
func (m *ListImage_FixableCves) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovImage(uint64(m.FixableCves))
	return n
}
func (m *ImageComponentEdge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.HasLayerIndex != nil {
		n += m.HasLayerIndex.Size()
	}
	l = len(m.Location)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ImageComponentEdge_LayerIndex) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovImage(uint64(m.LayerIndex))
	return n
}
func (m *ImageCVEEdge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.FirstImageOccurrence != nil {
		l = m.FirstImageOccurrence.Size()
		n += 1 + l + sovImage(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovImage(uint64(m.State))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WatchedImage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovImage(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovImage(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozImage(x uint64) (n int) {
	return sovImage(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Image) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Image: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Image: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Name == nil {
				m.Name = &ImageName{}
			}
			if err := m.Name.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &ImageMetadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Scan == nil {
				m.Scan = &ImageScan{}
			}
			if err := m.Scan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastUpdated == nil {
				m.LastUpdated = &types.Timestamp{}
			}
			if err := m.LastUpdated.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Components", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SetComponents = &Image_Components{v}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cves", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SetCves = &Image_Cves{v}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FixableCves", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SetFixable = &Image_FixableCves{v}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotPullable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NotPullable = bool(v != 0)
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priority", wireType)
			}
			m.Priority = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Priority |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field RiskScore", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.RiskScore = float32(math.Float32frombits(v))
		case 13:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field TopCvss", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.SetTopCvss = &Image_TopCvss{float32(math.Float32frombits(v))}
		case 14:
			if wireType == 0 {
				var v Image_Note
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowImage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= Image_Note(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Notes = append(m.Notes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowImage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthImage
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthImage
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.Notes) == 0 {
					m.Notes = make([]Image_Note, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v Image_Note
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowImage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= Image_Note(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Notes = append(m.Notes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Notes", wireType)
			}
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SignatureVerificationData", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SignatureVerificationData == nil {
				m.SignatureVerificationData = &ImageSignatureVerificationData{}
			}
			if err := m.SignatureVerificationData.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Signature", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Signature == nil {
				m.Signature = &ImageSignature{}
			}
			if err := m.Signature.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsClusterLocal", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsClusterLocal = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DataSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DataSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DataSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImageScan) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImageScan: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImageScan: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScanTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScanTime == nil {
				m.ScanTime = &types.Timestamp{}
			}
			if err := m.ScanTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Components", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Components = append(m.Components, &EmbeddedImageScanComponent{})
			if err := m.Components[len(m.Components)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataSource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DataSource == nil {
				m.DataSource = &DataSource{}
			}
			if err := m.DataSource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OperatingSystem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OperatingSystem = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType == 0 {
				var v ImageScan_Note
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowImage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= ImageScan_Note(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Notes = append(m.Notes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowImage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthImage
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthImage
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.Notes) == 0 {
					m.Notes = make([]ImageScan_Note, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v ImageScan_Note
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowImage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= ImageScan_Note(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Notes = append(m.Notes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Notes", wireType)
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScannerVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ScannerVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImageSignatureVerificationData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImageSignatureVerificationData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImageSignatureVerificationData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Results", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Results = append(m.Results, &ImageSignatureVerificationResult{})
			if err := m.Results[len(m.Results)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImageSignatureVerificationResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImageSignatureVerificationResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImageSignatureVerificationResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VerificationTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VerificationTime == nil {
				m.VerificationTime = &types.Timestamp{}
			}
			if err := m.VerificationTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VerifierId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VerifierId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= ImageSignatureVerificationResult_Status(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EmbeddedImageScanComponent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EmbeddedImageScanComponent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EmbeddedImageScanComponent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field License", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.License == nil {
				m.License = &License{}
			}
			if err := m.License.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Vulns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Vulns = append(m.Vulns, &EmbeddedVulnerability{})
			if err := m.Vulns[len(m.Vulns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LayerIndex", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasLayerIndex = &EmbeddedImageScanComponent_LayerIndex{v}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priority", wireType)
			}
			m.Priority = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Priority |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			m.Source = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Source |= SourceType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Location", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Location = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field TopCvss", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.SetTopCvss = &EmbeddedImageScanComponent_TopCvss{float32(math.Float32frombits(v))}
		case 10:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field RiskScore", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.RiskScore = float32(math.Float32frombits(v))
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FixedBy", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FixedBy = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Executables", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Executables = append(m.Executables, &EmbeddedImageScanComponent_Executable{})
			if err := m.Executables[len(m.Executables)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EmbeddedImageScanComponent_Executable) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Executable: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Executable: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dependencies", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Dependencies = append(m.Dependencies, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *License) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: License: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: License: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImageMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImageMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImageMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field V1", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.V1 == nil {
				m.V1 = &V1Metadata{}
			}
			if err := m.V1.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field V2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.V2 == nil {
				m.V2 = &V2Metadata{}
			}
			if err := m.V2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LayerShas", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LayerShas = append(m.LayerShas, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataSource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DataSource == nil {
				m.DataSource = &DataSource{}
			}
			if err := m.DataSource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImageSignature) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImageSignature: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImageSignature: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Signatures", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Signatures = append(m.Signatures, &Signature{})
			if err := m.Signatures[len(m.Signatures)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Signature) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Signature: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Signature: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cosign", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CosignSignature{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Signature = &Signature_Cosign{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CosignSignature) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CosignSignature: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CosignSignature: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawSignature", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RawSignature = append(m.RawSignature[:0], dAtA[iNdEx:postIndex]...)
			if m.RawSignature == nil {
				m.RawSignature = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SignaturePayload", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SignaturePayload = append(m.SignaturePayload[:0], dAtA[iNdEx:postIndex]...)
			if m.SignaturePayload == nil {
				m.SignaturePayload = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *V2Metadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: V2Metadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: V2Metadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Digest", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Digest = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *V1Metadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: V1Metadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: V1Metadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Digest", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Digest = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Created", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Created == nil {
				m.Created = &types.Timestamp{}
			}
			if err := m.Created.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Author", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Author = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Layers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Layers = append(m.Layers, &ImageLayer{})
			if err := m.Layers[len(m.Layers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.User = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Command = append(m.Command, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entrypoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Entrypoint = append(m.Entrypoint, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Volumes", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Volumes = append(m.Volumes, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowImage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowImage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthImage
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthImage
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowImage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthImage
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthImage
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipImage(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthImage
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImageLayer) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImageLayer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImageLayer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instruction", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Instruction = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Created", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Created == nil {
				m.Created = &types.Timestamp{}
			}
			if err := m.Created.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Author", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Author = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Empty", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Empty = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImageName) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImageName: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImageName: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Registry", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Registry = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Remote", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Remote = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tag", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tag = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FullName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FullName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListImage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListImage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListImage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Components", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SetComponents = &ListImage_Components{v}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cves", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SetCves = &ListImage_Cves{v}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FixableCves", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SetFixable = &ListImage_FixableCves{v}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Created", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Created == nil {
				m.Created = &types.Timestamp{}
			}
			if err := m.Created.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastUpdated == nil {
				m.LastUpdated = &types.Timestamp{}
			}
			if err := m.LastUpdated.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priority", wireType)
			}
			m.Priority = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Priority |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImageComponentEdge) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImageComponentEdge: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImageComponentEdge: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LayerIndex", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasLayerIndex = &ImageComponentEdge_LayerIndex{v}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Location", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Location = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImageCVEEdge) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImageCVEEdge: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImageCVEEdge: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstImageOccurrence", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FirstImageOccurrence == nil {
				m.FirstImageOccurrence = &types.Timestamp{}
			}
			if err := m.FirstImageOccurrence.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= VulnerabilityState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WatchedImage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WatchedImage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WatchedImage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipImage(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowImage
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowImage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowImage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthImage
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupImage
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthImage
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthImage        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowImage          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupImage = fmt.Errorf("proto: unexpected end of group")
)
