// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/image_component.proto

package storage

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ImageComponent struct {
	Id        string     `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" search:"Component ID,store"`
	Name      string     `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty" search:"Component,store"`
	Version   string     `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty" search:"Component Version,store"`
	License   *License   `protobuf:"bytes,4,opt,name=license,proto3" json:"license,omitempty"`
	Priority  int64      `protobuf:"varint,5,opt,name=priority,proto3" json:"priority,omitempty"`
	Source    SourceType `protobuf:"varint,6,opt,name=source,proto3,enum=storage.SourceType" json:"source,omitempty" search:"Component Source,store"`
	RiskScore float32    `protobuf:"fixed32,7,opt,name=risk_score,json=riskScore,proto3" json:"risk_score,omitempty" search:"Risk Score,hidden"`
	// Types that are valid to be assigned to SetTopCvss:
	//	*ImageComponent_TopCvss
	SetTopCvss isImageComponent_SetTopCvss `protobuf_oneof:"set_top_cvss"`
	// Component version that fixes all the fixable vulnerabilities in this component.
	FixedBy              string   `protobuf:"bytes,9,opt,name=fixed_by,json=fixedBy,proto3" json:"fixed_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImageComponent) Reset()         { *m = ImageComponent{} }
func (m *ImageComponent) String() string { return proto.CompactTextString(m) }
func (*ImageComponent) ProtoMessage()    {}
func (*ImageComponent) Descriptor() ([]byte, []int) {
	return fileDescriptor_f72cea254a8774ea, []int{0}
}
func (m *ImageComponent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImageComponent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImageComponent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImageComponent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageComponent.Merge(m, src)
}
func (m *ImageComponent) XXX_Size() int {
	return m.Size()
}
func (m *ImageComponent) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageComponent.DiscardUnknown(m)
}

var xxx_messageInfo_ImageComponent proto.InternalMessageInfo

type isImageComponent_SetTopCvss interface {
	isImageComponent_SetTopCvss()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isImageComponent_SetTopCvss
}

type ImageComponent_TopCvss struct {
	TopCvss float32 `protobuf:"fixed32,8,opt,name=top_cvss,json=topCvss,proto3,oneof" json:"top_cvss,omitempty" search:"Component Top CVSS,store"`
}

func (*ImageComponent_TopCvss) isImageComponent_SetTopCvss() {}
func (m *ImageComponent_TopCvss) Clone() isImageComponent_SetTopCvss {
	if m == nil {
		return nil
	}
	cloned := new(ImageComponent_TopCvss)
	*cloned = *m

	return cloned
}

func (m *ImageComponent) GetSetTopCvss() isImageComponent_SetTopCvss {
	if m != nil {
		return m.SetTopCvss
	}
	return nil
}

func (m *ImageComponent) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ImageComponent) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ImageComponent) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *ImageComponent) GetLicense() *License {
	if m != nil {
		return m.License
	}
	return nil
}

func (m *ImageComponent) GetPriority() int64 {
	if m != nil {
		return m.Priority
	}
	return 0
}

func (m *ImageComponent) GetSource() SourceType {
	if m != nil {
		return m.Source
	}
	return SourceType_OS
}

func (m *ImageComponent) GetRiskScore() float32 {
	if m != nil {
		return m.RiskScore
	}
	return 0
}

func (m *ImageComponent) GetTopCvss() float32 {
	if x, ok := m.GetSetTopCvss().(*ImageComponent_TopCvss); ok {
		return x.TopCvss
	}
	return 0
}

func (m *ImageComponent) GetFixedBy() string {
	if m != nil {
		return m.FixedBy
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ImageComponent) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ImageComponent_TopCvss)(nil),
	}
}

func (m *ImageComponent) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ImageComponent) Clone() *ImageComponent {
	if m == nil {
		return nil
	}
	cloned := new(ImageComponent)
	*cloned = *m

	cloned.License = m.License.Clone()
	if m.SetTopCvss != nil {
		cloned.SetTopCvss = m.SetTopCvss.Clone()
	}
	return cloned
}

type ComponentCVEEdge struct {
	// base 64 encoded Component:CVE ids.
	Id        string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	IsFixable bool   `protobuf:"varint,2,opt,name=is_fixable,json=isFixable,proto3" json:"is_fixable,omitempty" search:"Fixable,store"`
	// Whether there is a version the CVE is fixed in the component.
	//
	// Types that are valid to be assigned to HasFixedBy:
	//	*ComponentCVEEdge_FixedBy
	HasFixedBy           isComponentCVEEdge_HasFixedBy `protobuf_oneof:"has_fixed_by"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *ComponentCVEEdge) Reset()         { *m = ComponentCVEEdge{} }
func (m *ComponentCVEEdge) String() string { return proto.CompactTextString(m) }
func (*ComponentCVEEdge) ProtoMessage()    {}
func (*ComponentCVEEdge) Descriptor() ([]byte, []int) {
	return fileDescriptor_f72cea254a8774ea, []int{1}
}
func (m *ComponentCVEEdge) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ComponentCVEEdge) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ComponentCVEEdge.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ComponentCVEEdge) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComponentCVEEdge.Merge(m, src)
}
func (m *ComponentCVEEdge) XXX_Size() int {
	return m.Size()
}
func (m *ComponentCVEEdge) XXX_DiscardUnknown() {
	xxx_messageInfo_ComponentCVEEdge.DiscardUnknown(m)
}

var xxx_messageInfo_ComponentCVEEdge proto.InternalMessageInfo

type isComponentCVEEdge_HasFixedBy interface {
	isComponentCVEEdge_HasFixedBy()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isComponentCVEEdge_HasFixedBy
}

type ComponentCVEEdge_FixedBy struct {
	FixedBy string `protobuf:"bytes,3,opt,name=fixed_by,json=fixedBy,proto3,oneof" json:"fixed_by,omitempty" search:"Fixed By,store,hidden"`
}

func (*ComponentCVEEdge_FixedBy) isComponentCVEEdge_HasFixedBy() {}
func (m *ComponentCVEEdge_FixedBy) Clone() isComponentCVEEdge_HasFixedBy {
	if m == nil {
		return nil
	}
	cloned := new(ComponentCVEEdge_FixedBy)
	*cloned = *m

	return cloned
}

func (m *ComponentCVEEdge) GetHasFixedBy() isComponentCVEEdge_HasFixedBy {
	if m != nil {
		return m.HasFixedBy
	}
	return nil
}

func (m *ComponentCVEEdge) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ComponentCVEEdge) GetIsFixable() bool {
	if m != nil {
		return m.IsFixable
	}
	return false
}

func (m *ComponentCVEEdge) GetFixedBy() string {
	if x, ok := m.GetHasFixedBy().(*ComponentCVEEdge_FixedBy); ok {
		return x.FixedBy
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ComponentCVEEdge) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ComponentCVEEdge_FixedBy)(nil),
	}
}

func (m *ComponentCVEEdge) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ComponentCVEEdge) Clone() *ComponentCVEEdge {
	if m == nil {
		return nil
	}
	cloned := new(ComponentCVEEdge)
	*cloned = *m

	if m.HasFixedBy != nil {
		cloned.HasFixedBy = m.HasFixedBy.Clone()
	}
	return cloned
}

func init() {
	proto.RegisterType((*ImageComponent)(nil), "storage.ImageComponent")
	proto.RegisterType((*ComponentCVEEdge)(nil), "storage.ComponentCVEEdge")
}

func init() { proto.RegisterFile("storage/image_component.proto", fileDescriptor_f72cea254a8774ea) }

var fileDescriptor_f72cea254a8774ea = []byte{
	// 503 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x64, 0x53, 0xcf, 0x6e, 0xd3, 0x30,
	0x18, 0x9f, 0xbb, 0xd1, 0xb4, 0x06, 0x55, 0x93, 0x87, 0x90, 0x57, 0x20, 0x36, 0x01, 0xa4, 0x0a,
	0x4d, 0x2d, 0x1a, 0x5c, 0x40, 0x02, 0xa4, 0x94, 0x21, 0x26, 0x71, 0x40, 0xe9, 0xd4, 0x03, 0x97,
	0x28, 0x4d, 0xbc, 0xd6, 0xea, 0x1a, 0x47, 0x76, 0xa8, 0xda, 0x37, 0xe1, 0x29, 0x78, 0x0e, 0x8e,
	0x3c, 0x41, 0x84, 0xca, 0x1b, 0xe4, 0xca, 0x05, 0xc5, 0x8e, 0x4b, 0x51, 0x6f, 0xf6, 0xef, 0xfb,
	0xfd, 0xf9, 0xfc, 0x7d, 0x09, 0x7c, 0xa8, 0x72, 0x21, 0xa3, 0x29, 0x1b, 0xf0, 0x45, 0x34, 0x65,
	0x61, 0x2c, 0x16, 0x99, 0x48, 0x59, 0x9a, 0xf7, 0x33, 0x29, 0x72, 0x81, 0x9c, 0xba, 0xdc, 0x3d,
	0xf9, 0x8f, 0x67, 0xaa, 0xdd, 0xbb, 0x53, 0x31, 0x15, 0xfa, 0x38, 0xa8, 0x4e, 0x06, 0xf5, 0xfe,
	0x1c, 0xc2, 0xce, 0x65, 0xc5, 0x1a, 0x5a, 0x33, 0x34, 0x80, 0x0d, 0x9e, 0x60, 0x40, 0x41, 0xaf,
	0xed, 0x93, 0xb2, 0x20, 0xf7, 0x15, 0x8b, 0x64, 0x3c, 0x7b, 0xed, 0x6d, 0x29, 0xf4, 0xf2, 0xfd,
	0x59, 0x15, 0xc1, 0xbc, 0xa0, 0xc1, 0x13, 0xf4, 0x1c, 0x1e, 0xa5, 0xd1, 0x82, 0xe1, 0x86, 0x96,
	0x3c, 0x28, 0x0b, 0x82, 0xf7, 0x24, 0x96, 0xaf, 0x99, 0xe8, 0x2d, 0x74, 0x96, 0x4c, 0x2a, 0x2e,
	0x52, 0x7c, 0xa8, 0x45, 0x4f, 0xca, 0x82, 0xd0, 0xfd, 0x9c, 0xb1, 0x21, 0x59, 0xb1, 0x15, 0xa1,
	0x67, 0xd0, 0xb9, 0xe1, 0x31, 0x4b, 0x15, 0xc3, 0x47, 0x14, 0xf4, 0x6e, 0x9f, 0x1f, 0xf7, 0xeb,
	0x27, 0xf7, 0x3f, 0x19, 0x3c, 0xb0, 0x04, 0xd4, 0x85, 0xad, 0x4c, 0x72, 0x21, 0x79, 0xbe, 0xc6,
	0xb7, 0x28, 0xe8, 0x1d, 0x06, 0xdb, 0x3b, 0xfa, 0x0c, 0x9b, 0x4a, 0x7c, 0x95, 0x31, 0xc3, 0x4d,
	0x0a, 0x7a, 0x9d, 0xf3, 0x93, 0xad, 0xcd, 0x48, 0xc3, 0x57, 0xeb, 0x8c, 0xf9, 0x8f, 0xcb, 0x82,
	0x90, 0xfd, 0xde, 0x0c, 0xc3, 0xb6, 0x56, 0xfb, 0xa0, 0x37, 0x10, 0x4a, 0xae, 0xe6, 0xa1, 0x8a,
	0x85, 0x64, 0xd8, 0xa1, 0xa0, 0xd7, 0xf0, 0xdd, 0xb2, 0x20, 0x5d, 0x6b, 0x10, 0x70, 0x35, 0xa7,
	0xa3, 0xaa, 0x7a, 0x36, 0xe3, 0x49, 0xc2, 0x52, 0x2f, 0x68, 0x57, 0x0a, 0x0d, 0x21, 0x1f, 0xb6,
	0x72, 0x91, 0x85, 0xf1, 0x52, 0x29, 0xdc, 0xd2, 0xe2, 0xa7, 0x65, 0x41, 0x1e, 0xed, 0xa7, 0x5f,
	0x89, 0x8c, 0x0e, 0xc7, 0xa3, 0x51, 0x9d, 0xff, 0xf1, 0x20, 0x70, 0x72, 0x91, 0x0d, 0x97, 0x4a,
	0xa1, 0x53, 0xd8, 0xba, 0xe6, 0x2b, 0x96, 0x84, 0x93, 0x35, 0x6e, 0x57, 0xd3, 0x0d, 0x1c, 0x7d,
	0xf7, 0xd7, 0x7e, 0x07, 0xde, 0x51, 0x2c, 0x0f, 0x6d, 0x84, 0xf7, 0x1d, 0xc0, 0xe3, 0xad, 0xe7,
	0x70, 0x7c, 0x71, 0x91, 0x4c, 0x19, 0xea, 0xfc, 0xdb, 0xbf, 0x5e, 0xef, 0x2b, 0x08, 0xb9, 0x0a,
	0xaf, 0xf9, 0x2a, 0x9a, 0xdc, 0x98, 0x25, 0xb7, 0xfc, 0x6e, 0x59, 0x90, 0x7b, 0xb6, 0xab, 0x0f,
	0xa6, 0x64, 0x47, 0xd1, 0xe6, 0xaa, 0x46, 0xd0, 0xbb, 0x9d, 0x56, 0xcc, 0xa2, 0xbd, 0xb2, 0x20,
	0xee, 0x8e, 0x90, 0x25, 0xd4, 0x5f, 0x1b, 0xa5, 0x9d, 0x47, 0xf5, 0x96, 0x9d, 0x86, 0x67, 0x91,
	0x0e, 0xd7, 0x26, 0xfe, 0xcb, 0x1f, 0x1b, 0x17, 0xfc, 0xdc, 0xb8, 0xe0, 0xd7, 0xc6, 0x05, 0xdf,
	0x7e, 0xbb, 0x07, 0xf0, 0x94, 0x8b, 0xbe, 0xca, 0xa3, 0x78, 0x2e, 0xc5, 0xca, 0x7c, 0xd3, 0x76,
	0x87, 0x5f, 0xec, 0xff, 0x30, 0x69, 0x6a, 0xfc, 0xc5, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xab,
	0xd9, 0x11, 0xc3, 0x40, 0x03, 0x00, 0x00,
}

func (m *ImageComponent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImageComponent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageComponent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.FixedBy) > 0 {
		i -= len(m.FixedBy)
		copy(dAtA[i:], m.FixedBy)
		i = encodeVarintImageComponent(dAtA, i, uint64(len(m.FixedBy)))
		i--
		dAtA[i] = 0x4a
	}
	if m.SetTopCvss != nil {
		{
			size := m.SetTopCvss.Size()
			i -= size
			if _, err := m.SetTopCvss.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.RiskScore != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.RiskScore))))
		i--
		dAtA[i] = 0x3d
	}
	if m.Source != 0 {
		i = encodeVarintImageComponent(dAtA, i, uint64(m.Source))
		i--
		dAtA[i] = 0x30
	}
	if m.Priority != 0 {
		i = encodeVarintImageComponent(dAtA, i, uint64(m.Priority))
		i--
		dAtA[i] = 0x28
	}
	if m.License != nil {
		{
			size, err := m.License.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImageComponent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintImageComponent(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintImageComponent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintImageComponent(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ImageComponent_TopCvss) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageComponent_TopCvss) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 4
	encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.TopCvss))))
	i--
	dAtA[i] = 0x45
	return len(dAtA) - i, nil
}
func (m *ComponentCVEEdge) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComponentCVEEdge) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ComponentCVEEdge) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.HasFixedBy != nil {
		{
			size := m.HasFixedBy.Size()
			i -= size
			if _, err := m.HasFixedBy.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.IsFixable {
		i--
		if m.IsFixable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintImageComponent(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ComponentCVEEdge_FixedBy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ComponentCVEEdge_FixedBy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.FixedBy)
	copy(dAtA[i:], m.FixedBy)
	i = encodeVarintImageComponent(dAtA, i, uint64(len(m.FixedBy)))
	i--
	dAtA[i] = 0x1a
	return len(dAtA) - i, nil
}
func encodeVarintImageComponent(dAtA []byte, offset int, v uint64) int {
	offset -= sovImageComponent(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ImageComponent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovImageComponent(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovImageComponent(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovImageComponent(uint64(l))
	}
	if m.License != nil {
		l = m.License.Size()
		n += 1 + l + sovImageComponent(uint64(l))
	}
	if m.Priority != 0 {
		n += 1 + sovImageComponent(uint64(m.Priority))
	}
	if m.Source != 0 {
		n += 1 + sovImageComponent(uint64(m.Source))
	}
	if m.RiskScore != 0 {
		n += 5
	}
	if m.SetTopCvss != nil {
		n += m.SetTopCvss.Size()
	}
	l = len(m.FixedBy)
	if l > 0 {
		n += 1 + l + sovImageComponent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ImageComponent_TopCvss) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 5
	return n
}
func (m *ComponentCVEEdge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovImageComponent(uint64(l))
	}
	if m.IsFixable {
		n += 2
	}
	if m.HasFixedBy != nil {
		n += m.HasFixedBy.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ComponentCVEEdge_FixedBy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.FixedBy)
	n += 1 + l + sovImageComponent(uint64(l))
	return n
}

func sovImageComponent(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozImageComponent(x uint64) (n int) {
	return sovImageComponent(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ImageComponent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageComponent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImageComponent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImageComponent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageComponent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageComponent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageComponent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageComponent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageComponent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageComponent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageComponent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageComponent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageComponent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field License", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageComponent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageComponent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageComponent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.License == nil {
				m.License = &License{}
			}
			if err := m.License.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priority", wireType)
			}
			m.Priority = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageComponent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Priority |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			m.Source = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageComponent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Source |= SourceType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field RiskScore", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.RiskScore = float32(math.Float32frombits(v))
		case 8:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field TopCvss", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.SetTopCvss = &ImageComponent_TopCvss{float32(math.Float32frombits(v))}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FixedBy", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageComponent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageComponent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageComponent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FixedBy = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImageComponent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageComponent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ComponentCVEEdge) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageComponent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ComponentCVEEdge: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ComponentCVEEdge: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageComponent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageComponent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageComponent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsFixable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageComponent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsFixable = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FixedBy", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageComponent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageComponent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageComponent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HasFixedBy = &ComponentCVEEdge_FixedBy{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImageComponent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageComponent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipImageComponent(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowImageComponent
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowImageComponent
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowImageComponent
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthImageComponent
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupImageComponent
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthImageComponent
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthImageComponent        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowImageComponent          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupImageComponent = fmt.Errorf("proto: unexpected end of group")
)
