// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/image_integration.proto

package storage

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ImageIntegrationCategory int32

const (
	ImageIntegrationCategory_REGISTRY ImageIntegrationCategory = 0
	ImageIntegrationCategory_SCANNER  ImageIntegrationCategory = 1
	// Image and Node integrations are currently done on the same form in the UI
	// so the image integration is also currently used for node integrations.
	// This decision was made because we currently only support one node scanner (our scanner).
	ImageIntegrationCategory_NODE_SCANNER ImageIntegrationCategory = 2
)

var ImageIntegrationCategory_name = map[int32]string{
	0: "REGISTRY",
	1: "SCANNER",
	2: "NODE_SCANNER",
}

var ImageIntegrationCategory_value = map[string]int32{
	"REGISTRY":     0,
	"SCANNER":      1,
	"NODE_SCANNER": 2,
}

func (x ImageIntegrationCategory) String() string {
	return proto.EnumName(ImageIntegrationCategory_name, int32(x))
}

func (ImageIntegrationCategory) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_9e3766be4a43c581, []int{0}
}

// Next Tag: 21
type ImageIntegration struct {
	Id         string                     `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Name       string                     `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Type       string                     `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	Categories []ImageIntegrationCategory `protobuf:"varint,6,rep,packed,name=categories,proto3,enum=storage.ImageIntegrationCategory" json:"categories,omitempty"`
	// Types that are valid to be assigned to IntegrationConfig:
	//	*ImageIntegration_Dtr
	//	*ImageIntegration_Clairify
	//	*ImageIntegration_Docker
	//	*ImageIntegration_Quay
	//	*ImageIntegration_Ecr
	//	*ImageIntegration_Tenable
	//	*ImageIntegration_Google
	//	*ImageIntegration_Clair
	//	*ImageIntegration_Anchore
	//	*ImageIntegration_Ibm
	IntegrationConfig    isImageIntegration_IntegrationConfig `protobuf_oneof:"IntegrationConfig"`
	Autogenerated        bool                                 `protobuf:"varint,15,opt,name=autogenerated,proto3" json:"autogenerated,omitempty"`
	ClusterId            string                               `protobuf:"bytes,16,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	SkipTestIntegration  bool                                 `protobuf:"varint,18,opt,name=skip_test_integration,json=skipTestIntegration,proto3" json:"skip_test_integration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *ImageIntegration) Reset()         { *m = ImageIntegration{} }
func (m *ImageIntegration) String() string { return proto.CompactTextString(m) }
func (*ImageIntegration) ProtoMessage()    {}
func (*ImageIntegration) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e3766be4a43c581, []int{0}
}
func (m *ImageIntegration) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImageIntegration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImageIntegration.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImageIntegration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageIntegration.Merge(m, src)
}
func (m *ImageIntegration) XXX_Size() int {
	return m.Size()
}
func (m *ImageIntegration) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageIntegration.DiscardUnknown(m)
}

var xxx_messageInfo_ImageIntegration proto.InternalMessageInfo

type isImageIntegration_IntegrationConfig interface {
	isImageIntegration_IntegrationConfig()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isImageIntegration_IntegrationConfig
}

type ImageIntegration_Dtr struct {
	Dtr *DTRConfig `protobuf:"bytes,7,opt,name=dtr,proto3,oneof" json:"dtr,omitempty"`
}
type ImageIntegration_Clairify struct {
	Clairify *ClairifyConfig `protobuf:"bytes,8,opt,name=clairify,proto3,oneof" json:"clairify,omitempty"`
}
type ImageIntegration_Docker struct {
	Docker *DockerConfig `protobuf:"bytes,9,opt,name=docker,proto3,oneof" json:"docker,omitempty"`
}
type ImageIntegration_Quay struct {
	Quay *QuayConfig `protobuf:"bytes,10,opt,name=quay,proto3,oneof" json:"quay,omitempty"`
}
type ImageIntegration_Ecr struct {
	Ecr *ECRConfig `protobuf:"bytes,11,opt,name=ecr,proto3,oneof" json:"ecr,omitempty"`
}
type ImageIntegration_Tenable struct {
	Tenable *TenableConfig `protobuf:"bytes,12,opt,name=tenable,proto3,oneof" json:"tenable,omitempty"`
}
type ImageIntegration_Google struct {
	Google *GoogleConfig `protobuf:"bytes,13,opt,name=google,proto3,oneof" json:"google,omitempty"`
}
type ImageIntegration_Clair struct {
	Clair *ClairConfig `protobuf:"bytes,14,opt,name=clair,proto3,oneof" json:"clair,omitempty"`
}
type ImageIntegration_Anchore struct {
	Anchore *AnchoreConfig `protobuf:"bytes,17,opt,name=anchore,proto3,oneof" json:"anchore,omitempty"`
}
type ImageIntegration_Ibm struct {
	Ibm *IBMRegistryConfig `protobuf:"bytes,20,opt,name=ibm,proto3,oneof" json:"ibm,omitempty"`
}

func (*ImageIntegration_Dtr) isImageIntegration_IntegrationConfig() {}
func (m *ImageIntegration_Dtr) Clone() isImageIntegration_IntegrationConfig {
	if m == nil {
		return nil
	}
	cloned := new(ImageIntegration_Dtr)
	*cloned = *m

	cloned.Dtr = m.Dtr.Clone()
	return cloned
}
func (*ImageIntegration_Clairify) isImageIntegration_IntegrationConfig() {}
func (m *ImageIntegration_Clairify) Clone() isImageIntegration_IntegrationConfig {
	if m == nil {
		return nil
	}
	cloned := new(ImageIntegration_Clairify)
	*cloned = *m

	cloned.Clairify = m.Clairify.Clone()
	return cloned
}
func (*ImageIntegration_Docker) isImageIntegration_IntegrationConfig() {}
func (m *ImageIntegration_Docker) Clone() isImageIntegration_IntegrationConfig {
	if m == nil {
		return nil
	}
	cloned := new(ImageIntegration_Docker)
	*cloned = *m

	cloned.Docker = m.Docker.Clone()
	return cloned
}
func (*ImageIntegration_Quay) isImageIntegration_IntegrationConfig() {}
func (m *ImageIntegration_Quay) Clone() isImageIntegration_IntegrationConfig {
	if m == nil {
		return nil
	}
	cloned := new(ImageIntegration_Quay)
	*cloned = *m

	cloned.Quay = m.Quay.Clone()
	return cloned
}
func (*ImageIntegration_Ecr) isImageIntegration_IntegrationConfig() {}
func (m *ImageIntegration_Ecr) Clone() isImageIntegration_IntegrationConfig {
	if m == nil {
		return nil
	}
	cloned := new(ImageIntegration_Ecr)
	*cloned = *m

	cloned.Ecr = m.Ecr.Clone()
	return cloned
}
func (*ImageIntegration_Tenable) isImageIntegration_IntegrationConfig() {}
func (m *ImageIntegration_Tenable) Clone() isImageIntegration_IntegrationConfig {
	if m == nil {
		return nil
	}
	cloned := new(ImageIntegration_Tenable)
	*cloned = *m

	cloned.Tenable = m.Tenable.Clone()
	return cloned
}
func (*ImageIntegration_Google) isImageIntegration_IntegrationConfig() {}
func (m *ImageIntegration_Google) Clone() isImageIntegration_IntegrationConfig {
	if m == nil {
		return nil
	}
	cloned := new(ImageIntegration_Google)
	*cloned = *m

	cloned.Google = m.Google.Clone()
	return cloned
}
func (*ImageIntegration_Clair) isImageIntegration_IntegrationConfig() {}
func (m *ImageIntegration_Clair) Clone() isImageIntegration_IntegrationConfig {
	if m == nil {
		return nil
	}
	cloned := new(ImageIntegration_Clair)
	*cloned = *m

	cloned.Clair = m.Clair.Clone()
	return cloned
}
func (*ImageIntegration_Anchore) isImageIntegration_IntegrationConfig() {}
func (m *ImageIntegration_Anchore) Clone() isImageIntegration_IntegrationConfig {
	if m == nil {
		return nil
	}
	cloned := new(ImageIntegration_Anchore)
	*cloned = *m

	cloned.Anchore = m.Anchore.Clone()
	return cloned
}
func (*ImageIntegration_Ibm) isImageIntegration_IntegrationConfig() {}
func (m *ImageIntegration_Ibm) Clone() isImageIntegration_IntegrationConfig {
	if m == nil {
		return nil
	}
	cloned := new(ImageIntegration_Ibm)
	*cloned = *m

	cloned.Ibm = m.Ibm.Clone()
	return cloned
}

func (m *ImageIntegration) GetIntegrationConfig() isImageIntegration_IntegrationConfig {
	if m != nil {
		return m.IntegrationConfig
	}
	return nil
}

func (m *ImageIntegration) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ImageIntegration) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ImageIntegration) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *ImageIntegration) GetCategories() []ImageIntegrationCategory {
	if m != nil {
		return m.Categories
	}
	return nil
}

func (m *ImageIntegration) GetDtr() *DTRConfig {
	if x, ok := m.GetIntegrationConfig().(*ImageIntegration_Dtr); ok {
		return x.Dtr
	}
	return nil
}

func (m *ImageIntegration) GetClairify() *ClairifyConfig {
	if x, ok := m.GetIntegrationConfig().(*ImageIntegration_Clairify); ok {
		return x.Clairify
	}
	return nil
}

func (m *ImageIntegration) GetDocker() *DockerConfig {
	if x, ok := m.GetIntegrationConfig().(*ImageIntegration_Docker); ok {
		return x.Docker
	}
	return nil
}

func (m *ImageIntegration) GetQuay() *QuayConfig {
	if x, ok := m.GetIntegrationConfig().(*ImageIntegration_Quay); ok {
		return x.Quay
	}
	return nil
}

func (m *ImageIntegration) GetEcr() *ECRConfig {
	if x, ok := m.GetIntegrationConfig().(*ImageIntegration_Ecr); ok {
		return x.Ecr
	}
	return nil
}

func (m *ImageIntegration) GetTenable() *TenableConfig {
	if x, ok := m.GetIntegrationConfig().(*ImageIntegration_Tenable); ok {
		return x.Tenable
	}
	return nil
}

func (m *ImageIntegration) GetGoogle() *GoogleConfig {
	if x, ok := m.GetIntegrationConfig().(*ImageIntegration_Google); ok {
		return x.Google
	}
	return nil
}

func (m *ImageIntegration) GetClair() *ClairConfig {
	if x, ok := m.GetIntegrationConfig().(*ImageIntegration_Clair); ok {
		return x.Clair
	}
	return nil
}

func (m *ImageIntegration) GetAnchore() *AnchoreConfig {
	if x, ok := m.GetIntegrationConfig().(*ImageIntegration_Anchore); ok {
		return x.Anchore
	}
	return nil
}

func (m *ImageIntegration) GetIbm() *IBMRegistryConfig {
	if x, ok := m.GetIntegrationConfig().(*ImageIntegration_Ibm); ok {
		return x.Ibm
	}
	return nil
}

func (m *ImageIntegration) GetAutogenerated() bool {
	if m != nil {
		return m.Autogenerated
	}
	return false
}

func (m *ImageIntegration) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ImageIntegration) GetSkipTestIntegration() bool {
	if m != nil {
		return m.SkipTestIntegration
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ImageIntegration) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ImageIntegration_Dtr)(nil),
		(*ImageIntegration_Clairify)(nil),
		(*ImageIntegration_Docker)(nil),
		(*ImageIntegration_Quay)(nil),
		(*ImageIntegration_Ecr)(nil),
		(*ImageIntegration_Tenable)(nil),
		(*ImageIntegration_Google)(nil),
		(*ImageIntegration_Clair)(nil),
		(*ImageIntegration_Anchore)(nil),
		(*ImageIntegration_Ibm)(nil),
	}
}

func (m *ImageIntegration) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ImageIntegration) Clone() *ImageIntegration {
	if m == nil {
		return nil
	}
	cloned := new(ImageIntegration)
	*cloned = *m

	if m.Categories != nil {
		cloned.Categories = make([]ImageIntegrationCategory, len(m.Categories))
		copy(cloned.Categories, m.Categories)
	}
	if m.IntegrationConfig != nil {
		cloned.IntegrationConfig = m.IntegrationConfig.Clone()
	}
	return cloned
}

type IBMRegistryConfig struct {
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty" scrub:"dependent" validate:"nolocalendpoint"`
	// The API key for the integration. The server will mask the value of this credential in responses and logs.
	ApiKey               string   `protobuf:"bytes,2,opt,name=api_key,json=apiKey,proto3" json:"api_key,omitempty" scrub:"always"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IBMRegistryConfig) Reset()         { *m = IBMRegistryConfig{} }
func (m *IBMRegistryConfig) String() string { return proto.CompactTextString(m) }
func (*IBMRegistryConfig) ProtoMessage()    {}
func (*IBMRegistryConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e3766be4a43c581, []int{1}
}
func (m *IBMRegistryConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IBMRegistryConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IBMRegistryConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IBMRegistryConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IBMRegistryConfig.Merge(m, src)
}
func (m *IBMRegistryConfig) XXX_Size() int {
	return m.Size()
}
func (m *IBMRegistryConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_IBMRegistryConfig.DiscardUnknown(m)
}

var xxx_messageInfo_IBMRegistryConfig proto.InternalMessageInfo

func (m *IBMRegistryConfig) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *IBMRegistryConfig) GetApiKey() string {
	if m != nil {
		return m.ApiKey
	}
	return ""
}

func (m *IBMRegistryConfig) MessageClone() proto.Message {
	return m.Clone()
}
func (m *IBMRegistryConfig) Clone() *IBMRegistryConfig {
	if m == nil {
		return nil
	}
	cloned := new(IBMRegistryConfig)
	*cloned = *m

	return cloned
}

type QuayConfig struct {
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty" scrub:"dependent" validate:"nolocalendpoint"`
	// The OAuth token for the integration. The server will mask the value of this credential in responses and logs.
	OauthToken           string   `protobuf:"bytes,2,opt,name=oauthToken,proto3" json:"oauthToken,omitempty" scrub:"always"`
	Insecure             bool     `protobuf:"varint,3,opt,name=insecure,proto3" json:"insecure,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QuayConfig) Reset()         { *m = QuayConfig{} }
func (m *QuayConfig) String() string { return proto.CompactTextString(m) }
func (*QuayConfig) ProtoMessage()    {}
func (*QuayConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e3766be4a43c581, []int{2}
}
func (m *QuayConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QuayConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QuayConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QuayConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QuayConfig.Merge(m, src)
}
func (m *QuayConfig) XXX_Size() int {
	return m.Size()
}
func (m *QuayConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_QuayConfig.DiscardUnknown(m)
}

var xxx_messageInfo_QuayConfig proto.InternalMessageInfo

func (m *QuayConfig) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *QuayConfig) GetOauthToken() string {
	if m != nil {
		return m.OauthToken
	}
	return ""
}

func (m *QuayConfig) GetInsecure() bool {
	if m != nil {
		return m.Insecure
	}
	return false
}

func (m *QuayConfig) MessageClone() proto.Message {
	return m.Clone()
}
func (m *QuayConfig) Clone() *QuayConfig {
	if m == nil {
		return nil
	}
	cloned := new(QuayConfig)
	*cloned = *m

	return cloned
}

type ClairConfig struct {
	Endpoint             string   `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty" validate:"nolocalendpoint"`
	Insecure             bool     `protobuf:"varint,2,opt,name=insecure,proto3" json:"insecure,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClairConfig) Reset()         { *m = ClairConfig{} }
func (m *ClairConfig) String() string { return proto.CompactTextString(m) }
func (*ClairConfig) ProtoMessage()    {}
func (*ClairConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e3766be4a43c581, []int{3}
}
func (m *ClairConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClairConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClairConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClairConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClairConfig.Merge(m, src)
}
func (m *ClairConfig) XXX_Size() int {
	return m.Size()
}
func (m *ClairConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ClairConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ClairConfig proto.InternalMessageInfo

func (m *ClairConfig) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *ClairConfig) GetInsecure() bool {
	if m != nil {
		return m.Insecure
	}
	return false
}

func (m *ClairConfig) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ClairConfig) Clone() *ClairConfig {
	if m == nil {
		return nil
	}
	cloned := new(ClairConfig)
	*cloned = *m

	return cloned
}

type ClairifyConfig struct {
	Endpoint             string   `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty" validate:"nolocalendpoint"`
	GrpcEndpoint         string   `protobuf:"bytes,3,opt,name=grpc_endpoint,json=grpcEndpoint,proto3" json:"grpc_endpoint,omitempty" validate:"nolocalendpoint"`
	NumConcurrentScans   int32    `protobuf:"varint,2,opt,name=num_concurrent_scans,json=numConcurrentScans,proto3" json:"num_concurrent_scans,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClairifyConfig) Reset()         { *m = ClairifyConfig{} }
func (m *ClairifyConfig) String() string { return proto.CompactTextString(m) }
func (*ClairifyConfig) ProtoMessage()    {}
func (*ClairifyConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e3766be4a43c581, []int{4}
}
func (m *ClairifyConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClairifyConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClairifyConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClairifyConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClairifyConfig.Merge(m, src)
}
func (m *ClairifyConfig) XXX_Size() int {
	return m.Size()
}
func (m *ClairifyConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ClairifyConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ClairifyConfig proto.InternalMessageInfo

func (m *ClairifyConfig) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *ClairifyConfig) GetGrpcEndpoint() string {
	if m != nil {
		return m.GrpcEndpoint
	}
	return ""
}

func (m *ClairifyConfig) GetNumConcurrentScans() int32 {
	if m != nil {
		return m.NumConcurrentScans
	}
	return 0
}

func (m *ClairifyConfig) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ClairifyConfig) Clone() *ClairifyConfig {
	if m == nil {
		return nil
	}
	cloned := new(ClairifyConfig)
	*cloned = *m

	return cloned
}

type DockerConfig struct {
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty" scrub:"dependent" validate:"nolocalendpoint"`
	Username string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty" scrub:"dependent"`
	// The password for the integration. The server will mask the value of this credential in responses and logs.
	Password             string   `protobuf:"bytes,3,opt,name=password,proto3" json:"password,omitempty" scrub:"always"`
	Insecure             bool     `protobuf:"varint,4,opt,name=insecure,proto3" json:"insecure,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DockerConfig) Reset()         { *m = DockerConfig{} }
func (m *DockerConfig) String() string { return proto.CompactTextString(m) }
func (*DockerConfig) ProtoMessage()    {}
func (*DockerConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e3766be4a43c581, []int{5}
}
func (m *DockerConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DockerConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DockerConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DockerConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DockerConfig.Merge(m, src)
}
func (m *DockerConfig) XXX_Size() int {
	return m.Size()
}
func (m *DockerConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_DockerConfig.DiscardUnknown(m)
}

var xxx_messageInfo_DockerConfig proto.InternalMessageInfo

func (m *DockerConfig) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *DockerConfig) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *DockerConfig) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func (m *DockerConfig) GetInsecure() bool {
	if m != nil {
		return m.Insecure
	}
	return false
}

func (m *DockerConfig) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DockerConfig) Clone() *DockerConfig {
	if m == nil {
		return nil
	}
	cloned := new(DockerConfig)
	*cloned = *m

	return cloned
}

type ECRConfig struct {
	RegistryId string `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	// The access key ID for the integration. The server will mask the value of this credential in responses and logs.
	AccessKeyId string `protobuf:"bytes,2,opt,name=access_key_id,json=accessKeyId,proto3" json:"access_key_id,omitempty" scrub:"always"`
	// The secret access key for the integration. The server will mask the value of this credential in responses and logs.
	SecretAccessKey      string   `protobuf:"bytes,3,opt,name=secret_access_key,json=secretAccessKey,proto3" json:"secret_access_key,omitempty" scrub:"always"`
	Region               string   `protobuf:"bytes,4,opt,name=region,proto3" json:"region,omitempty"`
	UseIam               bool     `protobuf:"varint,5,opt,name=use_iam,json=useIam,proto3" json:"use_iam,omitempty" scrub:"dependent"`
	Endpoint             string   `protobuf:"bytes,6,opt,name=endpoint,proto3" json:"endpoint,omitempty" scrub:"dependent" validate:"nolocalendpoint"`
	UseAssumeRole        bool     `protobuf:"varint,7,opt,name=use_assume_role,json=useAssumeRole,proto3" json:"use_assume_role,omitempty"`
	AssumeRoleId         string   `protobuf:"bytes,8,opt,name=assume_role_id,json=assumeRoleId,proto3" json:"assume_role_id,omitempty"`
	AssumeRoleExternalId string   `protobuf:"bytes,9,opt,name=assume_role_external_id,json=assumeRoleExternalId,proto3" json:"assume_role_external_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ECRConfig) Reset()         { *m = ECRConfig{} }
func (m *ECRConfig) String() string { return proto.CompactTextString(m) }
func (*ECRConfig) ProtoMessage()    {}
func (*ECRConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e3766be4a43c581, []int{6}
}
func (m *ECRConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ECRConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ECRConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ECRConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ECRConfig.Merge(m, src)
}
func (m *ECRConfig) XXX_Size() int {
	return m.Size()
}
func (m *ECRConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ECRConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ECRConfig proto.InternalMessageInfo

func (m *ECRConfig) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

func (m *ECRConfig) GetAccessKeyId() string {
	if m != nil {
		return m.AccessKeyId
	}
	return ""
}

func (m *ECRConfig) GetSecretAccessKey() string {
	if m != nil {
		return m.SecretAccessKey
	}
	return ""
}

func (m *ECRConfig) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *ECRConfig) GetUseIam() bool {
	if m != nil {
		return m.UseIam
	}
	return false
}

func (m *ECRConfig) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *ECRConfig) GetUseAssumeRole() bool {
	if m != nil {
		return m.UseAssumeRole
	}
	return false
}

func (m *ECRConfig) GetAssumeRoleId() string {
	if m != nil {
		return m.AssumeRoleId
	}
	return ""
}

func (m *ECRConfig) GetAssumeRoleExternalId() string {
	if m != nil {
		return m.AssumeRoleExternalId
	}
	return ""
}

func (m *ECRConfig) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ECRConfig) Clone() *ECRConfig {
	if m == nil {
		return nil
	}
	cloned := new(ECRConfig)
	*cloned = *m

	return cloned
}

type DTRConfig struct {
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty" scrub:"dependent"`
	// The password for the integration. The server will mask the value of this credential in responses and logs.
	Password             string   `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty" scrub:"always"`
	Endpoint             string   `protobuf:"bytes,3,opt,name=endpoint,proto3" json:"endpoint,omitempty" scrub:"dependent" validate:"nolocalendpoint"`
	Insecure             bool     `protobuf:"varint,4,opt,name=insecure,proto3" json:"insecure,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DTRConfig) Reset()         { *m = DTRConfig{} }
func (m *DTRConfig) String() string { return proto.CompactTextString(m) }
func (*DTRConfig) ProtoMessage()    {}
func (*DTRConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e3766be4a43c581, []int{7}
}
func (m *DTRConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DTRConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DTRConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DTRConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DTRConfig.Merge(m, src)
}
func (m *DTRConfig) XXX_Size() int {
	return m.Size()
}
func (m *DTRConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_DTRConfig.DiscardUnknown(m)
}

var xxx_messageInfo_DTRConfig proto.InternalMessageInfo

func (m *DTRConfig) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *DTRConfig) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func (m *DTRConfig) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *DTRConfig) GetInsecure() bool {
	if m != nil {
		return m.Insecure
	}
	return false
}

func (m *DTRConfig) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DTRConfig) Clone() *DTRConfig {
	if m == nil {
		return nil
	}
	cloned := new(DTRConfig)
	*cloned = *m

	return cloned
}

type GoogleConfig struct {
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty" scrub:"dependent" validate:"nolocalendpoint"`
	// The service account for the integration. The server will mask the value of this credential in responses and logs.
	ServiceAccount       string   `protobuf:"bytes,2,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty" scrub:"always"`
	Project              string   `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GoogleConfig) Reset()         { *m = GoogleConfig{} }
func (m *GoogleConfig) String() string { return proto.CompactTextString(m) }
func (*GoogleConfig) ProtoMessage()    {}
func (*GoogleConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e3766be4a43c581, []int{8}
}
func (m *GoogleConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GoogleConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GoogleConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GoogleConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GoogleConfig.Merge(m, src)
}
func (m *GoogleConfig) XXX_Size() int {
	return m.Size()
}
func (m *GoogleConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_GoogleConfig.DiscardUnknown(m)
}

var xxx_messageInfo_GoogleConfig proto.InternalMessageInfo

func (m *GoogleConfig) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *GoogleConfig) GetServiceAccount() string {
	if m != nil {
		return m.ServiceAccount
	}
	return ""
}

func (m *GoogleConfig) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *GoogleConfig) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GoogleConfig) Clone() *GoogleConfig {
	if m == nil {
		return nil
	}
	cloned := new(GoogleConfig)
	*cloned = *m

	return cloned
}

type TenableConfig struct {
	// The access key for the integration. The server will mask the value of this credential in responses and logs.
	AccessKey string `protobuf:"bytes,1,opt,name=access_key,json=accessKey,proto3" json:"access_key,omitempty" scrub:"always"`
	// The secret key for the integration. The server will mask the value of this credential in responses and logs.
	SecretKey            string   `protobuf:"bytes,2,opt,name=secret_key,json=secretKey,proto3" json:"secret_key,omitempty" scrub:"always"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TenableConfig) Reset()         { *m = TenableConfig{} }
func (m *TenableConfig) String() string { return proto.CompactTextString(m) }
func (*TenableConfig) ProtoMessage()    {}
func (*TenableConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e3766be4a43c581, []int{9}
}
func (m *TenableConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TenableConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TenableConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TenableConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TenableConfig.Merge(m, src)
}
func (m *TenableConfig) XXX_Size() int {
	return m.Size()
}
func (m *TenableConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_TenableConfig.DiscardUnknown(m)
}

var xxx_messageInfo_TenableConfig proto.InternalMessageInfo

func (m *TenableConfig) GetAccessKey() string {
	if m != nil {
		return m.AccessKey
	}
	return ""
}

func (m *TenableConfig) GetSecretKey() string {
	if m != nil {
		return m.SecretKey
	}
	return ""
}

func (m *TenableConfig) MessageClone() proto.Message {
	return m.Clone()
}
func (m *TenableConfig) Clone() *TenableConfig {
	if m == nil {
		return nil
	}
	cloned := new(TenableConfig)
	*cloned = *m

	return cloned
}

type AnchoreConfig struct {
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty" scrub:"dependent" validate:"nolocalendpoint"`
	Username string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty" scrub:"dependent"`
	// The password for the integration. The server will mask the value of this credential in responses and logs.
	Password             string   `protobuf:"bytes,3,opt,name=password,proto3" json:"password,omitempty" scrub:"always"`
	Insecure             bool     `protobuf:"varint,4,opt,name=insecure,proto3" json:"insecure,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnchoreConfig) Reset()         { *m = AnchoreConfig{} }
func (m *AnchoreConfig) String() string { return proto.CompactTextString(m) }
func (*AnchoreConfig) ProtoMessage()    {}
func (*AnchoreConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e3766be4a43c581, []int{10}
}
func (m *AnchoreConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AnchoreConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AnchoreConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AnchoreConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnchoreConfig.Merge(m, src)
}
func (m *AnchoreConfig) XXX_Size() int {
	return m.Size()
}
func (m *AnchoreConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_AnchoreConfig.DiscardUnknown(m)
}

var xxx_messageInfo_AnchoreConfig proto.InternalMessageInfo

func (m *AnchoreConfig) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *AnchoreConfig) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *AnchoreConfig) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func (m *AnchoreConfig) GetInsecure() bool {
	if m != nil {
		return m.Insecure
	}
	return false
}

func (m *AnchoreConfig) MessageClone() proto.Message {
	return m.Clone()
}
func (m *AnchoreConfig) Clone() *AnchoreConfig {
	if m == nil {
		return nil
	}
	cloned := new(AnchoreConfig)
	*cloned = *m

	return cloned
}

func init() {
	proto.RegisterEnum("storage.ImageIntegrationCategory", ImageIntegrationCategory_name, ImageIntegrationCategory_value)
	proto.RegisterType((*ImageIntegration)(nil), "storage.ImageIntegration")
	proto.RegisterType((*IBMRegistryConfig)(nil), "storage.IBMRegistryConfig")
	proto.RegisterType((*QuayConfig)(nil), "storage.QuayConfig")
	proto.RegisterType((*ClairConfig)(nil), "storage.ClairConfig")
	proto.RegisterType((*ClairifyConfig)(nil), "storage.ClairifyConfig")
	proto.RegisterType((*DockerConfig)(nil), "storage.DockerConfig")
	proto.RegisterType((*ECRConfig)(nil), "storage.ECRConfig")
	proto.RegisterType((*DTRConfig)(nil), "storage.DTRConfig")
	proto.RegisterType((*GoogleConfig)(nil), "storage.GoogleConfig")
	proto.RegisterType((*TenableConfig)(nil), "storage.TenableConfig")
	proto.RegisterType((*AnchoreConfig)(nil), "storage.AnchoreConfig")
}

func init() { proto.RegisterFile("storage/image_integration.proto", fileDescriptor_9e3766be4a43c581) }

var fileDescriptor_9e3766be4a43c581 = []byte{
	// 1076 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x96, 0xcf, 0x6f, 0xe3, 0x44,
	0x14, 0xc7, 0xeb, 0x24, 0x4d, 0x9c, 0x97, 0x1f, 0x4d, 0xa7, 0xe9, 0xae, 0xa9, 0x44, 0x53, 0xac,
	0xd5, 0xaa, 0xc0, 0x2a, 0xdd, 0x2d, 0x2c, 0x87, 0x22, 0x21, 0x25, 0xd9, 0xa8, 0xa4, 0x0b, 0x45,
	0xb8, 0xbd, 0xc0, 0xc5, 0x9a, 0xda, 0x6f, 0xbd, 0xa6, 0x89, 0x27, 0xcc, 0x8c, 0x77, 0x37, 0x7f,
	0x01, 0x37, 0xce, 0xfc, 0x0d, 0x5c, 0xf9, 0x03, 0x38, 0x70, 0xe1, 0xc8, 0x11, 0x09, 0x54, 0xa1,
	0xf2, 0x1f, 0xf4, 0x2f, 0x40, 0x63, 0x3b, 0x8e, 0x93, 0xd2, 0xaa, 0xa8, 0x3d, 0x71, 0xb3, 0xdf,
	0x7c, 0xde, 0x9b, 0xef, 0xbc, 0x79, 0x6f, 0x66, 0xa0, 0x25, 0x24, 0xe3, 0xd4, 0xc3, 0x1d, 0x7f,
	0x44, 0x3d, 0xb4, 0xfd, 0x40, 0xa2, 0xc7, 0xa9, 0xf4, 0x59, 0xd0, 0x1e, 0x73, 0x26, 0x19, 0x29,
	0x25, 0xc0, 0x46, 0xd3, 0x63, 0x1e, 0x8b, 0x6c, 0x3b, 0xea, 0x2b, 0x1e, 0x36, 0xbf, 0x2b, 0x42,
	0x63, 0xa0, 0x5c, 0x07, 0x33, 0x4f, 0x52, 0x87, 0x9c, 0xef, 0x1a, 0xda, 0x96, 0xb6, 0x5d, 0xb6,
	0x72, 0xbe, 0x4b, 0x08, 0x14, 0x02, 0x3a, 0x42, 0x23, 0x17, 0x59, 0xa2, 0x6f, 0x65, 0x93, 0x93,
	0x31, 0x1a, 0xf9, 0xd8, 0xa6, 0xbe, 0x49, 0x07, 0xc0, 0xa1, 0x12, 0x3d, 0xc6, 0x7d, 0x14, 0x46,
	0x71, 0x2b, 0xbf, 0x5d, 0xdf, 0x7d, 0xa7, 0x9d, 0x08, 0x68, 0x2f, 0x4e, 0xd3, 0x8b, 0xd1, 0x89,
	0x95, 0x71, 0x22, 0x0f, 0x21, 0xef, 0x4a, 0x6e, 0x94, 0xb6, 0xb4, 0xed, 0xca, 0x2e, 0x49, 0x7d,
	0x9f, 0x1d, 0x5b, 0x3d, 0x16, 0xbc, 0xf0, 0xbd, 0x4f, 0x97, 0x2c, 0x05, 0x90, 0xa7, 0xa0, 0x3b,
	0x43, 0xea, 0x73, 0xff, 0xc5, 0xc4, 0xd0, 0x23, 0xf8, 0x7e, 0x0a, 0xf7, 0x92, 0x81, 0xd4, 0x23,
	0x45, 0xc9, 0x0e, 0x14, 0x5d, 0xe6, 0x9c, 0x22, 0x37, 0xca, 0x91, 0xd3, 0xfa, 0x6c, 0x86, 0xc8,
	0x9c, 0xba, 0x24, 0x18, 0x79, 0x17, 0x0a, 0xdf, 0x86, 0x74, 0x62, 0x40, 0x84, 0xaf, 0xa5, 0xf8,
	0x97, 0x21, 0x9d, 0xc5, 0x8f, 0x10, 0x25, 0x1d, 0x1d, 0x6e, 0x54, 0x16, 0xa4, 0xf7, 0x7b, 0x19,
	0xe9, 0xe8, 0x70, 0xb2, 0x0b, 0x25, 0x89, 0x01, 0x3d, 0x19, 0xa2, 0x51, 0x8d, 0xd8, 0x7b, 0x29,
	0x7b, 0x1c, 0xdb, 0x53, 0x7e, 0x0a, 0x2a, 0xdd, 0x1e, 0x63, 0xde, 0x10, 0x8d, 0xda, 0x82, 0xee,
	0xfd, 0xc8, 0x3c, 0xd3, 0x1d, 0x63, 0xe4, 0x11, 0x2c, 0x47, 0x8b, 0x36, 0xea, 0x11, 0xdf, 0x9c,
	0x4f, 0x4e, 0x8a, 0xc7, 0x90, 0x92, 0x44, 0x03, 0xe7, 0x25, 0xe3, 0x68, 0xac, 0x2e, 0x48, 0xea,
	0xc4, 0xf6, 0x99, 0xa4, 0x04, 0x24, 0x6d, 0xc8, 0xfb, 0x27, 0x23, 0xa3, 0x19, 0xf1, 0x1b, 0xb3,
	0x5d, 0xee, 0x7e, 0x6e, 0xa1, 0xe7, 0x0b, 0xc9, 0x67, 0xf9, 0x51, 0x20, 0x79, 0x00, 0x35, 0x1a,
	0x4a, 0xe6, 0x61, 0x80, 0x9c, 0x4a, 0x74, 0x8d, 0x95, 0x2d, 0x6d, 0x5b, 0xb7, 0xe6, 0x8d, 0xe4,
	0x6d, 0x00, 0x67, 0x18, 0x0a, 0x89, 0xdc, 0xf6, 0x5d, 0xa3, 0x11, 0x15, 0x57, 0x39, 0xb1, 0x0c,
	0x5c, 0xb2, 0x0b, 0xeb, 0xe2, 0xd4, 0x1f, 0xdb, 0x12, 0x85, 0xcc, 0x16, 0xbb, 0x41, 0xa2, 0x60,
	0x6b, 0x6a, 0xf0, 0x18, 0x85, 0xcc, 0x94, 0x59, 0x77, 0x0d, 0x56, 0xb3, 0x55, 0x17, 0x89, 0x3a,
	0x28, 0xe8, 0x85, 0xc6, 0xf2, 0x41, 0x41, 0x5f, 0x6e, 0x14, 0x0f, 0x0a, 0xfa, 0x5a, 0xa3, 0x69,
	0x7e, 0xaf, 0xc1, 0xea, 0x25, 0xf1, 0xe4, 0x33, 0xd0, 0x31, 0x70, 0xc7, 0xcc, 0x0f, 0x64, 0xdc,
	0x10, 0xdd, 0xc7, 0x17, 0x67, 0xad, 0x47, 0xc2, 0xe1, 0xe1, 0xc9, 0x9e, 0xe9, 0xe2, 0x18, 0x03,
	0x17, 0x03, 0x69, 0x6e, 0xbd, 0xa2, 0x43, 0xdf, 0xa5, 0x12, 0xf7, 0xcc, 0x80, 0x0d, 0x99, 0x43,
	0x87, 0x53, 0x37, 0xd3, 0x4a, 0x23, 0x90, 0xf7, 0xa1, 0x44, 0xc7, 0xbe, 0x7d, 0x8a, 0x93, 0xb8,
	0x97, 0xba, 0xe4, 0xe2, 0xac, 0x55, 0x4f, 0x82, 0xd1, 0xe1, 0x6b, 0x3a, 0x11, 0xa6, 0x55, 0xa4,
	0x63, 0xff, 0x39, 0x4e, 0xcc, 0x1f, 0x35, 0x80, 0x59, 0x99, 0xdd, 0xb1, 0x92, 0x5d, 0x00, 0x46,
	0x43, 0xf9, 0xf2, 0x98, 0x9d, 0x62, 0x70, 0x8d, 0x98, 0x0c, 0x45, 0x36, 0x40, 0xf7, 0x03, 0x81,
	0x4e, 0xc8, 0xe3, 0xb6, 0xd7, 0xad, 0xf4, 0xdf, 0x44, 0xa8, 0x64, 0x2a, 0x8b, 0xec, 0x5d, 0x12,
	0xbb, 0x79, 0x71, 0xd6, 0xda, 0xb8, 0x91, 0xb4, 0xec, 0x34, 0xb9, 0x85, 0x69, 0x7e, 0xd1, 0xa0,
	0x3e, 0xdf, 0xde, 0xb7, 0x9a, 0xaa, 0x07, 0x35, 0x8f, 0x8f, 0x1d, 0x3b, 0x0d, 0x90, 0xbf, 0x51,
	0x80, 0xaa, 0x72, 0xea, 0x4f, 0x83, 0x3c, 0x86, 0x66, 0x10, 0x8e, 0x6c, 0x87, 0x05, 0x4e, 0xc8,
	0x39, 0x06, 0xd2, 0x16, 0x0e, 0x0d, 0x44, 0xa4, 0x7d, 0xd9, 0x22, 0x41, 0x38, 0xea, 0xa5, 0x43,
	0x47, 0x6a, 0xc4, 0xfc, 0x43, 0x83, 0x6a, 0xf6, 0xbc, 0xb9, 0xe3, 0xbd, 0x7d, 0x02, 0x7a, 0x28,
	0x90, 0xcf, 0x8e, 0xec, 0xee, 0xfa, 0xc5, 0x59, 0x6b, 0xf5, 0x52, 0x34, 0x2b, 0xc5, 0x48, 0x1b,
	0xf4, 0x31, 0x15, 0xe2, 0x35, 0xe3, 0x6e, 0x92, 0x83, 0x7f, 0x2b, 0x86, 0x94, 0x99, 0xdb, 0xa3,
	0xc2, 0xc2, 0x1e, 0xfd, 0x9c, 0x87, 0x72, 0x7a, 0xe8, 0x91, 0x16, 0x54, 0x78, 0xd2, 0x52, 0x76,
	0x7a, 0xa9, 0xc0, 0xd4, 0x34, 0x70, 0xc9, 0x47, 0x50, 0xa3, 0x8e, 0x83, 0x42, 0xa8, 0xb6, 0x50,
	0xc8, 0xd5, 0xc5, 0x58, 0x89, 0xc1, 0xe7, 0xa8, 0xfc, 0x3e, 0x81, 0x55, 0x81, 0x0e, 0x47, 0x69,
	0xcf, 0xdc, 0xaf, 0xd1, 0xbe, 0x12, 0xc3, 0x9d, 0x69, 0x04, 0x72, 0x0f, 0x8a, 0x4a, 0x05, 0x0b,
	0xa2, 0x05, 0x94, 0xad, 0xe4, 0x8f, 0xb4, 0xa1, 0x14, 0x0a, 0xb4, 0x7d, 0x3a, 0x32, 0x96, 0xd5,
	0xca, 0xae, 0x4a, 0x5e, 0x31, 0x14, 0x38, 0xa0, 0xa3, 0xb9, 0xbd, 0x2b, 0xde, 0x7a, 0xef, 0x1e,
	0xc2, 0x8a, 0x9a, 0x9d, 0x0a, 0x11, 0x8e, 0xd0, 0xe6, 0x6c, 0x88, 0xd1, 0x5d, 0xa8, 0x5b, 0xb5,
	0x50, 0x60, 0x27, 0xb2, 0x5a, 0x6c, 0x88, 0xe4, 0x01, 0xd4, 0x33, 0x8c, 0x4a, 0x9b, 0x1e, 0xad,
	0xa2, 0x4a, 0x53, 0x66, 0xe0, 0x92, 0xa7, 0x70, 0x3f, 0x4b, 0xe1, 0x1b, 0xa9, 0xf6, 0x7b, 0xa8,
	0xf0, 0x72, 0x84, 0x37, 0x67, 0x78, 0x3f, 0x19, 0x1c, 0xb8, 0xe6, 0xef, 0x1a, 0x94, 0xd3, 0x1b,
	0x77, 0xae, 0x9c, 0xb4, 0xff, 0x5e, 0x4e, 0xb9, 0x1b, 0x94, 0x53, 0x36, 0x87, 0xf9, 0x5b, 0xe7,
	0xf0, 0xba, 0xe2, 0xfc, 0x49, 0x83, 0x6a, 0xf6, 0xca, 0xbc, 0xe3, 0xd6, 0xfb, 0x18, 0x56, 0x04,
	0xf2, 0x57, 0xbe, 0x83, 0xaa, 0x2a, 0x59, 0x18, 0xc8, 0x6b, 0xd6, 0x5f, 0x4f, 0xd0, 0x4e, 0x4c,
	0x12, 0x03, 0x4a, 0x63, 0xce, 0xbe, 0x41, 0x27, 0x49, 0x82, 0x35, 0xfd, 0x35, 0x43, 0xa8, 0xcd,
	0x3d, 0x0d, 0xc8, 0x13, 0x80, 0x4c, 0xd5, 0x6b, 0x57, 0x4e, 0x51, 0x4e, 0x3b, 0x46, 0xb9, 0x24,
	0xfd, 0x72, 0xfd, 0xf5, 0x53, 0x8e, 0x29, 0x75, 0x03, 0xfd, 0xa9, 0x41, 0x6d, 0xee, 0xfe, 0xff,
	0x5f, 0x1d, 0x54, 0xef, 0xed, 0x83, 0x71, 0xd5, 0x9b, 0x94, 0x54, 0x41, 0xb7, 0xfa, 0xfb, 0x83,
	0xa3, 0x63, 0xeb, 0xab, 0xc6, 0x12, 0xa9, 0x40, 0xe9, 0xa8, 0xd7, 0x39, 0x3c, 0xec, 0x5b, 0x0d,
	0x8d, 0x34, 0xa0, 0x7a, 0xf8, 0xc5, 0xb3, 0xbe, 0x3d, 0xb5, 0xe4, 0xba, 0x1f, 0xfe, 0x7a, 0xbe,
	0xa9, 0xfd, 0x76, 0xbe, 0xa9, 0xfd, 0x75, 0xbe, 0xa9, 0xfd, 0xf0, 0xf7, 0xe6, 0x12, 0xbc, 0xe5,
	0xb3, 0xb6, 0x90, 0xd4, 0x39, 0xe5, 0xec, 0x4d, 0xfc, 0xd2, 0x9e, 0x3e, 0x90, 0xbe, 0x9e, 0x3e,
	0xc8, 0x4f, 0x8a, 0x91, 0xfd, 0x83, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff, 0x05, 0xed, 0xcd, 0x3d,
	0xc3, 0x0b, 0x00, 0x00,
}

func (m *ImageIntegration) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImageIntegration) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageIntegration) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IntegrationConfig != nil {
		{
			size := m.IntegrationConfig.Size()
			i -= size
			if _, err := m.IntegrationConfig.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.SkipTestIntegration {
		i--
		if m.SkipTestIntegration {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x90
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if m.Autogenerated {
		i--
		if m.Autogenerated {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x78
	}
	if len(m.Categories) > 0 {
		dAtA2 := make([]byte, len(m.Categories)*10)
		var j1 int
		for _, num := range m.Categories {
			for num >= 1<<7 {
				dAtA2[j1] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j1++
			}
			dAtA2[j1] = uint8(num)
			j1++
		}
		i -= j1
		copy(dAtA[i:], dAtA2[:j1])
		i = encodeVarintImageIntegration(dAtA, i, uint64(j1))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ImageIntegration_Dtr) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageIntegration_Dtr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Dtr != nil {
		{
			size, err := m.Dtr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImageIntegration(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *ImageIntegration_Clairify) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageIntegration_Clairify) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Clairify != nil {
		{
			size, err := m.Clairify.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImageIntegration(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	return len(dAtA) - i, nil
}
func (m *ImageIntegration_Docker) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageIntegration_Docker) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Docker != nil {
		{
			size, err := m.Docker.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImageIntegration(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	return len(dAtA) - i, nil
}
func (m *ImageIntegration_Quay) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageIntegration_Quay) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Quay != nil {
		{
			size, err := m.Quay.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImageIntegration(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	return len(dAtA) - i, nil
}
func (m *ImageIntegration_Ecr) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageIntegration_Ecr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Ecr != nil {
		{
			size, err := m.Ecr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImageIntegration(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	return len(dAtA) - i, nil
}
func (m *ImageIntegration_Tenable) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageIntegration_Tenable) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Tenable != nil {
		{
			size, err := m.Tenable.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImageIntegration(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	return len(dAtA) - i, nil
}
func (m *ImageIntegration_Google) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageIntegration_Google) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Google != nil {
		{
			size, err := m.Google.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImageIntegration(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	return len(dAtA) - i, nil
}
func (m *ImageIntegration_Clair) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageIntegration_Clair) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Clair != nil {
		{
			size, err := m.Clair.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImageIntegration(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x72
	}
	return len(dAtA) - i, nil
}
func (m *ImageIntegration_Anchore) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageIntegration_Anchore) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Anchore != nil {
		{
			size, err := m.Anchore.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImageIntegration(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	return len(dAtA) - i, nil
}
func (m *ImageIntegration_Ibm) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageIntegration_Ibm) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Ibm != nil {
		{
			size, err := m.Ibm.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImageIntegration(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	return len(dAtA) - i, nil
}
func (m *IBMRegistryConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IBMRegistryConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IBMRegistryConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ApiKey) > 0 {
		i -= len(m.ApiKey)
		copy(dAtA[i:], m.ApiKey)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.ApiKey)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Endpoint) > 0 {
		i -= len(m.Endpoint)
		copy(dAtA[i:], m.Endpoint)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Endpoint)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *QuayConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuayConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QuayConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Insecure {
		i--
		if m.Insecure {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.OauthToken) > 0 {
		i -= len(m.OauthToken)
		copy(dAtA[i:], m.OauthToken)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.OauthToken)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Endpoint) > 0 {
		i -= len(m.Endpoint)
		copy(dAtA[i:], m.Endpoint)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Endpoint)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ClairConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClairConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClairConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Insecure {
		i--
		if m.Insecure {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Endpoint) > 0 {
		i -= len(m.Endpoint)
		copy(dAtA[i:], m.Endpoint)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Endpoint)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ClairifyConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClairifyConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClairifyConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.GrpcEndpoint) > 0 {
		i -= len(m.GrpcEndpoint)
		copy(dAtA[i:], m.GrpcEndpoint)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.GrpcEndpoint)))
		i--
		dAtA[i] = 0x1a
	}
	if m.NumConcurrentScans != 0 {
		i = encodeVarintImageIntegration(dAtA, i, uint64(m.NumConcurrentScans))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Endpoint) > 0 {
		i -= len(m.Endpoint)
		copy(dAtA[i:], m.Endpoint)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Endpoint)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DockerConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DockerConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DockerConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Insecure {
		i--
		if m.Insecure {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.Password) > 0 {
		i -= len(m.Password)
		copy(dAtA[i:], m.Password)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Password)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Username) > 0 {
		i -= len(m.Username)
		copy(dAtA[i:], m.Username)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Username)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Endpoint) > 0 {
		i -= len(m.Endpoint)
		copy(dAtA[i:], m.Endpoint)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Endpoint)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ECRConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ECRConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ECRConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AssumeRoleExternalId) > 0 {
		i -= len(m.AssumeRoleExternalId)
		copy(dAtA[i:], m.AssumeRoleExternalId)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.AssumeRoleExternalId)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.AssumeRoleId) > 0 {
		i -= len(m.AssumeRoleId)
		copy(dAtA[i:], m.AssumeRoleId)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.AssumeRoleId)))
		i--
		dAtA[i] = 0x42
	}
	if m.UseAssumeRole {
		i--
		if m.UseAssumeRole {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if len(m.Endpoint) > 0 {
		i -= len(m.Endpoint)
		copy(dAtA[i:], m.Endpoint)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Endpoint)))
		i--
		dAtA[i] = 0x32
	}
	if m.UseIam {
		i--
		if m.UseIam {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.Region) > 0 {
		i -= len(m.Region)
		copy(dAtA[i:], m.Region)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Region)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.SecretAccessKey) > 0 {
		i -= len(m.SecretAccessKey)
		copy(dAtA[i:], m.SecretAccessKey)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.SecretAccessKey)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.AccessKeyId) > 0 {
		i -= len(m.AccessKeyId)
		copy(dAtA[i:], m.AccessKeyId)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.AccessKeyId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.RegistryId) > 0 {
		i -= len(m.RegistryId)
		copy(dAtA[i:], m.RegistryId)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.RegistryId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DTRConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DTRConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DTRConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Insecure {
		i--
		if m.Insecure {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.Endpoint) > 0 {
		i -= len(m.Endpoint)
		copy(dAtA[i:], m.Endpoint)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Endpoint)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Password) > 0 {
		i -= len(m.Password)
		copy(dAtA[i:], m.Password)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Password)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Username) > 0 {
		i -= len(m.Username)
		copy(dAtA[i:], m.Username)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Username)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GoogleConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GoogleConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GoogleConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Project) > 0 {
		i -= len(m.Project)
		copy(dAtA[i:], m.Project)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Project)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ServiceAccount) > 0 {
		i -= len(m.ServiceAccount)
		copy(dAtA[i:], m.ServiceAccount)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.ServiceAccount)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Endpoint) > 0 {
		i -= len(m.Endpoint)
		copy(dAtA[i:], m.Endpoint)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Endpoint)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TenableConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TenableConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TenableConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.SecretKey) > 0 {
		i -= len(m.SecretKey)
		copy(dAtA[i:], m.SecretKey)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.SecretKey)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.AccessKey) > 0 {
		i -= len(m.AccessKey)
		copy(dAtA[i:], m.AccessKey)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.AccessKey)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AnchoreConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AnchoreConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AnchoreConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Insecure {
		i--
		if m.Insecure {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.Password) > 0 {
		i -= len(m.Password)
		copy(dAtA[i:], m.Password)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Password)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Username) > 0 {
		i -= len(m.Username)
		copy(dAtA[i:], m.Username)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Username)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Endpoint) > 0 {
		i -= len(m.Endpoint)
		copy(dAtA[i:], m.Endpoint)
		i = encodeVarintImageIntegration(dAtA, i, uint64(len(m.Endpoint)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintImageIntegration(dAtA []byte, offset int, v uint64) int {
	offset -= sovImageIntegration(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ImageIntegration) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	if len(m.Categories) > 0 {
		l = 0
		for _, e := range m.Categories {
			l += sovImageIntegration(uint64(e))
		}
		n += 1 + sovImageIntegration(uint64(l)) + l
	}
	if m.IntegrationConfig != nil {
		n += m.IntegrationConfig.Size()
	}
	if m.Autogenerated {
		n += 2
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 2 + l + sovImageIntegration(uint64(l))
	}
	if m.SkipTestIntegration {
		n += 3
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ImageIntegration_Dtr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Dtr != nil {
		l = m.Dtr.Size()
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	return n
}
func (m *ImageIntegration_Clairify) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Clairify != nil {
		l = m.Clairify.Size()
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	return n
}
func (m *ImageIntegration_Docker) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Docker != nil {
		l = m.Docker.Size()
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	return n
}
func (m *ImageIntegration_Quay) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Quay != nil {
		l = m.Quay.Size()
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	return n
}
func (m *ImageIntegration_Ecr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Ecr != nil {
		l = m.Ecr.Size()
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	return n
}
func (m *ImageIntegration_Tenable) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Tenable != nil {
		l = m.Tenable.Size()
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	return n
}
func (m *ImageIntegration_Google) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Google != nil {
		l = m.Google.Size()
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	return n
}
func (m *ImageIntegration_Clair) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Clair != nil {
		l = m.Clair.Size()
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	return n
}
func (m *ImageIntegration_Anchore) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Anchore != nil {
		l = m.Anchore.Size()
		n += 2 + l + sovImageIntegration(uint64(l))
	}
	return n
}
func (m *ImageIntegration_Ibm) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Ibm != nil {
		l = m.Ibm.Size()
		n += 2 + l + sovImageIntegration(uint64(l))
	}
	return n
}
func (m *IBMRegistryConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	l = len(m.ApiKey)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *QuayConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	l = len(m.OauthToken)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	if m.Insecure {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ClairConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	if m.Insecure {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ClairifyConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	if m.NumConcurrentScans != 0 {
		n += 1 + sovImageIntegration(uint64(m.NumConcurrentScans))
	}
	l = len(m.GrpcEndpoint)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DockerConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	l = len(m.Password)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	if m.Insecure {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ECRConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.RegistryId)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	l = len(m.AccessKeyId)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	l = len(m.SecretAccessKey)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	l = len(m.Region)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	if m.UseIam {
		n += 2
	}
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	if m.UseAssumeRole {
		n += 2
	}
	l = len(m.AssumeRoleId)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	l = len(m.AssumeRoleExternalId)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DTRConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	l = len(m.Password)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	if m.Insecure {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GoogleConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	l = len(m.ServiceAccount)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	l = len(m.Project)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TenableConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.AccessKey)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	l = len(m.SecretKey)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AnchoreConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	l = len(m.Password)
	if l > 0 {
		n += 1 + l + sovImageIntegration(uint64(l))
	}
	if m.Insecure {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovImageIntegration(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozImageIntegration(x uint64) (n int) {
	return sovImageIntegration(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ImageIntegration) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageIntegration
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImageIntegration: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImageIntegration: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType == 0 {
				var v ImageIntegrationCategory
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowImageIntegration
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= ImageIntegrationCategory(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Categories = append(m.Categories, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowImageIntegration
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthImageIntegration
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthImageIntegration
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.Categories) == 0 {
					m.Categories = make([]ImageIntegrationCategory, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v ImageIntegrationCategory
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowImageIntegration
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= ImageIntegrationCategory(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Categories = append(m.Categories, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Categories", wireType)
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dtr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DTRConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.IntegrationConfig = &ImageIntegration_Dtr{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Clairify", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ClairifyConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.IntegrationConfig = &ImageIntegration_Clairify{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Docker", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DockerConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.IntegrationConfig = &ImageIntegration_Docker{v}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quay", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &QuayConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.IntegrationConfig = &ImageIntegration_Quay{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ecr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ECRConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.IntegrationConfig = &ImageIntegration_Ecr{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tenable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TenableConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.IntegrationConfig = &ImageIntegration_Tenable{v}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Google", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GoogleConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.IntegrationConfig = &ImageIntegration_Google{v}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Clair", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ClairConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.IntegrationConfig = &ImageIntegration_Clair{v}
			iNdEx = postIndex
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Autogenerated", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Autogenerated = bool(v != 0)
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Anchore", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AnchoreConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.IntegrationConfig = &ImageIntegration_Anchore{v}
			iNdEx = postIndex
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SkipTestIntegration", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SkipTestIntegration = bool(v != 0)
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ibm", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &IBMRegistryConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.IntegrationConfig = &ImageIntegration_Ibm{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImageIntegration(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IBMRegistryConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageIntegration
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IBMRegistryConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IBMRegistryConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImageIntegration(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuayConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageIntegration
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuayConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuayConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OauthToken", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OauthToken = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Insecure", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Insecure = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipImageIntegration(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClairConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageIntegration
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClairConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClairConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Insecure", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Insecure = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipImageIntegration(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClairifyConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageIntegration
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClairifyConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClairifyConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumConcurrentScans", wireType)
			}
			m.NumConcurrentScans = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumConcurrentScans |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GrpcEndpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GrpcEndpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImageIntegration(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DockerConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageIntegration
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DockerConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DockerConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Password", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Password = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Insecure", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Insecure = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipImageIntegration(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ECRConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageIntegration
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ECRConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ECRConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegistryId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RegistryId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessKeyId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessKeyId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretAccessKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SecretAccessKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Region", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Region = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseIam", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UseIam = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseAssumeRole", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UseAssumeRole = bool(v != 0)
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AssumeRoleId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AssumeRoleId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AssumeRoleExternalId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AssumeRoleExternalId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImageIntegration(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DTRConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageIntegration
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DTRConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DTRConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Password", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Password = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Insecure", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Insecure = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipImageIntegration(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GoogleConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageIntegration
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GoogleConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GoogleConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceAccount", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceAccount = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Project = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImageIntegration(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TenableConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageIntegration
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TenableConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TenableConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SecretKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImageIntegration(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AnchoreConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageIntegration
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AnchoreConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AnchoreConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Password", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Password = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Insecure", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Insecure = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipImageIntegration(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageIntegration
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipImageIntegration(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowImageIntegration
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowImageIntegration
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthImageIntegration
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupImageIntegration
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthImageIntegration
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthImageIntegration        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowImageIntegration          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupImageIntegration = fmt.Errorf("proto: unexpected end of group")
)
