// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/network_flow.proto

package storage

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type L4Protocol int32

const (
	L4Protocol_L4_PROTOCOL_UNKNOWN L4Protocol = 0
	L4Protocol_L4_PROTOCOL_TCP     L4Protocol = 1
	L4Protocol_L4_PROTOCOL_UDP     L4Protocol = 2
	L4Protocol_L4_PROTOCOL_ICMP    L4Protocol = 3
	L4Protocol_L4_PROTOCOL_RAW     L4Protocol = 4
	L4Protocol_L4_PROTOCOL_SCTP    L4Protocol = 5
	L4Protocol_L4_PROTOCOL_ANY     L4Protocol = -1
)

var L4Protocol_name = map[int32]string{
	0:  "L4_PROTOCOL_UNKNOWN",
	1:  "L4_PROTOCOL_TCP",
	2:  "L4_PROTOCOL_UDP",
	3:  "L4_PROTOCOL_ICMP",
	4:  "L4_PROTOCOL_RAW",
	5:  "L4_PROTOCOL_SCTP",
	-1: "L4_PROTOCOL_ANY",
}

var L4Protocol_value = map[string]int32{
	"L4_PROTOCOL_UNKNOWN": 0,
	"L4_PROTOCOL_TCP":     1,
	"L4_PROTOCOL_UDP":     2,
	"L4_PROTOCOL_ICMP":    3,
	"L4_PROTOCOL_RAW":     4,
	"L4_PROTOCOL_SCTP":    5,
	"L4_PROTOCOL_ANY":     -1,
}

func (x L4Protocol) String() string {
	return proto.EnumName(L4Protocol_name, int32(x))
}

func (L4Protocol) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a6317ef286eb605d, []int{0}
}

type NetworkEntityInfo_Type int32

const (
	NetworkEntityInfo_UNKNOWN_TYPE    NetworkEntityInfo_Type = 0
	NetworkEntityInfo_DEPLOYMENT      NetworkEntityInfo_Type = 1
	NetworkEntityInfo_INTERNET        NetworkEntityInfo_Type = 2
	NetworkEntityInfo_LISTEN_ENDPOINT NetworkEntityInfo_Type = 3
	NetworkEntityInfo_EXTERNAL_SOURCE NetworkEntityInfo_Type = 4
)

var NetworkEntityInfo_Type_name = map[int32]string{
	0: "UNKNOWN_TYPE",
	1: "DEPLOYMENT",
	2: "INTERNET",
	3: "LISTEN_ENDPOINT",
	4: "EXTERNAL_SOURCE",
}

var NetworkEntityInfo_Type_value = map[string]int32{
	"UNKNOWN_TYPE":    0,
	"DEPLOYMENT":      1,
	"INTERNET":        2,
	"LISTEN_ENDPOINT": 3,
	"EXTERNAL_SOURCE": 4,
}

func (x NetworkEntityInfo_Type) String() string {
	return proto.EnumName(NetworkEntityInfo_Type_name, int32(x))
}

func (NetworkEntityInfo_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a6317ef286eb605d, []int{5, 0}
}

type NetworkFlow struct {
	Props                *NetworkFlowProperties `protobuf:"bytes,1,opt,name=props,proto3" json:"props,omitempty"`
	LastSeenTimestamp    *types.Timestamp       `protobuf:"bytes,2,opt,name=last_seen_timestamp,json=lastSeenTimestamp,proto3" json:"last_seen_timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *NetworkFlow) Reset()         { *m = NetworkFlow{} }
func (m *NetworkFlow) String() string { return proto.CompactTextString(m) }
func (*NetworkFlow) ProtoMessage()    {}
func (*NetworkFlow) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6317ef286eb605d, []int{0}
}
func (m *NetworkFlow) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkFlow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkFlow.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkFlow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkFlow.Merge(m, src)
}
func (m *NetworkFlow) XXX_Size() int {
	return m.Size()
}
func (m *NetworkFlow) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkFlow.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkFlow proto.InternalMessageInfo

func (m *NetworkFlow) GetProps() *NetworkFlowProperties {
	if m != nil {
		return m.Props
	}
	return nil
}

func (m *NetworkFlow) GetLastSeenTimestamp() *types.Timestamp {
	if m != nil {
		return m.LastSeenTimestamp
	}
	return nil
}

func (m *NetworkFlow) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkFlow) Clone() *NetworkFlow {
	if m == nil {
		return nil
	}
	cloned := new(NetworkFlow)
	*cloned = *m

	cloned.Props = m.Props.Clone()
	cloned.LastSeenTimestamp = m.LastSeenTimestamp.Clone()
	return cloned
}

type NetworkFlowProperties struct {
	// The source deployment ID of the network flow
	SrcEntity *NetworkEntityInfo `protobuf:"bytes,1,opt,name=src_entity,json=srcEntity,proto3" json:"src_entity,omitempty"`
	// The destination deployment ID of the network flow
	DstEntity *NetworkEntityInfo `protobuf:"bytes,2,opt,name=dst_entity,json=dstEntity,proto3" json:"dst_entity,omitempty"`
	// may be 0 if not applicable (e.g., icmp).
	DstPort              uint32     `protobuf:"varint,3,opt,name=dst_port,json=dstPort,proto3" json:"dst_port,omitempty"`
	L4Protocol           L4Protocol `protobuf:"varint,4,opt,name=l4protocol,proto3,enum=storage.L4Protocol" json:"l4protocol,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *NetworkFlowProperties) Reset()         { *m = NetworkFlowProperties{} }
func (m *NetworkFlowProperties) String() string { return proto.CompactTextString(m) }
func (*NetworkFlowProperties) ProtoMessage()    {}
func (*NetworkFlowProperties) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6317ef286eb605d, []int{1}
}
func (m *NetworkFlowProperties) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkFlowProperties) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkFlowProperties.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkFlowProperties) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkFlowProperties.Merge(m, src)
}
func (m *NetworkFlowProperties) XXX_Size() int {
	return m.Size()
}
func (m *NetworkFlowProperties) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkFlowProperties.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkFlowProperties proto.InternalMessageInfo

func (m *NetworkFlowProperties) GetSrcEntity() *NetworkEntityInfo {
	if m != nil {
		return m.SrcEntity
	}
	return nil
}

func (m *NetworkFlowProperties) GetDstEntity() *NetworkEntityInfo {
	if m != nil {
		return m.DstEntity
	}
	return nil
}

func (m *NetworkFlowProperties) GetDstPort() uint32 {
	if m != nil {
		return m.DstPort
	}
	return 0
}

func (m *NetworkFlowProperties) GetL4Protocol() L4Protocol {
	if m != nil {
		return m.L4Protocol
	}
	return L4Protocol_L4_PROTOCOL_UNKNOWN
}

func (m *NetworkFlowProperties) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkFlowProperties) Clone() *NetworkFlowProperties {
	if m == nil {
		return nil
	}
	cloned := new(NetworkFlowProperties)
	*cloned = *m

	cloned.SrcEntity = m.SrcEntity.Clone()
	cloned.DstEntity = m.DstEntity.Clone()
	return cloned
}

type NetworkEndpoint struct {
	Props                *NetworkEndpointProperties `protobuf:"bytes,1,opt,name=props,proto3" json:"props,omitempty"`
	LastActiveTimestamp  *types.Timestamp           `protobuf:"bytes,2,opt,name=last_active_timestamp,json=lastActiveTimestamp,proto3" json:"last_active_timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *NetworkEndpoint) Reset()         { *m = NetworkEndpoint{} }
func (m *NetworkEndpoint) String() string { return proto.CompactTextString(m) }
func (*NetworkEndpoint) ProtoMessage()    {}
func (*NetworkEndpoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6317ef286eb605d, []int{2}
}
func (m *NetworkEndpoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkEndpoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkEndpoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkEndpoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkEndpoint.Merge(m, src)
}
func (m *NetworkEndpoint) XXX_Size() int {
	return m.Size()
}
func (m *NetworkEndpoint) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkEndpoint.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkEndpoint proto.InternalMessageInfo

func (m *NetworkEndpoint) GetProps() *NetworkEndpointProperties {
	if m != nil {
		return m.Props
	}
	return nil
}

func (m *NetworkEndpoint) GetLastActiveTimestamp() *types.Timestamp {
	if m != nil {
		return m.LastActiveTimestamp
	}
	return nil
}

func (m *NetworkEndpoint) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkEndpoint) Clone() *NetworkEndpoint {
	if m == nil {
		return nil
	}
	cloned := new(NetworkEndpoint)
	*cloned = *m

	cloned.Props = m.Props.Clone()
	cloned.LastActiveTimestamp = m.LastActiveTimestamp.Clone()
	return cloned
}

type NetworkEndpointProperties struct {
	Entity               *NetworkEntityInfo `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	Port                 uint32             `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	L4Protocol           L4Protocol         `protobuf:"varint,3,opt,name=l4protocol,proto3,enum=storage.L4Protocol" json:"l4protocol,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *NetworkEndpointProperties) Reset()         { *m = NetworkEndpointProperties{} }
func (m *NetworkEndpointProperties) String() string { return proto.CompactTextString(m) }
func (*NetworkEndpointProperties) ProtoMessage()    {}
func (*NetworkEndpointProperties) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6317ef286eb605d, []int{3}
}
func (m *NetworkEndpointProperties) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkEndpointProperties) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkEndpointProperties.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkEndpointProperties) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkEndpointProperties.Merge(m, src)
}
func (m *NetworkEndpointProperties) XXX_Size() int {
	return m.Size()
}
func (m *NetworkEndpointProperties) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkEndpointProperties.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkEndpointProperties proto.InternalMessageInfo

func (m *NetworkEndpointProperties) GetEntity() *NetworkEntityInfo {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *NetworkEndpointProperties) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *NetworkEndpointProperties) GetL4Protocol() L4Protocol {
	if m != nil {
		return m.L4Protocol
	}
	return L4Protocol_L4_PROTOCOL_UNKNOWN
}

func (m *NetworkEndpointProperties) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkEndpointProperties) Clone() *NetworkEndpointProperties {
	if m == nil {
		return nil
	}
	cloned := new(NetworkEndpointProperties)
	*cloned = *m

	cloned.Entity = m.Entity.Clone()
	return cloned
}

type NetworkEntity struct {
	Info *NetworkEntityInfo `protobuf:"bytes,1,opt,name=info,proto3" json:"info,omitempty"`
	// `scope` represents known cluster network peers to which the flows must be scoped. In future, to restrict flows
	// to more granular entities, such as deployment, scope could include deployment ID.
	// Note: The highest scope level is cluster.
	Scope                *NetworkEntity_Scope `protobuf:"bytes,2,opt,name=scope,proto3" json:"scope,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *NetworkEntity) Reset()         { *m = NetworkEntity{} }
func (m *NetworkEntity) String() string { return proto.CompactTextString(m) }
func (*NetworkEntity) ProtoMessage()    {}
func (*NetworkEntity) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6317ef286eb605d, []int{4}
}
func (m *NetworkEntity) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkEntity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkEntity.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkEntity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkEntity.Merge(m, src)
}
func (m *NetworkEntity) XXX_Size() int {
	return m.Size()
}
func (m *NetworkEntity) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkEntity.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkEntity proto.InternalMessageInfo

func (m *NetworkEntity) GetInfo() *NetworkEntityInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *NetworkEntity) GetScope() *NetworkEntity_Scope {
	if m != nil {
		return m.Scope
	}
	return nil
}

func (m *NetworkEntity) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkEntity) Clone() *NetworkEntity {
	if m == nil {
		return nil
	}
	cloned := new(NetworkEntity)
	*cloned = *m

	cloned.Info = m.Info.Clone()
	cloned.Scope = m.Scope.Clone()
	return cloned
}

type NetworkEntity_Scope struct {
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NetworkEntity_Scope) Reset()         { *m = NetworkEntity_Scope{} }
func (m *NetworkEntity_Scope) String() string { return proto.CompactTextString(m) }
func (*NetworkEntity_Scope) ProtoMessage()    {}
func (*NetworkEntity_Scope) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6317ef286eb605d, []int{4, 0}
}
func (m *NetworkEntity_Scope) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkEntity_Scope) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkEntity_Scope.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkEntity_Scope) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkEntity_Scope.Merge(m, src)
}
func (m *NetworkEntity_Scope) XXX_Size() int {
	return m.Size()
}
func (m *NetworkEntity_Scope) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkEntity_Scope.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkEntity_Scope proto.InternalMessageInfo

func (m *NetworkEntity_Scope) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *NetworkEntity_Scope) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkEntity_Scope) Clone() *NetworkEntity_Scope {
	if m == nil {
		return nil
	}
	cloned := new(NetworkEntity_Scope)
	*cloned = *m

	return cloned
}

type NetworkEntityInfo struct {
	Type NetworkEntityInfo_Type `protobuf:"varint,1,opt,name=type,proto3,enum=storage.NetworkEntityInfo_Type" json:"type,omitempty"`
	Id   string                 `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Types that are valid to be assigned to Desc:
	//	*NetworkEntityInfo_Deployment_
	//	*NetworkEntityInfo_ExternalSource_
	Desc                 isNetworkEntityInfo_Desc `protobuf_oneof:"desc"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *NetworkEntityInfo) Reset()         { *m = NetworkEntityInfo{} }
func (m *NetworkEntityInfo) String() string { return proto.CompactTextString(m) }
func (*NetworkEntityInfo) ProtoMessage()    {}
func (*NetworkEntityInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6317ef286eb605d, []int{5}
}
func (m *NetworkEntityInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkEntityInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkEntityInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkEntityInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkEntityInfo.Merge(m, src)
}
func (m *NetworkEntityInfo) XXX_Size() int {
	return m.Size()
}
func (m *NetworkEntityInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkEntityInfo.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkEntityInfo proto.InternalMessageInfo

type isNetworkEntityInfo_Desc interface {
	isNetworkEntityInfo_Desc()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isNetworkEntityInfo_Desc
}

type NetworkEntityInfo_Deployment_ struct {
	Deployment *NetworkEntityInfo_Deployment `protobuf:"bytes,3,opt,name=deployment,proto3,oneof" json:"deployment,omitempty"`
}
type NetworkEntityInfo_ExternalSource_ struct {
	ExternalSource *NetworkEntityInfo_ExternalSource `protobuf:"bytes,4,opt,name=external_source,json=externalSource,proto3,oneof" json:"external_source,omitempty"`
}

func (*NetworkEntityInfo_Deployment_) isNetworkEntityInfo_Desc() {}
func (m *NetworkEntityInfo_Deployment_) Clone() isNetworkEntityInfo_Desc {
	if m == nil {
		return nil
	}
	cloned := new(NetworkEntityInfo_Deployment_)
	*cloned = *m

	cloned.Deployment = m.Deployment.Clone()
	return cloned
}
func (*NetworkEntityInfo_ExternalSource_) isNetworkEntityInfo_Desc() {}
func (m *NetworkEntityInfo_ExternalSource_) Clone() isNetworkEntityInfo_Desc {
	if m == nil {
		return nil
	}
	cloned := new(NetworkEntityInfo_ExternalSource_)
	*cloned = *m

	cloned.ExternalSource = m.ExternalSource.Clone()
	return cloned
}

func (m *NetworkEntityInfo) GetDesc() isNetworkEntityInfo_Desc {
	if m != nil {
		return m.Desc
	}
	return nil
}

func (m *NetworkEntityInfo) GetType() NetworkEntityInfo_Type {
	if m != nil {
		return m.Type
	}
	return NetworkEntityInfo_UNKNOWN_TYPE
}

func (m *NetworkEntityInfo) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *NetworkEntityInfo) GetDeployment() *NetworkEntityInfo_Deployment {
	if x, ok := m.GetDesc().(*NetworkEntityInfo_Deployment_); ok {
		return x.Deployment
	}
	return nil
}

func (m *NetworkEntityInfo) GetExternalSource() *NetworkEntityInfo_ExternalSource {
	if x, ok := m.GetDesc().(*NetworkEntityInfo_ExternalSource_); ok {
		return x.ExternalSource
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*NetworkEntityInfo) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*NetworkEntityInfo_Deployment_)(nil),
		(*NetworkEntityInfo_ExternalSource_)(nil),
	}
}

func (m *NetworkEntityInfo) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkEntityInfo) Clone() *NetworkEntityInfo {
	if m == nil {
		return nil
	}
	cloned := new(NetworkEntityInfo)
	*cloned = *m

	if m.Desc != nil {
		cloned.Desc = m.Desc.Clone()
	}
	return cloned
}

type NetworkEntityInfo_Deployment struct {
	Name                 string                                     `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Namespace            string                                     `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Cluster              string                                     `protobuf:"bytes,3,opt,name=cluster,proto3" json:"cluster,omitempty"` // Deprecated: Do not use.
	ListenPorts          []*NetworkEntityInfo_Deployment_ListenPort `protobuf:"bytes,4,rep,name=listen_ports,json=listenPorts,proto3" json:"listen_ports,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *NetworkEntityInfo_Deployment) Reset()         { *m = NetworkEntityInfo_Deployment{} }
func (m *NetworkEntityInfo_Deployment) String() string { return proto.CompactTextString(m) }
func (*NetworkEntityInfo_Deployment) ProtoMessage()    {}
func (*NetworkEntityInfo_Deployment) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6317ef286eb605d, []int{5, 0}
}
func (m *NetworkEntityInfo_Deployment) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkEntityInfo_Deployment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkEntityInfo_Deployment.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkEntityInfo_Deployment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkEntityInfo_Deployment.Merge(m, src)
}
func (m *NetworkEntityInfo_Deployment) XXX_Size() int {
	return m.Size()
}
func (m *NetworkEntityInfo_Deployment) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkEntityInfo_Deployment.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkEntityInfo_Deployment proto.InternalMessageInfo

func (m *NetworkEntityInfo_Deployment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *NetworkEntityInfo_Deployment) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

// Deprecated: Do not use.
func (m *NetworkEntityInfo_Deployment) GetCluster() string {
	if m != nil {
		return m.Cluster
	}
	return ""
}

func (m *NetworkEntityInfo_Deployment) GetListenPorts() []*NetworkEntityInfo_Deployment_ListenPort {
	if m != nil {
		return m.ListenPorts
	}
	return nil
}

func (m *NetworkEntityInfo_Deployment) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkEntityInfo_Deployment) Clone() *NetworkEntityInfo_Deployment {
	if m == nil {
		return nil
	}
	cloned := new(NetworkEntityInfo_Deployment)
	*cloned = *m

	if m.ListenPorts != nil {
		cloned.ListenPorts = make([]*NetworkEntityInfo_Deployment_ListenPort, len(m.ListenPorts))
		for idx, v := range m.ListenPorts {
			cloned.ListenPorts[idx] = v.Clone()
		}
	}
	return cloned
}

type NetworkEntityInfo_Deployment_ListenPort struct {
	Port                 uint32     `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
	L4Protocol           L4Protocol `protobuf:"varint,2,opt,name=l4protocol,proto3,enum=storage.L4Protocol" json:"l4protocol,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *NetworkEntityInfo_Deployment_ListenPort) Reset() {
	*m = NetworkEntityInfo_Deployment_ListenPort{}
}
func (m *NetworkEntityInfo_Deployment_ListenPort) String() string { return proto.CompactTextString(m) }
func (*NetworkEntityInfo_Deployment_ListenPort) ProtoMessage()    {}
func (*NetworkEntityInfo_Deployment_ListenPort) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6317ef286eb605d, []int{5, 0, 0}
}
func (m *NetworkEntityInfo_Deployment_ListenPort) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkEntityInfo_Deployment_ListenPort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkEntityInfo_Deployment_ListenPort.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkEntityInfo_Deployment_ListenPort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkEntityInfo_Deployment_ListenPort.Merge(m, src)
}
func (m *NetworkEntityInfo_Deployment_ListenPort) XXX_Size() int {
	return m.Size()
}
func (m *NetworkEntityInfo_Deployment_ListenPort) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkEntityInfo_Deployment_ListenPort.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkEntityInfo_Deployment_ListenPort proto.InternalMessageInfo

func (m *NetworkEntityInfo_Deployment_ListenPort) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *NetworkEntityInfo_Deployment_ListenPort) GetL4Protocol() L4Protocol {
	if m != nil {
		return m.L4Protocol
	}
	return L4Protocol_L4_PROTOCOL_UNKNOWN
}

func (m *NetworkEntityInfo_Deployment_ListenPort) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkEntityInfo_Deployment_ListenPort) Clone() *NetworkEntityInfo_Deployment_ListenPort {
	if m == nil {
		return nil
	}
	cloned := new(NetworkEntityInfo_Deployment_ListenPort)
	*cloned = *m

	return cloned
}

// Update normalizeDupNameExtSrcs(...) in `central/networkgraph/aggregator/aggregator.go` whenever this message is updated.
type NetworkEntityInfo_ExternalSource struct {
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are valid to be assigned to Source:
	//	*NetworkEntityInfo_ExternalSource_Cidr
	Source isNetworkEntityInfo_ExternalSource_Source `protobuf_oneof:"source"`
	// `default` indicates whether the external source is user-generated or system-generated.
	Default              bool     `protobuf:"varint,3,opt,name=default,proto3" json:"default,omitempty" search:"Default External Source,hidden"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NetworkEntityInfo_ExternalSource) Reset()         { *m = NetworkEntityInfo_ExternalSource{} }
func (m *NetworkEntityInfo_ExternalSource) String() string { return proto.CompactTextString(m) }
func (*NetworkEntityInfo_ExternalSource) ProtoMessage()    {}
func (*NetworkEntityInfo_ExternalSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6317ef286eb605d, []int{5, 1}
}
func (m *NetworkEntityInfo_ExternalSource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkEntityInfo_ExternalSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkEntityInfo_ExternalSource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkEntityInfo_ExternalSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkEntityInfo_ExternalSource.Merge(m, src)
}
func (m *NetworkEntityInfo_ExternalSource) XXX_Size() int {
	return m.Size()
}
func (m *NetworkEntityInfo_ExternalSource) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkEntityInfo_ExternalSource.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkEntityInfo_ExternalSource proto.InternalMessageInfo

type isNetworkEntityInfo_ExternalSource_Source interface {
	isNetworkEntityInfo_ExternalSource_Source()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isNetworkEntityInfo_ExternalSource_Source
}

type NetworkEntityInfo_ExternalSource_Cidr struct {
	Cidr string `protobuf:"bytes,2,opt,name=cidr,proto3,oneof" json:"cidr,omitempty"`
}

func (*NetworkEntityInfo_ExternalSource_Cidr) isNetworkEntityInfo_ExternalSource_Source() {}
func (m *NetworkEntityInfo_ExternalSource_Cidr) Clone() isNetworkEntityInfo_ExternalSource_Source {
	if m == nil {
		return nil
	}
	cloned := new(NetworkEntityInfo_ExternalSource_Cidr)
	*cloned = *m

	return cloned
}

func (m *NetworkEntityInfo_ExternalSource) GetSource() isNetworkEntityInfo_ExternalSource_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *NetworkEntityInfo_ExternalSource) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *NetworkEntityInfo_ExternalSource) GetCidr() string {
	if x, ok := m.GetSource().(*NetworkEntityInfo_ExternalSource_Cidr); ok {
		return x.Cidr
	}
	return ""
}

func (m *NetworkEntityInfo_ExternalSource) GetDefault() bool {
	if m != nil {
		return m.Default
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*NetworkEntityInfo_ExternalSource) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*NetworkEntityInfo_ExternalSource_Cidr)(nil),
	}
}

func (m *NetworkEntityInfo_ExternalSource) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkEntityInfo_ExternalSource) Clone() *NetworkEntityInfo_ExternalSource {
	if m == nil {
		return nil
	}
	cloned := new(NetworkEntityInfo_ExternalSource)
	*cloned = *m

	if m.Source != nil {
		cloned.Source = m.Source.Clone()
	}
	return cloned
}

func init() {
	proto.RegisterEnum("storage.L4Protocol", L4Protocol_name, L4Protocol_value)
	proto.RegisterEnum("storage.NetworkEntityInfo_Type", NetworkEntityInfo_Type_name, NetworkEntityInfo_Type_value)
	proto.RegisterType((*NetworkFlow)(nil), "storage.NetworkFlow")
	proto.RegisterType((*NetworkFlowProperties)(nil), "storage.NetworkFlowProperties")
	proto.RegisterType((*NetworkEndpoint)(nil), "storage.NetworkEndpoint")
	proto.RegisterType((*NetworkEndpointProperties)(nil), "storage.NetworkEndpointProperties")
	proto.RegisterType((*NetworkEntity)(nil), "storage.NetworkEntity")
	proto.RegisterType((*NetworkEntity_Scope)(nil), "storage.NetworkEntity.Scope")
	proto.RegisterType((*NetworkEntityInfo)(nil), "storage.NetworkEntityInfo")
	proto.RegisterType((*NetworkEntityInfo_Deployment)(nil), "storage.NetworkEntityInfo.Deployment")
	proto.RegisterType((*NetworkEntityInfo_Deployment_ListenPort)(nil), "storage.NetworkEntityInfo.Deployment.ListenPort")
	proto.RegisterType((*NetworkEntityInfo_ExternalSource)(nil), "storage.NetworkEntityInfo.ExternalSource")
}

func init() { proto.RegisterFile("storage/network_flow.proto", fileDescriptor_a6317ef286eb605d) }

var fileDescriptor_a6317ef286eb605d = []byte{
	// 881 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x55, 0xdd, 0x6e, 0xe3, 0x44,
	0x14, 0xce, 0xb8, 0x4e, 0xdb, 0x9c, 0x74, 0x53, 0xef, 0xb4, 0x2b, 0xd2, 0xa8, 0xa4, 0x51, 0x24,
	0xa0, 0xfc, 0xc8, 0x45, 0x69, 0x2e, 0x80, 0xbb, 0x26, 0x31, 0x34, 0x90, 0x75, 0xac, 0x89, 0xab,
	0xa5, 0xdc, 0x18, 0xaf, 0x3d, 0xc9, 0x5a, 0xeb, 0x7a, 0x2c, 0xcf, 0x94, 0x6e, 0xdf, 0x00, 0x89,
	0x0b, 0x6e, 0x57, 0xe2, 0x1d, 0x78, 0x0e, 0x2e, 0x79, 0x01, 0x10, 0x2a, 0x6f, 0xc0, 0x25, 0x37,
	0x20, 0x8f, 0x9d, 0xbf, 0xfe, 0x2c, 0x21, 0x37, 0x19, 0x7f, 0xe7, 0xfb, 0xce, 0x39, 0xf3, 0x9d,
	0xe3, 0x04, 0x6a, 0x5c, 0xb0, 0xc4, 0x9d, 0xd0, 0xa3, 0x88, 0x8a, 0x2b, 0x96, 0xbc, 0x74, 0xc6,
	0x21, 0xbb, 0xd2, 0xe3, 0x84, 0x09, 0x86, 0x37, 0xf2, 0x58, 0xed, 0x60, 0xc2, 0xd8, 0x24, 0xa4,
	0x47, 0x12, 0x7e, 0x7e, 0x39, 0x3e, 0x12, 0xc1, 0x05, 0xe5, 0xc2, 0xbd, 0x88, 0x33, 0x66, 0x6d,
	0x77, 0xc2, 0x26, 0x4c, 0x1e, 0x8f, 0xd2, 0x53, 0x86, 0x36, 0x7f, 0x44, 0x50, 0x36, 0xb3, 0xb4,
	0x9f, 0x87, 0xec, 0x0a, 0xb7, 0xa1, 0x18, 0x27, 0x2c, 0xe6, 0x55, 0xd4, 0x40, 0x87, 0xe5, 0x56,
	0x5d, 0xcf, 0xf3, 0xeb, 0x0b, 0x24, 0x2b, 0x61, 0x31, 0x4d, 0x44, 0x40, 0x39, 0xc9, 0xc8, 0xf8,
	0x4b, 0xd8, 0x09, 0x5d, 0x2e, 0x1c, 0x4e, 0x69, 0xe4, 0xcc, 0x0a, 0x57, 0x15, 0x99, 0xa3, 0xa6,
	0x67, 0xad, 0xe9, 0xd3, 0xd6, 0x74, 0x7b, 0xca, 0x20, 0x8f, 0x53, 0xd9, 0x88, 0xd2, 0x68, 0x06,
	0x35, 0x7f, 0x43, 0xf0, 0xe4, 0xde, 0x62, 0xf8, 0x53, 0x00, 0x9e, 0x78, 0x0e, 0x8d, 0x44, 0x20,
	0xae, 0xf3, 0x06, 0x6b, 0xb7, 0x1b, 0x34, 0x64, 0xb4, 0x1f, 0x8d, 0x19, 0x29, 0xf1, 0xc4, 0xcb,
	0x1e, 0x53, 0xa9, 0xcf, 0xc5, 0x54, 0xaa, 0xfc, 0xb7, 0xd4, 0xe7, 0x22, 0x97, 0xee, 0xc1, 0x66,
	0x2a, 0x8d, 0x59, 0x22, 0xaa, 0x6b, 0x0d, 0x74, 0xf8, 0x88, 0x6c, 0xf8, 0x5c, 0x58, 0x2c, 0x11,
	0xf8, 0x18, 0x20, 0x6c, 0xcb, 0x5b, 0x79, 0x2c, 0xac, 0xaa, 0x0d, 0x74, 0x58, 0x69, 0xed, 0xcc,
	0xb2, 0x0e, 0xda, 0x56, 0x1e, 0x22, 0x0b, 0xb4, 0xe6, 0x4f, 0x08, 0xb6, 0x67, 0x05, 0xfd, 0x98,
	0x05, 0x91, 0xc0, 0x9f, 0x2c, 0xbb, 0xde, 0xbc, 0xdb, 0x59, 0x46, 0xbc, 0xeb, 0xbc, 0x09, 0x4f,
	0xa4, 0xf3, 0xae, 0x27, 0x82, 0xef, 0xe8, 0xff, 0xf2, 0x5e, 0x8e, 0xec, 0x44, 0xea, 0xe6, 0xee,
	0xbf, 0x46, 0xb0, 0xf7, 0x60, 0x51, 0xdc, 0x82, 0xf5, 0x95, 0xdd, 0xcf, 0x99, 0x18, 0x83, 0x2a,
	0xbd, 0x53, 0xa4, 0x77, 0xf2, 0x7c, 0xcb, 0xb8, 0xb5, 0x95, 0x8d, 0x7b, 0xb4, 0x54, 0x06, 0xeb,
	0xa0, 0x06, 0xd1, 0x98, 0xad, 0xd0, 0x8c, 0xe4, 0xe1, 0x16, 0x14, 0xb9, 0xc7, 0x62, 0x9a, 0x9b,
	0xb3, 0x7f, 0xbf, 0x40, 0x1f, 0xa5, 0x1c, 0x92, 0x51, 0x6b, 0xef, 0x42, 0x51, 0x3e, 0xe3, 0xb7,
	0x01, 0xbc, 0xf0, 0x92, 0x0b, 0x9a, 0x38, 0x81, 0x2f, 0x4b, 0x96, 0x48, 0x29, 0x47, 0xfa, 0x7e,
	0xf3, 0xef, 0x22, 0x3c, 0xbe, 0x53, 0x17, 0x1f, 0x83, 0x2a, 0xae, 0x63, 0x2a, 0xe9, 0x95, 0xd6,
	0xc1, 0xc3, 0x1d, 0xea, 0xf6, 0x75, 0x4c, 0x89, 0x24, 0xe3, 0x0a, 0x28, 0x81, 0x2f, 0x7b, 0x2c,
	0x11, 0x25, 0xf0, 0xf1, 0x17, 0x00, 0x3e, 0x8d, 0x43, 0x76, 0x7d, 0x41, 0xa3, 0x6c, 0x07, 0xcb,
	0xad, 0x77, 0xde, 0x90, 0xaa, 0x37, 0x23, 0x9f, 0x16, 0xc8, 0x82, 0x14, 0xdb, 0xb0, 0x4d, 0x5f,
	0x09, 0x9a, 0x44, 0x6e, 0xe8, 0x70, 0x76, 0x99, 0x78, 0x54, 0x2e, 0x6d, 0xb9, 0xf5, 0xfe, 0x1b,
	0xb2, 0x19, 0xb9, 0x62, 0x24, 0x05, 0xa7, 0x05, 0x52, 0xa1, 0x4b, 0x48, 0xed, 0x7b, 0x05, 0x60,
	0x5e, 0x32, 0x9d, 0x77, 0xe4, 0x5e, 0xd0, 0xdc, 0x21, 0x79, 0xc6, 0xfb, 0x50, 0x4a, 0xbf, 0x79,
	0xec, 0x7a, 0x34, 0xbf, 0xd8, 0x1c, 0xc0, 0xfb, 0xb0, 0x91, 0xfb, 0x28, 0x2f, 0x57, 0xea, 0x28,
	0x55, 0x44, 0xa6, 0x10, 0x1e, 0xc1, 0x56, 0x18, 0x70, 0x41, 0x23, 0xf9, 0x0a, 0xf2, 0xaa, 0xda,
	0x58, 0x3b, 0x2c, 0xb7, 0x3e, 0x5e, 0xe9, 0xfe, 0xfa, 0x40, 0x2a, 0xd3, 0x97, 0x95, 0x94, 0xc3,
	0xd9, 0x99, 0xd7, 0xce, 0x00, 0xe6, 0xa1, 0xd9, 0x8a, 0xa2, 0x07, 0x57, 0x54, 0x59, 0x69, 0x45,
	0x6b, 0x3f, 0x20, 0xa8, 0x2c, 0xfb, 0x75, 0xaf, 0x1d, 0xbb, 0xa0, 0x7a, 0x81, 0x9f, 0x64, 0x4e,
	0x9c, 0x16, 0x88, 0x7c, 0xc2, 0x06, 0x6c, 0xf8, 0x74, 0xec, 0x5e, 0x86, 0xd9, 0x8c, 0x37, 0x3b,
	0x1f, 0xfe, 0xf5, 0xfb, 0xc1, 0x7b, 0x9c, 0xba, 0x89, 0xf7, 0xe2, 0xb3, 0x66, 0x2f, 0x0b, 0x35,
	0xa6, 0xe9, 0x1b, 0x59, 0xfe, 0x8f, 0x5e, 0x04, 0xbe, 0x4f, 0xa3, 0x26, 0x99, 0x6a, 0x3b, 0x9b,
	0xb0, 0x9e, 0xcd, 0xb6, 0xf9, 0x2d, 0xa8, 0xe9, 0x56, 0x61, 0x0d, 0xb6, 0xce, 0xcc, 0xaf, 0xcc,
	0xe1, 0x33, 0xd3, 0xb1, 0xcf, 0x2d, 0x43, 0x2b, 0xe0, 0x0a, 0x40, 0xcf, 0xb0, 0x06, 0xc3, 0xf3,
	0xa7, 0x86, 0x69, 0x6b, 0x08, 0x6f, 0xc1, 0x66, 0xdf, 0xb4, 0x0d, 0x62, 0x1a, 0xb6, 0xa6, 0xe0,
	0x1d, 0xd8, 0x1e, 0xf4, 0x47, 0xb6, 0x61, 0x3a, 0x86, 0xd9, 0xb3, 0x86, 0x7d, 0xd3, 0xd6, 0xd6,
	0x52, 0xd0, 0xf8, 0x3a, 0xa5, 0x9c, 0x0c, 0x9c, 0xd1, 0xf0, 0x8c, 0x74, 0x0d, 0x4d, 0xed, 0xac,
	0x83, 0xea, 0x53, 0xee, 0x7d, 0xf0, 0x33, 0x02, 0x98, 0x5b, 0x82, 0xdf, 0x82, 0x9d, 0x41, 0xdb,
	0xb1, 0xc8, 0xd0, 0x1e, 0x76, 0x87, 0x03, 0x27, 0x2f, 0xae, 0x15, 0x64, 0xe6, 0x85, 0x80, 0xdd,
	0xb5, 0x34, 0x74, 0x1b, 0x3c, 0xeb, 0x59, 0x9a, 0x82, 0x77, 0x41, 0x5b, 0x04, 0xfb, 0xdd, 0xa7,
	0x56, 0xd6, 0xc4, 0x22, 0x4a, 0x4e, 0x9e, 0x69, 0xea, 0x6d, 0xea, 0xa8, 0x6b, 0x5b, 0x5a, 0x11,
	0xef, 0x2f, 0x53, 0x4f, 0xcc, 0x73, 0xed, 0x9f, 0xe9, 0x07, 0x75, 0xda, 0xbf, 0xdc, 0xd4, 0xd1,
	0xaf, 0x37, 0x75, 0xf4, 0xc7, 0x4d, 0x1d, 0xbd, 0xfe, 0xb3, 0x5e, 0x80, 0xbd, 0x80, 0xe9, 0x5c,
	0xb8, 0xde, 0xcb, 0x84, 0xbd, 0xca, 0x7e, 0x2d, 0xa7, 0xc3, 0xfe, 0x66, 0xfa, 0x1f, 0xfb, 0x7c,
	0x5d, 0xe2, 0xc7, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x2e, 0xb9, 0x75, 0x24, 0x91, 0x07, 0x00,
	0x00,
}

func (m *NetworkFlow) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkFlow) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkFlow) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.LastSeenTimestamp != nil {
		{
			size, err := m.LastSeenTimestamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkFlow(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Props != nil {
		{
			size, err := m.Props.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkFlow(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkFlowProperties) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkFlowProperties) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkFlowProperties) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.L4Protocol != 0 {
		i = encodeVarintNetworkFlow(dAtA, i, uint64(m.L4Protocol))
		i--
		dAtA[i] = 0x20
	}
	if m.DstPort != 0 {
		i = encodeVarintNetworkFlow(dAtA, i, uint64(m.DstPort))
		i--
		dAtA[i] = 0x18
	}
	if m.DstEntity != nil {
		{
			size, err := m.DstEntity.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkFlow(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.SrcEntity != nil {
		{
			size, err := m.SrcEntity.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkFlow(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkEndpoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkEndpoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkEndpoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.LastActiveTimestamp != nil {
		{
			size, err := m.LastActiveTimestamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkFlow(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Props != nil {
		{
			size, err := m.Props.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkFlow(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkEndpointProperties) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkEndpointProperties) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkEndpointProperties) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.L4Protocol != 0 {
		i = encodeVarintNetworkFlow(dAtA, i, uint64(m.L4Protocol))
		i--
		dAtA[i] = 0x18
	}
	if m.Port != 0 {
		i = encodeVarintNetworkFlow(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x10
	}
	if m.Entity != nil {
		{
			size, err := m.Entity.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkFlow(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkEntity) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkEntity) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkEntity) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Scope != nil {
		{
			size, err := m.Scope.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkFlow(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Info != nil {
		{
			size, err := m.Info.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkFlow(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkEntity_Scope) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkEntity_Scope) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkEntity_Scope) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintNetworkFlow(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkEntityInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkEntityInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkEntityInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Desc != nil {
		{
			size := m.Desc.Size()
			i -= size
			if _, err := m.Desc.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintNetworkFlow(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0x12
	}
	if m.Type != 0 {
		i = encodeVarintNetworkFlow(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *NetworkEntityInfo_Deployment_) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkEntityInfo_Deployment_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Deployment != nil {
		{
			size, err := m.Deployment.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkFlow(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *NetworkEntityInfo_ExternalSource_) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkEntityInfo_ExternalSource_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ExternalSource != nil {
		{
			size, err := m.ExternalSource.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkFlow(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *NetworkEntityInfo_Deployment) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkEntityInfo_Deployment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkEntityInfo_Deployment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ListenPorts) > 0 {
		for iNdEx := len(m.ListenPorts) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ListenPorts[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkFlow(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Cluster) > 0 {
		i -= len(m.Cluster)
		copy(dAtA[i:], m.Cluster)
		i = encodeVarintNetworkFlow(dAtA, i, uint64(len(m.Cluster)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintNetworkFlow(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintNetworkFlow(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkEntityInfo_Deployment_ListenPort) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkEntityInfo_Deployment_ListenPort) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkEntityInfo_Deployment_ListenPort) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.L4Protocol != 0 {
		i = encodeVarintNetworkFlow(dAtA, i, uint64(m.L4Protocol))
		i--
		dAtA[i] = 0x10
	}
	if m.Port != 0 {
		i = encodeVarintNetworkFlow(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *NetworkEntityInfo_ExternalSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkEntityInfo_ExternalSource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkEntityInfo_ExternalSource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Default {
		i--
		if m.Default {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.Source != nil {
		{
			size := m.Source.Size()
			i -= size
			if _, err := m.Source.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintNetworkFlow(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkEntityInfo_ExternalSource_Cidr) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkEntityInfo_ExternalSource_Cidr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Cidr)
	copy(dAtA[i:], m.Cidr)
	i = encodeVarintNetworkFlow(dAtA, i, uint64(len(m.Cidr)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func encodeVarintNetworkFlow(dAtA []byte, offset int, v uint64) int {
	offset -= sovNetworkFlow(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *NetworkFlow) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Props != nil {
		l = m.Props.Size()
		n += 1 + l + sovNetworkFlow(uint64(l))
	}
	if m.LastSeenTimestamp != nil {
		l = m.LastSeenTimestamp.Size()
		n += 1 + l + sovNetworkFlow(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkFlowProperties) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SrcEntity != nil {
		l = m.SrcEntity.Size()
		n += 1 + l + sovNetworkFlow(uint64(l))
	}
	if m.DstEntity != nil {
		l = m.DstEntity.Size()
		n += 1 + l + sovNetworkFlow(uint64(l))
	}
	if m.DstPort != 0 {
		n += 1 + sovNetworkFlow(uint64(m.DstPort))
	}
	if m.L4Protocol != 0 {
		n += 1 + sovNetworkFlow(uint64(m.L4Protocol))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkEndpoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Props != nil {
		l = m.Props.Size()
		n += 1 + l + sovNetworkFlow(uint64(l))
	}
	if m.LastActiveTimestamp != nil {
		l = m.LastActiveTimestamp.Size()
		n += 1 + l + sovNetworkFlow(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkEndpointProperties) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Entity != nil {
		l = m.Entity.Size()
		n += 1 + l + sovNetworkFlow(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovNetworkFlow(uint64(m.Port))
	}
	if m.L4Protocol != 0 {
		n += 1 + sovNetworkFlow(uint64(m.L4Protocol))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkEntity) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Info != nil {
		l = m.Info.Size()
		n += 1 + l + sovNetworkFlow(uint64(l))
	}
	if m.Scope != nil {
		l = m.Scope.Size()
		n += 1 + l + sovNetworkFlow(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkEntity_Scope) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovNetworkFlow(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkEntityInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovNetworkFlow(uint64(m.Type))
	}
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovNetworkFlow(uint64(l))
	}
	if m.Desc != nil {
		n += m.Desc.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkEntityInfo_Deployment_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Deployment != nil {
		l = m.Deployment.Size()
		n += 1 + l + sovNetworkFlow(uint64(l))
	}
	return n
}
func (m *NetworkEntityInfo_ExternalSource_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExternalSource != nil {
		l = m.ExternalSource.Size()
		n += 1 + l + sovNetworkFlow(uint64(l))
	}
	return n
}
func (m *NetworkEntityInfo_Deployment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovNetworkFlow(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovNetworkFlow(uint64(l))
	}
	l = len(m.Cluster)
	if l > 0 {
		n += 1 + l + sovNetworkFlow(uint64(l))
	}
	if len(m.ListenPorts) > 0 {
		for _, e := range m.ListenPorts {
			l = e.Size()
			n += 1 + l + sovNetworkFlow(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkEntityInfo_Deployment_ListenPort) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Port != 0 {
		n += 1 + sovNetworkFlow(uint64(m.Port))
	}
	if m.L4Protocol != 0 {
		n += 1 + sovNetworkFlow(uint64(m.L4Protocol))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkEntityInfo_ExternalSource) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovNetworkFlow(uint64(l))
	}
	if m.Source != nil {
		n += m.Source.Size()
	}
	if m.Default {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkEntityInfo_ExternalSource_Cidr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Cidr)
	n += 1 + l + sovNetworkFlow(uint64(l))
	return n
}

func sovNetworkFlow(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozNetworkFlow(x uint64) (n int) {
	return sovNetworkFlow(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *NetworkFlow) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkFlow
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkFlow: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkFlow: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Props", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Props == nil {
				m.Props = &NetworkFlowProperties{}
			}
			if err := m.Props.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastSeenTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastSeenTimestamp == nil {
				m.LastSeenTimestamp = &types.Timestamp{}
			}
			if err := m.LastSeenTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkFlow(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkFlowProperties) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkFlow
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkFlowProperties: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkFlowProperties: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SrcEntity", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SrcEntity == nil {
				m.SrcEntity = &NetworkEntityInfo{}
			}
			if err := m.SrcEntity.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DstEntity", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DstEntity == nil {
				m.DstEntity = &NetworkEntityInfo{}
			}
			if err := m.DstEntity.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DstPort", wireType)
			}
			m.DstPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DstPort |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L4Protocol", wireType)
			}
			m.L4Protocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.L4Protocol |= L4Protocol(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkFlow(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkEndpoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkFlow
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkEndpoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkEndpoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Props", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Props == nil {
				m.Props = &NetworkEndpointProperties{}
			}
			if err := m.Props.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastActiveTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastActiveTimestamp == nil {
				m.LastActiveTimestamp = &types.Timestamp{}
			}
			if err := m.LastActiveTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkFlow(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkEndpointProperties) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkFlow
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkEndpointProperties: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkEndpointProperties: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entity", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Entity == nil {
				m.Entity = &NetworkEntityInfo{}
			}
			if err := m.Entity.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L4Protocol", wireType)
			}
			m.L4Protocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.L4Protocol |= L4Protocol(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkFlow(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkEntity) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkFlow
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkEntity: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkEntity: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Info == nil {
				m.Info = &NetworkEntityInfo{}
			}
			if err := m.Info.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scope", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Scope == nil {
				m.Scope = &NetworkEntity_Scope{}
			}
			if err := m.Scope.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkFlow(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkEntity_Scope) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkFlow
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Scope: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Scope: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkFlow(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkEntityInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkFlow
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkEntityInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkEntityInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= NetworkEntityInfo_Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &NetworkEntityInfo_Deployment{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Desc = &NetworkEntityInfo_Deployment_{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExternalSource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &NetworkEntityInfo_ExternalSource{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Desc = &NetworkEntityInfo_ExternalSource_{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkFlow(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkEntityInfo_Deployment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkFlow
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Deployment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Deployment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListenPorts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ListenPorts = append(m.ListenPorts, &NetworkEntityInfo_Deployment_ListenPort{})
			if err := m.ListenPorts[len(m.ListenPorts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkFlow(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkEntityInfo_Deployment_ListenPort) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkFlow
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListenPort: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListenPort: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L4Protocol", wireType)
			}
			m.L4Protocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.L4Protocol |= L4Protocol(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkFlow(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkEntityInfo_ExternalSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkFlow
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExternalSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExternalSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cidr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = &NetworkEntityInfo_ExternalSource_Cidr{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Default", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Default = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkFlow(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkFlow
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipNetworkFlow(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowNetworkFlow
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNetworkFlow
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthNetworkFlow
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupNetworkFlow
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthNetworkFlow
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthNetworkFlow        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowNetworkFlow          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupNetworkFlow = fmt.Errorf("proto: unexpected end of group")
)
