// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/node.proto

package storage

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Node represents information about a node in the cluster.
// next available tag: 27
type Node struct {
	// A unique ID identifying this node.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" search:"Node ID,store"`
	// The (host)name of the node. Might or might not be the same as ID.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty" search:"Node,store"`
	// Taints on the host
	Taints      []*Taint `protobuf:"bytes,3,rep,name=taints,proto3" json:"taints,omitempty"`
	ClusterId   string   `protobuf:"bytes,4,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty" search:"Cluster ID,store"`
	ClusterName string   `protobuf:"bytes,5,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty" search:"Cluster,store"`
	// TODO(ROX-6895): "Label" search term is ambiguous.
	Labels      map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" search:"Label" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Annotations map[string]string `protobuf:"bytes,7,rep,name=annotations,proto3" json:"annotations,omitempty" search:"Annotation" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// When the cluster reported the node was added
	JoinedAt *types.Timestamp `protobuf:"bytes,13,opt,name=joined_at,json=joinedAt,proto3" json:"joined_at,omitempty" search:"Node Join Time,store"`
	// node internal IP addresses
	InternalIpAddresses []string `protobuf:"bytes,8,rep,name=internal_ip_addresses,json=internalIpAddresses,proto3" json:"internal_ip_addresses,omitempty"`
	// node external IP addresses
	ExternalIpAddresses []string `protobuf:"bytes,9,rep,name=external_ip_addresses,json=externalIpAddresses,proto3" json:"external_ip_addresses,omitempty"`
	// From NodeInfo
	ContainerRuntimeVersion string                `protobuf:"bytes,10,opt,name=container_runtime_version,json=containerRuntimeVersion,proto3" json:"container_runtime_version,omitempty"` // Deprecated: Do not use.
	ContainerRuntime        *ContainerRuntimeInfo `protobuf:"bytes,14,opt,name=container_runtime,json=containerRuntime,proto3" json:"container_runtime,omitempty"`
	KernelVersion           string                `protobuf:"bytes,11,opt,name=kernel_version,json=kernelVersion,proto3" json:"kernel_version,omitempty"`
	// From NodeInfo. Operating system reported by the node (ex: linux).
	OperatingSystem string `protobuf:"bytes,17,opt,name=operating_system,json=operatingSystem,proto3" json:"operating_system,omitempty"`
	// From NodeInfo. OS image reported by the node from /etc/os-release.
	OsImage          string           `protobuf:"bytes,12,opt,name=os_image,json=osImage,proto3" json:"os_image,omitempty" search:"Operating System,store"`
	KubeletVersion   string           `protobuf:"bytes,15,opt,name=kubelet_version,json=kubeletVersion,proto3" json:"kubelet_version,omitempty"`
	KubeProxyVersion string           `protobuf:"bytes,16,opt,name=kube_proxy_version,json=kubeProxyVersion,proto3" json:"kube_proxy_version,omitempty"`
	LastUpdated      *types.Timestamp `protobuf:"bytes,25,opt,name=last_updated,json=lastUpdated,proto3" json:"last_updated,omitempty" search:"Last Updated,hidden"`
	// Time we received an update from Kubernetes.
	K8SUpdated *types.Timestamp `protobuf:"bytes,26,opt,name=k8s_updated,json=k8sUpdated,proto3" json:"k8s_updated,omitempty" sensorhash:"ignore"`
	Scan       *NodeScan        `protobuf:"bytes,18,opt,name=scan,proto3" json:"scan,omitempty" policy:"Node Scan"`
	// Types that are valid to be assigned to SetComponents:
	//	*Node_Components
	SetComponents isNode_SetComponents `protobuf_oneof:"set_components"`
	// Types that are valid to be assigned to SetCves:
	//	*Node_Cves
	SetCves isNode_SetCves `protobuf_oneof:"set_cves"`
	// Types that are valid to be assigned to SetFixable:
	//	*Node_FixableCves
	SetFixable isNode_SetFixable `protobuf_oneof:"set_fixable"`
	Priority   int64             `protobuf:"varint,22,opt,name=priority,proto3" json:"priority,omitempty"`
	RiskScore  float32           `protobuf:"fixed32,23,opt,name=risk_score,json=riskScore,proto3" json:"risk_score,omitempty" search:"Risk Score,hidden"`
	// Types that are valid to be assigned to SetTopCvss:
	//	*Node_TopCvss
	SetTopCvss           isNode_SetTopCvss `protobuf_oneof:"set_top_cvss"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Node) Reset()         { *m = Node{} }
func (m *Node) String() string { return proto.CompactTextString(m) }
func (*Node) ProtoMessage()    {}
func (*Node) Descriptor() ([]byte, []int) {
	return fileDescriptor_107f6eed651900c7, []int{0}
}
func (m *Node) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Node) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Node.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Node) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Node.Merge(m, src)
}
func (m *Node) XXX_Size() int {
	return m.Size()
}
func (m *Node) XXX_DiscardUnknown() {
	xxx_messageInfo_Node.DiscardUnknown(m)
}

var xxx_messageInfo_Node proto.InternalMessageInfo

type isNode_SetComponents interface {
	isNode_SetComponents()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isNode_SetComponents
}
type isNode_SetCves interface {
	isNode_SetCves()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isNode_SetCves
}
type isNode_SetFixable interface {
	isNode_SetFixable()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isNode_SetFixable
}
type isNode_SetTopCvss interface {
	isNode_SetTopCvss()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isNode_SetTopCvss
}

type Node_Components struct {
	Components int32 `protobuf:"varint,19,opt,name=components,proto3,oneof" json:"components,omitempty" search:"Component Count,store,hidden"`
}
type Node_Cves struct {
	Cves int32 `protobuf:"varint,20,opt,name=cves,proto3,oneof" json:"cves,omitempty" search:"CVE Count,store,hidden"`
}
type Node_FixableCves struct {
	FixableCves int32 `protobuf:"varint,21,opt,name=fixable_cves,json=fixableCves,proto3,oneof" json:"fixable_cves,omitempty" search:"Fixable CVE Count,store,hidden"`
}
type Node_TopCvss struct {
	TopCvss float32 `protobuf:"fixed32,24,opt,name=top_cvss,json=topCvss,proto3,oneof" json:"top_cvss,omitempty" search:"Node Top CVSS,store"`
}

func (*Node_Components) isNode_SetComponents() {}
func (m *Node_Components) Clone() isNode_SetComponents {
	if m == nil {
		return nil
	}
	cloned := new(Node_Components)
	*cloned = *m

	return cloned
}
func (*Node_Cves) isNode_SetCves() {}
func (m *Node_Cves) Clone() isNode_SetCves {
	if m == nil {
		return nil
	}
	cloned := new(Node_Cves)
	*cloned = *m

	return cloned
}
func (*Node_FixableCves) isNode_SetFixable() {}
func (m *Node_FixableCves) Clone() isNode_SetFixable {
	if m == nil {
		return nil
	}
	cloned := new(Node_FixableCves)
	*cloned = *m

	return cloned
}
func (*Node_TopCvss) isNode_SetTopCvss() {}
func (m *Node_TopCvss) Clone() isNode_SetTopCvss {
	if m == nil {
		return nil
	}
	cloned := new(Node_TopCvss)
	*cloned = *m

	return cloned
}

func (m *Node) GetSetComponents() isNode_SetComponents {
	if m != nil {
		return m.SetComponents
	}
	return nil
}
func (m *Node) GetSetCves() isNode_SetCves {
	if m != nil {
		return m.SetCves
	}
	return nil
}
func (m *Node) GetSetFixable() isNode_SetFixable {
	if m != nil {
		return m.SetFixable
	}
	return nil
}
func (m *Node) GetSetTopCvss() isNode_SetTopCvss {
	if m != nil {
		return m.SetTopCvss
	}
	return nil
}

func (m *Node) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Node) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Node) GetTaints() []*Taint {
	if m != nil {
		return m.Taints
	}
	return nil
}

func (m *Node) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *Node) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *Node) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Node) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *Node) GetJoinedAt() *types.Timestamp {
	if m != nil {
		return m.JoinedAt
	}
	return nil
}

func (m *Node) GetInternalIpAddresses() []string {
	if m != nil {
		return m.InternalIpAddresses
	}
	return nil
}

func (m *Node) GetExternalIpAddresses() []string {
	if m != nil {
		return m.ExternalIpAddresses
	}
	return nil
}

// Deprecated: Do not use.
func (m *Node) GetContainerRuntimeVersion() string {
	if m != nil {
		return m.ContainerRuntimeVersion
	}
	return ""
}

func (m *Node) GetContainerRuntime() *ContainerRuntimeInfo {
	if m != nil {
		return m.ContainerRuntime
	}
	return nil
}

func (m *Node) GetKernelVersion() string {
	if m != nil {
		return m.KernelVersion
	}
	return ""
}

func (m *Node) GetOperatingSystem() string {
	if m != nil {
		return m.OperatingSystem
	}
	return ""
}

func (m *Node) GetOsImage() string {
	if m != nil {
		return m.OsImage
	}
	return ""
}

func (m *Node) GetKubeletVersion() string {
	if m != nil {
		return m.KubeletVersion
	}
	return ""
}

func (m *Node) GetKubeProxyVersion() string {
	if m != nil {
		return m.KubeProxyVersion
	}
	return ""
}

func (m *Node) GetLastUpdated() *types.Timestamp {
	if m != nil {
		return m.LastUpdated
	}
	return nil
}

func (m *Node) GetK8SUpdated() *types.Timestamp {
	if m != nil {
		return m.K8SUpdated
	}
	return nil
}

func (m *Node) GetScan() *NodeScan {
	if m != nil {
		return m.Scan
	}
	return nil
}

func (m *Node) GetComponents() int32 {
	if x, ok := m.GetSetComponents().(*Node_Components); ok {
		return x.Components
	}
	return 0
}

func (m *Node) GetCves() int32 {
	if x, ok := m.GetSetCves().(*Node_Cves); ok {
		return x.Cves
	}
	return 0
}

func (m *Node) GetFixableCves() int32 {
	if x, ok := m.GetSetFixable().(*Node_FixableCves); ok {
		return x.FixableCves
	}
	return 0
}

func (m *Node) GetPriority() int64 {
	if m != nil {
		return m.Priority
	}
	return 0
}

func (m *Node) GetRiskScore() float32 {
	if m != nil {
		return m.RiskScore
	}
	return 0
}

func (m *Node) GetTopCvss() float32 {
	if x, ok := m.GetSetTopCvss().(*Node_TopCvss); ok {
		return x.TopCvss
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Node) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Node_Components)(nil),
		(*Node_Cves)(nil),
		(*Node_FixableCves)(nil),
		(*Node_TopCvss)(nil),
	}
}

func (m *Node) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Node) Clone() *Node {
	if m == nil {
		return nil
	}
	cloned := new(Node)
	*cloned = *m

	if m.Taints != nil {
		cloned.Taints = make([]*Taint, len(m.Taints))
		for idx, v := range m.Taints {
			cloned.Taints[idx] = v.Clone()
		}
	}
	if m.Labels != nil {
		cloned.Labels = make(map[string]string, len(m.Labels))
		for k, v := range m.Labels {
			cloned.Labels[k] = v
		}
	}
	if m.Annotations != nil {
		cloned.Annotations = make(map[string]string, len(m.Annotations))
		for k, v := range m.Annotations {
			cloned.Annotations[k] = v
		}
	}
	cloned.JoinedAt = m.JoinedAt.Clone()
	if m.InternalIpAddresses != nil {
		cloned.InternalIpAddresses = make([]string, len(m.InternalIpAddresses))
		copy(cloned.InternalIpAddresses, m.InternalIpAddresses)
	}
	if m.ExternalIpAddresses != nil {
		cloned.ExternalIpAddresses = make([]string, len(m.ExternalIpAddresses))
		copy(cloned.ExternalIpAddresses, m.ExternalIpAddresses)
	}
	cloned.ContainerRuntime = m.ContainerRuntime.Clone()
	cloned.LastUpdated = m.LastUpdated.Clone()
	cloned.K8SUpdated = m.K8SUpdated.Clone()
	cloned.Scan = m.Scan.Clone()
	if m.SetComponents != nil {
		cloned.SetComponents = m.SetComponents.Clone()
	}
	if m.SetCves != nil {
		cloned.SetCves = m.SetCves.Clone()
	}
	if m.SetFixable != nil {
		cloned.SetFixable = m.SetFixable.Clone()
	}
	if m.SetTopCvss != nil {
		cloned.SetTopCvss = m.SetTopCvss.Clone()
	}
	return cloned
}

type NodeScan struct {
	ScanTime             *types.Timestamp             `protobuf:"bytes,1,opt,name=scan_time,json=scanTime,proto3" json:"scan_time,omitempty" search:"Node Scan Time,store"`
	OperatingSystem      string                       `protobuf:"bytes,3,opt,name=operating_system,json=operatingSystem,proto3" json:"operating_system,omitempty"`
	Components           []*EmbeddedNodeScanComponent `protobuf:"bytes,2,rep,name=components,proto3" json:"components,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *NodeScan) Reset()         { *m = NodeScan{} }
func (m *NodeScan) String() string { return proto.CompactTextString(m) }
func (*NodeScan) ProtoMessage()    {}
func (*NodeScan) Descriptor() ([]byte, []int) {
	return fileDescriptor_107f6eed651900c7, []int{1}
}
func (m *NodeScan) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeScan) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeScan.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeScan) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeScan.Merge(m, src)
}
func (m *NodeScan) XXX_Size() int {
	return m.Size()
}
func (m *NodeScan) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeScan.DiscardUnknown(m)
}

var xxx_messageInfo_NodeScan proto.InternalMessageInfo

func (m *NodeScan) GetScanTime() *types.Timestamp {
	if m != nil {
		return m.ScanTime
	}
	return nil
}

func (m *NodeScan) GetOperatingSystem() string {
	if m != nil {
		return m.OperatingSystem
	}
	return ""
}

func (m *NodeScan) GetComponents() []*EmbeddedNodeScanComponent {
	if m != nil {
		return m.Components
	}
	return nil
}

func (m *NodeScan) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NodeScan) Clone() *NodeScan {
	if m == nil {
		return nil
	}
	cloned := new(NodeScan)
	*cloned = *m

	cloned.ScanTime = m.ScanTime.Clone()
	if m.Components != nil {
		cloned.Components = make([]*EmbeddedNodeScanComponent, len(m.Components))
		for idx, v := range m.Components {
			cloned.Components[idx] = v.Clone()
		}
	}
	return cloned
}

type EmbeddedNodeScanComponent struct {
	Name     string                   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty" search:"Component,store"`
	Version  string                   `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty" search:"Component Version,store"`
	Vulns    []*EmbeddedVulnerability `protobuf:"bytes,3,rep,name=vulns,proto3" json:"vulns,omitempty"`
	Priority int64                    `protobuf:"varint,4,opt,name=priority,proto3" json:"priority,omitempty"`
	// Types that are valid to be assigned to SetTopCvss:
	//	*EmbeddedNodeScanComponent_TopCvss
	SetTopCvss           isEmbeddedNodeScanComponent_SetTopCvss `protobuf_oneof:"set_top_cvss"`
	RiskScore            float32                                `protobuf:"fixed32,6,opt,name=risk_score,json=riskScore,proto3" json:"risk_score,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *EmbeddedNodeScanComponent) Reset()         { *m = EmbeddedNodeScanComponent{} }
func (m *EmbeddedNodeScanComponent) String() string { return proto.CompactTextString(m) }
func (*EmbeddedNodeScanComponent) ProtoMessage()    {}
func (*EmbeddedNodeScanComponent) Descriptor() ([]byte, []int) {
	return fileDescriptor_107f6eed651900c7, []int{2}
}
func (m *EmbeddedNodeScanComponent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EmbeddedNodeScanComponent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EmbeddedNodeScanComponent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EmbeddedNodeScanComponent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EmbeddedNodeScanComponent.Merge(m, src)
}
func (m *EmbeddedNodeScanComponent) XXX_Size() int {
	return m.Size()
}
func (m *EmbeddedNodeScanComponent) XXX_DiscardUnknown() {
	xxx_messageInfo_EmbeddedNodeScanComponent.DiscardUnknown(m)
}

var xxx_messageInfo_EmbeddedNodeScanComponent proto.InternalMessageInfo

type isEmbeddedNodeScanComponent_SetTopCvss interface {
	isEmbeddedNodeScanComponent_SetTopCvss()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isEmbeddedNodeScanComponent_SetTopCvss
}

type EmbeddedNodeScanComponent_TopCvss struct {
	TopCvss float32 `protobuf:"fixed32,5,opt,name=top_cvss,json=topCvss,proto3,oneof" json:"top_cvss,omitempty"`
}

func (*EmbeddedNodeScanComponent_TopCvss) isEmbeddedNodeScanComponent_SetTopCvss() {}
func (m *EmbeddedNodeScanComponent_TopCvss) Clone() isEmbeddedNodeScanComponent_SetTopCvss {
	if m == nil {
		return nil
	}
	cloned := new(EmbeddedNodeScanComponent_TopCvss)
	*cloned = *m

	return cloned
}

func (m *EmbeddedNodeScanComponent) GetSetTopCvss() isEmbeddedNodeScanComponent_SetTopCvss {
	if m != nil {
		return m.SetTopCvss
	}
	return nil
}

func (m *EmbeddedNodeScanComponent) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EmbeddedNodeScanComponent) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *EmbeddedNodeScanComponent) GetVulns() []*EmbeddedVulnerability {
	if m != nil {
		return m.Vulns
	}
	return nil
}

func (m *EmbeddedNodeScanComponent) GetPriority() int64 {
	if m != nil {
		return m.Priority
	}
	return 0
}

func (m *EmbeddedNodeScanComponent) GetTopCvss() float32 {
	if x, ok := m.GetSetTopCvss().(*EmbeddedNodeScanComponent_TopCvss); ok {
		return x.TopCvss
	}
	return 0
}

func (m *EmbeddedNodeScanComponent) GetRiskScore() float32 {
	if m != nil {
		return m.RiskScore
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*EmbeddedNodeScanComponent) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*EmbeddedNodeScanComponent_TopCvss)(nil),
	}
}

func (m *EmbeddedNodeScanComponent) MessageClone() proto.Message {
	return m.Clone()
}
func (m *EmbeddedNodeScanComponent) Clone() *EmbeddedNodeScanComponent {
	if m == nil {
		return nil
	}
	cloned := new(EmbeddedNodeScanComponent)
	*cloned = *m

	if m.Vulns != nil {
		cloned.Vulns = make([]*EmbeddedVulnerability, len(m.Vulns))
		for idx, v := range m.Vulns {
			cloned.Vulns[idx] = v.Clone()
		}
	}
	if m.SetTopCvss != nil {
		cloned.SetTopCvss = m.SetTopCvss.Clone()
	}
	return cloned
}

type NodeComponentEdge struct {
	// base 64 encoded Node:Component ids.
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeComponentEdge) Reset()         { *m = NodeComponentEdge{} }
func (m *NodeComponentEdge) String() string { return proto.CompactTextString(m) }
func (*NodeComponentEdge) ProtoMessage()    {}
func (*NodeComponentEdge) Descriptor() ([]byte, []int) {
	return fileDescriptor_107f6eed651900c7, []int{3}
}
func (m *NodeComponentEdge) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeComponentEdge) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeComponentEdge.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeComponentEdge) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeComponentEdge.Merge(m, src)
}
func (m *NodeComponentEdge) XXX_Size() int {
	return m.Size()
}
func (m *NodeComponentEdge) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeComponentEdge.DiscardUnknown(m)
}

var xxx_messageInfo_NodeComponentEdge proto.InternalMessageInfo

func (m *NodeComponentEdge) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *NodeComponentEdge) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NodeComponentEdge) Clone() *NodeComponentEdge {
	if m == nil {
		return nil
	}
	cloned := new(NodeComponentEdge)
	*cloned = *m

	return cloned
}

type NodeCVEEdge struct {
	// base 64 encoded Node:CVE ids.
	Id                   string           `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	FirstNodeOccurrence  *types.Timestamp `protobuf:"bytes,2,opt,name=first_node_occurrence,json=firstNodeOccurrence,proto3" json:"first_node_occurrence,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *NodeCVEEdge) Reset()         { *m = NodeCVEEdge{} }
func (m *NodeCVEEdge) String() string { return proto.CompactTextString(m) }
func (*NodeCVEEdge) ProtoMessage()    {}
func (*NodeCVEEdge) Descriptor() ([]byte, []int) {
	return fileDescriptor_107f6eed651900c7, []int{4}
}
func (m *NodeCVEEdge) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeCVEEdge) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeCVEEdge.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeCVEEdge) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeCVEEdge.Merge(m, src)
}
func (m *NodeCVEEdge) XXX_Size() int {
	return m.Size()
}
func (m *NodeCVEEdge) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeCVEEdge.DiscardUnknown(m)
}

var xxx_messageInfo_NodeCVEEdge proto.InternalMessageInfo

func (m *NodeCVEEdge) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *NodeCVEEdge) GetFirstNodeOccurrence() *types.Timestamp {
	if m != nil {
		return m.FirstNodeOccurrence
	}
	return nil
}

func (m *NodeCVEEdge) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NodeCVEEdge) Clone() *NodeCVEEdge {
	if m == nil {
		return nil
	}
	cloned := new(NodeCVEEdge)
	*cloned = *m

	cloned.FirstNodeOccurrence = m.FirstNodeOccurrence.Clone()
	return cloned
}

func init() {
	proto.RegisterType((*Node)(nil), "storage.Node")
	proto.RegisterMapType((map[string]string)(nil), "storage.Node.AnnotationsEntry")
	proto.RegisterMapType((map[string]string)(nil), "storage.Node.LabelsEntry")
	proto.RegisterType((*NodeScan)(nil), "storage.NodeScan")
	proto.RegisterType((*EmbeddedNodeScanComponent)(nil), "storage.EmbeddedNodeScanComponent")
	proto.RegisterType((*NodeComponentEdge)(nil), "storage.NodeComponentEdge")
	proto.RegisterType((*NodeCVEEdge)(nil), "storage.NodeCVEEdge")
}

func init() { proto.RegisterFile("storage/node.proto", fileDescriptor_107f6eed651900c7) }

var fileDescriptor_107f6eed651900c7 = []byte{
	// 1204 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0xdd, 0x6e, 0xdb, 0x36,
	0x14, 0xae, 0xec, 0xfc, 0x38, 0xc7, 0xa9, 0xeb, 0x30, 0xfd, 0x51, 0xdc, 0xc6, 0xd2, 0xdc, 0x75,
	0x75, 0xd7, 0xc2, 0x19, 0xba, 0x5e, 0xb4, 0xc5, 0x12, 0xa0, 0xf6, 0x32, 0x34, 0xdd, 0xd0, 0x16,
	0x4a, 0x16, 0x60, 0xbd, 0x11, 0x64, 0x89, 0x71, 0x38, 0xcb, 0xa4, 0x20, 0xd2, 0x46, 0x7c, 0xb9,
	0xb7, 0xd8, 0x3b, 0xec, 0x45, 0x76, 0xb9, 0x9b, 0xdd, 0x0a, 0x43, 0xf6, 0x06, 0x7a, 0x82, 0x81,
	0x94, 0xa8, 0xd8, 0x71, 0xba, 0x62, 0xbb, 0x93, 0xce, 0xf9, 0xbe, 0x4f, 0x87, 0x87, 0x9f, 0x0e,
	0x09, 0x88, 0x0b, 0x16, 0x7b, 0x03, 0xbc, 0x43, 0x59, 0x80, 0x3b, 0x51, 0xcc, 0x04, 0x43, 0xab,
	0x79, 0xac, 0x61, 0x0d, 0x18, 0x1b, 0x84, 0x78, 0x47, 0x85, 0xfb, 0xe3, 0x93, 0x1d, 0x41, 0x46,
	0x98, 0x0b, 0x6f, 0x14, 0x65, 0xc8, 0x86, 0xa5, 0xd9, 0x3e, 0xa3, 0xc2, 0x23, 0x14, 0xc7, 0x6e,
	0x3c, 0xa6, 0x12, 0x95, 0x03, 0x6e, 0x6a, 0x80, 0xcc, 0x0a, 0x9e, 0x47, 0xef, 0xea, 0xe8, 0x64,
	0x1c, 0x52, 0x1c, 0x7b, 0x7d, 0x12, 0x12, 0x31, 0xd5, 0x94, 0x01, 0x1b, 0x30, 0xf5, 0xb8, 0x23,
	0x9f, 0xb2, 0x68, 0xeb, 0x97, 0x1a, 0x2c, 0xbd, 0x65, 0x01, 0x46, 0x5f, 0x42, 0x89, 0x04, 0xa6,
	0x61, 0x1b, 0xed, 0xb5, 0x6e, 0x23, 0x4d, 0xac, 0xdb, 0x1c, 0x7b, 0xb1, 0x7f, 0xfa, 0xb2, 0x25,
	0xb3, 0xf6, 0xc1, 0xb7, 0x4f, 0xa4, 0x36, 0x6e, 0x39, 0x25, 0x12, 0xa0, 0xc7, 0xb0, 0x44, 0xbd,
	0x11, 0x36, 0x4b, 0x0a, 0x7d, 0x27, 0x4d, 0xac, 0xcd, 0x59, 0xb4, 0x86, 0x2a, 0x10, 0xfa, 0x02,
	0x56, 0xb2, 0x22, 0xcd, 0xb2, 0x5d, 0x6e, 0x57, 0x9f, 0xd6, 0x3a, 0x79, 0x95, 0x9d, 0x23, 0x19,
	0x76, 0xf2, 0x2c, 0xfa, 0x06, 0xc0, 0x0f, 0xc7, 0x5c, 0xe0, 0xd8, 0x25, 0x81, 0xb9, 0xa4, 0xa4,
	0xb7, 0xd3, 0xc4, 0xda, 0xd2, 0xd2, 0xbd, 0x2c, 0x3b, 0x53, 0xcb, 0x5a, 0x4e, 0x38, 0x08, 0xd0,
	0x2e, 0xac, 0x6b, 0xb6, 0x2a, 0x6d, 0x79, 0x71, 0x21, 0x39, 0x5f, 0x93, 0xab, 0x39, 0xfe, 0xad,
	0x2c, 0x72, 0x1f, 0x56, 0x42, 0xaf, 0x8f, 0x43, 0x6e, 0xae, 0xa8, 0x22, 0xb7, 0x8a, 0x22, 0xe5,
	0x82, 0x3a, 0x3f, 0xa8, 0xdc, 0x3e, 0x15, 0xf1, 0xb4, 0x8b, 0xd2, 0xc4, 0xaa, 0x69, 0x4d, 0x95,
	0x68, 0x39, 0x39, 0x19, 0xfd, 0x04, 0x55, 0x8f, 0x52, 0x26, 0x3c, 0x41, 0x18, 0xe5, 0xe6, 0xaa,
	0xd2, 0x6a, 0xce, 0x6b, 0xbd, 0xba, 0x00, 0x64, 0x82, 0x73, 0xfd, 0xbb, 0xc8, 0xb6, 0x9c, 0x59,
	0x2d, 0xf4, 0x01, 0xd6, 0x7e, 0x66, 0x84, 0xe2, 0xc0, 0xf5, 0x84, 0x79, 0xdd, 0x36, 0xda, 0xd5,
	0xa7, 0x8d, 0x4e, 0xe6, 0xa3, 0x8e, 0xf6, 0x51, 0xe7, 0x48, 0xfb, 0xa8, 0xfb, 0x59, 0x9a, 0x58,
	0xdb, 0x73, 0x5b, 0xf8, 0x86, 0x11, 0x6a, 0x4b, 0x80, 0x6e, 0x40, 0x25, 0xd3, 0x7b, 0x25, 0xd0,
	0x53, 0xb8, 0x45, 0xa8, 0xc0, 0x31, 0xf5, 0x42, 0x97, 0x44, 0xae, 0x17, 0x04, 0x31, 0xe6, 0x1c,
	0x73, 0xb3, 0x62, 0x97, 0xdb, 0x6b, 0xce, 0xa6, 0x4e, 0x1e, 0x44, 0xaf, 0x74, 0x4a, 0x72, 0xf0,
	0xd9, 0x55, 0x9c, 0xb5, 0x8c, 0xa3, 0x93, 0xb3, 0x9c, 0x3d, 0xd8, 0x5a, 0x30, 0xb4, 0x3b, 0xc1,
	0x31, 0x27, 0x8c, 0x9a, 0xa0, 0x76, 0xac, 0x64, 0x1a, 0xce, 0x9d, 0x02, 0xe4, 0x64, 0x98, 0xe3,
	0x0c, 0x82, 0xde, 0xc0, 0xc6, 0x02, 0xdf, 0xac, 0xa9, 0x5e, 0x6c, 0x17, 0x4d, 0xee, 0x5d, 0x22,
	0x1f, 0xd0, 0x13, 0xe6, 0xd4, 0x2f, 0x4b, 0xa2, 0x07, 0x50, 0x1b, 0xe2, 0x98, 0xe2, 0xb0, 0x28,
	0xa0, 0x2a, 0x0b, 0x70, 0xae, 0x67, 0x51, 0xfd, 0xc9, 0x47, 0x50, 0x67, 0x11, 0x8e, 0x3d, 0x41,
	0xe8, 0xc0, 0xe5, 0x53, 0x2e, 0xf0, 0xc8, 0xdc, 0x50, 0xc0, 0x1b, 0x45, 0xfc, 0x50, 0x85, 0xd1,
	0x1e, 0x54, 0x18, 0x77, 0xc9, 0xc8, 0x1b, 0x60, 0x73, 0x5d, 0x2d, 0xe6, 0x7e, 0x9a, 0x58, 0x96,
	0xde, 0x84, 0x77, 0x1a, 0x6e, 0x67, 0x78, 0xbd, 0x0d, 0xab, 0x8c, 0x1f, 0x48, 0x0e, 0x7a, 0x08,
	0x37, 0x86, 0xe3, 0x3e, 0x0e, 0xb1, 0x28, 0x4a, 0xba, 0xa1, 0xbe, 0x54, 0xcb, 0xc3, 0xba, 0xa6,
	0x27, 0x80, 0x64, 0xc4, 0x8d, 0x62, 0x76, 0x36, 0x2d, 0xb0, 0x75, 0x85, 0xad, 0xcb, 0xcc, 0x7b,
	0x99, 0xd0, 0x68, 0x17, 0xd6, 0x43, 0x8f, 0x0b, 0x77, 0x1c, 0x05, 0x9e, 0xc0, 0x81, 0xb9, 0xf5,
	0x49, 0xef, 0xd8, 0x69, 0x62, 0xdd, 0xbb, 0x70, 0x38, 0x17, 0xf6, 0x8f, 0x19, 0xf7, 0xc9, 0x29,
	0x09, 0x02, 0x2c, 0x9d, 0x29, 0x15, 0xf3, 0x20, 0x3a, 0x82, 0xea, 0xf0, 0x39, 0x2f, 0xf4, 0x1b,
	0x9f, 0xd4, 0xcf, 0x0d, 0x4f, 0x39, 0x8b, 0x4f, 0x3d, 0x7e, 0xfa, 0xb2, 0x45, 0x06, 0x54, 0xb5,
	0x02, 0x86, 0xcf, 0xb9, 0x56, 0xdd, 0x85, 0x25, 0xee, 0x7b, 0xd4, 0x44, 0x4a, 0x6e, 0x63, 0xee,
	0x1f, 0x3a, 0xf4, 0x3d, 0xda, 0xbd, 0x9d, 0x26, 0x16, 0x8a, 0x58, 0x48, 0xfc, 0x69, 0xee, 0x70,
	0x19, 0x6e, 0x39, 0x8a, 0x86, 0xbe, 0x07, 0xf0, 0xd9, 0x28, 0x62, 0x14, 0xcb, 0xc9, 0xb3, 0x69,
	0x1b, 0xed, 0xe5, 0xee, 0xa3, 0x34, 0xb1, 0x1e, 0x14, 0xd3, 0x40, 0x67, 0xed, 0x1e, 0x1b, 0x53,
	0x91, 0xed, 0x86, 0x5e, 0xe0, 0xeb, 0x6b, 0xce, 0x0c, 0x1d, 0xbd, 0x80, 0x25, 0x7f, 0x82, 0xb9,
	0x79, 0x53, 0xc9, 0xcc, 0xed, 0x6a, 0xef, 0x78, 0xff, 0x4a, 0x01, 0xc3, 0x51, 0x14, 0xf4, 0x1e,
	0xd6, 0x4f, 0xc8, 0x99, 0xd7, 0x0f, 0xb1, 0xab, 0x24, 0x6e, 0x29, 0x89, 0xc7, 0x69, 0x62, 0x3d,
	0xd4, 0x12, 0xdf, 0x65, 0x79, 0xfb, 0x63, 0x52, 0x25, 0xa7, 0x9a, 0x4b, 0xf4, 0xa4, 0x62, 0x03,
	0x2a, 0x51, 0x4c, 0x58, 0x4c, 0xc4, 0xd4, 0xbc, 0x6d, 0x1b, 0xed, 0xb2, 0x53, 0xbc, 0xa3, 0x5d,
	0x80, 0x98, 0xf0, 0xa1, 0xcb, 0x7d, 0x16, 0x63, 0xf3, 0x8e, 0x6d, 0xb4, 0x4b, 0xdd, 0x66, 0x9a,
	0x58, 0x0d, 0xfd, 0x2d, 0x87, 0xf0, 0xa1, 0x7d, 0xe8, 0xcf, 0xc8, 0x3b, 0x6b, 0x92, 0xa1, 0x42,
	0x68, 0x17, 0x2a, 0x82, 0x45, 0xae, 0x3f, 0xe1, 0xdc, 0x34, 0x15, 0x79, 0xce, 0x0a, 0xaa, 0xc9,
	0x47, 0x2c, 0xb2, 0x7b, 0xc7, 0x87, 0x87, 0xb9, 0x7d, 0x5f, 0x97, 0x9d, 0x55, 0xc1, 0xa2, 0xde,
	0x84, 0xf3, 0xc6, 0x0b, 0xa8, 0xce, 0x0c, 0x4a, 0x54, 0x87, 0xf2, 0x10, 0x4f, 0xb3, 0x23, 0xc5,
	0x91, 0x8f, 0xe8, 0x26, 0x2c, 0x4f, 0xbc, 0x70, 0x9c, 0x1f, 0x1c, 0x4e, 0xf6, 0xf2, 0xb2, 0xf4,
	0xdc, 0x68, 0xec, 0x41, 0xfd, 0xf2, 0x5c, 0xfc, 0x2f, 0xfc, 0x6e, 0x1d, 0x6a, 0x1c, 0x0b, 0xf7,
	0x62, 0xcf, 0xba, 0x00, 0x15, 0x15, 0x99, 0x60, 0xde, 0xbd, 0x0e, 0x55, 0xf9, 0x9c, 0x77, 0xb1,
	0x5b, 0x83, 0x75, 0xf9, 0xaa, 0x97, 0xda, 0xfa, 0xd3, 0x80, 0x8a, 0xb6, 0x95, 0x9c, 0xb3, 0xd2,
	0x40, 0xae, 0x9a, 0x2d, 0xc6, 0xff, 0x98, 0xb3, 0x52, 0x65, 0x7e, 0xce, 0x4a, 0x3d, 0x19, 0xb8,
	0x72, 0x98, 0x94, 0xaf, 0x1e, 0x26, 0xdd, 0x39, 0xff, 0x96, 0xd4, 0x41, 0xd2, 0x2a, 0x7e, 0x82,
	0xfd, 0x51, 0x1f, 0x07, 0x01, 0x0e, 0x74, 0xd5, 0x85, 0x99, 0x67, 0x6d, 0xdb, 0xfa, 0xad, 0x04,
	0x5b, 0x1f, 0x45, 0xa2, 0xaf, 0xf2, 0x43, 0x3c, 0x3b, 0xf2, 0xef, 0xa5, 0x89, 0x65, 0x2e, 0xfc,
	0x1b, 0xf3, 0x27, 0xf9, 0x1e, 0xac, 0xea, 0x61, 0x93, 0x9d, 0xfc, 0x9f, 0xa7, 0x89, 0x65, 0x2f,
	0xfe, 0x50, 0xf9, 0xe4, 0x29, 0x06, 0x5c, 0x4e, 0x42, 0xcf, 0x60, 0x59, 0x5e, 0x4c, 0xf4, 0x45,
	0xa0, 0xb9, 0xb0, 0x9c, 0xe3, 0xd9, 0x6b, 0x8b, 0x93, 0x81, 0xe7, 0xfc, 0xbe, 0x74, 0xc9, 0xef,
	0x77, 0x67, 0x0c, 0x2b, 0x4f, 0xfc, 0xd2, 0xeb, 0x6b, 0x85, 0x1d, 0xd1, 0xf6, 0xdc, 0xcf, 0xb0,
	0x22, 0xd3, 0x33, 0x66, 0x5f, 0x70, 0xc1, 0x7d, 0xd8, 0x90, 0x4d, 0x2a, 0x96, 0xb1, 0x1f, 0x0c,
	0x30, 0xaa, 0x5d, 0xdc, 0x8a, 0xe4, 0xcd, 0xa7, 0x35, 0x82, 0xaa, 0x02, 0x1d, 0xef, 0x5f, 0x95,
	0x46, 0x6f, 0xe1, 0xd6, 0x09, 0x89, 0xb9, 0x70, 0xe5, 0xad, 0xcf, 0x65, 0xbe, 0x3f, 0x8e, 0x63,
	0x4c, 0xfd, 0xcc, 0xb0, 0xff, 0x6a, 0x24, 0x67, 0x53, 0x11, 0xa5, 0xf8, 0xbb, 0x82, 0xd6, 0x7d,
	0xf6, 0xfb, 0x79, 0xd3, 0xf8, 0xe3, 0xbc, 0x69, 0xfc, 0x75, 0xde, 0x34, 0x7e, 0xfd, 0xbb, 0x79,
	0x0d, 0xb6, 0x08, 0xeb, 0x70, 0xe1, 0xf9, 0xc3, 0x98, 0x9d, 0x65, 0x32, 0xba, 0x8b, 0x1f, 0xf4,
	0xf5, 0xb2, 0xbf, 0xa2, 0xe2, 0x5f, 0xff, 0x13, 0x00, 0x00, 0xff, 0xff, 0x21, 0x75, 0x5a, 0x0b,
	0x84, 0x0a, 0x00, 0x00,
}

func (m *Node) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Node) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Node) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.K8SUpdated != nil {
		{
			size, err := m.K8SUpdated.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNode(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd2
	}
	if m.LastUpdated != nil {
		{
			size, err := m.LastUpdated.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNode(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xca
	}
	if m.SetTopCvss != nil {
		{
			size := m.SetTopCvss.Size()
			i -= size
			if _, err := m.SetTopCvss.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.RiskScore != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.RiskScore))))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xbd
	}
	if m.Priority != 0 {
		i = encodeVarintNode(dAtA, i, uint64(m.Priority))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb0
	}
	if m.SetFixable != nil {
		{
			size := m.SetFixable.Size()
			i -= size
			if _, err := m.SetFixable.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.SetCves != nil {
		{
			size := m.SetCves.Size()
			i -= size
			if _, err := m.SetCves.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.SetComponents != nil {
		{
			size := m.SetComponents.Size()
			i -= size
			if _, err := m.SetComponents.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Scan != nil {
		{
			size, err := m.Scan.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNode(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if len(m.OperatingSystem) > 0 {
		i -= len(m.OperatingSystem)
		copy(dAtA[i:], m.OperatingSystem)
		i = encodeVarintNode(dAtA, i, uint64(len(m.OperatingSystem)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if len(m.KubeProxyVersion) > 0 {
		i -= len(m.KubeProxyVersion)
		copy(dAtA[i:], m.KubeProxyVersion)
		i = encodeVarintNode(dAtA, i, uint64(len(m.KubeProxyVersion)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if len(m.KubeletVersion) > 0 {
		i -= len(m.KubeletVersion)
		copy(dAtA[i:], m.KubeletVersion)
		i = encodeVarintNode(dAtA, i, uint64(len(m.KubeletVersion)))
		i--
		dAtA[i] = 0x7a
	}
	if m.ContainerRuntime != nil {
		{
			size, err := m.ContainerRuntime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNode(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x72
	}
	if m.JoinedAt != nil {
		{
			size, err := m.JoinedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNode(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	if len(m.OsImage) > 0 {
		i -= len(m.OsImage)
		copy(dAtA[i:], m.OsImage)
		i = encodeVarintNode(dAtA, i, uint64(len(m.OsImage)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.KernelVersion) > 0 {
		i -= len(m.KernelVersion)
		copy(dAtA[i:], m.KernelVersion)
		i = encodeVarintNode(dAtA, i, uint64(len(m.KernelVersion)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.ContainerRuntimeVersion) > 0 {
		i -= len(m.ContainerRuntimeVersion)
		copy(dAtA[i:], m.ContainerRuntimeVersion)
		i = encodeVarintNode(dAtA, i, uint64(len(m.ContainerRuntimeVersion)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.ExternalIpAddresses) > 0 {
		for iNdEx := len(m.ExternalIpAddresses) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ExternalIpAddresses[iNdEx])
			copy(dAtA[i:], m.ExternalIpAddresses[iNdEx])
			i = encodeVarintNode(dAtA, i, uint64(len(m.ExternalIpAddresses[iNdEx])))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.InternalIpAddresses) > 0 {
		for iNdEx := len(m.InternalIpAddresses) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.InternalIpAddresses[iNdEx])
			copy(dAtA[i:], m.InternalIpAddresses[iNdEx])
			i = encodeVarintNode(dAtA, i, uint64(len(m.InternalIpAddresses[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.Annotations) > 0 {
		for k := range m.Annotations {
			v := m.Annotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintNode(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintNode(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintNode(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintNode(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintNode(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintNode(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintNode(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintNode(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Taints) > 0 {
		for iNdEx := len(m.Taints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Taints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNode(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintNode(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintNode(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Node_Components) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Node_Components) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintNode(dAtA, i, uint64(m.Components))
	i--
	dAtA[i] = 0x1
	i--
	dAtA[i] = 0x98
	return len(dAtA) - i, nil
}
func (m *Node_Cves) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Node_Cves) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintNode(dAtA, i, uint64(m.Cves))
	i--
	dAtA[i] = 0x1
	i--
	dAtA[i] = 0xa0
	return len(dAtA) - i, nil
}
func (m *Node_FixableCves) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Node_FixableCves) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintNode(dAtA, i, uint64(m.FixableCves))
	i--
	dAtA[i] = 0x1
	i--
	dAtA[i] = 0xa8
	return len(dAtA) - i, nil
}
func (m *Node_TopCvss) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Node_TopCvss) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 4
	encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.TopCvss))))
	i--
	dAtA[i] = 0x1
	i--
	dAtA[i] = 0xc5
	return len(dAtA) - i, nil
}
func (m *NodeScan) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeScan) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeScan) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.OperatingSystem) > 0 {
		i -= len(m.OperatingSystem)
		copy(dAtA[i:], m.OperatingSystem)
		i = encodeVarintNode(dAtA, i, uint64(len(m.OperatingSystem)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Components) > 0 {
		for iNdEx := len(m.Components) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Components[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNode(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.ScanTime != nil {
		{
			size, err := m.ScanTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNode(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EmbeddedNodeScanComponent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EmbeddedNodeScanComponent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EmbeddedNodeScanComponent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RiskScore != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.RiskScore))))
		i--
		dAtA[i] = 0x35
	}
	if m.SetTopCvss != nil {
		{
			size := m.SetTopCvss.Size()
			i -= size
			if _, err := m.SetTopCvss.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Priority != 0 {
		i = encodeVarintNode(dAtA, i, uint64(m.Priority))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Vulns) > 0 {
		for iNdEx := len(m.Vulns) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Vulns[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNode(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintNode(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintNode(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EmbeddedNodeScanComponent_TopCvss) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EmbeddedNodeScanComponent_TopCvss) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 4
	encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.TopCvss))))
	i--
	dAtA[i] = 0x2d
	return len(dAtA) - i, nil
}
func (m *NodeComponentEdge) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeComponentEdge) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeComponentEdge) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintNode(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NodeCVEEdge) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeCVEEdge) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeCVEEdge) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.FirstNodeOccurrence != nil {
		{
			size, err := m.FirstNodeOccurrence.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNode(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintNode(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintNode(dAtA []byte, offset int, v uint64) int {
	offset -= sovNode(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Node) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovNode(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovNode(uint64(l))
	}
	if len(m.Taints) > 0 {
		for _, e := range m.Taints {
			l = e.Size()
			n += 1 + l + sovNode(uint64(l))
		}
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovNode(uint64(l))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovNode(uint64(l))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovNode(uint64(len(k))) + 1 + len(v) + sovNode(uint64(len(v)))
			n += mapEntrySize + 1 + sovNode(uint64(mapEntrySize))
		}
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovNode(uint64(len(k))) + 1 + len(v) + sovNode(uint64(len(v)))
			n += mapEntrySize + 1 + sovNode(uint64(mapEntrySize))
		}
	}
	if len(m.InternalIpAddresses) > 0 {
		for _, s := range m.InternalIpAddresses {
			l = len(s)
			n += 1 + l + sovNode(uint64(l))
		}
	}
	if len(m.ExternalIpAddresses) > 0 {
		for _, s := range m.ExternalIpAddresses {
			l = len(s)
			n += 1 + l + sovNode(uint64(l))
		}
	}
	l = len(m.ContainerRuntimeVersion)
	if l > 0 {
		n += 1 + l + sovNode(uint64(l))
	}
	l = len(m.KernelVersion)
	if l > 0 {
		n += 1 + l + sovNode(uint64(l))
	}
	l = len(m.OsImage)
	if l > 0 {
		n += 1 + l + sovNode(uint64(l))
	}
	if m.JoinedAt != nil {
		l = m.JoinedAt.Size()
		n += 1 + l + sovNode(uint64(l))
	}
	if m.ContainerRuntime != nil {
		l = m.ContainerRuntime.Size()
		n += 1 + l + sovNode(uint64(l))
	}
	l = len(m.KubeletVersion)
	if l > 0 {
		n += 1 + l + sovNode(uint64(l))
	}
	l = len(m.KubeProxyVersion)
	if l > 0 {
		n += 2 + l + sovNode(uint64(l))
	}
	l = len(m.OperatingSystem)
	if l > 0 {
		n += 2 + l + sovNode(uint64(l))
	}
	if m.Scan != nil {
		l = m.Scan.Size()
		n += 2 + l + sovNode(uint64(l))
	}
	if m.SetComponents != nil {
		n += m.SetComponents.Size()
	}
	if m.SetCves != nil {
		n += m.SetCves.Size()
	}
	if m.SetFixable != nil {
		n += m.SetFixable.Size()
	}
	if m.Priority != 0 {
		n += 2 + sovNode(uint64(m.Priority))
	}
	if m.RiskScore != 0 {
		n += 6
	}
	if m.SetTopCvss != nil {
		n += m.SetTopCvss.Size()
	}
	if m.LastUpdated != nil {
		l = m.LastUpdated.Size()
		n += 2 + l + sovNode(uint64(l))
	}
	if m.K8SUpdated != nil {
		l = m.K8SUpdated.Size()
		n += 2 + l + sovNode(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Node_Components) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 2 + sovNode(uint64(m.Components))
	return n
}
func (m *Node_Cves) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 2 + sovNode(uint64(m.Cves))
	return n
}
func (m *Node_FixableCves) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 2 + sovNode(uint64(m.FixableCves))
	return n
}
func (m *Node_TopCvss) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 6
	return n
}
func (m *NodeScan) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ScanTime != nil {
		l = m.ScanTime.Size()
		n += 1 + l + sovNode(uint64(l))
	}
	if len(m.Components) > 0 {
		for _, e := range m.Components {
			l = e.Size()
			n += 1 + l + sovNode(uint64(l))
		}
	}
	l = len(m.OperatingSystem)
	if l > 0 {
		n += 1 + l + sovNode(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EmbeddedNodeScanComponent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovNode(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovNode(uint64(l))
	}
	if len(m.Vulns) > 0 {
		for _, e := range m.Vulns {
			l = e.Size()
			n += 1 + l + sovNode(uint64(l))
		}
	}
	if m.Priority != 0 {
		n += 1 + sovNode(uint64(m.Priority))
	}
	if m.SetTopCvss != nil {
		n += m.SetTopCvss.Size()
	}
	if m.RiskScore != 0 {
		n += 5
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EmbeddedNodeScanComponent_TopCvss) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 5
	return n
}
func (m *NodeComponentEdge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovNode(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeCVEEdge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovNode(uint64(l))
	}
	if m.FirstNodeOccurrence != nil {
		l = m.FirstNodeOccurrence.Size()
		n += 1 + l + sovNode(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovNode(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozNode(x uint64) (n int) {
	return sovNode(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Node) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNode
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Node: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Node: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Taints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Taints = append(m.Taints, &Taint{})
			if err := m.Taints[len(m.Taints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowNode
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowNode
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthNode
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthNode
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowNode
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthNode
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthNode
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipNode(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthNode
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Annotations == nil {
				m.Annotations = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowNode
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowNode
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthNode
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthNode
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowNode
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthNode
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthNode
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipNode(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthNode
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Annotations[mapkey] = mapvalue
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InternalIpAddresses", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InternalIpAddresses = append(m.InternalIpAddresses, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExternalIpAddresses", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExternalIpAddresses = append(m.ExternalIpAddresses, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerRuntimeVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerRuntimeVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KernelVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.KernelVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OsImage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OsImage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field JoinedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.JoinedAt == nil {
				m.JoinedAt = &types.Timestamp{}
			}
			if err := m.JoinedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerRuntime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ContainerRuntime == nil {
				m.ContainerRuntime = &ContainerRuntimeInfo{}
			}
			if err := m.ContainerRuntime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KubeletVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.KubeletVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KubeProxyVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.KubeProxyVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OperatingSystem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OperatingSystem = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Scan == nil {
				m.Scan = &NodeScan{}
			}
			if err := m.Scan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Components", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SetComponents = &Node_Components{v}
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cves", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SetCves = &Node_Cves{v}
		case 21:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FixableCves", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SetFixable = &Node_FixableCves{v}
		case 22:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priority", wireType)
			}
			m.Priority = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Priority |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 23:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field RiskScore", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.RiskScore = float32(math.Float32frombits(v))
		case 24:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field TopCvss", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.SetTopCvss = &Node_TopCvss{float32(math.Float32frombits(v))}
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastUpdated == nil {
				m.LastUpdated = &types.Timestamp{}
			}
			if err := m.LastUpdated.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field K8SUpdated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.K8SUpdated == nil {
				m.K8SUpdated = &types.Timestamp{}
			}
			if err := m.K8SUpdated.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNode(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNode
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeScan) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNode
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeScan: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeScan: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScanTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScanTime == nil {
				m.ScanTime = &types.Timestamp{}
			}
			if err := m.ScanTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Components", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Components = append(m.Components, &EmbeddedNodeScanComponent{})
			if err := m.Components[len(m.Components)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OperatingSystem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OperatingSystem = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNode(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNode
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EmbeddedNodeScanComponent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNode
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EmbeddedNodeScanComponent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EmbeddedNodeScanComponent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Vulns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Vulns = append(m.Vulns, &EmbeddedVulnerability{})
			if err := m.Vulns[len(m.Vulns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priority", wireType)
			}
			m.Priority = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Priority |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field TopCvss", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.SetTopCvss = &EmbeddedNodeScanComponent_TopCvss{float32(math.Float32frombits(v))}
		case 6:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field RiskScore", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.RiskScore = float32(math.Float32frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipNode(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNode
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeComponentEdge) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNode
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeComponentEdge: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeComponentEdge: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNode(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNode
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeCVEEdge) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNode
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeCVEEdge: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeCVEEdge: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstNodeOccurrence", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNode
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNode
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNode
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FirstNodeOccurrence == nil {
				m.FirstNodeOccurrence = &types.Timestamp{}
			}
			if err := m.FirstNodeOccurrence.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNode(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNode
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipNode(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowNode
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNode
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNode
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthNode
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupNode
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthNode
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthNode        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowNode          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupNode = fmt.Errorf("proto: unexpected end of group")
)
