// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/process_indicator.proto

package storage

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Next available tag: 13
type ProcessIndicator struct {
	// A unique uuid for the Indicator message
	Id            string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" search:"Process ID,store,hidden"`
	DeploymentId  string `protobuf:"bytes,2,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty" search:"Deployment ID,store,hidden" policy:",prefer-parent"`
	ContainerName string `protobuf:"bytes,3,opt,name=container_name,json=containerName,proto3" json:"container_name,omitempty" search:"Container Name,hidden" policy:",prefer-parent"`
	// Pod name
	PodId  string `protobuf:"bytes,4,opt,name=pod_id,json=podId,proto3" json:"pod_id,omitempty" search:"Pod ID,hidden"`
	PodUid string `protobuf:"bytes,11,opt,name=pod_uid,json=podUid,proto3" json:"pod_uid,omitempty" search:"Pod UID,hidden"`
	// A process signal message passed from Collector to Sensor
	Signal               *ProcessSignal   `protobuf:"bytes,6,opt,name=signal,proto3" json:"signal,omitempty"`
	ClusterId            string           `protobuf:"bytes,7,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty" search:"Cluster ID,store,hidden" policy:",prefer-parent"`
	Namespace            string           `protobuf:"bytes,8,opt,name=namespace,proto3" json:"namespace,omitempty" search:"Namespace,store,hidden" policy:",prefer-parent"`
	ContainerStartTime   *types.Timestamp `protobuf:"bytes,9,opt,name=container_start_time,json=containerStartTime,proto3" json:"container_start_time,omitempty"`
	ImageId              string           `protobuf:"bytes,12,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ProcessIndicator) Reset()         { *m = ProcessIndicator{} }
func (m *ProcessIndicator) String() string { return proto.CompactTextString(m) }
func (*ProcessIndicator) ProtoMessage()    {}
func (*ProcessIndicator) Descriptor() ([]byte, []int) {
	return fileDescriptor_a226da59a324d96a, []int{0}
}
func (m *ProcessIndicator) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessIndicator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessIndicator.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessIndicator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessIndicator.Merge(m, src)
}
func (m *ProcessIndicator) XXX_Size() int {
	return m.Size()
}
func (m *ProcessIndicator) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessIndicator.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessIndicator proto.InternalMessageInfo

func (m *ProcessIndicator) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ProcessIndicator) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *ProcessIndicator) GetContainerName() string {
	if m != nil {
		return m.ContainerName
	}
	return ""
}

func (m *ProcessIndicator) GetPodId() string {
	if m != nil {
		return m.PodId
	}
	return ""
}

func (m *ProcessIndicator) GetPodUid() string {
	if m != nil {
		return m.PodUid
	}
	return ""
}

func (m *ProcessIndicator) GetSignal() *ProcessSignal {
	if m != nil {
		return m.Signal
	}
	return nil
}

func (m *ProcessIndicator) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ProcessIndicator) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ProcessIndicator) GetContainerStartTime() *types.Timestamp {
	if m != nil {
		return m.ContainerStartTime
	}
	return nil
}

func (m *ProcessIndicator) GetImageId() string {
	if m != nil {
		return m.ImageId
	}
	return ""
}

func (m *ProcessIndicator) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ProcessIndicator) Clone() *ProcessIndicator {
	if m == nil {
		return nil
	}
	cloned := new(ProcessIndicator)
	*cloned = *m

	cloned.Signal = m.Signal.Clone()
	cloned.ContainerStartTime = m.ContainerStartTime.Clone()
	return cloned
}

// This is the unique key we store process indicators under in Bolt.
// This is stored in the DB, so please follow proto compatibility rules for it,
// OR discard existing values and repopulate it on startup.
type ProcessIndicatorUniqueKey struct {
	PodId                string   `protobuf:"bytes,1,opt,name=pod_id,json=podId,proto3" json:"pod_id,omitempty"`
	ContainerName        string   `protobuf:"bytes,2,opt,name=container_name,json=containerName,proto3" json:"container_name,omitempty"`
	ProcessName          string   `protobuf:"bytes,3,opt,name=process_name,json=processName,proto3" json:"process_name,omitempty"`
	ProcessExecFilePath  string   `protobuf:"bytes,4,opt,name=process_exec_file_path,json=processExecFilePath,proto3" json:"process_exec_file_path,omitempty"`
	ProcessArgs          string   `protobuf:"bytes,5,opt,name=process_args,json=processArgs,proto3" json:"process_args,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessIndicatorUniqueKey) Reset()         { *m = ProcessIndicatorUniqueKey{} }
func (m *ProcessIndicatorUniqueKey) String() string { return proto.CompactTextString(m) }
func (*ProcessIndicatorUniqueKey) ProtoMessage()    {}
func (*ProcessIndicatorUniqueKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_a226da59a324d96a, []int{1}
}
func (m *ProcessIndicatorUniqueKey) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessIndicatorUniqueKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessIndicatorUniqueKey.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessIndicatorUniqueKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessIndicatorUniqueKey.Merge(m, src)
}
func (m *ProcessIndicatorUniqueKey) XXX_Size() int {
	return m.Size()
}
func (m *ProcessIndicatorUniqueKey) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessIndicatorUniqueKey.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessIndicatorUniqueKey proto.InternalMessageInfo

func (m *ProcessIndicatorUniqueKey) GetPodId() string {
	if m != nil {
		return m.PodId
	}
	return ""
}

func (m *ProcessIndicatorUniqueKey) GetContainerName() string {
	if m != nil {
		return m.ContainerName
	}
	return ""
}

func (m *ProcessIndicatorUniqueKey) GetProcessName() string {
	if m != nil {
		return m.ProcessName
	}
	return ""
}

func (m *ProcessIndicatorUniqueKey) GetProcessExecFilePath() string {
	if m != nil {
		return m.ProcessExecFilePath
	}
	return ""
}

func (m *ProcessIndicatorUniqueKey) GetProcessArgs() string {
	if m != nil {
		return m.ProcessArgs
	}
	return ""
}

func (m *ProcessIndicatorUniqueKey) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ProcessIndicatorUniqueKey) Clone() *ProcessIndicatorUniqueKey {
	if m == nil {
		return nil
	}
	cloned := new(ProcessIndicatorUniqueKey)
	*cloned = *m

	return cloned
}

type ProcessSignal struct {
	// A unique UUID for identifying the message
	// We have this here instead of at the top level
	// because we want to have each message to be
	// self contained.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of container associated with this process
	ContainerId string `protobuf:"bytes,2,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty" search:"Container ID,hidden"`
	// Process creation time
	Time *types.Timestamp `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
	// Process name
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty" search:"Process Name"`
	// Process arguments
	Args string `protobuf:"bytes,5,opt,name=args,proto3" json:"args,omitempty" search:"Process Arguments"`
	// Process executable file path
	ExecFilePath string `protobuf:"bytes,6,opt,name=exec_file_path,json=execFilePath,proto3" json:"exec_file_path,omitempty" search:"Process Path"`
	// Host process ID
	Pid uint32 `protobuf:"varint,7,opt,name=pid,proto3" json:"pid,omitempty"`
	// Real user ID
	Uid uint32 `protobuf:"varint,8,opt,name=uid,proto3" json:"uid,omitempty" search:"Process UID"`
	// Real group ID
	Gid uint32 `protobuf:"varint,9,opt,name=gid,proto3" json:"gid,omitempty"`
	// Process Lineage
	Lineage []string `protobuf:"bytes,10,rep,name=lineage,proto3" json:"lineage,omitempty"` // Deprecated: Do not use.
	// Signal origin
	Scraped bool `protobuf:"varint,11,opt,name=scraped,proto3" json:"scraped,omitempty"`
	// Process LineageInfo
	LineageInfo          []*ProcessSignal_LineageInfo `protobuf:"bytes,12,rep,name=lineage_info,json=lineageInfo,proto3" json:"lineage_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *ProcessSignal) Reset()         { *m = ProcessSignal{} }
func (m *ProcessSignal) String() string { return proto.CompactTextString(m) }
func (*ProcessSignal) ProtoMessage()    {}
func (*ProcessSignal) Descriptor() ([]byte, []int) {
	return fileDescriptor_a226da59a324d96a, []int{2}
}
func (m *ProcessSignal) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessSignal) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessSignal.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessSignal) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessSignal.Merge(m, src)
}
func (m *ProcessSignal) XXX_Size() int {
	return m.Size()
}
func (m *ProcessSignal) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessSignal.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessSignal proto.InternalMessageInfo

func (m *ProcessSignal) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ProcessSignal) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

func (m *ProcessSignal) GetTime() *types.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

func (m *ProcessSignal) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ProcessSignal) GetArgs() string {
	if m != nil {
		return m.Args
	}
	return ""
}

func (m *ProcessSignal) GetExecFilePath() string {
	if m != nil {
		return m.ExecFilePath
	}
	return ""
}

func (m *ProcessSignal) GetPid() uint32 {
	if m != nil {
		return m.Pid
	}
	return 0
}

func (m *ProcessSignal) GetUid() uint32 {
	if m != nil {
		return m.Uid
	}
	return 0
}

func (m *ProcessSignal) GetGid() uint32 {
	if m != nil {
		return m.Gid
	}
	return 0
}

// Deprecated: Do not use.
func (m *ProcessSignal) GetLineage() []string {
	if m != nil {
		return m.Lineage
	}
	return nil
}

func (m *ProcessSignal) GetScraped() bool {
	if m != nil {
		return m.Scraped
	}
	return false
}

func (m *ProcessSignal) GetLineageInfo() []*ProcessSignal_LineageInfo {
	if m != nil {
		return m.LineageInfo
	}
	return nil
}

func (m *ProcessSignal) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ProcessSignal) Clone() *ProcessSignal {
	if m == nil {
		return nil
	}
	cloned := new(ProcessSignal)
	*cloned = *m

	cloned.Time = m.Time.Clone()
	if m.Lineage != nil {
		cloned.Lineage = make([]string, len(m.Lineage))
		copy(cloned.Lineage, m.Lineage)
	}
	if m.LineageInfo != nil {
		cloned.LineageInfo = make([]*ProcessSignal_LineageInfo, len(m.LineageInfo))
		for idx, v := range m.LineageInfo {
			cloned.LineageInfo[idx] = v.Clone()
		}
	}
	return cloned
}

type ProcessSignal_LineageInfo struct {
	ParentUid            uint32   `protobuf:"varint,1,opt,name=parent_uid,json=parentUid,proto3" json:"parent_uid,omitempty"`
	ParentExecFilePath   string   `protobuf:"bytes,2,opt,name=parent_exec_file_path,json=parentExecFilePath,proto3" json:"parent_exec_file_path,omitempty" search:"Process Ancestor"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessSignal_LineageInfo) Reset()         { *m = ProcessSignal_LineageInfo{} }
func (m *ProcessSignal_LineageInfo) String() string { return proto.CompactTextString(m) }
func (*ProcessSignal_LineageInfo) ProtoMessage()    {}
func (*ProcessSignal_LineageInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_a226da59a324d96a, []int{2, 0}
}
func (m *ProcessSignal_LineageInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessSignal_LineageInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessSignal_LineageInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessSignal_LineageInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessSignal_LineageInfo.Merge(m, src)
}
func (m *ProcessSignal_LineageInfo) XXX_Size() int {
	return m.Size()
}
func (m *ProcessSignal_LineageInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessSignal_LineageInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessSignal_LineageInfo proto.InternalMessageInfo

func (m *ProcessSignal_LineageInfo) GetParentUid() uint32 {
	if m != nil {
		return m.ParentUid
	}
	return 0
}

func (m *ProcessSignal_LineageInfo) GetParentExecFilePath() string {
	if m != nil {
		return m.ParentExecFilePath
	}
	return ""
}

func (m *ProcessSignal_LineageInfo) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ProcessSignal_LineageInfo) Clone() *ProcessSignal_LineageInfo {
	if m == nil {
		return nil
	}
	cloned := new(ProcessSignal_LineageInfo)
	*cloned = *m

	return cloned
}

func init() {
	proto.RegisterType((*ProcessIndicator)(nil), "storage.ProcessIndicator")
	proto.RegisterType((*ProcessIndicatorUniqueKey)(nil), "storage.ProcessIndicatorUniqueKey")
	proto.RegisterType((*ProcessSignal)(nil), "storage.ProcessSignal")
	proto.RegisterType((*ProcessSignal_LineageInfo)(nil), "storage.ProcessSignal.LineageInfo")
}

func init() { proto.RegisterFile("storage/process_indicator.proto", fileDescriptor_a226da59a324d96a) }

var fileDescriptor_a226da59a324d96a = []byte{
	// 854 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x55, 0xcf, 0x6f, 0xdc, 0x44,
	0x14, 0xc6, 0xd9, 0xdf, 0x6f, 0x77, 0xa3, 0x68, 0x48, 0x82, 0x77, 0x69, 0xd7, 0xc6, 0x02, 0x29,
	0x42, 0xa9, 0x23, 0xd2, 0x8a, 0xa2, 0x14, 0xa9, 0xea, 0x36, 0x45, 0x72, 0xa9, 0xaa, 0x68, 0x4a,
	0x0e, 0xc0, 0x61, 0x35, 0xf5, 0xcc, 0x3a, 0x23, 0xbc, 0x1e, 0x63, 0x7b, 0xa5, 0xe4, 0xc2, 0x95,
	0x7f, 0x81, 0x3f, 0x89, 0x23, 0x07, 0x24, 0x6e, 0x16, 0x0a, 0xff, 0x81, 0x4f, 0x1c, 0xd1, 0x8c,
	0x3d, 0xde, 0xed, 0x2e, 0x55, 0x7b, 0x1b, 0xcf, 0xfb, 0xde, 0x37, 0xf3, 0xde, 0xfb, 0xbe, 0x31,
	0x58, 0x69, 0x26, 0x12, 0x12, 0xb0, 0x93, 0x38, 0x11, 0x3e, 0x4b, 0xd3, 0x19, 0x8f, 0x28, 0xf7,
	0x49, 0x26, 0x12, 0x37, 0x4e, 0x44, 0x26, 0x50, 0xa7, 0x02, 0x8c, 0xad, 0x40, 0x88, 0x20, 0x54,
	0xc0, 0x4c, 0xbc, 0x5e, 0xce, 0x4f, 0x32, 0xbe, 0x60, 0x69, 0x46, 0x16, 0x71, 0x89, 0x1c, 0xef,
	0x07, 0x22, 0x10, 0x6a, 0x79, 0x22, 0x57, 0xe5, 0xae, 0xf3, 0x57, 0x0b, 0xf6, 0x2e, 0x4a, 0x6e,
	0x4f, 0x53, 0xa3, 0x07, 0xb0, 0xc3, 0xa9, 0x69, 0xd8, 0xc6, 0x51, 0x6f, 0xfa, 0x69, 0x91, 0x5b,
	0x76, 0xca, 0x48, 0xe2, 0x5f, 0x9d, 0x39, 0x15, 0xd2, 0xf6, 0xce, 0x8f, 0xe5, 0xb9, 0xec, 0xf8,
	0x8a, 0x53, 0xca, 0x22, 0x07, 0xef, 0x70, 0x8a, 0x28, 0x0c, 0x29, 0x8b, 0x43, 0x71, 0xb3, 0x60,
	0x51, 0x36, 0xe3, 0xd4, 0xdc, 0x51, 0x04, 0x8f, 0x8b, 0xdc, 0x7a, 0xa4, 0x09, 0xce, 0x6b, 0xc0,
	0x16, 0x87, 0x1d, 0x8b, 0x90, 0xfb, 0x37, 0x67, 0xce, 0x71, 0x9c, 0xb0, 0x39, 0x4b, 0xee, 0xc5,
	0x24, 0x61, 0x51, 0xe6, 0xe0, 0xc1, 0x8a, 0xd5, 0xa3, 0x88, 0xc0, 0xae, 0x2f, 0xa2, 0x8c, 0xf0,
	0x88, 0x25, 0xb3, 0x88, 0x2c, 0x98, 0xd9, 0x50, 0xc7, 0x9c, 0x15, 0xb9, 0xf5, 0xa5, 0x3e, 0xe6,
	0xa9, 0x46, 0xd8, 0x2f, 0xc9, 0xe2, 0xdd, 0x27, 0x0c, 0x6b, 0x46, 0x09, 0x47, 0x5f, 0x40, 0x3b,
	0x16, 0x54, 0x56, 0xd0, 0x54, 0xd4, 0xe3, 0x22, 0xb7, 0x0e, 0xeb, 0x16, 0x08, 0x2a, 0xaf, 0xae,
	0x0b, 0x6f, 0xc5, 0x82, 0x7a, 0x14, 0x3d, 0x80, 0x8e, 0x4c, 0x59, 0x72, 0x6a, 0xf6, 0x55, 0xce,
	0xc7, 0x45, 0x6e, 0x7d, 0xb4, 0x9e, 0x73, 0xb9, 0x96, 0x24, 0xe9, 0x2f, 0x39, 0x45, 0x2e, 0xb4,
	0x53, 0x1e, 0x44, 0x24, 0x34, 0xdb, 0xb6, 0x71, 0xd4, 0x3f, 0x3d, 0x74, 0xab, 0x69, 0xba, 0x55,
	0xa3, 0x5f, 0xa9, 0x28, 0xae, 0x50, 0xe8, 0x47, 0x00, 0x3f, 0x5c, 0xa6, 0x19, 0x4b, 0xe4, 0xe5,
	0x3a, 0xea, 0xa0, 0xaf, 0x8b, 0xdc, 0xfa, 0xaa, 0xae, 0xbb, 0x8c, 0xbe, 0x7f, 0x6f, 0x7b, 0x15,
	0x9f, 0x47, 0xd1, 0xf7, 0xd0, 0x93, 0xed, 0x4c, 0x63, 0xe2, 0x33, 0xb3, 0xab, 0xb8, 0x1f, 0x15,
	0xb9, 0xf5, 0x50, 0x73, 0xbf, 0xd4, 0xc1, 0xf7, 0xa5, 0xae, 0xd9, 0xd0, 0x0b, 0xd8, 0x5f, 0xcd,
	0x2c, 0xcd, 0x48, 0x92, 0xcd, 0xa4, 0x3a, 0xcd, 0x9e, 0xaa, 0x7a, 0xec, 0x96, 0xd2, 0x75, 0xb5,
	0x74, 0xdd, 0xef, 0xb4, 0x74, 0x31, 0xaa, 0xf3, 0x5e, 0xc9, 0x34, 0x19, 0x40, 0x23, 0xe8, 0xf2,
	0x05, 0x09, 0x98, 0xec, 0xc1, 0x40, 0xde, 0x13, 0x77, 0xd4, 0xb7, 0x47, 0x9f, 0x37, 0xbb, 0xb0,
	0xd7, 0x7f, 0xde, 0xec, 0xb6, 0xf6, 0xda, 0xce, 0x9f, 0x06, 0x8c, 0x36, 0x95, 0x7d, 0x19, 0xf1,
	0x9f, 0x97, 0xec, 0x5b, 0x76, 0x83, 0x0e, 0xea, 0x19, 0x2b, 0x99, 0xeb, 0x39, 0x7e, 0xb6, 0xa5,
	0x2e, 0x25, 0xe2, 0x4d, 0x85, 0x7c, 0x02, 0x03, 0x6d, 0xc8, 0x95, 0x04, 0x71, 0xbf, 0xda, 0x53,
	0x90, 0xfb, 0x70, 0xa8, 0x21, 0xec, 0x9a, 0xf9, 0xb3, 0x39, 0x0f, 0xd9, 0x2c, 0x26, 0xd9, 0x55,
	0x29, 0x2a, 0xfc, 0x61, 0x15, 0x7d, 0x76, 0xcd, 0xfc, 0x6f, 0x78, 0xc8, 0x2e, 0x48, 0x76, 0xb5,
	0xce, 0x4b, 0x92, 0x20, 0x35, 0x5b, 0x6f, 0xf0, 0x3e, 0x49, 0x82, 0xd4, 0xf9, 0xb5, 0x05, 0xc3,
	0x37, 0xd4, 0x81, 0x76, 0x57, 0x6e, 0x55, 0x3e, 0x7c, 0x0a, 0x83, 0x55, 0x0d, 0xb5, 0x0d, 0xed,
	0x22, 0xb7, 0xee, 0x6c, 0xfb, 0x63, 0x4d, 0x95, 0xfd, 0x3a, 0xcb, 0x93, 0xd2, 0x6c, 0xaa, 0x11,
	0x35, 0xde, 0x39, 0x22, 0x85, 0x43, 0xf7, 0xa0, 0xa9, 0x3a, 0x51, 0x3a, 0x66, 0x54, 0xe4, 0xd6,
	0xc1, 0xe6, 0xa3, 0x21, 0xdb, 0xe2, 0x60, 0x05, 0x43, 0xa7, 0xd0, 0x5c, 0x15, 0x38, 0x9d, 0x14,
	0xb9, 0x35, 0xde, 0x84, 0x3f, 0x49, 0x82, 0xa5, 0xf4, 0x7c, 0xea, 0x60, 0x85, 0x45, 0x8f, 0x61,
	0x77, 0xa3, 0x93, 0xed, 0xb7, 0x1f, 0x26, 0xdb, 0xe9, 0xe0, 0x01, 0x5b, 0xef, 0xee, 0x1e, 0x34,
	0xe2, 0xca, 0x37, 0x43, 0x2c, 0x97, 0xe8, 0x73, 0x68, 0x48, 0xcb, 0x4a, 0xb5, 0x0f, 0xa7, 0x66,
	0x91, 0x5b, 0xfb, 0x9b, 0x3c, 0x97, 0xde, 0xb9, 0x83, 0x25, 0x48, 0x66, 0x07, 0x9c, 0x2a, 0xcd,
	0x0e, 0xb1, 0x5c, 0xa2, 0x3b, 0xd0, 0x09, 0x79, 0xc4, 0x48, 0xc0, 0x4c, 0xb0, 0x1b, 0x47, 0xbd,
	0xe9, 0x8e, 0x69, 0x60, 0xbd, 0x85, 0x4c, 0xe8, 0xa4, 0x7e, 0x42, 0x62, 0x56, 0x3e, 0x09, 0x5d,
	0xac, 0x3f, 0xd1, 0x33, 0x18, 0x54, 0xa0, 0x19, 0x8f, 0xe6, 0xc2, 0x1c, 0xd8, 0x8d, 0xa3, 0xfe,
	0xa9, 0xf3, 0xff, 0xe6, 0x77, 0x5f, 0x94, 0x50, 0x2f, 0x9a, 0x0b, 0xdc, 0x0f, 0x57, 0x1f, 0xe3,
	0x5f, 0xa0, 0xbf, 0x16, 0x43, 0x77, 0x01, 0x4a, 0xeb, 0xa9, 0x57, 0xc8, 0x50, 0xd7, 0xec, 0x95,
	0x3b, 0xf2, 0xad, 0xb9, 0x80, 0x83, 0x2a, 0xbc, 0xd1, 0xc4, 0x52, 0x1e, 0x77, 0x8b, 0xdc, 0x1a,
	0x6d, 0x8d, 0x20, 0xf2, 0x99, 0xbc, 0x94, 0x83, 0x51, 0x99, 0xbb, 0x2e, 0xd6, 0xe9, 0xc3, 0xdf,
	0x6f, 0x27, 0xc6, 0x1f, 0xb7, 0x13, 0xe3, 0xef, 0xdb, 0x89, 0xf1, 0xdb, 0x3f, 0x93, 0x0f, 0x60,
	0xc4, 0x85, 0x9b, 0x66, 0xc4, 0xff, 0x29, 0x11, 0xd7, 0xa5, 0x54, 0x74, 0x4d, 0x3f, 0xe8, 0xff,
	0xd4, 0xbf, 0x86, 0xf1, 0xba, 0xad, 0x42, 0xf7, 0xff, 0x0b, 0x00, 0x00, 0xff, 0xff, 0x0f, 0xbc,
	0xe0, 0x32, 0xdd, 0x06, 0x00, 0x00,
}

func (m *ProcessIndicator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessIndicator) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessIndicator) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ImageId) > 0 {
		i -= len(m.ImageId)
		copy(dAtA[i:], m.ImageId)
		i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.ImageId)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.PodUid) > 0 {
		i -= len(m.PodUid)
		copy(dAtA[i:], m.PodUid)
		i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.PodUid)))
		i--
		dAtA[i] = 0x5a
	}
	if m.ContainerStartTime != nil {
		{
			size, err := m.ContainerStartTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProcessIndicator(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x3a
	}
	if m.Signal != nil {
		{
			size, err := m.Signal.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProcessIndicator(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.PodId) > 0 {
		i -= len(m.PodId)
		copy(dAtA[i:], m.PodId)
		i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.PodId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ContainerName) > 0 {
		i -= len(m.ContainerName)
		copy(dAtA[i:], m.ContainerName)
		i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.ContainerName)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ProcessIndicatorUniqueKey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessIndicatorUniqueKey) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessIndicatorUniqueKey) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ProcessArgs) > 0 {
		i -= len(m.ProcessArgs)
		copy(dAtA[i:], m.ProcessArgs)
		i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.ProcessArgs)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ProcessExecFilePath) > 0 {
		i -= len(m.ProcessExecFilePath)
		copy(dAtA[i:], m.ProcessExecFilePath)
		i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.ProcessExecFilePath)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ProcessName) > 0 {
		i -= len(m.ProcessName)
		copy(dAtA[i:], m.ProcessName)
		i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.ProcessName)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ContainerName) > 0 {
		i -= len(m.ContainerName)
		copy(dAtA[i:], m.ContainerName)
		i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.ContainerName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.PodId) > 0 {
		i -= len(m.PodId)
		copy(dAtA[i:], m.PodId)
		i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.PodId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ProcessSignal) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessSignal) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessSignal) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.LineageInfo) > 0 {
		for iNdEx := len(m.LineageInfo) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.LineageInfo[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProcessIndicator(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x62
		}
	}
	if m.Scraped {
		i--
		if m.Scraped {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if len(m.Lineage) > 0 {
		for iNdEx := len(m.Lineage) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Lineage[iNdEx])
			copy(dAtA[i:], m.Lineage[iNdEx])
			i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.Lineage[iNdEx])))
			i--
			dAtA[i] = 0x52
		}
	}
	if m.Gid != 0 {
		i = encodeVarintProcessIndicator(dAtA, i, uint64(m.Gid))
		i--
		dAtA[i] = 0x48
	}
	if m.Uid != 0 {
		i = encodeVarintProcessIndicator(dAtA, i, uint64(m.Uid))
		i--
		dAtA[i] = 0x40
	}
	if m.Pid != 0 {
		i = encodeVarintProcessIndicator(dAtA, i, uint64(m.Pid))
		i--
		dAtA[i] = 0x38
	}
	if len(m.ExecFilePath) > 0 {
		i -= len(m.ExecFilePath)
		copy(dAtA[i:], m.ExecFilePath)
		i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.ExecFilePath)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Args) > 0 {
		i -= len(m.Args)
		copy(dAtA[i:], m.Args)
		i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.Args)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x22
	}
	if m.Time != nil {
		{
			size, err := m.Time.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProcessIndicator(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ProcessSignal_LineageInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessSignal_LineageInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessSignal_LineageInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ParentExecFilePath) > 0 {
		i -= len(m.ParentExecFilePath)
		copy(dAtA[i:], m.ParentExecFilePath)
		i = encodeVarintProcessIndicator(dAtA, i, uint64(len(m.ParentExecFilePath)))
		i--
		dAtA[i] = 0x12
	}
	if m.ParentUid != 0 {
		i = encodeVarintProcessIndicator(dAtA, i, uint64(m.ParentUid))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintProcessIndicator(dAtA []byte, offset int, v uint64) int {
	offset -= sovProcessIndicator(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ProcessIndicator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	l = len(m.ContainerName)
	if l > 0 {
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	l = len(m.PodId)
	if l > 0 {
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	if m.Signal != nil {
		l = m.Signal.Size()
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	if m.ContainerStartTime != nil {
		l = m.ContainerStartTime.Size()
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	l = len(m.PodUid)
	if l > 0 {
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	l = len(m.ImageId)
	if l > 0 {
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProcessIndicatorUniqueKey) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PodId)
	if l > 0 {
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	l = len(m.ContainerName)
	if l > 0 {
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	l = len(m.ProcessName)
	if l > 0 {
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	l = len(m.ProcessExecFilePath)
	if l > 0 {
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	l = len(m.ProcessArgs)
	if l > 0 {
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProcessSignal) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	if m.Time != nil {
		l = m.Time.Size()
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	l = len(m.Args)
	if l > 0 {
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	l = len(m.ExecFilePath)
	if l > 0 {
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	if m.Pid != 0 {
		n += 1 + sovProcessIndicator(uint64(m.Pid))
	}
	if m.Uid != 0 {
		n += 1 + sovProcessIndicator(uint64(m.Uid))
	}
	if m.Gid != 0 {
		n += 1 + sovProcessIndicator(uint64(m.Gid))
	}
	if len(m.Lineage) > 0 {
		for _, s := range m.Lineage {
			l = len(s)
			n += 1 + l + sovProcessIndicator(uint64(l))
		}
	}
	if m.Scraped {
		n += 2
	}
	if len(m.LineageInfo) > 0 {
		for _, e := range m.LineageInfo {
			l = e.Size()
			n += 1 + l + sovProcessIndicator(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProcessSignal_LineageInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ParentUid != 0 {
		n += 1 + sovProcessIndicator(uint64(m.ParentUid))
	}
	l = len(m.ParentExecFilePath)
	if l > 0 {
		n += 1 + l + sovProcessIndicator(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovProcessIndicator(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozProcessIndicator(x uint64) (n int) {
	return sovProcessIndicator(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ProcessIndicator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessIndicator
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessIndicator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessIndicator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PodId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Signal", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Signal == nil {
				m.Signal = &ProcessSignal{}
			}
			if err := m.Signal.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerStartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ContainerStartTime == nil {
				m.ContainerStartTime = &types.Timestamp{}
			}
			if err := m.ContainerStartTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PodUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ImageId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ImageId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessIndicator(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessIndicatorUniqueKey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessIndicator
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessIndicatorUniqueKey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessIndicatorUniqueKey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PodId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProcessName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessExecFilePath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProcessExecFilePath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessArgs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProcessArgs = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessIndicator(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessSignal) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessIndicator
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessSignal: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessSignal: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Time == nil {
				m.Time = &types.Timestamp{}
			}
			if err := m.Time.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecFilePath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExecFilePath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pid", wireType)
			}
			m.Pid = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Pid |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uid", wireType)
			}
			m.Uid = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Uid |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gid", wireType)
			}
			m.Gid = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Gid |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lineage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Lineage = append(m.Lineage, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scraped", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Scraped = bool(v != 0)
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LineageInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LineageInfo = append(m.LineageInfo, &ProcessSignal_LineageInfo{})
			if err := m.LineageInfo[len(m.LineageInfo)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessIndicator(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessSignal_LineageInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessIndicator
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LineageInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LineageInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentUid", wireType)
			}
			m.ParentUid = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ParentUid |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentExecFilePath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentExecFilePath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessIndicator(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProcessIndicator
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipProcessIndicator(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowProcessIndicator
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProcessIndicator
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthProcessIndicator
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupProcessIndicator
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthProcessIndicator
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthProcessIndicator        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowProcessIndicator          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupProcessIndicator = fmt.Errorf("proto: unexpected end of group")
)
