// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/rbac.proto

package storage

import (
	bytes "bytes"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type SubjectKind int32

const (
	SubjectKind_UNSET_KIND      SubjectKind = 0
	SubjectKind_SERVICE_ACCOUNT SubjectKind = 1
	SubjectKind_USER            SubjectKind = 2
	SubjectKind_GROUP           SubjectKind = 3
)

var SubjectKind_name = map[int32]string{
	0: "UNSET_KIND",
	1: "SERVICE_ACCOUNT",
	2: "USER",
	3: "GROUP",
}

var SubjectKind_value = map[string]int32{
	"UNSET_KIND":      0,
	"SERVICE_ACCOUNT": 1,
	"USER":            2,
	"GROUP":           3,
}

func (x SubjectKind) String() string {
	return proto.EnumName(SubjectKind_name, int32(x))
}

func (SubjectKind) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_385316e6bc10731c, []int{0}
}

// For any update to PermissionLevel, also update:
// - pkg/searchbasedpolicies/builders/k8s_rbac.go
// - ui/src/messages/common.js
type PermissionLevel int32

const (
	PermissionLevel_UNSET                 PermissionLevel = 0
	PermissionLevel_NONE                  PermissionLevel = 1
	PermissionLevel_DEFAULT               PermissionLevel = 2
	PermissionLevel_ELEVATED_IN_NAMESPACE PermissionLevel = 3
	PermissionLevel_ELEVATED_CLUSTER_WIDE PermissionLevel = 4
	PermissionLevel_CLUSTER_ADMIN         PermissionLevel = 5
)

var PermissionLevel_name = map[int32]string{
	0: "UNSET",
	1: "NONE",
	2: "DEFAULT",
	3: "ELEVATED_IN_NAMESPACE",
	4: "ELEVATED_CLUSTER_WIDE",
	5: "CLUSTER_ADMIN",
}

var PermissionLevel_value = map[string]int32{
	"UNSET":                 0,
	"NONE":                  1,
	"DEFAULT":               2,
	"ELEVATED_IN_NAMESPACE": 3,
	"ELEVATED_CLUSTER_WIDE": 4,
	"CLUSTER_ADMIN":         5,
}

func (x PermissionLevel) String() string {
	return proto.EnumName(PermissionLevel_name, int32(x))
}

func (PermissionLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_385316e6bc10731c, []int{1}
}

// Properties of an individual k8s Role or ClusterRole.
//////////////////////////////////////////
type K8SRole struct {
	Id          string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" search:"Role ID,hidden"`
	Name        string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty" search:"Role"`
	Namespace   string `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty" search:"Namespace,store"`
	ClusterId   string `protobuf:"bytes,4,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty" search:"Cluster ID,store,hidden"`
	ClusterName string `protobuf:"bytes,5,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty" search:"Cluster"`
	ClusterRole bool   `protobuf:"varint,6,opt,name=cluster_role,json=clusterRole,proto3" json:"cluster_role,omitempty" search:"Cluster Role"`
	// TODO(ROX-6895): "Label" search term is ambiguous.
	Labels               map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" search:"Label" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Annotations          map[string]string `protobuf:"bytes,8,rep,name=annotations,proto3" json:"annotations,omitempty" search:"Annotation" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	CreatedAt            *types.Timestamp  `protobuf:"bytes,9,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	Rules                []*PolicyRule     `protobuf:"bytes,10,rep,name=rules,proto3" json:"rules,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *K8SRole) Reset()         { *m = K8SRole{} }
func (m *K8SRole) String() string { return proto.CompactTextString(m) }
func (*K8SRole) ProtoMessage()    {}
func (*K8SRole) Descriptor() ([]byte, []int) {
	return fileDescriptor_385316e6bc10731c, []int{0}
}
func (m *K8SRole) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *K8SRole) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_K8SRole.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *K8SRole) XXX_Merge(src proto.Message) {
	xxx_messageInfo_K8SRole.Merge(m, src)
}
func (m *K8SRole) XXX_Size() int {
	return m.Size()
}
func (m *K8SRole) XXX_DiscardUnknown() {
	xxx_messageInfo_K8SRole.DiscardUnknown(m)
}

var xxx_messageInfo_K8SRole proto.InternalMessageInfo

func (m *K8SRole) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *K8SRole) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *K8SRole) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *K8SRole) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *K8SRole) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *K8SRole) GetClusterRole() bool {
	if m != nil {
		return m.ClusterRole
	}
	return false
}

func (m *K8SRole) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *K8SRole) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *K8SRole) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *K8SRole) GetRules() []*PolicyRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

func (m *K8SRole) MessageClone() proto.Message {
	return m.Clone()
}
func (m *K8SRole) Clone() *K8SRole {
	if m == nil {
		return nil
	}
	cloned := new(K8SRole)
	*cloned = *m

	if m.Labels != nil {
		cloned.Labels = make(map[string]string, len(m.Labels))
		for k, v := range m.Labels {
			cloned.Labels[k] = v
		}
	}
	if m.Annotations != nil {
		cloned.Annotations = make(map[string]string, len(m.Annotations))
		for k, v := range m.Annotations {
			cloned.Annotations[k] = v
		}
	}
	cloned.CreatedAt = m.CreatedAt.Clone()
	if m.Rules != nil {
		cloned.Rules = make([]*PolicyRule, len(m.Rules))
		for idx, v := range m.Rules {
			cloned.Rules[idx] = v.Clone()
		}
	}
	return cloned
}

// Properties of an individual rules that grant permissions to resources.
//////////////////////////////////////////
type PolicyRule struct {
	Verbs                []string `protobuf:"bytes,1,rep,name=verbs,proto3" json:"verbs,omitempty"`
	ApiGroups            []string `protobuf:"bytes,2,rep,name=api_groups,json=apiGroups,proto3" json:"api_groups,omitempty"`
	Resources            []string `protobuf:"bytes,3,rep,name=resources,proto3" json:"resources,omitempty"`
	NonResourceUrls      []string `protobuf:"bytes,4,rep,name=non_resource_urls,json=nonResourceUrls,proto3" json:"non_resource_urls,omitempty"`
	ResourceNames        []string `protobuf:"bytes,5,rep,name=resource_names,json=resourceNames,proto3" json:"resource_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PolicyRule) Reset()         { *m = PolicyRule{} }
func (m *PolicyRule) String() string { return proto.CompactTextString(m) }
func (*PolicyRule) ProtoMessage()    {}
func (*PolicyRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_385316e6bc10731c, []int{1}
}
func (m *PolicyRule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PolicyRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PolicyRule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PolicyRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyRule.Merge(m, src)
}
func (m *PolicyRule) XXX_Size() int {
	return m.Size()
}
func (m *PolicyRule) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyRule.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyRule proto.InternalMessageInfo

func (m *PolicyRule) GetVerbs() []string {
	if m != nil {
		return m.Verbs
	}
	return nil
}

func (m *PolicyRule) GetApiGroups() []string {
	if m != nil {
		return m.ApiGroups
	}
	return nil
}

func (m *PolicyRule) GetResources() []string {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *PolicyRule) GetNonResourceUrls() []string {
	if m != nil {
		return m.NonResourceUrls
	}
	return nil
}

func (m *PolicyRule) GetResourceNames() []string {
	if m != nil {
		return m.ResourceNames
	}
	return nil
}

func (m *PolicyRule) MessageClone() proto.Message {
	return m.Clone()
}
func (m *PolicyRule) Clone() *PolicyRule {
	if m == nil {
		return nil
	}
	cloned := new(PolicyRule)
	*cloned = *m

	if m.Verbs != nil {
		cloned.Verbs = make([]string, len(m.Verbs))
		copy(cloned.Verbs, m.Verbs)
	}
	if m.ApiGroups != nil {
		cloned.ApiGroups = make([]string, len(m.ApiGroups))
		copy(cloned.ApiGroups, m.ApiGroups)
	}
	if m.Resources != nil {
		cloned.Resources = make([]string, len(m.Resources))
		copy(cloned.Resources, m.Resources)
	}
	if m.NonResourceUrls != nil {
		cloned.NonResourceUrls = make([]string, len(m.NonResourceUrls))
		copy(cloned.NonResourceUrls, m.NonResourceUrls)
	}
	if m.ResourceNames != nil {
		cloned.ResourceNames = make([]string, len(m.ResourceNames))
		copy(cloned.ResourceNames, m.ResourceNames)
	}
	return cloned
}

// Properties of an individual k8s RoleBinding or ClusterRoleBinding.
//////////////////////////////////////////
type K8SRoleBinding struct {
	Id          string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" search:"Role Binding ID,hidden"`
	Name        string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty" search:"Role Binding"`
	Namespace   string `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty" search:"Namespace,store"`
	ClusterId   string `protobuf:"bytes,4,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty" search:"Cluster ID,store,hidden"`
	ClusterName string `protobuf:"bytes,5,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty" search:"Cluster"`
	ClusterRole bool   `protobuf:"varint,6,opt,name=cluster_role,json=clusterRole,proto3" json:"cluster_role,omitempty" search:"Cluster Role"`
	// TODO(ROX-6895): "Label" search term is ambiguous.
	Labels               map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" search:"Label" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Annotations          map[string]string `protobuf:"bytes,8,rep,name=annotations,proto3" json:"annotations,omitempty" search:"Annotation" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	CreatedAt            *types.Timestamp  `protobuf:"bytes,9,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	Subjects             []*Subject        `protobuf:"bytes,10,rep,name=subjects,proto3" json:"subjects,omitempty"`
	RoleId               string            `protobuf:"bytes,11,opt,name=role_id,json=roleId,proto3" json:"role_id,omitempty" search:"Role ID"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *K8SRoleBinding) Reset()         { *m = K8SRoleBinding{} }
func (m *K8SRoleBinding) String() string { return proto.CompactTextString(m) }
func (*K8SRoleBinding) ProtoMessage()    {}
func (*K8SRoleBinding) Descriptor() ([]byte, []int) {
	return fileDescriptor_385316e6bc10731c, []int{2}
}
func (m *K8SRoleBinding) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *K8SRoleBinding) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_K8SRoleBinding.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *K8SRoleBinding) XXX_Merge(src proto.Message) {
	xxx_messageInfo_K8SRoleBinding.Merge(m, src)
}
func (m *K8SRoleBinding) XXX_Size() int {
	return m.Size()
}
func (m *K8SRoleBinding) XXX_DiscardUnknown() {
	xxx_messageInfo_K8SRoleBinding.DiscardUnknown(m)
}

var xxx_messageInfo_K8SRoleBinding proto.InternalMessageInfo

func (m *K8SRoleBinding) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *K8SRoleBinding) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *K8SRoleBinding) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *K8SRoleBinding) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *K8SRoleBinding) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *K8SRoleBinding) GetClusterRole() bool {
	if m != nil {
		return m.ClusterRole
	}
	return false
}

func (m *K8SRoleBinding) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *K8SRoleBinding) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *K8SRoleBinding) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *K8SRoleBinding) GetSubjects() []*Subject {
	if m != nil {
		return m.Subjects
	}
	return nil
}

func (m *K8SRoleBinding) GetRoleId() string {
	if m != nil {
		return m.RoleId
	}
	return ""
}

func (m *K8SRoleBinding) MessageClone() proto.Message {
	return m.Clone()
}
func (m *K8SRoleBinding) Clone() *K8SRoleBinding {
	if m == nil {
		return nil
	}
	cloned := new(K8SRoleBinding)
	*cloned = *m

	if m.Labels != nil {
		cloned.Labels = make(map[string]string, len(m.Labels))
		for k, v := range m.Labels {
			cloned.Labels[k] = v
		}
	}
	if m.Annotations != nil {
		cloned.Annotations = make(map[string]string, len(m.Annotations))
		for k, v := range m.Annotations {
			cloned.Annotations[k] = v
		}
	}
	cloned.CreatedAt = m.CreatedAt.Clone()
	if m.Subjects != nil {
		cloned.Subjects = make([]*Subject, len(m.Subjects))
		for idx, v := range m.Subjects {
			cloned.Subjects[idx] = v.Clone()
		}
	}
	return cloned
}

// Properties of an individual subjects who are granted roles via role bindings.
//////////////////////////////////////////
type Subject struct {
	Id                   string      `protobuf:"bytes,4,opt,name=id,proto3" json:"id,omitempty"`
	Kind                 SubjectKind `protobuf:"varint,1,opt,name=kind,proto3,enum=storage.SubjectKind" json:"kind,omitempty" search:"Subject Kind"`
	Name                 string      `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty" search:"Subject"`
	Namespace            string      `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty"`
	ClusterId            string      `protobuf:"bytes,5,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	ClusterName          string      `protobuf:"bytes,6,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *Subject) Reset()         { *m = Subject{} }
func (m *Subject) String() string { return proto.CompactTextString(m) }
func (*Subject) ProtoMessage()    {}
func (*Subject) Descriptor() ([]byte, []int) {
	return fileDescriptor_385316e6bc10731c, []int{3}
}
func (m *Subject) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Subject) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Subject.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Subject) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Subject.Merge(m, src)
}
func (m *Subject) XXX_Size() int {
	return m.Size()
}
func (m *Subject) XXX_DiscardUnknown() {
	xxx_messageInfo_Subject.DiscardUnknown(m)
}

var xxx_messageInfo_Subject proto.InternalMessageInfo

func (m *Subject) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Subject) GetKind() SubjectKind {
	if m != nil {
		return m.Kind
	}
	return SubjectKind_UNSET_KIND
}

func (m *Subject) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Subject) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *Subject) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *Subject) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *Subject) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Subject) Clone() *Subject {
	if m == nil {
		return nil
	}
	cloned := new(Subject)
	*cloned = *m

	return cloned
}

func init() {
	proto.RegisterEnum("storage.SubjectKind", SubjectKind_name, SubjectKind_value)
	proto.RegisterEnum("storage.PermissionLevel", PermissionLevel_name, PermissionLevel_value)
	proto.RegisterType((*K8SRole)(nil), "storage.K8sRole")
	proto.RegisterMapType((map[string]string)(nil), "storage.K8sRole.AnnotationsEntry")
	proto.RegisterMapType((map[string]string)(nil), "storage.K8sRole.LabelsEntry")
	proto.RegisterType((*PolicyRule)(nil), "storage.PolicyRule")
	proto.RegisterType((*K8SRoleBinding)(nil), "storage.K8sRoleBinding")
	proto.RegisterMapType((map[string]string)(nil), "storage.K8sRoleBinding.AnnotationsEntry")
	proto.RegisterMapType((map[string]string)(nil), "storage.K8sRoleBinding.LabelsEntry")
	proto.RegisterType((*Subject)(nil), "storage.Subject")
}

func init() { proto.RegisterFile("storage/rbac.proto", fileDescriptor_385316e6bc10731c) }

var fileDescriptor_385316e6bc10731c = []byte{
	// 935 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x96, 0xcd, 0x6e, 0xe3, 0x54,
	0x14, 0xc7, 0xeb, 0x7c, 0x36, 0x27, 0x34, 0x75, 0x6f, 0x3b, 0x1a, 0xb7, 0x74, 0xe2, 0x8c, 0x87,
	0x91, 0x42, 0xe9, 0xa4, 0x52, 0x67, 0x41, 0xa7, 0x42, 0x48, 0xf9, 0x30, 0x25, 0x6a, 0xc6, 0xad,
	0x6e, 0x92, 0x41, 0x42, 0x48, 0x96, 0x63, 0x5f, 0x32, 0xa6, 0xae, 0x6f, 0xe4, 0x6b, 0x8f, 0xa8,
	0xc4, 0x83, 0xf0, 0x08, 0xac, 0x91, 0x78, 0x07, 0x96, 0x3c, 0x81, 0x85, 0xca, 0x86, 0xb5, 0x9f,
	0x00, 0xf9, 0xda, 0xce, 0x57, 0x41, 0x82, 0x0d, 0x2c, 0x58, 0xc5, 0x3e, 0xff, 0xff, 0x39, 0x39,
	0xf7, 0x9e, 0xf3, 0x53, 0x02, 0x88, 0xf9, 0xd4, 0x33, 0xa6, 0xe4, 0xc4, 0x9b, 0x18, 0x66, 0x6b,
	0xe6, 0x51, 0x9f, 0xa2, 0x72, 0x1a, 0x3b, 0x90, 0xa7, 0x94, 0x4e, 0x1d, 0x72, 0xc2, 0xc3, 0x93,
	0xe0, 0xeb, 0x13, 0xdf, 0xbe, 0x25, 0xcc, 0x37, 0x6e, 0x67, 0x89, 0xf3, 0x60, 0x6f, 0x4a, 0xa7,
	0x94, 0x3f, 0x9e, 0xc4, 0x4f, 0x49, 0x54, 0x09, 0x8b, 0x50, 0xbe, 0x3c, 0x63, 0x98, 0x3a, 0x04,
	0x7d, 0x04, 0x39, 0xdb, 0x92, 0x84, 0x86, 0xd0, 0xac, 0x74, 0xde, 0x8f, 0x42, 0xf9, 0x31, 0x23,
	0x86, 0x67, 0xbe, 0x3d, 0x57, 0x62, 0xb5, 0xd1, 0xef, 0x1d, 0xbf, 0xb5, 0x2d, 0x8b, 0xb8, 0x0a,
	0xce, 0xd9, 0x16, 0x7a, 0x0e, 0x05, 0xd7, 0xb8, 0x25, 0x52, 0x8e, 0xdb, 0x77, 0xa2, 0x50, 0xde,
	0x5a, 0xb6, 0x2b, 0x98, 0xcb, 0xe8, 0x1c, 0x2a, 0xf1, 0x27, 0x9b, 0x19, 0x26, 0x91, 0xf2, 0xdc,
	0x7b, 0x18, 0x85, 0xb2, 0x94, 0x79, 0xb5, 0x4c, 0x3c, 0x8e, 0x0f, 0x42, 0x14, 0xbc, 0xb0, 0xa3,
	0x2e, 0x80, 0xe9, 0x04, 0xcc, 0x27, 0x9e, 0x6e, 0x5b, 0x52, 0x81, 0x27, 0x7f, 0x10, 0x85, 0x72,
	0x23, 0x4b, 0xee, 0x26, 0x6a, 0xdc, 0x1a, 0xcf, 0x9e, 0x37, 0x58, 0x49, 0xf3, 0xfa, 0x16, 0xfa,
	0x18, 0xde, 0xcb, 0x8a, 0xf0, 0x7e, 0x8b, 0xbc, 0xcc, 0x5e, 0x14, 0xca, 0xe2, 0x5a, 0x19, 0x05,
	0x57, 0x53, 0x67, 0xdc, 0x14, 0xfa, 0x64, 0x91, 0xe8, 0x51, 0x87, 0x48, 0xa5, 0x86, 0xd0, 0xdc,
	0xec, 0xec, 0x47, 0xa1, 0xfc, 0x68, 0xfd, 0xfb, 0x93, 0x03, 0x67, 0xd9, 0xfc, 0x2e, 0x3f, 0x87,
	0x92, 0x63, 0x4c, 0x88, 0xc3, 0xa4, 0x72, 0x23, 0xdf, 0xac, 0x9e, 0x1e, 0xb6, 0xd2, 0x41, 0xb5,
	0xd2, 0xdb, 0x6e, 0x0d, 0xb8, 0xac, 0xba, 0xbe, 0x77, 0xd7, 0x41, 0x51, 0x28, 0xd7, 0xb2, 0xaa,
	0x5c, 0x50, 0x70, 0x9a, 0x8f, 0xbe, 0x82, 0xaa, 0xe1, 0xba, 0xd4, 0x37, 0x7c, 0x9b, 0xba, 0x4c,
	0xda, 0xe4, 0xe5, 0x9e, 0x3e, 0x28, 0xd7, 0x5e, 0x78, 0x92, 0x9a, 0x8f, 0xa3, 0x50, 0xde, 0xcd,
	0x6a, 0x2e, 0x54, 0x05, 0x2f, 0x97, 0x43, 0xaf, 0x00, 0x4c, 0x8f, 0x18, 0x3e, 0xb1, 0x74, 0xc3,
	0x97, 0x2a, 0x0d, 0xa1, 0x59, 0x3d, 0x3d, 0x68, 0x25, 0xbb, 0xd4, 0xca, 0x76, 0xa9, 0x35, 0xca,
	0x76, 0x09, 0x57, 0x52, 0x77, 0xdb, 0x47, 0x1f, 0x42, 0xd1, 0x0b, 0x1c, 0xc2, 0x24, 0xe0, 0x2d,
	0xed, 0xce, 0x5b, 0xba, 0xa6, 0x8e, 0x6d, 0xde, 0xe1, 0xc0, 0x21, 0x38, 0x71, 0x1c, 0xbc, 0x82,
	0xea, 0xd2, 0x71, 0x91, 0x08, 0xf9, 0x1b, 0x72, 0x97, 0x6c, 0x1a, 0x8e, 0x1f, 0xd1, 0x1e, 0x14,
	0xdf, 0x19, 0x4e, 0x90, 0xae, 0x13, 0x4e, 0x5e, 0xce, 0x73, 0x67, 0xc2, 0xc1, 0xa7, 0x20, 0xae,
	0x1f, 0xed, 0x9f, 0xe4, 0x2b, 0x3f, 0x0a, 0x00, 0x8b, 0x86, 0xb8, 0x91, 0x78, 0x13, 0x26, 0x09,
	0x8d, 0x3c, 0x37, 0xc6, 0x2f, 0xe8, 0x09, 0x80, 0x31, 0xb3, 0xf5, 0xa9, 0x47, 0x83, 0x19, 0x93,
	0x72, 0x5c, 0xaa, 0x18, 0x33, 0xfb, 0x82, 0x07, 0xd0, 0x21, 0x54, 0x3c, 0xc2, 0x68, 0xe0, 0x99,
	0x84, 0x49, 0xf9, 0x44, 0x9d, 0x07, 0xd0, 0x11, 0xec, 0xb8, 0xd4, 0xd5, 0xb3, 0x80, 0x1e, 0x78,
	0x0e, 0x93, 0x0a, 0xdc, 0xb5, 0xed, 0x52, 0x17, 0xa7, 0xf1, 0xb1, 0xe7, 0x30, 0xf4, 0x1c, 0x6a,
	0x73, 0x1f, 0x5f, 0x74, 0xa9, 0xc8, 0x8d, 0x5b, 0x59, 0x94, 0xf3, 0xa0, 0xfc, 0x54, 0x82, 0x5a,
	0x3a, 0xd8, 0x8e, 0xed, 0x5a, 0xb6, 0x3b, 0x45, 0x2f, 0x97, 0xe0, 0x7c, 0x16, 0x85, 0xb2, 0xbc,
	0x02, 0x67, 0xea, 0x5a, 0x87, 0xf4, 0xc5, 0x0a, 0xa4, 0x2b, 0xbb, 0xbb, 0x9c, 0xf6, 0x7f, 0x87,
	0xf5, 0x6a, 0x0d, 0xd6, 0x67, 0xeb, 0x74, 0xa5, 0xf7, 0xf4, 0xb7, 0x99, 0x35, 0xff, 0x8c, 0xd9,
	0xe6, 0x5f, 0x55, 0xfd, 0xf7, 0xd1, 0x3d, 0x86, 0x4d, 0x16, 0x4c, 0xbe, 0x21, 0xa6, 0x9f, 0xd1,
	0x2b, 0xce, 0x9b, 0x1b, 0x26, 0x02, 0x9e, 0x3b, 0xd0, 0x0b, 0x28, 0xc7, 0x97, 0x1a, 0xcf, 0xb5,
	0xfa, 0x70, 0x20, 0xe9, 0x8f, 0x83, 0x82, 0x4b, 0xb1, 0xa9, 0x6f, 0xfd, 0x97, 0xb0, 0xff, 0x2e,
	0x40, 0x39, 0xed, 0x1f, 0xd5, 0x38, 0x30, 0x7c, 0x11, 0x39, 0x0b, 0x5d, 0x28, 0xdc, 0xd8, 0x6e,
	0x82, 0x50, 0xed, 0x74, 0x6f, 0xfd, 0xbc, 0x97, 0xb6, 0x6b, 0xad, 0x2e, 0x4c, 0x2a, 0x34, 0x62,
	0x45, 0xc1, 0x3c, 0x19, 0x35, 0x57, 0x80, 0x5a, 0xb9, 0x87, 0xd4, 0x9e, 0xb1, 0x74, 0xf8, 0x80,
	0xa5, 0x65, 0x5a, 0x9e, 0xac, 0xd0, 0x52, 0x4c, 0xe4, 0x05, 0x07, 0x4f, 0xd7, 0x38, 0x28, 0x71,
	0xc3, 0xf2, 0xc6, 0x1f, 0x5d, 0x40, 0x75, 0xa9, 0x73, 0x54, 0x03, 0x18, 0x6b, 0x43, 0x75, 0xa4,
	0x5f, 0xf6, 0xb5, 0x9e, 0xb8, 0x81, 0x76, 0x61, 0x7b, 0xa8, 0xe2, 0x37, 0xfd, 0xae, 0xaa, 0xb7,
	0xbb, 0xdd, 0xab, 0xb1, 0x36, 0x12, 0x05, 0xb4, 0x09, 0x85, 0xf1, 0x50, 0xc5, 0x62, 0x0e, 0x55,
	0xa0, 0x78, 0x81, 0xaf, 0xc6, 0xd7, 0x62, 0xfe, 0xe8, 0x3b, 0xd8, 0xbe, 0x26, 0xde, 0xad, 0xcd,
	0x98, 0x4d, 0xdd, 0x01, 0x79, 0x47, 0x9c, 0x58, 0xe5, 0xc5, 0xc4, 0x8d, 0x38, 0x45, 0xbb, 0xd2,
	0x54, 0x51, 0x40, 0x55, 0x28, 0xf7, 0xd4, 0xcf, 0xda, 0xe3, 0xc1, 0x48, 0xcc, 0xa1, 0x7d, 0x78,
	0xa4, 0x0e, 0xd4, 0x37, 0xed, 0x91, 0xda, 0xd3, 0xfb, 0x9a, 0xae, 0xb5, 0x5f, 0xab, 0xc3, 0xeb,
	0x76, 0x57, 0x15, 0xf3, 0x2b, 0x52, 0x77, 0x30, 0x1e, 0x8e, 0x54, 0xac, 0x7f, 0xd1, 0xef, 0xa9,
	0x62, 0x01, 0xed, 0xc0, 0x56, 0x16, 0x69, 0xf7, 0x5e, 0xf7, 0x35, 0xb1, 0xd8, 0x39, 0xfb, 0xe1,
	0xbe, 0x2e, 0xfc, 0x7c, 0x5f, 0x17, 0x7e, 0xb9, 0xaf, 0x0b, 0xbf, 0xde, 0xd7, 0x85, 0xef, 0x7f,
	0xab, 0x6f, 0xc0, 0xbe, 0x4d, 0x5b, 0xcc, 0x37, 0xcc, 0x1b, 0x8f, 0x7e, 0x9b, 0xac, 0x72, 0x36,
	0xae, 0x2f, 0xb3, 0x3f, 0x3c, 0x93, 0x12, 0x8f, 0xbf, 0xfc, 0x23, 0x00, 0x00, 0xff, 0xff, 0x6f,
	0x45, 0xed, 0xf3, 0x16, 0x09, 0x00, 0x00,
}

func (this *K8SRole) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*K8SRole)
	if !ok {
		that2, ok := that.(K8SRole)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if this.ClusterId != that1.ClusterId {
		return false
	}
	if this.ClusterName != that1.ClusterName {
		return false
	}
	if this.ClusterRole != that1.ClusterRole {
		return false
	}
	if len(this.Labels) != len(that1.Labels) {
		return false
	}
	for i := range this.Labels {
		if this.Labels[i] != that1.Labels[i] {
			return false
		}
	}
	if len(this.Annotations) != len(that1.Annotations) {
		return false
	}
	for i := range this.Annotations {
		if this.Annotations[i] != that1.Annotations[i] {
			return false
		}
	}
	if !this.CreatedAt.Equal(that1.CreatedAt) {
		return false
	}
	if len(this.Rules) != len(that1.Rules) {
		return false
	}
	for i := range this.Rules {
		if !this.Rules[i].Equal(that1.Rules[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *PolicyRule) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PolicyRule)
	if !ok {
		that2, ok := that.(PolicyRule)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Verbs) != len(that1.Verbs) {
		return false
	}
	for i := range this.Verbs {
		if this.Verbs[i] != that1.Verbs[i] {
			return false
		}
	}
	if len(this.ApiGroups) != len(that1.ApiGroups) {
		return false
	}
	for i := range this.ApiGroups {
		if this.ApiGroups[i] != that1.ApiGroups[i] {
			return false
		}
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if this.Resources[i] != that1.Resources[i] {
			return false
		}
	}
	if len(this.NonResourceUrls) != len(that1.NonResourceUrls) {
		return false
	}
	for i := range this.NonResourceUrls {
		if this.NonResourceUrls[i] != that1.NonResourceUrls[i] {
			return false
		}
	}
	if len(this.ResourceNames) != len(that1.ResourceNames) {
		return false
	}
	for i := range this.ResourceNames {
		if this.ResourceNames[i] != that1.ResourceNames[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *K8SRoleBinding) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*K8SRoleBinding)
	if !ok {
		that2, ok := that.(K8SRoleBinding)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if this.ClusterId != that1.ClusterId {
		return false
	}
	if this.ClusterName != that1.ClusterName {
		return false
	}
	if this.ClusterRole != that1.ClusterRole {
		return false
	}
	if len(this.Labels) != len(that1.Labels) {
		return false
	}
	for i := range this.Labels {
		if this.Labels[i] != that1.Labels[i] {
			return false
		}
	}
	if len(this.Annotations) != len(that1.Annotations) {
		return false
	}
	for i := range this.Annotations {
		if this.Annotations[i] != that1.Annotations[i] {
			return false
		}
	}
	if !this.CreatedAt.Equal(that1.CreatedAt) {
		return false
	}
	if len(this.Subjects) != len(that1.Subjects) {
		return false
	}
	for i := range this.Subjects {
		if !this.Subjects[i].Equal(that1.Subjects[i]) {
			return false
		}
	}
	if this.RoleId != that1.RoleId {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Subject) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Subject)
	if !ok {
		that2, ok := that.(Subject)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if this.Kind != that1.Kind {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if this.ClusterId != that1.ClusterId {
		return false
	}
	if this.ClusterName != that1.ClusterName {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (m *K8SRole) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *K8SRole) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *K8SRole) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Rules) > 0 {
		for iNdEx := len(m.Rules) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Rules[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRbac(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x52
		}
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRbac(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if len(m.Annotations) > 0 {
		for k := range m.Annotations {
			v := m.Annotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintRbac(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRbac(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRbac(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintRbac(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRbac(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRbac(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.ClusterRole {
		i--
		if m.ClusterRole {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintRbac(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintRbac(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRbac(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintRbac(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintRbac(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PolicyRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PolicyRule) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PolicyRule) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ResourceNames) > 0 {
		for iNdEx := len(m.ResourceNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ResourceNames[iNdEx])
			copy(dAtA[i:], m.ResourceNames[iNdEx])
			i = encodeVarintRbac(dAtA, i, uint64(len(m.ResourceNames[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.NonResourceUrls) > 0 {
		for iNdEx := len(m.NonResourceUrls) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.NonResourceUrls[iNdEx])
			copy(dAtA[i:], m.NonResourceUrls[iNdEx])
			i = encodeVarintRbac(dAtA, i, uint64(len(m.NonResourceUrls[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Resources) > 0 {
		for iNdEx := len(m.Resources) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Resources[iNdEx])
			copy(dAtA[i:], m.Resources[iNdEx])
			i = encodeVarintRbac(dAtA, i, uint64(len(m.Resources[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.ApiGroups) > 0 {
		for iNdEx := len(m.ApiGroups) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ApiGroups[iNdEx])
			copy(dAtA[i:], m.ApiGroups[iNdEx])
			i = encodeVarintRbac(dAtA, i, uint64(len(m.ApiGroups[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Verbs) > 0 {
		for iNdEx := len(m.Verbs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Verbs[iNdEx])
			copy(dAtA[i:], m.Verbs[iNdEx])
			i = encodeVarintRbac(dAtA, i, uint64(len(m.Verbs[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *K8SRoleBinding) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *K8SRoleBinding) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *K8SRoleBinding) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.RoleId) > 0 {
		i -= len(m.RoleId)
		copy(dAtA[i:], m.RoleId)
		i = encodeVarintRbac(dAtA, i, uint64(len(m.RoleId)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.Subjects) > 0 {
		for iNdEx := len(m.Subjects) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Subjects[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRbac(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x52
		}
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRbac(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if len(m.Annotations) > 0 {
		for k := range m.Annotations {
			v := m.Annotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintRbac(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRbac(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRbac(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintRbac(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRbac(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRbac(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.ClusterRole {
		i--
		if m.ClusterRole {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintRbac(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintRbac(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRbac(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintRbac(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintRbac(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Subject) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Subject) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Subject) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintRbac(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintRbac(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintRbac(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRbac(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintRbac(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if m.Kind != 0 {
		i = encodeVarintRbac(dAtA, i, uint64(m.Kind))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintRbac(dAtA []byte, offset int, v uint64) int {
	offset -= sovRbac(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *K8SRole) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovRbac(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRbac(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRbac(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovRbac(uint64(l))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovRbac(uint64(l))
	}
	if m.ClusterRole {
		n += 2
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRbac(uint64(len(k))) + 1 + len(v) + sovRbac(uint64(len(v)))
			n += mapEntrySize + 1 + sovRbac(uint64(mapEntrySize))
		}
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRbac(uint64(len(k))) + 1 + len(v) + sovRbac(uint64(len(v)))
			n += mapEntrySize + 1 + sovRbac(uint64(mapEntrySize))
		}
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovRbac(uint64(l))
	}
	if len(m.Rules) > 0 {
		for _, e := range m.Rules {
			l = e.Size()
			n += 1 + l + sovRbac(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PolicyRule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Verbs) > 0 {
		for _, s := range m.Verbs {
			l = len(s)
			n += 1 + l + sovRbac(uint64(l))
		}
	}
	if len(m.ApiGroups) > 0 {
		for _, s := range m.ApiGroups {
			l = len(s)
			n += 1 + l + sovRbac(uint64(l))
		}
	}
	if len(m.Resources) > 0 {
		for _, s := range m.Resources {
			l = len(s)
			n += 1 + l + sovRbac(uint64(l))
		}
	}
	if len(m.NonResourceUrls) > 0 {
		for _, s := range m.NonResourceUrls {
			l = len(s)
			n += 1 + l + sovRbac(uint64(l))
		}
	}
	if len(m.ResourceNames) > 0 {
		for _, s := range m.ResourceNames {
			l = len(s)
			n += 1 + l + sovRbac(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *K8SRoleBinding) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovRbac(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRbac(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRbac(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovRbac(uint64(l))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovRbac(uint64(l))
	}
	if m.ClusterRole {
		n += 2
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRbac(uint64(len(k))) + 1 + len(v) + sovRbac(uint64(len(v)))
			n += mapEntrySize + 1 + sovRbac(uint64(mapEntrySize))
		}
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRbac(uint64(len(k))) + 1 + len(v) + sovRbac(uint64(len(v)))
			n += mapEntrySize + 1 + sovRbac(uint64(mapEntrySize))
		}
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovRbac(uint64(l))
	}
	if len(m.Subjects) > 0 {
		for _, e := range m.Subjects {
			l = e.Size()
			n += 1 + l + sovRbac(uint64(l))
		}
	}
	l = len(m.RoleId)
	if l > 0 {
		n += 1 + l + sovRbac(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Subject) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Kind != 0 {
		n += 1 + sovRbac(uint64(m.Kind))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRbac(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRbac(uint64(l))
	}
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovRbac(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovRbac(uint64(l))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovRbac(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovRbac(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozRbac(x uint64) (n int) {
	return sovRbac(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *K8SRole) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRbac
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: K8sRole: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: K8sRole: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterRole", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ClusterRole = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRbac
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRbac
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRbac
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRbac
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRbac
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthRbac
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthRbac
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRbac(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthRbac
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Annotations == nil {
				m.Annotations = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRbac
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRbac
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRbac
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRbac
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRbac
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthRbac
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthRbac
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRbac(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthRbac
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Annotations[mapkey] = mapvalue
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rules = append(m.Rules, &PolicyRule{})
			if err := m.Rules[len(m.Rules)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRbac(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRbac
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PolicyRule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRbac
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PolicyRule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PolicyRule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Verbs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Verbs = append(m.Verbs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiGroups", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiGroups = append(m.ApiGroups, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NonResourceUrls", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NonResourceUrls = append(m.NonResourceUrls, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceNames = append(m.ResourceNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRbac(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRbac
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *K8SRoleBinding) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRbac
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: K8sRoleBinding: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: K8sRoleBinding: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterRole", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ClusterRole = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRbac
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRbac
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRbac
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRbac
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRbac
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthRbac
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthRbac
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRbac(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthRbac
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Annotations == nil {
				m.Annotations = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRbac
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRbac
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRbac
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRbac
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRbac
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthRbac
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthRbac
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRbac(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthRbac
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Annotations[mapkey] = mapvalue
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subjects", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subjects = append(m.Subjects, &Subject{})
			if err := m.Subjects[len(m.Subjects)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RoleId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RoleId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRbac(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRbac
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Subject) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRbac
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Subject: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Subject: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			m.Kind = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Kind |= SubjectKind(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbac
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRbac(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRbac
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRbac(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRbac
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRbac
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupRbac
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthRbac
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthRbac        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRbac          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupRbac = fmt.Errorf("proto: unexpected end of group")
)
