// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/report_configuration.proto

package storage

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ReportConfiguration_ReportType int32

const (
	ReportConfiguration_VULNERABILITY ReportConfiguration_ReportType = 0
)

var ReportConfiguration_ReportType_name = map[int32]string{
	0: "VULNERABILITY",
}

var ReportConfiguration_ReportType_value = map[string]int32{
	"VULNERABILITY": 0,
}

func (x ReportConfiguration_ReportType) String() string {
	return proto.EnumName(ReportConfiguration_ReportType_name, int32(x))
}

func (ReportConfiguration_ReportType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_541201f82fe9caab, []int{0, 0}
}

type ReportLastRunStatus_RunStatus int32

const (
	ReportLastRunStatus_SUCCESS ReportLastRunStatus_RunStatus = 0
	ReportLastRunStatus_FAILURE ReportLastRunStatus_RunStatus = 1
)

var ReportLastRunStatus_RunStatus_name = map[int32]string{
	0: "SUCCESS",
	1: "FAILURE",
}

var ReportLastRunStatus_RunStatus_value = map[string]int32{
	"SUCCESS": 0,
	"FAILURE": 1,
}

func (x ReportLastRunStatus_RunStatus) String() string {
	return proto.EnumName(ReportLastRunStatus_RunStatus_name, int32(x))
}

func (ReportLastRunStatus_RunStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_541201f82fe9caab, []int{1, 0}
}

type VulnerabilityReportFilters_Fixability int32

const (
	VulnerabilityReportFilters_BOTH        VulnerabilityReportFilters_Fixability = 0
	VulnerabilityReportFilters_FIXABLE     VulnerabilityReportFilters_Fixability = 1
	VulnerabilityReportFilters_NOT_FIXABLE VulnerabilityReportFilters_Fixability = 2
)

var VulnerabilityReportFilters_Fixability_name = map[int32]string{
	0: "BOTH",
	1: "FIXABLE",
	2: "NOT_FIXABLE",
}

var VulnerabilityReportFilters_Fixability_value = map[string]int32{
	"BOTH":        0,
	"FIXABLE":     1,
	"NOT_FIXABLE": 2,
}

func (x VulnerabilityReportFilters_Fixability) String() string {
	return proto.EnumName(VulnerabilityReportFilters_Fixability_name, int32(x))
}

func (VulnerabilityReportFilters_Fixability) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_541201f82fe9caab, []int{2, 0}
}

type ReportConfiguration struct {
	Id          string                         `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Name        string                         `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty" search:"Report Name"`
	Description string                         `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	Type        ReportConfiguration_ReportType `protobuf:"varint,4,opt,name=type,proto3,enum=storage.ReportConfiguration_ReportType" json:"type,omitempty" search:"Report Type"`
	// Types that are valid to be assigned to Filter:
	//	*ReportConfiguration_VulnReportFilters
	Filter  isReportConfiguration_Filter `protobuf_oneof:"filter"`
	ScopeId string                       `protobuf:"bytes,6,opt,name=scope_id,json=scopeId,proto3" json:"scope_id,omitempty"`
	// Types that are valid to be assigned to NotifierConfig:
	//	*ReportConfiguration_EmailConfig
	NotifierConfig        isReportConfiguration_NotifierConfig `protobuf_oneof:"notifier_config"`
	Schedule              *Schedule                            `protobuf:"bytes,8,opt,name=schedule,proto3" json:"schedule,omitempty"`
	LastRunStatus         *ReportLastRunStatus                 `protobuf:"bytes,9,opt,name=last_run_status,json=lastRunStatus,proto3" json:"last_run_status,omitempty"`
	LastSuccessfulRunTime *types.Timestamp                     `protobuf:"bytes,10,opt,name=last_successful_run_time,json=lastSuccessfulRunTime,proto3" json:"last_successful_run_time,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}                             `json:"-"`
	XXX_unrecognized      []byte                               `json:"-"`
	XXX_sizecache         int32                                `json:"-"`
}

func (m *ReportConfiguration) Reset()         { *m = ReportConfiguration{} }
func (m *ReportConfiguration) String() string { return proto.CompactTextString(m) }
func (*ReportConfiguration) ProtoMessage()    {}
func (*ReportConfiguration) Descriptor() ([]byte, []int) {
	return fileDescriptor_541201f82fe9caab, []int{0}
}
func (m *ReportConfiguration) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReportConfiguration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReportConfiguration.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReportConfiguration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportConfiguration.Merge(m, src)
}
func (m *ReportConfiguration) XXX_Size() int {
	return m.Size()
}
func (m *ReportConfiguration) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportConfiguration.DiscardUnknown(m)
}

var xxx_messageInfo_ReportConfiguration proto.InternalMessageInfo

type isReportConfiguration_Filter interface {
	isReportConfiguration_Filter()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isReportConfiguration_Filter
}
type isReportConfiguration_NotifierConfig interface {
	isReportConfiguration_NotifierConfig()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isReportConfiguration_NotifierConfig
}

type ReportConfiguration_VulnReportFilters struct {
	VulnReportFilters *VulnerabilityReportFilters `protobuf:"bytes,5,opt,name=vuln_report_filters,json=vulnReportFilters,proto3,oneof" json:"vuln_report_filters,omitempty"`
}
type ReportConfiguration_EmailConfig struct {
	EmailConfig *EmailNotifierConfiguration `protobuf:"bytes,7,opt,name=email_config,json=emailConfig,proto3,oneof" json:"email_config,omitempty"`
}

func (*ReportConfiguration_VulnReportFilters) isReportConfiguration_Filter() {}
func (m *ReportConfiguration_VulnReportFilters) Clone() isReportConfiguration_Filter {
	if m == nil {
		return nil
	}
	cloned := new(ReportConfiguration_VulnReportFilters)
	*cloned = *m

	cloned.VulnReportFilters = m.VulnReportFilters.Clone()
	return cloned
}
func (*ReportConfiguration_EmailConfig) isReportConfiguration_NotifierConfig() {}
func (m *ReportConfiguration_EmailConfig) Clone() isReportConfiguration_NotifierConfig {
	if m == nil {
		return nil
	}
	cloned := new(ReportConfiguration_EmailConfig)
	*cloned = *m

	cloned.EmailConfig = m.EmailConfig.Clone()
	return cloned
}

func (m *ReportConfiguration) GetFilter() isReportConfiguration_Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}
func (m *ReportConfiguration) GetNotifierConfig() isReportConfiguration_NotifierConfig {
	if m != nil {
		return m.NotifierConfig
	}
	return nil
}

func (m *ReportConfiguration) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ReportConfiguration) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ReportConfiguration) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ReportConfiguration) GetType() ReportConfiguration_ReportType {
	if m != nil {
		return m.Type
	}
	return ReportConfiguration_VULNERABILITY
}

func (m *ReportConfiguration) GetVulnReportFilters() *VulnerabilityReportFilters {
	if x, ok := m.GetFilter().(*ReportConfiguration_VulnReportFilters); ok {
		return x.VulnReportFilters
	}
	return nil
}

func (m *ReportConfiguration) GetScopeId() string {
	if m != nil {
		return m.ScopeId
	}
	return ""
}

func (m *ReportConfiguration) GetEmailConfig() *EmailNotifierConfiguration {
	if x, ok := m.GetNotifierConfig().(*ReportConfiguration_EmailConfig); ok {
		return x.EmailConfig
	}
	return nil
}

func (m *ReportConfiguration) GetSchedule() *Schedule {
	if m != nil {
		return m.Schedule
	}
	return nil
}

func (m *ReportConfiguration) GetLastRunStatus() *ReportLastRunStatus {
	if m != nil {
		return m.LastRunStatus
	}
	return nil
}

func (m *ReportConfiguration) GetLastSuccessfulRunTime() *types.Timestamp {
	if m != nil {
		return m.LastSuccessfulRunTime
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ReportConfiguration) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ReportConfiguration_VulnReportFilters)(nil),
		(*ReportConfiguration_EmailConfig)(nil),
	}
}

func (m *ReportConfiguration) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ReportConfiguration) Clone() *ReportConfiguration {
	if m == nil {
		return nil
	}
	cloned := new(ReportConfiguration)
	*cloned = *m

	if m.Filter != nil {
		cloned.Filter = m.Filter.Clone()
	}
	if m.NotifierConfig != nil {
		cloned.NotifierConfig = m.NotifierConfig.Clone()
	}
	cloned.Schedule = m.Schedule.Clone()
	cloned.LastRunStatus = m.LastRunStatus.Clone()
	cloned.LastSuccessfulRunTime = m.LastSuccessfulRunTime.Clone()
	return cloned
}

type ReportLastRunStatus struct {
	ReportStatus         ReportLastRunStatus_RunStatus `protobuf:"varint,1,opt,name=report_status,json=reportStatus,proto3,enum=storage.ReportLastRunStatus_RunStatus" json:"report_status,omitempty"`
	LastRunTime          *types.Timestamp              `protobuf:"bytes,2,opt,name=last_run_time,json=lastRunTime,proto3" json:"last_run_time,omitempty"`
	ErrorMsg             string                        `protobuf:"bytes,3,opt,name=error_msg,json=errorMsg,proto3" json:"error_msg,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *ReportLastRunStatus) Reset()         { *m = ReportLastRunStatus{} }
func (m *ReportLastRunStatus) String() string { return proto.CompactTextString(m) }
func (*ReportLastRunStatus) ProtoMessage()    {}
func (*ReportLastRunStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_541201f82fe9caab, []int{1}
}
func (m *ReportLastRunStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReportLastRunStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReportLastRunStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReportLastRunStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportLastRunStatus.Merge(m, src)
}
func (m *ReportLastRunStatus) XXX_Size() int {
	return m.Size()
}
func (m *ReportLastRunStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportLastRunStatus.DiscardUnknown(m)
}

var xxx_messageInfo_ReportLastRunStatus proto.InternalMessageInfo

func (m *ReportLastRunStatus) GetReportStatus() ReportLastRunStatus_RunStatus {
	if m != nil {
		return m.ReportStatus
	}
	return ReportLastRunStatus_SUCCESS
}

func (m *ReportLastRunStatus) GetLastRunTime() *types.Timestamp {
	if m != nil {
		return m.LastRunTime
	}
	return nil
}

func (m *ReportLastRunStatus) GetErrorMsg() string {
	if m != nil {
		return m.ErrorMsg
	}
	return ""
}

func (m *ReportLastRunStatus) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ReportLastRunStatus) Clone() *ReportLastRunStatus {
	if m == nil {
		return nil
	}
	cloned := new(ReportLastRunStatus)
	*cloned = *m

	cloned.LastRunTime = m.LastRunTime.Clone()
	return cloned
}

type VulnerabilityReportFilters struct {
	Fixability           VulnerabilityReportFilters_Fixability `protobuf:"varint,1,opt,name=fixability,proto3,enum=storage.VulnerabilityReportFilters_Fixability" json:"fixability,omitempty"`
	SinceLastReport      bool                                  `protobuf:"varint,2,opt,name=since_last_report,json=sinceLastReport,proto3" json:"since_last_report,omitempty"`
	Severities           []VulnerabilitySeverity               `protobuf:"varint,3,rep,packed,name=severities,proto3,enum=storage.VulnerabilitySeverity" json:"severities,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *VulnerabilityReportFilters) Reset()         { *m = VulnerabilityReportFilters{} }
func (m *VulnerabilityReportFilters) String() string { return proto.CompactTextString(m) }
func (*VulnerabilityReportFilters) ProtoMessage()    {}
func (*VulnerabilityReportFilters) Descriptor() ([]byte, []int) {
	return fileDescriptor_541201f82fe9caab, []int{2}
}
func (m *VulnerabilityReportFilters) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VulnerabilityReportFilters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VulnerabilityReportFilters.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VulnerabilityReportFilters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnerabilityReportFilters.Merge(m, src)
}
func (m *VulnerabilityReportFilters) XXX_Size() int {
	return m.Size()
}
func (m *VulnerabilityReportFilters) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnerabilityReportFilters.DiscardUnknown(m)
}

var xxx_messageInfo_VulnerabilityReportFilters proto.InternalMessageInfo

func (m *VulnerabilityReportFilters) GetFixability() VulnerabilityReportFilters_Fixability {
	if m != nil {
		return m.Fixability
	}
	return VulnerabilityReportFilters_BOTH
}

func (m *VulnerabilityReportFilters) GetSinceLastReport() bool {
	if m != nil {
		return m.SinceLastReport
	}
	return false
}

func (m *VulnerabilityReportFilters) GetSeverities() []VulnerabilitySeverity {
	if m != nil {
		return m.Severities
	}
	return nil
}

func (m *VulnerabilityReportFilters) MessageClone() proto.Message {
	return m.Clone()
}
func (m *VulnerabilityReportFilters) Clone() *VulnerabilityReportFilters {
	if m == nil {
		return nil
	}
	cloned := new(VulnerabilityReportFilters)
	*cloned = *m

	if m.Severities != nil {
		cloned.Severities = make([]VulnerabilitySeverity, len(m.Severities))
		copy(cloned.Severities, m.Severities)
	}
	return cloned
}

type EmailNotifierConfiguration struct {
	NotifierId           string   `protobuf:"bytes,1,opt,name=notifier_id,json=notifierId,proto3" json:"notifier_id,omitempty"`
	MailingLists         []string `protobuf:"bytes,2,rep,name=mailing_lists,json=mailingLists,proto3" json:"mailing_lists,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EmailNotifierConfiguration) Reset()         { *m = EmailNotifierConfiguration{} }
func (m *EmailNotifierConfiguration) String() string { return proto.CompactTextString(m) }
func (*EmailNotifierConfiguration) ProtoMessage()    {}
func (*EmailNotifierConfiguration) Descriptor() ([]byte, []int) {
	return fileDescriptor_541201f82fe9caab, []int{3}
}
func (m *EmailNotifierConfiguration) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EmailNotifierConfiguration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EmailNotifierConfiguration.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EmailNotifierConfiguration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EmailNotifierConfiguration.Merge(m, src)
}
func (m *EmailNotifierConfiguration) XXX_Size() int {
	return m.Size()
}
func (m *EmailNotifierConfiguration) XXX_DiscardUnknown() {
	xxx_messageInfo_EmailNotifierConfiguration.DiscardUnknown(m)
}

var xxx_messageInfo_EmailNotifierConfiguration proto.InternalMessageInfo

func (m *EmailNotifierConfiguration) GetNotifierId() string {
	if m != nil {
		return m.NotifierId
	}
	return ""
}

func (m *EmailNotifierConfiguration) GetMailingLists() []string {
	if m != nil {
		return m.MailingLists
	}
	return nil
}

func (m *EmailNotifierConfiguration) MessageClone() proto.Message {
	return m.Clone()
}
func (m *EmailNotifierConfiguration) Clone() *EmailNotifierConfiguration {
	if m == nil {
		return nil
	}
	cloned := new(EmailNotifierConfiguration)
	*cloned = *m

	if m.MailingLists != nil {
		cloned.MailingLists = make([]string, len(m.MailingLists))
		copy(cloned.MailingLists, m.MailingLists)
	}
	return cloned
}

func init() {
	proto.RegisterEnum("storage.ReportConfiguration_ReportType", ReportConfiguration_ReportType_name, ReportConfiguration_ReportType_value)
	proto.RegisterEnum("storage.ReportLastRunStatus_RunStatus", ReportLastRunStatus_RunStatus_name, ReportLastRunStatus_RunStatus_value)
	proto.RegisterEnum("storage.VulnerabilityReportFilters_Fixability", VulnerabilityReportFilters_Fixability_name, VulnerabilityReportFilters_Fixability_value)
	proto.RegisterType((*ReportConfiguration)(nil), "storage.ReportConfiguration")
	proto.RegisterType((*ReportLastRunStatus)(nil), "storage.ReportLastRunStatus")
	proto.RegisterType((*VulnerabilityReportFilters)(nil), "storage.VulnerabilityReportFilters")
	proto.RegisterType((*EmailNotifierConfiguration)(nil), "storage.EmailNotifierConfiguration")
}

func init() {
	proto.RegisterFile("storage/report_configuration.proto", fileDescriptor_541201f82fe9caab)
}

var fileDescriptor_541201f82fe9caab = []byte{
	// 750 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x54, 0xd1, 0x6e, 0x32, 0x45,
	0x14, 0x66, 0x81, 0xbf, 0xc0, 0xa1, 0x14, 0x98, 0x56, 0xb3, 0x45, 0x03, 0x64, 0x1b, 0x95, 0x18,
	0x5d, 0x92, 0xda, 0x2b, 0x2f, 0x9a, 0x94, 0x4a, 0x03, 0x11, 0x69, 0x32, 0x0b, 0x8d, 0x7a, 0xb3,
	0x59, 0x96, 0x61, 0x3b, 0x71, 0xd9, 0x25, 0x33, 0xb3, 0x4d, 0x79, 0x09, 0xe3, 0xa5, 0x8f, 0xe4,
	0xa5, 0x4f, 0x60, 0x4c, 0x4d, 0x7c, 0x00, 0x9f, 0xc0, 0xec, 0xec, 0xec, 0x42, 0x9b, 0x56, 0xff,
	0x3b, 0xe6, 0x3b, 0xe7, 0x7c, 0xe7, 0x7c, 0xe7, 0x7c, 0x2c, 0x18, 0x5c, 0x84, 0xcc, 0xf1, 0x48,
	0x9f, 0x91, 0x4d, 0xc8, 0x84, 0xed, 0x86, 0xc1, 0x8a, 0x7a, 0x11, 0x73, 0x04, 0x0d, 0x03, 0x73,
	0xc3, 0x42, 0x11, 0xa2, 0x92, 0xca, 0x69, 0x35, 0xd3, 0x64, 0xf7, 0x81, 0x24, 0xb1, 0xd6, 0x87,
	0x29, 0xc4, 0xdd, 0x7b, 0xb2, 0x8c, 0xfc, 0x14, 0x3f, 0xf1, 0x42, 0x2f, 0x94, 0x3f, 0xfb, 0xf1,
	0x2f, 0x85, 0x76, 0xbc, 0x30, 0xf4, 0x7c, 0xd2, 0x97, 0xaf, 0x45, 0xb4, 0xea, 0x0b, 0xba, 0x26,
	0x5c, 0x38, 0xeb, 0x4d, 0x92, 0x60, 0xfc, 0xf2, 0x0e, 0x8e, 0xb1, 0x9c, 0xe4, 0x7a, 0x7f, 0x10,
	0x74, 0x04, 0x79, 0xba, 0xd4, 0xb5, 0xae, 0xd6, 0xab, 0xe0, 0x3c, 0x5d, 0xa2, 0x2f, 0xa0, 0x18,
	0x38, 0x6b, 0xa2, 0xe7, 0x63, 0x64, 0xa0, 0xff, 0xf3, 0x47, 0xe7, 0x84, 0x13, 0x87, 0xb9, 0xf7,
	0x5f, 0x1b, 0x49, 0x79, 0x77, 0xea, 0xac, 0x89, 0x81, 0x65, 0x16, 0xea, 0x42, 0x75, 0x49, 0xb8,
	0xcb, 0xe8, 0x26, 0x26, 0xd3, 0x0b, 0x92, 0x66, 0x1f, 0x42, 0x73, 0x28, 0x8a, 0xed, 0x86, 0xe8,
	0xc5, 0xae, 0xd6, 0x3b, 0x3a, 0xff, 0xcc, 0x54, 0xaa, 0xcc, 0x57, 0x66, 0x51, 0xd8, 0x6c, 0xbb,
	0x21, 0xaf, 0x36, 0x8e, 0x03, 0x06, 0x96, 0x74, 0x68, 0x0e, 0xc7, 0x0f, 0x91, 0x1f, 0xd8, 0x6a,
	0xb9, 0x2b, 0xea, 0x0b, 0xc2, 0xb8, 0xfe, 0xae, 0xab, 0xf5, 0xaa, 0xe7, 0x67, 0x59, 0x97, 0xbb,
	0xc8, 0x0f, 0x08, 0x73, 0x16, 0xd4, 0xa7, 0x62, 0x9b, 0xd0, 0xdc, 0x24, 0xa9, 0xa3, 0x1c, 0x6e,
	0xc6, 0x0c, 0xcf, 0x40, 0x74, 0x0a, 0x65, 0xee, 0x86, 0x1b, 0x62, 0xd3, 0xa5, 0x7e, 0x20, 0xc5,
	0x94, 0xe4, 0x7b, 0xbc, 0x44, 0x23, 0x38, 0x24, 0x6b, 0x87, 0xfa, 0xea, 0x90, 0x7a, 0xe9, 0x45,
	0xab, 0x61, 0x1c, 0x9c, 0x86, 0x82, 0xae, 0x28, 0x61, 0xcf, 0x74, 0x8d, 0x34, 0x5c, 0x95, 0xa5,
	0x09, 0x8a, 0xbe, 0x8c, 0x9b, 0x24, 0x37, 0xd5, 0xcb, 0x92, 0xa5, 0x99, 0xb1, 0x58, 0x2a, 0x80,
	0xb3, 0x14, 0xf4, 0x0d, 0xd4, 0x7d, 0x87, 0x0b, 0x9b, 0x45, 0x81, 0xcd, 0x85, 0x23, 0x22, 0xae,
	0x57, 0x64, 0xd5, 0xc7, 0x2f, 0x96, 0x39, 0x71, 0xb8, 0xc0, 0x51, 0x60, 0xc9, 0x1c, 0x5c, 0xf3,
	0xf7, 0x9f, 0xc8, 0x02, 0x5d, 0xb2, 0xf0, 0xc8, 0x75, 0x09, 0xe7, 0xab, 0xc8, 0x97, 0x84, 0xb1,
	0x4d, 0x74, 0x90, 0x74, 0x2d, 0x33, 0xf1, 0x90, 0x99, 0x7a, 0xc8, 0x9c, 0xa5, 0x1e, 0xc2, 0x1f,
	0xc4, 0xb5, 0x56, 0x56, 0x8a, 0xa3, 0x20, 0x8e, 0x19, 0x1d, 0x80, 0xdd, 0xcd, 0x50, 0x13, 0x6a,
	0x77, 0xf3, 0xc9, 0x74, 0x88, 0xaf, 0x06, 0xe3, 0xc9, 0x78, 0xf6, 0x43, 0x23, 0x37, 0x28, 0xc3,
	0x41, 0x72, 0x9a, 0x41, 0x13, 0xea, 0x81, 0x5a, 0x8e, 0xda, 0xa0, 0xf1, 0xb7, 0x96, 0x5a, 0xf2,
	0xd9, 0xe4, 0xe8, 0x5b, 0xa8, 0xa9, 0xb3, 0x2a, 0xb9, 0x9a, 0xf4, 0xce, 0xa7, 0xff, 0x25, 0xd7,
	0xdc, 0x09, 0x3f, 0x4c, 0x8a, 0x15, 0xd9, 0x25, 0xd4, 0xb2, 0xed, 0x49, 0xb1, 0xf9, 0xff, 0x15,
	0x5b, 0x55, 0x9b, 0x8b, 0x11, 0xf4, 0x11, 0x54, 0x08, 0x63, 0x21, 0xb3, 0xd7, 0xdc, 0x53, 0xfe,
	0x2e, 0x4b, 0xe0, 0x3b, 0xee, 0x19, 0x9f, 0x40, 0x65, 0x37, 0x76, 0x15, 0x4a, 0xd6, 0xfc, 0xfa,
	0x7a, 0x68, 0x59, 0x8d, 0x5c, 0xfc, 0xb8, 0xb9, 0x1a, 0x4f, 0xe6, 0x78, 0xd8, 0xd0, 0x8c, 0x9f,
	0xf3, 0xd0, 0x7a, 0xdb, 0x89, 0x68, 0x0a, 0xb0, 0xa2, 0x8f, 0x2a, 0xa4, 0xc4, 0x9a, 0xef, 0x61,
	0x61, 0xf3, 0x26, 0xab, 0xc2, 0x7b, 0x0c, 0xe8, 0x73, 0x68, 0x72, 0x1a, 0xb8, 0xc4, 0x4e, 0x84,
	0xcb, 0x12, 0x29, 0xbb, 0x8c, 0xeb, 0x32, 0x20, 0x37, 0x27, 0x61, 0x74, 0x09, 0xc0, 0xc9, 0x03,
	0x61, 0x54, 0x50, 0xc2, 0xf5, 0x42, 0xb7, 0xd0, 0x3b, 0x3a, 0x6f, 0xbf, 0xde, 0xdb, 0x4a, 0xf2,
	0xb6, 0x78, 0xaf, 0xc2, 0xb8, 0x00, 0xd8, 0x4d, 0x81, 0xca, 0x50, 0x1c, 0xdc, 0xce, 0x46, 0x4a,
	0xff, 0xf8, 0xfb, 0xab, 0xc1, 0x64, 0xd8, 0xd0, 0x50, 0x1d, 0xaa, 0xd3, 0xdb, 0x99, 0x9d, 0x02,
	0x79, 0x63, 0x01, 0xad, 0xb7, 0xff, 0x2e, 0xa8, 0x03, 0xd5, 0xcc, 0x2a, 0xd9, 0xb7, 0x09, 0x52,
	0x68, 0xbc, 0x44, 0x67, 0x50, 0x8b, 0xab, 0x69, 0xe0, 0xd9, 0x3e, 0xe5, 0x82, 0xeb, 0xf9, 0x6e,
	0xa1, 0x57, 0xc1, 0x87, 0x0a, 0x9c, 0xc4, 0xd8, 0xe0, 0xe2, 0xb7, 0xa7, 0xb6, 0xf6, 0xfb, 0x53,
	0x5b, 0xfb, 0xf3, 0xa9, 0xad, 0xfd, 0xfa, 0x57, 0x3b, 0x07, 0xa7, 0x34, 0x34, 0xb9, 0x70, 0xdc,
	0x9f, 0x58, 0xf8, 0x98, 0xdc, 0x3d, 0x15, 0xfa, 0x63, 0xfa, 0x21, 0x5e, 0x1c, 0x48, 0xfc, 0xab,
	0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x8c, 0xe4, 0x13, 0x48, 0xbe, 0x05, 0x00, 0x00,
}

func (m *ReportConfiguration) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReportConfiguration) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReportConfiguration) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.LastSuccessfulRunTime != nil {
		{
			size, err := m.LastSuccessfulRunTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportConfiguration(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.LastRunStatus != nil {
		{
			size, err := m.LastRunStatus.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportConfiguration(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.Schedule != nil {
		{
			size, err := m.Schedule.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportConfiguration(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.NotifierConfig != nil {
		{
			size := m.NotifierConfig.Size()
			i -= size
			if _, err := m.NotifierConfig.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.ScopeId) > 0 {
		i -= len(m.ScopeId)
		copy(dAtA[i:], m.ScopeId)
		i = encodeVarintReportConfiguration(dAtA, i, uint64(len(m.ScopeId)))
		i--
		dAtA[i] = 0x32
	}
	if m.Filter != nil {
		{
			size := m.Filter.Size()
			i -= size
			if _, err := m.Filter.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Type != 0 {
		i = encodeVarintReportConfiguration(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintReportConfiguration(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintReportConfiguration(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintReportConfiguration(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReportConfiguration_VulnReportFilters) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReportConfiguration_VulnReportFilters) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.VulnReportFilters != nil {
		{
			size, err := m.VulnReportFilters.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportConfiguration(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *ReportConfiguration_EmailConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReportConfiguration_EmailConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.EmailConfig != nil {
		{
			size, err := m.EmailConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportConfiguration(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *ReportLastRunStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReportLastRunStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReportLastRunStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ErrorMsg) > 0 {
		i -= len(m.ErrorMsg)
		copy(dAtA[i:], m.ErrorMsg)
		i = encodeVarintReportConfiguration(dAtA, i, uint64(len(m.ErrorMsg)))
		i--
		dAtA[i] = 0x1a
	}
	if m.LastRunTime != nil {
		{
			size, err := m.LastRunTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportConfiguration(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.ReportStatus != 0 {
		i = encodeVarintReportConfiguration(dAtA, i, uint64(m.ReportStatus))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *VulnerabilityReportFilters) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VulnerabilityReportFilters) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VulnerabilityReportFilters) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Severities) > 0 {
		dAtA8 := make([]byte, len(m.Severities)*10)
		var j7 int
		for _, num := range m.Severities {
			for num >= 1<<7 {
				dAtA8[j7] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j7++
			}
			dAtA8[j7] = uint8(num)
			j7++
		}
		i -= j7
		copy(dAtA[i:], dAtA8[:j7])
		i = encodeVarintReportConfiguration(dAtA, i, uint64(j7))
		i--
		dAtA[i] = 0x1a
	}
	if m.SinceLastReport {
		i--
		if m.SinceLastReport {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.Fixability != 0 {
		i = encodeVarintReportConfiguration(dAtA, i, uint64(m.Fixability))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *EmailNotifierConfiguration) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EmailNotifierConfiguration) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EmailNotifierConfiguration) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.MailingLists) > 0 {
		for iNdEx := len(m.MailingLists) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.MailingLists[iNdEx])
			copy(dAtA[i:], m.MailingLists[iNdEx])
			i = encodeVarintReportConfiguration(dAtA, i, uint64(len(m.MailingLists[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.NotifierId) > 0 {
		i -= len(m.NotifierId)
		copy(dAtA[i:], m.NotifierId)
		i = encodeVarintReportConfiguration(dAtA, i, uint64(len(m.NotifierId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintReportConfiguration(dAtA []byte, offset int, v uint64) int {
	offset -= sovReportConfiguration(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ReportConfiguration) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovReportConfiguration(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovReportConfiguration(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovReportConfiguration(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovReportConfiguration(uint64(m.Type))
	}
	if m.Filter != nil {
		n += m.Filter.Size()
	}
	l = len(m.ScopeId)
	if l > 0 {
		n += 1 + l + sovReportConfiguration(uint64(l))
	}
	if m.NotifierConfig != nil {
		n += m.NotifierConfig.Size()
	}
	if m.Schedule != nil {
		l = m.Schedule.Size()
		n += 1 + l + sovReportConfiguration(uint64(l))
	}
	if m.LastRunStatus != nil {
		l = m.LastRunStatus.Size()
		n += 1 + l + sovReportConfiguration(uint64(l))
	}
	if m.LastSuccessfulRunTime != nil {
		l = m.LastSuccessfulRunTime.Size()
		n += 1 + l + sovReportConfiguration(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReportConfiguration_VulnReportFilters) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.VulnReportFilters != nil {
		l = m.VulnReportFilters.Size()
		n += 1 + l + sovReportConfiguration(uint64(l))
	}
	return n
}
func (m *ReportConfiguration_EmailConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.EmailConfig != nil {
		l = m.EmailConfig.Size()
		n += 1 + l + sovReportConfiguration(uint64(l))
	}
	return n
}
func (m *ReportLastRunStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ReportStatus != 0 {
		n += 1 + sovReportConfiguration(uint64(m.ReportStatus))
	}
	if m.LastRunTime != nil {
		l = m.LastRunTime.Size()
		n += 1 + l + sovReportConfiguration(uint64(l))
	}
	l = len(m.ErrorMsg)
	if l > 0 {
		n += 1 + l + sovReportConfiguration(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VulnerabilityReportFilters) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Fixability != 0 {
		n += 1 + sovReportConfiguration(uint64(m.Fixability))
	}
	if m.SinceLastReport {
		n += 2
	}
	if len(m.Severities) > 0 {
		l = 0
		for _, e := range m.Severities {
			l += sovReportConfiguration(uint64(e))
		}
		n += 1 + sovReportConfiguration(uint64(l)) + l
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EmailNotifierConfiguration) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NotifierId)
	if l > 0 {
		n += 1 + l + sovReportConfiguration(uint64(l))
	}
	if len(m.MailingLists) > 0 {
		for _, s := range m.MailingLists {
			l = len(s)
			n += 1 + l + sovReportConfiguration(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovReportConfiguration(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozReportConfiguration(x uint64) (n int) {
	return sovReportConfiguration(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ReportConfiguration) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportConfiguration
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReportConfiguration: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReportConfiguration: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfiguration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfiguration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfiguration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfiguration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= ReportConfiguration_ReportType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VulnReportFilters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfiguration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &VulnerabilityReportFilters{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Filter = &ReportConfiguration_VulnReportFilters{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScopeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfiguration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ScopeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EmailConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfiguration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &EmailNotifierConfiguration{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.NotifierConfig = &ReportConfiguration_EmailConfig{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schedule", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfiguration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Schedule == nil {
				m.Schedule = &Schedule{}
			}
			if err := m.Schedule.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastRunStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfiguration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastRunStatus == nil {
				m.LastRunStatus = &ReportLastRunStatus{}
			}
			if err := m.LastRunStatus.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastSuccessfulRunTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfiguration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastSuccessfulRunTime == nil {
				m.LastSuccessfulRunTime = &types.Timestamp{}
			}
			if err := m.LastSuccessfulRunTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReportConfiguration(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReportLastRunStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportConfiguration
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReportLastRunStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReportLastRunStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReportStatus", wireType)
			}
			m.ReportStatus = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfiguration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReportStatus |= ReportLastRunStatus_RunStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastRunTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfiguration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastRunTime == nil {
				m.LastRunTime = &types.Timestamp{}
			}
			if err := m.LastRunTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMsg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfiguration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorMsg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReportConfiguration(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VulnerabilityReportFilters) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportConfiguration
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VulnerabilityReportFilters: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VulnerabilityReportFilters: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Fixability", wireType)
			}
			m.Fixability = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfiguration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Fixability |= VulnerabilityReportFilters_Fixability(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SinceLastReport", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfiguration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SinceLastReport = bool(v != 0)
		case 3:
			if wireType == 0 {
				var v VulnerabilitySeverity
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReportConfiguration
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= VulnerabilitySeverity(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Severities = append(m.Severities, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReportConfiguration
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthReportConfiguration
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthReportConfiguration
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.Severities) == 0 {
					m.Severities = make([]VulnerabilitySeverity, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v VulnerabilitySeverity
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportConfiguration
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= VulnerabilitySeverity(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Severities = append(m.Severities, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Severities", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipReportConfiguration(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EmailNotifierConfiguration) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportConfiguration
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EmailNotifierConfiguration: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EmailNotifierConfiguration: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotifierId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfiguration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NotifierId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MailingLists", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfiguration
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MailingLists = append(m.MailingLists, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReportConfiguration(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthReportConfiguration
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipReportConfiguration(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowReportConfiguration
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowReportConfiguration
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowReportConfiguration
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthReportConfiguration
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupReportConfiguration
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthReportConfiguration
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthReportConfiguration        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowReportConfiguration          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupReportConfiguration = fmt.Errorf("proto: unexpected end of group")
)
