// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/role.proto

package storage

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type Access int32

const (
	Access_NO_ACCESS         Access = 0
	Access_READ_ACCESS       Access = 1
	Access_READ_WRITE_ACCESS Access = 2
)

var Access_name = map[int32]string{
	0: "NO_ACCESS",
	1: "READ_ACCESS",
	2: "READ_WRITE_ACCESS",
}

var Access_value = map[string]int32{
	"NO_ACCESS":         0,
	"READ_ACCESS":       1,
	"READ_WRITE_ACCESS": 2,
}

func (x Access) String() string {
	return proto.EnumName(Access_name, int32(x))
}

func (Access) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_dc9b4bbfaa99ac3e, []int{0}
}

type EffectiveAccessScope_State int32

const (
	EffectiveAccessScope_UNKNOWN  EffectiveAccessScope_State = 0
	EffectiveAccessScope_INCLUDED EffectiveAccessScope_State = 1
	EffectiveAccessScope_EXCLUDED EffectiveAccessScope_State = 2
	EffectiveAccessScope_PARTIAL  EffectiveAccessScope_State = 3
)

var EffectiveAccessScope_State_name = map[int32]string{
	0: "UNKNOWN",
	1: "INCLUDED",
	2: "EXCLUDED",
	3: "PARTIAL",
}

var EffectiveAccessScope_State_value = map[string]int32{
	"UNKNOWN":  0,
	"INCLUDED": 1,
	"EXCLUDED": 2,
	"PARTIAL":  3,
}

func (x EffectiveAccessScope_State) String() string {
	return proto.EnumName(EffectiveAccessScope_State_name, int32(x))
}

func (EffectiveAccessScope_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_dc9b4bbfaa99ac3e, []int{3, 0}
}

// A role specifies which actions are allowed for which subset of cluster
// objects. Permissions be can either specified directly via setting
// resource_to_access together with global_access or by referencing a
// permission set by its id in permission_set_name.
type Role struct {
	// `name` and `description` are provided by the user and can be changed.
	Name        string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// The associated PermissionSet and AccessScope for this Role.
	PermissionSetId string `protobuf:"bytes,6,opt,name=permission_set_id,json=permissionSetId,proto3" json:"permission_set_id,omitempty"`
	AccessScopeId   string `protobuf:"bytes,7,opt,name=access_scope_id,json=accessScopeId,proto3" json:"access_scope_id,omitempty"`
	// Minimum (not default!) access level for every resource. Can be extended
	// below by explicit permissions but not shrunk.
	// Deprecated 2021-04-20 in favor of `permission_set_id`.
	// This field now should be always NO_ACCESS
	GlobalAccess Access `protobuf:"varint,2,opt,name=global_access,json=globalAccess,proto3,enum=storage.Access" json:"global_access,omitempty"` // Deprecated: Do not use.
	// Deprecated 2021-04-20 in favor of `permission_set_id`.
	ResourceToAccess     map[string]Access `protobuf:"bytes,3,rep,name=resource_to_access,json=resourceToAccess,proto3" json:"resource_to_access,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=storage.Access"` // Deprecated: Do not use.
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Role) Reset()         { *m = Role{} }
func (m *Role) String() string { return proto.CompactTextString(m) }
func (*Role) ProtoMessage()    {}
func (*Role) Descriptor() ([]byte, []int) {
	return fileDescriptor_dc9b4bbfaa99ac3e, []int{0}
}
func (m *Role) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Role) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Role.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Role) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Role.Merge(m, src)
}
func (m *Role) XXX_Size() int {
	return m.Size()
}
func (m *Role) XXX_DiscardUnknown() {
	xxx_messageInfo_Role.DiscardUnknown(m)
}

var xxx_messageInfo_Role proto.InternalMessageInfo

func (m *Role) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Role) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Role) GetPermissionSetId() string {
	if m != nil {
		return m.PermissionSetId
	}
	return ""
}

func (m *Role) GetAccessScopeId() string {
	if m != nil {
		return m.AccessScopeId
	}
	return ""
}

// Deprecated: Do not use.
func (m *Role) GetGlobalAccess() Access {
	if m != nil {
		return m.GlobalAccess
	}
	return Access_NO_ACCESS
}

// Deprecated: Do not use.
func (m *Role) GetResourceToAccess() map[string]Access {
	if m != nil {
		return m.ResourceToAccess
	}
	return nil
}

func (m *Role) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Role) Clone() *Role {
	if m == nil {
		return nil
	}
	cloned := new(Role)
	*cloned = *m

	if m.ResourceToAccess != nil {
		cloned.ResourceToAccess = make(map[string]Access, len(m.ResourceToAccess))
		for k, v := range m.ResourceToAccess {
			cloned.ResourceToAccess[k] = v
		}
	}
	return cloned
}

// This encodes a set of permissions for StackRox resources.
type PermissionSet struct {
	// id is generated and cannot be changed.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// `name` and `description` are provided by the user and can be changed.
	Name                 string            `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Description          string            `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	ResourceToAccess     map[string]Access `protobuf:"bytes,4,rep,name=resource_to_access,json=resourceToAccess,proto3" json:"resource_to_access,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=storage.Access"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PermissionSet) Reset()         { *m = PermissionSet{} }
func (m *PermissionSet) String() string { return proto.CompactTextString(m) }
func (*PermissionSet) ProtoMessage()    {}
func (*PermissionSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_dc9b4bbfaa99ac3e, []int{1}
}
func (m *PermissionSet) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PermissionSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PermissionSet.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PermissionSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PermissionSet.Merge(m, src)
}
func (m *PermissionSet) XXX_Size() int {
	return m.Size()
}
func (m *PermissionSet) XXX_DiscardUnknown() {
	xxx_messageInfo_PermissionSet.DiscardUnknown(m)
}

var xxx_messageInfo_PermissionSet proto.InternalMessageInfo

func (m *PermissionSet) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PermissionSet) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PermissionSet) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *PermissionSet) GetResourceToAccess() map[string]Access {
	if m != nil {
		return m.ResourceToAccess
	}
	return nil
}

func (m *PermissionSet) MessageClone() proto.Message {
	return m.Clone()
}
func (m *PermissionSet) Clone() *PermissionSet {
	if m == nil {
		return nil
	}
	cloned := new(PermissionSet)
	*cloned = *m

	if m.ResourceToAccess != nil {
		cloned.ResourceToAccess = make(map[string]Access, len(m.ResourceToAccess))
		for k, v := range m.ResourceToAccess {
			cloned.ResourceToAccess[k] = v
		}
	}
	return cloned
}

// Simple access scope is a (simple) selection criteria for scoped resources.
// It does *not* allow multi-component AND-rules nor set operations on names.
type SimpleAccessScope struct {
	// `id` is generated and cannot be changed.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// `name` and `description` are provided by the user and can be changed.
	Name                 string                   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Description          string                   `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	Rules                *SimpleAccessScope_Rules `protobuf:"bytes,4,opt,name=rules,proto3" json:"rules,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *SimpleAccessScope) Reset()         { *m = SimpleAccessScope{} }
func (m *SimpleAccessScope) String() string { return proto.CompactTextString(m) }
func (*SimpleAccessScope) ProtoMessage()    {}
func (*SimpleAccessScope) Descriptor() ([]byte, []int) {
	return fileDescriptor_dc9b4bbfaa99ac3e, []int{2}
}
func (m *SimpleAccessScope) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SimpleAccessScope) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SimpleAccessScope.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SimpleAccessScope) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SimpleAccessScope.Merge(m, src)
}
func (m *SimpleAccessScope) XXX_Size() int {
	return m.Size()
}
func (m *SimpleAccessScope) XXX_DiscardUnknown() {
	xxx_messageInfo_SimpleAccessScope.DiscardUnknown(m)
}

var xxx_messageInfo_SimpleAccessScope proto.InternalMessageInfo

func (m *SimpleAccessScope) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SimpleAccessScope) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SimpleAccessScope) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *SimpleAccessScope) GetRules() *SimpleAccessScope_Rules {
	if m != nil {
		return m.Rules
	}
	return nil
}

func (m *SimpleAccessScope) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SimpleAccessScope) Clone() *SimpleAccessScope {
	if m == nil {
		return nil
	}
	cloned := new(SimpleAccessScope)
	*cloned = *m

	cloned.Rules = m.Rules.Clone()
	return cloned
}

// Each element of any repeated field is an individual rule. Rules are
// joined by logical OR: if there exists a rule allowing resource `x`,
// `x` is in the access scope.
type SimpleAccessScope_Rules struct {
	IncludedClusters        []string                             `protobuf:"bytes,1,rep,name=included_clusters,json=includedClusters,proto3" json:"included_clusters,omitempty"`
	IncludedNamespaces      []*SimpleAccessScope_Rules_Namespace `protobuf:"bytes,2,rep,name=included_namespaces,json=includedNamespaces,proto3" json:"included_namespaces,omitempty"`
	ClusterLabelSelectors   []*SetBasedLabelSelector             `protobuf:"bytes,3,rep,name=cluster_label_selectors,json=clusterLabelSelectors,proto3" json:"cluster_label_selectors,omitempty"`
	NamespaceLabelSelectors []*SetBasedLabelSelector             `protobuf:"bytes,4,rep,name=namespace_label_selectors,json=namespaceLabelSelectors,proto3" json:"namespace_label_selectors,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}                             `json:"-"`
	XXX_unrecognized        []byte                               `json:"-"`
	XXX_sizecache           int32                                `json:"-"`
}

func (m *SimpleAccessScope_Rules) Reset()         { *m = SimpleAccessScope_Rules{} }
func (m *SimpleAccessScope_Rules) String() string { return proto.CompactTextString(m) }
func (*SimpleAccessScope_Rules) ProtoMessage()    {}
func (*SimpleAccessScope_Rules) Descriptor() ([]byte, []int) {
	return fileDescriptor_dc9b4bbfaa99ac3e, []int{2, 0}
}
func (m *SimpleAccessScope_Rules) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SimpleAccessScope_Rules) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SimpleAccessScope_Rules.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SimpleAccessScope_Rules) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SimpleAccessScope_Rules.Merge(m, src)
}
func (m *SimpleAccessScope_Rules) XXX_Size() int {
	return m.Size()
}
func (m *SimpleAccessScope_Rules) XXX_DiscardUnknown() {
	xxx_messageInfo_SimpleAccessScope_Rules.DiscardUnknown(m)
}

var xxx_messageInfo_SimpleAccessScope_Rules proto.InternalMessageInfo

func (m *SimpleAccessScope_Rules) GetIncludedClusters() []string {
	if m != nil {
		return m.IncludedClusters
	}
	return nil
}

func (m *SimpleAccessScope_Rules) GetIncludedNamespaces() []*SimpleAccessScope_Rules_Namespace {
	if m != nil {
		return m.IncludedNamespaces
	}
	return nil
}

func (m *SimpleAccessScope_Rules) GetClusterLabelSelectors() []*SetBasedLabelSelector {
	if m != nil {
		return m.ClusterLabelSelectors
	}
	return nil
}

func (m *SimpleAccessScope_Rules) GetNamespaceLabelSelectors() []*SetBasedLabelSelector {
	if m != nil {
		return m.NamespaceLabelSelectors
	}
	return nil
}

func (m *SimpleAccessScope_Rules) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SimpleAccessScope_Rules) Clone() *SimpleAccessScope_Rules {
	if m == nil {
		return nil
	}
	cloned := new(SimpleAccessScope_Rules)
	*cloned = *m

	if m.IncludedClusters != nil {
		cloned.IncludedClusters = make([]string, len(m.IncludedClusters))
		copy(cloned.IncludedClusters, m.IncludedClusters)
	}
	if m.IncludedNamespaces != nil {
		cloned.IncludedNamespaces = make([]*SimpleAccessScope_Rules_Namespace, len(m.IncludedNamespaces))
		for idx, v := range m.IncludedNamespaces {
			cloned.IncludedNamespaces[idx] = v.Clone()
		}
	}
	if m.ClusterLabelSelectors != nil {
		cloned.ClusterLabelSelectors = make([]*SetBasedLabelSelector, len(m.ClusterLabelSelectors))
		for idx, v := range m.ClusterLabelSelectors {
			cloned.ClusterLabelSelectors[idx] = v.Clone()
		}
	}
	if m.NamespaceLabelSelectors != nil {
		cloned.NamespaceLabelSelectors = make([]*SetBasedLabelSelector, len(m.NamespaceLabelSelectors))
		for idx, v := range m.NamespaceLabelSelectors {
			cloned.NamespaceLabelSelectors[idx] = v.Clone()
		}
	}
	return cloned
}

type SimpleAccessScope_Rules_Namespace struct {
	// Both fields must be set.
	ClusterName          string   `protobuf:"bytes,1,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	NamespaceName        string   `protobuf:"bytes,2,opt,name=namespace_name,json=namespaceName,proto3" json:"namespace_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SimpleAccessScope_Rules_Namespace) Reset()         { *m = SimpleAccessScope_Rules_Namespace{} }
func (m *SimpleAccessScope_Rules_Namespace) String() string { return proto.CompactTextString(m) }
func (*SimpleAccessScope_Rules_Namespace) ProtoMessage()    {}
func (*SimpleAccessScope_Rules_Namespace) Descriptor() ([]byte, []int) {
	return fileDescriptor_dc9b4bbfaa99ac3e, []int{2, 0, 0}
}
func (m *SimpleAccessScope_Rules_Namespace) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SimpleAccessScope_Rules_Namespace) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SimpleAccessScope_Rules_Namespace.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SimpleAccessScope_Rules_Namespace) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SimpleAccessScope_Rules_Namespace.Merge(m, src)
}
func (m *SimpleAccessScope_Rules_Namespace) XXX_Size() int {
	return m.Size()
}
func (m *SimpleAccessScope_Rules_Namespace) XXX_DiscardUnknown() {
	xxx_messageInfo_SimpleAccessScope_Rules_Namespace.DiscardUnknown(m)
}

var xxx_messageInfo_SimpleAccessScope_Rules_Namespace proto.InternalMessageInfo

func (m *SimpleAccessScope_Rules_Namespace) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *SimpleAccessScope_Rules_Namespace) GetNamespaceName() string {
	if m != nil {
		return m.NamespaceName
	}
	return ""
}

func (m *SimpleAccessScope_Rules_Namespace) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SimpleAccessScope_Rules_Namespace) Clone() *SimpleAccessScope_Rules_Namespace {
	if m == nil {
		return nil
	}
	cloned := new(SimpleAccessScope_Rules_Namespace)
	*cloned = *m

	return cloned
}

// EffectiveAccessScope describes which clusters and namespaces are "in scope"
// given current state. Basically, if AccessScope is applied to the currently
// known clusters and namespaces, the result is EffectiveAccessScope.
//
// EffectiveAccessScope represents a tree with nodes marked as included and
// excluded. If a node is included, all its child nodes are included.
type EffectiveAccessScope struct {
	Clusters             []*EffectiveAccessScope_Cluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *EffectiveAccessScope) Reset()         { *m = EffectiveAccessScope{} }
func (m *EffectiveAccessScope) String() string { return proto.CompactTextString(m) }
func (*EffectiveAccessScope) ProtoMessage()    {}
func (*EffectiveAccessScope) Descriptor() ([]byte, []int) {
	return fileDescriptor_dc9b4bbfaa99ac3e, []int{3}
}
func (m *EffectiveAccessScope) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EffectiveAccessScope) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EffectiveAccessScope.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EffectiveAccessScope) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EffectiveAccessScope.Merge(m, src)
}
func (m *EffectiveAccessScope) XXX_Size() int {
	return m.Size()
}
func (m *EffectiveAccessScope) XXX_DiscardUnknown() {
	xxx_messageInfo_EffectiveAccessScope.DiscardUnknown(m)
}

var xxx_messageInfo_EffectiveAccessScope proto.InternalMessageInfo

func (m *EffectiveAccessScope) GetClusters() []*EffectiveAccessScope_Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *EffectiveAccessScope) MessageClone() proto.Message {
	return m.Clone()
}
func (m *EffectiveAccessScope) Clone() *EffectiveAccessScope {
	if m == nil {
		return nil
	}
	cloned := new(EffectiveAccessScope)
	*cloned = *m

	if m.Clusters != nil {
		cloned.Clusters = make([]*EffectiveAccessScope_Cluster, len(m.Clusters))
		for idx, v := range m.Clusters {
			cloned.Clusters[idx] = v.Clone()
		}
	}
	return cloned
}

type EffectiveAccessScope_Namespace struct {
	Id                   string                     `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Name                 string                     `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	State                EffectiveAccessScope_State `protobuf:"varint,3,opt,name=state,proto3,enum=storage.EffectiveAccessScope_State" json:"state,omitempty"`
	Labels               map[string]string          `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *EffectiveAccessScope_Namespace) Reset()         { *m = EffectiveAccessScope_Namespace{} }
func (m *EffectiveAccessScope_Namespace) String() string { return proto.CompactTextString(m) }
func (*EffectiveAccessScope_Namespace) ProtoMessage()    {}
func (*EffectiveAccessScope_Namespace) Descriptor() ([]byte, []int) {
	return fileDescriptor_dc9b4bbfaa99ac3e, []int{3, 0}
}
func (m *EffectiveAccessScope_Namespace) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EffectiveAccessScope_Namespace) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EffectiveAccessScope_Namespace.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EffectiveAccessScope_Namespace) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EffectiveAccessScope_Namespace.Merge(m, src)
}
func (m *EffectiveAccessScope_Namespace) XXX_Size() int {
	return m.Size()
}
func (m *EffectiveAccessScope_Namespace) XXX_DiscardUnknown() {
	xxx_messageInfo_EffectiveAccessScope_Namespace.DiscardUnknown(m)
}

var xxx_messageInfo_EffectiveAccessScope_Namespace proto.InternalMessageInfo

func (m *EffectiveAccessScope_Namespace) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *EffectiveAccessScope_Namespace) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EffectiveAccessScope_Namespace) GetState() EffectiveAccessScope_State {
	if m != nil {
		return m.State
	}
	return EffectiveAccessScope_UNKNOWN
}

func (m *EffectiveAccessScope_Namespace) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *EffectiveAccessScope_Namespace) MessageClone() proto.Message {
	return m.Clone()
}
func (m *EffectiveAccessScope_Namespace) Clone() *EffectiveAccessScope_Namespace {
	if m == nil {
		return nil
	}
	cloned := new(EffectiveAccessScope_Namespace)
	*cloned = *m

	if m.Labels != nil {
		cloned.Labels = make(map[string]string, len(m.Labels))
		for k, v := range m.Labels {
			cloned.Labels[k] = v
		}
	}
	return cloned
}

type EffectiveAccessScope_Cluster struct {
	Id                   string                            `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Name                 string                            `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	State                EffectiveAccessScope_State        `protobuf:"varint,3,opt,name=state,proto3,enum=storage.EffectiveAccessScope_State" json:"state,omitempty"`
	Labels               map[string]string                 `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Namespaces           []*EffectiveAccessScope_Namespace `protobuf:"bytes,4,rep,name=namespaces,proto3" json:"namespaces,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *EffectiveAccessScope_Cluster) Reset()         { *m = EffectiveAccessScope_Cluster{} }
func (m *EffectiveAccessScope_Cluster) String() string { return proto.CompactTextString(m) }
func (*EffectiveAccessScope_Cluster) ProtoMessage()    {}
func (*EffectiveAccessScope_Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_dc9b4bbfaa99ac3e, []int{3, 1}
}
func (m *EffectiveAccessScope_Cluster) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EffectiveAccessScope_Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EffectiveAccessScope_Cluster.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EffectiveAccessScope_Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EffectiveAccessScope_Cluster.Merge(m, src)
}
func (m *EffectiveAccessScope_Cluster) XXX_Size() int {
	return m.Size()
}
func (m *EffectiveAccessScope_Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_EffectiveAccessScope_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_EffectiveAccessScope_Cluster proto.InternalMessageInfo

func (m *EffectiveAccessScope_Cluster) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *EffectiveAccessScope_Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EffectiveAccessScope_Cluster) GetState() EffectiveAccessScope_State {
	if m != nil {
		return m.State
	}
	return EffectiveAccessScope_UNKNOWN
}

func (m *EffectiveAccessScope_Cluster) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *EffectiveAccessScope_Cluster) GetNamespaces() []*EffectiveAccessScope_Namespace {
	if m != nil {
		return m.Namespaces
	}
	return nil
}

func (m *EffectiveAccessScope_Cluster) MessageClone() proto.Message {
	return m.Clone()
}
func (m *EffectiveAccessScope_Cluster) Clone() *EffectiveAccessScope_Cluster {
	if m == nil {
		return nil
	}
	cloned := new(EffectiveAccessScope_Cluster)
	*cloned = *m

	if m.Labels != nil {
		cloned.Labels = make(map[string]string, len(m.Labels))
		for k, v := range m.Labels {
			cloned.Labels[k] = v
		}
	}
	if m.Namespaces != nil {
		cloned.Namespaces = make([]*EffectiveAccessScope_Namespace, len(m.Namespaces))
		for idx, v := range m.Namespaces {
			cloned.Namespaces[idx] = v.Clone()
		}
	}
	return cloned
}

func init() {
	proto.RegisterEnum("storage.Access", Access_name, Access_value)
	proto.RegisterEnum("storage.EffectiveAccessScope_State", EffectiveAccessScope_State_name, EffectiveAccessScope_State_value)
	proto.RegisterType((*Role)(nil), "storage.Role")
	proto.RegisterMapType((map[string]Access)(nil), "storage.Role.ResourceToAccessEntry")
	proto.RegisterType((*PermissionSet)(nil), "storage.PermissionSet")
	proto.RegisterMapType((map[string]Access)(nil), "storage.PermissionSet.ResourceToAccessEntry")
	proto.RegisterType((*SimpleAccessScope)(nil), "storage.SimpleAccessScope")
	proto.RegisterType((*SimpleAccessScope_Rules)(nil), "storage.SimpleAccessScope.Rules")
	proto.RegisterType((*SimpleAccessScope_Rules_Namespace)(nil), "storage.SimpleAccessScope.Rules.Namespace")
	proto.RegisterType((*EffectiveAccessScope)(nil), "storage.EffectiveAccessScope")
	proto.RegisterType((*EffectiveAccessScope_Namespace)(nil), "storage.EffectiveAccessScope.Namespace")
	proto.RegisterMapType((map[string]string)(nil), "storage.EffectiveAccessScope.Namespace.LabelsEntry")
	proto.RegisterType((*EffectiveAccessScope_Cluster)(nil), "storage.EffectiveAccessScope.Cluster")
	proto.RegisterMapType((map[string]string)(nil), "storage.EffectiveAccessScope.Cluster.LabelsEntry")
}

func init() { proto.RegisterFile("storage/role.proto", fileDescriptor_dc9b4bbfaa99ac3e) }

var fileDescriptor_dc9b4bbfaa99ac3e = []byte{
	// 787 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x56, 0xcd, 0x6e, 0xd3, 0x40,
	0x10, 0xae, 0x9d, 0x38, 0x69, 0xc6, 0x4d, 0xe2, 0x2c, 0xad, 0x9a, 0xe6, 0x10, 0x85, 0xa0, 0x42,
	0x54, 0x90, 0x11, 0x29, 0x42, 0x2d, 0x12, 0x42, 0x69, 0x1a, 0xa1, 0xd0, 0x2a, 0xad, 0x36, 0x09,
	0x45, 0xe5, 0x60, 0xb9, 0xf6, 0xb6, 0xb2, 0xea, 0xc6, 0x91, 0xd7, 0xa9, 0xe8, 0x13, 0xf0, 0x0a,
	0x1c, 0x78, 0x08, 0x6e, 0x3c, 0x02, 0x1c, 0x79, 0x04, 0x54, 0xde, 0x80, 0x3b, 0x12, 0xf2, 0x7a,
	0xed, 0x38, 0x34, 0x85, 0x48, 0xfc, 0xdc, 0xec, 0x6f, 0xbe, 0x99, 0x9d, 0xf9, 0x66, 0x66, 0x6d,
	0x40, 0xd4, 0x73, 0x5c, 0xfd, 0x84, 0xdc, 0x77, 0x1d, 0x9b, 0xa8, 0x43, 0xd7, 0xf1, 0x1c, 0x94,
	0xe6, 0x58, 0x69, 0x31, 0x34, 0xda, 0xfa, 0x11, 0xb1, 0x69, 0x60, 0xae, 0x7e, 0x17, 0x21, 0x89,
	0x1d, 0x9b, 0x20, 0x04, 0xc9, 0x81, 0x7e, 0x46, 0x8a, 0x42, 0x45, 0xa8, 0x65, 0x30, 0x7b, 0x46,
	0x15, 0x90, 0x4d, 0x42, 0x0d, 0xd7, 0x1a, 0x7a, 0x96, 0x33, 0x28, 0x4a, 0xcc, 0x14, 0x87, 0xd0,
	0x1a, 0x14, 0x86, 0xc4, 0x3d, 0xb3, 0x28, 0xb5, 0x9c, 0x81, 0x46, 0x89, 0xa7, 0x59, 0x66, 0x31,
	0xc5, 0x78, 0xf9, 0xb1, 0xa1, 0x4b, 0xbc, 0xb6, 0x89, 0x6e, 0x43, 0x5e, 0x37, 0x0c, 0x42, 0xa9,
	0x46, 0x0d, 0x67, 0x48, 0x7c, 0x66, 0x9a, 0x31, 0xb3, 0x01, 0xdc, 0xf5, 0xd1, 0xb6, 0x89, 0x36,
	0x20, 0x7b, 0x62, 0x3b, 0x47, 0xba, 0xad, 0x05, 0x78, 0x51, 0xac, 0x08, 0xb5, 0x5c, 0x3d, 0xaf,
	0xf2, 0x02, 0xd4, 0x06, 0x83, 0xb7, 0xc4, 0xa2, 0x80, 0x17, 0x02, 0x66, 0x80, 0xa0, 0x3e, 0x20,
	0x97, 0x50, 0x67, 0xe4, 0x1a, 0x44, 0xf3, 0x9c, 0xd0, 0x3d, 0x51, 0x49, 0xd4, 0xe4, 0xfa, 0xad,
	0xc8, 0xdd, 0x2f, 0x57, 0xc5, 0x9c, 0xd7, 0x73, 0x02, 0xdf, 0xd6, 0xc0, 0x73, 0x2f, 0x58, 0x48,
	0xc5, 0xfd, 0xc9, 0x54, 0xea, 0xc1, 0xd2, 0x54, 0x3a, 0x52, 0x20, 0x71, 0x4a, 0x2e, 0xb8, 0x64,
	0xfe, 0x23, 0x5a, 0x05, 0xe9, 0x5c, 0xb7, 0x47, 0xe4, 0x9a, 0x9c, 0x71, 0x60, 0x7d, 0x2c, 0x6e,
	0x08, 0xcf, 0x93, 0xf3, 0x49, 0x45, 0xaa, 0xbe, 0x11, 0x21, 0xbb, 0x1f, 0x17, 0x0a, 0xe5, 0x40,
	0xb4, 0x4c, 0x1e, 0x53, 0xb4, 0xcc, 0xa8, 0x31, 0xe2, 0xf5, 0x8d, 0x49, 0x5c, 0x6d, 0xcc, 0xe1,
	0x54, 0x29, 0x92, 0x4c, 0x8a, 0x7b, 0x51, 0x56, 0x13, 0x27, 0x4f, 0xd7, 0xe4, 0x7f, 0xe9, 0x51,
	0x7d, 0x9f, 0x84, 0x42, 0xd7, 0x3a, 0x1b, 0xda, 0xa4, 0x31, 0x1e, 0x87, 0xbf, 0xa4, 0xc6, 0x23,
	0x90, 0xdc, 0x91, 0x4d, 0x7c, 0x01, 0x84, 0x9a, 0x5c, 0xaf, 0x44, 0x69, 0x5c, 0x39, 0x50, 0xc5,
	0x3e, 0x0f, 0x07, 0xf4, 0xd2, 0xbb, 0x04, 0x48, 0x0c, 0x40, 0x77, 0xa1, 0x60, 0x0d, 0x0c, 0x7b,
	0x64, 0x12, 0x53, 0x33, 0xec, 0x11, 0xf5, 0x88, 0x4b, 0x8b, 0x42, 0x25, 0x51, 0xcb, 0x60, 0x25,
	0x34, 0x34, 0x39, 0x8e, 0x5e, 0xc1, 0x8d, 0x88, 0xec, 0x67, 0x48, 0x87, 0xba, 0x41, 0xfc, 0x39,
	0xf6, 0xd5, 0x5f, 0xfb, 0xdd, 0xe1, 0x6a, 0x27, 0x74, 0xc1, 0x28, 0x0c, 0x13, 0x41, 0x14, 0xbd,
	0x80, 0x65, 0x9e, 0x80, 0xc6, 0x36, 0x59, 0xa3, 0xc4, 0x26, 0x86, 0xe7, 0xb8, 0xe1, 0xa4, 0x97,
	0xc7, 0x07, 0x10, 0x6f, 0x4b, 0xa7, 0xc4, 0xdc, 0xf5, 0x79, 0x5d, 0x4e, 0xc3, 0x4b, 0xdc, 0x7d,
	0x02, 0xa5, 0xe8, 0x10, 0x56, 0xa2, 0x5c, 0xaf, 0x44, 0x4e, 0xce, 0x14, 0x79, 0x39, 0x0a, 0x30,
	0x19, 0xbb, 0xd4, 0x87, 0x4c, 0x54, 0x01, 0xba, 0x09, 0x0b, 0x61, 0x01, 0xb1, 0x1b, 0x47, 0xe6,
	0x98, 0xcf, 0x43, 0xab, 0x90, 0x1b, 0xe7, 0x12, 0xeb, 0x77, 0x36, 0x42, 0x7d, 0x5a, 0xf5, 0xa3,
	0x04, 0x8b, 0xad, 0xe3, 0x63, 0x62, 0x78, 0xd6, 0xf9, 0xc4, 0xd4, 0x34, 0x60, 0x7e, 0xa2, 0x49,
	0x72, 0x7d, 0x35, 0x4a, 0x7d, 0x9a, 0x83, 0xca, 0x5b, 0x87, 0x23, 0xb7, 0xd2, 0x37, 0x21, 0x9e,
	0xf3, 0x2c, 0x63, 0xb8, 0x09, 0x12, 0xf5, 0x74, 0x8f, 0xb0, 0x01, 0xcc, 0xc5, 0x2e, 0x9c, 0xa9,
	0x27, 0x76, 0x7d, 0x2a, 0x0e, 0x3c, 0xd0, 0x0e, 0xa4, 0x82, 0x5b, 0x99, 0x0b, 0xbd, 0xfe, 0x6b,
	0xdf, 0x28, 0x2f, 0x95, 0xe9, 0xcc, 0x17, 0x95, 0x87, 0x28, 0x6d, 0x82, 0x1c, 0x83, 0xa7, 0x2c,
	0xe5, 0x62, 0x7c, 0x29, 0x33, 0xb1, 0x1d, 0x2c, 0x7d, 0x10, 0x21, 0xcd, 0xa5, 0xf8, 0xd7, 0x25,
	0xb7, 0xa3, 0x92, 0x25, 0x56, 0xf2, 0x83, 0x99, 0x1a, 0x34, 0xad, 0x60, 0xf4, 0x0c, 0x20, 0xb6,
	0x65, 0x81, 0x82, 0x77, 0x66, 0x54, 0x10, 0xc7, 0x5c, 0xff, 0x40, 0xb9, 0xea, 0x13, 0x90, 0x58,
	0x79, 0x48, 0x86, 0x74, 0xbf, 0xb3, 0xd3, 0xd9, 0x3b, 0xe8, 0x28, 0x73, 0x68, 0x01, 0xe6, 0xdb,
	0x9d, 0xe6, 0x6e, 0x7f, 0xbb, 0xb5, 0xad, 0x08, 0xfe, 0x5b, 0xeb, 0x25, 0x7f, 0x13, 0x7d, 0xe2,
	0x7e, 0x03, 0xf7, 0xda, 0x8d, 0x5d, 0x25, 0xb1, 0xf6, 0x14, 0x52, 0xfc, 0x1b, 0x96, 0x85, 0x4c,
	0x67, 0x4f, 0x6b, 0x34, 0x9b, 0xad, 0x6e, 0x57, 0x99, 0x43, 0x79, 0x90, 0x71, 0xab, 0xb1, 0x1d,
	0x02, 0x02, 0x5a, 0x82, 0x02, 0x03, 0x0e, 0x70, 0xbb, 0xd7, 0x0a, 0x61, 0x71, 0xeb, 0xe1, 0xa7,
	0xcb, 0xb2, 0xf0, 0xf9, 0xb2, 0x2c, 0x7c, 0xb9, 0x2c, 0x0b, 0x6f, 0xbf, 0x96, 0xe7, 0x60, 0xc5,
	0x72, 0x54, 0xea, 0xe9, 0xc6, 0xa9, 0xeb, 0xbc, 0x0e, 0x3e, 0xf6, 0xa1, 0x24, 0x87, 0xe1, 0x3f,
	0xc1, 0x51, 0x8a, 0xe1, 0xeb, 0x3f, 0x02, 0x00, 0x00, 0xff, 0xff, 0x5f, 0xa2, 0xf4, 0x6b, 0x39,
	0x08, 0x00, 0x00,
}

func (m *Role) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Role) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Role) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AccessScopeId) > 0 {
		i -= len(m.AccessScopeId)
		copy(dAtA[i:], m.AccessScopeId)
		i = encodeVarintRole(dAtA, i, uint64(len(m.AccessScopeId)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.PermissionSetId) > 0 {
		i -= len(m.PermissionSetId)
		copy(dAtA[i:], m.PermissionSetId)
		i = encodeVarintRole(dAtA, i, uint64(len(m.PermissionSetId)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintRole(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ResourceToAccess) > 0 {
		for k := range m.ResourceToAccess {
			v := m.ResourceToAccess[k]
			baseI := i
			i = encodeVarintRole(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRole(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRole(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.GlobalAccess != 0 {
		i = encodeVarintRole(dAtA, i, uint64(m.GlobalAccess))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintRole(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PermissionSet) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PermissionSet) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PermissionSet) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ResourceToAccess) > 0 {
		for k := range m.ResourceToAccess {
			v := m.ResourceToAccess[k]
			baseI := i
			i = encodeVarintRole(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRole(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRole(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintRole(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintRole(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintRole(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SimpleAccessScope) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SimpleAccessScope) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SimpleAccessScope) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Rules != nil {
		{
			size, err := m.Rules.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRole(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintRole(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintRole(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintRole(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SimpleAccessScope_Rules) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SimpleAccessScope_Rules) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SimpleAccessScope_Rules) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.NamespaceLabelSelectors) > 0 {
		for iNdEx := len(m.NamespaceLabelSelectors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.NamespaceLabelSelectors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRole(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.ClusterLabelSelectors) > 0 {
		for iNdEx := len(m.ClusterLabelSelectors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ClusterLabelSelectors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRole(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.IncludedNamespaces) > 0 {
		for iNdEx := len(m.IncludedNamespaces) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.IncludedNamespaces[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRole(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.IncludedClusters) > 0 {
		for iNdEx := len(m.IncludedClusters) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.IncludedClusters[iNdEx])
			copy(dAtA[i:], m.IncludedClusters[iNdEx])
			i = encodeVarintRole(dAtA, i, uint64(len(m.IncludedClusters[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *SimpleAccessScope_Rules_Namespace) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SimpleAccessScope_Rules_Namespace) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SimpleAccessScope_Rules_Namespace) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.NamespaceName) > 0 {
		i -= len(m.NamespaceName)
		copy(dAtA[i:], m.NamespaceName)
		i = encodeVarintRole(dAtA, i, uint64(len(m.NamespaceName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintRole(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EffectiveAccessScope) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EffectiveAccessScope) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EffectiveAccessScope) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Clusters) > 0 {
		for iNdEx := len(m.Clusters) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Clusters[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRole(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *EffectiveAccessScope_Namespace) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EffectiveAccessScope_Namespace) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EffectiveAccessScope_Namespace) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintRole(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRole(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRole(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.State != 0 {
		i = encodeVarintRole(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintRole(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintRole(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EffectiveAccessScope_Cluster) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EffectiveAccessScope_Cluster) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EffectiveAccessScope_Cluster) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintRole(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRole(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRole(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Namespaces) > 0 {
		for iNdEx := len(m.Namespaces) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Namespaces[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRole(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.State != 0 {
		i = encodeVarintRole(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintRole(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintRole(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintRole(dAtA []byte, offset int, v uint64) int {
	offset -= sovRole(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Role) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRole(uint64(l))
	}
	if m.GlobalAccess != 0 {
		n += 1 + sovRole(uint64(m.GlobalAccess))
	}
	if len(m.ResourceToAccess) > 0 {
		for k, v := range m.ResourceToAccess {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRole(uint64(len(k))) + 1 + sovRole(uint64(v))
			n += mapEntrySize + 1 + sovRole(uint64(mapEntrySize))
		}
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovRole(uint64(l))
	}
	l = len(m.PermissionSetId)
	if l > 0 {
		n += 1 + l + sovRole(uint64(l))
	}
	l = len(m.AccessScopeId)
	if l > 0 {
		n += 1 + l + sovRole(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PermissionSet) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovRole(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRole(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovRole(uint64(l))
	}
	if len(m.ResourceToAccess) > 0 {
		for k, v := range m.ResourceToAccess {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRole(uint64(len(k))) + 1 + sovRole(uint64(v))
			n += mapEntrySize + 1 + sovRole(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SimpleAccessScope) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovRole(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRole(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovRole(uint64(l))
	}
	if m.Rules != nil {
		l = m.Rules.Size()
		n += 1 + l + sovRole(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SimpleAccessScope_Rules) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.IncludedClusters) > 0 {
		for _, s := range m.IncludedClusters {
			l = len(s)
			n += 1 + l + sovRole(uint64(l))
		}
	}
	if len(m.IncludedNamespaces) > 0 {
		for _, e := range m.IncludedNamespaces {
			l = e.Size()
			n += 1 + l + sovRole(uint64(l))
		}
	}
	if len(m.ClusterLabelSelectors) > 0 {
		for _, e := range m.ClusterLabelSelectors {
			l = e.Size()
			n += 1 + l + sovRole(uint64(l))
		}
	}
	if len(m.NamespaceLabelSelectors) > 0 {
		for _, e := range m.NamespaceLabelSelectors {
			l = e.Size()
			n += 1 + l + sovRole(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SimpleAccessScope_Rules_Namespace) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovRole(uint64(l))
	}
	l = len(m.NamespaceName)
	if l > 0 {
		n += 1 + l + sovRole(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EffectiveAccessScope) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Clusters) > 0 {
		for _, e := range m.Clusters {
			l = e.Size()
			n += 1 + l + sovRole(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EffectiveAccessScope_Namespace) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovRole(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRole(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovRole(uint64(m.State))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRole(uint64(len(k))) + 1 + len(v) + sovRole(uint64(len(v)))
			n += mapEntrySize + 1 + sovRole(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EffectiveAccessScope_Cluster) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovRole(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRole(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovRole(uint64(m.State))
	}
	if len(m.Namespaces) > 0 {
		for _, e := range m.Namespaces {
			l = e.Size()
			n += 1 + l + sovRole(uint64(l))
		}
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRole(uint64(len(k))) + 1 + len(v) + sovRole(uint64(len(v)))
			n += mapEntrySize + 1 + sovRole(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovRole(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozRole(x uint64) (n int) {
	return sovRole(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Role) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRole
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Role: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Role: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GlobalAccess", wireType)
			}
			m.GlobalAccess = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GlobalAccess |= Access(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceToAccess", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResourceToAccess == nil {
				m.ResourceToAccess = make(map[string]Access)
			}
			var mapkey string
			var mapvalue Access
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRole
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRole
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRole
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRole
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRole
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= Access(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRole(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthRole
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ResourceToAccess[mapkey] = mapvalue
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PermissionSetId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PermissionSetId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessScopeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessScopeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRole(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRole
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PermissionSet) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRole
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PermissionSet: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PermissionSet: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceToAccess", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResourceToAccess == nil {
				m.ResourceToAccess = make(map[string]Access)
			}
			var mapkey string
			var mapvalue Access
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRole
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRole
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRole
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRole
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRole
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= Access(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRole(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthRole
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ResourceToAccess[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRole(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRole
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SimpleAccessScope) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRole
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SimpleAccessScope: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SimpleAccessScope: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Rules == nil {
				m.Rules = &SimpleAccessScope_Rules{}
			}
			if err := m.Rules.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRole(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRole
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SimpleAccessScope_Rules) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRole
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Rules: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Rules: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludedClusters", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IncludedClusters = append(m.IncludedClusters, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludedNamespaces", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IncludedNamespaces = append(m.IncludedNamespaces, &SimpleAccessScope_Rules_Namespace{})
			if err := m.IncludedNamespaces[len(m.IncludedNamespaces)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterLabelSelectors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterLabelSelectors = append(m.ClusterLabelSelectors, &SetBasedLabelSelector{})
			if err := m.ClusterLabelSelectors[len(m.ClusterLabelSelectors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceLabelSelectors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceLabelSelectors = append(m.NamespaceLabelSelectors, &SetBasedLabelSelector{})
			if err := m.NamespaceLabelSelectors[len(m.NamespaceLabelSelectors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRole(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRole
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SimpleAccessScope_Rules_Namespace) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRole
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Namespace: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Namespace: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRole(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRole
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EffectiveAccessScope) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRole
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EffectiveAccessScope: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EffectiveAccessScope: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Clusters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Clusters = append(m.Clusters, &EffectiveAccessScope_Cluster{})
			if err := m.Clusters[len(m.Clusters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRole(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRole
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EffectiveAccessScope_Namespace) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRole
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Namespace: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Namespace: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= EffectiveAccessScope_State(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRole
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRole
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRole
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRole
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRole
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthRole
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthRole
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRole(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthRole
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRole(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRole
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EffectiveAccessScope_Cluster) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRole
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Cluster: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Cluster: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= EffectiveAccessScope_State(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespaces", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespaces = append(m.Namespaces, &EffectiveAccessScope_Namespace{})
			if err := m.Namespaces[len(m.Namespaces)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRole
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRole
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRole
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRole
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRole
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRole
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRole
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRole
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthRole
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthRole
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRole(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthRole
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRole(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRole
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRole(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRole
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRole
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRole
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRole
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupRole
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthRole
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthRole        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRole          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupRole = fmt.Errorf("proto: unexpected end of group")
)
