// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/secret.proto

package storage

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type SecretType int32

const (
	SecretType_UNDETERMINED             SecretType = 0
	SecretType_PUBLIC_CERTIFICATE       SecretType = 1
	SecretType_CERTIFICATE_REQUEST      SecretType = 2
	SecretType_PRIVACY_ENHANCED_MESSAGE SecretType = 3
	SecretType_OPENSSH_PRIVATE_KEY      SecretType = 4
	SecretType_PGP_PRIVATE_KEY          SecretType = 5
	SecretType_EC_PRIVATE_KEY           SecretType = 6
	SecretType_RSA_PRIVATE_KEY          SecretType = 7
	SecretType_DSA_PRIVATE_KEY          SecretType = 8
	SecretType_CERT_PRIVATE_KEY         SecretType = 9
	SecretType_ENCRYPTED_PRIVATE_KEY    SecretType = 10
	SecretType_IMAGE_PULL_SECRET        SecretType = 11
)

var SecretType_name = map[int32]string{
	0:  "UNDETERMINED",
	1:  "PUBLIC_CERTIFICATE",
	2:  "CERTIFICATE_REQUEST",
	3:  "PRIVACY_ENHANCED_MESSAGE",
	4:  "OPENSSH_PRIVATE_KEY",
	5:  "PGP_PRIVATE_KEY",
	6:  "EC_PRIVATE_KEY",
	7:  "RSA_PRIVATE_KEY",
	8:  "DSA_PRIVATE_KEY",
	9:  "CERT_PRIVATE_KEY",
	10: "ENCRYPTED_PRIVATE_KEY",
	11: "IMAGE_PULL_SECRET",
}

var SecretType_value = map[string]int32{
	"UNDETERMINED":             0,
	"PUBLIC_CERTIFICATE":       1,
	"CERTIFICATE_REQUEST":      2,
	"PRIVACY_ENHANCED_MESSAGE": 3,
	"OPENSSH_PRIVATE_KEY":      4,
	"PGP_PRIVATE_KEY":          5,
	"EC_PRIVATE_KEY":           6,
	"RSA_PRIVATE_KEY":          7,
	"DSA_PRIVATE_KEY":          8,
	"CERT_PRIVATE_KEY":         9,
	"ENCRYPTED_PRIVATE_KEY":    10,
	"IMAGE_PULL_SECRET":        11,
}

func (x SecretType) String() string {
	return proto.EnumName(SecretType_name, int32(x))
}

func (SecretType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b4b7da2d1fc45954, []int{0}
}

// Flat secret object.
// Any properties of an individual secret.
// (regardless of time, scope, or context)
//////////////////////////////////////////
type Secret struct {
	Id          string            `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" search:"Secret ID,store,hidden" sql:"pk"`
	Name        string            `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty" search:"Secret,store"`
	ClusterId   string            `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty" search:"Cluster ID,store,hidden"`
	ClusterName string            `protobuf:"bytes,4,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty" search:"Cluster,store"`
	Namespace   string            `protobuf:"bytes,5,opt,name=namespace,proto3" json:"namespace,omitempty" search:"Namespace,store"`
	Type        string            `protobuf:"bytes,6,opt,name=type,proto3" json:"type,omitempty"`
	Labels      map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Annotations map[string]string `protobuf:"bytes,8,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	CreatedAt   *types.Timestamp  `protobuf:"bytes,9,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty" search:"Created Time"`
	// Metadata about the secrets.
	// The secret need not be a file, but rather may be an arbitrary value.
	Files                []*SecretDataFile   `protobuf:"bytes,10,rep,name=files,proto3" json:"files,omitempty"`
	Relationship         *SecretRelationship `protobuf:"bytes,11,opt,name=relationship,proto3" json:"relationship,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Secret) Reset()         { *m = Secret{} }
func (m *Secret) String() string { return proto.CompactTextString(m) }
func (*Secret) ProtoMessage()    {}
func (*Secret) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4b7da2d1fc45954, []int{0}
}
func (m *Secret) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Secret) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Secret.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Secret) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Secret.Merge(m, src)
}
func (m *Secret) XXX_Size() int {
	return m.Size()
}
func (m *Secret) XXX_DiscardUnknown() {
	xxx_messageInfo_Secret.DiscardUnknown(m)
}

var xxx_messageInfo_Secret proto.InternalMessageInfo

func (m *Secret) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Secret) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Secret) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *Secret) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *Secret) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *Secret) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Secret) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Secret) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *Secret) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Secret) GetFiles() []*SecretDataFile {
	if m != nil {
		return m.Files
	}
	return nil
}

func (m *Secret) GetRelationship() *SecretRelationship {
	if m != nil {
		return m.Relationship
	}
	return nil
}

func (m *Secret) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Secret) Clone() *Secret {
	if m == nil {
		return nil
	}
	cloned := new(Secret)
	*cloned = *m

	if m.Labels != nil {
		cloned.Labels = make(map[string]string, len(m.Labels))
		for k, v := range m.Labels {
			cloned.Labels[k] = v
		}
	}
	if m.Annotations != nil {
		cloned.Annotations = make(map[string]string, len(m.Annotations))
		for k, v := range m.Annotations {
			cloned.Annotations[k] = v
		}
	}
	cloned.CreatedAt = m.CreatedAt.Clone()
	if m.Files != nil {
		cloned.Files = make([]*SecretDataFile, len(m.Files))
		for idx, v := range m.Files {
			cloned.Files[idx] = v.Clone()
		}
	}
	cloned.Relationship = m.Relationship.Clone()
	return cloned
}

type ListSecret struct {
	Id                   string           `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Name                 string           `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	ClusterName          string           `protobuf:"bytes,3,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	Namespace            string           `protobuf:"bytes,4,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Types                []SecretType     `protobuf:"varint,5,rep,packed,name=types,proto3,enum=storage.SecretType" json:"types,omitempty"`
	CreatedAt            *types.Timestamp `protobuf:"bytes,6,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ListSecret) Reset()         { *m = ListSecret{} }
func (m *ListSecret) String() string { return proto.CompactTextString(m) }
func (*ListSecret) ProtoMessage()    {}
func (*ListSecret) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4b7da2d1fc45954, []int{1}
}
func (m *ListSecret) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListSecret) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListSecret.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListSecret) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSecret.Merge(m, src)
}
func (m *ListSecret) XXX_Size() int {
	return m.Size()
}
func (m *ListSecret) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSecret.DiscardUnknown(m)
}

var xxx_messageInfo_ListSecret proto.InternalMessageInfo

func (m *ListSecret) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ListSecret) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListSecret) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *ListSecret) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ListSecret) GetTypes() []SecretType {
	if m != nil {
		return m.Types
	}
	return nil
}

func (m *ListSecret) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *ListSecret) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListSecret) Clone() *ListSecret {
	if m == nil {
		return nil
	}
	cloned := new(ListSecret)
	*cloned = *m

	if m.Types != nil {
		cloned.Types = make([]SecretType, len(m.Types))
		copy(cloned.Types, m.Types)
	}
	cloned.CreatedAt = m.CreatedAt.Clone()
	return cloned
}

// The combined relationships that belong to the secret.
// Next Tag: 6
type SecretRelationship struct {
	// Secret id
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Container id to relationship.s
	ContainerRelationships []*SecretContainerRelationship `protobuf:"bytes,4,rep,name=container_relationships,json=containerRelationships,proto3" json:"container_relationships,omitempty"`
	// Deployment id to relationship.
	DeploymentRelationships []*SecretDeploymentRelationship `protobuf:"bytes,5,rep,name=deployment_relationships,json=deploymentRelationships,proto3" json:"deployment_relationships,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}                        `json:"-"`
	XXX_unrecognized        []byte                          `json:"-"`
	XXX_sizecache           int32                           `json:"-"`
}

func (m *SecretRelationship) Reset()         { *m = SecretRelationship{} }
func (m *SecretRelationship) String() string { return proto.CompactTextString(m) }
func (*SecretRelationship) ProtoMessage()    {}
func (*SecretRelationship) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4b7da2d1fc45954, []int{2}
}
func (m *SecretRelationship) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SecretRelationship) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SecretRelationship.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SecretRelationship) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecretRelationship.Merge(m, src)
}
func (m *SecretRelationship) XXX_Size() int {
	return m.Size()
}
func (m *SecretRelationship) XXX_DiscardUnknown() {
	xxx_messageInfo_SecretRelationship.DiscardUnknown(m)
}

var xxx_messageInfo_SecretRelationship proto.InternalMessageInfo

func (m *SecretRelationship) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SecretRelationship) GetContainerRelationships() []*SecretContainerRelationship {
	if m != nil {
		return m.ContainerRelationships
	}
	return nil
}

func (m *SecretRelationship) GetDeploymentRelationships() []*SecretDeploymentRelationship {
	if m != nil {
		return m.DeploymentRelationships
	}
	return nil
}

func (m *SecretRelationship) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SecretRelationship) Clone() *SecretRelationship {
	if m == nil {
		return nil
	}
	cloned := new(SecretRelationship)
	*cloned = *m

	if m.ContainerRelationships != nil {
		cloned.ContainerRelationships = make([]*SecretContainerRelationship, len(m.ContainerRelationships))
		for idx, v := range m.ContainerRelationships {
			cloned.ContainerRelationships[idx] = v.Clone()
		}
	}
	if m.DeploymentRelationships != nil {
		cloned.DeploymentRelationships = make([]*SecretDeploymentRelationship, len(m.DeploymentRelationships))
		for idx, v := range m.DeploymentRelationships {
			cloned.DeploymentRelationships[idx] = v.Clone()
		}
	}
	return cloned
}

// Secrets can be used by a deployment.
// Next Tag: 3
type SecretDeploymentRelationship struct {
	// Id of the deployment using the secret within a container.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the deployment.
	Name                 string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SecretDeploymentRelationship) Reset()         { *m = SecretDeploymentRelationship{} }
func (m *SecretDeploymentRelationship) String() string { return proto.CompactTextString(m) }
func (*SecretDeploymentRelationship) ProtoMessage()    {}
func (*SecretDeploymentRelationship) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4b7da2d1fc45954, []int{3}
}
func (m *SecretDeploymentRelationship) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SecretDeploymentRelationship) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SecretDeploymentRelationship.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SecretDeploymentRelationship) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecretDeploymentRelationship.Merge(m, src)
}
func (m *SecretDeploymentRelationship) XXX_Size() int {
	return m.Size()
}
func (m *SecretDeploymentRelationship) XXX_DiscardUnknown() {
	xxx_messageInfo_SecretDeploymentRelationship.DiscardUnknown(m)
}

var xxx_messageInfo_SecretDeploymentRelationship proto.InternalMessageInfo

func (m *SecretDeploymentRelationship) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SecretDeploymentRelationship) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SecretDeploymentRelationship) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SecretDeploymentRelationship) Clone() *SecretDeploymentRelationship {
	if m == nil {
		return nil
	}
	cloned := new(SecretDeploymentRelationship)
	*cloned = *m

	return cloned
}

// Secrets can be mounted in a path in a container.
// Next Tag: 3
type SecretContainerRelationship struct {
	// Id of the container the secret is mounted in.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Path is a container specific mounting directory.
	Path                 string   `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SecretContainerRelationship) Reset()         { *m = SecretContainerRelationship{} }
func (m *SecretContainerRelationship) String() string { return proto.CompactTextString(m) }
func (*SecretContainerRelationship) ProtoMessage()    {}
func (*SecretContainerRelationship) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4b7da2d1fc45954, []int{4}
}
func (m *SecretContainerRelationship) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SecretContainerRelationship) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SecretContainerRelationship.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SecretContainerRelationship) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecretContainerRelationship.Merge(m, src)
}
func (m *SecretContainerRelationship) XXX_Size() int {
	return m.Size()
}
func (m *SecretContainerRelationship) XXX_DiscardUnknown() {
	xxx_messageInfo_SecretContainerRelationship.DiscardUnknown(m)
}

var xxx_messageInfo_SecretContainerRelationship proto.InternalMessageInfo

func (m *SecretContainerRelationship) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SecretContainerRelationship) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *SecretContainerRelationship) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SecretContainerRelationship) Clone() *SecretContainerRelationship {
	if m == nil {
		return nil
	}
	cloned := new(SecretContainerRelationship)
	*cloned = *m

	return cloned
}

type ImagePullSecret struct {
	Registries           []*ImagePullSecret_Registry `protobuf:"bytes,1,rep,name=registries,proto3" json:"registries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *ImagePullSecret) Reset()         { *m = ImagePullSecret{} }
func (m *ImagePullSecret) String() string { return proto.CompactTextString(m) }
func (*ImagePullSecret) ProtoMessage()    {}
func (*ImagePullSecret) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4b7da2d1fc45954, []int{5}
}
func (m *ImagePullSecret) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImagePullSecret) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImagePullSecret.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImagePullSecret) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImagePullSecret.Merge(m, src)
}
func (m *ImagePullSecret) XXX_Size() int {
	return m.Size()
}
func (m *ImagePullSecret) XXX_DiscardUnknown() {
	xxx_messageInfo_ImagePullSecret.DiscardUnknown(m)
}

var xxx_messageInfo_ImagePullSecret proto.InternalMessageInfo

func (m *ImagePullSecret) GetRegistries() []*ImagePullSecret_Registry {
	if m != nil {
		return m.Registries
	}
	return nil
}

func (m *ImagePullSecret) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ImagePullSecret) Clone() *ImagePullSecret {
	if m == nil {
		return nil
	}
	cloned := new(ImagePullSecret)
	*cloned = *m

	if m.Registries != nil {
		cloned.Registries = make([]*ImagePullSecret_Registry, len(m.Registries))
		for idx, v := range m.Registries {
			cloned.Registries[idx] = v.Clone()
		}
	}
	return cloned
}

type ImagePullSecret_Registry struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty" search:"Image Pull Secret Registry,store"`
	Username             string   `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImagePullSecret_Registry) Reset()         { *m = ImagePullSecret_Registry{} }
func (m *ImagePullSecret_Registry) String() string { return proto.CompactTextString(m) }
func (*ImagePullSecret_Registry) ProtoMessage()    {}
func (*ImagePullSecret_Registry) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4b7da2d1fc45954, []int{5, 0}
}
func (m *ImagePullSecret_Registry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImagePullSecret_Registry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImagePullSecret_Registry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImagePullSecret_Registry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImagePullSecret_Registry.Merge(m, src)
}
func (m *ImagePullSecret_Registry) XXX_Size() int {
	return m.Size()
}
func (m *ImagePullSecret_Registry) XXX_DiscardUnknown() {
	xxx_messageInfo_ImagePullSecret_Registry.DiscardUnknown(m)
}

var xxx_messageInfo_ImagePullSecret_Registry proto.InternalMessageInfo

func (m *ImagePullSecret_Registry) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ImagePullSecret_Registry) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *ImagePullSecret_Registry) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ImagePullSecret_Registry) Clone() *ImagePullSecret_Registry {
	if m == nil {
		return nil
	}
	cloned := new(ImagePullSecret_Registry)
	*cloned = *m

	return cloned
}

// Metadata about secret. Additional information is presented for a certificate file and
// imagePullSecret, but the "file" may also represent some arbitrary value.
type SecretDataFile struct {
	Name string     `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Type SecretType `protobuf:"varint,2,opt,name=type,proto3,enum=storage.SecretType" json:"type,omitempty" search:"Secret Type"`
	// Types that are valid to be assigned to Metadata:
	//	*SecretDataFile_Cert
	//	*SecretDataFile_ImagePullSecret
	Metadata             isSecretDataFile_Metadata `protobuf_oneof:"metadata"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *SecretDataFile) Reset()         { *m = SecretDataFile{} }
func (m *SecretDataFile) String() string { return proto.CompactTextString(m) }
func (*SecretDataFile) ProtoMessage()    {}
func (*SecretDataFile) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4b7da2d1fc45954, []int{6}
}
func (m *SecretDataFile) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SecretDataFile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SecretDataFile.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SecretDataFile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecretDataFile.Merge(m, src)
}
func (m *SecretDataFile) XXX_Size() int {
	return m.Size()
}
func (m *SecretDataFile) XXX_DiscardUnknown() {
	xxx_messageInfo_SecretDataFile.DiscardUnknown(m)
}

var xxx_messageInfo_SecretDataFile proto.InternalMessageInfo

type isSecretDataFile_Metadata interface {
	isSecretDataFile_Metadata()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isSecretDataFile_Metadata
}

type SecretDataFile_Cert struct {
	Cert *Cert `protobuf:"bytes,3,opt,name=cert,proto3,oneof" json:"cert,omitempty"`
}
type SecretDataFile_ImagePullSecret struct {
	ImagePullSecret *ImagePullSecret `protobuf:"bytes,4,opt,name=image_pull_secret,json=imagePullSecret,proto3,oneof" json:"image_pull_secret,omitempty"`
}

func (*SecretDataFile_Cert) isSecretDataFile_Metadata() {}
func (m *SecretDataFile_Cert) Clone() isSecretDataFile_Metadata {
	if m == nil {
		return nil
	}
	cloned := new(SecretDataFile_Cert)
	*cloned = *m

	cloned.Cert = m.Cert.Clone()
	return cloned
}
func (*SecretDataFile_ImagePullSecret) isSecretDataFile_Metadata() {}
func (m *SecretDataFile_ImagePullSecret) Clone() isSecretDataFile_Metadata {
	if m == nil {
		return nil
	}
	cloned := new(SecretDataFile_ImagePullSecret)
	*cloned = *m

	cloned.ImagePullSecret = m.ImagePullSecret.Clone()
	return cloned
}

func (m *SecretDataFile) GetMetadata() isSecretDataFile_Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *SecretDataFile) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SecretDataFile) GetType() SecretType {
	if m != nil {
		return m.Type
	}
	return SecretType_UNDETERMINED
}

func (m *SecretDataFile) GetCert() *Cert {
	if x, ok := m.GetMetadata().(*SecretDataFile_Cert); ok {
		return x.Cert
	}
	return nil
}

func (m *SecretDataFile) GetImagePullSecret() *ImagePullSecret {
	if x, ok := m.GetMetadata().(*SecretDataFile_ImagePullSecret); ok {
		return x.ImagePullSecret
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SecretDataFile) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SecretDataFile_Cert)(nil),
		(*SecretDataFile_ImagePullSecret)(nil),
	}
}

func (m *SecretDataFile) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SecretDataFile) Clone() *SecretDataFile {
	if m == nil {
		return nil
	}
	cloned := new(SecretDataFile)
	*cloned = *m

	if m.Metadata != nil {
		cloned.Metadata = m.Metadata.Clone()
	}
	return cloned
}

type Cert struct {
	Subject              *CertName        `protobuf:"bytes,1,opt,name=subject,proto3" json:"subject,omitempty"`
	Issuer               *CertName        `protobuf:"bytes,2,opt,name=issuer,proto3" json:"issuer,omitempty"`
	Sans                 []string         `protobuf:"bytes,3,rep,name=sans,proto3" json:"sans,omitempty"`
	StartDate            *types.Timestamp `protobuf:"bytes,4,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	EndDate              *types.Timestamp `protobuf:"bytes,5,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty" search:"Cert Expiration"`
	Algorithm            string           `protobuf:"bytes,6,opt,name=algorithm,proto3" json:"algorithm,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Cert) Reset()         { *m = Cert{} }
func (m *Cert) String() string { return proto.CompactTextString(m) }
func (*Cert) ProtoMessage()    {}
func (*Cert) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4b7da2d1fc45954, []int{7}
}
func (m *Cert) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cert) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Cert.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Cert) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cert.Merge(m, src)
}
func (m *Cert) XXX_Size() int {
	return m.Size()
}
func (m *Cert) XXX_DiscardUnknown() {
	xxx_messageInfo_Cert.DiscardUnknown(m)
}

var xxx_messageInfo_Cert proto.InternalMessageInfo

func (m *Cert) GetSubject() *CertName {
	if m != nil {
		return m.Subject
	}
	return nil
}

func (m *Cert) GetIssuer() *CertName {
	if m != nil {
		return m.Issuer
	}
	return nil
}

func (m *Cert) GetSans() []string {
	if m != nil {
		return m.Sans
	}
	return nil
}

func (m *Cert) GetStartDate() *types.Timestamp {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *Cert) GetEndDate() *types.Timestamp {
	if m != nil {
		return m.EndDate
	}
	return nil
}

func (m *Cert) GetAlgorithm() string {
	if m != nil {
		return m.Algorithm
	}
	return ""
}

func (m *Cert) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Cert) Clone() *Cert {
	if m == nil {
		return nil
	}
	cloned := new(Cert)
	*cloned = *m

	cloned.Subject = m.Subject.Clone()
	cloned.Issuer = m.Issuer.Clone()
	if m.Sans != nil {
		cloned.Sans = make([]string, len(m.Sans))
		copy(cloned.Sans, m.Sans)
	}
	cloned.StartDate = m.StartDate.Clone()
	cloned.EndDate = m.EndDate.Clone()
	return cloned
}

type CertName struct {
	CommonName           string   `protobuf:"bytes,1,opt,name=common_name,json=commonName,proto3" json:"common_name,omitempty"`
	Country              string   `protobuf:"bytes,2,opt,name=country,proto3" json:"country,omitempty"`
	Organization         string   `protobuf:"bytes,3,opt,name=organization,proto3" json:"organization,omitempty"`
	OrganizationUnit     string   `protobuf:"bytes,4,opt,name=organization_unit,json=organizationUnit,proto3" json:"organization_unit,omitempty"`
	Locality             string   `protobuf:"bytes,5,opt,name=locality,proto3" json:"locality,omitempty"`
	Province             string   `protobuf:"bytes,6,opt,name=province,proto3" json:"province,omitempty"`
	StreetAddress        string   `protobuf:"bytes,7,opt,name=street_address,json=streetAddress,proto3" json:"street_address,omitempty"`
	PostalCode           string   `protobuf:"bytes,8,opt,name=postal_code,json=postalCode,proto3" json:"postal_code,omitempty"`
	Names                []string `protobuf:"bytes,9,rep,name=names,proto3" json:"names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CertName) Reset()         { *m = CertName{} }
func (m *CertName) String() string { return proto.CompactTextString(m) }
func (*CertName) ProtoMessage()    {}
func (*CertName) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4b7da2d1fc45954, []int{8}
}
func (m *CertName) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CertName) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CertName.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CertName) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CertName.Merge(m, src)
}
func (m *CertName) XXX_Size() int {
	return m.Size()
}
func (m *CertName) XXX_DiscardUnknown() {
	xxx_messageInfo_CertName.DiscardUnknown(m)
}

var xxx_messageInfo_CertName proto.InternalMessageInfo

func (m *CertName) GetCommonName() string {
	if m != nil {
		return m.CommonName
	}
	return ""
}

func (m *CertName) GetCountry() string {
	if m != nil {
		return m.Country
	}
	return ""
}

func (m *CertName) GetOrganization() string {
	if m != nil {
		return m.Organization
	}
	return ""
}

func (m *CertName) GetOrganizationUnit() string {
	if m != nil {
		return m.OrganizationUnit
	}
	return ""
}

func (m *CertName) GetLocality() string {
	if m != nil {
		return m.Locality
	}
	return ""
}

func (m *CertName) GetProvince() string {
	if m != nil {
		return m.Province
	}
	return ""
}

func (m *CertName) GetStreetAddress() string {
	if m != nil {
		return m.StreetAddress
	}
	return ""
}

func (m *CertName) GetPostalCode() string {
	if m != nil {
		return m.PostalCode
	}
	return ""
}

func (m *CertName) GetNames() []string {
	if m != nil {
		return m.Names
	}
	return nil
}

func (m *CertName) MessageClone() proto.Message {
	return m.Clone()
}
func (m *CertName) Clone() *CertName {
	if m == nil {
		return nil
	}
	cloned := new(CertName)
	*cloned = *m

	if m.Names != nil {
		cloned.Names = make([]string, len(m.Names))
		copy(cloned.Names, m.Names)
	}
	return cloned
}

func init() {
	proto.RegisterEnum("storage.SecretType", SecretType_name, SecretType_value)
	proto.RegisterType((*Secret)(nil), "storage.Secret")
	proto.RegisterMapType((map[string]string)(nil), "storage.Secret.AnnotationsEntry")
	proto.RegisterMapType((map[string]string)(nil), "storage.Secret.LabelsEntry")
	proto.RegisterType((*ListSecret)(nil), "storage.ListSecret")
	proto.RegisterType((*SecretRelationship)(nil), "storage.SecretRelationship")
	proto.RegisterType((*SecretDeploymentRelationship)(nil), "storage.SecretDeploymentRelationship")
	proto.RegisterType((*SecretContainerRelationship)(nil), "storage.SecretContainerRelationship")
	proto.RegisterType((*ImagePullSecret)(nil), "storage.ImagePullSecret")
	proto.RegisterType((*ImagePullSecret_Registry)(nil), "storage.ImagePullSecret.Registry")
	proto.RegisterType((*SecretDataFile)(nil), "storage.SecretDataFile")
	proto.RegisterType((*Cert)(nil), "storage.Cert")
	proto.RegisterType((*CertName)(nil), "storage.CertName")
}

func init() { proto.RegisterFile("storage/secret.proto", fileDescriptor_b4b7da2d1fc45954) }

var fileDescriptor_b4b7da2d1fc45954 = []byte{
	// 1271 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x56, 0xcd, 0x6e, 0xdb, 0xc6,
	0x16, 0x36, 0xf5, 0x67, 0xe9, 0xc8, 0x71, 0xe4, 0x89, 0x13, 0x33, 0x8a, 0x61, 0x29, 0xbc, 0x09,
	0xe0, 0xdc, 0x24, 0x32, 0xe0, 0xdc, 0xc5, 0x8d, 0x71, 0x6f, 0x0b, 0x89, 0x62, 0x62, 0xa1, 0x8e,
	0xaa, 0x52, 0x72, 0x81, 0x14, 0x28, 0xd8, 0x31, 0x39, 0x91, 0xd9, 0x50, 0xa4, 0xca, 0x19, 0x05,
	0x51, 0xb7, 0x7d, 0x89, 0x2e, 0xdb, 0x7d, 0xdf, 0xa1, 0xdb, 0x2e, 0xbb, 0xeb, 0x4e, 0x08, 0x52,
	0xf4, 0x05, 0xf4, 0x04, 0xc5, 0xcc, 0x90, 0x32, 0xc9, 0xb8, 0x49, 0xbb, 0xe3, 0x7c, 0xf3, 0x7d,
	0x67, 0xe6, 0x9c, 0xf9, 0xe6, 0x0c, 0x61, 0x9b, 0xb2, 0x20, 0xc4, 0x63, 0x72, 0x40, 0x89, 0x1d,
	0x12, 0xd6, 0x9a, 0x86, 0x01, 0x0b, 0xd0, 0x7a, 0x84, 0xd6, 0x1b, 0xe3, 0x20, 0x18, 0x7b, 0xe4,
	0x40, 0xc0, 0x67, 0xb3, 0x17, 0x07, 0xcc, 0x9d, 0x10, 0xca, 0xf0, 0x64, 0x2a, 0x99, 0xf5, 0xed,
	0x71, 0x30, 0x0e, 0xc4, 0xe7, 0x01, 0xff, 0x92, 0xa8, 0xf6, 0x5d, 0x09, 0x4a, 0x43, 0x11, 0x10,
	0xfd, 0x0f, 0x72, 0xae, 0xa3, 0x2a, 0x4d, 0x65, 0xbf, 0xd2, 0x79, 0xb0, 0x5c, 0x34, 0xf6, 0x29,
	0xc1, 0xa1, 0x7d, 0x7e, 0xa4, 0xc9, 0xf9, 0x66, 0xaf, 0xfb, 0x80, 0x2f, 0x46, 0x1e, 0x9c, 0xbb,
	0x8e, 0x43, 0x7c, 0xad, 0x49, 0xbf, 0xf1, 0x8e, 0xb4, 0xe9, 0x4b, 0xcd, 0xcc, 0xb9, 0x0e, 0x7a,
	0x08, 0x05, 0x1f, 0x4f, 0x88, 0x9a, 0x13, 0xfa, 0x9b, 0xcb, 0x45, 0xe3, 0x7a, 0x5a, 0x2f, 0xc5,
	0x9a, 0x29, 0x68, 0x48, 0x07, 0xb0, 0xbd, 0x19, 0x65, 0x24, 0xb4, 0x5c, 0x47, 0xcd, 0x0b, 0xd1,
	0x9d, 0xe5, 0xa2, 0xd1, 0x8c, 0x45, 0xba, 0x9c, 0x7d, 0x67, 0x55, 0xb3, 0x12, 0xe9, 0x7a, 0x0e,
	0xfa, 0x3f, 0x6c, 0xc4, 0x41, 0xc4, 0xda, 0x05, 0x11, 0xa6, 0xbe, 0x5c, 0x34, 0x6e, 0x64, 0xc2,
	0xc4, 0x8b, 0x57, 0x23, 0x7e, 0x9f, 0xef, 0xe1, 0x08, 0x2a, 0x5c, 0x46, 0xa7, 0xd8, 0x26, 0x6a,
	0x51, 0x68, 0x77, 0x97, 0x8b, 0x86, 0x1a, 0x6b, 0xfb, 0xf1, 0x64, 0xac, 0xbe, 0xa0, 0x23, 0x04,
	0x05, 0x36, 0x9f, 0x12, 0xb5, 0xc4, 0x65, 0xa6, 0xf8, 0x46, 0x8f, 0xa0, 0xe4, 0xe1, 0x33, 0xe2,
	0x51, 0x75, 0xbd, 0x99, 0xdf, 0xaf, 0x1e, 0xde, 0x6a, 0x45, 0x87, 0xd3, 0x92, 0x15, 0x68, 0x9d,
	0x88, 0x59, 0xc3, 0x67, 0xe1, 0xdc, 0x8c, 0xa8, 0xa8, 0x03, 0x55, 0xec, 0xfb, 0x01, 0xc3, 0xcc,
	0x0d, 0x7c, 0xaa, 0x96, 0x85, 0xb2, 0x99, 0x55, 0xb6, 0x2f, 0x28, 0x52, 0x9e, 0x14, 0xa1, 0x11,
	0x80, 0x1d, 0x12, 0xcc, 0x88, 0x63, 0x61, 0xa6, 0x56, 0x9a, 0xca, 0x7e, 0xf5, 0xb0, 0xde, 0x92,
	0x86, 0x68, 0xc5, 0x86, 0x68, 0x8d, 0x62, 0x43, 0xa4, 0x4f, 0x47, 0x97, 0xca, 0x26, 0x9f, 0xe6,
	0xd5, 0x95, 0xc3, 0x36, 0x43, 0x0f, 0xa1, 0xf8, 0xc2, 0xf5, 0x08, 0x55, 0x41, 0xec, 0x69, 0x27,
	0xb3, 0xa7, 0x2e, 0x66, 0xf8, 0x89, 0xeb, 0x11, 0x53, 0xb2, 0xd0, 0xc7, 0xb0, 0x11, 0x12, 0x4f,
	0xee, 0xe8, 0xdc, 0x9d, 0xaa, 0x55, 0xb1, 0x8d, 0x6c, 0x0d, 0xcc, 0x04, 0xc5, 0x4c, 0x09, 0xea,
	0x8f, 0xa1, 0x9a, 0x28, 0x10, 0xaa, 0x41, 0xfe, 0x25, 0x99, 0x4b, 0x3f, 0x9a, 0xfc, 0x13, 0x6d,
	0x43, 0xf1, 0x15, 0xf6, 0x66, 0x91, 0xc7, 0x4c, 0x39, 0x38, 0xca, 0xfd, 0x57, 0xa9, 0x7f, 0x04,
	0xb5, 0x6c, 0x85, 0xfe, 0x89, 0x5e, 0xfb, 0x4d, 0x01, 0x38, 0x71, 0x29, 0x8b, 0x6e, 0xc2, 0xe6,
	0xc5, 0x4d, 0x10, 0xde, 0x46, 0x49, 0x6f, 0x47, 0x06, 0xbe, 0x9d, 0xf1, 0x9e, 0xb0, 0x70, 0xda,
	0x5f, 0xbb, 0x49, 0x7f, 0x09, 0x6f, 0x26, 0x1d, 0x74, 0x0f, 0x8a, 0xdc, 0x35, 0x54, 0x2d, 0x36,
	0xf3, 0xfb, 0x9b, 0x87, 0xd7, 0x32, 0x85, 0x1a, 0xcd, 0xa7, 0xc4, 0x94, 0x0c, 0xf4, 0x38, 0x75,
	0xbe, 0xa5, 0x0f, 0x9d, 0x6f, 0xe2, 0x10, 0xb5, 0x3f, 0x14, 0x40, 0xef, 0x56, 0xfe, 0x9d, 0x0c,
	0xbf, 0x84, 0x1d, 0x3b, 0xf0, 0x19, 0x76, 0x7d, 0x12, 0x5a, 0xc9, 0x53, 0xa1, 0x6a, 0x41, 0x9c,
	0xfe, 0x9d, 0xcc, 0xf6, 0xf4, 0x98, 0x9d, 0x3a, 0xd0, 0x1b, 0xf6, 0x65, 0x30, 0x45, 0x5f, 0x81,
	0xea, 0x90, 0xa9, 0x17, 0xcc, 0x27, 0xc4, 0x67, 0x99, 0xf8, 0x45, 0x11, 0xff, 0x6e, 0xd6, 0x5d,
	0x2b, 0x7a, 0x6a, 0x81, 0x1d, 0xe7, 0x52, 0x9c, 0x6a, 0x1d, 0xd8, 0x7d, 0x9f, 0xf0, 0xef, 0x1c,
	0xa9, 0xd6, 0x86, 0x5b, 0xef, 0x49, 0xee, 0xb2, 0x10, 0x53, 0xcc, 0xce, 0xe3, 0x10, 0xfc, 0x5b,
	0xfb, 0x59, 0x81, 0xab, 0xbd, 0x09, 0x1e, 0x93, 0xc1, 0xcc, 0xf3, 0x22, 0x37, 0xb5, 0x01, 0x42,
	0x32, 0x76, 0x29, 0x0b, 0x5d, 0x42, 0x55, 0x45, 0xa4, 0x7b, 0x7b, 0x95, 0x6e, 0x86, 0xdd, 0x32,
	0x25, 0x75, 0x6e, 0x26, 0x44, 0x75, 0x17, 0xca, 0x31, 0x8e, 0xda, 0xd1, 0xce, 0x65, 0xa3, 0x7e,
	0xb8, 0x5c, 0x34, 0xee, 0xc5, 0x57, 0x59, 0xc4, 0x6a, 0xf2, 0x60, 0xcd, 0xa8, 0x67, 0xc7, 0xaa,
	0x74, 0xf3, 0xad, 0x43, 0x79, 0x46, 0x49, 0x98, 0x28, 0xc0, 0x6a, 0xac, 0xbd, 0x51, 0x60, 0x33,
	0x7d, 0xc1, 0x57, 0xb5, 0x52, 0x12, 0xf6, 0x6f, 0x47, 0xfd, 0x8f, 0xcb, 0x2f, 0x37, 0x6f, 0x47,
	0x5d, 0x2e, 0x1a, 0xdb, 0x99, 0x37, 0x84, 0x4f, 0x68, 0x51, 0xbb, 0xfc, 0x17, 0x14, 0x6c, 0x12,
	0x32, 0x71, 0x73, 0xaa, 0x87, 0x57, 0x56, 0x21, 0x74, 0x12, 0xb2, 0xe3, 0x35, 0x53, 0x4c, 0xa2,
	0x27, 0xb0, 0xe5, 0xf2, 0xac, 0xac, 0xe9, 0xcc, 0xf3, 0x2c, 0xf9, 0xf4, 0x89, 0xbb, 0x54, 0x3d,
	0x54, 0xff, 0xaa, 0x86, 0xc7, 0x6b, 0xe6, 0x55, 0x37, 0x0d, 0x75, 0x00, 0xca, 0x13, 0xc2, 0xb0,
	0x83, 0x19, 0xd6, 0x7e, 0xc8, 0x41, 0x81, 0x2f, 0x82, 0xee, 0xc3, 0x3a, 0x9d, 0x9d, 0x7d, 0x4d,
	0x6c, 0x26, 0x72, 0xab, 0x1e, 0x6e, 0xa5, 0x36, 0xc1, 0x2f, 0xb1, 0x19, 0x33, 0xd0, 0x3d, 0x28,
	0xb9, 0x94, 0xce, 0x48, 0x28, 0x72, 0xbe, 0x94, 0x1b, 0x11, 0x78, 0xc1, 0x28, 0xf6, 0xa9, 0x9a,
	0x6f, 0xe6, 0x79, 0xc1, 0xf8, 0x37, 0xbf, 0xc3, 0x94, 0xe1, 0x90, 0x59, 0x0e, 0x66, 0x24, 0xca,
	0xe0, 0xbd, 0x77, 0x58, 0xb0, 0xbb, 0x98, 0x11, 0x34, 0x84, 0x32, 0xf1, 0x1d, 0x29, 0x2c, 0x7e,
	0xb0, 0xb9, 0xa7, 0x9e, 0x30, 0xbe, 0xb5, 0xa6, 0xf1, 0x7a, 0xea, 0x86, 0xc2, 0xc7, 0x9a, 0xb9,
	0x4e, 0x7c, 0x47, 0x04, 0xdd, 0x85, 0x0a, 0xf6, 0xc6, 0x41, 0xe8, 0xb2, 0xf3, 0x49, 0xf4, 0x8a,
	0x5d, 0x00, 0xda, 0x4f, 0x39, 0x28, 0xc7, 0x69, 0xa1, 0x06, 0x54, 0xed, 0x60, 0x32, 0x09, 0x7c,
	0x2b, 0x61, 0x03, 0x90, 0x90, 0x20, 0xa8, 0xb0, 0x6e, 0x07, 0x33, 0xde, 0x75, 0x23, 0x3b, 0xc5,
	0x43, 0xa4, 0xc1, 0x46, 0x10, 0x8e, 0xb1, 0xef, 0x7e, 0x2b, 0xd6, 0x8f, 0xba, 0x64, 0x0a, 0x43,
	0xf7, 0x61, 0x2b, 0x39, 0xb6, 0x66, 0xbe, 0xcb, 0xa2, 0x76, 0x59, 0x4b, 0x4e, 0x9c, 0xfa, 0x2e,
	0xe3, 0xd6, 0xf5, 0x02, 0x1b, 0x7b, 0x2e, 0x9b, 0xcb, 0x27, 0xdb, 0x5c, 0x8d, 0xf9, 0xdc, 0x34,
	0x0c, 0x5e, 0xb9, 0xbe, 0x1d, 0xbf, 0xcb, 0xab, 0x31, 0xba, 0x0b, 0x9b, 0x94, 0x85, 0x84, 0x30,
	0x0b, 0x3b, 0x4e, 0x48, 0x28, 0x7f, 0xa3, 0x39, 0xe3, 0x8a, 0x44, 0xdb, 0x12, 0xe4, 0xa9, 0x4e,
	0x03, 0xca, 0xb0, 0x67, 0xd9, 0x81, 0x43, 0xd4, 0xb2, 0x4c, 0x55, 0x42, 0x7a, 0xe0, 0x10, 0xfe,
	0x86, 0x88, 0x16, 0xae, 0x56, 0xc4, 0xd9, 0xca, 0xc1, 0xbf, 0x7f, 0xcc, 0x01, 0x5c, 0x38, 0x1f,
	0xd5, 0x60, 0xe3, 0xb4, 0xdf, 0x35, 0x46, 0x86, 0xf9, 0xac, 0xd7, 0x37, 0xba, 0xb5, 0x35, 0x74,
	0x03, 0xd0, 0xe0, 0xb4, 0x73, 0xd2, 0xd3, 0x2d, 0xdd, 0x30, 0x47, 0xbd, 0x27, 0x3d, 0xbd, 0x3d,
	0x32, 0x6a, 0x0a, 0xda, 0x81, 0x6b, 0x09, 0xc0, 0x32, 0x8d, 0xcf, 0x4e, 0x8d, 0xe1, 0xa8, 0x96,
	0x43, 0xbb, 0xa0, 0x0e, 0xcc, 0xde, 0xe7, 0x6d, 0xfd, 0xb9, 0x65, 0xf4, 0x8f, 0xdb, 0x7d, 0xdd,
	0xe8, 0x5a, 0xcf, 0x8c, 0xe1, 0xb0, 0xfd, 0xd4, 0xa8, 0xe5, 0xb9, 0xec, 0xd3, 0x81, 0xd1, 0x1f,
	0x0e, 0x8f, 0x2d, 0xc1, 0x1a, 0x19, 0xd6, 0x27, 0xc6, 0xf3, 0x5a, 0x01, 0x5d, 0x83, 0xab, 0x83,
	0xa7, 0x83, 0x14, 0x58, 0x44, 0x08, 0x36, 0x0d, 0x3d, 0x85, 0x95, 0x38, 0xd1, 0x1c, 0xb6, 0x53,
	0xe0, 0x3a, 0x07, 0xbb, 0x19, 0xb0, 0x8c, 0xb6, 0xa1, 0xc6, 0xb7, 0x98, 0x42, 0x2b, 0xe8, 0x26,
	0x5c, 0x37, 0xfa, 0xba, 0xf9, 0x7c, 0x30, 0x32, 0xba, 0xa9, 0x29, 0x40, 0xd7, 0x61, 0xab, 0xf7,
	0xac, 0xfd, 0xd4, 0xb0, 0x06, 0xa7, 0x27, 0x27, 0xd6, 0xd0, 0xd0, 0x4d, 0x63, 0x54, 0xab, 0x76,
	0xfe, 0xf3, 0xcb, 0xdb, 0x3d, 0xe5, 0xd7, 0xb7, 0x7b, 0xca, 0x9b, 0xb7, 0x7b, 0xca, 0xf7, 0xbf,
	0xef, 0xad, 0xc1, 0x4d, 0x37, 0x68, 0x51, 0x86, 0xed, 0x97, 0x61, 0xf0, 0x5a, 0x3a, 0x39, 0xbe,
	0x52, 0x5f, 0xc4, 0xbf, 0xb5, 0x67, 0x25, 0x81, 0x3f, 0xfa, 0x33, 0x00, 0x00, 0xff, 0xff, 0xd4,
	0x8d, 0x47, 0x9f, 0xfe, 0x0a, 0x00, 0x00,
}

func (m *Secret) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Secret) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Secret) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Relationship != nil {
		{
			size, err := m.Relationship.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecret(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if len(m.Files) > 0 {
		for iNdEx := len(m.Files) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Files[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSecret(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x52
		}
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecret(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if len(m.Annotations) > 0 {
		for k := range m.Annotations {
			v := m.Annotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintSecret(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintSecret(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintSecret(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintSecret(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintSecret(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintSecret(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListSecret) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListSecret) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListSecret) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecret(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.Types) > 0 {
		dAtA5 := make([]byte, len(m.Types)*10)
		var j4 int
		for _, num := range m.Types {
			for num >= 1<<7 {
				dAtA5[j4] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j4++
			}
			dAtA5[j4] = uint8(num)
			j4++
		}
		i -= j4
		copy(dAtA[i:], dAtA5[:j4])
		i = encodeVarintSecret(dAtA, i, uint64(j4))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SecretRelationship) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SecretRelationship) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SecretRelationship) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DeploymentRelationships) > 0 {
		for iNdEx := len(m.DeploymentRelationships) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DeploymentRelationships[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSecret(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.ContainerRelationships) > 0 {
		for iNdEx := len(m.ContainerRelationships) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ContainerRelationships[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSecret(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SecretDeploymentRelationship) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SecretDeploymentRelationship) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SecretDeploymentRelationship) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SecretContainerRelationship) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SecretContainerRelationship) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SecretContainerRelationship) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ImagePullSecret) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImagePullSecret) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImagePullSecret) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Registries) > 0 {
		for iNdEx := len(m.Registries) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Registries[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSecret(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ImagePullSecret_Registry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImagePullSecret_Registry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImagePullSecret_Registry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Username) > 0 {
		i -= len(m.Username)
		copy(dAtA[i:], m.Username)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Username)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SecretDataFile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SecretDataFile) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SecretDataFile) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Metadata != nil {
		{
			size := m.Metadata.Size()
			i -= size
			if _, err := m.Metadata.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Type != 0 {
		i = encodeVarintSecret(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SecretDataFile_Cert) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SecretDataFile_Cert) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Cert != nil {
		{
			size, err := m.Cert.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecret(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *SecretDataFile_ImagePullSecret) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SecretDataFile_ImagePullSecret) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ImagePullSecret != nil {
		{
			size, err := m.ImagePullSecret.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecret(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *Cert) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cert) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Cert) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Algorithm) > 0 {
		i -= len(m.Algorithm)
		copy(dAtA[i:], m.Algorithm)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Algorithm)))
		i--
		dAtA[i] = 0x32
	}
	if m.EndDate != nil {
		{
			size, err := m.EndDate.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecret(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.StartDate != nil {
		{
			size, err := m.StartDate.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecret(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Sans) > 0 {
		for iNdEx := len(m.Sans) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Sans[iNdEx])
			copy(dAtA[i:], m.Sans[iNdEx])
			i = encodeVarintSecret(dAtA, i, uint64(len(m.Sans[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Issuer != nil {
		{
			size, err := m.Issuer.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecret(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Subject != nil {
		{
			size, err := m.Subject.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecret(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CertName) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CertName) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CertName) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Names) > 0 {
		for iNdEx := len(m.Names) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Names[iNdEx])
			copy(dAtA[i:], m.Names[iNdEx])
			i = encodeVarintSecret(dAtA, i, uint64(len(m.Names[iNdEx])))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.PostalCode) > 0 {
		i -= len(m.PostalCode)
		copy(dAtA[i:], m.PostalCode)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.PostalCode)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.StreetAddress) > 0 {
		i -= len(m.StreetAddress)
		copy(dAtA[i:], m.StreetAddress)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.StreetAddress)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Province) > 0 {
		i -= len(m.Province)
		copy(dAtA[i:], m.Province)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Province)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Locality) > 0 {
		i -= len(m.Locality)
		copy(dAtA[i:], m.Locality)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Locality)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.OrganizationUnit) > 0 {
		i -= len(m.OrganizationUnit)
		copy(dAtA[i:], m.OrganizationUnit)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.OrganizationUnit)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Organization) > 0 {
		i -= len(m.Organization)
		copy(dAtA[i:], m.Organization)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Organization)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Country) > 0 {
		i -= len(m.Country)
		copy(dAtA[i:], m.Country)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.Country)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.CommonName) > 0 {
		i -= len(m.CommonName)
		copy(dAtA[i:], m.CommonName)
		i = encodeVarintSecret(dAtA, i, uint64(len(m.CommonName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintSecret(dAtA []byte, offset int, v uint64) int {
	offset -= sovSecret(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Secret) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovSecret(uint64(len(k))) + 1 + len(v) + sovSecret(uint64(len(v)))
			n += mapEntrySize + 1 + sovSecret(uint64(mapEntrySize))
		}
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovSecret(uint64(len(k))) + 1 + len(v) + sovSecret(uint64(len(v)))
			n += mapEntrySize + 1 + sovSecret(uint64(mapEntrySize))
		}
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovSecret(uint64(l))
	}
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovSecret(uint64(l))
		}
	}
	if m.Relationship != nil {
		l = m.Relationship.Size()
		n += 1 + l + sovSecret(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListSecret) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	if len(m.Types) > 0 {
		l = 0
		for _, e := range m.Types {
			l += sovSecret(uint64(e))
		}
		n += 1 + sovSecret(uint64(l)) + l
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovSecret(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SecretRelationship) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	if len(m.ContainerRelationships) > 0 {
		for _, e := range m.ContainerRelationships {
			l = e.Size()
			n += 1 + l + sovSecret(uint64(l))
		}
	}
	if len(m.DeploymentRelationships) > 0 {
		for _, e := range m.DeploymentRelationships {
			l = e.Size()
			n += 1 + l + sovSecret(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SecretDeploymentRelationship) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SecretContainerRelationship) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ImagePullSecret) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Registries) > 0 {
		for _, e := range m.Registries {
			l = e.Size()
			n += 1 + l + sovSecret(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ImagePullSecret_Registry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SecretDataFile) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovSecret(uint64(m.Type))
	}
	if m.Metadata != nil {
		n += m.Metadata.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SecretDataFile_Cert) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Cert != nil {
		l = m.Cert.Size()
		n += 1 + l + sovSecret(uint64(l))
	}
	return n
}
func (m *SecretDataFile_ImagePullSecret) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ImagePullSecret != nil {
		l = m.ImagePullSecret.Size()
		n += 1 + l + sovSecret(uint64(l))
	}
	return n
}
func (m *Cert) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Subject != nil {
		l = m.Subject.Size()
		n += 1 + l + sovSecret(uint64(l))
	}
	if m.Issuer != nil {
		l = m.Issuer.Size()
		n += 1 + l + sovSecret(uint64(l))
	}
	if len(m.Sans) > 0 {
		for _, s := range m.Sans {
			l = len(s)
			n += 1 + l + sovSecret(uint64(l))
		}
	}
	if m.StartDate != nil {
		l = m.StartDate.Size()
		n += 1 + l + sovSecret(uint64(l))
	}
	if m.EndDate != nil {
		l = m.EndDate.Size()
		n += 1 + l + sovSecret(uint64(l))
	}
	l = len(m.Algorithm)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CertName) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CommonName)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	l = len(m.Country)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	l = len(m.Organization)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	l = len(m.OrganizationUnit)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	l = len(m.Locality)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	l = len(m.Province)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	l = len(m.StreetAddress)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	l = len(m.PostalCode)
	if l > 0 {
		n += 1 + l + sovSecret(uint64(l))
	}
	if len(m.Names) > 0 {
		for _, s := range m.Names {
			l = len(s)
			n += 1 + l + sovSecret(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovSecret(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozSecret(x uint64) (n int) {
	return sovSecret(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Secret) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecret
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Secret: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Secret: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSecret
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSecret
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthSecret
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthSecret
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSecret
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthSecret
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthSecret
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipSecret(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthSecret
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Annotations == nil {
				m.Annotations = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSecret
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSecret
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthSecret
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthSecret
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSecret
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthSecret
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthSecret
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipSecret(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthSecret
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Annotations[mapkey] = mapvalue
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, &SecretDataFile{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Relationship", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Relationship == nil {
				m.Relationship = &SecretRelationship{}
			}
			if err := m.Relationship.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecret(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSecret
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListSecret) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecret
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListSecret: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListSecret: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType == 0 {
				var v SecretType
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSecret
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= SecretType(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Types = append(m.Types, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSecret
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthSecret
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthSecret
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.Types) == 0 {
					m.Types = make([]SecretType, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v SecretType
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSecret
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= SecretType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Types = append(m.Types, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Types", wireType)
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecret(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSecret
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SecretRelationship) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecret
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SecretRelationship: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SecretRelationship: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerRelationships", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerRelationships = append(m.ContainerRelationships, &SecretContainerRelationship{})
			if err := m.ContainerRelationships[len(m.ContainerRelationships)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentRelationships", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentRelationships = append(m.DeploymentRelationships, &SecretDeploymentRelationship{})
			if err := m.DeploymentRelationships[len(m.DeploymentRelationships)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecret(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSecret
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SecretDeploymentRelationship) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecret
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SecretDeploymentRelationship: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SecretDeploymentRelationship: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecret(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSecret
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SecretContainerRelationship) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecret
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SecretContainerRelationship: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SecretContainerRelationship: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecret(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSecret
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImagePullSecret) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecret
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImagePullSecret: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImagePullSecret: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Registries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Registries = append(m.Registries, &ImagePullSecret_Registry{})
			if err := m.Registries[len(m.Registries)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecret(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSecret
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImagePullSecret_Registry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecret
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Registry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Registry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecret(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSecret
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SecretDataFile) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecret
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SecretDataFile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SecretDataFile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= SecretType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cert", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Cert{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Metadata = &SecretDataFile_Cert{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ImagePullSecret", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ImagePullSecret{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Metadata = &SecretDataFile_ImagePullSecret{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecret(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSecret
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cert) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecret
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Cert: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Cert: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subject", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subject == nil {
				m.Subject = &CertName{}
			}
			if err := m.Subject.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Issuer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Issuer == nil {
				m.Issuer = &CertName{}
			}
			if err := m.Issuer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sans", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sans = append(m.Sans, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartDate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartDate == nil {
				m.StartDate = &types.Timestamp{}
			}
			if err := m.StartDate.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndDate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EndDate == nil {
				m.EndDate = &types.Timestamp{}
			}
			if err := m.EndDate.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Algorithm", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Algorithm = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecret(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSecret
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CertName) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecret
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CertName: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CertName: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommonName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CommonName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Country", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Country = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Organization", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Organization = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationUnit", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationUnit = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locality", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Locality = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Province", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Province = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StreetAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StreetAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PostalCode", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PostalCode = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Names", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecret
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecret
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Names = append(m.Names, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecret(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSecret
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSecret(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSecret
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSecret
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthSecret
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupSecret
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthSecret
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthSecret        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSecret          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupSecret = fmt.Errorf("proto: unexpected end of group")
)
