// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/sensor_upgrade.proto

package storage

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// SensorUpgradeConfig encapsulates configuration relevant to sensor auto-upgrades.
type SensorUpgradeConfig struct {
	// Whether to automatically trigger upgrades for out-of-date sensors.
	EnableAutoUpgrade    bool     `protobuf:"varint,1,opt,name=enable_auto_upgrade,json=enableAutoUpgrade,proto3" json:"enable_auto_upgrade,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SensorUpgradeConfig) Reset()         { *m = SensorUpgradeConfig{} }
func (m *SensorUpgradeConfig) String() string { return proto.CompactTextString(m) }
func (*SensorUpgradeConfig) ProtoMessage()    {}
func (*SensorUpgradeConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e0148125d586f21a, []int{0}
}
func (m *SensorUpgradeConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SensorUpgradeConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SensorUpgradeConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SensorUpgradeConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SensorUpgradeConfig.Merge(m, src)
}
func (m *SensorUpgradeConfig) XXX_Size() int {
	return m.Size()
}
func (m *SensorUpgradeConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SensorUpgradeConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SensorUpgradeConfig proto.InternalMessageInfo

func (m *SensorUpgradeConfig) GetEnableAutoUpgrade() bool {
	if m != nil {
		return m.EnableAutoUpgrade
	}
	return false
}

func (m *SensorUpgradeConfig) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SensorUpgradeConfig) Clone() *SensorUpgradeConfig {
	if m == nil {
		return nil
	}
	cloned := new(SensorUpgradeConfig)
	*cloned = *m

	return cloned
}

func init() {
	proto.RegisterType((*SensorUpgradeConfig)(nil), "storage.SensorUpgradeConfig")
}

func init() { proto.RegisterFile("storage/sensor_upgrade.proto", fileDescriptor_e0148125d586f21a) }

var fileDescriptor_e0148125d586f21a = []byte{
	// 152 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0x92, 0x29, 0x2e, 0xc9, 0x2f,
	0x4a, 0x4c, 0x4f, 0xd5, 0x2f, 0x4e, 0xcd, 0x2b, 0xce, 0x2f, 0x8a, 0x2f, 0x2d, 0x48, 0x2f, 0x4a,
	0x4c, 0x49, 0xd5, 0x2b, 0x28, 0xca, 0x2f, 0xc9, 0x17, 0x62, 0x87, 0xca, 0x2a, 0xb9, 0x72, 0x09,
	0x07, 0x83, 0x15, 0x84, 0x42, 0xe4, 0x9d, 0xf3, 0xf3, 0xd2, 0x32, 0xd3, 0x85, 0xf4, 0xb8, 0x84,
	0x53, 0xf3, 0x12, 0x93, 0x72, 0x52, 0xe3, 0x13, 0x4b, 0x4b, 0xf2, 0x61, 0x9a, 0x25, 0x18, 0x15,
	0x18, 0x35, 0x38, 0x82, 0x04, 0x21, 0x52, 0x8e, 0xa5, 0x25, 0xf9, 0x50, 0x5d, 0x4e, 0x26, 0x27,
	0x1e, 0xc9, 0x31, 0x5e, 0x78, 0x24, 0xc7, 0xf8, 0xe0, 0x91, 0x1c, 0xe3, 0x8c, 0xc7, 0x72, 0x0c,
	0x5c, 0x92, 0x99, 0xf9, 0x7a, 0xc5, 0x25, 0x89, 0xc9, 0xd9, 0x45, 0xf9, 0x15, 0x10, 0x4b, 0xf5,
	0xa0, 0x76, 0x46, 0xc1, 0x2c, 0x4f, 0x62, 0x03, 0x8b, 0x1b, 0x03, 0x02, 0x00, 0x00, 0xff, 0xff,
	0xe5, 0x9c, 0x5c, 0xe0, 0xac, 0x00, 0x00, 0x00,
}

func (m *SensorUpgradeConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SensorUpgradeConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SensorUpgradeConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.EnableAutoUpgrade {
		i--
		if m.EnableAutoUpgrade {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintSensorUpgrade(dAtA []byte, offset int, v uint64) int {
	offset -= sovSensorUpgrade(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *SensorUpgradeConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.EnableAutoUpgrade {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovSensorUpgrade(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozSensorUpgrade(x uint64) (n int) {
	return sovSensorUpgrade(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *SensorUpgradeConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSensorUpgrade
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SensorUpgradeConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SensorUpgradeConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableAutoUpgrade", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSensorUpgrade
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableAutoUpgrade = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipSensorUpgrade(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSensorUpgrade
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSensorUpgrade(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSensorUpgrade
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSensorUpgrade
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSensorUpgrade
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthSensorUpgrade
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupSensorUpgrade
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthSensorUpgrade
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthSensorUpgrade        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSensorUpgrade          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupSensorUpgrade = fmt.Errorf("proto: unexpected end of group")
)
