// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/vuln_requests.proto

package storage

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Indicates the status of a request. Requests canceled by the user before they are acted upon by the approver
// are not tracked/persisted (with the exception of audit logs if it is turned on).
type RequestStatus int32

const (
	// Default request state. It indicates that the request has not been fulfilled and that an action (approve/deny) is required.
	RequestStatus_PENDING RequestStatus = 0
	// Indicates that the request has been approved by the approver.
	RequestStatus_APPROVED RequestStatus = 1
	// Indicates that the request has been denied by the approver.
	RequestStatus_DENIED RequestStatus = 2
	// Indicates that the original request was approved, but an update is still pending an approval or denial.
	RequestStatus_APPROVED_PENDING_UPDATE RequestStatus = 3
)

var RequestStatus_name = map[int32]string{
	0: "PENDING",
	1: "APPROVED",
	2: "DENIED",
	3: "APPROVED_PENDING_UPDATE",
}

var RequestStatus_value = map[string]int32{
	"PENDING":                 0,
	"APPROVED":                1,
	"DENIED":                  2,
	"APPROVED_PENDING_UPDATE": 3,
}

func (x RequestStatus) String() string {
	return proto.EnumName(RequestStatus_name, int32(x))
}

func (RequestStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_878c2c8004fa26b3, []int{0}
}

type RequestComment struct {
	Id                   string           `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Message              string           `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	User                 *SlimUser        `protobuf:"bytes,3,opt,name=user,proto3" json:"user,omitempty"`
	CreatedAt            *types.Timestamp `protobuf:"bytes,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *RequestComment) Reset()         { *m = RequestComment{} }
func (m *RequestComment) String() string { return proto.CompactTextString(m) }
func (*RequestComment) ProtoMessage()    {}
func (*RequestComment) Descriptor() ([]byte, []int) {
	return fileDescriptor_878c2c8004fa26b3, []int{0}
}
func (m *RequestComment) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RequestComment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RequestComment.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RequestComment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestComment.Merge(m, src)
}
func (m *RequestComment) XXX_Size() int {
	return m.Size()
}
func (m *RequestComment) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestComment.DiscardUnknown(m)
}

var xxx_messageInfo_RequestComment proto.InternalMessageInfo

func (m *RequestComment) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *RequestComment) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *RequestComment) GetUser() *SlimUser {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *RequestComment) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *RequestComment) MessageClone() proto.Message {
	return m.Clone()
}
func (m *RequestComment) Clone() *RequestComment {
	if m == nil {
		return nil
	}
	cloned := new(RequestComment)
	*cloned = *m

	cloned.User = m.User.Clone()
	cloned.CreatedAt = m.CreatedAt.Clone()
	return cloned
}

type RequestExpiry struct {
	// Types that are valid to be assigned to Expiry:
	//	*RequestExpiry_ExpiresWhenFixed
	//	*RequestExpiry_ExpiresOn
	Expiry               isRequestExpiry_Expiry `protobuf_oneof:"expiry"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *RequestExpiry) Reset()         { *m = RequestExpiry{} }
func (m *RequestExpiry) String() string { return proto.CompactTextString(m) }
func (*RequestExpiry) ProtoMessage()    {}
func (*RequestExpiry) Descriptor() ([]byte, []int) {
	return fileDescriptor_878c2c8004fa26b3, []int{1}
}
func (m *RequestExpiry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RequestExpiry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RequestExpiry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RequestExpiry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestExpiry.Merge(m, src)
}
func (m *RequestExpiry) XXX_Size() int {
	return m.Size()
}
func (m *RequestExpiry) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestExpiry.DiscardUnknown(m)
}

var xxx_messageInfo_RequestExpiry proto.InternalMessageInfo

type isRequestExpiry_Expiry interface {
	isRequestExpiry_Expiry()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isRequestExpiry_Expiry
}

type RequestExpiry_ExpiresWhenFixed struct {
	ExpiresWhenFixed bool `protobuf:"varint,1,opt,name=expires_when_fixed,json=expiresWhenFixed,proto3,oneof" json:"expires_when_fixed,omitempty" search:"Request Expires When Fixed"`
}
type RequestExpiry_ExpiresOn struct {
	ExpiresOn *types.Timestamp `protobuf:"bytes,2,opt,name=expires_on,json=expiresOn,proto3,oneof" json:"expires_on,omitempty" search:"Request Expiry Time"`
}

func (*RequestExpiry_ExpiresWhenFixed) isRequestExpiry_Expiry() {}
func (m *RequestExpiry_ExpiresWhenFixed) Clone() isRequestExpiry_Expiry {
	if m == nil {
		return nil
	}
	cloned := new(RequestExpiry_ExpiresWhenFixed)
	*cloned = *m

	return cloned
}
func (*RequestExpiry_ExpiresOn) isRequestExpiry_Expiry() {}
func (m *RequestExpiry_ExpiresOn) Clone() isRequestExpiry_Expiry {
	if m == nil {
		return nil
	}
	cloned := new(RequestExpiry_ExpiresOn)
	*cloned = *m

	cloned.ExpiresOn = m.ExpiresOn.Clone()
	return cloned
}

func (m *RequestExpiry) GetExpiry() isRequestExpiry_Expiry {
	if m != nil {
		return m.Expiry
	}
	return nil
}

func (m *RequestExpiry) GetExpiresWhenFixed() bool {
	if x, ok := m.GetExpiry().(*RequestExpiry_ExpiresWhenFixed); ok {
		return x.ExpiresWhenFixed
	}
	return false
}

func (m *RequestExpiry) GetExpiresOn() *types.Timestamp {
	if x, ok := m.GetExpiry().(*RequestExpiry_ExpiresOn); ok {
		return x.ExpiresOn
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*RequestExpiry) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*RequestExpiry_ExpiresWhenFixed)(nil),
		(*RequestExpiry_ExpiresOn)(nil),
	}
}

func (m *RequestExpiry) MessageClone() proto.Message {
	return m.Clone()
}
func (m *RequestExpiry) Clone() *RequestExpiry {
	if m == nil {
		return nil
	}
	cloned := new(RequestExpiry)
	*cloned = *m

	if m.Expiry != nil {
		cloned.Expiry = m.Expiry.Clone()
	}
	return cloned
}

type DeferralRequest struct {
	Expiry               *RequestExpiry `protobuf:"bytes,1,opt,name=expiry,proto3" json:"expiry,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *DeferralRequest) Reset()         { *m = DeferralRequest{} }
func (m *DeferralRequest) String() string { return proto.CompactTextString(m) }
func (*DeferralRequest) ProtoMessage()    {}
func (*DeferralRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_878c2c8004fa26b3, []int{2}
}
func (m *DeferralRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeferralRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeferralRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeferralRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeferralRequest.Merge(m, src)
}
func (m *DeferralRequest) XXX_Size() int {
	return m.Size()
}
func (m *DeferralRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeferralRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeferralRequest proto.InternalMessageInfo

func (m *DeferralRequest) GetExpiry() *RequestExpiry {
	if m != nil {
		return m.Expiry
	}
	return nil
}

func (m *DeferralRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DeferralRequest) Clone() *DeferralRequest {
	if m == nil {
		return nil
	}
	cloned := new(DeferralRequest)
	*cloned = *m

	cloned.Expiry = m.Expiry.Clone()
	return cloned
}

type FalsePositiveRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FalsePositiveRequest) Reset()         { *m = FalsePositiveRequest{} }
func (m *FalsePositiveRequest) String() string { return proto.CompactTextString(m) }
func (*FalsePositiveRequest) ProtoMessage()    {}
func (*FalsePositiveRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_878c2c8004fa26b3, []int{3}
}
func (m *FalsePositiveRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FalsePositiveRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FalsePositiveRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FalsePositiveRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FalsePositiveRequest.Merge(m, src)
}
func (m *FalsePositiveRequest) XXX_Size() int {
	return m.Size()
}
func (m *FalsePositiveRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FalsePositiveRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FalsePositiveRequest proto.InternalMessageInfo

func (m *FalsePositiveRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *FalsePositiveRequest) Clone() *FalsePositiveRequest {
	if m == nil {
		return nil
	}
	cloned := new(FalsePositiveRequest)
	*cloned = *m

	return cloned
}

// Next available tag: 21
// VulnerabilityRequest encapsulates a request such as deferral request and false-positive request.
type VulnerabilityRequest struct {
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Indicates the state the vulnerabilities will move to once the request is complete.
	TargetState VulnerabilityState `protobuf:"varint,2,opt,name=target_state,json=targetState,proto3,enum=storage.VulnerabilityState" json:"target_state,omitempty" search:"Requested Vulnerability State"`
	// Indicates the status of a request.
	Status RequestStatus `protobuf:"varint,3,opt,name=status,proto3,enum=storage.RequestStatus" json:"status,omitempty" search:"Request Status"`
	// Indicates if this request is a historical request that is no longer in effect
	// due to deferral expiry, cancellation, or restarting cve observation.
	Expired     bool                        `protobuf:"varint,4,opt,name=expired,proto3" json:"expired,omitempty" search:"Expired Request"`
	Requestor   *SlimUser                   `protobuf:"bytes,5,opt,name=requestor,proto3" json:"requestor,omitempty"`
	Approvers   []*SlimUser                 `protobuf:"bytes,6,rep,name=approvers,proto3" json:"approvers,omitempty"`
	CreatedAt   *types.Timestamp            `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty" search:"Created Time"`
	LastUpdated *types.Timestamp            `protobuf:"bytes,8,opt,name=last_updated,json=lastUpdated,proto3" json:"last_updated,omitempty" search:"Last Updated"`
	Comments    []*RequestComment           `protobuf:"bytes,9,rep,name=comments,proto3" json:"comments,omitempty"`
	Scope       *VulnerabilityRequest_Scope `protobuf:"bytes,10,opt,name=scope,proto3" json:"scope,omitempty"`
	// 11 to 15 reserved for the request type oneof.
	//
	// Types that are valid to be assigned to Req:
	//	*VulnerabilityRequest_DeferralReq
	//	*VulnerabilityRequest_FpRequest
	Req isVulnerabilityRequest_Req `protobuf_oneof:"req"`
	// 16 to 20 reserved for entities oneof.
	//
	// Types that are valid to be assigned to Entities:
	//	*VulnerabilityRequest_Cves
	Entities isVulnerabilityRequest_Entities `protobuf_oneof:"entities"`
	// 21 to 25 reserved for the updated request type oneof.
	//
	// Types that are valid to be assigned to UpdatedReq:
	//	*VulnerabilityRequest_UpdatedDeferralReq
	UpdatedReq           isVulnerabilityRequest_UpdatedReq `protobuf_oneof:"updated_req"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *VulnerabilityRequest) Reset()         { *m = VulnerabilityRequest{} }
func (m *VulnerabilityRequest) String() string { return proto.CompactTextString(m) }
func (*VulnerabilityRequest) ProtoMessage()    {}
func (*VulnerabilityRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_878c2c8004fa26b3, []int{4}
}
func (m *VulnerabilityRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VulnerabilityRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VulnerabilityRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VulnerabilityRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnerabilityRequest.Merge(m, src)
}
func (m *VulnerabilityRequest) XXX_Size() int {
	return m.Size()
}
func (m *VulnerabilityRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnerabilityRequest.DiscardUnknown(m)
}

var xxx_messageInfo_VulnerabilityRequest proto.InternalMessageInfo

type isVulnerabilityRequest_Req interface {
	isVulnerabilityRequest_Req()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isVulnerabilityRequest_Req
}
type isVulnerabilityRequest_Entities interface {
	isVulnerabilityRequest_Entities()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isVulnerabilityRequest_Entities
}
type isVulnerabilityRequest_UpdatedReq interface {
	isVulnerabilityRequest_UpdatedReq()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isVulnerabilityRequest_UpdatedReq
}

type VulnerabilityRequest_DeferralReq struct {
	DeferralReq *DeferralRequest `protobuf:"bytes,11,opt,name=deferral_req,json=deferralReq,proto3,oneof" json:"deferral_req,omitempty"`
}
type VulnerabilityRequest_FpRequest struct {
	FpRequest *FalsePositiveRequest `protobuf:"bytes,12,opt,name=fp_request,json=fpRequest,proto3,oneof" json:"fp_request,omitempty"`
}
type VulnerabilityRequest_Cves struct {
	Cves *VulnerabilityRequest_CVEs `protobuf:"bytes,16,opt,name=cves,proto3,oneof" json:"cves,omitempty"`
}
type VulnerabilityRequest_UpdatedDeferralReq struct {
	UpdatedDeferralReq *DeferralRequest `protobuf:"bytes,21,opt,name=updated_deferral_req,json=updatedDeferralReq,proto3,oneof" json:"updated_deferral_req,omitempty" search:"-"`
}

func (*VulnerabilityRequest_DeferralReq) isVulnerabilityRequest_Req() {}
func (m *VulnerabilityRequest_DeferralReq) Clone() isVulnerabilityRequest_Req {
	if m == nil {
		return nil
	}
	cloned := new(VulnerabilityRequest_DeferralReq)
	*cloned = *m

	cloned.DeferralReq = m.DeferralReq.Clone()
	return cloned
}
func (*VulnerabilityRequest_FpRequest) isVulnerabilityRequest_Req() {}
func (m *VulnerabilityRequest_FpRequest) Clone() isVulnerabilityRequest_Req {
	if m == nil {
		return nil
	}
	cloned := new(VulnerabilityRequest_FpRequest)
	*cloned = *m

	cloned.FpRequest = m.FpRequest.Clone()
	return cloned
}
func (*VulnerabilityRequest_Cves) isVulnerabilityRequest_Entities() {}
func (m *VulnerabilityRequest_Cves) Clone() isVulnerabilityRequest_Entities {
	if m == nil {
		return nil
	}
	cloned := new(VulnerabilityRequest_Cves)
	*cloned = *m

	cloned.Cves = m.Cves.Clone()
	return cloned
}
func (*VulnerabilityRequest_UpdatedDeferralReq) isVulnerabilityRequest_UpdatedReq() {}
func (m *VulnerabilityRequest_UpdatedDeferralReq) Clone() isVulnerabilityRequest_UpdatedReq {
	if m == nil {
		return nil
	}
	cloned := new(VulnerabilityRequest_UpdatedDeferralReq)
	*cloned = *m

	cloned.UpdatedDeferralReq = m.UpdatedDeferralReq.Clone()
	return cloned
}

func (m *VulnerabilityRequest) GetReq() isVulnerabilityRequest_Req {
	if m != nil {
		return m.Req
	}
	return nil
}
func (m *VulnerabilityRequest) GetEntities() isVulnerabilityRequest_Entities {
	if m != nil {
		return m.Entities
	}
	return nil
}
func (m *VulnerabilityRequest) GetUpdatedReq() isVulnerabilityRequest_UpdatedReq {
	if m != nil {
		return m.UpdatedReq
	}
	return nil
}

func (m *VulnerabilityRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *VulnerabilityRequest) GetTargetState() VulnerabilityState {
	if m != nil {
		return m.TargetState
	}
	return VulnerabilityState_OBSERVED
}

func (m *VulnerabilityRequest) GetStatus() RequestStatus {
	if m != nil {
		return m.Status
	}
	return RequestStatus_PENDING
}

func (m *VulnerabilityRequest) GetExpired() bool {
	if m != nil {
		return m.Expired
	}
	return false
}

func (m *VulnerabilityRequest) GetRequestor() *SlimUser {
	if m != nil {
		return m.Requestor
	}
	return nil
}

func (m *VulnerabilityRequest) GetApprovers() []*SlimUser {
	if m != nil {
		return m.Approvers
	}
	return nil
}

func (m *VulnerabilityRequest) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *VulnerabilityRequest) GetLastUpdated() *types.Timestamp {
	if m != nil {
		return m.LastUpdated
	}
	return nil
}

func (m *VulnerabilityRequest) GetComments() []*RequestComment {
	if m != nil {
		return m.Comments
	}
	return nil
}

func (m *VulnerabilityRequest) GetScope() *VulnerabilityRequest_Scope {
	if m != nil {
		return m.Scope
	}
	return nil
}

func (m *VulnerabilityRequest) GetDeferralReq() *DeferralRequest {
	if x, ok := m.GetReq().(*VulnerabilityRequest_DeferralReq); ok {
		return x.DeferralReq
	}
	return nil
}

func (m *VulnerabilityRequest) GetFpRequest() *FalsePositiveRequest {
	if x, ok := m.GetReq().(*VulnerabilityRequest_FpRequest); ok {
		return x.FpRequest
	}
	return nil
}

func (m *VulnerabilityRequest) GetCves() *VulnerabilityRequest_CVEs {
	if x, ok := m.GetEntities().(*VulnerabilityRequest_Cves); ok {
		return x.Cves
	}
	return nil
}

func (m *VulnerabilityRequest) GetUpdatedDeferralReq() *DeferralRequest {
	if x, ok := m.GetUpdatedReq().(*VulnerabilityRequest_UpdatedDeferralReq); ok {
		return x.UpdatedDeferralReq
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*VulnerabilityRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*VulnerabilityRequest_DeferralReq)(nil),
		(*VulnerabilityRequest_FpRequest)(nil),
		(*VulnerabilityRequest_Cves)(nil),
		(*VulnerabilityRequest_UpdatedDeferralReq)(nil),
	}
}

func (m *VulnerabilityRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *VulnerabilityRequest) Clone() *VulnerabilityRequest {
	if m == nil {
		return nil
	}
	cloned := new(VulnerabilityRequest)
	*cloned = *m

	cloned.Requestor = m.Requestor.Clone()
	if m.Approvers != nil {
		cloned.Approvers = make([]*SlimUser, len(m.Approvers))
		for idx, v := range m.Approvers {
			cloned.Approvers[idx] = v.Clone()
		}
	}
	cloned.CreatedAt = m.CreatedAt.Clone()
	cloned.LastUpdated = m.LastUpdated.Clone()
	if m.Comments != nil {
		cloned.Comments = make([]*RequestComment, len(m.Comments))
		for idx, v := range m.Comments {
			cloned.Comments[idx] = v.Clone()
		}
	}
	cloned.Scope = m.Scope.Clone()
	if m.Req != nil {
		cloned.Req = m.Req.Clone()
	}
	if m.Entities != nil {
		cloned.Entities = m.Entities.Clone()
	}
	if m.UpdatedReq != nil {
		cloned.UpdatedReq = m.UpdatedReq.Clone()
	}
	return cloned
}

type VulnerabilityRequest_CVEs struct {
	Ids                  []string `protobuf:"bytes,1,rep,name=ids,proto3" json:"ids,omitempty" search:"CVE"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VulnerabilityRequest_CVEs) Reset()         { *m = VulnerabilityRequest_CVEs{} }
func (m *VulnerabilityRequest_CVEs) String() string { return proto.CompactTextString(m) }
func (*VulnerabilityRequest_CVEs) ProtoMessage()    {}
func (*VulnerabilityRequest_CVEs) Descriptor() ([]byte, []int) {
	return fileDescriptor_878c2c8004fa26b3, []int{4, 0}
}
func (m *VulnerabilityRequest_CVEs) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VulnerabilityRequest_CVEs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VulnerabilityRequest_CVEs.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VulnerabilityRequest_CVEs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnerabilityRequest_CVEs.Merge(m, src)
}
func (m *VulnerabilityRequest_CVEs) XXX_Size() int {
	return m.Size()
}
func (m *VulnerabilityRequest_CVEs) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnerabilityRequest_CVEs.DiscardUnknown(m)
}

var xxx_messageInfo_VulnerabilityRequest_CVEs proto.InternalMessageInfo

func (m *VulnerabilityRequest_CVEs) GetIds() []string {
	if m != nil {
		return m.Ids
	}
	return nil
}

func (m *VulnerabilityRequest_CVEs) MessageClone() proto.Message {
	return m.Clone()
}
func (m *VulnerabilityRequest_CVEs) Clone() *VulnerabilityRequest_CVEs {
	if m == nil {
		return nil
	}
	cloned := new(VulnerabilityRequest_CVEs)
	*cloned = *m

	if m.Ids != nil {
		cloned.Ids = make([]string, len(m.Ids))
		copy(cloned.Ids, m.Ids)
	}
	return cloned
}

type VulnerabilityRequest_Scope struct {
	// Types that are valid to be assigned to Info:
	//	*VulnerabilityRequest_Scope_ImageScope
	//	*VulnerabilityRequest_Scope_GlobalScope
	Info                 isVulnerabilityRequest_Scope_Info `protobuf_oneof:"info"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *VulnerabilityRequest_Scope) Reset()         { *m = VulnerabilityRequest_Scope{} }
func (m *VulnerabilityRequest_Scope) String() string { return proto.CompactTextString(m) }
func (*VulnerabilityRequest_Scope) ProtoMessage()    {}
func (*VulnerabilityRequest_Scope) Descriptor() ([]byte, []int) {
	return fileDescriptor_878c2c8004fa26b3, []int{4, 1}
}
func (m *VulnerabilityRequest_Scope) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VulnerabilityRequest_Scope) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VulnerabilityRequest_Scope.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VulnerabilityRequest_Scope) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnerabilityRequest_Scope.Merge(m, src)
}
func (m *VulnerabilityRequest_Scope) XXX_Size() int {
	return m.Size()
}
func (m *VulnerabilityRequest_Scope) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnerabilityRequest_Scope.DiscardUnknown(m)
}

var xxx_messageInfo_VulnerabilityRequest_Scope proto.InternalMessageInfo

type isVulnerabilityRequest_Scope_Info interface {
	isVulnerabilityRequest_Scope_Info()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isVulnerabilityRequest_Scope_Info
}

type VulnerabilityRequest_Scope_ImageScope struct {
	ImageScope *VulnerabilityRequest_Scope_Image `protobuf:"bytes,1,opt,name=image_scope,json=imageScope,proto3,oneof" json:"image_scope,omitempty"`
}
type VulnerabilityRequest_Scope_GlobalScope struct {
	GlobalScope *VulnerabilityRequest_Scope_Global `protobuf:"bytes,2,opt,name=global_scope,json=globalScope,proto3,oneof" json:"global_scope,omitempty"`
}

func (*VulnerabilityRequest_Scope_ImageScope) isVulnerabilityRequest_Scope_Info() {}
func (m *VulnerabilityRequest_Scope_ImageScope) Clone() isVulnerabilityRequest_Scope_Info {
	if m == nil {
		return nil
	}
	cloned := new(VulnerabilityRequest_Scope_ImageScope)
	*cloned = *m

	cloned.ImageScope = m.ImageScope.Clone()
	return cloned
}
func (*VulnerabilityRequest_Scope_GlobalScope) isVulnerabilityRequest_Scope_Info() {}
func (m *VulnerabilityRequest_Scope_GlobalScope) Clone() isVulnerabilityRequest_Scope_Info {
	if m == nil {
		return nil
	}
	cloned := new(VulnerabilityRequest_Scope_GlobalScope)
	*cloned = *m

	cloned.GlobalScope = m.GlobalScope.Clone()
	return cloned
}

func (m *VulnerabilityRequest_Scope) GetInfo() isVulnerabilityRequest_Scope_Info {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *VulnerabilityRequest_Scope) GetImageScope() *VulnerabilityRequest_Scope_Image {
	if x, ok := m.GetInfo().(*VulnerabilityRequest_Scope_ImageScope); ok {
		return x.ImageScope
	}
	return nil
}

func (m *VulnerabilityRequest_Scope) GetGlobalScope() *VulnerabilityRequest_Scope_Global {
	if x, ok := m.GetInfo().(*VulnerabilityRequest_Scope_GlobalScope); ok {
		return x.GlobalScope
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*VulnerabilityRequest_Scope) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*VulnerabilityRequest_Scope_ImageScope)(nil),
		(*VulnerabilityRequest_Scope_GlobalScope)(nil),
	}
}

func (m *VulnerabilityRequest_Scope) MessageClone() proto.Message {
	return m.Clone()
}
func (m *VulnerabilityRequest_Scope) Clone() *VulnerabilityRequest_Scope {
	if m == nil {
		return nil
	}
	cloned := new(VulnerabilityRequest_Scope)
	*cloned = *m

	if m.Info != nil {
		cloned.Info = m.Info.Clone()
	}
	return cloned
}

type VulnerabilityRequest_Scope_Image struct {
	Registry             string   `protobuf:"bytes,1,opt,name=registry,proto3" json:"registry,omitempty"`
	Remote               string   `protobuf:"bytes,2,opt,name=remote,proto3" json:"remote,omitempty"`
	Tag                  string   `protobuf:"bytes,3,opt,name=tag,proto3" json:"tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VulnerabilityRequest_Scope_Image) Reset()         { *m = VulnerabilityRequest_Scope_Image{} }
func (m *VulnerabilityRequest_Scope_Image) String() string { return proto.CompactTextString(m) }
func (*VulnerabilityRequest_Scope_Image) ProtoMessage()    {}
func (*VulnerabilityRequest_Scope_Image) Descriptor() ([]byte, []int) {
	return fileDescriptor_878c2c8004fa26b3, []int{4, 1, 0}
}
func (m *VulnerabilityRequest_Scope_Image) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VulnerabilityRequest_Scope_Image) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VulnerabilityRequest_Scope_Image.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VulnerabilityRequest_Scope_Image) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnerabilityRequest_Scope_Image.Merge(m, src)
}
func (m *VulnerabilityRequest_Scope_Image) XXX_Size() int {
	return m.Size()
}
func (m *VulnerabilityRequest_Scope_Image) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnerabilityRequest_Scope_Image.DiscardUnknown(m)
}

var xxx_messageInfo_VulnerabilityRequest_Scope_Image proto.InternalMessageInfo

func (m *VulnerabilityRequest_Scope_Image) GetRegistry() string {
	if m != nil {
		return m.Registry
	}
	return ""
}

func (m *VulnerabilityRequest_Scope_Image) GetRemote() string {
	if m != nil {
		return m.Remote
	}
	return ""
}

func (m *VulnerabilityRequest_Scope_Image) GetTag() string {
	if m != nil {
		return m.Tag
	}
	return ""
}

func (m *VulnerabilityRequest_Scope_Image) MessageClone() proto.Message {
	return m.Clone()
}
func (m *VulnerabilityRequest_Scope_Image) Clone() *VulnerabilityRequest_Scope_Image {
	if m == nil {
		return nil
	}
	cloned := new(VulnerabilityRequest_Scope_Image)
	*cloned = *m

	return cloned
}

type VulnerabilityRequest_Scope_Global struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VulnerabilityRequest_Scope_Global) Reset()         { *m = VulnerabilityRequest_Scope_Global{} }
func (m *VulnerabilityRequest_Scope_Global) String() string { return proto.CompactTextString(m) }
func (*VulnerabilityRequest_Scope_Global) ProtoMessage()    {}
func (*VulnerabilityRequest_Scope_Global) Descriptor() ([]byte, []int) {
	return fileDescriptor_878c2c8004fa26b3, []int{4, 1, 1}
}
func (m *VulnerabilityRequest_Scope_Global) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VulnerabilityRequest_Scope_Global) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VulnerabilityRequest_Scope_Global.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VulnerabilityRequest_Scope_Global) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnerabilityRequest_Scope_Global.Merge(m, src)
}
func (m *VulnerabilityRequest_Scope_Global) XXX_Size() int {
	return m.Size()
}
func (m *VulnerabilityRequest_Scope_Global) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnerabilityRequest_Scope_Global.DiscardUnknown(m)
}

var xxx_messageInfo_VulnerabilityRequest_Scope_Global proto.InternalMessageInfo

func (m *VulnerabilityRequest_Scope_Global) MessageClone() proto.Message {
	return m.Clone()
}
func (m *VulnerabilityRequest_Scope_Global) Clone() *VulnerabilityRequest_Scope_Global {
	if m == nil {
		return nil
	}
	cloned := new(VulnerabilityRequest_Scope_Global)
	*cloned = *m

	return cloned
}

func init() {
	proto.RegisterEnum("storage.RequestStatus", RequestStatus_name, RequestStatus_value)
	proto.RegisterType((*RequestComment)(nil), "storage.RequestComment")
	proto.RegisterType((*RequestExpiry)(nil), "storage.RequestExpiry")
	proto.RegisterType((*DeferralRequest)(nil), "storage.DeferralRequest")
	proto.RegisterType((*FalsePositiveRequest)(nil), "storage.FalsePositiveRequest")
	proto.RegisterType((*VulnerabilityRequest)(nil), "storage.VulnerabilityRequest")
	proto.RegisterType((*VulnerabilityRequest_CVEs)(nil), "storage.VulnerabilityRequest.CVEs")
	proto.RegisterType((*VulnerabilityRequest_Scope)(nil), "storage.VulnerabilityRequest.Scope")
	proto.RegisterType((*VulnerabilityRequest_Scope_Image)(nil), "storage.VulnerabilityRequest.Scope.Image")
	proto.RegisterType((*VulnerabilityRequest_Scope_Global)(nil), "storage.VulnerabilityRequest.Scope.Global")
}

func init() { proto.RegisterFile("storage/vuln_requests.proto", fileDescriptor_878c2c8004fa26b3) }

var fileDescriptor_878c2c8004fa26b3 = []byte{
	// 966 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x55, 0xdd, 0x6e, 0x1b, 0x45,
	0x14, 0xce, 0xda, 0x89, 0x63, 0x1f, 0xbb, 0xc1, 0x1d, 0xa5, 0xc9, 0xd6, 0x29, 0xf1, 0x6a, 0x2b,
	0x20, 0x44, 0x62, 0x23, 0xa5, 0x08, 0x51, 0x24, 0x90, 0xb2, 0xb1, 0xdb, 0x44, 0x94, 0xc4, 0x1a,
	0x27, 0x29, 0x42, 0xa0, 0xd5, 0xc6, 0x3b, 0xde, 0x2c, 0xac, 0xbd, 0xce, 0xcc, 0xd8, 0x24, 0x4f,
	0x00, 0x8f, 0xc0, 0x05, 0x0f, 0xc4, 0x25, 0xbc, 0x80, 0x85, 0xc2, 0x1b, 0xf8, 0x09, 0xd0, 0xfc,
	0xb9, 0xb5, 0x49, 0x43, 0x7b, 0xb7, 0x73, 0xe6, 0xfb, 0xbe, 0x33, 0xe7, 0x77, 0x61, 0x83, 0xf1,
	0x8c, 0x86, 0x31, 0xd9, 0x19, 0x0d, 0xd3, 0x7e, 0x40, 0xc9, 0xe5, 0x90, 0x30, 0xce, 0xbc, 0x01,
	0xcd, 0x78, 0x86, 0x96, 0xf5, 0x65, 0xad, 0x1e, 0x67, 0x59, 0x9c, 0x92, 0x1d, 0x69, 0x3e, 0x1f,
	0x76, 0x77, 0x78, 0xd2, 0x23, 0x8c, 0x87, 0xbd, 0x81, 0x42, 0xd6, 0x56, 0xe3, 0x2c, 0xce, 0xe4,
	0xe7, 0x8e, 0xf8, 0xd2, 0xd6, 0xfb, 0x46, 0xbc, 0x33, 0x22, 0xda, 0x84, 0x8c, 0x69, 0xc8, 0x08,
	0x55, 0x36, 0xf7, 0x77, 0x0b, 0x56, 0xb0, 0xf2, 0xbc, 0x9f, 0xf5, 0x7a, 0xa4, 0xcf, 0xd1, 0x0a,
	0xe4, 0x92, 0xc8, 0xb6, 0x1c, 0x6b, 0xab, 0x84, 0x73, 0x49, 0x84, 0x6c, 0x58, 0xee, 0x11, 0xc6,
	0xc2, 0x98, 0xd8, 0x39, 0x69, 0x34, 0x47, 0xf4, 0x01, 0x2c, 0x0a, 0x29, 0x3b, 0xef, 0x58, 0x5b,
	0xe5, 0xdd, 0xfb, 0x9e, 0xd6, 0xf7, 0xda, 0x69, 0xd2, 0x3b, 0x65, 0x84, 0x62, 0x79, 0x8d, 0x9e,
	0x02, 0x74, 0x28, 0x09, 0x39, 0x89, 0x82, 0x90, 0xdb, 0x8b, 0x12, 0x5c, 0xf3, 0x54, 0x58, 0x9e,
	0x09, 0xcb, 0x3b, 0x31, 0x61, 0xe1, 0x92, 0x46, 0xef, 0x71, 0xf7, 0x2f, 0x0b, 0xee, 0xe9, 0xe7,
	0x35, 0xaf, 0x06, 0x09, 0xbd, 0x46, 0x2f, 0x01, 0x11, 0xf1, 0x45, 0x58, 0xf0, 0xf3, 0x05, 0xe9,
	0x07, 0xdd, 0xe4, 0x8a, 0xa8, 0xd7, 0x16, 0xfd, 0x8f, 0x26, 0xe3, 0xfa, 0x63, 0x46, 0x42, 0xda,
	0xb9, 0xf8, 0xc2, 0xd5, 0x34, 0xa7, 0xa9, 0xd0, 0xce, 0xcb, 0x0b, 0xd2, 0x77, 0x9e, 0x09, 0xb4,
	0x7b, 0xb0, 0x80, 0xab, 0x5a, 0x44, 0x58, 0xa5, 0x11, 0xfd, 0x00, 0x60, 0x84, 0xb3, 0xbe, 0x8c,
	0xf4, 0xce, 0x57, 0xfa, 0xce, 0x64, 0x5c, 0x7f, 0x74, 0xab, 0xb3, 0x6b, 0x47, 0xa0, 0x84, 0x97,
	0x92, 0x56, 0x3c, 0xee, 0xfb, 0x45, 0x28, 0xc8, 0xc3, 0xb5, 0xbb, 0x07, 0xef, 0x35, 0x48, 0x97,
	0x50, 0x1a, 0xa6, 0x9a, 0x86, 0x3c, 0x73, 0x29, 0x03, 0x29, 0xef, 0xae, 0x4d, 0x53, 0x39, 0x13,
	0x3c, 0x36, 0x12, 0x6b, 0xb0, 0xfa, 0x2c, 0x4c, 0x19, 0x69, 0x65, 0x2c, 0xe1, 0xc9, 0x88, 0x68,
	0x94, 0xfb, 0x2b, 0xc0, 0xea, 0xd9, 0x30, 0xed, 0x13, 0x1a, 0x9e, 0x27, 0x69, 0xc2, 0xaf, 0x8d,
	0x83, 0xf9, 0x9a, 0xfe, 0x08, 0x15, 0x1e, 0xd2, 0x98, 0xf0, 0x80, 0xf1, 0x90, 0xab, 0xc2, 0xae,
	0xec, 0x6e, 0x4c, 0xdd, 0xce, 0x88, 0xb4, 0x05, 0xc4, 0xdf, 0x9e, 0x8c, 0xeb, 0x1f, 0xce, 0xc5,
	0x4b, 0x22, 0x67, 0x06, 0xe9, 0x48, 0xa8, 0x8b, 0xcb, 0x4a, 0x5c, 0x9e, 0xd0, 0xd7, 0x50, 0x10,
	0x4e, 0x86, 0x4c, 0xf6, 0xc9, 0xca, 0x7f, 0x83, 0x6b, 0xcb, 0x5b, 0x7f, 0x63, 0x32, 0xae, 0xaf,
	0xcf, 0x27, 0x54, 0xdd, 0xb9, 0x58, 0x4b, 0xa0, 0xcf, 0x60, 0x59, 0xe5, 0x34, 0x92, 0x8d, 0x54,
	0xf4, 0x1f, 0x4d, 0xc6, 0x75, 0xdb, 0xb0, 0x54, 0xad, 0x23, 0xc7, 0xe4, 0x03, 0x1b, 0x30, 0xda,
	0x81, 0x92, 0x1e, 0xb0, 0x8c, 0xda, 0x4b, 0x6f, 0xea, 0xd7, 0x57, 0x18, 0x41, 0x08, 0x07, 0x03,
	0x9a, 0x8d, 0x08, 0x65, 0x76, 0xc1, 0xc9, 0xbf, 0x81, 0x30, 0xc5, 0xa0, 0x93, 0x99, 0x2e, 0x5f,
	0xfe, 0xdf, 0xfe, 0x79, 0x38, 0x19, 0xd7, 0x1f, 0x98, 0x87, 0xef, 0x2b, 0xa6, 0x6a, 0x9c, 0xd7,
	0x06, 0x00, 0x7d, 0x0b, 0x95, 0x34, 0x64, 0x3c, 0x18, 0x0e, 0x22, 0x61, 0xb1, 0x8b, 0xef, 0xa6,
	0xfb, 0x22, 0x64, 0xdc, 0x39, 0x55, 0x5c, 0x17, 0x97, 0x85, 0x94, 0x3e, 0xa1, 0x27, 0x50, 0xec,
	0xa8, 0x89, 0x67, 0x76, 0x49, 0xc6, 0xb7, 0x3e, 0x5f, 0x18, 0xbd, 0x11, 0xf0, 0x14, 0x88, 0x9e,
	0xc2, 0x12, 0xeb, 0x64, 0x03, 0x62, 0x83, 0x7c, 0xc7, 0xe3, 0xdb, 0x1b, 0x46, 0xd3, 0xbd, 0xb6,
	0x80, 0x62, 0xc5, 0x40, 0x5f, 0x42, 0x25, 0xd2, 0x6d, 0x2f, 0x76, 0x9d, 0x5d, 0x96, 0x0a, 0xf6,
	0x54, 0x61, 0x6e, 0x26, 0x0e, 0x16, 0x70, 0x39, 0x7a, 0x65, 0x42, 0x5f, 0x01, 0x74, 0x07, 0x66,
	0x49, 0xda, 0x15, 0x49, 0x7e, 0x7f, 0x4a, 0xbe, 0x6d, 0x1a, 0xc4, 0xfc, 0x75, 0x07, 0x66, 0x02,
	0x3e, 0x87, 0xc5, 0xce, 0x88, 0x30, 0xbb, 0x2a, 0x99, 0xee, 0xdd, 0x0f, 0xdf, 0x3f, 0x6b, 0xb2,
	0x03, 0x0b, 0x4b, 0x06, 0xfa, 0x1e, 0x56, 0x75, 0xf6, 0x83, 0x99, 0x00, 0x1e, 0xdc, 0x1d, 0x80,
	0xbf, 0x32, 0x19, 0xd7, 0xc1, 0x14, 0xe2, 0x13, 0xf7, 0x20, 0x87, 0x91, 0xd6, 0x79, 0x0d, 0x59,
	0xdb, 0x86, 0x45, 0xe1, 0x0d, 0xb9, 0x90, 0x4f, 0x22, 0x66, 0x5b, 0x4e, 0x7e, 0xab, 0xe4, 0x57,
	0x27, 0xe3, 0x7a, 0x65, 0xda, 0x1b, 0x67, 0x4d, 0x17, 0x8b, 0xcb, 0xda, 0x2f, 0x39, 0x58, 0x92,
	0x39, 0x45, 0x2f, 0xa0, 0x9c, 0xf4, 0xc2, 0x98, 0x04, 0xaa, 0x1a, 0x6a, 0x6b, 0x7c, 0xfc, 0x16,
	0xd5, 0xf0, 0x0e, 0x05, 0xed, 0x60, 0x01, 0x83, 0xe4, 0x2b, 0xb5, 0x63, 0xa8, 0xc4, 0x69, 0x76,
	0x1e, 0xa6, 0x5a, 0x4e, 0x2d, 0xbf, 0xed, 0xb7, 0x91, 0x7b, 0x2e, 0x79, 0xa2, 0x58, 0x4a, 0x41,
	0x5a, 0x6b, 0xdf, 0xc0, 0x92, 0xf4, 0x83, 0x6a, 0x50, 0xa4, 0x24, 0x4e, 0x18, 0xd7, 0xab, 0xad,
	0x84, 0xa7, 0x67, 0xb4, 0x06, 0x05, 0x4a, 0x7a, 0x19, 0x37, 0xbf, 0x15, 0x7d, 0x42, 0x55, 0xc8,
	0xf3, 0x30, 0x96, 0xcb, 0xa2, 0x84, 0xc5, 0x67, 0xad, 0x08, 0x05, 0xe5, 0xc7, 0x2f, 0xc0, 0x62,
	0xd2, 0xef, 0x66, 0xfe, 0x12, 0xe4, 0x29, 0xb9, 0xf4, 0x01, 0x8a, 0xa4, 0xcf, 0x13, 0x9e, 0x10,
	0xe6, 0xdf, 0x83, 0xb2, 0x29, 0x13, 0x25, 0x97, 0xdb, 0xed, 0xe9, 0x8f, 0x43, 0xad, 0x10, 0x54,
	0x86, 0xe5, 0x56, 0xf3, 0xa8, 0x71, 0x78, 0xf4, 0xbc, 0xba, 0x80, 0x2a, 0x50, 0xdc, 0x6b, 0xb5,
	0xf0, 0xf1, 0x59, 0xb3, 0x51, 0xb5, 0x10, 0x40, 0xa1, 0xd1, 0x3c, 0x3a, 0x6c, 0x36, 0xaa, 0x39,
	0xb4, 0x01, 0xeb, 0xe6, 0x26, 0xd0, 0xf8, 0xe0, 0xb4, 0xd5, 0xd8, 0x3b, 0x69, 0x56, 0xf3, 0xfe,
	0xa7, 0x7f, 0xdc, 0x6c, 0x5a, 0x7f, 0xde, 0x6c, 0x5a, 0x7f, 0xdf, 0x6c, 0x5a, 0xbf, 0xfd, 0xb3,
	0xb9, 0x00, 0x0f, 0x93, 0xcc, 0x63, 0x3c, 0xec, 0xfc, 0x44, 0xb3, 0x2b, 0x35, 0x8d, 0x26, 0x6b,
	0xdf, 0x99, 0x3f, 0xf8, 0x79, 0x41, 0xda, 0x9f, 0xfc, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x46, 0xd4,
	0xd8, 0x10, 0xf0, 0x07, 0x00, 0x00,
}

func (m *RequestComment) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestComment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RequestComment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnRequests(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.User != nil {
		{
			size, err := m.User.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnRequests(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintVulnRequests(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintVulnRequests(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RequestExpiry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestExpiry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RequestExpiry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Expiry != nil {
		{
			size := m.Expiry.Size()
			i -= size
			if _, err := m.Expiry.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *RequestExpiry_ExpiresWhenFixed) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RequestExpiry_ExpiresWhenFixed) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i--
	if m.ExpiresWhenFixed {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x8
	return len(dAtA) - i, nil
}
func (m *RequestExpiry_ExpiresOn) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RequestExpiry_ExpiresOn) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ExpiresOn != nil {
		{
			size, err := m.ExpiresOn.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnRequests(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *DeferralRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeferralRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeferralRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Expiry != nil {
		{
			size, err := m.Expiry.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnRequests(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *FalsePositiveRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FalsePositiveRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FalsePositiveRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *VulnerabilityRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VulnerabilityRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VulnerabilityRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.UpdatedReq != nil {
		{
			size := m.UpdatedReq.Size()
			i -= size
			if _, err := m.UpdatedReq.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Entities != nil {
		{
			size := m.Entities.Size()
			i -= size
			if _, err := m.Entities.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Req != nil {
		{
			size := m.Req.Size()
			i -= size
			if _, err := m.Req.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Scope != nil {
		{
			size, err := m.Scope.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnRequests(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if len(m.Comments) > 0 {
		for iNdEx := len(m.Comments) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Comments[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintVulnRequests(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x4a
		}
	}
	if m.LastUpdated != nil {
		{
			size, err := m.LastUpdated.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnRequests(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnRequests(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Approvers) > 0 {
		for iNdEx := len(m.Approvers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Approvers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintVulnRequests(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if m.Requestor != nil {
		{
			size, err := m.Requestor.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnRequests(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Expired {
		i--
		if m.Expired {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Status != 0 {
		i = encodeVarintVulnRequests(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x18
	}
	if m.TargetState != 0 {
		i = encodeVarintVulnRequests(dAtA, i, uint64(m.TargetState))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintVulnRequests(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *VulnerabilityRequest_DeferralReq) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VulnerabilityRequest_DeferralReq) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.DeferralReq != nil {
		{
			size, err := m.DeferralReq.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnRequests(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	return len(dAtA) - i, nil
}
func (m *VulnerabilityRequest_FpRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VulnerabilityRequest_FpRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.FpRequest != nil {
		{
			size, err := m.FpRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnRequests(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	return len(dAtA) - i, nil
}
func (m *VulnerabilityRequest_Cves) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VulnerabilityRequest_Cves) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Cves != nil {
		{
			size, err := m.Cves.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnRequests(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	return len(dAtA) - i, nil
}
func (m *VulnerabilityRequest_UpdatedDeferralReq) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VulnerabilityRequest_UpdatedDeferralReq) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.UpdatedDeferralReq != nil {
		{
			size, err := m.UpdatedDeferralReq.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnRequests(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	return len(dAtA) - i, nil
}
func (m *VulnerabilityRequest_CVEs) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VulnerabilityRequest_CVEs) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VulnerabilityRequest_CVEs) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Ids) > 0 {
		for iNdEx := len(m.Ids) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Ids[iNdEx])
			copy(dAtA[i:], m.Ids[iNdEx])
			i = encodeVarintVulnRequests(dAtA, i, uint64(len(m.Ids[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *VulnerabilityRequest_Scope) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VulnerabilityRequest_Scope) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VulnerabilityRequest_Scope) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Info != nil {
		{
			size := m.Info.Size()
			i -= size
			if _, err := m.Info.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *VulnerabilityRequest_Scope_ImageScope) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VulnerabilityRequest_Scope_ImageScope) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ImageScope != nil {
		{
			size, err := m.ImageScope.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnRequests(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *VulnerabilityRequest_Scope_GlobalScope) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VulnerabilityRequest_Scope_GlobalScope) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.GlobalScope != nil {
		{
			size, err := m.GlobalScope.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnRequests(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *VulnerabilityRequest_Scope_Image) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VulnerabilityRequest_Scope_Image) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VulnerabilityRequest_Scope_Image) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Tag) > 0 {
		i -= len(m.Tag)
		copy(dAtA[i:], m.Tag)
		i = encodeVarintVulnRequests(dAtA, i, uint64(len(m.Tag)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Remote) > 0 {
		i -= len(m.Remote)
		copy(dAtA[i:], m.Remote)
		i = encodeVarintVulnRequests(dAtA, i, uint64(len(m.Remote)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Registry) > 0 {
		i -= len(m.Registry)
		copy(dAtA[i:], m.Registry)
		i = encodeVarintVulnRequests(dAtA, i, uint64(len(m.Registry)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *VulnerabilityRequest_Scope_Global) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VulnerabilityRequest_Scope_Global) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VulnerabilityRequest_Scope_Global) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func encodeVarintVulnRequests(dAtA []byte, offset int, v uint64) int {
	offset -= sovVulnRequests(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *RequestComment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovVulnRequests(uint64(l))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovVulnRequests(uint64(l))
	}
	if m.User != nil {
		l = m.User.Size()
		n += 1 + l + sovVulnRequests(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovVulnRequests(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RequestExpiry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Expiry != nil {
		n += m.Expiry.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RequestExpiry_ExpiresWhenFixed) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 2
	return n
}
func (m *RequestExpiry_ExpiresOn) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExpiresOn != nil {
		l = m.ExpiresOn.Size()
		n += 1 + l + sovVulnRequests(uint64(l))
	}
	return n
}
func (m *DeferralRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Expiry != nil {
		l = m.Expiry.Size()
		n += 1 + l + sovVulnRequests(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FalsePositiveRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VulnerabilityRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovVulnRequests(uint64(l))
	}
	if m.TargetState != 0 {
		n += 1 + sovVulnRequests(uint64(m.TargetState))
	}
	if m.Status != 0 {
		n += 1 + sovVulnRequests(uint64(m.Status))
	}
	if m.Expired {
		n += 2
	}
	if m.Requestor != nil {
		l = m.Requestor.Size()
		n += 1 + l + sovVulnRequests(uint64(l))
	}
	if len(m.Approvers) > 0 {
		for _, e := range m.Approvers {
			l = e.Size()
			n += 1 + l + sovVulnRequests(uint64(l))
		}
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovVulnRequests(uint64(l))
	}
	if m.LastUpdated != nil {
		l = m.LastUpdated.Size()
		n += 1 + l + sovVulnRequests(uint64(l))
	}
	if len(m.Comments) > 0 {
		for _, e := range m.Comments {
			l = e.Size()
			n += 1 + l + sovVulnRequests(uint64(l))
		}
	}
	if m.Scope != nil {
		l = m.Scope.Size()
		n += 1 + l + sovVulnRequests(uint64(l))
	}
	if m.Req != nil {
		n += m.Req.Size()
	}
	if m.Entities != nil {
		n += m.Entities.Size()
	}
	if m.UpdatedReq != nil {
		n += m.UpdatedReq.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VulnerabilityRequest_DeferralReq) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DeferralReq != nil {
		l = m.DeferralReq.Size()
		n += 1 + l + sovVulnRequests(uint64(l))
	}
	return n
}
func (m *VulnerabilityRequest_FpRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.FpRequest != nil {
		l = m.FpRequest.Size()
		n += 1 + l + sovVulnRequests(uint64(l))
	}
	return n
}
func (m *VulnerabilityRequest_Cves) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Cves != nil {
		l = m.Cves.Size()
		n += 2 + l + sovVulnRequests(uint64(l))
	}
	return n
}
func (m *VulnerabilityRequest_UpdatedDeferralReq) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.UpdatedDeferralReq != nil {
		l = m.UpdatedDeferralReq.Size()
		n += 2 + l + sovVulnRequests(uint64(l))
	}
	return n
}
func (m *VulnerabilityRequest_CVEs) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Ids) > 0 {
		for _, s := range m.Ids {
			l = len(s)
			n += 1 + l + sovVulnRequests(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VulnerabilityRequest_Scope) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Info != nil {
		n += m.Info.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VulnerabilityRequest_Scope_ImageScope) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ImageScope != nil {
		l = m.ImageScope.Size()
		n += 1 + l + sovVulnRequests(uint64(l))
	}
	return n
}
func (m *VulnerabilityRequest_Scope_GlobalScope) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.GlobalScope != nil {
		l = m.GlobalScope.Size()
		n += 1 + l + sovVulnRequests(uint64(l))
	}
	return n
}
func (m *VulnerabilityRequest_Scope_Image) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Registry)
	if l > 0 {
		n += 1 + l + sovVulnRequests(uint64(l))
	}
	l = len(m.Remote)
	if l > 0 {
		n += 1 + l + sovVulnRequests(uint64(l))
	}
	l = len(m.Tag)
	if l > 0 {
		n += 1 + l + sovVulnRequests(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VulnerabilityRequest_Scope_Global) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovVulnRequests(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozVulnRequests(x uint64) (n int) {
	return sovVulnRequests(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *RequestComment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVulnRequests
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestComment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestComment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.User == nil {
				m.User = &SlimUser{}
			}
			if err := m.User.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVulnRequests(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestExpiry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVulnRequests
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestExpiry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestExpiry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpiresWhenFixed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Expiry = &RequestExpiry_ExpiresWhenFixed{b}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpiresOn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Timestamp{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Expiry = &RequestExpiry_ExpiresOn{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVulnRequests(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeferralRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVulnRequests
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeferralRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeferralRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expiry", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Expiry == nil {
				m.Expiry = &RequestExpiry{}
			}
			if err := m.Expiry.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVulnRequests(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FalsePositiveRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVulnRequests
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FalsePositiveRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FalsePositiveRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipVulnRequests(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VulnerabilityRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVulnRequests
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VulnerabilityRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VulnerabilityRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetState", wireType)
			}
			m.TargetState = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TargetState |= VulnerabilityState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= RequestStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expired", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Expired = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Requestor", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Requestor == nil {
				m.Requestor = &SlimUser{}
			}
			if err := m.Requestor.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Approvers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Approvers = append(m.Approvers, &SlimUser{})
			if err := m.Approvers[len(m.Approvers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastUpdated == nil {
				m.LastUpdated = &types.Timestamp{}
			}
			if err := m.LastUpdated.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Comments", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Comments = append(m.Comments, &RequestComment{})
			if err := m.Comments[len(m.Comments)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scope", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Scope == nil {
				m.Scope = &VulnerabilityRequest_Scope{}
			}
			if err := m.Scope.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeferralReq", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DeferralRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Req = &VulnerabilityRequest_DeferralReq{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FpRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &FalsePositiveRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Req = &VulnerabilityRequest_FpRequest{v}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cves", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &VulnerabilityRequest_CVEs{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Entities = &VulnerabilityRequest_Cves{v}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdatedDeferralReq", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DeferralRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.UpdatedReq = &VulnerabilityRequest_UpdatedDeferralReq{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVulnRequests(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VulnerabilityRequest_CVEs) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVulnRequests
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CVEs: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CVEs: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ids", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ids = append(m.Ids, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVulnRequests(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VulnerabilityRequest_Scope) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVulnRequests
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Scope: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Scope: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ImageScope", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &VulnerabilityRequest_Scope_Image{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Info = &VulnerabilityRequest_Scope_ImageScope{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GlobalScope", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &VulnerabilityRequest_Scope_Global{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Info = &VulnerabilityRequest_Scope_GlobalScope{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVulnRequests(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VulnerabilityRequest_Scope_Image) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVulnRequests
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Image: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Image: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Registry", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Registry = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Remote", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Remote = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tag", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVulnRequests
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tag = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVulnRequests(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VulnerabilityRequest_Scope_Global) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVulnRequests
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Global: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Global: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipVulnRequests(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthVulnRequests
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipVulnRequests(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowVulnRequests
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowVulnRequests
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthVulnRequests
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupVulnRequests
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthVulnRequests
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthVulnRequests        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowVulnRequests          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupVulnRequests = fmt.Errorf("proto: unexpected end of group")
)
