// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/vulnerability.proto

package storage

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type EmbeddedVulnerability_ScoreVersion int32

const (
	EmbeddedVulnerability_V2 EmbeddedVulnerability_ScoreVersion = 0
	EmbeddedVulnerability_V3 EmbeddedVulnerability_ScoreVersion = 1
)

var EmbeddedVulnerability_ScoreVersion_name = map[int32]string{
	0: "V2",
	1: "V3",
}

var EmbeddedVulnerability_ScoreVersion_value = map[string]int32{
	"V2": 0,
	"V3": 1,
}

func (x EmbeddedVulnerability_ScoreVersion) String() string {
	return proto.EnumName(EmbeddedVulnerability_ScoreVersion_name, int32(x))
}

func (EmbeddedVulnerability_ScoreVersion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_6f066c439a54ddc6, []int{0, 0}
}

type EmbeddedVulnerability_VulnerabilityType int32

const (
	EmbeddedVulnerability_UNKNOWN_VULNERABILITY   EmbeddedVulnerability_VulnerabilityType = 0
	EmbeddedVulnerability_IMAGE_VULNERABILITY     EmbeddedVulnerability_VulnerabilityType = 1
	EmbeddedVulnerability_K8S_VULNERABILITY       EmbeddedVulnerability_VulnerabilityType = 2
	EmbeddedVulnerability_ISTIO_VULNERABILITY     EmbeddedVulnerability_VulnerabilityType = 3
	EmbeddedVulnerability_NODE_VULNERABILITY      EmbeddedVulnerability_VulnerabilityType = 4
	EmbeddedVulnerability_OPENSHIFT_VULNERABILITY EmbeddedVulnerability_VulnerabilityType = 5
)

var EmbeddedVulnerability_VulnerabilityType_name = map[int32]string{
	0: "UNKNOWN_VULNERABILITY",
	1: "IMAGE_VULNERABILITY",
	2: "K8S_VULNERABILITY",
	3: "ISTIO_VULNERABILITY",
	4: "NODE_VULNERABILITY",
	5: "OPENSHIFT_VULNERABILITY",
}

var EmbeddedVulnerability_VulnerabilityType_value = map[string]int32{
	"UNKNOWN_VULNERABILITY":   0,
	"IMAGE_VULNERABILITY":     1,
	"K8S_VULNERABILITY":       2,
	"ISTIO_VULNERABILITY":     3,
	"NODE_VULNERABILITY":      4,
	"OPENSHIFT_VULNERABILITY": 5,
}

func (x EmbeddedVulnerability_VulnerabilityType) String() string {
	return proto.EnumName(EmbeddedVulnerability_VulnerabilityType_name, int32(x))
}

func (EmbeddedVulnerability_VulnerabilityType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_6f066c439a54ddc6, []int{0, 1}
}

// Next Tag: 21
type EmbeddedVulnerability struct {
	Cve     string  `protobuf:"bytes,1,opt,name=cve,proto3" json:"cve,omitempty" search:"CVE,store"`
	Cvss    float32 `protobuf:"fixed32,2,opt,name=cvss,proto3" json:"cvss,omitempty" search:"CVSS,store"`
	Summary string  `protobuf:"bytes,3,opt,name=summary,proto3" json:"summary,omitempty"`
	Link    string  `protobuf:"bytes,4,opt,name=link,proto3" json:"link,omitempty"`
	// Types that are valid to be assigned to SetFixedBy:
	//	*EmbeddedVulnerability_FixedBy
	SetFixedBy   isEmbeddedVulnerability_SetFixedBy `protobuf_oneof:"set_fixed_by"`
	ScoreVersion EmbeddedVulnerability_ScoreVersion `protobuf:"varint,8,opt,name=score_version,json=scoreVersion,proto3,enum=storage.EmbeddedVulnerability_ScoreVersion" json:"score_version,omitempty"`
	CvssV2       *CVSSV2                            `protobuf:"bytes,6,opt,name=cvss_v2,json=cvssV2,proto3" json:"cvss_v2,omitempty"`
	CvssV3       *CVSSV3                            `protobuf:"bytes,7,opt,name=cvss_v3,json=cvssV3,proto3" json:"cvss_v3,omitempty"`
	PublishedOn  *types.Timestamp                   `protobuf:"bytes,9,opt,name=published_on,json=publishedOn,proto3" json:"published_on,omitempty" search:"CVE Published On"`
	LastModified *types.Timestamp                   `protobuf:"bytes,10,opt,name=last_modified,json=lastModified,proto3" json:"last_modified,omitempty"`
	// For internal purposes only.
	VulnerabilityType  EmbeddedVulnerability_VulnerabilityType   `protobuf:"varint,11,opt,name=vulnerability_type,json=vulnerabilityType,proto3,enum=storage.EmbeddedVulnerability_VulnerabilityType" json:"vulnerability_type,omitempty"`
	VulnerabilityTypes []EmbeddedVulnerability_VulnerabilityType `protobuf:"varint,18,rep,packed,name=vulnerability_types,json=vulnerabilityTypes,proto3,enum=storage.EmbeddedVulnerability_VulnerabilityType" json:"vulnerability_types,omitempty"`
	Suppressed         bool                                      `protobuf:"varint,12,opt,name=suppressed,proto3" json:"suppressed,omitempty" search:"CVE Snoozed"`
	SuppressActivation *types.Timestamp                          `protobuf:"bytes,13,opt,name=suppress_activation,json=suppressActivation,proto3" json:"suppress_activation,omitempty"`
	SuppressExpiry     *types.Timestamp                          `protobuf:"bytes,14,opt,name=suppress_expiry,json=suppressExpiry,proto3" json:"suppress_expiry,omitempty"`
	// Time when the CVE was first seen in the system.
	FirstSystemOccurrence *types.Timestamp `protobuf:"bytes,15,opt,name=first_system_occurrence,json=firstSystemOccurrence,proto3" json:"first_system_occurrence,omitempty"`
	// Time when the CVE was first seen in the image.
	FirstImageOccurrence *types.Timestamp `protobuf:"bytes,16,opt,name=first_image_occurrence,json=firstImageOccurrence,proto3" json:"first_image_occurrence,omitempty"`
	// Time when the CVE was first seen in the node.
	FirstNodeOccurrence  *types.Timestamp      `protobuf:"bytes,17,opt,name=first_node_occurrence,json=firstNodeOccurrence,proto3" json:"first_node_occurrence,omitempty"`
	Severity             VulnerabilitySeverity `protobuf:"varint,19,opt,name=severity,proto3,enum=storage.VulnerabilitySeverity" json:"severity,omitempty" policy:"Severity"`
	State                VulnerabilityState    `protobuf:"varint,20,opt,name=state,proto3,enum=storage.VulnerabilityState" json:"state,omitempty" search:"Vulnerability State"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *EmbeddedVulnerability) Reset()         { *m = EmbeddedVulnerability{} }
func (m *EmbeddedVulnerability) String() string { return proto.CompactTextString(m) }
func (*EmbeddedVulnerability) ProtoMessage()    {}
func (*EmbeddedVulnerability) Descriptor() ([]byte, []int) {
	return fileDescriptor_6f066c439a54ddc6, []int{0}
}
func (m *EmbeddedVulnerability) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EmbeddedVulnerability) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EmbeddedVulnerability.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EmbeddedVulnerability) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EmbeddedVulnerability.Merge(m, src)
}
func (m *EmbeddedVulnerability) XXX_Size() int {
	return m.Size()
}
func (m *EmbeddedVulnerability) XXX_DiscardUnknown() {
	xxx_messageInfo_EmbeddedVulnerability.DiscardUnknown(m)
}

var xxx_messageInfo_EmbeddedVulnerability proto.InternalMessageInfo

type isEmbeddedVulnerability_SetFixedBy interface {
	isEmbeddedVulnerability_SetFixedBy()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isEmbeddedVulnerability_SetFixedBy
}

type EmbeddedVulnerability_FixedBy struct {
	FixedBy string `protobuf:"bytes,5,opt,name=fixed_by,json=fixedBy,proto3,oneof" json:"fixed_by,omitempty" search:"Fixed By,store,hidden"`
}

func (*EmbeddedVulnerability_FixedBy) isEmbeddedVulnerability_SetFixedBy() {}
func (m *EmbeddedVulnerability_FixedBy) Clone() isEmbeddedVulnerability_SetFixedBy {
	if m == nil {
		return nil
	}
	cloned := new(EmbeddedVulnerability_FixedBy)
	*cloned = *m

	return cloned
}

func (m *EmbeddedVulnerability) GetSetFixedBy() isEmbeddedVulnerability_SetFixedBy {
	if m != nil {
		return m.SetFixedBy
	}
	return nil
}

func (m *EmbeddedVulnerability) GetCve() string {
	if m != nil {
		return m.Cve
	}
	return ""
}

func (m *EmbeddedVulnerability) GetCvss() float32 {
	if m != nil {
		return m.Cvss
	}
	return 0
}

func (m *EmbeddedVulnerability) GetSummary() string {
	if m != nil {
		return m.Summary
	}
	return ""
}

func (m *EmbeddedVulnerability) GetLink() string {
	if m != nil {
		return m.Link
	}
	return ""
}

func (m *EmbeddedVulnerability) GetFixedBy() string {
	if x, ok := m.GetSetFixedBy().(*EmbeddedVulnerability_FixedBy); ok {
		return x.FixedBy
	}
	return ""
}

func (m *EmbeddedVulnerability) GetScoreVersion() EmbeddedVulnerability_ScoreVersion {
	if m != nil {
		return m.ScoreVersion
	}
	return EmbeddedVulnerability_V2
}

func (m *EmbeddedVulnerability) GetCvssV2() *CVSSV2 {
	if m != nil {
		return m.CvssV2
	}
	return nil
}

func (m *EmbeddedVulnerability) GetCvssV3() *CVSSV3 {
	if m != nil {
		return m.CvssV3
	}
	return nil
}

func (m *EmbeddedVulnerability) GetPublishedOn() *types.Timestamp {
	if m != nil {
		return m.PublishedOn
	}
	return nil
}

func (m *EmbeddedVulnerability) GetLastModified() *types.Timestamp {
	if m != nil {
		return m.LastModified
	}
	return nil
}

func (m *EmbeddedVulnerability) GetVulnerabilityType() EmbeddedVulnerability_VulnerabilityType {
	if m != nil {
		return m.VulnerabilityType
	}
	return EmbeddedVulnerability_UNKNOWN_VULNERABILITY
}

func (m *EmbeddedVulnerability) GetVulnerabilityTypes() []EmbeddedVulnerability_VulnerabilityType {
	if m != nil {
		return m.VulnerabilityTypes
	}
	return nil
}

func (m *EmbeddedVulnerability) GetSuppressed() bool {
	if m != nil {
		return m.Suppressed
	}
	return false
}

func (m *EmbeddedVulnerability) GetSuppressActivation() *types.Timestamp {
	if m != nil {
		return m.SuppressActivation
	}
	return nil
}

func (m *EmbeddedVulnerability) GetSuppressExpiry() *types.Timestamp {
	if m != nil {
		return m.SuppressExpiry
	}
	return nil
}

func (m *EmbeddedVulnerability) GetFirstSystemOccurrence() *types.Timestamp {
	if m != nil {
		return m.FirstSystemOccurrence
	}
	return nil
}

func (m *EmbeddedVulnerability) GetFirstImageOccurrence() *types.Timestamp {
	if m != nil {
		return m.FirstImageOccurrence
	}
	return nil
}

func (m *EmbeddedVulnerability) GetFirstNodeOccurrence() *types.Timestamp {
	if m != nil {
		return m.FirstNodeOccurrence
	}
	return nil
}

func (m *EmbeddedVulnerability) GetSeverity() VulnerabilitySeverity {
	if m != nil {
		return m.Severity
	}
	return VulnerabilitySeverity_UNKNOWN_VULNERABILITY_SEVERITY
}

func (m *EmbeddedVulnerability) GetState() VulnerabilityState {
	if m != nil {
		return m.State
	}
	return VulnerabilityState_OBSERVED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*EmbeddedVulnerability) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*EmbeddedVulnerability_FixedBy)(nil),
	}
}

func (m *EmbeddedVulnerability) MessageClone() proto.Message {
	return m.Clone()
}
func (m *EmbeddedVulnerability) Clone() *EmbeddedVulnerability {
	if m == nil {
		return nil
	}
	cloned := new(EmbeddedVulnerability)
	*cloned = *m

	if m.SetFixedBy != nil {
		cloned.SetFixedBy = m.SetFixedBy.Clone()
	}
	cloned.CvssV2 = m.CvssV2.Clone()
	cloned.CvssV3 = m.CvssV3.Clone()
	cloned.PublishedOn = m.PublishedOn.Clone()
	cloned.LastModified = m.LastModified.Clone()
	if m.VulnerabilityTypes != nil {
		cloned.VulnerabilityTypes = make([]EmbeddedVulnerability_VulnerabilityType, len(m.VulnerabilityTypes))
		copy(cloned.VulnerabilityTypes, m.VulnerabilityTypes)
	}
	cloned.SuppressActivation = m.SuppressActivation.Clone()
	cloned.SuppressExpiry = m.SuppressExpiry.Clone()
	cloned.FirstSystemOccurrence = m.FirstSystemOccurrence.Clone()
	cloned.FirstImageOccurrence = m.FirstImageOccurrence.Clone()
	cloned.FirstNodeOccurrence = m.FirstNodeOccurrence.Clone()
	return cloned
}

func init() {
	proto.RegisterEnum("storage.EmbeddedVulnerability_ScoreVersion", EmbeddedVulnerability_ScoreVersion_name, EmbeddedVulnerability_ScoreVersion_value)
	proto.RegisterEnum("storage.EmbeddedVulnerability_VulnerabilityType", EmbeddedVulnerability_VulnerabilityType_name, EmbeddedVulnerability_VulnerabilityType_value)
	proto.RegisterType((*EmbeddedVulnerability)(nil), "storage.EmbeddedVulnerability")
}

func init() { proto.RegisterFile("storage/vulnerability.proto", fileDescriptor_6f066c439a54ddc6) }

var fileDescriptor_6f066c439a54ddc6 = []byte{
	// 830 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x95, 0xdd, 0x6e, 0xe2, 0x46,
	0x14, 0xc7, 0xe3, 0x7c, 0x91, 0x3d, 0x21, 0x1f, 0x0c, 0x21, 0x99, 0x24, 0x2d, 0x58, 0xbe, 0x42,
	0xda, 0x15, 0xa9, 0xa0, 0x17, 0xab, 0xbd, 0x59, 0xc5, 0x5b, 0xb6, 0x8b, 0xb2, 0x0b, 0xa9, 0xcd,
	0x52, 0xb5, 0xaa, 0x64, 0x19, 0x7b, 0x42, 0x46, 0x8b, 0x3d, 0x96, 0x67, 0xb0, 0xe2, 0x3e, 0x49,
	0x1f, 0xa2, 0x52, 0x5f, 0xa3, 0x97, 0x7d, 0x02, 0x54, 0xa5, 0x6f, 0xc0, 0x13, 0x54, 0x1e, 0x63,
	0xd6, 0x90, 0xad, 0x90, 0x7a, 0x95, 0x99, 0x73, 0xfe, 0xff, 0xdf, 0xc9, 0x9c, 0x73, 0x64, 0xe0,
	0x92, 0x0b, 0x16, 0xda, 0x23, 0x72, 0x15, 0x4d, 0xc6, 0x3e, 0x09, 0xed, 0x21, 0x1d, 0x53, 0x11,
	0x37, 0x82, 0x90, 0x09, 0x86, 0x0a, 0xf3, 0xe4, 0x45, 0x6d, 0xc4, 0xd8, 0x68, 0x4c, 0xae, 0x64,
	0x78, 0x38, 0xb9, 0xbb, 0x12, 0xd4, 0x23, 0x5c, 0xd8, 0x5e, 0x90, 0x2a, 0x2f, 0x4a, 0x19, 0xc6,
	0x89, 0xc8, 0x3c, 0x74, 0x32, 0x62, 0x23, 0x26, 0x8f, 0x57, 0xc9, 0x29, 0x8d, 0x6a, 0x7f, 0x14,
	0xa1, 0xd2, 0xf6, 0x86, 0xc4, 0x75, 0x89, 0x3b, 0xc8, 0x97, 0x44, 0x75, 0xd8, 0x72, 0x22, 0x82,
	0x15, 0x55, 0xa9, 0x3f, 0xd3, 0x4f, 0x67, 0xd3, 0x1a, 0xe2, 0xc4, 0x0e, 0x9d, 0xfb, 0x57, 0xda,
	0x9b, 0x41, 0xfb, 0x45, 0xc2, 0x27, 0x9a, 0x91, 0x48, 0xd0, 0x73, 0xd8, 0x76, 0x22, 0xce, 0xf1,
	0xa6, 0xaa, 0xd4, 0x37, 0xf5, 0xb3, 0xd9, 0xb4, 0x56, 0xfe, 0x2c, 0x35, 0xcd, 0x4c, 0x2b, 0x45,
	0x08, 0x43, 0x81, 0x4f, 0x3c, 0xcf, 0x0e, 0x63, 0xbc, 0x95, 0xa0, 0x8d, 0xec, 0x8a, 0x10, 0x6c,
	0x8f, 0xa9, 0xff, 0x09, 0x6f, 0xcb, 0xb0, 0x3c, 0xa3, 0xd7, 0xb0, 0x77, 0x47, 0x1f, 0x88, 0x6b,
	0x0d, 0x63, 0xbc, 0x23, 0xff, 0x13, 0x6d, 0x36, 0xad, 0x55, 0x33, 0xfc, 0xdb, 0x24, 0xa7, 0xea,
	0x71, 0x5a, 0xe2, 0xc5, 0x3d, 0x75, 0x5d, 0xe2, 0x6b, 0xef, 0x36, 0x8c, 0x82, 0x74, 0xe9, 0x31,
	0xba, 0x85, 0x03, 0xee, 0xb0, 0x90, 0x58, 0x11, 0x09, 0x39, 0x65, 0x3e, 0xde, 0x53, 0x95, 0xfa,
	0x61, 0xf3, 0x79, 0x63, 0xde, 0xa0, 0xc6, 0x17, 0x1f, 0xdf, 0x30, 0x13, 0xcf, 0x20, 0xb5, 0x18,
	0x45, 0x9e, 0xbb, 0xa1, 0x3a, 0x14, 0x92, 0x87, 0x58, 0x51, 0x13, 0xef, 0xaa, 0x4a, 0x7d, 0xbf,
	0x79, 0xb4, 0x60, 0x25, 0xaf, 0x1d, 0x34, 0x8d, 0xdd, 0x24, 0x3f, 0x68, 0x7e, 0x56, 0xb6, 0x70,
	0xe1, 0x4b, 0xca, 0xd6, 0x5c, 0xd9, 0x42, 0xbf, 0x40, 0x31, 0x98, 0x0c, 0xc7, 0x94, 0xdf, 0x13,
	0xd7, 0x62, 0x3e, 0x7e, 0x26, 0xe5, 0x17, 0x8d, 0x74, 0xcc, 0x8d, 0x6c, 0xcc, 0x8d, 0x7e, 0x36,
	0x66, 0xfd, 0xeb, 0xd9, 0xb4, 0x76, 0x9e, 0x1b, 0x88, 0x7a, 0x9b, 0xf9, 0xd5, 0x9e, 0xaf, 0x19,
	0xfb, 0x0b, 0x5c, 0xcf, 0x47, 0xaf, 0xe1, 0x60, 0x6c, 0x73, 0x61, 0x79, 0xcc, 0xa5, 0x77, 0x94,
	0xb8, 0x18, 0xd6, 0xe1, 0x8d, 0x62, 0x62, 0xf8, 0x30, 0xd7, 0x23, 0x0b, 0xd0, 0xd2, 0x3a, 0x5a,
	0x22, 0x0e, 0x08, 0xde, 0x97, 0x9d, 0xfc, 0x66, 0x4d, 0x27, 0x97, 0x6e, 0xfd, 0x38, 0x20, 0x46,
	0x29, 0x5a, 0x0d, 0x21, 0x1b, 0xca, 0x4f, 0x0b, 0x70, 0x8c, 0xd4, 0xad, 0xff, 0x55, 0x01, 0x3d,
	0xa9, 0xc0, 0xd1, 0x4b, 0x00, 0x3e, 0x09, 0x82, 0x90, 0x70, 0x4e, 0x5c, 0x5c, 0x54, 0x95, 0xfa,
	0x9e, 0x8e, 0x67, 0xd3, 0xda, 0x49, 0xbe, 0x89, 0xa6, 0xcf, 0xd8, 0xaf, 0xc4, 0xd5, 0x8c, 0x9c,
	0x16, 0xdd, 0x40, 0x39, 0xbb, 0x59, 0xb6, 0x23, 0x68, 0x64, 0x8b, 0x64, 0x91, 0x0e, 0xd6, 0x36,
	0x11, 0x65, 0xb6, 0xeb, 0x85, 0x0b, 0xbd, 0x81, 0xa3, 0x05, 0x8c, 0x3c, 0x04, 0x34, 0x8c, 0xf1,
	0xe1, 0x5a, 0xd0, 0x61, 0x66, 0x69, 0x4b, 0x07, 0x32, 0xe0, 0xec, 0x8e, 0x86, 0x5c, 0x58, 0x3c,
	0xe6, 0x82, 0x78, 0x16, 0x73, 0x9c, 0x49, 0x18, 0x12, 0xdf, 0x21, 0xf8, 0x68, 0x2d, 0xac, 0x22,
	0xad, 0xa6, 0x74, 0xf6, 0x16, 0x46, 0x74, 0x0b, 0xa7, 0x29, 0x93, 0x7a, 0xf6, 0x88, 0xe4, 0x91,
	0xc7, 0x6b, 0x91, 0x27, 0xd2, 0xd9, 0x49, 0x8c, 0x39, 0x62, 0x17, 0xd2, 0x52, 0x96, 0xcf, 0xdc,
	0x25, 0x60, 0x69, 0x2d, 0xb0, 0x2c, 0x8d, 0x5d, 0xe6, 0xe6, 0x79, 0x3f, 0xc0, 0x1e, 0x27, 0x11,
	0x09, 0xa9, 0x88, 0x71, 0x59, 0xee, 0x5e, 0x75, 0xb1, 0x19, 0x4b, 0x3b, 0x60, 0xce, 0x55, 0x7a,
	0x65, 0x36, 0xad, 0x95, 0x02, 0x36, 0xa6, 0x4e, 0xfc, 0x4a, 0xcb, 0xa2, 0x9a, 0xb1, 0xc0, 0x20,
	0x13, 0x76, 0xb8, 0xb0, 0x05, 0xc1, 0x27, 0x92, 0x77, 0xf9, 0x1f, 0xbc, 0x44, 0xa2, 0xab, 0xb3,
	0x69, 0xed, 0xab, 0x6c, 0x59, 0x96, 0xf2, 0xaa, 0x14, 0x68, 0x46, 0xca, 0xd2, 0xaa, 0x50, 0xcc,
	0x7f, 0x3e, 0xd0, 0x2e, 0x6c, 0x0e, 0x9a, 0xc7, 0x1b, 0xf2, 0x6f, 0xeb, 0x58, 0xd1, 0x7e, 0x57,
	0xa0, 0xf4, 0x64, 0x67, 0xd1, 0x39, 0x54, 0x3e, 0x76, 0x6f, 0xba, 0xbd, 0x1f, 0xbb, 0xd6, 0xe0,
	0xe3, 0xfb, 0x6e, 0xdb, 0xb8, 0xd6, 0x3b, 0xef, 0x3b, 0xfd, 0x9f, 0x8e, 0x37, 0xd0, 0x19, 0x94,
	0x3b, 0x1f, 0xae, 0xbf, 0x6f, 0xaf, 0x24, 0x14, 0x54, 0x81, 0xd2, 0xcd, 0x4b, 0x73, 0x25, 0xbc,
	0x29, 0xf5, 0x66, 0xbf, 0xd3, 0x5b, 0x49, 0x6c, 0xa1, 0x53, 0x40, 0xdd, 0xde, 0x77, 0xab, 0x9c,
	0x6d, 0x74, 0x09, 0x67, 0xbd, 0xdb, 0x76, 0xd7, 0x7c, 0xd7, 0x79, 0xdb, 0x5f, 0x49, 0xee, 0xe8,
	0x87, 0x50, 0xe4, 0x44, 0x58, 0xd9, 0x67, 0x58, 0xff, 0xf6, 0xcf, 0xc7, 0xaa, 0xf2, 0xd7, 0x63,
	0x55, 0xf9, 0xfb, 0xb1, 0xaa, 0xfc, 0xf6, 0x4f, 0x75, 0x03, 0xce, 0x29, 0x6b, 0x70, 0x61, 0x3b,
	0x9f, 0x42, 0xf6, 0x90, 0x4e, 0x33, 0xeb, 0xe3, 0xcf, 0xd9, 0x2f, 0xd6, 0x70, 0x57, 0xc6, 0x5b,
	0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0xf9, 0xb3, 0xa9, 0x9c, 0xe0, 0x06, 0x00, 0x00,
}

func (m *EmbeddedVulnerability) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EmbeddedVulnerability) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EmbeddedVulnerability) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.State != 0 {
		i = encodeVarintVulnerability(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa0
	}
	if m.Severity != 0 {
		i = encodeVarintVulnerability(dAtA, i, uint64(m.Severity))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x98
	}
	if len(m.VulnerabilityTypes) > 0 {
		dAtA2 := make([]byte, len(m.VulnerabilityTypes)*10)
		var j1 int
		for _, num := range m.VulnerabilityTypes {
			for num >= 1<<7 {
				dAtA2[j1] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j1++
			}
			dAtA2[j1] = uint8(num)
			j1++
		}
		i -= j1
		copy(dAtA[i:], dAtA2[:j1])
		i = encodeVarintVulnerability(dAtA, i, uint64(j1))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if m.FirstNodeOccurrence != nil {
		{
			size, err := m.FirstNodeOccurrence.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnerability(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if m.FirstImageOccurrence != nil {
		{
			size, err := m.FirstImageOccurrence.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnerability(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if m.FirstSystemOccurrence != nil {
		{
			size, err := m.FirstSystemOccurrence.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnerability(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x7a
	}
	if m.SuppressExpiry != nil {
		{
			size, err := m.SuppressExpiry.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnerability(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x72
	}
	if m.SuppressActivation != nil {
		{
			size, err := m.SuppressActivation.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnerability(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	if m.Suppressed {
		i--
		if m.Suppressed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x60
	}
	if m.VulnerabilityType != 0 {
		i = encodeVarintVulnerability(dAtA, i, uint64(m.VulnerabilityType))
		i--
		dAtA[i] = 0x58
	}
	if m.LastModified != nil {
		{
			size, err := m.LastModified.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnerability(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.PublishedOn != nil {
		{
			size, err := m.PublishedOn.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnerability(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.ScoreVersion != 0 {
		i = encodeVarintVulnerability(dAtA, i, uint64(m.ScoreVersion))
		i--
		dAtA[i] = 0x40
	}
	if m.CvssV3 != nil {
		{
			size, err := m.CvssV3.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnerability(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.CvssV2 != nil {
		{
			size, err := m.CvssV2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVulnerability(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.SetFixedBy != nil {
		{
			size := m.SetFixedBy.Size()
			i -= size
			if _, err := m.SetFixedBy.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Link) > 0 {
		i -= len(m.Link)
		copy(dAtA[i:], m.Link)
		i = encodeVarintVulnerability(dAtA, i, uint64(len(m.Link)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Summary) > 0 {
		i -= len(m.Summary)
		copy(dAtA[i:], m.Summary)
		i = encodeVarintVulnerability(dAtA, i, uint64(len(m.Summary)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Cvss != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.Cvss))))
		i--
		dAtA[i] = 0x15
	}
	if len(m.Cve) > 0 {
		i -= len(m.Cve)
		copy(dAtA[i:], m.Cve)
		i = encodeVarintVulnerability(dAtA, i, uint64(len(m.Cve)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EmbeddedVulnerability_FixedBy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EmbeddedVulnerability_FixedBy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.FixedBy)
	copy(dAtA[i:], m.FixedBy)
	i = encodeVarintVulnerability(dAtA, i, uint64(len(m.FixedBy)))
	i--
	dAtA[i] = 0x2a
	return len(dAtA) - i, nil
}
func encodeVarintVulnerability(dAtA []byte, offset int, v uint64) int {
	offset -= sovVulnerability(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *EmbeddedVulnerability) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Cve)
	if l > 0 {
		n += 1 + l + sovVulnerability(uint64(l))
	}
	if m.Cvss != 0 {
		n += 5
	}
	l = len(m.Summary)
	if l > 0 {
		n += 1 + l + sovVulnerability(uint64(l))
	}
	l = len(m.Link)
	if l > 0 {
		n += 1 + l + sovVulnerability(uint64(l))
	}
	if m.SetFixedBy != nil {
		n += m.SetFixedBy.Size()
	}
	if m.CvssV2 != nil {
		l = m.CvssV2.Size()
		n += 1 + l + sovVulnerability(uint64(l))
	}
	if m.CvssV3 != nil {
		l = m.CvssV3.Size()
		n += 1 + l + sovVulnerability(uint64(l))
	}
	if m.ScoreVersion != 0 {
		n += 1 + sovVulnerability(uint64(m.ScoreVersion))
	}
	if m.PublishedOn != nil {
		l = m.PublishedOn.Size()
		n += 1 + l + sovVulnerability(uint64(l))
	}
	if m.LastModified != nil {
		l = m.LastModified.Size()
		n += 1 + l + sovVulnerability(uint64(l))
	}
	if m.VulnerabilityType != 0 {
		n += 1 + sovVulnerability(uint64(m.VulnerabilityType))
	}
	if m.Suppressed {
		n += 2
	}
	if m.SuppressActivation != nil {
		l = m.SuppressActivation.Size()
		n += 1 + l + sovVulnerability(uint64(l))
	}
	if m.SuppressExpiry != nil {
		l = m.SuppressExpiry.Size()
		n += 1 + l + sovVulnerability(uint64(l))
	}
	if m.FirstSystemOccurrence != nil {
		l = m.FirstSystemOccurrence.Size()
		n += 1 + l + sovVulnerability(uint64(l))
	}
	if m.FirstImageOccurrence != nil {
		l = m.FirstImageOccurrence.Size()
		n += 2 + l + sovVulnerability(uint64(l))
	}
	if m.FirstNodeOccurrence != nil {
		l = m.FirstNodeOccurrence.Size()
		n += 2 + l + sovVulnerability(uint64(l))
	}
	if len(m.VulnerabilityTypes) > 0 {
		l = 0
		for _, e := range m.VulnerabilityTypes {
			l += sovVulnerability(uint64(e))
		}
		n += 2 + sovVulnerability(uint64(l)) + l
	}
	if m.Severity != 0 {
		n += 2 + sovVulnerability(uint64(m.Severity))
	}
	if m.State != 0 {
		n += 2 + sovVulnerability(uint64(m.State))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EmbeddedVulnerability_FixedBy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.FixedBy)
	n += 1 + l + sovVulnerability(uint64(l))
	return n
}

func sovVulnerability(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozVulnerability(x uint64) (n int) {
	return sovVulnerability(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *EmbeddedVulnerability) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVulnerability
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EmbeddedVulnerability: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EmbeddedVulnerability: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cve", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVulnerability
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVulnerability
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cve = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cvss", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.Cvss = float32(math.Float32frombits(v))
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Summary", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVulnerability
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVulnerability
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Summary = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Link", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVulnerability
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVulnerability
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Link = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FixedBy", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVulnerability
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVulnerability
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SetFixedBy = &EmbeddedVulnerability_FixedBy{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CvssV2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnerability
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnerability
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CvssV2 == nil {
				m.CvssV2 = &CVSSV2{}
			}
			if err := m.CvssV2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CvssV3", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnerability
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnerability
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CvssV3 == nil {
				m.CvssV3 = &CVSSV3{}
			}
			if err := m.CvssV3.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScoreVersion", wireType)
			}
			m.ScoreVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScoreVersion |= EmbeddedVulnerability_ScoreVersion(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PublishedOn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnerability
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnerability
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PublishedOn == nil {
				m.PublishedOn = &types.Timestamp{}
			}
			if err := m.PublishedOn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastModified", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnerability
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnerability
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastModified == nil {
				m.LastModified = &types.Timestamp{}
			}
			if err := m.LastModified.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field VulnerabilityType", wireType)
			}
			m.VulnerabilityType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.VulnerabilityType |= EmbeddedVulnerability_VulnerabilityType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Suppressed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Suppressed = bool(v != 0)
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SuppressActivation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnerability
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnerability
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SuppressActivation == nil {
				m.SuppressActivation = &types.Timestamp{}
			}
			if err := m.SuppressActivation.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SuppressExpiry", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnerability
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnerability
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SuppressExpiry == nil {
				m.SuppressExpiry = &types.Timestamp{}
			}
			if err := m.SuppressExpiry.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstSystemOccurrence", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnerability
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnerability
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FirstSystemOccurrence == nil {
				m.FirstSystemOccurrence = &types.Timestamp{}
			}
			if err := m.FirstSystemOccurrence.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstImageOccurrence", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnerability
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnerability
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FirstImageOccurrence == nil {
				m.FirstImageOccurrence = &types.Timestamp{}
			}
			if err := m.FirstImageOccurrence.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstNodeOccurrence", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVulnerability
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVulnerability
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FirstNodeOccurrence == nil {
				m.FirstNodeOccurrence = &types.Timestamp{}
			}
			if err := m.FirstNodeOccurrence.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 18:
			if wireType == 0 {
				var v EmbeddedVulnerability_VulnerabilityType
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVulnerability
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= EmbeddedVulnerability_VulnerabilityType(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.VulnerabilityTypes = append(m.VulnerabilityTypes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVulnerability
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthVulnerability
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthVulnerability
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.VulnerabilityTypes) == 0 {
					m.VulnerabilityTypes = make([]EmbeddedVulnerability_VulnerabilityType, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v EmbeddedVulnerability_VulnerabilityType
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVulnerability
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= EmbeddedVulnerability_VulnerabilityType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.VulnerabilityTypes = append(m.VulnerabilityTypes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field VulnerabilityTypes", wireType)
			}
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Severity", wireType)
			}
			m.Severity = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Severity |= VulnerabilitySeverity(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= VulnerabilityState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipVulnerability(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthVulnerability
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipVulnerability(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowVulnerability
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowVulnerability
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthVulnerability
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupVulnerability
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthVulnerability
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthVulnerability        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowVulnerability          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupVulnerability = fmt.Errorf("proto: unexpected end of group")
)
