// Code generated by genny. DO NOT EDIT.
// This file was automatically generated by genny.
// Any changes will be lost if this file is regenerated.
// see https://github.com/mauricelam/genny

package maputil

import (
	"github.com/stackrox/rox/pkg/sync"
)

// CloneStringStringMap clones a map of the given type.
func CloneStringStringMap(inputMap map[string]string) map[string]string {
	cloned := make(map[string]string, len(inputMap))
	for k, v := range inputMap {
		cloned[k] = v
	}
	return cloned
}

// StringStringMapsEqual compares if two maps of the given type are equal.
func StringStringMapsEqual(a, b map[string]string) bool {
	if len(a) != len(b) {
		return false
	}
	for k, aV := range a {
		if bV, ok := b[k]; !ok || aV != bV {
			return false
		}
	}
	return true
}

// StringStringFastRMap is a thread-safe map from string to string that is optimized for read-heavy access patterns.
// Writes are expensive because it clones, mutates and replaces the map instead of an in-place addition.
// Use NewStringString to instantiate.
type StringStringFastRMap struct {
	lock sync.RWMutex
	m    *map[string]string
}

// NewStringStringFastRMap returns an empty, read-to-use, StringStringFastRMap.
func NewStringStringFastRMap() StringStringFastRMap {
	initialMap := make(map[string]string)
	return StringStringFastRMap{m: &initialMap}
}

func (m *StringStringFastRMap) getCurrentMapPtr() *map[string]string {
	m.lock.RLock()
	defer m.lock.RUnlock()
	return m.m
}

// GetMap returns a snapshot of the current map.
// Please don't hold on to it for too long because the map can be out-of-date.
// Further, do not mutate its contents UNLESS you know that you are the only
// user who will mutate the map.
func (m *StringStringFastRMap) GetMap() map[string]string {
	currentPtr := m.getCurrentMapPtr()
	return *currentPtr
}

// DeleteMany deletes the specified keys.
func (m *StringStringFastRMap) DeleteMany(keys ...string) {
	m.cloneAndMutate(func(clonedMap map[string]string) {
		for _, k := range keys {
			delete(clonedMap, k)
		}
	})
}

// SetMany merges the passed map into the current map.
// If there are key collisions, the passed-in map's elements take precedence.
func (m *StringStringFastRMap) SetMany(elements map[string]string) {
	m.cloneAndMutate(func(clonedMap map[string]string) {
		for k, v := range elements {
			clonedMap[k] = v
		}
	})
}

// Set sets the value for the given key.
func (m *StringStringFastRMap) Set(k string, v string) {
	m.cloneAndMutate(func(clonedMap map[string]string) {
		clonedMap[k] = v
	})
}

// Get retrieves the value for the given key.
func (m *StringStringFastRMap) Get(k string) (string, bool) {
	m.lock.RLock()
	defer m.lock.RUnlock()
	val, exists := (*m.m)[k]
	return val, exists
}

// Delete deletes the value for the given key.
func (m *StringStringFastRMap) Delete(k string) {
	m.cloneAndMutate(func(clonedMap map[string]string) {
		delete(clonedMap, k)
	})
}

// In order to block readers for as little time as possible, this implementation serializes writes in a more expensive way.
// We read the current pointer, clone the current map and mutate the cloned map. Then, just before replacing the current map pointer
// with a pointer to the cloned map,
// we acquire the lock, and check whether the current map pointer is the same as the one we started out with.
// If it is not (which means the map was mutated by another goroutine), we go back to the beginning.
// If it is, then we replace the map pointer with our cloned map.
func (m *StringStringFastRMap) cloneAndMutate(mutateFunc func(clonedMap map[string]string)) {
	m.cloneAndMutateWithInitialPtr(m.getCurrentMapPtr(), mutateFunc)
}

func (m *StringStringFastRMap) cloneAndMutateWithInitialPtr(initialMapPtr *map[string]string, mutateFunc func(clonedMap map[string]string)) {
	defer m.lock.Unlock()

	for {
		cloned := CloneStringStringMap(*initialMapPtr)
		mutateFunc(cloned)

		m.lock.Lock()
		if m.m == initialMapPtr {
			m.m = &cloned
			return
		}

		// our work was for nothing, another goroutine beat us to the write!
		initialMapPtr = m.m
		m.lock.Unlock()
	}
}
