package metrics

// Op represents a bolt operation that we want to time.
//go:generate stringer -type=Op
type Op int

// The following is the list of Bolt operations that we want to time.
const (
	Add Op = iota
	AddMany

	Count

	Dedupe

	Exists

	Get
	GetAll
	GetMany

	// Special operation currently used only for processes.
	GetGrouped

	List

	Prune

	Reset
	Rename
	Remove
	RemoveMany

	Search

	Update
	UpdateMany
	Upsert
	UpsertAll
)
