package protoutils

import (
	"testing"

	"github.com/gogo/protobuf/proto"
	golangProto "github.com/golang/protobuf/proto"
	"github.com/stackrox/rox/pkg/fixtures"
)

// This benchmark uses autogenerated clones
func BenchmarkGoGoProtoClone(b *testing.B) {
	st := fixtures.GetImage()
	b.ResetTimer()
	for i := 0; i < b.N; i++ {
		_ = proto.Clone(st)
	}
}

// This benchmark uses reflection
func BenchmarkGolangProtoClone(b *testing.B) {
	st := fixtures.GetImage()
	b.ResetTimer()
	for i := 0; i < b.N; i++ {
		_ = golangProto.Clone(st)
	}
}

func BenchmarkAutogeneratedClone(b *testing.B) {
	st := fixtures.GetImage()
	b.ResetTimer()
	for i := 0; i < b.N; i++ {
		_ = st.Clone()
	}
}
