package types

import (
	"github.com/stackrox/rox/generated/storage"
)

// Config is the config of the registry, which can be utilized by 3rd party scanners
type Config struct {
	Username         string
	Password         string
	Insecure         bool
	URL              string
	RegistryHostname string
	Autogenerated    bool
}

// Registry is the interface that all image registries must implement
type Registry interface {
	Match(image *storage.ImageName) bool
	Metadata(image *storage.Image) (*storage.ImageMetadata, error)
	Test() error
	Config() *Config
	Name() string
}

// ImageRegistry adds a DataSource function to Registry that describes which
// integration formed the interface
type ImageRegistry interface {
	Registry
	DataSource() *storage.DataSource
}

// DockerfileInstructionSet are the set of acceptable keywords in a Dockerfile
var DockerfileInstructionSet = map[string]struct{}{
	"ADD":         {},
	"ARG":         {},
	"CMD":         {},
	"COPY":        {},
	"ENTRYPOINT":  {},
	"ENV":         {},
	"EXPOSE":      {},
	"FROM":        {},
	"HEALTHCHECK": {},
	"LABEL":       {},
	"MAINTAINER":  {},
	"ONBUILD":     {},
	"RUN":         {},
	"SHELL":       {},
	"STOPSIGNAL":  {},
	"USER":        {},
	"VOLUME":      {},
	"WORKDIR":     {},
}
