// Code generated by genny. DO NOT EDIT.
// This file was automatically generated by genny.
// Any changes will be lost if this file is regenerated.
// see https://github.com/mauricelam/genny

package sliceutils

// BoolDiff returns, given two sorted bool slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func BoolDiff(a, b []bool, lessFunc func(a, b bool) bool) (aOnly, bOnly []bool) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// BoolFind returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func BoolFind(slice []bool, elem bool) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// BoolUnique returns a new slice that contains only the first occurrence of each element in slice.
func BoolUnique(slice []bool) []bool {
	result := make([]bool, 0, len(slice))
	seen := make(map[bool]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// BoolDifference returns the array of elements in the first slice that aren't in the second slice
func BoolDifference(slice1, slice2 []bool) []bool {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[bool]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []bool
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// BoolUnion returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func BoolUnion(slice1, slice2 []bool) []bool {
	// Fast-path checks
	if len(slice1) == 0 {
		return BoolUnique(slice2)
	}
	if len(slice2) == 0 {
		return BoolUnique(slice1)
	}

	elemSet := make(map[bool]struct{}, len(slice1))
	var newSlice []bool
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// BoolEqual checks if the two given slices are equal.
func BoolEqual(a, b []bool) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}

// ByteDiff returns, given two sorted byte slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func ByteDiff(a, b []byte, lessFunc func(a, b byte) bool) (aOnly, bOnly []byte) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// ByteFind returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func ByteFind(slice []byte, elem byte) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ByteUnique returns a new slice that contains only the first occurrence of each element in slice.
func ByteUnique(slice []byte) []byte {
	result := make([]byte, 0, len(slice))
	seen := make(map[byte]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// ByteDifference returns the array of elements in the first slice that aren't in the second slice
func ByteDifference(slice1, slice2 []byte) []byte {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[byte]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []byte
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// ByteUnion returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func ByteUnion(slice1, slice2 []byte) []byte {
	// Fast-path checks
	if len(slice1) == 0 {
		return ByteUnique(slice2)
	}
	if len(slice2) == 0 {
		return ByteUnique(slice1)
	}

	elemSet := make(map[byte]struct{}, len(slice1))
	var newSlice []byte
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// ByteEqual checks if the two given slices are equal.
func ByteEqual(a, b []byte) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}

// Complex128Diff returns, given two sorted complex128 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Complex128Diff(a, b []complex128, lessFunc func(a, b complex128) bool) (aOnly, bOnly []complex128) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Complex128Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Complex128Find(slice []complex128, elem complex128) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// Complex128Unique returns a new slice that contains only the first occurrence of each element in slice.
func Complex128Unique(slice []complex128) []complex128 {
	result := make([]complex128, 0, len(slice))
	seen := make(map[complex128]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Complex128Difference returns the array of elements in the first slice that aren't in the second slice
func Complex128Difference(slice1, slice2 []complex128) []complex128 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[complex128]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []complex128
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// Complex128Union returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func Complex128Union(slice1, slice2 []complex128) []complex128 {
	// Fast-path checks
	if len(slice1) == 0 {
		return Complex128Unique(slice2)
	}
	if len(slice2) == 0 {
		return Complex128Unique(slice1)
	}

	elemSet := make(map[complex128]struct{}, len(slice1))
	var newSlice []complex128
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// Complex128Equal checks if the two given slices are equal.
func Complex128Equal(a, b []complex128) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}

// Complex64Diff returns, given two sorted complex64 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Complex64Diff(a, b []complex64, lessFunc func(a, b complex64) bool) (aOnly, bOnly []complex64) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Complex64Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Complex64Find(slice []complex64, elem complex64) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// Complex64Unique returns a new slice that contains only the first occurrence of each element in slice.
func Complex64Unique(slice []complex64) []complex64 {
	result := make([]complex64, 0, len(slice))
	seen := make(map[complex64]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Complex64Difference returns the array of elements in the first slice that aren't in the second slice
func Complex64Difference(slice1, slice2 []complex64) []complex64 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[complex64]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []complex64
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// Complex64Union returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func Complex64Union(slice1, slice2 []complex64) []complex64 {
	// Fast-path checks
	if len(slice1) == 0 {
		return Complex64Unique(slice2)
	}
	if len(slice2) == 0 {
		return Complex64Unique(slice1)
	}

	elemSet := make(map[complex64]struct{}, len(slice1))
	var newSlice []complex64
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// Complex64Equal checks if the two given slices are equal.
func Complex64Equal(a, b []complex64) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}

// ErrorDiff returns, given two sorted error slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func ErrorDiff(a, b []error, lessFunc func(a, b error) bool) (aOnly, bOnly []error) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// ErrorFind returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func ErrorFind(slice []error, elem error) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// ErrorUnique returns a new slice that contains only the first occurrence of each element in slice.
func ErrorUnique(slice []error) []error {
	result := make([]error, 0, len(slice))
	seen := make(map[error]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// ErrorDifference returns the array of elements in the first slice that aren't in the second slice
func ErrorDifference(slice1, slice2 []error) []error {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[error]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []error
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// ErrorUnion returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func ErrorUnion(slice1, slice2 []error) []error {
	// Fast-path checks
	if len(slice1) == 0 {
		return ErrorUnique(slice2)
	}
	if len(slice2) == 0 {
		return ErrorUnique(slice1)
	}

	elemSet := make(map[error]struct{}, len(slice1))
	var newSlice []error
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// ErrorEqual checks if the two given slices are equal.
func ErrorEqual(a, b []error) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}

// Float32Diff returns, given two sorted float32 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Float32Diff(a, b []float32, lessFunc func(a, b float32) bool) (aOnly, bOnly []float32) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Float32Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Float32Find(slice []float32, elem float32) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// Float32Unique returns a new slice that contains only the first occurrence of each element in slice.
func Float32Unique(slice []float32) []float32 {
	result := make([]float32, 0, len(slice))
	seen := make(map[float32]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Float32Difference returns the array of elements in the first slice that aren't in the second slice
func Float32Difference(slice1, slice2 []float32) []float32 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[float32]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []float32
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// Float32Union returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func Float32Union(slice1, slice2 []float32) []float32 {
	// Fast-path checks
	if len(slice1) == 0 {
		return Float32Unique(slice2)
	}
	if len(slice2) == 0 {
		return Float32Unique(slice1)
	}

	elemSet := make(map[float32]struct{}, len(slice1))
	var newSlice []float32
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// Float32Equal checks if the two given slices are equal.
func Float32Equal(a, b []float32) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}

// Float64Diff returns, given two sorted float64 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Float64Diff(a, b []float64, lessFunc func(a, b float64) bool) (aOnly, bOnly []float64) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Float64Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Float64Find(slice []float64, elem float64) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// Float64Unique returns a new slice that contains only the first occurrence of each element in slice.
func Float64Unique(slice []float64) []float64 {
	result := make([]float64, 0, len(slice))
	seen := make(map[float64]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Float64Difference returns the array of elements in the first slice that aren't in the second slice
func Float64Difference(slice1, slice2 []float64) []float64 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[float64]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []float64
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// Float64Union returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func Float64Union(slice1, slice2 []float64) []float64 {
	// Fast-path checks
	if len(slice1) == 0 {
		return Float64Unique(slice2)
	}
	if len(slice2) == 0 {
		return Float64Unique(slice1)
	}

	elemSet := make(map[float64]struct{}, len(slice1))
	var newSlice []float64
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// Float64Equal checks if the two given slices are equal.
func Float64Equal(a, b []float64) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}

// IntDiff returns, given two sorted int slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func IntDiff(a, b []int, lessFunc func(a, b int) bool) (aOnly, bOnly []int) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// IntFind returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func IntFind(slice []int, elem int) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// IntUnique returns a new slice that contains only the first occurrence of each element in slice.
func IntUnique(slice []int) []int {
	result := make([]int, 0, len(slice))
	seen := make(map[int]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// IntDifference returns the array of elements in the first slice that aren't in the second slice
func IntDifference(slice1, slice2 []int) []int {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[int]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []int
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// IntUnion returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func IntUnion(slice1, slice2 []int) []int {
	// Fast-path checks
	if len(slice1) == 0 {
		return IntUnique(slice2)
	}
	if len(slice2) == 0 {
		return IntUnique(slice1)
	}

	elemSet := make(map[int]struct{}, len(slice1))
	var newSlice []int
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// IntEqual checks if the two given slices are equal.
func IntEqual(a, b []int) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}

// Int16Diff returns, given two sorted int16 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Int16Diff(a, b []int16, lessFunc func(a, b int16) bool) (aOnly, bOnly []int16) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Int16Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Int16Find(slice []int16, elem int16) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// Int16Unique returns a new slice that contains only the first occurrence of each element in slice.
func Int16Unique(slice []int16) []int16 {
	result := make([]int16, 0, len(slice))
	seen := make(map[int16]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Int16Difference returns the array of elements in the first slice that aren't in the second slice
func Int16Difference(slice1, slice2 []int16) []int16 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[int16]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []int16
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// Int16Union returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func Int16Union(slice1, slice2 []int16) []int16 {
	// Fast-path checks
	if len(slice1) == 0 {
		return Int16Unique(slice2)
	}
	if len(slice2) == 0 {
		return Int16Unique(slice1)
	}

	elemSet := make(map[int16]struct{}, len(slice1))
	var newSlice []int16
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// Int16Equal checks if the two given slices are equal.
func Int16Equal(a, b []int16) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}

// Int32Diff returns, given two sorted int32 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Int32Diff(a, b []int32, lessFunc func(a, b int32) bool) (aOnly, bOnly []int32) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Int32Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Int32Find(slice []int32, elem int32) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// Int32Unique returns a new slice that contains only the first occurrence of each element in slice.
func Int32Unique(slice []int32) []int32 {
	result := make([]int32, 0, len(slice))
	seen := make(map[int32]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Int32Difference returns the array of elements in the first slice that aren't in the second slice
func Int32Difference(slice1, slice2 []int32) []int32 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[int32]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []int32
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// Int32Union returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func Int32Union(slice1, slice2 []int32) []int32 {
	// Fast-path checks
	if len(slice1) == 0 {
		return Int32Unique(slice2)
	}
	if len(slice2) == 0 {
		return Int32Unique(slice1)
	}

	elemSet := make(map[int32]struct{}, len(slice1))
	var newSlice []int32
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// Int32Equal checks if the two given slices are equal.
func Int32Equal(a, b []int32) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}

// Int64Diff returns, given two sorted int64 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Int64Diff(a, b []int64, lessFunc func(a, b int64) bool) (aOnly, bOnly []int64) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Int64Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Int64Find(slice []int64, elem int64) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// Int64Unique returns a new slice that contains only the first occurrence of each element in slice.
func Int64Unique(slice []int64) []int64 {
	result := make([]int64, 0, len(slice))
	seen := make(map[int64]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Int64Difference returns the array of elements in the first slice that aren't in the second slice
func Int64Difference(slice1, slice2 []int64) []int64 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[int64]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []int64
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// Int64Union returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func Int64Union(slice1, slice2 []int64) []int64 {
	// Fast-path checks
	if len(slice1) == 0 {
		return Int64Unique(slice2)
	}
	if len(slice2) == 0 {
		return Int64Unique(slice1)
	}

	elemSet := make(map[int64]struct{}, len(slice1))
	var newSlice []int64
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// Int64Equal checks if the two given slices are equal.
func Int64Equal(a, b []int64) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}

// Int8Diff returns, given two sorted int8 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Int8Diff(a, b []int8, lessFunc func(a, b int8) bool) (aOnly, bOnly []int8) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Int8Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Int8Find(slice []int8, elem int8) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// Int8Unique returns a new slice that contains only the first occurrence of each element in slice.
func Int8Unique(slice []int8) []int8 {
	result := make([]int8, 0, len(slice))
	seen := make(map[int8]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Int8Difference returns the array of elements in the first slice that aren't in the second slice
func Int8Difference(slice1, slice2 []int8) []int8 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[int8]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []int8
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// Int8Union returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func Int8Union(slice1, slice2 []int8) []int8 {
	// Fast-path checks
	if len(slice1) == 0 {
		return Int8Unique(slice2)
	}
	if len(slice2) == 0 {
		return Int8Unique(slice1)
	}

	elemSet := make(map[int8]struct{}, len(slice1))
	var newSlice []int8
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// Int8Equal checks if the two given slices are equal.
func Int8Equal(a, b []int8) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}

// RuneDiff returns, given two sorted rune slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func RuneDiff(a, b []rune, lessFunc func(a, b rune) bool) (aOnly, bOnly []rune) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// RuneFind returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func RuneFind(slice []rune, elem rune) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// RuneUnique returns a new slice that contains only the first occurrence of each element in slice.
func RuneUnique(slice []rune) []rune {
	result := make([]rune, 0, len(slice))
	seen := make(map[rune]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// RuneDifference returns the array of elements in the first slice that aren't in the second slice
func RuneDifference(slice1, slice2 []rune) []rune {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[rune]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []rune
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// RuneUnion returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func RuneUnion(slice1, slice2 []rune) []rune {
	// Fast-path checks
	if len(slice1) == 0 {
		return RuneUnique(slice2)
	}
	if len(slice2) == 0 {
		return RuneUnique(slice1)
	}

	elemSet := make(map[rune]struct{}, len(slice1))
	var newSlice []rune
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// RuneEqual checks if the two given slices are equal.
func RuneEqual(a, b []rune) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}

// StringDiff returns, given two sorted string slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func StringDiff(a, b []string, lessFunc func(a, b string) bool) (aOnly, bOnly []string) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// StringFind returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func StringFind(slice []string, elem string) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// StringUnique returns a new slice that contains only the first occurrence of each element in slice.
func StringUnique(slice []string) []string {
	result := make([]string, 0, len(slice))
	seen := make(map[string]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// StringDifference returns the array of elements in the first slice that aren't in the second slice
func StringDifference(slice1, slice2 []string) []string {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[string]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []string
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// StringUnion returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func StringUnion(slice1, slice2 []string) []string {
	// Fast-path checks
	if len(slice1) == 0 {
		return StringUnique(slice2)
	}
	if len(slice2) == 0 {
		return StringUnique(slice1)
	}

	elemSet := make(map[string]struct{}, len(slice1))
	var newSlice []string
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// StringEqual checks if the two given slices are equal.
func StringEqual(a, b []string) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}

// UintDiff returns, given two sorted uint slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func UintDiff(a, b []uint, lessFunc func(a, b uint) bool) (aOnly, bOnly []uint) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// UintFind returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func UintFind(slice []uint, elem uint) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// UintUnique returns a new slice that contains only the first occurrence of each element in slice.
func UintUnique(slice []uint) []uint {
	result := make([]uint, 0, len(slice))
	seen := make(map[uint]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// UintDifference returns the array of elements in the first slice that aren't in the second slice
func UintDifference(slice1, slice2 []uint) []uint {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[uint]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []uint
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// UintUnion returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func UintUnion(slice1, slice2 []uint) []uint {
	// Fast-path checks
	if len(slice1) == 0 {
		return UintUnique(slice2)
	}
	if len(slice2) == 0 {
		return UintUnique(slice1)
	}

	elemSet := make(map[uint]struct{}, len(slice1))
	var newSlice []uint
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// UintEqual checks if the two given slices are equal.
func UintEqual(a, b []uint) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}

// Uint16Diff returns, given two sorted uint16 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Uint16Diff(a, b []uint16, lessFunc func(a, b uint16) bool) (aOnly, bOnly []uint16) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Uint16Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Uint16Find(slice []uint16, elem uint16) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// Uint16Unique returns a new slice that contains only the first occurrence of each element in slice.
func Uint16Unique(slice []uint16) []uint16 {
	result := make([]uint16, 0, len(slice))
	seen := make(map[uint16]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Uint16Difference returns the array of elements in the first slice that aren't in the second slice
func Uint16Difference(slice1, slice2 []uint16) []uint16 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[uint16]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []uint16
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// Uint16Union returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func Uint16Union(slice1, slice2 []uint16) []uint16 {
	// Fast-path checks
	if len(slice1) == 0 {
		return Uint16Unique(slice2)
	}
	if len(slice2) == 0 {
		return Uint16Unique(slice1)
	}

	elemSet := make(map[uint16]struct{}, len(slice1))
	var newSlice []uint16
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// Uint16Equal checks if the two given slices are equal.
func Uint16Equal(a, b []uint16) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}

// Uint32Diff returns, given two sorted uint32 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Uint32Diff(a, b []uint32, lessFunc func(a, b uint32) bool) (aOnly, bOnly []uint32) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Uint32Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Uint32Find(slice []uint32, elem uint32) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// Uint32Unique returns a new slice that contains only the first occurrence of each element in slice.
func Uint32Unique(slice []uint32) []uint32 {
	result := make([]uint32, 0, len(slice))
	seen := make(map[uint32]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Uint32Difference returns the array of elements in the first slice that aren't in the second slice
func Uint32Difference(slice1, slice2 []uint32) []uint32 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[uint32]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []uint32
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// Uint32Union returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func Uint32Union(slice1, slice2 []uint32) []uint32 {
	// Fast-path checks
	if len(slice1) == 0 {
		return Uint32Unique(slice2)
	}
	if len(slice2) == 0 {
		return Uint32Unique(slice1)
	}

	elemSet := make(map[uint32]struct{}, len(slice1))
	var newSlice []uint32
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// Uint32Equal checks if the two given slices are equal.
func Uint32Equal(a, b []uint32) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}

// Uint64Diff returns, given two sorted uint64 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Uint64Diff(a, b []uint64, lessFunc func(a, b uint64) bool) (aOnly, bOnly []uint64) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Uint64Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Uint64Find(slice []uint64, elem uint64) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// Uint64Unique returns a new slice that contains only the first occurrence of each element in slice.
func Uint64Unique(slice []uint64) []uint64 {
	result := make([]uint64, 0, len(slice))
	seen := make(map[uint64]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Uint64Difference returns the array of elements in the first slice that aren't in the second slice
func Uint64Difference(slice1, slice2 []uint64) []uint64 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[uint64]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []uint64
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// Uint64Union returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func Uint64Union(slice1, slice2 []uint64) []uint64 {
	// Fast-path checks
	if len(slice1) == 0 {
		return Uint64Unique(slice2)
	}
	if len(slice2) == 0 {
		return Uint64Unique(slice1)
	}

	elemSet := make(map[uint64]struct{}, len(slice1))
	var newSlice []uint64
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// Uint64Equal checks if the two given slices are equal.
func Uint64Equal(a, b []uint64) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}

// Uint8Diff returns, given two sorted uint8 slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func Uint8Diff(a, b []uint8, lessFunc func(a, b uint8) bool) (aOnly, bOnly []uint8) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// Uint8Find returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func Uint8Find(slice []uint8, elem uint8) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// Uint8Unique returns a new slice that contains only the first occurrence of each element in slice.
func Uint8Unique(slice []uint8) []uint8 {
	result := make([]uint8, 0, len(slice))
	seen := make(map[uint8]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// Uint8Difference returns the array of elements in the first slice that aren't in the second slice
func Uint8Difference(slice1, slice2 []uint8) []uint8 {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[uint8]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []uint8
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// Uint8Union returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func Uint8Union(slice1, slice2 []uint8) []uint8 {
	// Fast-path checks
	if len(slice1) == 0 {
		return Uint8Unique(slice2)
	}
	if len(slice2) == 0 {
		return Uint8Unique(slice1)
	}

	elemSet := make(map[uint8]struct{}, len(slice1))
	var newSlice []uint8
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// Uint8Equal checks if the two given slices are equal.
func Uint8Equal(a, b []uint8) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}

// UintptrDiff returns, given two sorted uintptr slices a and b, a slice of the elements occurring in a and b only,
// respectively.
func UintptrDiff(a, b []uintptr, lessFunc func(a, b uintptr) bool) (aOnly, bOnly []uintptr) {
	i, j := 0, 0
	for i < len(a) && j < len(b) {
		if lessFunc(a[i], b[j]) {
			aOnly = append(aOnly, a[i])
			i++
		} else if lessFunc(b[j], a[i]) {
			bOnly = append(bOnly, b[j])
			j++
		} else { // a[i] and b[j] are "equal"
			i++
			j++
		}
	}

	aOnly = append(aOnly, a[i:]...)
	bOnly = append(bOnly, b[j:]...)
	return
}

// UintptrFind returns, given a slice and an element, the first index of elem in the slice, or -1 if the slice does
// not contain elem.
func UintptrFind(slice []uintptr, elem uintptr) int {
	for i, sliceElem := range slice {
		if sliceElem == elem {
			return i
		}
	}
	return -1
}

// UintptrUnique returns a new slice that contains only the first occurrence of each element in slice.
func UintptrUnique(slice []uintptr) []uintptr {
	result := make([]uintptr, 0, len(slice))
	seen := make(map[uintptr]struct{}, len(slice))
	for _, elem := range slice {
		if _, ok := seen[elem]; !ok {
			result = append(result, elem)
			seen[elem] = struct{}{}
		}
	}
	return result
}

// UintptrDifference returns the array of elements in the first slice that aren't in the second slice
func UintptrDifference(slice1, slice2 []uintptr) []uintptr {
	if len(slice1) == 0 || len(slice2) == 0 {
		return slice1
	}

	blockedElems := make(map[uintptr]struct{}, len(slice2))
	for _, s := range slice2 {
		blockedElems[s] = struct{}{}
	}
	var newSlice []uintptr
	for _, s := range slice1 {
		if _, ok := blockedElems[s]; !ok {
			newSlice = append(newSlice, s)
			blockedElems[s] = struct{}{}
		}
	}
	return newSlice
}

// UintptrUnion returns the union array of slice1 and slice2 without duplicates.
// The elements in the returned slice will be in the same order as if you concatenated
// the two slices, and then removed all copies of repeated elements except the first one.
func UintptrUnion(slice1, slice2 []uintptr) []uintptr {
	// Fast-path checks
	if len(slice1) == 0 {
		return UintptrUnique(slice2)
	}
	if len(slice2) == 0 {
		return UintptrUnique(slice1)
	}

	elemSet := make(map[uintptr]struct{}, len(slice1))
	var newSlice []uintptr
	for _, elem := range slice1 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	for _, elem := range slice2 {
		if _, ok := elemSet[elem]; !ok {
			elemSet[elem] = struct{}{}
			newSlice = append(newSlice, elem)
		}
	}

	return newSlice
}

// UintptrEqual checks if the two given slices are equal.
func UintptrEqual(a, b []uintptr) bool {
	if len(a) != len(b) {
		return false
	}
	for i, aElem := range a {
		if aElem != b[i] {
			return false
		}
	}
	return true
}
