// Code generated by pg-bindings generator. DO NOT EDIT.
package postgres

import (
	"time"
	"reflect"

	"github.com/jackc/pgx/v4/pgxpool"
	"github.com/stackrox/rox/central/metrics"
	v1 "github.com/stackrox/rox/generated/api/v1"
	storage "github.com/stackrox/rox/generated/storage"
	ops "github.com/stackrox/rox/pkg/metrics"
	"github.com/stackrox/rox/pkg/postgres/walker"
	search "github.com/stackrox/rox/pkg/search"
	"github.com/stackrox/rox/pkg/search/blevesearch"
	"github.com/stackrox/rox/pkg/search/postgres"
	"github.com/stackrox/rox/pkg/search/postgres/mapping"
	mappings "github.com/stackrox/rox/tools/generate-helpers/pg-table-bindings/multitest/options"
)

func init() {
	mapping.RegisterCategoryToTable(v1.SearchCategory_SEARCH_UNSET, walker.Walk(reflect.TypeOf((*storage.TestMultiKeyStruct)(nil)), "multikey"))
}

func NewIndexer(db *pgxpool.Pool) *indexerImpl {
	return &indexerImpl{
		db: db,
	}
}

type indexerImpl struct {
	db *pgxpool.Pool
}

func (b *indexerImpl) Count(q *v1.Query, opts ...blevesearch.SearchOption) (int, error) {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.Count, "TestMultiKeyStruct")

	return postgres.RunCountRequest(v1.SearchCategory_SEARCH_UNSET, q, b.db, mappings.OptionsMap)
}

func (b *indexerImpl) Search(q *v1.Query, opts ...blevesearch.SearchOption) ([]search.Result, error) {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.Search, "TestMultiKeyStruct")

	return postgres.RunSearchRequest(v1.SearchCategory_SEARCH_UNSET, q, b.db, mappings.OptionsMap)
}

//// Stubs for satisfying interfaces

func (b *indexerImpl) AddTestMultiKeyStruct(deployment *storage.TestMultiKeyStruct) error {
	return nil
}

func (b *indexerImpl) AddTestMultiKeyStructs(_ []*storage.TestMultiKeyStruct) error {
	return nil
}

func (b *indexerImpl) DeleteTestMultiKeyStruct(id string) error {
	return nil
}

func (b *indexerImpl) DeleteTestMultiKeyStructs(_ []string) error {
	return nil
}

func (b *indexerImpl) MarkInitialIndexingComplete() error {
	return nil
}

func (b *indexerImpl) NeedsInitialIndexing() (bool, error) {
	return false, nil
}
