import React from 'react';
import PropTypes from 'prop-types';

import { httpURLPattern, isValidURL } from 'utils/urlUtils';

const CommentMessage = ({ message }) => {
    // split the message by URLs
    return message.split(httpURLPattern).map((word) => {
        // create links for each URL string
        if (isValidURL(word)) {
            return (
                <a
                    href={word}
                    target="_blank"
                    rel="noopener noreferrer"
                    key={word}
                    data-testid="comment-link"
                >
                    {word}
                </a>
            );
        }
        return word;
    });
};

CommentMessage.propTypes = {
    message: PropTypes.string,
};

CommentMessage.defaultProps = {
    message: '',
};

export default CommentMessage;
