import React from 'react';
import { Label } from '@patternfly/react-core';
import { vulnerabilitySeverityColorMapPF } from 'constants/severityColors';
import { vulnerabilitySeverityLabels } from 'messages/common';
import { VulnerabilitySeverity } from 'types/cve.proto';

export type VulnerabilitySeverityLabelProps = {
    severity: VulnerabilitySeverity;
};

function VulnerabilitySeverityLabel({ severity }: VulnerabilitySeverityLabelProps) {
    const severityLabel = vulnerabilitySeverityLabels[severity];
    const color = vulnerabilitySeverityColorMapPF[severityLabel];
    return <Label color={color}>{severityLabel}</Label>;
}

export default VulnerabilitySeverityLabel;
