import React, { ReactElement, useState } from 'react';
import { Select, SelectVariant } from '@patternfly/react-core';

export type SelectSingleProps = {
    id: string;
    value: string;
    setFieldValue: (name: string, value: string) => void;
    isDisabled: boolean;
    children: ReactElement[];
};

function SelectSingle({
    id,
    value,
    setFieldValue,
    isDisabled,
    children,
}: SelectSingleProps): ReactElement {
    const [isOpen, setIsOpen] = useState(false);

    function onSelect(_event, selection) {
        // The mouse event is not useful.
        setIsOpen(false);
        setFieldValue(id, selection);
    }

    return (
        <Select
            variant={SelectVariant.single}
            id={id}
            isDisabled={isDisabled}
            isOpen={isOpen}
            onSelect={onSelect}
            onToggle={setIsOpen}
            selections={value}
        >
            {children}
        </Select>
    );
}

export default SelectSingle;
