import React from 'react';

import { defaultColumnClassName } from 'Components/Table';

import { times, daysOfWeek } from '../Form/Schedule';

const classNameWordBreak = `${defaultColumnClassName} word-break`;

const tableColumnDescriptor = Object.freeze({
    authProviders: {
        oidc: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'config.issuer', Header: 'Issuer' },
        ],
        auth0: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'config.issuer', Header: 'Auth0 Tenant' },
        ],
        saml: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'config.idp_issuer', Header: 'Issuer' },
        ],
        iap: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'config.audience', Header: 'Audience' },
        ],
        clusterInitBundle: [{ accessor: 'name', Header: 'Name' }],
        apitoken: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'role', Header: 'Role' },
        ],
    },
    notifiers: {
        awsSecurityHub: [
            { accessor: 'name', Header: 'Name' },
            {
                accessor: 'awsSecurityHub.accountId',
                Header: 'AWS Account Number',
            },
            { accessor: 'awsSecurityHub.region', Header: 'AWS Region' },
        ],
        slack: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'labelDefault', Header: 'Default Webhook', className: classNameWordBreak },
            { accessor: 'labelKey', Header: 'Webhook Annotation Key' },
        ],
        teams: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'labelDefault', Header: 'Default Webhook', className: classNameWordBreak },
            { accessor: 'labelKey', Header: 'Webhook Annotation Key' },
        ],
        jira: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'labelDefault', Header: 'Default Project' },
            { accessor: 'labelKey', Header: 'Project Annotation Key' },
            {
                accessor: 'jira.url',
                keyValueFunc: (url) => (
                    <a href={url} target="_blank" rel="noopener noreferrer">
                        {url}
                    </a>
                ),
                Header: 'URL',
            },
        ],
        email: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'labelDefault', Header: 'Default Recipient' },
            { accessor: 'labelKey', Header: 'Recipient Annotation Key' },
            { accessor: 'email.server', Header: 'Server' },
        ],
        cscc: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'cscc.sourceId', Header: 'Google Cloud SCC Source ID' },
        ],
        splunk: [
            { accessor: 'name', Header: 'Name' },
            {
                accessor: 'splunk.httpEndpoint',
                keyValueFunc: (url) => (
                    <a href={url} target="_blank" rel="noopener noreferrer">
                        {url}
                    </a>
                ),
                Header: 'URL',
            },
            { accessor: 'splunk.truncate', Header: 'HEC Truncate Limit' },
        ],
        pagerduty: [{ accessor: 'name', Header: 'Name' }],
        generic: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'generic.endpoint', Header: 'Endpoint' },
        ],
        sumologic: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'sumologic.httpSourceAddress', Header: 'HTTP Collector Source Address' },
            {
                Header: 'Skip TLS Certificate Verification',
                accessor: (data) => (data.skipTLSVerify ? 'Yes (Insecure)' : 'No (Secure)'),
            },
        ],
        syslog: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'syslog.tcpConfig.hostname', Header: 'Receiver Host' },
            {
                Header: 'Skip TLS Certificate Verification',
                accessor: (data) => (data.skipTLSVerify ? 'Yes (Insecure)' : 'No (Secure)'),
            },
        ],
    },
    imageIntegrations: {
        docker: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'docker.endpoint', Header: 'Endpoint' },
            { accessor: 'docker.username', Header: 'Username' },
            {
                Header: 'Autogenerated',
                accessor: (data) => (data.autogenerated ? 'True' : 'False'),
            },
        ],
        tenable: [{ accessor: 'name', Header: 'Name' }],
        dtr: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'dtr.endpoint', Header: 'Endpoint' },
            { accessor: 'dtr.username', Header: 'Username' },
        ],
        artifactregistry: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'google.endpoint', Header: 'Endpoint' },
            { accessor: 'google.project', Header: 'Project' },
        ],
        artifactory: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'docker.endpoint', Header: 'Endpoint' },
            { accessor: 'docker.username', Header: 'Username' },
        ],
        quay: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'quay.endpoint', Header: 'Endpoint' },
        ],
        clair: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'clair.endpoint', Header: 'Endpoint' },
        ],
        clairify: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'clairify.endpoint', Header: 'Endpoint' },
        ],
        google: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'google.endpoint', Header: 'Endpoint' },
            { accessor: 'google.project', Header: 'Project' },
        ],
        ecr: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'ecr.registryId', Header: 'Registry ID' },
            { accessor: 'ecr.region', Header: 'Region' },
        ],
        nexus: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'docker.endpoint', Header: 'Endpoint' },
            { accessor: 'docker.username', Header: 'Username' },
        ],
        azure: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'docker.endpoint', Header: 'Endpoint' },
            { accessor: 'docker.username', Header: 'Username' },
        ],
        anchore: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'anchore.endpoint', Header: 'Endpoint' },
            { accessor: 'anchore.username', Header: 'Username' },
        ],
        ibm: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'ibm.endpoint', Header: 'Endpoint' },
        ],
        rhel: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'docker.endpoint', Header: 'Endpoint' },
            { accessor: 'docker.username', Header: 'Username' },
        ],
    },
    backups: {
        s3: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 's3.bucket', Header: 'Bucket' },
            {
                id: 'schedule',
                accessor: (data) => {
                    const { schedule } = data;
                    if (schedule.weekly) {
                        return `Weekly on ${daysOfWeek[schedule.weekly.day]} @ ${
                            times[schedule.hour]
                        } UTC`;
                    }
                    return `Daily @ ${times[schedule.hour]} UTC`;
                },
                Header: 'Schedule',
            },
        ],
        gcs: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'gcs.bucket', Header: 'Bucket' },
            {
                id: 'schedule',
                accessor: (data) => {
                    const { schedule } = data;
                    if (schedule.weekly) {
                        return `Weekly on ${daysOfWeek[schedule.weekly.day]} @ ${
                            times[schedule.hour]
                        } UTC`;
                    }
                    return `Daily @ ${times[schedule.hour]} UTC`;
                },
                Header: 'Schedule',
            },
        ],
    },
    authPlugins: {
        scopedAccess: [
            { accessor: 'name', Header: 'Name' },
            { accessor: 'endpointConfig.endpoint', Header: 'Endpoint' },
        ],
    },
});

export default tableColumnDescriptor;
