import React, { ReactElement } from 'react';
import { differenceInMinutes } from 'date-fns';

import { styleHealthy, styleUnhealthy } from 'Containers/Clusters/cluster.helpers';
import { getDateTime } from 'utils/dateUtils';

import { style0 } from '../utils/health';

const dayInMinutes = 24 * 60;

type VulnerabilityDefinitionsInfo = {
    lastUpdatedTimestamp: string;
};

type Props = {
    currentDatetime: Date | null;
    vulnerabilityDefinitionsInfo: VulnerabilityDefinitionsInfo | null;
};

const VulnerabilityDefinitions = ({
    currentDatetime,
    vulnerabilityDefinitionsInfo,
}: Props): ReactElement => {
    let style = style0;
    let text = '';
    let timeElement;

    if (vulnerabilityDefinitionsInfo?.lastUpdatedTimestamp) {
        const { lastUpdatedTimestamp } = vulnerabilityDefinitionsInfo;

        if (currentDatetime) {
            // date-fns@2: differenceInMinutes(parseISO(lastUpdatedTimestamp), currentDatetime)
            if (differenceInMinutes(lastUpdatedTimestamp, currentDatetime) <= -dayInMinutes) {
                style = styleUnhealthy;
                text = 'Vulnerability definitions are out\u00A0of\u00A0date';
            } else {
                style = styleHealthy;
                text = 'Vulnerability definitions are up\u00A0to\u00A0date';
            }
        }

        timeElement = <div>{getDateTime(lastUpdatedTimestamp)}</div>;
    }

    const { Icon, fgColor } = style;

    return (
        <div className="flex flex-col justify-between w-full">
            <div className={fgColor}>
                <div className="flex justify-center mb-2 mt-4">
                    <Icon className="h-6 w-6" />
                </div>
                <div className="leading-normal px-2 text-center" data-testid="text">
                    {text}
                </div>
            </div>
            <div className="leading-normal p-2 text-center" data-testid="time">
                {timeElement}
            </div>
        </div>
    );
};

export default VulnerabilityDefinitions;
