import { useMutation } from '@apollo/client';
import { DeferralFormValues } from './DeferralFormModal';
import { DeferVulnerabilityRequest, DEFER_VULNERABILITY } from '../imageVulnerabilities.graphql';
import {
    getExpiresOnValue,
    getExpiresWhenFixedValue,
    getScopeValue,
} from '../utils/vulnRequestFormUtils';

export type UseDeferVulnerabilityProps = {
    cveIDs: string[];
    registry: string;
    remote: string;
    tag: string;
};

function useDeferVulnerability({ cveIDs, registry, remote, tag }: UseDeferVulnerabilityProps) {
    const [deferVulnerability] = useMutation(DEFER_VULNERABILITY);

    function requestDeferral(formValues: DeferralFormValues) {
        const { comment } = formValues;
        const expiresWhenFixed = getExpiresWhenFixedValue(formValues.expiresOn);
        const expiresOn = getExpiresOnValue(formValues.expiresOn);
        const scope = getScopeValue(formValues.imageAppliesTo, registry, remote, tag);

        const promises = cveIDs.map((cve) => {
            const request: DeferVulnerabilityRequest = {
                cve,
                comment,
                scope,
            };
            if (expiresOn) {
                request.expiresOn = expiresOn;
            }
            if (expiresWhenFixed) {
                request.expiresWhenFixed = expiresWhenFixed;
            }
            const variables = { request };
            return deferVulnerability({ variables });
        });

        return Promise.all(promises)
            .then(() => {
                return Promise.resolve({
                    message: 'Successfully deferred vulnerability',
                    isError: false,
                });
            })
            .catch((error) => {
                return Promise.reject(new Error(error.response.data.message));
            });
    }

    return requestDeferral;
}

export default useDeferVulnerability;
