import React, { ReactElement } from 'react';

import { Scope } from 'types/vuln_request.proto';

export type VulnerabilityRequestScopeProps = {
    scope: Scope;
};

function VulnerabilityRequestScope({ scope }: VulnerabilityRequestScopeProps): ReactElement {
    let text = 'N/A';
    if (scope.imageScope) {
        const { registry, remote, tag } = scope.imageScope;
        text = tag ? `${registry}/${remote}:${tag}` : `${registry}/${remote}`;
    }
    return <div>{text}</div>;
}

export default VulnerabilityRequestScope;
