import { useApolloClient, useQuery } from '@apollo/client';
import {
    GetVulnerabilityRequestsData,
    GetVulnerabilityRequestsVars,
    GET_VULNERABILITY_REQUESTS,
} from './vulnerabilityRequests.graphql';

function useVulnerabilityRequests({ query, requestID, pagination }) {
    const client = useApolloClient();
    const {
        loading: isLoading,
        data,
        error,
    } = useQuery<GetVulnerabilityRequestsData, GetVulnerabilityRequestsVars>(
        GET_VULNERABILITY_REQUESTS,
        {
            variables: {
                query,
                requestIDSelector: requestID,
                pagination,
            },
            fetchPolicy: 'network-only',
        }
    );

    async function refetchQuery() {
        await client.refetchQueries({
            include: [GET_VULNERABILITY_REQUESTS],
        });
    }

    return { isLoading, data, error, refetchQuery };
}

export default useVulnerabilityRequests;
