/* eslint-disable import/prefer-default-export */
import { VulnerabilityRequest } from 'types/vuln_request.proto';
import axios from './instance';

export function fetchVulnRequests({
    query,
}: {
    query: string | null;
}): Promise<VulnerabilityRequest[]> {
    const baseURL = '/v1/cve/requests';
    const url = `${baseURL}?query=${query || ''}`;
    return axios
        .get<{ requestInfos: VulnerabilityRequest[] }>(url)
        .then((response) => response?.data?.requestInfos ?? []);
}
