(function() {
  var PROTOCOL_6, PROTOCOL_7, Parser, ProtocolError,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  exports.PROTOCOL_6 = PROTOCOL_6 = 'http://livereload.com/protocols/official-6';

  exports.PROTOCOL_7 = PROTOCOL_7 = 'http://livereload.com/protocols/official-7';

  exports.ProtocolError = ProtocolError = (function() {
    function ProtocolError(reason, data) {
      this.message = "LiveReload protocol error (" + reason + ") after receiving data: \"" + data + "\".";
    }

    return ProtocolError;

  })();

  exports.Parser = Parser = (function() {
    function Parser(handlers) {
      this.handlers = handlers;
      this.reset();
    }

    Parser.prototype.reset = function() {
      return this.protocol = null;
    };

    Parser.prototype.process = function(data) {
      var command, e, error, message, options, ref;
      try {
        if (this.protocol == null) {
          if (data.match(/^!!ver:([\d.]+)$/)) {
            this.protocol = 6;
          } else if (message = this._parseMessage(data, ['hello'])) {
            if (!message.protocols.length) {
              throw new ProtocolError("no protocols specified in handshake message");
            } else if (indexOf.call(message.protocols, PROTOCOL_7) >= 0) {
              this.protocol = 7;
            } else if (indexOf.call(message.protocols, PROTOCOL_6) >= 0) {
              this.protocol = 6;
            } else {
              throw new ProtocolError("no supported protocols found");
            }
          }
          return this.handlers.connected(this.protocol);
        } else if (this.protocol === 6) {
          message = JSON.parse(data);
          if (!message.length) {
            throw new ProtocolError("protocol 6 messages must be arrays");
          }
          command = message[0], options = message[1];
          if (command !== 'refresh') {
            throw new ProtocolError("unknown protocol 6 command");
          }
          return this.handlers.message({
            command: 'reload',
            path: options.path,
            liveCSS: (ref = options.apply_css_live) != null ? ref : true
          });
        } else {
          message = this._parseMessage(data, ['reload', 'alert']);
          return this.handlers.message(message);
        }
      } catch (error) {
        e = error;
        if (e instanceof ProtocolError) {
          return this.handlers.error(e);
        } else {
          throw e;
        }
      }
    };

    Parser.prototype._parseMessage = function(data, validCommands) {
      var e, error, message, ref;
      try {
        message = JSON.parse(data);
      } catch (error) {
        e = error;
        throw new ProtocolError('unparsable JSON', data);
      }
      if (!message.command) {
        throw new ProtocolError('missing "command" key', data);
      }
      if (ref = message.command, indexOf.call(validCommands, ref) < 0) {
        throw new ProtocolError("invalid command '" + message.command + "', only valid commands are: " + (validCommands.join(', ')) + ")", data);
      }
      return message;
    };

    return Parser;

  })();

}).call(this);
