(function(){
var _$dep_3 = {};
"use strict";

Object.defineProperty(_$dep_3, "__esModule", {
  value: true
});
_$dep_3.default = whatever;

function whatever(xyz) {
  return xyz.toUpperCase();
}

var trailingNewlineRegex = /\n[\s]+$/
var leadingNewlineRegex = /^\n[\s]+/
var trailingSpaceRegex = /[\s]+$/
var leadingSpaceRegex = /^[\s]+/
var multiSpaceRegex = /[\n\s]+/g

var TEXT_TAGS = [
  'a', 'abbr', 'b', 'bdi', 'bdo', 'br', 'cite', 'data', 'dfn', 'em', 'i',
  'kbd', 'mark', 'q', 'rp', 'rt', 'rtc', 'ruby', 's', 'amp', 'small', 'span',
  'strong', 'sub', 'sup', 'time', 'u', 'var', 'wbr'
]

var VERBATIM_TAGS = [
  'code', 'pre', 'textarea'
]

var _$appendChild_1 = function appendChild (el, childs) {
  if (!Array.isArray(childs)) return

  var nodeName = el.nodeName.toLowerCase()

  var hadText = false
  var value, leader

  for (var i = 0, len = childs.length; i < len; i++) {
    var node = childs[i]
    if (Array.isArray(node)) {
      appendChild(el, node)
      continue
    }

    if (typeof node === 'number' ||
      typeof node === 'boolean' ||
      typeof node === 'function' ||
      node instanceof Date ||
      node instanceof RegExp) {
      node = node.toString()
    }

    var lastChild = el.childNodes[el.childNodes.length - 1]

    // Iterate over text nodes
    if (typeof node === 'string') {
      hadText = true

      // If we already had text, append to the existing text
      if (lastChild && lastChild.nodeName === '#text') {
        lastChild.nodeValue += node

      // We didn't have a text node yet, create one
      } else {
        node = document.createTextNode(node)
        el.appendChild(node)
        lastChild = node
      }

      // If this is the last of the child nodes, make sure we close it out
      // right
      if (i === len - 1) {
        hadText = false
        // Trim the child text nodes if the current node isn't a
        // node where whitespace matters.
        if (TEXT_TAGS.indexOf(nodeName) === -1 &&
          VERBATIM_TAGS.indexOf(nodeName) === -1) {
          value = lastChild.nodeValue
            .replace(leadingNewlineRegex, '')
            .replace(trailingSpaceRegex, '')
            .replace(trailingNewlineRegex, '')
            .replace(multiSpaceRegex, ' ')
          if (value === '') {
            el.removeChild(lastChild)
          } else {
            lastChild.nodeValue = value
          }
        } else if (VERBATIM_TAGS.indexOf(nodeName) === -1) {
          // The very first node in the list should not have leading
          // whitespace. Sibling text nodes should have whitespace if there
          // was any.
          leader = i === 0 ? '' : ' '
          value = lastChild.nodeValue
            .replace(leadingNewlineRegex, leader)
            .replace(leadingSpaceRegex, ' ')
            .replace(trailingSpaceRegex, '')
            .replace(trailingNewlineRegex, '')
            .replace(multiSpaceRegex, ' ')
          lastChild.nodeValue = value
        }
      }

    // Iterate over DOM nodes
    } else if (node && node.nodeType) {
      // If the last node was a text node, make sure it is properly closed out
      if (hadText) {
        hadText = false

        // Trim the child text nodes if the current node isn't a
        // text node or a code node
        if (TEXT_TAGS.indexOf(nodeName) === -1 &&
          VERBATIM_TAGS.indexOf(nodeName) === -1) {
          value = lastChild.nodeValue
            .replace(leadingNewlineRegex, '')
            .replace(trailingNewlineRegex, '')
            .replace(multiSpaceRegex, ' ')

          // Remove empty text nodes, append otherwise
          if (value === '') {
            el.removeChild(lastChild)
          } else {
            lastChild.nodeValue = value
          }
        // Trim the child nodes if the current node is not a node
        // where all whitespace must be preserved
        } else if (VERBATIM_TAGS.indexOf(nodeName) === -1) {
          value = lastChild.nodeValue
            .replace(leadingSpaceRegex, ' ')
            .replace(leadingNewlineRegex, '')
            .replace(trailingNewlineRegex, '')
            .replace(multiSpaceRegex, ' ')
          lastChild.nodeValue = value
        }
      }

      // Store the last nodename
      var _nodeName = node.nodeName
      if (_nodeName) nodeName = _nodeName.toLowerCase()

      // Append the node to the DOM
      el.appendChild(node)
    }
  }
}

var _$app_2 = {};
"use strict";

var _dep = _interopRequireDefault(_$dep_3);

var _athelas,
    _f,
    _f2,
    _w_,
    _db,
    _pl3Ns,
    _flex,
    _ttu,
    _f3,
    _f4,
    _pv,
    _mw;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

document.body.appendChild((_mw = document.createElement("section"), _mw.setAttribute("class", "mw7 center"), _$appendChild_1(_mw, ["\n\t ", (_athelas = document.createElement("h2"), _athelas.setAttribute("class", "athelas ph3 ph0-l"), _$appendChild_1(_athelas, ["News"]), _athelas), "\n\t ", (_pv = document.createElement("article"), _pv.setAttribute("class", "pv4 bt bb b--black-10 ph3 ph0-l"), _$appendChild_1(_pv, ["\n\t\t", (_flex = document.createElement("div"), _flex.setAttribute("class", "flex flex-column flex-row-ns"), _$appendChild_1(_flex, ["\n\t\t  ", (_w_ = document.createElement("div"), _w_.setAttribute("class", "w-100 w-60-ns pr3-ns order-2 order-1-ns"), _$appendChild_1(_w_, ["\n\t\t\t ", (_f = document.createElement("h1"), _f.setAttribute("class", "f3 athelas mt0 lh-title"), _$appendChild_1(_f, [(0, _dep.default)('title')]), _f), "\n\t\t\t ", (_f2 = document.createElement("p"), _f2.setAttribute("class", "f5 f4-l lh-copy athelas"), _$appendChild_1(_f2, ["\n\t\t\t\t", (0, _dep.default)('excerpt'), "\n\t\t\t "]), _f2), "\n\t\t  "]), _w_), "\n\t\t  ", (_pl3Ns = document.createElement("div"), _pl3Ns.setAttribute("class", "pl3-ns order-1 order-2-ns mb4 mb0-ns w-100 w-40-ns"), _$appendChild_1(_pl3Ns, ["\n\t\t\t ", (_db = document.createElement("img"), _db.setAttribute("src", "http://mrmrs.github.io/photos/cpu.jpg"), _db.setAttribute("alt", "Photo of a dimly lit room with a computer interface terminal."), _db.setAttribute("class", "db"), _db), "\n\t\t  "]), _pl3Ns), "\n\t\t"]), _flex), "\n\t\t", (_f3 = document.createElement("p"), _f3.setAttribute("class", "f6 lh-copy gray mv0"), _$appendChild_1(_f3, ["By ", (_ttu = document.createElement("span"), _ttu.setAttribute("class", "ttu"), _$appendChild_1(_ttu, [(0, _dep.default)('author')]), _ttu)]), _f3), "\n\t\t", (_f4 = document.createElement("time"), _f4.setAttribute("class", "f6 db gray"), _$appendChild_1(_f4, [(0, _dep.default)('timestamp')]), _f4), "\n\t "]), _pv), "\n  "]), _mw));

}());
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
