package locks

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// ManagementLocksClient is the azure resources can be locked to prevent other users in your organization from deleting
// or modifying resources.
type ManagementLocksClient struct {
	BaseClient
}

// NewManagementLocksClient creates an instance of the ManagementLocksClient client.
func NewManagementLocksClient(subscriptionID string) ManagementLocksClient {
	return NewManagementLocksClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewManagementLocksClientWithBaseURI creates an instance of the ManagementLocksClient client.
func NewManagementLocksClientWithBaseURI(baseURI string, subscriptionID string) ManagementLocksClient {
	return ManagementLocksClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdateAtResourceGroupLevel when you apply a lock at a parent scope, all child resources inherit the same
// lock. To create management locks, you must have access to Microsoft.Authorization/* or
// Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted
// those actions.
// Parameters:
// resourceGroupName - the name of the resource group to lock.
// lockName - the lock name. The lock name can be a maximum of 260 characters. It cannot contain <, > %, &, :,
// \, ?, /, or any control characters.
// parameters - the management lock parameters.
func (client ManagementLocksClient) CreateOrUpdateAtResourceGroupLevel(ctx context.Context, resourceGroupName string, lockName string, parameters ManagementLockObject) (result ManagementLockObject, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ManagementLockProperties", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("locks.ManagementLocksClient", "CreateOrUpdateAtResourceGroupLevel", err.Error())
	}

	req, err := client.CreateOrUpdateAtResourceGroupLevelPreparer(ctx, resourceGroupName, lockName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "CreateOrUpdateAtResourceGroupLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateAtResourceGroupLevelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "CreateOrUpdateAtResourceGroupLevel", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateAtResourceGroupLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "CreateOrUpdateAtResourceGroupLevel", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateAtResourceGroupLevelPreparer prepares the CreateOrUpdateAtResourceGroupLevel request.
func (client ManagementLocksClient) CreateOrUpdateAtResourceGroupLevelPreparer(ctx context.Context, resourceGroupName string, lockName string, parameters ManagementLockObject) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"lockName":          autorest.Encode("path", lockName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateAtResourceGroupLevelSender sends the CreateOrUpdateAtResourceGroupLevel request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementLocksClient) CreateOrUpdateAtResourceGroupLevelSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateAtResourceGroupLevelResponder handles the response to the CreateOrUpdateAtResourceGroupLevel request. The method always
// closes the http.Response Body.
func (client ManagementLocksClient) CreateOrUpdateAtResourceGroupLevelResponder(resp *http.Response) (result ManagementLockObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateAtResourceLevel when you apply a lock at a parent scope, all child resources inherit the same lock. To
// create management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
// actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
// Parameters:
// resourceGroupName - the name of the resource group containing the resource to lock.
// resourceProviderNamespace - the resource provider namespace of the resource to lock.
// parentResourcePath - the parent resource identity.
// resourceType - the resource type of the resource to lock.
// resourceName - the name of the resource to lock.
// lockName - the name of lock. The lock name can be a maximum of 260 characters. It cannot contain <, > %, &,
// :, \, ?, /, or any control characters.
// parameters - parameters for creating or updating a  management lock.
func (client ManagementLocksClient) CreateOrUpdateAtResourceLevel(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string, parameters ManagementLockObject) (result ManagementLockObject, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ManagementLockProperties", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("locks.ManagementLocksClient", "CreateOrUpdateAtResourceLevel", err.Error())
	}

	req, err := client.CreateOrUpdateAtResourceLevelPreparer(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "CreateOrUpdateAtResourceLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateAtResourceLevelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "CreateOrUpdateAtResourceLevel", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateAtResourceLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "CreateOrUpdateAtResourceLevel", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateAtResourceLevelPreparer prepares the CreateOrUpdateAtResourceLevel request.
func (client ManagementLocksClient) CreateOrUpdateAtResourceLevelPreparer(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string, parameters ManagementLockObject) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"lockName":                  autorest.Encode("path", lockName),
		"parentResourcePath":        parentResourcePath,
		"resourceGroupName":         autorest.Encode("path", resourceGroupName),
		"resourceName":              autorest.Encode("path", resourceName),
		"resourceProviderNamespace": autorest.Encode("path", resourceProviderNamespace),
		"resourceType":              resourceType,
		"subscriptionId":            autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateAtResourceLevelSender sends the CreateOrUpdateAtResourceLevel request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementLocksClient) CreateOrUpdateAtResourceLevelSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateAtResourceLevelResponder handles the response to the CreateOrUpdateAtResourceLevel request. The method always
// closes the http.Response Body.
func (client ManagementLocksClient) CreateOrUpdateAtResourceLevelResponder(resp *http.Response) (result ManagementLockObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateAtSubscriptionLevel when you apply a lock at a parent scope, all child resources inherit the same
// lock. To create management locks, you must have access to Microsoft.Authorization/* or
// Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted
// those actions.
// Parameters:
// lockName - the name of lock. The lock name can be a maximum of 260 characters. It cannot contain <, > %, &,
// :, \, ?, /, or any control characters.
// parameters - the management lock parameters.
func (client ManagementLocksClient) CreateOrUpdateAtSubscriptionLevel(ctx context.Context, lockName string, parameters ManagementLockObject) (result ManagementLockObject, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ManagementLockProperties", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("locks.ManagementLocksClient", "CreateOrUpdateAtSubscriptionLevel", err.Error())
	}

	req, err := client.CreateOrUpdateAtSubscriptionLevelPreparer(ctx, lockName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "CreateOrUpdateAtSubscriptionLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateAtSubscriptionLevelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "CreateOrUpdateAtSubscriptionLevel", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateAtSubscriptionLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "CreateOrUpdateAtSubscriptionLevel", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateAtSubscriptionLevelPreparer prepares the CreateOrUpdateAtSubscriptionLevel request.
func (client ManagementLocksClient) CreateOrUpdateAtSubscriptionLevelPreparer(ctx context.Context, lockName string, parameters ManagementLockObject) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"lockName":       autorest.Encode("path", lockName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateAtSubscriptionLevelSender sends the CreateOrUpdateAtSubscriptionLevel request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementLocksClient) CreateOrUpdateAtSubscriptionLevelSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateAtSubscriptionLevelResponder handles the response to the CreateOrUpdateAtSubscriptionLevel request. The method always
// closes the http.Response Body.
func (client ManagementLocksClient) CreateOrUpdateAtSubscriptionLevelResponder(resp *http.Response) (result ManagementLockObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateByScope create or update a management lock by scope.
// Parameters:
// scope - the scope for the lock. When providing a scope for the assignment, use
// '/subscriptions/{subscriptionId}' for subscriptions,
// '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}' for resource groups, and
// '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePathIfPresent}/{resourceType}/{resourceName}'
// for resources.
// lockName - the name of lock.
// parameters - create or update management lock parameters.
func (client ManagementLocksClient) CreateOrUpdateByScope(ctx context.Context, scope string, lockName string, parameters ManagementLockObject) (result ManagementLockObject, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ManagementLockProperties", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("locks.ManagementLocksClient", "CreateOrUpdateByScope", err.Error())
	}

	req, err := client.CreateOrUpdateByScopePreparer(ctx, scope, lockName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "CreateOrUpdateByScope", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateByScopeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "CreateOrUpdateByScope", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateByScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "CreateOrUpdateByScope", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateByScopePreparer prepares the CreateOrUpdateByScope request.
func (client ManagementLocksClient) CreateOrUpdateByScopePreparer(ctx context.Context, scope string, lockName string, parameters ManagementLockObject) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"lockName": autorest.Encode("path", lockName),
		"scope":    autorest.Encode("path", scope),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/locks/{lockName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateByScopeSender sends the CreateOrUpdateByScope request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementLocksClient) CreateOrUpdateByScopeSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateOrUpdateByScopeResponder handles the response to the CreateOrUpdateByScope request. The method always
// closes the http.Response Body.
func (client ManagementLocksClient) CreateOrUpdateByScopeResponder(resp *http.Response) (result ManagementLockObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteAtResourceGroupLevel to delete management locks, you must have access to Microsoft.Authorization/* or
// Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted
// those actions.
// Parameters:
// resourceGroupName - the name of the resource group containing the lock.
// lockName - the name of lock to delete.
func (client ManagementLocksClient) DeleteAtResourceGroupLevel(ctx context.Context, resourceGroupName string, lockName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("locks.ManagementLocksClient", "DeleteAtResourceGroupLevel", err.Error())
	}

	req, err := client.DeleteAtResourceGroupLevelPreparer(ctx, resourceGroupName, lockName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "DeleteAtResourceGroupLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteAtResourceGroupLevelSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "DeleteAtResourceGroupLevel", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteAtResourceGroupLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "DeleteAtResourceGroupLevel", resp, "Failure responding to request")
	}

	return
}

// DeleteAtResourceGroupLevelPreparer prepares the DeleteAtResourceGroupLevel request.
func (client ManagementLocksClient) DeleteAtResourceGroupLevelPreparer(ctx context.Context, resourceGroupName string, lockName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"lockName":          autorest.Encode("path", lockName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteAtResourceGroupLevelSender sends the DeleteAtResourceGroupLevel request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementLocksClient) DeleteAtResourceGroupLevelSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteAtResourceGroupLevelResponder handles the response to the DeleteAtResourceGroupLevel request. The method always
// closes the http.Response Body.
func (client ManagementLocksClient) DeleteAtResourceGroupLevelResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteAtResourceLevel to delete management locks, you must have access to Microsoft.Authorization/* or
// Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted
// those actions.
// Parameters:
// resourceGroupName - the name of the resource group containing the resource with the lock to delete.
// resourceProviderNamespace - the resource provider namespace of the resource with the lock to delete.
// parentResourcePath - the parent resource identity.
// resourceType - the resource type of the resource with the lock to delete.
// resourceName - the name of the resource with the lock to delete.
// lockName - the name of the lock to delete.
func (client ManagementLocksClient) DeleteAtResourceLevel(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("locks.ManagementLocksClient", "DeleteAtResourceLevel", err.Error())
	}

	req, err := client.DeleteAtResourceLevelPreparer(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "DeleteAtResourceLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteAtResourceLevelSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "DeleteAtResourceLevel", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteAtResourceLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "DeleteAtResourceLevel", resp, "Failure responding to request")
	}

	return
}

// DeleteAtResourceLevelPreparer prepares the DeleteAtResourceLevel request.
func (client ManagementLocksClient) DeleteAtResourceLevelPreparer(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"lockName":                  autorest.Encode("path", lockName),
		"parentResourcePath":        parentResourcePath,
		"resourceGroupName":         autorest.Encode("path", resourceGroupName),
		"resourceName":              autorest.Encode("path", resourceName),
		"resourceProviderNamespace": autorest.Encode("path", resourceProviderNamespace),
		"resourceType":              resourceType,
		"subscriptionId":            autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteAtResourceLevelSender sends the DeleteAtResourceLevel request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementLocksClient) DeleteAtResourceLevelSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteAtResourceLevelResponder handles the response to the DeleteAtResourceLevel request. The method always
// closes the http.Response Body.
func (client ManagementLocksClient) DeleteAtResourceLevelResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteAtSubscriptionLevel to delete management locks, you must have access to Microsoft.Authorization/* or
// Microsoft.Authorization/locks/* actions. Of the built-in roles, only Owner and User Access Administrator are granted
// those actions.
// Parameters:
// lockName - the name of lock to delete.
func (client ManagementLocksClient) DeleteAtSubscriptionLevel(ctx context.Context, lockName string) (result autorest.Response, err error) {
	req, err := client.DeleteAtSubscriptionLevelPreparer(ctx, lockName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "DeleteAtSubscriptionLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteAtSubscriptionLevelSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "DeleteAtSubscriptionLevel", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteAtSubscriptionLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "DeleteAtSubscriptionLevel", resp, "Failure responding to request")
	}

	return
}

// DeleteAtSubscriptionLevelPreparer prepares the DeleteAtSubscriptionLevel request.
func (client ManagementLocksClient) DeleteAtSubscriptionLevelPreparer(ctx context.Context, lockName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"lockName":       autorest.Encode("path", lockName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteAtSubscriptionLevelSender sends the DeleteAtSubscriptionLevel request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementLocksClient) DeleteAtSubscriptionLevelSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteAtSubscriptionLevelResponder handles the response to the DeleteAtSubscriptionLevel request. The method always
// closes the http.Response Body.
func (client ManagementLocksClient) DeleteAtSubscriptionLevelResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteByScope delete a management lock by scope.
// Parameters:
// scope - the scope for the lock.
// lockName - the name of lock.
func (client ManagementLocksClient) DeleteByScope(ctx context.Context, scope string, lockName string) (result autorest.Response, err error) {
	req, err := client.DeleteByScopePreparer(ctx, scope, lockName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "DeleteByScope", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteByScopeSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "DeleteByScope", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteByScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "DeleteByScope", resp, "Failure responding to request")
	}

	return
}

// DeleteByScopePreparer prepares the DeleteByScope request.
func (client ManagementLocksClient) DeleteByScopePreparer(ctx context.Context, scope string, lockName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"lockName": autorest.Encode("path", lockName),
		"scope":    autorest.Encode("path", scope),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/locks/{lockName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteByScopeSender sends the DeleteByScope request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementLocksClient) DeleteByScopeSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteByScopeResponder handles the response to the DeleteByScope request. The method always
// closes the http.Response Body.
func (client ManagementLocksClient) DeleteByScopeResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetAtResourceGroupLevel gets a management lock at the resource group level.
// Parameters:
// resourceGroupName - the name of the locked resource group.
// lockName - the name of the lock to get.
func (client ManagementLocksClient) GetAtResourceGroupLevel(ctx context.Context, resourceGroupName string, lockName string) (result ManagementLockObject, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("locks.ManagementLocksClient", "GetAtResourceGroupLevel", err.Error())
	}

	req, err := client.GetAtResourceGroupLevelPreparer(ctx, resourceGroupName, lockName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "GetAtResourceGroupLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAtResourceGroupLevelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "GetAtResourceGroupLevel", resp, "Failure sending request")
		return
	}

	result, err = client.GetAtResourceGroupLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "GetAtResourceGroupLevel", resp, "Failure responding to request")
	}

	return
}

// GetAtResourceGroupLevelPreparer prepares the GetAtResourceGroupLevel request.
func (client ManagementLocksClient) GetAtResourceGroupLevelPreparer(ctx context.Context, resourceGroupName string, lockName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"lockName":          autorest.Encode("path", lockName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAtResourceGroupLevelSender sends the GetAtResourceGroupLevel request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementLocksClient) GetAtResourceGroupLevelSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetAtResourceGroupLevelResponder handles the response to the GetAtResourceGroupLevel request. The method always
// closes the http.Response Body.
func (client ManagementLocksClient) GetAtResourceGroupLevelResponder(resp *http.Response) (result ManagementLockObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAtResourceLevel get the management lock of a resource or any level below resource.
// Parameters:
// resourceGroupName - the name of the resource group.
// resourceProviderNamespace - the namespace of the resource provider.
// parentResourcePath - an extra path parameter needed in some services, like SQL Databases.
// resourceType - the type of the resource.
// resourceName - the name of the resource.
// lockName - the name of lock.
func (client ManagementLocksClient) GetAtResourceLevel(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string) (result ManagementLockObject, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("locks.ManagementLocksClient", "GetAtResourceLevel", err.Error())
	}

	req, err := client.GetAtResourceLevelPreparer(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "GetAtResourceLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAtResourceLevelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "GetAtResourceLevel", resp, "Failure sending request")
		return
	}

	result, err = client.GetAtResourceLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "GetAtResourceLevel", resp, "Failure responding to request")
	}

	return
}

// GetAtResourceLevelPreparer prepares the GetAtResourceLevel request.
func (client ManagementLocksClient) GetAtResourceLevelPreparer(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"lockName":                  autorest.Encode("path", lockName),
		"parentResourcePath":        parentResourcePath,
		"resourceGroupName":         autorest.Encode("path", resourceGroupName),
		"resourceName":              autorest.Encode("path", resourceName),
		"resourceProviderNamespace": autorest.Encode("path", resourceProviderNamespace),
		"resourceType":              resourceType,
		"subscriptionId":            autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAtResourceLevelSender sends the GetAtResourceLevel request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementLocksClient) GetAtResourceLevelSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetAtResourceLevelResponder handles the response to the GetAtResourceLevel request. The method always
// closes the http.Response Body.
func (client ManagementLocksClient) GetAtResourceLevelResponder(resp *http.Response) (result ManagementLockObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAtSubscriptionLevel gets a management lock at the subscription level.
// Parameters:
// lockName - the name of the lock to get.
func (client ManagementLocksClient) GetAtSubscriptionLevel(ctx context.Context, lockName string) (result ManagementLockObject, err error) {
	req, err := client.GetAtSubscriptionLevelPreparer(ctx, lockName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "GetAtSubscriptionLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAtSubscriptionLevelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "GetAtSubscriptionLevel", resp, "Failure sending request")
		return
	}

	result, err = client.GetAtSubscriptionLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "GetAtSubscriptionLevel", resp, "Failure responding to request")
	}

	return
}

// GetAtSubscriptionLevelPreparer prepares the GetAtSubscriptionLevel request.
func (client ManagementLocksClient) GetAtSubscriptionLevelPreparer(ctx context.Context, lockName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"lockName":       autorest.Encode("path", lockName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAtSubscriptionLevelSender sends the GetAtSubscriptionLevel request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementLocksClient) GetAtSubscriptionLevelSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetAtSubscriptionLevelResponder handles the response to the GetAtSubscriptionLevel request. The method always
// closes the http.Response Body.
func (client ManagementLocksClient) GetAtSubscriptionLevelResponder(resp *http.Response) (result ManagementLockObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetByScope get a management lock by scope.
// Parameters:
// scope - the scope for the lock.
// lockName - the name of lock.
func (client ManagementLocksClient) GetByScope(ctx context.Context, scope string, lockName string) (result ManagementLockObject, err error) {
	req, err := client.GetByScopePreparer(ctx, scope, lockName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "GetByScope", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByScopeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "GetByScope", resp, "Failure sending request")
		return
	}

	result, err = client.GetByScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "GetByScope", resp, "Failure responding to request")
	}

	return
}

// GetByScopePreparer prepares the GetByScope request.
func (client ManagementLocksClient) GetByScopePreparer(ctx context.Context, scope string, lockName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"lockName": autorest.Encode("path", lockName),
		"scope":    autorest.Encode("path", scope),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/locks/{lockName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByScopeSender sends the GetByScope request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementLocksClient) GetByScopeSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetByScopeResponder handles the response to the GetByScope request. The method always
// closes the http.Response Body.
func (client ManagementLocksClient) GetByScopeResponder(resp *http.Response) (result ManagementLockObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListAtResourceGroupLevel gets all the management locks for a resource group.
// Parameters:
// resourceGroupName - the name of the resource group containing the locks to get.
// filter - the filter to apply on the operation.
func (client ManagementLocksClient) ListAtResourceGroupLevel(ctx context.Context, resourceGroupName string, filter string) (result ManagementLockListResultPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("locks.ManagementLocksClient", "ListAtResourceGroupLevel", err.Error())
	}

	result.fn = client.listAtResourceGroupLevelNextResults
	req, err := client.ListAtResourceGroupLevelPreparer(ctx, resourceGroupName, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "ListAtResourceGroupLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAtResourceGroupLevelSender(req)
	if err != nil {
		result.mllr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "ListAtResourceGroupLevel", resp, "Failure sending request")
		return
	}

	result.mllr, err = client.ListAtResourceGroupLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "ListAtResourceGroupLevel", resp, "Failure responding to request")
	}

	return
}

// ListAtResourceGroupLevelPreparer prepares the ListAtResourceGroupLevel request.
func (client ManagementLocksClient) ListAtResourceGroupLevelPreparer(ctx context.Context, resourceGroupName string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAtResourceGroupLevelSender sends the ListAtResourceGroupLevel request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementLocksClient) ListAtResourceGroupLevelSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListAtResourceGroupLevelResponder handles the response to the ListAtResourceGroupLevel request. The method always
// closes the http.Response Body.
func (client ManagementLocksClient) ListAtResourceGroupLevelResponder(resp *http.Response) (result ManagementLockListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listAtResourceGroupLevelNextResults retrieves the next set of results, if any.
func (client ManagementLocksClient) listAtResourceGroupLevelNextResults(lastResults ManagementLockListResult) (result ManagementLockListResult, err error) {
	req, err := lastResults.managementLockListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "listAtResourceGroupLevelNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListAtResourceGroupLevelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "listAtResourceGroupLevelNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListAtResourceGroupLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "listAtResourceGroupLevelNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListAtResourceGroupLevelComplete enumerates all values, automatically crossing page boundaries as required.
func (client ManagementLocksClient) ListAtResourceGroupLevelComplete(ctx context.Context, resourceGroupName string, filter string) (result ManagementLockListResultIterator, err error) {
	result.page, err = client.ListAtResourceGroupLevel(ctx, resourceGroupName, filter)
	return
}

// ListAtResourceLevel gets all the management locks for a resource or any level below resource.
// Parameters:
// resourceGroupName - the name of the resource group containing the locked resource. The name is case
// insensitive.
// resourceProviderNamespace - the namespace of the resource provider.
// parentResourcePath - the parent resource identity.
// resourceType - the resource type of the locked resource.
// resourceName - the name of the locked resource.
// filter - the filter to apply on the operation.
func (client ManagementLocksClient) ListAtResourceLevel(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, filter string) (result ManagementLockListResultPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("locks.ManagementLocksClient", "ListAtResourceLevel", err.Error())
	}

	result.fn = client.listAtResourceLevelNextResults
	req, err := client.ListAtResourceLevelPreparer(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "ListAtResourceLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAtResourceLevelSender(req)
	if err != nil {
		result.mllr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "ListAtResourceLevel", resp, "Failure sending request")
		return
	}

	result.mllr, err = client.ListAtResourceLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "ListAtResourceLevel", resp, "Failure responding to request")
	}

	return
}

// ListAtResourceLevelPreparer prepares the ListAtResourceLevel request.
func (client ManagementLocksClient) ListAtResourceLevelPreparer(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"parentResourcePath":        parentResourcePath,
		"resourceGroupName":         autorest.Encode("path", resourceGroupName),
		"resourceName":              autorest.Encode("path", resourceName),
		"resourceProviderNamespace": autorest.Encode("path", resourceProviderNamespace),
		"resourceType":              resourceType,
		"subscriptionId":            autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAtResourceLevelSender sends the ListAtResourceLevel request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementLocksClient) ListAtResourceLevelSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListAtResourceLevelResponder handles the response to the ListAtResourceLevel request. The method always
// closes the http.Response Body.
func (client ManagementLocksClient) ListAtResourceLevelResponder(resp *http.Response) (result ManagementLockListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listAtResourceLevelNextResults retrieves the next set of results, if any.
func (client ManagementLocksClient) listAtResourceLevelNextResults(lastResults ManagementLockListResult) (result ManagementLockListResult, err error) {
	req, err := lastResults.managementLockListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "listAtResourceLevelNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListAtResourceLevelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "listAtResourceLevelNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListAtResourceLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "listAtResourceLevelNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListAtResourceLevelComplete enumerates all values, automatically crossing page boundaries as required.
func (client ManagementLocksClient) ListAtResourceLevelComplete(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, filter string) (result ManagementLockListResultIterator, err error) {
	result.page, err = client.ListAtResourceLevel(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter)
	return
}

// ListAtSubscriptionLevel gets all the management locks for a subscription.
// Parameters:
// filter - the filter to apply on the operation.
func (client ManagementLocksClient) ListAtSubscriptionLevel(ctx context.Context, filter string) (result ManagementLockListResultPage, err error) {
	result.fn = client.listAtSubscriptionLevelNextResults
	req, err := client.ListAtSubscriptionLevelPreparer(ctx, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "ListAtSubscriptionLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAtSubscriptionLevelSender(req)
	if err != nil {
		result.mllr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "ListAtSubscriptionLevel", resp, "Failure sending request")
		return
	}

	result.mllr, err = client.ListAtSubscriptionLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "ListAtSubscriptionLevel", resp, "Failure responding to request")
	}

	return
}

// ListAtSubscriptionLevelPreparer prepares the ListAtSubscriptionLevel request.
func (client ManagementLocksClient) ListAtSubscriptionLevelPreparer(ctx context.Context, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAtSubscriptionLevelSender sends the ListAtSubscriptionLevel request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementLocksClient) ListAtSubscriptionLevelSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListAtSubscriptionLevelResponder handles the response to the ListAtSubscriptionLevel request. The method always
// closes the http.Response Body.
func (client ManagementLocksClient) ListAtSubscriptionLevelResponder(resp *http.Response) (result ManagementLockListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listAtSubscriptionLevelNextResults retrieves the next set of results, if any.
func (client ManagementLocksClient) listAtSubscriptionLevelNextResults(lastResults ManagementLockListResult) (result ManagementLockListResult, err error) {
	req, err := lastResults.managementLockListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "listAtSubscriptionLevelNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListAtSubscriptionLevelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "listAtSubscriptionLevelNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListAtSubscriptionLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "locks.ManagementLocksClient", "listAtSubscriptionLevelNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListAtSubscriptionLevelComplete enumerates all values, automatically crossing page boundaries as required.
func (client ManagementLocksClient) ListAtSubscriptionLevelComplete(ctx context.Context, filter string) (result ManagementLockListResultIterator, err error) {
	result.page, err = client.ListAtSubscriptionLevel(ctx, filter)
	return
}
