// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by entc, DO NOT EDIT.

package ent

import (
	"context"
	"fmt"
	"sync"

	"entgo.io/ent/entc/integration/customid/ent/blob"
	"entgo.io/ent/entc/integration/customid/ent/car"
	"entgo.io/ent/entc/integration/customid/ent/doc"
	"entgo.io/ent/entc/integration/customid/ent/group"
	"entgo.io/ent/entc/integration/customid/ent/mixinid"
	"entgo.io/ent/entc/integration/customid/ent/note"
	"entgo.io/ent/entc/integration/customid/ent/pet"
	"entgo.io/ent/entc/integration/customid/ent/predicate"
	"entgo.io/ent/entc/integration/customid/ent/schema"
	"entgo.io/ent/entc/integration/customid/ent/user"
	"github.com/google/uuid"

	"entgo.io/ent"
)

const (
	// Operation types.
	OpCreate    = ent.OpCreate
	OpDelete    = ent.OpDelete
	OpDeleteOne = ent.OpDeleteOne
	OpUpdate    = ent.OpUpdate
	OpUpdateOne = ent.OpUpdateOne

	// Node types.
	TypeBlob    = "Blob"
	TypeCar     = "Car"
	TypeDoc     = "Doc"
	TypeGroup   = "Group"
	TypeMixinID = "MixinID"
	TypeNote    = "Note"
	TypePet     = "Pet"
	TypeUser    = "User"
)

// BlobMutation represents an operation that mutates the Blob nodes in the graph.
type BlobMutation struct {
	config
	op            Op
	typ           string
	id            *uuid.UUID
	uuid          *uuid.UUID
	clearedFields map[string]struct{}
	parent        *uuid.UUID
	clearedparent bool
	links         map[uuid.UUID]struct{}
	removedlinks  map[uuid.UUID]struct{}
	clearedlinks  bool
	done          bool
	oldValue      func(context.Context) (*Blob, error)
	predicates    []predicate.Blob
}

var _ ent.Mutation = (*BlobMutation)(nil)

// blobOption allows management of the mutation configuration using functional options.
type blobOption func(*BlobMutation)

// newBlobMutation creates new mutation for the Blob entity.
func newBlobMutation(c config, op Op, opts ...blobOption) *BlobMutation {
	m := &BlobMutation{
		config:        c,
		op:            op,
		typ:           TypeBlob,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withBlobID sets the ID field of the mutation.
func withBlobID(id uuid.UUID) blobOption {
	return func(m *BlobMutation) {
		var (
			err   error
			once  sync.Once
			value *Blob
		)
		m.oldValue = func(ctx context.Context) (*Blob, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Blob.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withBlob sets the old Blob of the mutation.
func withBlob(node *Blob) blobOption {
	return func(m *BlobMutation) {
		m.oldValue = func(context.Context) (*Blob, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m BlobMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m BlobMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Blob entities.
func (m *BlobMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *BlobMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetUUID sets the "uuid" field.
func (m *BlobMutation) SetUUID(u uuid.UUID) {
	m.uuid = &u
}

// UUID returns the value of the "uuid" field in the mutation.
func (m *BlobMutation) UUID() (r uuid.UUID, exists bool) {
	v := m.uuid
	if v == nil {
		return
	}
	return *v, true
}

// OldUUID returns the old "uuid" field's value of the Blob entity.
// If the Blob object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *BlobMutation) OldUUID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldUUID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldUUID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUUID: %w", err)
	}
	return oldValue.UUID, nil
}

// ResetUUID resets all changes to the "uuid" field.
func (m *BlobMutation) ResetUUID() {
	m.uuid = nil
}

// SetParentID sets the "parent" edge to the Blob entity by id.
func (m *BlobMutation) SetParentID(id uuid.UUID) {
	m.parent = &id
}

// ClearParent clears the "parent" edge to the Blob entity.
func (m *BlobMutation) ClearParent() {
	m.clearedparent = true
}

// ParentCleared reports if the "parent" edge to the Blob entity was cleared.
func (m *BlobMutation) ParentCleared() bool {
	return m.clearedparent
}

// ParentID returns the "parent" edge ID in the mutation.
func (m *BlobMutation) ParentID() (id uuid.UUID, exists bool) {
	if m.parent != nil {
		return *m.parent, true
	}
	return
}

// ParentIDs returns the "parent" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// ParentID instead. It exists only for internal usage by the builders.
func (m *BlobMutation) ParentIDs() (ids []uuid.UUID) {
	if id := m.parent; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetParent resets all changes to the "parent" edge.
func (m *BlobMutation) ResetParent() {
	m.parent = nil
	m.clearedparent = false
}

// AddLinkIDs adds the "links" edge to the Blob entity by ids.
func (m *BlobMutation) AddLinkIDs(ids ...uuid.UUID) {
	if m.links == nil {
		m.links = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.links[ids[i]] = struct{}{}
	}
}

// ClearLinks clears the "links" edge to the Blob entity.
func (m *BlobMutation) ClearLinks() {
	m.clearedlinks = true
}

// LinksCleared reports if the "links" edge to the Blob entity was cleared.
func (m *BlobMutation) LinksCleared() bool {
	return m.clearedlinks
}

// RemoveLinkIDs removes the "links" edge to the Blob entity by IDs.
func (m *BlobMutation) RemoveLinkIDs(ids ...uuid.UUID) {
	if m.removedlinks == nil {
		m.removedlinks = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.links, ids[i])
		m.removedlinks[ids[i]] = struct{}{}
	}
}

// RemovedLinks returns the removed IDs of the "links" edge to the Blob entity.
func (m *BlobMutation) RemovedLinksIDs() (ids []uuid.UUID) {
	for id := range m.removedlinks {
		ids = append(ids, id)
	}
	return
}

// LinksIDs returns the "links" edge IDs in the mutation.
func (m *BlobMutation) LinksIDs() (ids []uuid.UUID) {
	for id := range m.links {
		ids = append(ids, id)
	}
	return
}

// ResetLinks resets all changes to the "links" edge.
func (m *BlobMutation) ResetLinks() {
	m.links = nil
	m.clearedlinks = false
	m.removedlinks = nil
}

// Where appends a list predicates to the BlobMutation builder.
func (m *BlobMutation) Where(ps ...predicate.Blob) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *BlobMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Blob).
func (m *BlobMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *BlobMutation) Fields() []string {
	fields := make([]string, 0, 1)
	if m.uuid != nil {
		fields = append(fields, blob.FieldUUID)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *BlobMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case blob.FieldUUID:
		return m.UUID()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *BlobMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case blob.FieldUUID:
		return m.OldUUID(ctx)
	}
	return nil, fmt.Errorf("unknown Blob field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *BlobMutation) SetField(name string, value ent.Value) error {
	switch name {
	case blob.FieldUUID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUUID(v)
		return nil
	}
	return fmt.Errorf("unknown Blob field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *BlobMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *BlobMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *BlobMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Blob numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *BlobMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *BlobMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *BlobMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Blob nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *BlobMutation) ResetField(name string) error {
	switch name {
	case blob.FieldUUID:
		m.ResetUUID()
		return nil
	}
	return fmt.Errorf("unknown Blob field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *BlobMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.parent != nil {
		edges = append(edges, blob.EdgeParent)
	}
	if m.links != nil {
		edges = append(edges, blob.EdgeLinks)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *BlobMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case blob.EdgeParent:
		if id := m.parent; id != nil {
			return []ent.Value{*id}
		}
	case blob.EdgeLinks:
		ids := make([]ent.Value, 0, len(m.links))
		for id := range m.links {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *BlobMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	if m.removedlinks != nil {
		edges = append(edges, blob.EdgeLinks)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *BlobMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case blob.EdgeLinks:
		ids := make([]ent.Value, 0, len(m.removedlinks))
		for id := range m.removedlinks {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *BlobMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.clearedparent {
		edges = append(edges, blob.EdgeParent)
	}
	if m.clearedlinks {
		edges = append(edges, blob.EdgeLinks)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *BlobMutation) EdgeCleared(name string) bool {
	switch name {
	case blob.EdgeParent:
		return m.clearedparent
	case blob.EdgeLinks:
		return m.clearedlinks
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *BlobMutation) ClearEdge(name string) error {
	switch name {
	case blob.EdgeParent:
		m.ClearParent()
		return nil
	}
	return fmt.Errorf("unknown Blob unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *BlobMutation) ResetEdge(name string) error {
	switch name {
	case blob.EdgeParent:
		m.ResetParent()
		return nil
	case blob.EdgeLinks:
		m.ResetLinks()
		return nil
	}
	return fmt.Errorf("unknown Blob edge %s", name)
}

// CarMutation represents an operation that mutates the Car nodes in the graph.
type CarMutation struct {
	config
	op            Op
	typ           string
	id            *int
	before_id     *float64
	addbefore_id  *float64
	after_id      *float64
	addafter_id   *float64
	model         *string
	clearedFields map[string]struct{}
	owner         *string
	clearedowner  bool
	done          bool
	oldValue      func(context.Context) (*Car, error)
	predicates    []predicate.Car
}

var _ ent.Mutation = (*CarMutation)(nil)

// carOption allows management of the mutation configuration using functional options.
type carOption func(*CarMutation)

// newCarMutation creates new mutation for the Car entity.
func newCarMutation(c config, op Op, opts ...carOption) *CarMutation {
	m := &CarMutation{
		config:        c,
		op:            op,
		typ:           TypeCar,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withCarID sets the ID field of the mutation.
func withCarID(id int) carOption {
	return func(m *CarMutation) {
		var (
			err   error
			once  sync.Once
			value *Car
		)
		m.oldValue = func(ctx context.Context) (*Car, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Car.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withCar sets the old Car of the mutation.
func withCar(node *Car) carOption {
	return func(m *CarMutation) {
		m.oldValue = func(context.Context) (*Car, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m CarMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m CarMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Car entities.
func (m *CarMutation) SetID(id int) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *CarMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetBeforeID sets the "before_id" field.
func (m *CarMutation) SetBeforeID(f float64) {
	m.before_id = &f
	m.addbefore_id = nil
}

// BeforeID returns the value of the "before_id" field in the mutation.
func (m *CarMutation) BeforeID() (r float64, exists bool) {
	v := m.before_id
	if v == nil {
		return
	}
	return *v, true
}

// OldBeforeID returns the old "before_id" field's value of the Car entity.
// If the Car object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CarMutation) OldBeforeID(ctx context.Context) (v float64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldBeforeID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldBeforeID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldBeforeID: %w", err)
	}
	return oldValue.BeforeID, nil
}

// AddBeforeID adds f to the "before_id" field.
func (m *CarMutation) AddBeforeID(f float64) {
	if m.addbefore_id != nil {
		*m.addbefore_id += f
	} else {
		m.addbefore_id = &f
	}
}

// AddedBeforeID returns the value that was added to the "before_id" field in this mutation.
func (m *CarMutation) AddedBeforeID() (r float64, exists bool) {
	v := m.addbefore_id
	if v == nil {
		return
	}
	return *v, true
}

// ClearBeforeID clears the value of the "before_id" field.
func (m *CarMutation) ClearBeforeID() {
	m.before_id = nil
	m.addbefore_id = nil
	m.clearedFields[car.FieldBeforeID] = struct{}{}
}

// BeforeIDCleared returns if the "before_id" field was cleared in this mutation.
func (m *CarMutation) BeforeIDCleared() bool {
	_, ok := m.clearedFields[car.FieldBeforeID]
	return ok
}

// ResetBeforeID resets all changes to the "before_id" field.
func (m *CarMutation) ResetBeforeID() {
	m.before_id = nil
	m.addbefore_id = nil
	delete(m.clearedFields, car.FieldBeforeID)
}

// SetAfterID sets the "after_id" field.
func (m *CarMutation) SetAfterID(f float64) {
	m.after_id = &f
	m.addafter_id = nil
}

// AfterID returns the value of the "after_id" field in the mutation.
func (m *CarMutation) AfterID() (r float64, exists bool) {
	v := m.after_id
	if v == nil {
		return
	}
	return *v, true
}

// OldAfterID returns the old "after_id" field's value of the Car entity.
// If the Car object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CarMutation) OldAfterID(ctx context.Context) (v float64, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldAfterID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldAfterID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAfterID: %w", err)
	}
	return oldValue.AfterID, nil
}

// AddAfterID adds f to the "after_id" field.
func (m *CarMutation) AddAfterID(f float64) {
	if m.addafter_id != nil {
		*m.addafter_id += f
	} else {
		m.addafter_id = &f
	}
}

// AddedAfterID returns the value that was added to the "after_id" field in this mutation.
func (m *CarMutation) AddedAfterID() (r float64, exists bool) {
	v := m.addafter_id
	if v == nil {
		return
	}
	return *v, true
}

// ClearAfterID clears the value of the "after_id" field.
func (m *CarMutation) ClearAfterID() {
	m.after_id = nil
	m.addafter_id = nil
	m.clearedFields[car.FieldAfterID] = struct{}{}
}

// AfterIDCleared returns if the "after_id" field was cleared in this mutation.
func (m *CarMutation) AfterIDCleared() bool {
	_, ok := m.clearedFields[car.FieldAfterID]
	return ok
}

// ResetAfterID resets all changes to the "after_id" field.
func (m *CarMutation) ResetAfterID() {
	m.after_id = nil
	m.addafter_id = nil
	delete(m.clearedFields, car.FieldAfterID)
}

// SetModel sets the "model" field.
func (m *CarMutation) SetModel(s string) {
	m.model = &s
}

// Model returns the value of the "model" field in the mutation.
func (m *CarMutation) Model() (r string, exists bool) {
	v := m.model
	if v == nil {
		return
	}
	return *v, true
}

// OldModel returns the old "model" field's value of the Car entity.
// If the Car object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CarMutation) OldModel(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldModel is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldModel requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldModel: %w", err)
	}
	return oldValue.Model, nil
}

// ResetModel resets all changes to the "model" field.
func (m *CarMutation) ResetModel() {
	m.model = nil
}

// SetOwnerID sets the "owner" edge to the Pet entity by id.
func (m *CarMutation) SetOwnerID(id string) {
	m.owner = &id
}

// ClearOwner clears the "owner" edge to the Pet entity.
func (m *CarMutation) ClearOwner() {
	m.clearedowner = true
}

// OwnerCleared reports if the "owner" edge to the Pet entity was cleared.
func (m *CarMutation) OwnerCleared() bool {
	return m.clearedowner
}

// OwnerID returns the "owner" edge ID in the mutation.
func (m *CarMutation) OwnerID() (id string, exists bool) {
	if m.owner != nil {
		return *m.owner, true
	}
	return
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *CarMutation) OwnerIDs() (ids []string) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *CarMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// Where appends a list predicates to the CarMutation builder.
func (m *CarMutation) Where(ps ...predicate.Car) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *CarMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Car).
func (m *CarMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *CarMutation) Fields() []string {
	fields := make([]string, 0, 3)
	if m.before_id != nil {
		fields = append(fields, car.FieldBeforeID)
	}
	if m.after_id != nil {
		fields = append(fields, car.FieldAfterID)
	}
	if m.model != nil {
		fields = append(fields, car.FieldModel)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *CarMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case car.FieldBeforeID:
		return m.BeforeID()
	case car.FieldAfterID:
		return m.AfterID()
	case car.FieldModel:
		return m.Model()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *CarMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case car.FieldBeforeID:
		return m.OldBeforeID(ctx)
	case car.FieldAfterID:
		return m.OldAfterID(ctx)
	case car.FieldModel:
		return m.OldModel(ctx)
	}
	return nil, fmt.Errorf("unknown Car field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *CarMutation) SetField(name string, value ent.Value) error {
	switch name {
	case car.FieldBeforeID:
		v, ok := value.(float64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetBeforeID(v)
		return nil
	case car.FieldAfterID:
		v, ok := value.(float64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAfterID(v)
		return nil
	case car.FieldModel:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetModel(v)
		return nil
	}
	return fmt.Errorf("unknown Car field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *CarMutation) AddedFields() []string {
	var fields []string
	if m.addbefore_id != nil {
		fields = append(fields, car.FieldBeforeID)
	}
	if m.addafter_id != nil {
		fields = append(fields, car.FieldAfterID)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *CarMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case car.FieldBeforeID:
		return m.AddedBeforeID()
	case car.FieldAfterID:
		return m.AddedAfterID()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *CarMutation) AddField(name string, value ent.Value) error {
	switch name {
	case car.FieldBeforeID:
		v, ok := value.(float64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddBeforeID(v)
		return nil
	case car.FieldAfterID:
		v, ok := value.(float64)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddAfterID(v)
		return nil
	}
	return fmt.Errorf("unknown Car numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *CarMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(car.FieldBeforeID) {
		fields = append(fields, car.FieldBeforeID)
	}
	if m.FieldCleared(car.FieldAfterID) {
		fields = append(fields, car.FieldAfterID)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *CarMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *CarMutation) ClearField(name string) error {
	switch name {
	case car.FieldBeforeID:
		m.ClearBeforeID()
		return nil
	case car.FieldAfterID:
		m.ClearAfterID()
		return nil
	}
	return fmt.Errorf("unknown Car nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *CarMutation) ResetField(name string) error {
	switch name {
	case car.FieldBeforeID:
		m.ResetBeforeID()
		return nil
	case car.FieldAfterID:
		m.ResetAfterID()
		return nil
	case car.FieldModel:
		m.ResetModel()
		return nil
	}
	return fmt.Errorf("unknown Car field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *CarMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.owner != nil {
		edges = append(edges, car.EdgeOwner)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *CarMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case car.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *CarMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *CarMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *CarMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedowner {
		edges = append(edges, car.EdgeOwner)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *CarMutation) EdgeCleared(name string) bool {
	switch name {
	case car.EdgeOwner:
		return m.clearedowner
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *CarMutation) ClearEdge(name string) error {
	switch name {
	case car.EdgeOwner:
		m.ClearOwner()
		return nil
	}
	return fmt.Errorf("unknown Car unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *CarMutation) ResetEdge(name string) error {
	switch name {
	case car.EdgeOwner:
		m.ResetOwner()
		return nil
	}
	return fmt.Errorf("unknown Car edge %s", name)
}

// DocMutation represents an operation that mutates the Doc nodes in the graph.
type DocMutation struct {
	config
	op              Op
	typ             string
	id              *schema.DocID
	text            *string
	clearedFields   map[string]struct{}
	parent          *schema.DocID
	clearedparent   bool
	children        map[schema.DocID]struct{}
	removedchildren map[schema.DocID]struct{}
	clearedchildren bool
	done            bool
	oldValue        func(context.Context) (*Doc, error)
	predicates      []predicate.Doc
}

var _ ent.Mutation = (*DocMutation)(nil)

// docOption allows management of the mutation configuration using functional options.
type docOption func(*DocMutation)

// newDocMutation creates new mutation for the Doc entity.
func newDocMutation(c config, op Op, opts ...docOption) *DocMutation {
	m := &DocMutation{
		config:        c,
		op:            op,
		typ:           TypeDoc,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withDocID sets the ID field of the mutation.
func withDocID(id schema.DocID) docOption {
	return func(m *DocMutation) {
		var (
			err   error
			once  sync.Once
			value *Doc
		)
		m.oldValue = func(ctx context.Context) (*Doc, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Doc.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withDoc sets the old Doc of the mutation.
func withDoc(node *Doc) docOption {
	return func(m *DocMutation) {
		m.oldValue = func(context.Context) (*Doc, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m DocMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m DocMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Doc entities.
func (m *DocMutation) SetID(id schema.DocID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *DocMutation) ID() (id schema.DocID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetText sets the "text" field.
func (m *DocMutation) SetText(s string) {
	m.text = &s
}

// Text returns the value of the "text" field in the mutation.
func (m *DocMutation) Text() (r string, exists bool) {
	v := m.text
	if v == nil {
		return
	}
	return *v, true
}

// OldText returns the old "text" field's value of the Doc entity.
// If the Doc object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DocMutation) OldText(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldText is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldText requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldText: %w", err)
	}
	return oldValue.Text, nil
}

// ClearText clears the value of the "text" field.
func (m *DocMutation) ClearText() {
	m.text = nil
	m.clearedFields[doc.FieldText] = struct{}{}
}

// TextCleared returns if the "text" field was cleared in this mutation.
func (m *DocMutation) TextCleared() bool {
	_, ok := m.clearedFields[doc.FieldText]
	return ok
}

// ResetText resets all changes to the "text" field.
func (m *DocMutation) ResetText() {
	m.text = nil
	delete(m.clearedFields, doc.FieldText)
}

// SetParentID sets the "parent" edge to the Doc entity by id.
func (m *DocMutation) SetParentID(id schema.DocID) {
	m.parent = &id
}

// ClearParent clears the "parent" edge to the Doc entity.
func (m *DocMutation) ClearParent() {
	m.clearedparent = true
}

// ParentCleared reports if the "parent" edge to the Doc entity was cleared.
func (m *DocMutation) ParentCleared() bool {
	return m.clearedparent
}

// ParentID returns the "parent" edge ID in the mutation.
func (m *DocMutation) ParentID() (id schema.DocID, exists bool) {
	if m.parent != nil {
		return *m.parent, true
	}
	return
}

// ParentIDs returns the "parent" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// ParentID instead. It exists only for internal usage by the builders.
func (m *DocMutation) ParentIDs() (ids []schema.DocID) {
	if id := m.parent; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetParent resets all changes to the "parent" edge.
func (m *DocMutation) ResetParent() {
	m.parent = nil
	m.clearedparent = false
}

// AddChildIDs adds the "children" edge to the Doc entity by ids.
func (m *DocMutation) AddChildIDs(ids ...schema.DocID) {
	if m.children == nil {
		m.children = make(map[schema.DocID]struct{})
	}
	for i := range ids {
		m.children[ids[i]] = struct{}{}
	}
}

// ClearChildren clears the "children" edge to the Doc entity.
func (m *DocMutation) ClearChildren() {
	m.clearedchildren = true
}

// ChildrenCleared reports if the "children" edge to the Doc entity was cleared.
func (m *DocMutation) ChildrenCleared() bool {
	return m.clearedchildren
}

// RemoveChildIDs removes the "children" edge to the Doc entity by IDs.
func (m *DocMutation) RemoveChildIDs(ids ...schema.DocID) {
	if m.removedchildren == nil {
		m.removedchildren = make(map[schema.DocID]struct{})
	}
	for i := range ids {
		delete(m.children, ids[i])
		m.removedchildren[ids[i]] = struct{}{}
	}
}

// RemovedChildren returns the removed IDs of the "children" edge to the Doc entity.
func (m *DocMutation) RemovedChildrenIDs() (ids []schema.DocID) {
	for id := range m.removedchildren {
		ids = append(ids, id)
	}
	return
}

// ChildrenIDs returns the "children" edge IDs in the mutation.
func (m *DocMutation) ChildrenIDs() (ids []schema.DocID) {
	for id := range m.children {
		ids = append(ids, id)
	}
	return
}

// ResetChildren resets all changes to the "children" edge.
func (m *DocMutation) ResetChildren() {
	m.children = nil
	m.clearedchildren = false
	m.removedchildren = nil
}

// Where appends a list predicates to the DocMutation builder.
func (m *DocMutation) Where(ps ...predicate.Doc) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *DocMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Doc).
func (m *DocMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *DocMutation) Fields() []string {
	fields := make([]string, 0, 1)
	if m.text != nil {
		fields = append(fields, doc.FieldText)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *DocMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case doc.FieldText:
		return m.Text()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *DocMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case doc.FieldText:
		return m.OldText(ctx)
	}
	return nil, fmt.Errorf("unknown Doc field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *DocMutation) SetField(name string, value ent.Value) error {
	switch name {
	case doc.FieldText:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetText(v)
		return nil
	}
	return fmt.Errorf("unknown Doc field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *DocMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *DocMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *DocMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Doc numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *DocMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(doc.FieldText) {
		fields = append(fields, doc.FieldText)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *DocMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *DocMutation) ClearField(name string) error {
	switch name {
	case doc.FieldText:
		m.ClearText()
		return nil
	}
	return fmt.Errorf("unknown Doc nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *DocMutation) ResetField(name string) error {
	switch name {
	case doc.FieldText:
		m.ResetText()
		return nil
	}
	return fmt.Errorf("unknown Doc field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *DocMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.parent != nil {
		edges = append(edges, doc.EdgeParent)
	}
	if m.children != nil {
		edges = append(edges, doc.EdgeChildren)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *DocMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case doc.EdgeParent:
		if id := m.parent; id != nil {
			return []ent.Value{*id}
		}
	case doc.EdgeChildren:
		ids := make([]ent.Value, 0, len(m.children))
		for id := range m.children {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *DocMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	if m.removedchildren != nil {
		edges = append(edges, doc.EdgeChildren)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *DocMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case doc.EdgeChildren:
		ids := make([]ent.Value, 0, len(m.removedchildren))
		for id := range m.removedchildren {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *DocMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.clearedparent {
		edges = append(edges, doc.EdgeParent)
	}
	if m.clearedchildren {
		edges = append(edges, doc.EdgeChildren)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *DocMutation) EdgeCleared(name string) bool {
	switch name {
	case doc.EdgeParent:
		return m.clearedparent
	case doc.EdgeChildren:
		return m.clearedchildren
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *DocMutation) ClearEdge(name string) error {
	switch name {
	case doc.EdgeParent:
		m.ClearParent()
		return nil
	}
	return fmt.Errorf("unknown Doc unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *DocMutation) ResetEdge(name string) error {
	switch name {
	case doc.EdgeParent:
		m.ResetParent()
		return nil
	case doc.EdgeChildren:
		m.ResetChildren()
		return nil
	}
	return fmt.Errorf("unknown Doc edge %s", name)
}

// GroupMutation represents an operation that mutates the Group nodes in the graph.
type GroupMutation struct {
	config
	op            Op
	typ           string
	id            *int
	clearedFields map[string]struct{}
	users         map[int]struct{}
	removedusers  map[int]struct{}
	clearedusers  bool
	done          bool
	oldValue      func(context.Context) (*Group, error)
	predicates    []predicate.Group
}

var _ ent.Mutation = (*GroupMutation)(nil)

// groupOption allows management of the mutation configuration using functional options.
type groupOption func(*GroupMutation)

// newGroupMutation creates new mutation for the Group entity.
func newGroupMutation(c config, op Op, opts ...groupOption) *GroupMutation {
	m := &GroupMutation{
		config:        c,
		op:            op,
		typ:           TypeGroup,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withGroupID sets the ID field of the mutation.
func withGroupID(id int) groupOption {
	return func(m *GroupMutation) {
		var (
			err   error
			once  sync.Once
			value *Group
		)
		m.oldValue = func(ctx context.Context) (*Group, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Group.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withGroup sets the old Group of the mutation.
func withGroup(node *Group) groupOption {
	return func(m *GroupMutation) {
		m.oldValue = func(context.Context) (*Group, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m GroupMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m GroupMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Group entities.
func (m *GroupMutation) SetID(id int) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *GroupMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// AddUserIDs adds the "users" edge to the User entity by ids.
func (m *GroupMutation) AddUserIDs(ids ...int) {
	if m.users == nil {
		m.users = make(map[int]struct{})
	}
	for i := range ids {
		m.users[ids[i]] = struct{}{}
	}
}

// ClearUsers clears the "users" edge to the User entity.
func (m *GroupMutation) ClearUsers() {
	m.clearedusers = true
}

// UsersCleared reports if the "users" edge to the User entity was cleared.
func (m *GroupMutation) UsersCleared() bool {
	return m.clearedusers
}

// RemoveUserIDs removes the "users" edge to the User entity by IDs.
func (m *GroupMutation) RemoveUserIDs(ids ...int) {
	if m.removedusers == nil {
		m.removedusers = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.users, ids[i])
		m.removedusers[ids[i]] = struct{}{}
	}
}

// RemovedUsers returns the removed IDs of the "users" edge to the User entity.
func (m *GroupMutation) RemovedUsersIDs() (ids []int) {
	for id := range m.removedusers {
		ids = append(ids, id)
	}
	return
}

// UsersIDs returns the "users" edge IDs in the mutation.
func (m *GroupMutation) UsersIDs() (ids []int) {
	for id := range m.users {
		ids = append(ids, id)
	}
	return
}

// ResetUsers resets all changes to the "users" edge.
func (m *GroupMutation) ResetUsers() {
	m.users = nil
	m.clearedusers = false
	m.removedusers = nil
}

// Where appends a list predicates to the GroupMutation builder.
func (m *GroupMutation) Where(ps ...predicate.Group) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *GroupMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Group).
func (m *GroupMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *GroupMutation) Fields() []string {
	fields := make([]string, 0, 0)
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *GroupMutation) Field(name string) (ent.Value, bool) {
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *GroupMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	return nil, fmt.Errorf("unknown Group field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *GroupMutation) SetField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Group field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *GroupMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *GroupMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *GroupMutation) AddField(name string, value ent.Value) error {
	return fmt.Errorf("unknown Group numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *GroupMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *GroupMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *GroupMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Group nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *GroupMutation) ResetField(name string) error {
	return fmt.Errorf("unknown Group field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *GroupMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.users != nil {
		edges = append(edges, group.EdgeUsers)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *GroupMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case group.EdgeUsers:
		ids := make([]ent.Value, 0, len(m.users))
		for id := range m.users {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *GroupMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	if m.removedusers != nil {
		edges = append(edges, group.EdgeUsers)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *GroupMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case group.EdgeUsers:
		ids := make([]ent.Value, 0, len(m.removedusers))
		for id := range m.removedusers {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *GroupMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedusers {
		edges = append(edges, group.EdgeUsers)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *GroupMutation) EdgeCleared(name string) bool {
	switch name {
	case group.EdgeUsers:
		return m.clearedusers
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *GroupMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown Group unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *GroupMutation) ResetEdge(name string) error {
	switch name {
	case group.EdgeUsers:
		m.ResetUsers()
		return nil
	}
	return fmt.Errorf("unknown Group edge %s", name)
}

// MixinIDMutation represents an operation that mutates the MixinID nodes in the graph.
type MixinIDMutation struct {
	config
	op            Op
	typ           string
	id            *uuid.UUID
	some_field    *string
	mixin_field   *string
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*MixinID, error)
	predicates    []predicate.MixinID
}

var _ ent.Mutation = (*MixinIDMutation)(nil)

// mixinidOption allows management of the mutation configuration using functional options.
type mixinidOption func(*MixinIDMutation)

// newMixinIDMutation creates new mutation for the MixinID entity.
func newMixinIDMutation(c config, op Op, opts ...mixinidOption) *MixinIDMutation {
	m := &MixinIDMutation{
		config:        c,
		op:            op,
		typ:           TypeMixinID,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withMixinIDID sets the ID field of the mutation.
func withMixinIDID(id uuid.UUID) mixinidOption {
	return func(m *MixinIDMutation) {
		var (
			err   error
			once  sync.Once
			value *MixinID
		)
		m.oldValue = func(ctx context.Context) (*MixinID, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().MixinID.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withMixinID sets the old MixinID of the mutation.
func withMixinID(node *MixinID) mixinidOption {
	return func(m *MixinIDMutation) {
		m.oldValue = func(context.Context) (*MixinID, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m MixinIDMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m MixinIDMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of MixinID entities.
func (m *MixinIDMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *MixinIDMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetSomeField sets the "some_field" field.
func (m *MixinIDMutation) SetSomeField(s string) {
	m.some_field = &s
}

// SomeField returns the value of the "some_field" field in the mutation.
func (m *MixinIDMutation) SomeField() (r string, exists bool) {
	v := m.some_field
	if v == nil {
		return
	}
	return *v, true
}

// OldSomeField returns the old "some_field" field's value of the MixinID entity.
// If the MixinID object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MixinIDMutation) OldSomeField(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldSomeField is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldSomeField requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSomeField: %w", err)
	}
	return oldValue.SomeField, nil
}

// ResetSomeField resets all changes to the "some_field" field.
func (m *MixinIDMutation) ResetSomeField() {
	m.some_field = nil
}

// SetMixinField sets the "mixin_field" field.
func (m *MixinIDMutation) SetMixinField(s string) {
	m.mixin_field = &s
}

// MixinField returns the value of the "mixin_field" field in the mutation.
func (m *MixinIDMutation) MixinField() (r string, exists bool) {
	v := m.mixin_field
	if v == nil {
		return
	}
	return *v, true
}

// OldMixinField returns the old "mixin_field" field's value of the MixinID entity.
// If the MixinID object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MixinIDMutation) OldMixinField(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldMixinField is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldMixinField requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldMixinField: %w", err)
	}
	return oldValue.MixinField, nil
}

// ResetMixinField resets all changes to the "mixin_field" field.
func (m *MixinIDMutation) ResetMixinField() {
	m.mixin_field = nil
}

// Where appends a list predicates to the MixinIDMutation builder.
func (m *MixinIDMutation) Where(ps ...predicate.MixinID) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *MixinIDMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (MixinID).
func (m *MixinIDMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *MixinIDMutation) Fields() []string {
	fields := make([]string, 0, 2)
	if m.some_field != nil {
		fields = append(fields, mixinid.FieldSomeField)
	}
	if m.mixin_field != nil {
		fields = append(fields, mixinid.FieldMixinField)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *MixinIDMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case mixinid.FieldSomeField:
		return m.SomeField()
	case mixinid.FieldMixinField:
		return m.MixinField()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *MixinIDMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case mixinid.FieldSomeField:
		return m.OldSomeField(ctx)
	case mixinid.FieldMixinField:
		return m.OldMixinField(ctx)
	}
	return nil, fmt.Errorf("unknown MixinID field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MixinIDMutation) SetField(name string, value ent.Value) error {
	switch name {
	case mixinid.FieldSomeField:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSomeField(v)
		return nil
	case mixinid.FieldMixinField:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetMixinField(v)
		return nil
	}
	return fmt.Errorf("unknown MixinID field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *MixinIDMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *MixinIDMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MixinIDMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown MixinID numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *MixinIDMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *MixinIDMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *MixinIDMutation) ClearField(name string) error {
	return fmt.Errorf("unknown MixinID nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *MixinIDMutation) ResetField(name string) error {
	switch name {
	case mixinid.FieldSomeField:
		m.ResetSomeField()
		return nil
	case mixinid.FieldMixinField:
		m.ResetMixinField()
		return nil
	}
	return fmt.Errorf("unknown MixinID field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *MixinIDMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *MixinIDMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *MixinIDMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *MixinIDMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *MixinIDMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *MixinIDMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *MixinIDMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown MixinID unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *MixinIDMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown MixinID edge %s", name)
}

// NoteMutation represents an operation that mutates the Note nodes in the graph.
type NoteMutation struct {
	config
	op              Op
	typ             string
	id              *schema.NoteID
	text            *string
	clearedFields   map[string]struct{}
	parent          *schema.NoteID
	clearedparent   bool
	children        map[schema.NoteID]struct{}
	removedchildren map[schema.NoteID]struct{}
	clearedchildren bool
	done            bool
	oldValue        func(context.Context) (*Note, error)
	predicates      []predicate.Note
}

var _ ent.Mutation = (*NoteMutation)(nil)

// noteOption allows management of the mutation configuration using functional options.
type noteOption func(*NoteMutation)

// newNoteMutation creates new mutation for the Note entity.
func newNoteMutation(c config, op Op, opts ...noteOption) *NoteMutation {
	m := &NoteMutation{
		config:        c,
		op:            op,
		typ:           TypeNote,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withNoteID sets the ID field of the mutation.
func withNoteID(id schema.NoteID) noteOption {
	return func(m *NoteMutation) {
		var (
			err   error
			once  sync.Once
			value *Note
		)
		m.oldValue = func(ctx context.Context) (*Note, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Note.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withNote sets the old Note of the mutation.
func withNote(node *Note) noteOption {
	return func(m *NoteMutation) {
		m.oldValue = func(context.Context) (*Note, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m NoteMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m NoteMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Note entities.
func (m *NoteMutation) SetID(id schema.NoteID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *NoteMutation) ID() (id schema.NoteID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetText sets the "text" field.
func (m *NoteMutation) SetText(s string) {
	m.text = &s
}

// Text returns the value of the "text" field in the mutation.
func (m *NoteMutation) Text() (r string, exists bool) {
	v := m.text
	if v == nil {
		return
	}
	return *v, true
}

// OldText returns the old "text" field's value of the Note entity.
// If the Note object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *NoteMutation) OldText(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldText is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldText requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldText: %w", err)
	}
	return oldValue.Text, nil
}

// ClearText clears the value of the "text" field.
func (m *NoteMutation) ClearText() {
	m.text = nil
	m.clearedFields[note.FieldText] = struct{}{}
}

// TextCleared returns if the "text" field was cleared in this mutation.
func (m *NoteMutation) TextCleared() bool {
	_, ok := m.clearedFields[note.FieldText]
	return ok
}

// ResetText resets all changes to the "text" field.
func (m *NoteMutation) ResetText() {
	m.text = nil
	delete(m.clearedFields, note.FieldText)
}

// SetParentID sets the "parent" edge to the Note entity by id.
func (m *NoteMutation) SetParentID(id schema.NoteID) {
	m.parent = &id
}

// ClearParent clears the "parent" edge to the Note entity.
func (m *NoteMutation) ClearParent() {
	m.clearedparent = true
}

// ParentCleared reports if the "parent" edge to the Note entity was cleared.
func (m *NoteMutation) ParentCleared() bool {
	return m.clearedparent
}

// ParentID returns the "parent" edge ID in the mutation.
func (m *NoteMutation) ParentID() (id schema.NoteID, exists bool) {
	if m.parent != nil {
		return *m.parent, true
	}
	return
}

// ParentIDs returns the "parent" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// ParentID instead. It exists only for internal usage by the builders.
func (m *NoteMutation) ParentIDs() (ids []schema.NoteID) {
	if id := m.parent; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetParent resets all changes to the "parent" edge.
func (m *NoteMutation) ResetParent() {
	m.parent = nil
	m.clearedparent = false
}

// AddChildIDs adds the "children" edge to the Note entity by ids.
func (m *NoteMutation) AddChildIDs(ids ...schema.NoteID) {
	if m.children == nil {
		m.children = make(map[schema.NoteID]struct{})
	}
	for i := range ids {
		m.children[ids[i]] = struct{}{}
	}
}

// ClearChildren clears the "children" edge to the Note entity.
func (m *NoteMutation) ClearChildren() {
	m.clearedchildren = true
}

// ChildrenCleared reports if the "children" edge to the Note entity was cleared.
func (m *NoteMutation) ChildrenCleared() bool {
	return m.clearedchildren
}

// RemoveChildIDs removes the "children" edge to the Note entity by IDs.
func (m *NoteMutation) RemoveChildIDs(ids ...schema.NoteID) {
	if m.removedchildren == nil {
		m.removedchildren = make(map[schema.NoteID]struct{})
	}
	for i := range ids {
		delete(m.children, ids[i])
		m.removedchildren[ids[i]] = struct{}{}
	}
}

// RemovedChildren returns the removed IDs of the "children" edge to the Note entity.
func (m *NoteMutation) RemovedChildrenIDs() (ids []schema.NoteID) {
	for id := range m.removedchildren {
		ids = append(ids, id)
	}
	return
}

// ChildrenIDs returns the "children" edge IDs in the mutation.
func (m *NoteMutation) ChildrenIDs() (ids []schema.NoteID) {
	for id := range m.children {
		ids = append(ids, id)
	}
	return
}

// ResetChildren resets all changes to the "children" edge.
func (m *NoteMutation) ResetChildren() {
	m.children = nil
	m.clearedchildren = false
	m.removedchildren = nil
}

// Where appends a list predicates to the NoteMutation builder.
func (m *NoteMutation) Where(ps ...predicate.Note) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *NoteMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Note).
func (m *NoteMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *NoteMutation) Fields() []string {
	fields := make([]string, 0, 1)
	if m.text != nil {
		fields = append(fields, note.FieldText)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *NoteMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case note.FieldText:
		return m.Text()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *NoteMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case note.FieldText:
		return m.OldText(ctx)
	}
	return nil, fmt.Errorf("unknown Note field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *NoteMutation) SetField(name string, value ent.Value) error {
	switch name {
	case note.FieldText:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetText(v)
		return nil
	}
	return fmt.Errorf("unknown Note field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *NoteMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *NoteMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *NoteMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Note numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *NoteMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(note.FieldText) {
		fields = append(fields, note.FieldText)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *NoteMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *NoteMutation) ClearField(name string) error {
	switch name {
	case note.FieldText:
		m.ClearText()
		return nil
	}
	return fmt.Errorf("unknown Note nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *NoteMutation) ResetField(name string) error {
	switch name {
	case note.FieldText:
		m.ResetText()
		return nil
	}
	return fmt.Errorf("unknown Note field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *NoteMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.parent != nil {
		edges = append(edges, note.EdgeParent)
	}
	if m.children != nil {
		edges = append(edges, note.EdgeChildren)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *NoteMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case note.EdgeParent:
		if id := m.parent; id != nil {
			return []ent.Value{*id}
		}
	case note.EdgeChildren:
		ids := make([]ent.Value, 0, len(m.children))
		for id := range m.children {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *NoteMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	if m.removedchildren != nil {
		edges = append(edges, note.EdgeChildren)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *NoteMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case note.EdgeChildren:
		ids := make([]ent.Value, 0, len(m.removedchildren))
		for id := range m.removedchildren {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *NoteMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.clearedparent {
		edges = append(edges, note.EdgeParent)
	}
	if m.clearedchildren {
		edges = append(edges, note.EdgeChildren)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *NoteMutation) EdgeCleared(name string) bool {
	switch name {
	case note.EdgeParent:
		return m.clearedparent
	case note.EdgeChildren:
		return m.clearedchildren
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *NoteMutation) ClearEdge(name string) error {
	switch name {
	case note.EdgeParent:
		m.ClearParent()
		return nil
	}
	return fmt.Errorf("unknown Note unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *NoteMutation) ResetEdge(name string) error {
	switch name {
	case note.EdgeParent:
		m.ResetParent()
		return nil
	case note.EdgeChildren:
		m.ResetChildren()
		return nil
	}
	return fmt.Errorf("unknown Note edge %s", name)
}

// PetMutation represents an operation that mutates the Pet nodes in the graph.
type PetMutation struct {
	config
	op                 Op
	typ                string
	id                 *string
	clearedFields      map[string]struct{}
	owner              *int
	clearedowner       bool
	cars               map[int]struct{}
	removedcars        map[int]struct{}
	clearedcars        bool
	friends            map[string]struct{}
	removedfriends     map[string]struct{}
	clearedfriends     bool
	best_friend        *string
	clearedbest_friend bool
	done               bool
	oldValue           func(context.Context) (*Pet, error)
	predicates         []predicate.Pet
}

var _ ent.Mutation = (*PetMutation)(nil)

// petOption allows management of the mutation configuration using functional options.
type petOption func(*PetMutation)

// newPetMutation creates new mutation for the Pet entity.
func newPetMutation(c config, op Op, opts ...petOption) *PetMutation {
	m := &PetMutation{
		config:        c,
		op:            op,
		typ:           TypePet,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withPetID sets the ID field of the mutation.
func withPetID(id string) petOption {
	return func(m *PetMutation) {
		var (
			err   error
			once  sync.Once
			value *Pet
		)
		m.oldValue = func(ctx context.Context) (*Pet, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Pet.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withPet sets the old Pet of the mutation.
func withPet(node *Pet) petOption {
	return func(m *PetMutation) {
		m.oldValue = func(context.Context) (*Pet, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m PetMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m PetMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Pet entities.
func (m *PetMutation) SetID(id string) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *PetMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetOwnerID sets the "owner" edge to the User entity by id.
func (m *PetMutation) SetOwnerID(id int) {
	m.owner = &id
}

// ClearOwner clears the "owner" edge to the User entity.
func (m *PetMutation) ClearOwner() {
	m.clearedowner = true
}

// OwnerCleared reports if the "owner" edge to the User entity was cleared.
func (m *PetMutation) OwnerCleared() bool {
	return m.clearedowner
}

// OwnerID returns the "owner" edge ID in the mutation.
func (m *PetMutation) OwnerID() (id int, exists bool) {
	if m.owner != nil {
		return *m.owner, true
	}
	return
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *PetMutation) OwnerIDs() (ids []int) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *PetMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// AddCarIDs adds the "cars" edge to the Car entity by ids.
func (m *PetMutation) AddCarIDs(ids ...int) {
	if m.cars == nil {
		m.cars = make(map[int]struct{})
	}
	for i := range ids {
		m.cars[ids[i]] = struct{}{}
	}
}

// ClearCars clears the "cars" edge to the Car entity.
func (m *PetMutation) ClearCars() {
	m.clearedcars = true
}

// CarsCleared reports if the "cars" edge to the Car entity was cleared.
func (m *PetMutation) CarsCleared() bool {
	return m.clearedcars
}

// RemoveCarIDs removes the "cars" edge to the Car entity by IDs.
func (m *PetMutation) RemoveCarIDs(ids ...int) {
	if m.removedcars == nil {
		m.removedcars = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.cars, ids[i])
		m.removedcars[ids[i]] = struct{}{}
	}
}

// RemovedCars returns the removed IDs of the "cars" edge to the Car entity.
func (m *PetMutation) RemovedCarsIDs() (ids []int) {
	for id := range m.removedcars {
		ids = append(ids, id)
	}
	return
}

// CarsIDs returns the "cars" edge IDs in the mutation.
func (m *PetMutation) CarsIDs() (ids []int) {
	for id := range m.cars {
		ids = append(ids, id)
	}
	return
}

// ResetCars resets all changes to the "cars" edge.
func (m *PetMutation) ResetCars() {
	m.cars = nil
	m.clearedcars = false
	m.removedcars = nil
}

// AddFriendIDs adds the "friends" edge to the Pet entity by ids.
func (m *PetMutation) AddFriendIDs(ids ...string) {
	if m.friends == nil {
		m.friends = make(map[string]struct{})
	}
	for i := range ids {
		m.friends[ids[i]] = struct{}{}
	}
}

// ClearFriends clears the "friends" edge to the Pet entity.
func (m *PetMutation) ClearFriends() {
	m.clearedfriends = true
}

// FriendsCleared reports if the "friends" edge to the Pet entity was cleared.
func (m *PetMutation) FriendsCleared() bool {
	return m.clearedfriends
}

// RemoveFriendIDs removes the "friends" edge to the Pet entity by IDs.
func (m *PetMutation) RemoveFriendIDs(ids ...string) {
	if m.removedfriends == nil {
		m.removedfriends = make(map[string]struct{})
	}
	for i := range ids {
		delete(m.friends, ids[i])
		m.removedfriends[ids[i]] = struct{}{}
	}
}

// RemovedFriends returns the removed IDs of the "friends" edge to the Pet entity.
func (m *PetMutation) RemovedFriendsIDs() (ids []string) {
	for id := range m.removedfriends {
		ids = append(ids, id)
	}
	return
}

// FriendsIDs returns the "friends" edge IDs in the mutation.
func (m *PetMutation) FriendsIDs() (ids []string) {
	for id := range m.friends {
		ids = append(ids, id)
	}
	return
}

// ResetFriends resets all changes to the "friends" edge.
func (m *PetMutation) ResetFriends() {
	m.friends = nil
	m.clearedfriends = false
	m.removedfriends = nil
}

// SetBestFriendID sets the "best_friend" edge to the Pet entity by id.
func (m *PetMutation) SetBestFriendID(id string) {
	m.best_friend = &id
}

// ClearBestFriend clears the "best_friend" edge to the Pet entity.
func (m *PetMutation) ClearBestFriend() {
	m.clearedbest_friend = true
}

// BestFriendCleared reports if the "best_friend" edge to the Pet entity was cleared.
func (m *PetMutation) BestFriendCleared() bool {
	return m.clearedbest_friend
}

// BestFriendID returns the "best_friend" edge ID in the mutation.
func (m *PetMutation) BestFriendID() (id string, exists bool) {
	if m.best_friend != nil {
		return *m.best_friend, true
	}
	return
}

// BestFriendIDs returns the "best_friend" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// BestFriendID instead. It exists only for internal usage by the builders.
func (m *PetMutation) BestFriendIDs() (ids []string) {
	if id := m.best_friend; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetBestFriend resets all changes to the "best_friend" edge.
func (m *PetMutation) ResetBestFriend() {
	m.best_friend = nil
	m.clearedbest_friend = false
}

// Where appends a list predicates to the PetMutation builder.
func (m *PetMutation) Where(ps ...predicate.Pet) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *PetMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Pet).
func (m *PetMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *PetMutation) Fields() []string {
	fields := make([]string, 0, 0)
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *PetMutation) Field(name string) (ent.Value, bool) {
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *PetMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	return nil, fmt.Errorf("unknown Pet field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *PetMutation) SetField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Pet field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *PetMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *PetMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *PetMutation) AddField(name string, value ent.Value) error {
	return fmt.Errorf("unknown Pet numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *PetMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *PetMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *PetMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Pet nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *PetMutation) ResetField(name string) error {
	return fmt.Errorf("unknown Pet field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *PetMutation) AddedEdges() []string {
	edges := make([]string, 0, 4)
	if m.owner != nil {
		edges = append(edges, pet.EdgeOwner)
	}
	if m.cars != nil {
		edges = append(edges, pet.EdgeCars)
	}
	if m.friends != nil {
		edges = append(edges, pet.EdgeFriends)
	}
	if m.best_friend != nil {
		edges = append(edges, pet.EdgeBestFriend)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *PetMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case pet.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	case pet.EdgeCars:
		ids := make([]ent.Value, 0, len(m.cars))
		for id := range m.cars {
			ids = append(ids, id)
		}
		return ids
	case pet.EdgeFriends:
		ids := make([]ent.Value, 0, len(m.friends))
		for id := range m.friends {
			ids = append(ids, id)
		}
		return ids
	case pet.EdgeBestFriend:
		if id := m.best_friend; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *PetMutation) RemovedEdges() []string {
	edges := make([]string, 0, 4)
	if m.removedcars != nil {
		edges = append(edges, pet.EdgeCars)
	}
	if m.removedfriends != nil {
		edges = append(edges, pet.EdgeFriends)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *PetMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case pet.EdgeCars:
		ids := make([]ent.Value, 0, len(m.removedcars))
		for id := range m.removedcars {
			ids = append(ids, id)
		}
		return ids
	case pet.EdgeFriends:
		ids := make([]ent.Value, 0, len(m.removedfriends))
		for id := range m.removedfriends {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *PetMutation) ClearedEdges() []string {
	edges := make([]string, 0, 4)
	if m.clearedowner {
		edges = append(edges, pet.EdgeOwner)
	}
	if m.clearedcars {
		edges = append(edges, pet.EdgeCars)
	}
	if m.clearedfriends {
		edges = append(edges, pet.EdgeFriends)
	}
	if m.clearedbest_friend {
		edges = append(edges, pet.EdgeBestFriend)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *PetMutation) EdgeCleared(name string) bool {
	switch name {
	case pet.EdgeOwner:
		return m.clearedowner
	case pet.EdgeCars:
		return m.clearedcars
	case pet.EdgeFriends:
		return m.clearedfriends
	case pet.EdgeBestFriend:
		return m.clearedbest_friend
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *PetMutation) ClearEdge(name string) error {
	switch name {
	case pet.EdgeOwner:
		m.ClearOwner()
		return nil
	case pet.EdgeBestFriend:
		m.ClearBestFriend()
		return nil
	}
	return fmt.Errorf("unknown Pet unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *PetMutation) ResetEdge(name string) error {
	switch name {
	case pet.EdgeOwner:
		m.ResetOwner()
		return nil
	case pet.EdgeCars:
		m.ResetCars()
		return nil
	case pet.EdgeFriends:
		m.ResetFriends()
		return nil
	case pet.EdgeBestFriend:
		m.ResetBestFriend()
		return nil
	}
	return fmt.Errorf("unknown Pet edge %s", name)
}

// UserMutation represents an operation that mutates the User nodes in the graph.
type UserMutation struct {
	config
	op              Op
	typ             string
	id              *int
	clearedFields   map[string]struct{}
	groups          map[int]struct{}
	removedgroups   map[int]struct{}
	clearedgroups   bool
	parent          *int
	clearedparent   bool
	children        map[int]struct{}
	removedchildren map[int]struct{}
	clearedchildren bool
	pets            map[string]struct{}
	removedpets     map[string]struct{}
	clearedpets     bool
	done            bool
	oldValue        func(context.Context) (*User, error)
	predicates      []predicate.User
}

var _ ent.Mutation = (*UserMutation)(nil)

// userOption allows management of the mutation configuration using functional options.
type userOption func(*UserMutation)

// newUserMutation creates new mutation for the User entity.
func newUserMutation(c config, op Op, opts ...userOption) *UserMutation {
	m := &UserMutation{
		config:        c,
		op:            op,
		typ:           TypeUser,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withUserID sets the ID field of the mutation.
func withUserID(id int) userOption {
	return func(m *UserMutation) {
		var (
			err   error
			once  sync.Once
			value *User
		)
		m.oldValue = func(ctx context.Context) (*User, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().User.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withUser sets the old User of the mutation.
func withUser(node *User) userOption {
	return func(m *UserMutation) {
		m.oldValue = func(context.Context) (*User, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m UserMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m UserMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of User entities.
func (m *UserMutation) SetID(id int) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *UserMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// AddGroupIDs adds the "groups" edge to the Group entity by ids.
func (m *UserMutation) AddGroupIDs(ids ...int) {
	if m.groups == nil {
		m.groups = make(map[int]struct{})
	}
	for i := range ids {
		m.groups[ids[i]] = struct{}{}
	}
}

// ClearGroups clears the "groups" edge to the Group entity.
func (m *UserMutation) ClearGroups() {
	m.clearedgroups = true
}

// GroupsCleared reports if the "groups" edge to the Group entity was cleared.
func (m *UserMutation) GroupsCleared() bool {
	return m.clearedgroups
}

// RemoveGroupIDs removes the "groups" edge to the Group entity by IDs.
func (m *UserMutation) RemoveGroupIDs(ids ...int) {
	if m.removedgroups == nil {
		m.removedgroups = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.groups, ids[i])
		m.removedgroups[ids[i]] = struct{}{}
	}
}

// RemovedGroups returns the removed IDs of the "groups" edge to the Group entity.
func (m *UserMutation) RemovedGroupsIDs() (ids []int) {
	for id := range m.removedgroups {
		ids = append(ids, id)
	}
	return
}

// GroupsIDs returns the "groups" edge IDs in the mutation.
func (m *UserMutation) GroupsIDs() (ids []int) {
	for id := range m.groups {
		ids = append(ids, id)
	}
	return
}

// ResetGroups resets all changes to the "groups" edge.
func (m *UserMutation) ResetGroups() {
	m.groups = nil
	m.clearedgroups = false
	m.removedgroups = nil
}

// SetParentID sets the "parent" edge to the User entity by id.
func (m *UserMutation) SetParentID(id int) {
	m.parent = &id
}

// ClearParent clears the "parent" edge to the User entity.
func (m *UserMutation) ClearParent() {
	m.clearedparent = true
}

// ParentCleared reports if the "parent" edge to the User entity was cleared.
func (m *UserMutation) ParentCleared() bool {
	return m.clearedparent
}

// ParentID returns the "parent" edge ID in the mutation.
func (m *UserMutation) ParentID() (id int, exists bool) {
	if m.parent != nil {
		return *m.parent, true
	}
	return
}

// ParentIDs returns the "parent" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// ParentID instead. It exists only for internal usage by the builders.
func (m *UserMutation) ParentIDs() (ids []int) {
	if id := m.parent; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetParent resets all changes to the "parent" edge.
func (m *UserMutation) ResetParent() {
	m.parent = nil
	m.clearedparent = false
}

// AddChildIDs adds the "children" edge to the User entity by ids.
func (m *UserMutation) AddChildIDs(ids ...int) {
	if m.children == nil {
		m.children = make(map[int]struct{})
	}
	for i := range ids {
		m.children[ids[i]] = struct{}{}
	}
}

// ClearChildren clears the "children" edge to the User entity.
func (m *UserMutation) ClearChildren() {
	m.clearedchildren = true
}

// ChildrenCleared reports if the "children" edge to the User entity was cleared.
func (m *UserMutation) ChildrenCleared() bool {
	return m.clearedchildren
}

// RemoveChildIDs removes the "children" edge to the User entity by IDs.
func (m *UserMutation) RemoveChildIDs(ids ...int) {
	if m.removedchildren == nil {
		m.removedchildren = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.children, ids[i])
		m.removedchildren[ids[i]] = struct{}{}
	}
}

// RemovedChildren returns the removed IDs of the "children" edge to the User entity.
func (m *UserMutation) RemovedChildrenIDs() (ids []int) {
	for id := range m.removedchildren {
		ids = append(ids, id)
	}
	return
}

// ChildrenIDs returns the "children" edge IDs in the mutation.
func (m *UserMutation) ChildrenIDs() (ids []int) {
	for id := range m.children {
		ids = append(ids, id)
	}
	return
}

// ResetChildren resets all changes to the "children" edge.
func (m *UserMutation) ResetChildren() {
	m.children = nil
	m.clearedchildren = false
	m.removedchildren = nil
}

// AddPetIDs adds the "pets" edge to the Pet entity by ids.
func (m *UserMutation) AddPetIDs(ids ...string) {
	if m.pets == nil {
		m.pets = make(map[string]struct{})
	}
	for i := range ids {
		m.pets[ids[i]] = struct{}{}
	}
}

// ClearPets clears the "pets" edge to the Pet entity.
func (m *UserMutation) ClearPets() {
	m.clearedpets = true
}

// PetsCleared reports if the "pets" edge to the Pet entity was cleared.
func (m *UserMutation) PetsCleared() bool {
	return m.clearedpets
}

// RemovePetIDs removes the "pets" edge to the Pet entity by IDs.
func (m *UserMutation) RemovePetIDs(ids ...string) {
	if m.removedpets == nil {
		m.removedpets = make(map[string]struct{})
	}
	for i := range ids {
		delete(m.pets, ids[i])
		m.removedpets[ids[i]] = struct{}{}
	}
}

// RemovedPets returns the removed IDs of the "pets" edge to the Pet entity.
func (m *UserMutation) RemovedPetsIDs() (ids []string) {
	for id := range m.removedpets {
		ids = append(ids, id)
	}
	return
}

// PetsIDs returns the "pets" edge IDs in the mutation.
func (m *UserMutation) PetsIDs() (ids []string) {
	for id := range m.pets {
		ids = append(ids, id)
	}
	return
}

// ResetPets resets all changes to the "pets" edge.
func (m *UserMutation) ResetPets() {
	m.pets = nil
	m.clearedpets = false
	m.removedpets = nil
}

// Where appends a list predicates to the UserMutation builder.
func (m *UserMutation) Where(ps ...predicate.User) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *UserMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (User).
func (m *UserMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *UserMutation) Fields() []string {
	fields := make([]string, 0, 0)
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *UserMutation) Field(name string) (ent.Value, bool) {
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *UserMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	return nil, fmt.Errorf("unknown User field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserMutation) SetField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown User field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *UserMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *UserMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserMutation) AddField(name string, value ent.Value) error {
	return fmt.Errorf("unknown User numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *UserMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *UserMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *UserMutation) ClearField(name string) error {
	return fmt.Errorf("unknown User nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *UserMutation) ResetField(name string) error {
	return fmt.Errorf("unknown User field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *UserMutation) AddedEdges() []string {
	edges := make([]string, 0, 4)
	if m.groups != nil {
		edges = append(edges, user.EdgeGroups)
	}
	if m.parent != nil {
		edges = append(edges, user.EdgeParent)
	}
	if m.children != nil {
		edges = append(edges, user.EdgeChildren)
	}
	if m.pets != nil {
		edges = append(edges, user.EdgePets)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *UserMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case user.EdgeGroups:
		ids := make([]ent.Value, 0, len(m.groups))
		for id := range m.groups {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeParent:
		if id := m.parent; id != nil {
			return []ent.Value{*id}
		}
	case user.EdgeChildren:
		ids := make([]ent.Value, 0, len(m.children))
		for id := range m.children {
			ids = append(ids, id)
		}
		return ids
	case user.EdgePets:
		ids := make([]ent.Value, 0, len(m.pets))
		for id := range m.pets {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *UserMutation) RemovedEdges() []string {
	edges := make([]string, 0, 4)
	if m.removedgroups != nil {
		edges = append(edges, user.EdgeGroups)
	}
	if m.removedchildren != nil {
		edges = append(edges, user.EdgeChildren)
	}
	if m.removedpets != nil {
		edges = append(edges, user.EdgePets)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *UserMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case user.EdgeGroups:
		ids := make([]ent.Value, 0, len(m.removedgroups))
		for id := range m.removedgroups {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeChildren:
		ids := make([]ent.Value, 0, len(m.removedchildren))
		for id := range m.removedchildren {
			ids = append(ids, id)
		}
		return ids
	case user.EdgePets:
		ids := make([]ent.Value, 0, len(m.removedpets))
		for id := range m.removedpets {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *UserMutation) ClearedEdges() []string {
	edges := make([]string, 0, 4)
	if m.clearedgroups {
		edges = append(edges, user.EdgeGroups)
	}
	if m.clearedparent {
		edges = append(edges, user.EdgeParent)
	}
	if m.clearedchildren {
		edges = append(edges, user.EdgeChildren)
	}
	if m.clearedpets {
		edges = append(edges, user.EdgePets)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *UserMutation) EdgeCleared(name string) bool {
	switch name {
	case user.EdgeGroups:
		return m.clearedgroups
	case user.EdgeParent:
		return m.clearedparent
	case user.EdgeChildren:
		return m.clearedchildren
	case user.EdgePets:
		return m.clearedpets
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *UserMutation) ClearEdge(name string) error {
	switch name {
	case user.EdgeParent:
		m.ClearParent()
		return nil
	}
	return fmt.Errorf("unknown User unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *UserMutation) ResetEdge(name string) error {
	switch name {
	case user.EdgeGroups:
		m.ResetGroups()
		return nil
	case user.EdgeParent:
		m.ResetParent()
		return nil
	case user.EdgeChildren:
		m.ResetChildren()
		return nil
	case user.EdgePets:
		m.ResetPets()
		return nil
	}
	return fmt.Errorf("unknown User edge %s", name)
}
