// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by entc, DO NOT EDIT.

package ent

import (
	"context"
	"encoding/json"
	"fmt"
	"sync"
	"time"

	"entgo.io/ent/entc/integration/edgefield/ent/car"
	"entgo.io/ent/entc/integration/edgefield/ent/card"
	"entgo.io/ent/entc/integration/edgefield/ent/info"
	"entgo.io/ent/entc/integration/edgefield/ent/metadata"
	"entgo.io/ent/entc/integration/edgefield/ent/pet"
	"entgo.io/ent/entc/integration/edgefield/ent/post"
	"entgo.io/ent/entc/integration/edgefield/ent/predicate"
	"entgo.io/ent/entc/integration/edgefield/ent/rental"
	"entgo.io/ent/entc/integration/edgefield/ent/user"
	"github.com/google/uuid"

	"entgo.io/ent"
)

const (
	// Operation types.
	OpCreate    = ent.OpCreate
	OpDelete    = ent.OpDelete
	OpDeleteOne = ent.OpDeleteOne
	OpUpdate    = ent.OpUpdate
	OpUpdateOne = ent.OpUpdateOne

	// Node types.
	TypeCar      = "Car"
	TypeCard     = "Card"
	TypeInfo     = "Info"
	TypeMetadata = "Metadata"
	TypePet      = "Pet"
	TypePost     = "Post"
	TypeRental   = "Rental"
	TypeUser     = "User"
)

// CarMutation represents an operation that mutates the Car nodes in the graph.
type CarMutation struct {
	config
	op             Op
	typ            string
	id             *uuid.UUID
	number         *string
	clearedFields  map[string]struct{}
	rentals        map[int]struct{}
	removedrentals map[int]struct{}
	clearedrentals bool
	done           bool
	oldValue       func(context.Context) (*Car, error)
	predicates     []predicate.Car
}

var _ ent.Mutation = (*CarMutation)(nil)

// carOption allows management of the mutation configuration using functional options.
type carOption func(*CarMutation)

// newCarMutation creates new mutation for the Car entity.
func newCarMutation(c config, op Op, opts ...carOption) *CarMutation {
	m := &CarMutation{
		config:        c,
		op:            op,
		typ:           TypeCar,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withCarID sets the ID field of the mutation.
func withCarID(id uuid.UUID) carOption {
	return func(m *CarMutation) {
		var (
			err   error
			once  sync.Once
			value *Car
		)
		m.oldValue = func(ctx context.Context) (*Car, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Car.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withCar sets the old Car of the mutation.
func withCar(node *Car) carOption {
	return func(m *CarMutation) {
		m.oldValue = func(context.Context) (*Car, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m CarMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m CarMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Car entities.
func (m *CarMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *CarMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetNumber sets the "number" field.
func (m *CarMutation) SetNumber(s string) {
	m.number = &s
}

// Number returns the value of the "number" field in the mutation.
func (m *CarMutation) Number() (r string, exists bool) {
	v := m.number
	if v == nil {
		return
	}
	return *v, true
}

// OldNumber returns the old "number" field's value of the Car entity.
// If the Car object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CarMutation) OldNumber(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNumber is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNumber requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNumber: %w", err)
	}
	return oldValue.Number, nil
}

// ClearNumber clears the value of the "number" field.
func (m *CarMutation) ClearNumber() {
	m.number = nil
	m.clearedFields[car.FieldNumber] = struct{}{}
}

// NumberCleared returns if the "number" field was cleared in this mutation.
func (m *CarMutation) NumberCleared() bool {
	_, ok := m.clearedFields[car.FieldNumber]
	return ok
}

// ResetNumber resets all changes to the "number" field.
func (m *CarMutation) ResetNumber() {
	m.number = nil
	delete(m.clearedFields, car.FieldNumber)
}

// AddRentalIDs adds the "rentals" edge to the Rental entity by ids.
func (m *CarMutation) AddRentalIDs(ids ...int) {
	if m.rentals == nil {
		m.rentals = make(map[int]struct{})
	}
	for i := range ids {
		m.rentals[ids[i]] = struct{}{}
	}
}

// ClearRentals clears the "rentals" edge to the Rental entity.
func (m *CarMutation) ClearRentals() {
	m.clearedrentals = true
}

// RentalsCleared reports if the "rentals" edge to the Rental entity was cleared.
func (m *CarMutation) RentalsCleared() bool {
	return m.clearedrentals
}

// RemoveRentalIDs removes the "rentals" edge to the Rental entity by IDs.
func (m *CarMutation) RemoveRentalIDs(ids ...int) {
	if m.removedrentals == nil {
		m.removedrentals = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.rentals, ids[i])
		m.removedrentals[ids[i]] = struct{}{}
	}
}

// RemovedRentals returns the removed IDs of the "rentals" edge to the Rental entity.
func (m *CarMutation) RemovedRentalsIDs() (ids []int) {
	for id := range m.removedrentals {
		ids = append(ids, id)
	}
	return
}

// RentalsIDs returns the "rentals" edge IDs in the mutation.
func (m *CarMutation) RentalsIDs() (ids []int) {
	for id := range m.rentals {
		ids = append(ids, id)
	}
	return
}

// ResetRentals resets all changes to the "rentals" edge.
func (m *CarMutation) ResetRentals() {
	m.rentals = nil
	m.clearedrentals = false
	m.removedrentals = nil
}

// Where appends a list predicates to the CarMutation builder.
func (m *CarMutation) Where(ps ...predicate.Car) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *CarMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Car).
func (m *CarMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *CarMutation) Fields() []string {
	fields := make([]string, 0, 1)
	if m.number != nil {
		fields = append(fields, car.FieldNumber)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *CarMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case car.FieldNumber:
		return m.Number()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *CarMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case car.FieldNumber:
		return m.OldNumber(ctx)
	}
	return nil, fmt.Errorf("unknown Car field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *CarMutation) SetField(name string, value ent.Value) error {
	switch name {
	case car.FieldNumber:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNumber(v)
		return nil
	}
	return fmt.Errorf("unknown Car field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *CarMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *CarMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *CarMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Car numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *CarMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(car.FieldNumber) {
		fields = append(fields, car.FieldNumber)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *CarMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *CarMutation) ClearField(name string) error {
	switch name {
	case car.FieldNumber:
		m.ClearNumber()
		return nil
	}
	return fmt.Errorf("unknown Car nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *CarMutation) ResetField(name string) error {
	switch name {
	case car.FieldNumber:
		m.ResetNumber()
		return nil
	}
	return fmt.Errorf("unknown Car field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *CarMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.rentals != nil {
		edges = append(edges, car.EdgeRentals)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *CarMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case car.EdgeRentals:
		ids := make([]ent.Value, 0, len(m.rentals))
		for id := range m.rentals {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *CarMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	if m.removedrentals != nil {
		edges = append(edges, car.EdgeRentals)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *CarMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case car.EdgeRentals:
		ids := make([]ent.Value, 0, len(m.removedrentals))
		for id := range m.removedrentals {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *CarMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedrentals {
		edges = append(edges, car.EdgeRentals)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *CarMutation) EdgeCleared(name string) bool {
	switch name {
	case car.EdgeRentals:
		return m.clearedrentals
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *CarMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown Car unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *CarMutation) ResetEdge(name string) error {
	switch name {
	case car.EdgeRentals:
		m.ResetRentals()
		return nil
	}
	return fmt.Errorf("unknown Car edge %s", name)
}

// CardMutation represents an operation that mutates the Card nodes in the graph.
type CardMutation struct {
	config
	op            Op
	typ           string
	id            *int
	number        *string
	clearedFields map[string]struct{}
	owner         *int
	clearedowner  bool
	done          bool
	oldValue      func(context.Context) (*Card, error)
	predicates    []predicate.Card
}

var _ ent.Mutation = (*CardMutation)(nil)

// cardOption allows management of the mutation configuration using functional options.
type cardOption func(*CardMutation)

// newCardMutation creates new mutation for the Card entity.
func newCardMutation(c config, op Op, opts ...cardOption) *CardMutation {
	m := &CardMutation{
		config:        c,
		op:            op,
		typ:           TypeCard,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withCardID sets the ID field of the mutation.
func withCardID(id int) cardOption {
	return func(m *CardMutation) {
		var (
			err   error
			once  sync.Once
			value *Card
		)
		m.oldValue = func(ctx context.Context) (*Card, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Card.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withCard sets the old Card of the mutation.
func withCard(node *Card) cardOption {
	return func(m *CardMutation) {
		m.oldValue = func(context.Context) (*Card, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m CardMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m CardMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *CardMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetNumber sets the "number" field.
func (m *CardMutation) SetNumber(s string) {
	m.number = &s
}

// Number returns the value of the "number" field in the mutation.
func (m *CardMutation) Number() (r string, exists bool) {
	v := m.number
	if v == nil {
		return
	}
	return *v, true
}

// OldNumber returns the old "number" field's value of the Card entity.
// If the Card object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CardMutation) OldNumber(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNumber is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNumber requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNumber: %w", err)
	}
	return oldValue.Number, nil
}

// ClearNumber clears the value of the "number" field.
func (m *CardMutation) ClearNumber() {
	m.number = nil
	m.clearedFields[card.FieldNumber] = struct{}{}
}

// NumberCleared returns if the "number" field was cleared in this mutation.
func (m *CardMutation) NumberCleared() bool {
	_, ok := m.clearedFields[card.FieldNumber]
	return ok
}

// ResetNumber resets all changes to the "number" field.
func (m *CardMutation) ResetNumber() {
	m.number = nil
	delete(m.clearedFields, card.FieldNumber)
}

// SetOwnerID sets the "owner_id" field.
func (m *CardMutation) SetOwnerID(i int) {
	m.owner = &i
}

// OwnerID returns the value of the "owner_id" field in the mutation.
func (m *CardMutation) OwnerID() (r int, exists bool) {
	v := m.owner
	if v == nil {
		return
	}
	return *v, true
}

// OldOwnerID returns the old "owner_id" field's value of the Card entity.
// If the Card object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CardMutation) OldOwnerID(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldOwnerID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldOwnerID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOwnerID: %w", err)
	}
	return oldValue.OwnerID, nil
}

// ClearOwnerID clears the value of the "owner_id" field.
func (m *CardMutation) ClearOwnerID() {
	m.owner = nil
	m.clearedFields[card.FieldOwnerID] = struct{}{}
}

// OwnerIDCleared returns if the "owner_id" field was cleared in this mutation.
func (m *CardMutation) OwnerIDCleared() bool {
	_, ok := m.clearedFields[card.FieldOwnerID]
	return ok
}

// ResetOwnerID resets all changes to the "owner_id" field.
func (m *CardMutation) ResetOwnerID() {
	m.owner = nil
	delete(m.clearedFields, card.FieldOwnerID)
}

// ClearOwner clears the "owner" edge to the User entity.
func (m *CardMutation) ClearOwner() {
	m.clearedowner = true
}

// OwnerCleared reports if the "owner" edge to the User entity was cleared.
func (m *CardMutation) OwnerCleared() bool {
	return m.OwnerIDCleared() || m.clearedowner
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *CardMutation) OwnerIDs() (ids []int) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *CardMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// Where appends a list predicates to the CardMutation builder.
func (m *CardMutation) Where(ps ...predicate.Card) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *CardMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Card).
func (m *CardMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *CardMutation) Fields() []string {
	fields := make([]string, 0, 2)
	if m.number != nil {
		fields = append(fields, card.FieldNumber)
	}
	if m.owner != nil {
		fields = append(fields, card.FieldOwnerID)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *CardMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case card.FieldNumber:
		return m.Number()
	case card.FieldOwnerID:
		return m.OwnerID()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *CardMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case card.FieldNumber:
		return m.OldNumber(ctx)
	case card.FieldOwnerID:
		return m.OldOwnerID(ctx)
	}
	return nil, fmt.Errorf("unknown Card field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *CardMutation) SetField(name string, value ent.Value) error {
	switch name {
	case card.FieldNumber:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNumber(v)
		return nil
	case card.FieldOwnerID:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOwnerID(v)
		return nil
	}
	return fmt.Errorf("unknown Card field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *CardMutation) AddedFields() []string {
	var fields []string
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *CardMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *CardMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Card numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *CardMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(card.FieldNumber) {
		fields = append(fields, card.FieldNumber)
	}
	if m.FieldCleared(card.FieldOwnerID) {
		fields = append(fields, card.FieldOwnerID)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *CardMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *CardMutation) ClearField(name string) error {
	switch name {
	case card.FieldNumber:
		m.ClearNumber()
		return nil
	case card.FieldOwnerID:
		m.ClearOwnerID()
		return nil
	}
	return fmt.Errorf("unknown Card nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *CardMutation) ResetField(name string) error {
	switch name {
	case card.FieldNumber:
		m.ResetNumber()
		return nil
	case card.FieldOwnerID:
		m.ResetOwnerID()
		return nil
	}
	return fmt.Errorf("unknown Card field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *CardMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.owner != nil {
		edges = append(edges, card.EdgeOwner)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *CardMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case card.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *CardMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *CardMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *CardMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedowner {
		edges = append(edges, card.EdgeOwner)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *CardMutation) EdgeCleared(name string) bool {
	switch name {
	case card.EdgeOwner:
		return m.clearedowner
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *CardMutation) ClearEdge(name string) error {
	switch name {
	case card.EdgeOwner:
		m.ClearOwner()
		return nil
	}
	return fmt.Errorf("unknown Card unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *CardMutation) ResetEdge(name string) error {
	switch name {
	case card.EdgeOwner:
		m.ResetOwner()
		return nil
	}
	return fmt.Errorf("unknown Card edge %s", name)
}

// InfoMutation represents an operation that mutates the Info nodes in the graph.
type InfoMutation struct {
	config
	op            Op
	typ           string
	id            *int
	content       *json.RawMessage
	clearedFields map[string]struct{}
	user          *int
	cleareduser   bool
	done          bool
	oldValue      func(context.Context) (*Info, error)
	predicates    []predicate.Info
}

var _ ent.Mutation = (*InfoMutation)(nil)

// infoOption allows management of the mutation configuration using functional options.
type infoOption func(*InfoMutation)

// newInfoMutation creates new mutation for the Info entity.
func newInfoMutation(c config, op Op, opts ...infoOption) *InfoMutation {
	m := &InfoMutation{
		config:        c,
		op:            op,
		typ:           TypeInfo,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withInfoID sets the ID field of the mutation.
func withInfoID(id int) infoOption {
	return func(m *InfoMutation) {
		var (
			err   error
			once  sync.Once
			value *Info
		)
		m.oldValue = func(ctx context.Context) (*Info, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Info.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withInfo sets the old Info of the mutation.
func withInfo(node *Info) infoOption {
	return func(m *InfoMutation) {
		m.oldValue = func(context.Context) (*Info, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m InfoMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m InfoMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Info entities.
func (m *InfoMutation) SetID(id int) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *InfoMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetContent sets the "content" field.
func (m *InfoMutation) SetContent(jm json.RawMessage) {
	m.content = &jm
}

// Content returns the value of the "content" field in the mutation.
func (m *InfoMutation) Content() (r json.RawMessage, exists bool) {
	v := m.content
	if v == nil {
		return
	}
	return *v, true
}

// OldContent returns the old "content" field's value of the Info entity.
// If the Info object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *InfoMutation) OldContent(ctx context.Context) (v json.RawMessage, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldContent is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldContent requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldContent: %w", err)
	}
	return oldValue.Content, nil
}

// ResetContent resets all changes to the "content" field.
func (m *InfoMutation) ResetContent() {
	m.content = nil
}

// SetUserID sets the "user" edge to the User entity by id.
func (m *InfoMutation) SetUserID(id int) {
	m.user = &id
}

// ClearUser clears the "user" edge to the User entity.
func (m *InfoMutation) ClearUser() {
	m.cleareduser = true
}

// UserCleared reports if the "user" edge to the User entity was cleared.
func (m *InfoMutation) UserCleared() bool {
	return m.cleareduser
}

// UserID returns the "user" edge ID in the mutation.
func (m *InfoMutation) UserID() (id int, exists bool) {
	if m.user != nil {
		return *m.user, true
	}
	return
}

// UserIDs returns the "user" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// UserID instead. It exists only for internal usage by the builders.
func (m *InfoMutation) UserIDs() (ids []int) {
	if id := m.user; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetUser resets all changes to the "user" edge.
func (m *InfoMutation) ResetUser() {
	m.user = nil
	m.cleareduser = false
}

// Where appends a list predicates to the InfoMutation builder.
func (m *InfoMutation) Where(ps ...predicate.Info) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *InfoMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Info).
func (m *InfoMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *InfoMutation) Fields() []string {
	fields := make([]string, 0, 1)
	if m.content != nil {
		fields = append(fields, info.FieldContent)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *InfoMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case info.FieldContent:
		return m.Content()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *InfoMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case info.FieldContent:
		return m.OldContent(ctx)
	}
	return nil, fmt.Errorf("unknown Info field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *InfoMutation) SetField(name string, value ent.Value) error {
	switch name {
	case info.FieldContent:
		v, ok := value.(json.RawMessage)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetContent(v)
		return nil
	}
	return fmt.Errorf("unknown Info field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *InfoMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *InfoMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *InfoMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Info numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *InfoMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *InfoMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *InfoMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Info nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *InfoMutation) ResetField(name string) error {
	switch name {
	case info.FieldContent:
		m.ResetContent()
		return nil
	}
	return fmt.Errorf("unknown Info field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *InfoMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.user != nil {
		edges = append(edges, info.EdgeUser)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *InfoMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case info.EdgeUser:
		if id := m.user; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *InfoMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *InfoMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *InfoMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.cleareduser {
		edges = append(edges, info.EdgeUser)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *InfoMutation) EdgeCleared(name string) bool {
	switch name {
	case info.EdgeUser:
		return m.cleareduser
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *InfoMutation) ClearEdge(name string) error {
	switch name {
	case info.EdgeUser:
		m.ClearUser()
		return nil
	}
	return fmt.Errorf("unknown Info unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *InfoMutation) ResetEdge(name string) error {
	switch name {
	case info.EdgeUser:
		m.ResetUser()
		return nil
	}
	return fmt.Errorf("unknown Info edge %s", name)
}

// MetadataMutation represents an operation that mutates the Metadata nodes in the graph.
type MetadataMutation struct {
	config
	op              Op
	typ             string
	id              *int
	age             *int
	addage          *int
	clearedFields   map[string]struct{}
	user            *int
	cleareduser     bool
	children        map[int]struct{}
	removedchildren map[int]struct{}
	clearedchildren bool
	parent          *int
	clearedparent   bool
	done            bool
	oldValue        func(context.Context) (*Metadata, error)
	predicates      []predicate.Metadata
}

var _ ent.Mutation = (*MetadataMutation)(nil)

// metadataOption allows management of the mutation configuration using functional options.
type metadataOption func(*MetadataMutation)

// newMetadataMutation creates new mutation for the Metadata entity.
func newMetadataMutation(c config, op Op, opts ...metadataOption) *MetadataMutation {
	m := &MetadataMutation{
		config:        c,
		op:            op,
		typ:           TypeMetadata,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withMetadataID sets the ID field of the mutation.
func withMetadataID(id int) metadataOption {
	return func(m *MetadataMutation) {
		var (
			err   error
			once  sync.Once
			value *Metadata
		)
		m.oldValue = func(ctx context.Context) (*Metadata, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Metadata.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withMetadata sets the old Metadata of the mutation.
func withMetadata(node *Metadata) metadataOption {
	return func(m *MetadataMutation) {
		m.oldValue = func(context.Context) (*Metadata, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m MetadataMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m MetadataMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Metadata entities.
func (m *MetadataMutation) SetID(id int) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *MetadataMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetAge sets the "age" field.
func (m *MetadataMutation) SetAge(i int) {
	m.age = &i
	m.addage = nil
}

// Age returns the value of the "age" field in the mutation.
func (m *MetadataMutation) Age() (r int, exists bool) {
	v := m.age
	if v == nil {
		return
	}
	return *v, true
}

// OldAge returns the old "age" field's value of the Metadata entity.
// If the Metadata object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MetadataMutation) OldAge(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldAge is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldAge requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAge: %w", err)
	}
	return oldValue.Age, nil
}

// AddAge adds i to the "age" field.
func (m *MetadataMutation) AddAge(i int) {
	if m.addage != nil {
		*m.addage += i
	} else {
		m.addage = &i
	}
}

// AddedAge returns the value that was added to the "age" field in this mutation.
func (m *MetadataMutation) AddedAge() (r int, exists bool) {
	v := m.addage
	if v == nil {
		return
	}
	return *v, true
}

// ResetAge resets all changes to the "age" field.
func (m *MetadataMutation) ResetAge() {
	m.age = nil
	m.addage = nil
}

// SetParentID sets the "parent_id" field.
func (m *MetadataMutation) SetParentID(i int) {
	m.parent = &i
}

// ParentID returns the value of the "parent_id" field in the mutation.
func (m *MetadataMutation) ParentID() (r int, exists bool) {
	v := m.parent
	if v == nil {
		return
	}
	return *v, true
}

// OldParentID returns the old "parent_id" field's value of the Metadata entity.
// If the Metadata object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MetadataMutation) OldParentID(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldParentID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldParentID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldParentID: %w", err)
	}
	return oldValue.ParentID, nil
}

// ClearParentID clears the value of the "parent_id" field.
func (m *MetadataMutation) ClearParentID() {
	m.parent = nil
	m.clearedFields[metadata.FieldParentID] = struct{}{}
}

// ParentIDCleared returns if the "parent_id" field was cleared in this mutation.
func (m *MetadataMutation) ParentIDCleared() bool {
	_, ok := m.clearedFields[metadata.FieldParentID]
	return ok
}

// ResetParentID resets all changes to the "parent_id" field.
func (m *MetadataMutation) ResetParentID() {
	m.parent = nil
	delete(m.clearedFields, metadata.FieldParentID)
}

// SetUserID sets the "user" edge to the User entity by id.
func (m *MetadataMutation) SetUserID(id int) {
	m.user = &id
}

// ClearUser clears the "user" edge to the User entity.
func (m *MetadataMutation) ClearUser() {
	m.cleareduser = true
}

// UserCleared reports if the "user" edge to the User entity was cleared.
func (m *MetadataMutation) UserCleared() bool {
	return m.cleareduser
}

// UserID returns the "user" edge ID in the mutation.
func (m *MetadataMutation) UserID() (id int, exists bool) {
	if m.user != nil {
		return *m.user, true
	}
	return
}

// UserIDs returns the "user" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// UserID instead. It exists only for internal usage by the builders.
func (m *MetadataMutation) UserIDs() (ids []int) {
	if id := m.user; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetUser resets all changes to the "user" edge.
func (m *MetadataMutation) ResetUser() {
	m.user = nil
	m.cleareduser = false
}

// AddChildIDs adds the "children" edge to the Metadata entity by ids.
func (m *MetadataMutation) AddChildIDs(ids ...int) {
	if m.children == nil {
		m.children = make(map[int]struct{})
	}
	for i := range ids {
		m.children[ids[i]] = struct{}{}
	}
}

// ClearChildren clears the "children" edge to the Metadata entity.
func (m *MetadataMutation) ClearChildren() {
	m.clearedchildren = true
}

// ChildrenCleared reports if the "children" edge to the Metadata entity was cleared.
func (m *MetadataMutation) ChildrenCleared() bool {
	return m.clearedchildren
}

// RemoveChildIDs removes the "children" edge to the Metadata entity by IDs.
func (m *MetadataMutation) RemoveChildIDs(ids ...int) {
	if m.removedchildren == nil {
		m.removedchildren = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.children, ids[i])
		m.removedchildren[ids[i]] = struct{}{}
	}
}

// RemovedChildren returns the removed IDs of the "children" edge to the Metadata entity.
func (m *MetadataMutation) RemovedChildrenIDs() (ids []int) {
	for id := range m.removedchildren {
		ids = append(ids, id)
	}
	return
}

// ChildrenIDs returns the "children" edge IDs in the mutation.
func (m *MetadataMutation) ChildrenIDs() (ids []int) {
	for id := range m.children {
		ids = append(ids, id)
	}
	return
}

// ResetChildren resets all changes to the "children" edge.
func (m *MetadataMutation) ResetChildren() {
	m.children = nil
	m.clearedchildren = false
	m.removedchildren = nil
}

// ClearParent clears the "parent" edge to the Metadata entity.
func (m *MetadataMutation) ClearParent() {
	m.clearedparent = true
}

// ParentCleared reports if the "parent" edge to the Metadata entity was cleared.
func (m *MetadataMutation) ParentCleared() bool {
	return m.ParentIDCleared() || m.clearedparent
}

// ParentIDs returns the "parent" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// ParentID instead. It exists only for internal usage by the builders.
func (m *MetadataMutation) ParentIDs() (ids []int) {
	if id := m.parent; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetParent resets all changes to the "parent" edge.
func (m *MetadataMutation) ResetParent() {
	m.parent = nil
	m.clearedparent = false
}

// Where appends a list predicates to the MetadataMutation builder.
func (m *MetadataMutation) Where(ps ...predicate.Metadata) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *MetadataMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Metadata).
func (m *MetadataMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *MetadataMutation) Fields() []string {
	fields := make([]string, 0, 2)
	if m.age != nil {
		fields = append(fields, metadata.FieldAge)
	}
	if m.parent != nil {
		fields = append(fields, metadata.FieldParentID)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *MetadataMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case metadata.FieldAge:
		return m.Age()
	case metadata.FieldParentID:
		return m.ParentID()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *MetadataMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case metadata.FieldAge:
		return m.OldAge(ctx)
	case metadata.FieldParentID:
		return m.OldParentID(ctx)
	}
	return nil, fmt.Errorf("unknown Metadata field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MetadataMutation) SetField(name string, value ent.Value) error {
	switch name {
	case metadata.FieldAge:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAge(v)
		return nil
	case metadata.FieldParentID:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetParentID(v)
		return nil
	}
	return fmt.Errorf("unknown Metadata field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *MetadataMutation) AddedFields() []string {
	var fields []string
	if m.addage != nil {
		fields = append(fields, metadata.FieldAge)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *MetadataMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case metadata.FieldAge:
		return m.AddedAge()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MetadataMutation) AddField(name string, value ent.Value) error {
	switch name {
	case metadata.FieldAge:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddAge(v)
		return nil
	}
	return fmt.Errorf("unknown Metadata numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *MetadataMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(metadata.FieldParentID) {
		fields = append(fields, metadata.FieldParentID)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *MetadataMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *MetadataMutation) ClearField(name string) error {
	switch name {
	case metadata.FieldParentID:
		m.ClearParentID()
		return nil
	}
	return fmt.Errorf("unknown Metadata nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *MetadataMutation) ResetField(name string) error {
	switch name {
	case metadata.FieldAge:
		m.ResetAge()
		return nil
	case metadata.FieldParentID:
		m.ResetParentID()
		return nil
	}
	return fmt.Errorf("unknown Metadata field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *MetadataMutation) AddedEdges() []string {
	edges := make([]string, 0, 3)
	if m.user != nil {
		edges = append(edges, metadata.EdgeUser)
	}
	if m.children != nil {
		edges = append(edges, metadata.EdgeChildren)
	}
	if m.parent != nil {
		edges = append(edges, metadata.EdgeParent)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *MetadataMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case metadata.EdgeUser:
		if id := m.user; id != nil {
			return []ent.Value{*id}
		}
	case metadata.EdgeChildren:
		ids := make([]ent.Value, 0, len(m.children))
		for id := range m.children {
			ids = append(ids, id)
		}
		return ids
	case metadata.EdgeParent:
		if id := m.parent; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *MetadataMutation) RemovedEdges() []string {
	edges := make([]string, 0, 3)
	if m.removedchildren != nil {
		edges = append(edges, metadata.EdgeChildren)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *MetadataMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case metadata.EdgeChildren:
		ids := make([]ent.Value, 0, len(m.removedchildren))
		for id := range m.removedchildren {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *MetadataMutation) ClearedEdges() []string {
	edges := make([]string, 0, 3)
	if m.cleareduser {
		edges = append(edges, metadata.EdgeUser)
	}
	if m.clearedchildren {
		edges = append(edges, metadata.EdgeChildren)
	}
	if m.clearedparent {
		edges = append(edges, metadata.EdgeParent)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *MetadataMutation) EdgeCleared(name string) bool {
	switch name {
	case metadata.EdgeUser:
		return m.cleareduser
	case metadata.EdgeChildren:
		return m.clearedchildren
	case metadata.EdgeParent:
		return m.clearedparent
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *MetadataMutation) ClearEdge(name string) error {
	switch name {
	case metadata.EdgeUser:
		m.ClearUser()
		return nil
	case metadata.EdgeParent:
		m.ClearParent()
		return nil
	}
	return fmt.Errorf("unknown Metadata unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *MetadataMutation) ResetEdge(name string) error {
	switch name {
	case metadata.EdgeUser:
		m.ResetUser()
		return nil
	case metadata.EdgeChildren:
		m.ResetChildren()
		return nil
	case metadata.EdgeParent:
		m.ResetParent()
		return nil
	}
	return fmt.Errorf("unknown Metadata edge %s", name)
}

// PetMutation represents an operation that mutates the Pet nodes in the graph.
type PetMutation struct {
	config
	op            Op
	typ           string
	id            *int
	clearedFields map[string]struct{}
	owner         *int
	clearedowner  bool
	done          bool
	oldValue      func(context.Context) (*Pet, error)
	predicates    []predicate.Pet
}

var _ ent.Mutation = (*PetMutation)(nil)

// petOption allows management of the mutation configuration using functional options.
type petOption func(*PetMutation)

// newPetMutation creates new mutation for the Pet entity.
func newPetMutation(c config, op Op, opts ...petOption) *PetMutation {
	m := &PetMutation{
		config:        c,
		op:            op,
		typ:           TypePet,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withPetID sets the ID field of the mutation.
func withPetID(id int) petOption {
	return func(m *PetMutation) {
		var (
			err   error
			once  sync.Once
			value *Pet
		)
		m.oldValue = func(ctx context.Context) (*Pet, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Pet.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withPet sets the old Pet of the mutation.
func withPet(node *Pet) petOption {
	return func(m *PetMutation) {
		m.oldValue = func(context.Context) (*Pet, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m PetMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m PetMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *PetMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetOwnerID sets the "owner_id" field.
func (m *PetMutation) SetOwnerID(i int) {
	m.owner = &i
}

// OwnerID returns the value of the "owner_id" field in the mutation.
func (m *PetMutation) OwnerID() (r int, exists bool) {
	v := m.owner
	if v == nil {
		return
	}
	return *v, true
}

// OldOwnerID returns the old "owner_id" field's value of the Pet entity.
// If the Pet object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *PetMutation) OldOwnerID(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldOwnerID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldOwnerID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldOwnerID: %w", err)
	}
	return oldValue.OwnerID, nil
}

// ClearOwnerID clears the value of the "owner_id" field.
func (m *PetMutation) ClearOwnerID() {
	m.owner = nil
	m.clearedFields[pet.FieldOwnerID] = struct{}{}
}

// OwnerIDCleared returns if the "owner_id" field was cleared in this mutation.
func (m *PetMutation) OwnerIDCleared() bool {
	_, ok := m.clearedFields[pet.FieldOwnerID]
	return ok
}

// ResetOwnerID resets all changes to the "owner_id" field.
func (m *PetMutation) ResetOwnerID() {
	m.owner = nil
	delete(m.clearedFields, pet.FieldOwnerID)
}

// ClearOwner clears the "owner" edge to the User entity.
func (m *PetMutation) ClearOwner() {
	m.clearedowner = true
}

// OwnerCleared reports if the "owner" edge to the User entity was cleared.
func (m *PetMutation) OwnerCleared() bool {
	return m.OwnerIDCleared() || m.clearedowner
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *PetMutation) OwnerIDs() (ids []int) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *PetMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// Where appends a list predicates to the PetMutation builder.
func (m *PetMutation) Where(ps ...predicate.Pet) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *PetMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Pet).
func (m *PetMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *PetMutation) Fields() []string {
	fields := make([]string, 0, 1)
	if m.owner != nil {
		fields = append(fields, pet.FieldOwnerID)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *PetMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case pet.FieldOwnerID:
		return m.OwnerID()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *PetMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case pet.FieldOwnerID:
		return m.OldOwnerID(ctx)
	}
	return nil, fmt.Errorf("unknown Pet field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *PetMutation) SetField(name string, value ent.Value) error {
	switch name {
	case pet.FieldOwnerID:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetOwnerID(v)
		return nil
	}
	return fmt.Errorf("unknown Pet field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *PetMutation) AddedFields() []string {
	var fields []string
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *PetMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *PetMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Pet numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *PetMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(pet.FieldOwnerID) {
		fields = append(fields, pet.FieldOwnerID)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *PetMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *PetMutation) ClearField(name string) error {
	switch name {
	case pet.FieldOwnerID:
		m.ClearOwnerID()
		return nil
	}
	return fmt.Errorf("unknown Pet nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *PetMutation) ResetField(name string) error {
	switch name {
	case pet.FieldOwnerID:
		m.ResetOwnerID()
		return nil
	}
	return fmt.Errorf("unknown Pet field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *PetMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.owner != nil {
		edges = append(edges, pet.EdgeOwner)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *PetMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case pet.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *PetMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *PetMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *PetMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedowner {
		edges = append(edges, pet.EdgeOwner)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *PetMutation) EdgeCleared(name string) bool {
	switch name {
	case pet.EdgeOwner:
		return m.clearedowner
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *PetMutation) ClearEdge(name string) error {
	switch name {
	case pet.EdgeOwner:
		m.ClearOwner()
		return nil
	}
	return fmt.Errorf("unknown Pet unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *PetMutation) ResetEdge(name string) error {
	switch name {
	case pet.EdgeOwner:
		m.ResetOwner()
		return nil
	}
	return fmt.Errorf("unknown Pet edge %s", name)
}

// PostMutation represents an operation that mutates the Post nodes in the graph.
type PostMutation struct {
	config
	op            Op
	typ           string
	id            *int
	text          *string
	clearedFields map[string]struct{}
	author        *int
	clearedauthor bool
	done          bool
	oldValue      func(context.Context) (*Post, error)
	predicates    []predicate.Post
}

var _ ent.Mutation = (*PostMutation)(nil)

// postOption allows management of the mutation configuration using functional options.
type postOption func(*PostMutation)

// newPostMutation creates new mutation for the Post entity.
func newPostMutation(c config, op Op, opts ...postOption) *PostMutation {
	m := &PostMutation{
		config:        c,
		op:            op,
		typ:           TypePost,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withPostID sets the ID field of the mutation.
func withPostID(id int) postOption {
	return func(m *PostMutation) {
		var (
			err   error
			once  sync.Once
			value *Post
		)
		m.oldValue = func(ctx context.Context) (*Post, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Post.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withPost sets the old Post of the mutation.
func withPost(node *Post) postOption {
	return func(m *PostMutation) {
		m.oldValue = func(context.Context) (*Post, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m PostMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m PostMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *PostMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetText sets the "text" field.
func (m *PostMutation) SetText(s string) {
	m.text = &s
}

// Text returns the value of the "text" field in the mutation.
func (m *PostMutation) Text() (r string, exists bool) {
	v := m.text
	if v == nil {
		return
	}
	return *v, true
}

// OldText returns the old "text" field's value of the Post entity.
// If the Post object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *PostMutation) OldText(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldText is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldText requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldText: %w", err)
	}
	return oldValue.Text, nil
}

// ResetText resets all changes to the "text" field.
func (m *PostMutation) ResetText() {
	m.text = nil
}

// SetAuthorID sets the "author_id" field.
func (m *PostMutation) SetAuthorID(i int) {
	m.author = &i
}

// AuthorID returns the value of the "author_id" field in the mutation.
func (m *PostMutation) AuthorID() (r int, exists bool) {
	v := m.author
	if v == nil {
		return
	}
	return *v, true
}

// OldAuthorID returns the old "author_id" field's value of the Post entity.
// If the Post object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *PostMutation) OldAuthorID(ctx context.Context) (v *int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldAuthorID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldAuthorID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAuthorID: %w", err)
	}
	return oldValue.AuthorID, nil
}

// ClearAuthorID clears the value of the "author_id" field.
func (m *PostMutation) ClearAuthorID() {
	m.author = nil
	m.clearedFields[post.FieldAuthorID] = struct{}{}
}

// AuthorIDCleared returns if the "author_id" field was cleared in this mutation.
func (m *PostMutation) AuthorIDCleared() bool {
	_, ok := m.clearedFields[post.FieldAuthorID]
	return ok
}

// ResetAuthorID resets all changes to the "author_id" field.
func (m *PostMutation) ResetAuthorID() {
	m.author = nil
	delete(m.clearedFields, post.FieldAuthorID)
}

// ClearAuthor clears the "author" edge to the User entity.
func (m *PostMutation) ClearAuthor() {
	m.clearedauthor = true
}

// AuthorCleared reports if the "author" edge to the User entity was cleared.
func (m *PostMutation) AuthorCleared() bool {
	return m.AuthorIDCleared() || m.clearedauthor
}

// AuthorIDs returns the "author" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// AuthorID instead. It exists only for internal usage by the builders.
func (m *PostMutation) AuthorIDs() (ids []int) {
	if id := m.author; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetAuthor resets all changes to the "author" edge.
func (m *PostMutation) ResetAuthor() {
	m.author = nil
	m.clearedauthor = false
}

// Where appends a list predicates to the PostMutation builder.
func (m *PostMutation) Where(ps ...predicate.Post) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *PostMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Post).
func (m *PostMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *PostMutation) Fields() []string {
	fields := make([]string, 0, 2)
	if m.text != nil {
		fields = append(fields, post.FieldText)
	}
	if m.author != nil {
		fields = append(fields, post.FieldAuthorID)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *PostMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case post.FieldText:
		return m.Text()
	case post.FieldAuthorID:
		return m.AuthorID()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *PostMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case post.FieldText:
		return m.OldText(ctx)
	case post.FieldAuthorID:
		return m.OldAuthorID(ctx)
	}
	return nil, fmt.Errorf("unknown Post field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *PostMutation) SetField(name string, value ent.Value) error {
	switch name {
	case post.FieldText:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetText(v)
		return nil
	case post.FieldAuthorID:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAuthorID(v)
		return nil
	}
	return fmt.Errorf("unknown Post field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *PostMutation) AddedFields() []string {
	var fields []string
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *PostMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *PostMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Post numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *PostMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(post.FieldAuthorID) {
		fields = append(fields, post.FieldAuthorID)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *PostMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *PostMutation) ClearField(name string) error {
	switch name {
	case post.FieldAuthorID:
		m.ClearAuthorID()
		return nil
	}
	return fmt.Errorf("unknown Post nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *PostMutation) ResetField(name string) error {
	switch name {
	case post.FieldText:
		m.ResetText()
		return nil
	case post.FieldAuthorID:
		m.ResetAuthorID()
		return nil
	}
	return fmt.Errorf("unknown Post field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *PostMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.author != nil {
		edges = append(edges, post.EdgeAuthor)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *PostMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case post.EdgeAuthor:
		if id := m.author; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *PostMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *PostMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *PostMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedauthor {
		edges = append(edges, post.EdgeAuthor)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *PostMutation) EdgeCleared(name string) bool {
	switch name {
	case post.EdgeAuthor:
		return m.clearedauthor
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *PostMutation) ClearEdge(name string) error {
	switch name {
	case post.EdgeAuthor:
		m.ClearAuthor()
		return nil
	}
	return fmt.Errorf("unknown Post unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *PostMutation) ResetEdge(name string) error {
	switch name {
	case post.EdgeAuthor:
		m.ResetAuthor()
		return nil
	}
	return fmt.Errorf("unknown Post edge %s", name)
}

// RentalMutation represents an operation that mutates the Rental nodes in the graph.
type RentalMutation struct {
	config
	op            Op
	typ           string
	id            *int
	date          *time.Time
	clearedFields map[string]struct{}
	user          *int
	cleareduser   bool
	car           *uuid.UUID
	clearedcar    bool
	done          bool
	oldValue      func(context.Context) (*Rental, error)
	predicates    []predicate.Rental
}

var _ ent.Mutation = (*RentalMutation)(nil)

// rentalOption allows management of the mutation configuration using functional options.
type rentalOption func(*RentalMutation)

// newRentalMutation creates new mutation for the Rental entity.
func newRentalMutation(c config, op Op, opts ...rentalOption) *RentalMutation {
	m := &RentalMutation{
		config:        c,
		op:            op,
		typ:           TypeRental,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withRentalID sets the ID field of the mutation.
func withRentalID(id int) rentalOption {
	return func(m *RentalMutation) {
		var (
			err   error
			once  sync.Once
			value *Rental
		)
		m.oldValue = func(ctx context.Context) (*Rental, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Rental.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withRental sets the old Rental of the mutation.
func withRental(node *Rental) rentalOption {
	return func(m *RentalMutation) {
		m.oldValue = func(context.Context) (*Rental, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m RentalMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m RentalMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *RentalMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetDate sets the "date" field.
func (m *RentalMutation) SetDate(t time.Time) {
	m.date = &t
}

// Date returns the value of the "date" field in the mutation.
func (m *RentalMutation) Date() (r time.Time, exists bool) {
	v := m.date
	if v == nil {
		return
	}
	return *v, true
}

// OldDate returns the old "date" field's value of the Rental entity.
// If the Rental object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RentalMutation) OldDate(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldDate is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldDate requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDate: %w", err)
	}
	return oldValue.Date, nil
}

// ResetDate resets all changes to the "date" field.
func (m *RentalMutation) ResetDate() {
	m.date = nil
}

// SetUserID sets the "user_id" field.
func (m *RentalMutation) SetUserID(i int) {
	m.user = &i
}

// UserID returns the value of the "user_id" field in the mutation.
func (m *RentalMutation) UserID() (r int, exists bool) {
	v := m.user
	if v == nil {
		return
	}
	return *v, true
}

// OldUserID returns the old "user_id" field's value of the Rental entity.
// If the Rental object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RentalMutation) OldUserID(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserID: %w", err)
	}
	return oldValue.UserID, nil
}

// ResetUserID resets all changes to the "user_id" field.
func (m *RentalMutation) ResetUserID() {
	m.user = nil
}

// SetCarID sets the "car_id" field.
func (m *RentalMutation) SetCarID(u uuid.UUID) {
	m.car = &u
}

// CarID returns the value of the "car_id" field in the mutation.
func (m *RentalMutation) CarID() (r uuid.UUID, exists bool) {
	v := m.car
	if v == nil {
		return
	}
	return *v, true
}

// OldCarID returns the old "car_id" field's value of the Rental entity.
// If the Rental object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RentalMutation) OldCarID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldCarID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldCarID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCarID: %w", err)
	}
	return oldValue.CarID, nil
}

// ResetCarID resets all changes to the "car_id" field.
func (m *RentalMutation) ResetCarID() {
	m.car = nil
}

// ClearUser clears the "user" edge to the User entity.
func (m *RentalMutation) ClearUser() {
	m.cleareduser = true
}

// UserCleared reports if the "user" edge to the User entity was cleared.
func (m *RentalMutation) UserCleared() bool {
	return m.cleareduser
}

// UserIDs returns the "user" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// UserID instead. It exists only for internal usage by the builders.
func (m *RentalMutation) UserIDs() (ids []int) {
	if id := m.user; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetUser resets all changes to the "user" edge.
func (m *RentalMutation) ResetUser() {
	m.user = nil
	m.cleareduser = false
}

// ClearCar clears the "car" edge to the Car entity.
func (m *RentalMutation) ClearCar() {
	m.clearedcar = true
}

// CarCleared reports if the "car" edge to the Car entity was cleared.
func (m *RentalMutation) CarCleared() bool {
	return m.clearedcar
}

// CarIDs returns the "car" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// CarID instead. It exists only for internal usage by the builders.
func (m *RentalMutation) CarIDs() (ids []uuid.UUID) {
	if id := m.car; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetCar resets all changes to the "car" edge.
func (m *RentalMutation) ResetCar() {
	m.car = nil
	m.clearedcar = false
}

// Where appends a list predicates to the RentalMutation builder.
func (m *RentalMutation) Where(ps ...predicate.Rental) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *RentalMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Rental).
func (m *RentalMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *RentalMutation) Fields() []string {
	fields := make([]string, 0, 3)
	if m.date != nil {
		fields = append(fields, rental.FieldDate)
	}
	if m.user != nil {
		fields = append(fields, rental.FieldUserID)
	}
	if m.car != nil {
		fields = append(fields, rental.FieldCarID)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *RentalMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case rental.FieldDate:
		return m.Date()
	case rental.FieldUserID:
		return m.UserID()
	case rental.FieldCarID:
		return m.CarID()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *RentalMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case rental.FieldDate:
		return m.OldDate(ctx)
	case rental.FieldUserID:
		return m.OldUserID(ctx)
	case rental.FieldCarID:
		return m.OldCarID(ctx)
	}
	return nil, fmt.Errorf("unknown Rental field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *RentalMutation) SetField(name string, value ent.Value) error {
	switch name {
	case rental.FieldDate:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDate(v)
		return nil
	case rental.FieldUserID:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserID(v)
		return nil
	case rental.FieldCarID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCarID(v)
		return nil
	}
	return fmt.Errorf("unknown Rental field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *RentalMutation) AddedFields() []string {
	var fields []string
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *RentalMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *RentalMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Rental numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *RentalMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *RentalMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *RentalMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Rental nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *RentalMutation) ResetField(name string) error {
	switch name {
	case rental.FieldDate:
		m.ResetDate()
		return nil
	case rental.FieldUserID:
		m.ResetUserID()
		return nil
	case rental.FieldCarID:
		m.ResetCarID()
		return nil
	}
	return fmt.Errorf("unknown Rental field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *RentalMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.user != nil {
		edges = append(edges, rental.EdgeUser)
	}
	if m.car != nil {
		edges = append(edges, rental.EdgeCar)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *RentalMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case rental.EdgeUser:
		if id := m.user; id != nil {
			return []ent.Value{*id}
		}
	case rental.EdgeCar:
		if id := m.car; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *RentalMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *RentalMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *RentalMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.cleareduser {
		edges = append(edges, rental.EdgeUser)
	}
	if m.clearedcar {
		edges = append(edges, rental.EdgeCar)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *RentalMutation) EdgeCleared(name string) bool {
	switch name {
	case rental.EdgeUser:
		return m.cleareduser
	case rental.EdgeCar:
		return m.clearedcar
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *RentalMutation) ClearEdge(name string) error {
	switch name {
	case rental.EdgeUser:
		m.ClearUser()
		return nil
	case rental.EdgeCar:
		m.ClearCar()
		return nil
	}
	return fmt.Errorf("unknown Rental unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *RentalMutation) ResetEdge(name string) error {
	switch name {
	case rental.EdgeUser:
		m.ResetUser()
		return nil
	case rental.EdgeCar:
		m.ResetCar()
		return nil
	}
	return fmt.Errorf("unknown Rental edge %s", name)
}

// UserMutation represents an operation that mutates the User nodes in the graph.
type UserMutation struct {
	config
	op              Op
	typ             string
	id              *int
	clearedFields   map[string]struct{}
	pets            map[int]struct{}
	removedpets     map[int]struct{}
	clearedpets     bool
	parent          *int
	clearedparent   bool
	children        map[int]struct{}
	removedchildren map[int]struct{}
	clearedchildren bool
	spouse          *int
	clearedspouse   bool
	card            *int
	clearedcard     bool
	metadata        *int
	clearedmetadata bool
	info            map[int]struct{}
	removedinfo     map[int]struct{}
	clearedinfo     bool
	rentals         map[int]struct{}
	removedrentals  map[int]struct{}
	clearedrentals  bool
	done            bool
	oldValue        func(context.Context) (*User, error)
	predicates      []predicate.User
}

var _ ent.Mutation = (*UserMutation)(nil)

// userOption allows management of the mutation configuration using functional options.
type userOption func(*UserMutation)

// newUserMutation creates new mutation for the User entity.
func newUserMutation(c config, op Op, opts ...userOption) *UserMutation {
	m := &UserMutation{
		config:        c,
		op:            op,
		typ:           TypeUser,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withUserID sets the ID field of the mutation.
func withUserID(id int) userOption {
	return func(m *UserMutation) {
		var (
			err   error
			once  sync.Once
			value *User
		)
		m.oldValue = func(ctx context.Context) (*User, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().User.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withUser sets the old User of the mutation.
func withUser(node *User) userOption {
	return func(m *UserMutation) {
		m.oldValue = func(context.Context) (*User, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m UserMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m UserMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of User entities.
func (m *UserMutation) SetID(id int) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *UserMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetParentID sets the "parent_id" field.
func (m *UserMutation) SetParentID(i int) {
	m.parent = &i
}

// ParentID returns the value of the "parent_id" field in the mutation.
func (m *UserMutation) ParentID() (r int, exists bool) {
	v := m.parent
	if v == nil {
		return
	}
	return *v, true
}

// OldParentID returns the old "parent_id" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldParentID(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldParentID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldParentID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldParentID: %w", err)
	}
	return oldValue.ParentID, nil
}

// ClearParentID clears the value of the "parent_id" field.
func (m *UserMutation) ClearParentID() {
	m.parent = nil
	m.clearedFields[user.FieldParentID] = struct{}{}
}

// ParentIDCleared returns if the "parent_id" field was cleared in this mutation.
func (m *UserMutation) ParentIDCleared() bool {
	_, ok := m.clearedFields[user.FieldParentID]
	return ok
}

// ResetParentID resets all changes to the "parent_id" field.
func (m *UserMutation) ResetParentID() {
	m.parent = nil
	delete(m.clearedFields, user.FieldParentID)
}

// SetSpouseID sets the "spouse_id" field.
func (m *UserMutation) SetSpouseID(i int) {
	m.spouse = &i
}

// SpouseID returns the value of the "spouse_id" field in the mutation.
func (m *UserMutation) SpouseID() (r int, exists bool) {
	v := m.spouse
	if v == nil {
		return
	}
	return *v, true
}

// OldSpouseID returns the old "spouse_id" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldSpouseID(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldSpouseID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldSpouseID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSpouseID: %w", err)
	}
	return oldValue.SpouseID, nil
}

// ClearSpouseID clears the value of the "spouse_id" field.
func (m *UserMutation) ClearSpouseID() {
	m.spouse = nil
	m.clearedFields[user.FieldSpouseID] = struct{}{}
}

// SpouseIDCleared returns if the "spouse_id" field was cleared in this mutation.
func (m *UserMutation) SpouseIDCleared() bool {
	_, ok := m.clearedFields[user.FieldSpouseID]
	return ok
}

// ResetSpouseID resets all changes to the "spouse_id" field.
func (m *UserMutation) ResetSpouseID() {
	m.spouse = nil
	delete(m.clearedFields, user.FieldSpouseID)
}

// AddPetIDs adds the "pets" edge to the Pet entity by ids.
func (m *UserMutation) AddPetIDs(ids ...int) {
	if m.pets == nil {
		m.pets = make(map[int]struct{})
	}
	for i := range ids {
		m.pets[ids[i]] = struct{}{}
	}
}

// ClearPets clears the "pets" edge to the Pet entity.
func (m *UserMutation) ClearPets() {
	m.clearedpets = true
}

// PetsCleared reports if the "pets" edge to the Pet entity was cleared.
func (m *UserMutation) PetsCleared() bool {
	return m.clearedpets
}

// RemovePetIDs removes the "pets" edge to the Pet entity by IDs.
func (m *UserMutation) RemovePetIDs(ids ...int) {
	if m.removedpets == nil {
		m.removedpets = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.pets, ids[i])
		m.removedpets[ids[i]] = struct{}{}
	}
}

// RemovedPets returns the removed IDs of the "pets" edge to the Pet entity.
func (m *UserMutation) RemovedPetsIDs() (ids []int) {
	for id := range m.removedpets {
		ids = append(ids, id)
	}
	return
}

// PetsIDs returns the "pets" edge IDs in the mutation.
func (m *UserMutation) PetsIDs() (ids []int) {
	for id := range m.pets {
		ids = append(ids, id)
	}
	return
}

// ResetPets resets all changes to the "pets" edge.
func (m *UserMutation) ResetPets() {
	m.pets = nil
	m.clearedpets = false
	m.removedpets = nil
}

// ClearParent clears the "parent" edge to the User entity.
func (m *UserMutation) ClearParent() {
	m.clearedparent = true
}

// ParentCleared reports if the "parent" edge to the User entity was cleared.
func (m *UserMutation) ParentCleared() bool {
	return m.ParentIDCleared() || m.clearedparent
}

// ParentIDs returns the "parent" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// ParentID instead. It exists only for internal usage by the builders.
func (m *UserMutation) ParentIDs() (ids []int) {
	if id := m.parent; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetParent resets all changes to the "parent" edge.
func (m *UserMutation) ResetParent() {
	m.parent = nil
	m.clearedparent = false
}

// AddChildIDs adds the "children" edge to the User entity by ids.
func (m *UserMutation) AddChildIDs(ids ...int) {
	if m.children == nil {
		m.children = make(map[int]struct{})
	}
	for i := range ids {
		m.children[ids[i]] = struct{}{}
	}
}

// ClearChildren clears the "children" edge to the User entity.
func (m *UserMutation) ClearChildren() {
	m.clearedchildren = true
}

// ChildrenCleared reports if the "children" edge to the User entity was cleared.
func (m *UserMutation) ChildrenCleared() bool {
	return m.clearedchildren
}

// RemoveChildIDs removes the "children" edge to the User entity by IDs.
func (m *UserMutation) RemoveChildIDs(ids ...int) {
	if m.removedchildren == nil {
		m.removedchildren = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.children, ids[i])
		m.removedchildren[ids[i]] = struct{}{}
	}
}

// RemovedChildren returns the removed IDs of the "children" edge to the User entity.
func (m *UserMutation) RemovedChildrenIDs() (ids []int) {
	for id := range m.removedchildren {
		ids = append(ids, id)
	}
	return
}

// ChildrenIDs returns the "children" edge IDs in the mutation.
func (m *UserMutation) ChildrenIDs() (ids []int) {
	for id := range m.children {
		ids = append(ids, id)
	}
	return
}

// ResetChildren resets all changes to the "children" edge.
func (m *UserMutation) ResetChildren() {
	m.children = nil
	m.clearedchildren = false
	m.removedchildren = nil
}

// ClearSpouse clears the "spouse" edge to the User entity.
func (m *UserMutation) ClearSpouse() {
	m.clearedspouse = true
}

// SpouseCleared reports if the "spouse" edge to the User entity was cleared.
func (m *UserMutation) SpouseCleared() bool {
	return m.SpouseIDCleared() || m.clearedspouse
}

// SpouseIDs returns the "spouse" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// SpouseID instead. It exists only for internal usage by the builders.
func (m *UserMutation) SpouseIDs() (ids []int) {
	if id := m.spouse; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetSpouse resets all changes to the "spouse" edge.
func (m *UserMutation) ResetSpouse() {
	m.spouse = nil
	m.clearedspouse = false
}

// SetCardID sets the "card" edge to the Card entity by id.
func (m *UserMutation) SetCardID(id int) {
	m.card = &id
}

// ClearCard clears the "card" edge to the Card entity.
func (m *UserMutation) ClearCard() {
	m.clearedcard = true
}

// CardCleared reports if the "card" edge to the Card entity was cleared.
func (m *UserMutation) CardCleared() bool {
	return m.clearedcard
}

// CardID returns the "card" edge ID in the mutation.
func (m *UserMutation) CardID() (id int, exists bool) {
	if m.card != nil {
		return *m.card, true
	}
	return
}

// CardIDs returns the "card" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// CardID instead. It exists only for internal usage by the builders.
func (m *UserMutation) CardIDs() (ids []int) {
	if id := m.card; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetCard resets all changes to the "card" edge.
func (m *UserMutation) ResetCard() {
	m.card = nil
	m.clearedcard = false
}

// SetMetadataID sets the "metadata" edge to the Metadata entity by id.
func (m *UserMutation) SetMetadataID(id int) {
	m.metadata = &id
}

// ClearMetadata clears the "metadata" edge to the Metadata entity.
func (m *UserMutation) ClearMetadata() {
	m.clearedmetadata = true
}

// MetadataCleared reports if the "metadata" edge to the Metadata entity was cleared.
func (m *UserMutation) MetadataCleared() bool {
	return m.clearedmetadata
}

// MetadataID returns the "metadata" edge ID in the mutation.
func (m *UserMutation) MetadataID() (id int, exists bool) {
	if m.metadata != nil {
		return *m.metadata, true
	}
	return
}

// MetadataIDs returns the "metadata" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// MetadataID instead. It exists only for internal usage by the builders.
func (m *UserMutation) MetadataIDs() (ids []int) {
	if id := m.metadata; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetMetadata resets all changes to the "metadata" edge.
func (m *UserMutation) ResetMetadata() {
	m.metadata = nil
	m.clearedmetadata = false
}

// AddInfoIDs adds the "info" edge to the Info entity by ids.
func (m *UserMutation) AddInfoIDs(ids ...int) {
	if m.info == nil {
		m.info = make(map[int]struct{})
	}
	for i := range ids {
		m.info[ids[i]] = struct{}{}
	}
}

// ClearInfo clears the "info" edge to the Info entity.
func (m *UserMutation) ClearInfo() {
	m.clearedinfo = true
}

// InfoCleared reports if the "info" edge to the Info entity was cleared.
func (m *UserMutation) InfoCleared() bool {
	return m.clearedinfo
}

// RemoveInfoIDs removes the "info" edge to the Info entity by IDs.
func (m *UserMutation) RemoveInfoIDs(ids ...int) {
	if m.removedinfo == nil {
		m.removedinfo = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.info, ids[i])
		m.removedinfo[ids[i]] = struct{}{}
	}
}

// RemovedInfo returns the removed IDs of the "info" edge to the Info entity.
func (m *UserMutation) RemovedInfoIDs() (ids []int) {
	for id := range m.removedinfo {
		ids = append(ids, id)
	}
	return
}

// InfoIDs returns the "info" edge IDs in the mutation.
func (m *UserMutation) InfoIDs() (ids []int) {
	for id := range m.info {
		ids = append(ids, id)
	}
	return
}

// ResetInfo resets all changes to the "info" edge.
func (m *UserMutation) ResetInfo() {
	m.info = nil
	m.clearedinfo = false
	m.removedinfo = nil
}

// AddRentalIDs adds the "rentals" edge to the Rental entity by ids.
func (m *UserMutation) AddRentalIDs(ids ...int) {
	if m.rentals == nil {
		m.rentals = make(map[int]struct{})
	}
	for i := range ids {
		m.rentals[ids[i]] = struct{}{}
	}
}

// ClearRentals clears the "rentals" edge to the Rental entity.
func (m *UserMutation) ClearRentals() {
	m.clearedrentals = true
}

// RentalsCleared reports if the "rentals" edge to the Rental entity was cleared.
func (m *UserMutation) RentalsCleared() bool {
	return m.clearedrentals
}

// RemoveRentalIDs removes the "rentals" edge to the Rental entity by IDs.
func (m *UserMutation) RemoveRentalIDs(ids ...int) {
	if m.removedrentals == nil {
		m.removedrentals = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.rentals, ids[i])
		m.removedrentals[ids[i]] = struct{}{}
	}
}

// RemovedRentals returns the removed IDs of the "rentals" edge to the Rental entity.
func (m *UserMutation) RemovedRentalsIDs() (ids []int) {
	for id := range m.removedrentals {
		ids = append(ids, id)
	}
	return
}

// RentalsIDs returns the "rentals" edge IDs in the mutation.
func (m *UserMutation) RentalsIDs() (ids []int) {
	for id := range m.rentals {
		ids = append(ids, id)
	}
	return
}

// ResetRentals resets all changes to the "rentals" edge.
func (m *UserMutation) ResetRentals() {
	m.rentals = nil
	m.clearedrentals = false
	m.removedrentals = nil
}

// Where appends a list predicates to the UserMutation builder.
func (m *UserMutation) Where(ps ...predicate.User) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *UserMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (User).
func (m *UserMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *UserMutation) Fields() []string {
	fields := make([]string, 0, 2)
	if m.parent != nil {
		fields = append(fields, user.FieldParentID)
	}
	if m.spouse != nil {
		fields = append(fields, user.FieldSpouseID)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *UserMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case user.FieldParentID:
		return m.ParentID()
	case user.FieldSpouseID:
		return m.SpouseID()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *UserMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case user.FieldParentID:
		return m.OldParentID(ctx)
	case user.FieldSpouseID:
		return m.OldSpouseID(ctx)
	}
	return nil, fmt.Errorf("unknown User field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserMutation) SetField(name string, value ent.Value) error {
	switch name {
	case user.FieldParentID:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetParentID(v)
		return nil
	case user.FieldSpouseID:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSpouseID(v)
		return nil
	}
	return fmt.Errorf("unknown User field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *UserMutation) AddedFields() []string {
	var fields []string
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *UserMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown User numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *UserMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(user.FieldParentID) {
		fields = append(fields, user.FieldParentID)
	}
	if m.FieldCleared(user.FieldSpouseID) {
		fields = append(fields, user.FieldSpouseID)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *UserMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *UserMutation) ClearField(name string) error {
	switch name {
	case user.FieldParentID:
		m.ClearParentID()
		return nil
	case user.FieldSpouseID:
		m.ClearSpouseID()
		return nil
	}
	return fmt.Errorf("unknown User nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *UserMutation) ResetField(name string) error {
	switch name {
	case user.FieldParentID:
		m.ResetParentID()
		return nil
	case user.FieldSpouseID:
		m.ResetSpouseID()
		return nil
	}
	return fmt.Errorf("unknown User field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *UserMutation) AddedEdges() []string {
	edges := make([]string, 0, 8)
	if m.pets != nil {
		edges = append(edges, user.EdgePets)
	}
	if m.parent != nil {
		edges = append(edges, user.EdgeParent)
	}
	if m.children != nil {
		edges = append(edges, user.EdgeChildren)
	}
	if m.spouse != nil {
		edges = append(edges, user.EdgeSpouse)
	}
	if m.card != nil {
		edges = append(edges, user.EdgeCard)
	}
	if m.metadata != nil {
		edges = append(edges, user.EdgeMetadata)
	}
	if m.info != nil {
		edges = append(edges, user.EdgeInfo)
	}
	if m.rentals != nil {
		edges = append(edges, user.EdgeRentals)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *UserMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case user.EdgePets:
		ids := make([]ent.Value, 0, len(m.pets))
		for id := range m.pets {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeParent:
		if id := m.parent; id != nil {
			return []ent.Value{*id}
		}
	case user.EdgeChildren:
		ids := make([]ent.Value, 0, len(m.children))
		for id := range m.children {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeSpouse:
		if id := m.spouse; id != nil {
			return []ent.Value{*id}
		}
	case user.EdgeCard:
		if id := m.card; id != nil {
			return []ent.Value{*id}
		}
	case user.EdgeMetadata:
		if id := m.metadata; id != nil {
			return []ent.Value{*id}
		}
	case user.EdgeInfo:
		ids := make([]ent.Value, 0, len(m.info))
		for id := range m.info {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeRentals:
		ids := make([]ent.Value, 0, len(m.rentals))
		for id := range m.rentals {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *UserMutation) RemovedEdges() []string {
	edges := make([]string, 0, 8)
	if m.removedpets != nil {
		edges = append(edges, user.EdgePets)
	}
	if m.removedchildren != nil {
		edges = append(edges, user.EdgeChildren)
	}
	if m.removedinfo != nil {
		edges = append(edges, user.EdgeInfo)
	}
	if m.removedrentals != nil {
		edges = append(edges, user.EdgeRentals)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *UserMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case user.EdgePets:
		ids := make([]ent.Value, 0, len(m.removedpets))
		for id := range m.removedpets {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeChildren:
		ids := make([]ent.Value, 0, len(m.removedchildren))
		for id := range m.removedchildren {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeInfo:
		ids := make([]ent.Value, 0, len(m.removedinfo))
		for id := range m.removedinfo {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeRentals:
		ids := make([]ent.Value, 0, len(m.removedrentals))
		for id := range m.removedrentals {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *UserMutation) ClearedEdges() []string {
	edges := make([]string, 0, 8)
	if m.clearedpets {
		edges = append(edges, user.EdgePets)
	}
	if m.clearedparent {
		edges = append(edges, user.EdgeParent)
	}
	if m.clearedchildren {
		edges = append(edges, user.EdgeChildren)
	}
	if m.clearedspouse {
		edges = append(edges, user.EdgeSpouse)
	}
	if m.clearedcard {
		edges = append(edges, user.EdgeCard)
	}
	if m.clearedmetadata {
		edges = append(edges, user.EdgeMetadata)
	}
	if m.clearedinfo {
		edges = append(edges, user.EdgeInfo)
	}
	if m.clearedrentals {
		edges = append(edges, user.EdgeRentals)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *UserMutation) EdgeCleared(name string) bool {
	switch name {
	case user.EdgePets:
		return m.clearedpets
	case user.EdgeParent:
		return m.clearedparent
	case user.EdgeChildren:
		return m.clearedchildren
	case user.EdgeSpouse:
		return m.clearedspouse
	case user.EdgeCard:
		return m.clearedcard
	case user.EdgeMetadata:
		return m.clearedmetadata
	case user.EdgeInfo:
		return m.clearedinfo
	case user.EdgeRentals:
		return m.clearedrentals
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *UserMutation) ClearEdge(name string) error {
	switch name {
	case user.EdgeParent:
		m.ClearParent()
		return nil
	case user.EdgeSpouse:
		m.ClearSpouse()
		return nil
	case user.EdgeCard:
		m.ClearCard()
		return nil
	case user.EdgeMetadata:
		m.ClearMetadata()
		return nil
	}
	return fmt.Errorf("unknown User unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *UserMutation) ResetEdge(name string) error {
	switch name {
	case user.EdgePets:
		m.ResetPets()
		return nil
	case user.EdgeParent:
		m.ResetParent()
		return nil
	case user.EdgeChildren:
		m.ResetChildren()
		return nil
	case user.EdgeSpouse:
		m.ResetSpouse()
		return nil
	case user.EdgeCard:
		m.ResetCard()
		return nil
	case user.EdgeMetadata:
		m.ResetMetadata()
		return nil
	case user.EdgeInfo:
		m.ResetInfo()
		return nil
	case user.EdgeRentals:
		m.ResetRentals()
		return nil
	}
	return fmt.Errorf("unknown User edge %s", name)
}
