// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by entc, DO NOT EDIT.

package entv2

import (
	"context"
	"fmt"
	"sync"
	"time"

	"entgo.io/ent/entc/integration/migrate/entv2/car"
	"entgo.io/ent/entc/integration/migrate/entv2/conversion"
	"entgo.io/ent/entc/integration/migrate/entv2/customtype"
	"entgo.io/ent/entc/integration/migrate/entv2/media"
	"entgo.io/ent/entc/integration/migrate/entv2/pet"
	"entgo.io/ent/entc/integration/migrate/entv2/predicate"
	"entgo.io/ent/entc/integration/migrate/entv2/user"

	"entgo.io/ent"
)

const (
	// Operation types.
	OpCreate    = ent.OpCreate
	OpDelete    = ent.OpDelete
	OpDeleteOne = ent.OpDeleteOne
	OpUpdate    = ent.OpUpdate
	OpUpdateOne = ent.OpUpdateOne

	// Node types.
	TypeCar        = "Car"
	TypeConversion = "Conversion"
	TypeCustomType = "CustomType"
	TypeGroup      = "Group"
	TypeMedia      = "Media"
	TypePet        = "Pet"
	TypeUser       = "User"
)

// CarMutation represents an operation that mutates the Car nodes in the graph.
type CarMutation struct {
	config
	op            Op
	typ           string
	id            *int
	clearedFields map[string]struct{}
	owner         *int
	clearedowner  bool
	done          bool
	oldValue      func(context.Context) (*Car, error)
	predicates    []predicate.Car
}

var _ ent.Mutation = (*CarMutation)(nil)

// carOption allows management of the mutation configuration using functional options.
type carOption func(*CarMutation)

// newCarMutation creates new mutation for the Car entity.
func newCarMutation(c config, op Op, opts ...carOption) *CarMutation {
	m := &CarMutation{
		config:        c,
		op:            op,
		typ:           TypeCar,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withCarID sets the ID field of the mutation.
func withCarID(id int) carOption {
	return func(m *CarMutation) {
		var (
			err   error
			once  sync.Once
			value *Car
		)
		m.oldValue = func(ctx context.Context) (*Car, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Car.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withCar sets the old Car of the mutation.
func withCar(node *Car) carOption {
	return func(m *CarMutation) {
		m.oldValue = func(context.Context) (*Car, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m CarMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m CarMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("entv2: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *CarMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetOwnerID sets the "owner" edge to the User entity by id.
func (m *CarMutation) SetOwnerID(id int) {
	m.owner = &id
}

// ClearOwner clears the "owner" edge to the User entity.
func (m *CarMutation) ClearOwner() {
	m.clearedowner = true
}

// OwnerCleared reports if the "owner" edge to the User entity was cleared.
func (m *CarMutation) OwnerCleared() bool {
	return m.clearedowner
}

// OwnerID returns the "owner" edge ID in the mutation.
func (m *CarMutation) OwnerID() (id int, exists bool) {
	if m.owner != nil {
		return *m.owner, true
	}
	return
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *CarMutation) OwnerIDs() (ids []int) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *CarMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// Where appends a list predicates to the CarMutation builder.
func (m *CarMutation) Where(ps ...predicate.Car) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *CarMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Car).
func (m *CarMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *CarMutation) Fields() []string {
	fields := make([]string, 0, 0)
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *CarMutation) Field(name string) (ent.Value, bool) {
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *CarMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	return nil, fmt.Errorf("unknown Car field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *CarMutation) SetField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Car field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *CarMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *CarMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *CarMutation) AddField(name string, value ent.Value) error {
	return fmt.Errorf("unknown Car numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *CarMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *CarMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *CarMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Car nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *CarMutation) ResetField(name string) error {
	return fmt.Errorf("unknown Car field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *CarMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.owner != nil {
		edges = append(edges, car.EdgeOwner)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *CarMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case car.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *CarMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *CarMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *CarMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedowner {
		edges = append(edges, car.EdgeOwner)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *CarMutation) EdgeCleared(name string) bool {
	switch name {
	case car.EdgeOwner:
		return m.clearedowner
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *CarMutation) ClearEdge(name string) error {
	switch name {
	case car.EdgeOwner:
		m.ClearOwner()
		return nil
	}
	return fmt.Errorf("unknown Car unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *CarMutation) ResetEdge(name string) error {
	switch name {
	case car.EdgeOwner:
		m.ResetOwner()
		return nil
	}
	return fmt.Errorf("unknown Car edge %s", name)
}

// ConversionMutation represents an operation that mutates the Conversion nodes in the graph.
type ConversionMutation struct {
	config
	op               Op
	typ              string
	id               *int
	name             *string
	int8_to_string   *string
	uint8_to_string  *string
	int16_to_string  *string
	uint16_to_string *string
	int32_to_string  *string
	uint32_to_string *string
	int64_to_string  *string
	uint64_to_string *string
	clearedFields    map[string]struct{}
	done             bool
	oldValue         func(context.Context) (*Conversion, error)
	predicates       []predicate.Conversion
}

var _ ent.Mutation = (*ConversionMutation)(nil)

// conversionOption allows management of the mutation configuration using functional options.
type conversionOption func(*ConversionMutation)

// newConversionMutation creates new mutation for the Conversion entity.
func newConversionMutation(c config, op Op, opts ...conversionOption) *ConversionMutation {
	m := &ConversionMutation{
		config:        c,
		op:            op,
		typ:           TypeConversion,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withConversionID sets the ID field of the mutation.
func withConversionID(id int) conversionOption {
	return func(m *ConversionMutation) {
		var (
			err   error
			once  sync.Once
			value *Conversion
		)
		m.oldValue = func(ctx context.Context) (*Conversion, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Conversion.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withConversion sets the old Conversion of the mutation.
func withConversion(node *Conversion) conversionOption {
	return func(m *ConversionMutation) {
		m.oldValue = func(context.Context) (*Conversion, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m ConversionMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m ConversionMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("entv2: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *ConversionMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetName sets the "name" field.
func (m *ConversionMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *ConversionMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the Conversion entity.
// If the Conversion object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ConversionMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ClearName clears the value of the "name" field.
func (m *ConversionMutation) ClearName() {
	m.name = nil
	m.clearedFields[conversion.FieldName] = struct{}{}
}

// NameCleared returns if the "name" field was cleared in this mutation.
func (m *ConversionMutation) NameCleared() bool {
	_, ok := m.clearedFields[conversion.FieldName]
	return ok
}

// ResetName resets all changes to the "name" field.
func (m *ConversionMutation) ResetName() {
	m.name = nil
	delete(m.clearedFields, conversion.FieldName)
}

// SetInt8ToString sets the "int8_to_string" field.
func (m *ConversionMutation) SetInt8ToString(s string) {
	m.int8_to_string = &s
}

// Int8ToString returns the value of the "int8_to_string" field in the mutation.
func (m *ConversionMutation) Int8ToString() (r string, exists bool) {
	v := m.int8_to_string
	if v == nil {
		return
	}
	return *v, true
}

// OldInt8ToString returns the old "int8_to_string" field's value of the Conversion entity.
// If the Conversion object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ConversionMutation) OldInt8ToString(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldInt8ToString is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldInt8ToString requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldInt8ToString: %w", err)
	}
	return oldValue.Int8ToString, nil
}

// ClearInt8ToString clears the value of the "int8_to_string" field.
func (m *ConversionMutation) ClearInt8ToString() {
	m.int8_to_string = nil
	m.clearedFields[conversion.FieldInt8ToString] = struct{}{}
}

// Int8ToStringCleared returns if the "int8_to_string" field was cleared in this mutation.
func (m *ConversionMutation) Int8ToStringCleared() bool {
	_, ok := m.clearedFields[conversion.FieldInt8ToString]
	return ok
}

// ResetInt8ToString resets all changes to the "int8_to_string" field.
func (m *ConversionMutation) ResetInt8ToString() {
	m.int8_to_string = nil
	delete(m.clearedFields, conversion.FieldInt8ToString)
}

// SetUint8ToString sets the "uint8_to_string" field.
func (m *ConversionMutation) SetUint8ToString(s string) {
	m.uint8_to_string = &s
}

// Uint8ToString returns the value of the "uint8_to_string" field in the mutation.
func (m *ConversionMutation) Uint8ToString() (r string, exists bool) {
	v := m.uint8_to_string
	if v == nil {
		return
	}
	return *v, true
}

// OldUint8ToString returns the old "uint8_to_string" field's value of the Conversion entity.
// If the Conversion object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ConversionMutation) OldUint8ToString(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldUint8ToString is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldUint8ToString requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUint8ToString: %w", err)
	}
	return oldValue.Uint8ToString, nil
}

// ClearUint8ToString clears the value of the "uint8_to_string" field.
func (m *ConversionMutation) ClearUint8ToString() {
	m.uint8_to_string = nil
	m.clearedFields[conversion.FieldUint8ToString] = struct{}{}
}

// Uint8ToStringCleared returns if the "uint8_to_string" field was cleared in this mutation.
func (m *ConversionMutation) Uint8ToStringCleared() bool {
	_, ok := m.clearedFields[conversion.FieldUint8ToString]
	return ok
}

// ResetUint8ToString resets all changes to the "uint8_to_string" field.
func (m *ConversionMutation) ResetUint8ToString() {
	m.uint8_to_string = nil
	delete(m.clearedFields, conversion.FieldUint8ToString)
}

// SetInt16ToString sets the "int16_to_string" field.
func (m *ConversionMutation) SetInt16ToString(s string) {
	m.int16_to_string = &s
}

// Int16ToString returns the value of the "int16_to_string" field in the mutation.
func (m *ConversionMutation) Int16ToString() (r string, exists bool) {
	v := m.int16_to_string
	if v == nil {
		return
	}
	return *v, true
}

// OldInt16ToString returns the old "int16_to_string" field's value of the Conversion entity.
// If the Conversion object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ConversionMutation) OldInt16ToString(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldInt16ToString is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldInt16ToString requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldInt16ToString: %w", err)
	}
	return oldValue.Int16ToString, nil
}

// ClearInt16ToString clears the value of the "int16_to_string" field.
func (m *ConversionMutation) ClearInt16ToString() {
	m.int16_to_string = nil
	m.clearedFields[conversion.FieldInt16ToString] = struct{}{}
}

// Int16ToStringCleared returns if the "int16_to_string" field was cleared in this mutation.
func (m *ConversionMutation) Int16ToStringCleared() bool {
	_, ok := m.clearedFields[conversion.FieldInt16ToString]
	return ok
}

// ResetInt16ToString resets all changes to the "int16_to_string" field.
func (m *ConversionMutation) ResetInt16ToString() {
	m.int16_to_string = nil
	delete(m.clearedFields, conversion.FieldInt16ToString)
}

// SetUint16ToString sets the "uint16_to_string" field.
func (m *ConversionMutation) SetUint16ToString(s string) {
	m.uint16_to_string = &s
}

// Uint16ToString returns the value of the "uint16_to_string" field in the mutation.
func (m *ConversionMutation) Uint16ToString() (r string, exists bool) {
	v := m.uint16_to_string
	if v == nil {
		return
	}
	return *v, true
}

// OldUint16ToString returns the old "uint16_to_string" field's value of the Conversion entity.
// If the Conversion object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ConversionMutation) OldUint16ToString(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldUint16ToString is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldUint16ToString requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUint16ToString: %w", err)
	}
	return oldValue.Uint16ToString, nil
}

// ClearUint16ToString clears the value of the "uint16_to_string" field.
func (m *ConversionMutation) ClearUint16ToString() {
	m.uint16_to_string = nil
	m.clearedFields[conversion.FieldUint16ToString] = struct{}{}
}

// Uint16ToStringCleared returns if the "uint16_to_string" field was cleared in this mutation.
func (m *ConversionMutation) Uint16ToStringCleared() bool {
	_, ok := m.clearedFields[conversion.FieldUint16ToString]
	return ok
}

// ResetUint16ToString resets all changes to the "uint16_to_string" field.
func (m *ConversionMutation) ResetUint16ToString() {
	m.uint16_to_string = nil
	delete(m.clearedFields, conversion.FieldUint16ToString)
}

// SetInt32ToString sets the "int32_to_string" field.
func (m *ConversionMutation) SetInt32ToString(s string) {
	m.int32_to_string = &s
}

// Int32ToString returns the value of the "int32_to_string" field in the mutation.
func (m *ConversionMutation) Int32ToString() (r string, exists bool) {
	v := m.int32_to_string
	if v == nil {
		return
	}
	return *v, true
}

// OldInt32ToString returns the old "int32_to_string" field's value of the Conversion entity.
// If the Conversion object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ConversionMutation) OldInt32ToString(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldInt32ToString is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldInt32ToString requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldInt32ToString: %w", err)
	}
	return oldValue.Int32ToString, nil
}

// ClearInt32ToString clears the value of the "int32_to_string" field.
func (m *ConversionMutation) ClearInt32ToString() {
	m.int32_to_string = nil
	m.clearedFields[conversion.FieldInt32ToString] = struct{}{}
}

// Int32ToStringCleared returns if the "int32_to_string" field was cleared in this mutation.
func (m *ConversionMutation) Int32ToStringCleared() bool {
	_, ok := m.clearedFields[conversion.FieldInt32ToString]
	return ok
}

// ResetInt32ToString resets all changes to the "int32_to_string" field.
func (m *ConversionMutation) ResetInt32ToString() {
	m.int32_to_string = nil
	delete(m.clearedFields, conversion.FieldInt32ToString)
}

// SetUint32ToString sets the "uint32_to_string" field.
func (m *ConversionMutation) SetUint32ToString(s string) {
	m.uint32_to_string = &s
}

// Uint32ToString returns the value of the "uint32_to_string" field in the mutation.
func (m *ConversionMutation) Uint32ToString() (r string, exists bool) {
	v := m.uint32_to_string
	if v == nil {
		return
	}
	return *v, true
}

// OldUint32ToString returns the old "uint32_to_string" field's value of the Conversion entity.
// If the Conversion object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ConversionMutation) OldUint32ToString(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldUint32ToString is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldUint32ToString requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUint32ToString: %w", err)
	}
	return oldValue.Uint32ToString, nil
}

// ClearUint32ToString clears the value of the "uint32_to_string" field.
func (m *ConversionMutation) ClearUint32ToString() {
	m.uint32_to_string = nil
	m.clearedFields[conversion.FieldUint32ToString] = struct{}{}
}

// Uint32ToStringCleared returns if the "uint32_to_string" field was cleared in this mutation.
func (m *ConversionMutation) Uint32ToStringCleared() bool {
	_, ok := m.clearedFields[conversion.FieldUint32ToString]
	return ok
}

// ResetUint32ToString resets all changes to the "uint32_to_string" field.
func (m *ConversionMutation) ResetUint32ToString() {
	m.uint32_to_string = nil
	delete(m.clearedFields, conversion.FieldUint32ToString)
}

// SetInt64ToString sets the "int64_to_string" field.
func (m *ConversionMutation) SetInt64ToString(s string) {
	m.int64_to_string = &s
}

// Int64ToString returns the value of the "int64_to_string" field in the mutation.
func (m *ConversionMutation) Int64ToString() (r string, exists bool) {
	v := m.int64_to_string
	if v == nil {
		return
	}
	return *v, true
}

// OldInt64ToString returns the old "int64_to_string" field's value of the Conversion entity.
// If the Conversion object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ConversionMutation) OldInt64ToString(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldInt64ToString is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldInt64ToString requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldInt64ToString: %w", err)
	}
	return oldValue.Int64ToString, nil
}

// ClearInt64ToString clears the value of the "int64_to_string" field.
func (m *ConversionMutation) ClearInt64ToString() {
	m.int64_to_string = nil
	m.clearedFields[conversion.FieldInt64ToString] = struct{}{}
}

// Int64ToStringCleared returns if the "int64_to_string" field was cleared in this mutation.
func (m *ConversionMutation) Int64ToStringCleared() bool {
	_, ok := m.clearedFields[conversion.FieldInt64ToString]
	return ok
}

// ResetInt64ToString resets all changes to the "int64_to_string" field.
func (m *ConversionMutation) ResetInt64ToString() {
	m.int64_to_string = nil
	delete(m.clearedFields, conversion.FieldInt64ToString)
}

// SetUint64ToString sets the "uint64_to_string" field.
func (m *ConversionMutation) SetUint64ToString(s string) {
	m.uint64_to_string = &s
}

// Uint64ToString returns the value of the "uint64_to_string" field in the mutation.
func (m *ConversionMutation) Uint64ToString() (r string, exists bool) {
	v := m.uint64_to_string
	if v == nil {
		return
	}
	return *v, true
}

// OldUint64ToString returns the old "uint64_to_string" field's value of the Conversion entity.
// If the Conversion object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ConversionMutation) OldUint64ToString(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldUint64ToString is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldUint64ToString requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUint64ToString: %w", err)
	}
	return oldValue.Uint64ToString, nil
}

// ClearUint64ToString clears the value of the "uint64_to_string" field.
func (m *ConversionMutation) ClearUint64ToString() {
	m.uint64_to_string = nil
	m.clearedFields[conversion.FieldUint64ToString] = struct{}{}
}

// Uint64ToStringCleared returns if the "uint64_to_string" field was cleared in this mutation.
func (m *ConversionMutation) Uint64ToStringCleared() bool {
	_, ok := m.clearedFields[conversion.FieldUint64ToString]
	return ok
}

// ResetUint64ToString resets all changes to the "uint64_to_string" field.
func (m *ConversionMutation) ResetUint64ToString() {
	m.uint64_to_string = nil
	delete(m.clearedFields, conversion.FieldUint64ToString)
}

// Where appends a list predicates to the ConversionMutation builder.
func (m *ConversionMutation) Where(ps ...predicate.Conversion) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *ConversionMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Conversion).
func (m *ConversionMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *ConversionMutation) Fields() []string {
	fields := make([]string, 0, 9)
	if m.name != nil {
		fields = append(fields, conversion.FieldName)
	}
	if m.int8_to_string != nil {
		fields = append(fields, conversion.FieldInt8ToString)
	}
	if m.uint8_to_string != nil {
		fields = append(fields, conversion.FieldUint8ToString)
	}
	if m.int16_to_string != nil {
		fields = append(fields, conversion.FieldInt16ToString)
	}
	if m.uint16_to_string != nil {
		fields = append(fields, conversion.FieldUint16ToString)
	}
	if m.int32_to_string != nil {
		fields = append(fields, conversion.FieldInt32ToString)
	}
	if m.uint32_to_string != nil {
		fields = append(fields, conversion.FieldUint32ToString)
	}
	if m.int64_to_string != nil {
		fields = append(fields, conversion.FieldInt64ToString)
	}
	if m.uint64_to_string != nil {
		fields = append(fields, conversion.FieldUint64ToString)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *ConversionMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case conversion.FieldName:
		return m.Name()
	case conversion.FieldInt8ToString:
		return m.Int8ToString()
	case conversion.FieldUint8ToString:
		return m.Uint8ToString()
	case conversion.FieldInt16ToString:
		return m.Int16ToString()
	case conversion.FieldUint16ToString:
		return m.Uint16ToString()
	case conversion.FieldInt32ToString:
		return m.Int32ToString()
	case conversion.FieldUint32ToString:
		return m.Uint32ToString()
	case conversion.FieldInt64ToString:
		return m.Int64ToString()
	case conversion.FieldUint64ToString:
		return m.Uint64ToString()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *ConversionMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case conversion.FieldName:
		return m.OldName(ctx)
	case conversion.FieldInt8ToString:
		return m.OldInt8ToString(ctx)
	case conversion.FieldUint8ToString:
		return m.OldUint8ToString(ctx)
	case conversion.FieldInt16ToString:
		return m.OldInt16ToString(ctx)
	case conversion.FieldUint16ToString:
		return m.OldUint16ToString(ctx)
	case conversion.FieldInt32ToString:
		return m.OldInt32ToString(ctx)
	case conversion.FieldUint32ToString:
		return m.OldUint32ToString(ctx)
	case conversion.FieldInt64ToString:
		return m.OldInt64ToString(ctx)
	case conversion.FieldUint64ToString:
		return m.OldUint64ToString(ctx)
	}
	return nil, fmt.Errorf("unknown Conversion field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ConversionMutation) SetField(name string, value ent.Value) error {
	switch name {
	case conversion.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case conversion.FieldInt8ToString:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetInt8ToString(v)
		return nil
	case conversion.FieldUint8ToString:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUint8ToString(v)
		return nil
	case conversion.FieldInt16ToString:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetInt16ToString(v)
		return nil
	case conversion.FieldUint16ToString:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUint16ToString(v)
		return nil
	case conversion.FieldInt32ToString:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetInt32ToString(v)
		return nil
	case conversion.FieldUint32ToString:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUint32ToString(v)
		return nil
	case conversion.FieldInt64ToString:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetInt64ToString(v)
		return nil
	case conversion.FieldUint64ToString:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUint64ToString(v)
		return nil
	}
	return fmt.Errorf("unknown Conversion field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *ConversionMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *ConversionMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ConversionMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Conversion numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *ConversionMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(conversion.FieldName) {
		fields = append(fields, conversion.FieldName)
	}
	if m.FieldCleared(conversion.FieldInt8ToString) {
		fields = append(fields, conversion.FieldInt8ToString)
	}
	if m.FieldCleared(conversion.FieldUint8ToString) {
		fields = append(fields, conversion.FieldUint8ToString)
	}
	if m.FieldCleared(conversion.FieldInt16ToString) {
		fields = append(fields, conversion.FieldInt16ToString)
	}
	if m.FieldCleared(conversion.FieldUint16ToString) {
		fields = append(fields, conversion.FieldUint16ToString)
	}
	if m.FieldCleared(conversion.FieldInt32ToString) {
		fields = append(fields, conversion.FieldInt32ToString)
	}
	if m.FieldCleared(conversion.FieldUint32ToString) {
		fields = append(fields, conversion.FieldUint32ToString)
	}
	if m.FieldCleared(conversion.FieldInt64ToString) {
		fields = append(fields, conversion.FieldInt64ToString)
	}
	if m.FieldCleared(conversion.FieldUint64ToString) {
		fields = append(fields, conversion.FieldUint64ToString)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *ConversionMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *ConversionMutation) ClearField(name string) error {
	switch name {
	case conversion.FieldName:
		m.ClearName()
		return nil
	case conversion.FieldInt8ToString:
		m.ClearInt8ToString()
		return nil
	case conversion.FieldUint8ToString:
		m.ClearUint8ToString()
		return nil
	case conversion.FieldInt16ToString:
		m.ClearInt16ToString()
		return nil
	case conversion.FieldUint16ToString:
		m.ClearUint16ToString()
		return nil
	case conversion.FieldInt32ToString:
		m.ClearInt32ToString()
		return nil
	case conversion.FieldUint32ToString:
		m.ClearUint32ToString()
		return nil
	case conversion.FieldInt64ToString:
		m.ClearInt64ToString()
		return nil
	case conversion.FieldUint64ToString:
		m.ClearUint64ToString()
		return nil
	}
	return fmt.Errorf("unknown Conversion nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *ConversionMutation) ResetField(name string) error {
	switch name {
	case conversion.FieldName:
		m.ResetName()
		return nil
	case conversion.FieldInt8ToString:
		m.ResetInt8ToString()
		return nil
	case conversion.FieldUint8ToString:
		m.ResetUint8ToString()
		return nil
	case conversion.FieldInt16ToString:
		m.ResetInt16ToString()
		return nil
	case conversion.FieldUint16ToString:
		m.ResetUint16ToString()
		return nil
	case conversion.FieldInt32ToString:
		m.ResetInt32ToString()
		return nil
	case conversion.FieldUint32ToString:
		m.ResetUint32ToString()
		return nil
	case conversion.FieldInt64ToString:
		m.ResetInt64ToString()
		return nil
	case conversion.FieldUint64ToString:
		m.ResetUint64ToString()
		return nil
	}
	return fmt.Errorf("unknown Conversion field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *ConversionMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *ConversionMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *ConversionMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *ConversionMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *ConversionMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *ConversionMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *ConversionMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown Conversion unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *ConversionMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown Conversion edge %s", name)
}

// CustomTypeMutation represents an operation that mutates the CustomType nodes in the graph.
type CustomTypeMutation struct {
	config
	op            Op
	typ           string
	id            *int
	custom        *string
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*CustomType, error)
	predicates    []predicate.CustomType
}

var _ ent.Mutation = (*CustomTypeMutation)(nil)

// customtypeOption allows management of the mutation configuration using functional options.
type customtypeOption func(*CustomTypeMutation)

// newCustomTypeMutation creates new mutation for the CustomType entity.
func newCustomTypeMutation(c config, op Op, opts ...customtypeOption) *CustomTypeMutation {
	m := &CustomTypeMutation{
		config:        c,
		op:            op,
		typ:           TypeCustomType,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withCustomTypeID sets the ID field of the mutation.
func withCustomTypeID(id int) customtypeOption {
	return func(m *CustomTypeMutation) {
		var (
			err   error
			once  sync.Once
			value *CustomType
		)
		m.oldValue = func(ctx context.Context) (*CustomType, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().CustomType.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withCustomType sets the old CustomType of the mutation.
func withCustomType(node *CustomType) customtypeOption {
	return func(m *CustomTypeMutation) {
		m.oldValue = func(context.Context) (*CustomType, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m CustomTypeMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m CustomTypeMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("entv2: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *CustomTypeMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetCustom sets the "custom" field.
func (m *CustomTypeMutation) SetCustom(s string) {
	m.custom = &s
}

// Custom returns the value of the "custom" field in the mutation.
func (m *CustomTypeMutation) Custom() (r string, exists bool) {
	v := m.custom
	if v == nil {
		return
	}
	return *v, true
}

// OldCustom returns the old "custom" field's value of the CustomType entity.
// If the CustomType object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *CustomTypeMutation) OldCustom(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldCustom is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldCustom requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCustom: %w", err)
	}
	return oldValue.Custom, nil
}

// ClearCustom clears the value of the "custom" field.
func (m *CustomTypeMutation) ClearCustom() {
	m.custom = nil
	m.clearedFields[customtype.FieldCustom] = struct{}{}
}

// CustomCleared returns if the "custom" field was cleared in this mutation.
func (m *CustomTypeMutation) CustomCleared() bool {
	_, ok := m.clearedFields[customtype.FieldCustom]
	return ok
}

// ResetCustom resets all changes to the "custom" field.
func (m *CustomTypeMutation) ResetCustom() {
	m.custom = nil
	delete(m.clearedFields, customtype.FieldCustom)
}

// Where appends a list predicates to the CustomTypeMutation builder.
func (m *CustomTypeMutation) Where(ps ...predicate.CustomType) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *CustomTypeMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (CustomType).
func (m *CustomTypeMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *CustomTypeMutation) Fields() []string {
	fields := make([]string, 0, 1)
	if m.custom != nil {
		fields = append(fields, customtype.FieldCustom)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *CustomTypeMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case customtype.FieldCustom:
		return m.Custom()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *CustomTypeMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case customtype.FieldCustom:
		return m.OldCustom(ctx)
	}
	return nil, fmt.Errorf("unknown CustomType field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *CustomTypeMutation) SetField(name string, value ent.Value) error {
	switch name {
	case customtype.FieldCustom:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCustom(v)
		return nil
	}
	return fmt.Errorf("unknown CustomType field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *CustomTypeMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *CustomTypeMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *CustomTypeMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown CustomType numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *CustomTypeMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(customtype.FieldCustom) {
		fields = append(fields, customtype.FieldCustom)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *CustomTypeMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *CustomTypeMutation) ClearField(name string) error {
	switch name {
	case customtype.FieldCustom:
		m.ClearCustom()
		return nil
	}
	return fmt.Errorf("unknown CustomType nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *CustomTypeMutation) ResetField(name string) error {
	switch name {
	case customtype.FieldCustom:
		m.ResetCustom()
		return nil
	}
	return fmt.Errorf("unknown CustomType field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *CustomTypeMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *CustomTypeMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *CustomTypeMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *CustomTypeMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *CustomTypeMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *CustomTypeMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *CustomTypeMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown CustomType unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *CustomTypeMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown CustomType edge %s", name)
}

// GroupMutation represents an operation that mutates the Group nodes in the graph.
type GroupMutation struct {
	config
	op            Op
	typ           string
	id            *int
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*Group, error)
	predicates    []predicate.Group
}

var _ ent.Mutation = (*GroupMutation)(nil)

// groupOption allows management of the mutation configuration using functional options.
type groupOption func(*GroupMutation)

// newGroupMutation creates new mutation for the Group entity.
func newGroupMutation(c config, op Op, opts ...groupOption) *GroupMutation {
	m := &GroupMutation{
		config:        c,
		op:            op,
		typ:           TypeGroup,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withGroupID sets the ID field of the mutation.
func withGroupID(id int) groupOption {
	return func(m *GroupMutation) {
		var (
			err   error
			once  sync.Once
			value *Group
		)
		m.oldValue = func(ctx context.Context) (*Group, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Group.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withGroup sets the old Group of the mutation.
func withGroup(node *Group) groupOption {
	return func(m *GroupMutation) {
		m.oldValue = func(context.Context) (*Group, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m GroupMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m GroupMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("entv2: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *GroupMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// Where appends a list predicates to the GroupMutation builder.
func (m *GroupMutation) Where(ps ...predicate.Group) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *GroupMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Group).
func (m *GroupMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *GroupMutation) Fields() []string {
	fields := make([]string, 0, 0)
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *GroupMutation) Field(name string) (ent.Value, bool) {
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *GroupMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	return nil, fmt.Errorf("unknown Group field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *GroupMutation) SetField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Group field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *GroupMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *GroupMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *GroupMutation) AddField(name string, value ent.Value) error {
	return fmt.Errorf("unknown Group numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *GroupMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *GroupMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *GroupMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Group nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *GroupMutation) ResetField(name string) error {
	return fmt.Errorf("unknown Group field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *GroupMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *GroupMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *GroupMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *GroupMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *GroupMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *GroupMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *GroupMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown Group unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *GroupMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown Group edge %s", name)
}

// MediaMutation represents an operation that mutates the Media nodes in the graph.
type MediaMutation struct {
	config
	op            Op
	typ           string
	id            *int
	source        *string
	source_uri    *string
	text          *string
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*Media, error)
	predicates    []predicate.Media
}

var _ ent.Mutation = (*MediaMutation)(nil)

// mediaOption allows management of the mutation configuration using functional options.
type mediaOption func(*MediaMutation)

// newMediaMutation creates new mutation for the Media entity.
func newMediaMutation(c config, op Op, opts ...mediaOption) *MediaMutation {
	m := &MediaMutation{
		config:        c,
		op:            op,
		typ:           TypeMedia,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withMediaID sets the ID field of the mutation.
func withMediaID(id int) mediaOption {
	return func(m *MediaMutation) {
		var (
			err   error
			once  sync.Once
			value *Media
		)
		m.oldValue = func(ctx context.Context) (*Media, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Media.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withMedia sets the old Media of the mutation.
func withMedia(node *Media) mediaOption {
	return func(m *MediaMutation) {
		m.oldValue = func(context.Context) (*Media, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m MediaMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m MediaMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("entv2: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *MediaMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetSource sets the "source" field.
func (m *MediaMutation) SetSource(s string) {
	m.source = &s
}

// Source returns the value of the "source" field in the mutation.
func (m *MediaMutation) Source() (r string, exists bool) {
	v := m.source
	if v == nil {
		return
	}
	return *v, true
}

// OldSource returns the old "source" field's value of the Media entity.
// If the Media object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MediaMutation) OldSource(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldSource is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldSource requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSource: %w", err)
	}
	return oldValue.Source, nil
}

// ClearSource clears the value of the "source" field.
func (m *MediaMutation) ClearSource() {
	m.source = nil
	m.clearedFields[media.FieldSource] = struct{}{}
}

// SourceCleared returns if the "source" field was cleared in this mutation.
func (m *MediaMutation) SourceCleared() bool {
	_, ok := m.clearedFields[media.FieldSource]
	return ok
}

// ResetSource resets all changes to the "source" field.
func (m *MediaMutation) ResetSource() {
	m.source = nil
	delete(m.clearedFields, media.FieldSource)
}

// SetSourceURI sets the "source_uri" field.
func (m *MediaMutation) SetSourceURI(s string) {
	m.source_uri = &s
}

// SourceURI returns the value of the "source_uri" field in the mutation.
func (m *MediaMutation) SourceURI() (r string, exists bool) {
	v := m.source_uri
	if v == nil {
		return
	}
	return *v, true
}

// OldSourceURI returns the old "source_uri" field's value of the Media entity.
// If the Media object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MediaMutation) OldSourceURI(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldSourceURI is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldSourceURI requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSourceURI: %w", err)
	}
	return oldValue.SourceURI, nil
}

// ClearSourceURI clears the value of the "source_uri" field.
func (m *MediaMutation) ClearSourceURI() {
	m.source_uri = nil
	m.clearedFields[media.FieldSourceURI] = struct{}{}
}

// SourceURICleared returns if the "source_uri" field was cleared in this mutation.
func (m *MediaMutation) SourceURICleared() bool {
	_, ok := m.clearedFields[media.FieldSourceURI]
	return ok
}

// ResetSourceURI resets all changes to the "source_uri" field.
func (m *MediaMutation) ResetSourceURI() {
	m.source_uri = nil
	delete(m.clearedFields, media.FieldSourceURI)
}

// SetText sets the "text" field.
func (m *MediaMutation) SetText(s string) {
	m.text = &s
}

// Text returns the value of the "text" field in the mutation.
func (m *MediaMutation) Text() (r string, exists bool) {
	v := m.text
	if v == nil {
		return
	}
	return *v, true
}

// OldText returns the old "text" field's value of the Media entity.
// If the Media object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *MediaMutation) OldText(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldText is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldText requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldText: %w", err)
	}
	return oldValue.Text, nil
}

// ClearText clears the value of the "text" field.
func (m *MediaMutation) ClearText() {
	m.text = nil
	m.clearedFields[media.FieldText] = struct{}{}
}

// TextCleared returns if the "text" field was cleared in this mutation.
func (m *MediaMutation) TextCleared() bool {
	_, ok := m.clearedFields[media.FieldText]
	return ok
}

// ResetText resets all changes to the "text" field.
func (m *MediaMutation) ResetText() {
	m.text = nil
	delete(m.clearedFields, media.FieldText)
}

// Where appends a list predicates to the MediaMutation builder.
func (m *MediaMutation) Where(ps ...predicate.Media) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *MediaMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Media).
func (m *MediaMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *MediaMutation) Fields() []string {
	fields := make([]string, 0, 3)
	if m.source != nil {
		fields = append(fields, media.FieldSource)
	}
	if m.source_uri != nil {
		fields = append(fields, media.FieldSourceURI)
	}
	if m.text != nil {
		fields = append(fields, media.FieldText)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *MediaMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case media.FieldSource:
		return m.Source()
	case media.FieldSourceURI:
		return m.SourceURI()
	case media.FieldText:
		return m.Text()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *MediaMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case media.FieldSource:
		return m.OldSource(ctx)
	case media.FieldSourceURI:
		return m.OldSourceURI(ctx)
	case media.FieldText:
		return m.OldText(ctx)
	}
	return nil, fmt.Errorf("unknown Media field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MediaMutation) SetField(name string, value ent.Value) error {
	switch name {
	case media.FieldSource:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSource(v)
		return nil
	case media.FieldSourceURI:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSourceURI(v)
		return nil
	case media.FieldText:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetText(v)
		return nil
	}
	return fmt.Errorf("unknown Media field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *MediaMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *MediaMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *MediaMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Media numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *MediaMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(media.FieldSource) {
		fields = append(fields, media.FieldSource)
	}
	if m.FieldCleared(media.FieldSourceURI) {
		fields = append(fields, media.FieldSourceURI)
	}
	if m.FieldCleared(media.FieldText) {
		fields = append(fields, media.FieldText)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *MediaMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *MediaMutation) ClearField(name string) error {
	switch name {
	case media.FieldSource:
		m.ClearSource()
		return nil
	case media.FieldSourceURI:
		m.ClearSourceURI()
		return nil
	case media.FieldText:
		m.ClearText()
		return nil
	}
	return fmt.Errorf("unknown Media nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *MediaMutation) ResetField(name string) error {
	switch name {
	case media.FieldSource:
		m.ResetSource()
		return nil
	case media.FieldSourceURI:
		m.ResetSourceURI()
		return nil
	case media.FieldText:
		m.ResetText()
		return nil
	}
	return fmt.Errorf("unknown Media field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *MediaMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *MediaMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *MediaMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *MediaMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *MediaMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *MediaMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *MediaMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown Media unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *MediaMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown Media edge %s", name)
}

// PetMutation represents an operation that mutates the Pet nodes in the graph.
type PetMutation struct {
	config
	op            Op
	typ           string
	id            *int
	clearedFields map[string]struct{}
	owner         *int
	clearedowner  bool
	done          bool
	oldValue      func(context.Context) (*Pet, error)
	predicates    []predicate.Pet
}

var _ ent.Mutation = (*PetMutation)(nil)

// petOption allows management of the mutation configuration using functional options.
type petOption func(*PetMutation)

// newPetMutation creates new mutation for the Pet entity.
func newPetMutation(c config, op Op, opts ...petOption) *PetMutation {
	m := &PetMutation{
		config:        c,
		op:            op,
		typ:           TypePet,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withPetID sets the ID field of the mutation.
func withPetID(id int) petOption {
	return func(m *PetMutation) {
		var (
			err   error
			once  sync.Once
			value *Pet
		)
		m.oldValue = func(ctx context.Context) (*Pet, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Pet.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withPet sets the old Pet of the mutation.
func withPet(node *Pet) petOption {
	return func(m *PetMutation) {
		m.oldValue = func(context.Context) (*Pet, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m PetMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m PetMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("entv2: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *PetMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetOwnerID sets the "owner" edge to the User entity by id.
func (m *PetMutation) SetOwnerID(id int) {
	m.owner = &id
}

// ClearOwner clears the "owner" edge to the User entity.
func (m *PetMutation) ClearOwner() {
	m.clearedowner = true
}

// OwnerCleared reports if the "owner" edge to the User entity was cleared.
func (m *PetMutation) OwnerCleared() bool {
	return m.clearedowner
}

// OwnerID returns the "owner" edge ID in the mutation.
func (m *PetMutation) OwnerID() (id int, exists bool) {
	if m.owner != nil {
		return *m.owner, true
	}
	return
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *PetMutation) OwnerIDs() (ids []int) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *PetMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// Where appends a list predicates to the PetMutation builder.
func (m *PetMutation) Where(ps ...predicate.Pet) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *PetMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Pet).
func (m *PetMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *PetMutation) Fields() []string {
	fields := make([]string, 0, 0)
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *PetMutation) Field(name string) (ent.Value, bool) {
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *PetMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	return nil, fmt.Errorf("unknown Pet field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *PetMutation) SetField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Pet field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *PetMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *PetMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *PetMutation) AddField(name string, value ent.Value) error {
	return fmt.Errorf("unknown Pet numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *PetMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *PetMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *PetMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Pet nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *PetMutation) ResetField(name string) error {
	return fmt.Errorf("unknown Pet field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *PetMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.owner != nil {
		edges = append(edges, pet.EdgeOwner)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *PetMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case pet.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *PetMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *PetMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *PetMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedowner {
		edges = append(edges, pet.EdgeOwner)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *PetMutation) EdgeCleared(name string) bool {
	switch name {
	case pet.EdgeOwner:
		return m.clearedowner
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *PetMutation) ClearEdge(name string) error {
	switch name {
	case pet.EdgeOwner:
		m.ClearOwner()
		return nil
	}
	return fmt.Errorf("unknown Pet unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *PetMutation) ResetEdge(name string) error {
	switch name {
	case pet.EdgeOwner:
		m.ResetOwner()
		return nil
	}
	return fmt.Errorf("unknown Pet edge %s", name)
}

// UserMutation represents an operation that mutates the User nodes in the graph.
type UserMutation struct {
	config
	op             Op
	typ            string
	id             *int
	mixed_string   *string
	mixed_enum     *user.MixedEnum
	age            *int
	addage         *int
	name           *string
	description    *string
	nickname       *string
	phone          *string
	buffer         *[]byte
	title          *string
	new_name       *string
	blob           *[]byte
	state          *user.State
	status         *user.Status
	workplace      *string
	created_at     *time.Time
	clearedFields  map[string]struct{}
	car            map[int]struct{}
	removedcar     map[int]struct{}
	clearedcar     bool
	pets           *int
	clearedpets    bool
	friends        map[int]struct{}
	removedfriends map[int]struct{}
	clearedfriends bool
	done           bool
	oldValue       func(context.Context) (*User, error)
	predicates     []predicate.User
}

var _ ent.Mutation = (*UserMutation)(nil)

// userOption allows management of the mutation configuration using functional options.
type userOption func(*UserMutation)

// newUserMutation creates new mutation for the User entity.
func newUserMutation(c config, op Op, opts ...userOption) *UserMutation {
	m := &UserMutation{
		config:        c,
		op:            op,
		typ:           TypeUser,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withUserID sets the ID field of the mutation.
func withUserID(id int) userOption {
	return func(m *UserMutation) {
		var (
			err   error
			once  sync.Once
			value *User
		)
		m.oldValue = func(ctx context.Context) (*User, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().User.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withUser sets the old User of the mutation.
func withUser(node *User) userOption {
	return func(m *UserMutation) {
		m.oldValue = func(context.Context) (*User, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m UserMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m UserMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("entv2: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of User entities.
func (m *UserMutation) SetID(id int) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *UserMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetMixedString sets the "mixed_string" field.
func (m *UserMutation) SetMixedString(s string) {
	m.mixed_string = &s
}

// MixedString returns the value of the "mixed_string" field in the mutation.
func (m *UserMutation) MixedString() (r string, exists bool) {
	v := m.mixed_string
	if v == nil {
		return
	}
	return *v, true
}

// OldMixedString returns the old "mixed_string" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldMixedString(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldMixedString is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldMixedString requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldMixedString: %w", err)
	}
	return oldValue.MixedString, nil
}

// ResetMixedString resets all changes to the "mixed_string" field.
func (m *UserMutation) ResetMixedString() {
	m.mixed_string = nil
}

// SetMixedEnum sets the "mixed_enum" field.
func (m *UserMutation) SetMixedEnum(ue user.MixedEnum) {
	m.mixed_enum = &ue
}

// MixedEnum returns the value of the "mixed_enum" field in the mutation.
func (m *UserMutation) MixedEnum() (r user.MixedEnum, exists bool) {
	v := m.mixed_enum
	if v == nil {
		return
	}
	return *v, true
}

// OldMixedEnum returns the old "mixed_enum" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldMixedEnum(ctx context.Context) (v user.MixedEnum, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldMixedEnum is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldMixedEnum requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldMixedEnum: %w", err)
	}
	return oldValue.MixedEnum, nil
}

// ResetMixedEnum resets all changes to the "mixed_enum" field.
func (m *UserMutation) ResetMixedEnum() {
	m.mixed_enum = nil
}

// SetAge sets the "age" field.
func (m *UserMutation) SetAge(i int) {
	m.age = &i
	m.addage = nil
}

// Age returns the value of the "age" field in the mutation.
func (m *UserMutation) Age() (r int, exists bool) {
	v := m.age
	if v == nil {
		return
	}
	return *v, true
}

// OldAge returns the old "age" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldAge(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldAge is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldAge requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAge: %w", err)
	}
	return oldValue.Age, nil
}

// AddAge adds i to the "age" field.
func (m *UserMutation) AddAge(i int) {
	if m.addage != nil {
		*m.addage += i
	} else {
		m.addage = &i
	}
}

// AddedAge returns the value that was added to the "age" field in this mutation.
func (m *UserMutation) AddedAge() (r int, exists bool) {
	v := m.addage
	if v == nil {
		return
	}
	return *v, true
}

// ResetAge resets all changes to the "age" field.
func (m *UserMutation) ResetAge() {
	m.age = nil
	m.addage = nil
}

// SetName sets the "name" field.
func (m *UserMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *UserMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *UserMutation) ResetName() {
	m.name = nil
}

// SetDescription sets the "description" field.
func (m *UserMutation) SetDescription(s string) {
	m.description = &s
}

// Description returns the value of the "description" field in the mutation.
func (m *UserMutation) Description() (r string, exists bool) {
	v := m.description
	if v == nil {
		return
	}
	return *v, true
}

// OldDescription returns the old "description" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldDescription(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldDescription is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldDescription requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDescription: %w", err)
	}
	return oldValue.Description, nil
}

// ClearDescription clears the value of the "description" field.
func (m *UserMutation) ClearDescription() {
	m.description = nil
	m.clearedFields[user.FieldDescription] = struct{}{}
}

// DescriptionCleared returns if the "description" field was cleared in this mutation.
func (m *UserMutation) DescriptionCleared() bool {
	_, ok := m.clearedFields[user.FieldDescription]
	return ok
}

// ResetDescription resets all changes to the "description" field.
func (m *UserMutation) ResetDescription() {
	m.description = nil
	delete(m.clearedFields, user.FieldDescription)
}

// SetNickname sets the "nickname" field.
func (m *UserMutation) SetNickname(s string) {
	m.nickname = &s
}

// Nickname returns the value of the "nickname" field in the mutation.
func (m *UserMutation) Nickname() (r string, exists bool) {
	v := m.nickname
	if v == nil {
		return
	}
	return *v, true
}

// OldNickname returns the old "nickname" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldNickname(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNickname is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNickname requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNickname: %w", err)
	}
	return oldValue.Nickname, nil
}

// ResetNickname resets all changes to the "nickname" field.
func (m *UserMutation) ResetNickname() {
	m.nickname = nil
}

// SetPhone sets the "phone" field.
func (m *UserMutation) SetPhone(s string) {
	m.phone = &s
}

// Phone returns the value of the "phone" field in the mutation.
func (m *UserMutation) Phone() (r string, exists bool) {
	v := m.phone
	if v == nil {
		return
	}
	return *v, true
}

// OldPhone returns the old "phone" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldPhone(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldPhone is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldPhone requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPhone: %w", err)
	}
	return oldValue.Phone, nil
}

// ResetPhone resets all changes to the "phone" field.
func (m *UserMutation) ResetPhone() {
	m.phone = nil
}

// SetBuffer sets the "buffer" field.
func (m *UserMutation) SetBuffer(b []byte) {
	m.buffer = &b
}

// Buffer returns the value of the "buffer" field in the mutation.
func (m *UserMutation) Buffer() (r []byte, exists bool) {
	v := m.buffer
	if v == nil {
		return
	}
	return *v, true
}

// OldBuffer returns the old "buffer" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldBuffer(ctx context.Context) (v []byte, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldBuffer is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldBuffer requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldBuffer: %w", err)
	}
	return oldValue.Buffer, nil
}

// ClearBuffer clears the value of the "buffer" field.
func (m *UserMutation) ClearBuffer() {
	m.buffer = nil
	m.clearedFields[user.FieldBuffer] = struct{}{}
}

// BufferCleared returns if the "buffer" field was cleared in this mutation.
func (m *UserMutation) BufferCleared() bool {
	_, ok := m.clearedFields[user.FieldBuffer]
	return ok
}

// ResetBuffer resets all changes to the "buffer" field.
func (m *UserMutation) ResetBuffer() {
	m.buffer = nil
	delete(m.clearedFields, user.FieldBuffer)
}

// SetTitle sets the "title" field.
func (m *UserMutation) SetTitle(s string) {
	m.title = &s
}

// Title returns the value of the "title" field in the mutation.
func (m *UserMutation) Title() (r string, exists bool) {
	v := m.title
	if v == nil {
		return
	}
	return *v, true
}

// OldTitle returns the old "title" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldTitle(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldTitle is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldTitle requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldTitle: %w", err)
	}
	return oldValue.Title, nil
}

// ResetTitle resets all changes to the "title" field.
func (m *UserMutation) ResetTitle() {
	m.title = nil
}

// SetNewName sets the "new_name" field.
func (m *UserMutation) SetNewName(s string) {
	m.new_name = &s
}

// NewName returns the value of the "new_name" field in the mutation.
func (m *UserMutation) NewName() (r string, exists bool) {
	v := m.new_name
	if v == nil {
		return
	}
	return *v, true
}

// OldNewName returns the old "new_name" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldNewName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNewName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNewName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNewName: %w", err)
	}
	return oldValue.NewName, nil
}

// ClearNewName clears the value of the "new_name" field.
func (m *UserMutation) ClearNewName() {
	m.new_name = nil
	m.clearedFields[user.FieldNewName] = struct{}{}
}

// NewNameCleared returns if the "new_name" field was cleared in this mutation.
func (m *UserMutation) NewNameCleared() bool {
	_, ok := m.clearedFields[user.FieldNewName]
	return ok
}

// ResetNewName resets all changes to the "new_name" field.
func (m *UserMutation) ResetNewName() {
	m.new_name = nil
	delete(m.clearedFields, user.FieldNewName)
}

// SetBlob sets the "blob" field.
func (m *UserMutation) SetBlob(b []byte) {
	m.blob = &b
}

// Blob returns the value of the "blob" field in the mutation.
func (m *UserMutation) Blob() (r []byte, exists bool) {
	v := m.blob
	if v == nil {
		return
	}
	return *v, true
}

// OldBlob returns the old "blob" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldBlob(ctx context.Context) (v []byte, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldBlob is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldBlob requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldBlob: %w", err)
	}
	return oldValue.Blob, nil
}

// ClearBlob clears the value of the "blob" field.
func (m *UserMutation) ClearBlob() {
	m.blob = nil
	m.clearedFields[user.FieldBlob] = struct{}{}
}

// BlobCleared returns if the "blob" field was cleared in this mutation.
func (m *UserMutation) BlobCleared() bool {
	_, ok := m.clearedFields[user.FieldBlob]
	return ok
}

// ResetBlob resets all changes to the "blob" field.
func (m *UserMutation) ResetBlob() {
	m.blob = nil
	delete(m.clearedFields, user.FieldBlob)
}

// SetState sets the "state" field.
func (m *UserMutation) SetState(u user.State) {
	m.state = &u
}

// State returns the value of the "state" field in the mutation.
func (m *UserMutation) State() (r user.State, exists bool) {
	v := m.state
	if v == nil {
		return
	}
	return *v, true
}

// OldState returns the old "state" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldState(ctx context.Context) (v user.State, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldState is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldState requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldState: %w", err)
	}
	return oldValue.State, nil
}

// ClearState clears the value of the "state" field.
func (m *UserMutation) ClearState() {
	m.state = nil
	m.clearedFields[user.FieldState] = struct{}{}
}

// StateCleared returns if the "state" field was cleared in this mutation.
func (m *UserMutation) StateCleared() bool {
	_, ok := m.clearedFields[user.FieldState]
	return ok
}

// ResetState resets all changes to the "state" field.
func (m *UserMutation) ResetState() {
	m.state = nil
	delete(m.clearedFields, user.FieldState)
}

// SetStatus sets the "status" field.
func (m *UserMutation) SetStatus(u user.Status) {
	m.status = &u
}

// Status returns the value of the "status" field in the mutation.
func (m *UserMutation) Status() (r user.Status, exists bool) {
	v := m.status
	if v == nil {
		return
	}
	return *v, true
}

// OldStatus returns the old "status" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldStatus(ctx context.Context) (v user.Status, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldStatus is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldStatus requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStatus: %w", err)
	}
	return oldValue.Status, nil
}

// ClearStatus clears the value of the "status" field.
func (m *UserMutation) ClearStatus() {
	m.status = nil
	m.clearedFields[user.FieldStatus] = struct{}{}
}

// StatusCleared returns if the "status" field was cleared in this mutation.
func (m *UserMutation) StatusCleared() bool {
	_, ok := m.clearedFields[user.FieldStatus]
	return ok
}

// ResetStatus resets all changes to the "status" field.
func (m *UserMutation) ResetStatus() {
	m.status = nil
	delete(m.clearedFields, user.FieldStatus)
}

// SetWorkplace sets the "workplace" field.
func (m *UserMutation) SetWorkplace(s string) {
	m.workplace = &s
}

// Workplace returns the value of the "workplace" field in the mutation.
func (m *UserMutation) Workplace() (r string, exists bool) {
	v := m.workplace
	if v == nil {
		return
	}
	return *v, true
}

// OldWorkplace returns the old "workplace" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldWorkplace(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldWorkplace is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldWorkplace requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldWorkplace: %w", err)
	}
	return oldValue.Workplace, nil
}

// ClearWorkplace clears the value of the "workplace" field.
func (m *UserMutation) ClearWorkplace() {
	m.workplace = nil
	m.clearedFields[user.FieldWorkplace] = struct{}{}
}

// WorkplaceCleared returns if the "workplace" field was cleared in this mutation.
func (m *UserMutation) WorkplaceCleared() bool {
	_, ok := m.clearedFields[user.FieldWorkplace]
	return ok
}

// ResetWorkplace resets all changes to the "workplace" field.
func (m *UserMutation) ResetWorkplace() {
	m.workplace = nil
	delete(m.clearedFields, user.FieldWorkplace)
}

// SetCreatedAt sets the "created_at" field.
func (m *UserMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *UserMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *UserMutation) ResetCreatedAt() {
	m.created_at = nil
}

// AddCarIDs adds the "car" edge to the Car entity by ids.
func (m *UserMutation) AddCarIDs(ids ...int) {
	if m.car == nil {
		m.car = make(map[int]struct{})
	}
	for i := range ids {
		m.car[ids[i]] = struct{}{}
	}
}

// ClearCar clears the "car" edge to the Car entity.
func (m *UserMutation) ClearCar() {
	m.clearedcar = true
}

// CarCleared reports if the "car" edge to the Car entity was cleared.
func (m *UserMutation) CarCleared() bool {
	return m.clearedcar
}

// RemoveCarIDs removes the "car" edge to the Car entity by IDs.
func (m *UserMutation) RemoveCarIDs(ids ...int) {
	if m.removedcar == nil {
		m.removedcar = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.car, ids[i])
		m.removedcar[ids[i]] = struct{}{}
	}
}

// RemovedCar returns the removed IDs of the "car" edge to the Car entity.
func (m *UserMutation) RemovedCarIDs() (ids []int) {
	for id := range m.removedcar {
		ids = append(ids, id)
	}
	return
}

// CarIDs returns the "car" edge IDs in the mutation.
func (m *UserMutation) CarIDs() (ids []int) {
	for id := range m.car {
		ids = append(ids, id)
	}
	return
}

// ResetCar resets all changes to the "car" edge.
func (m *UserMutation) ResetCar() {
	m.car = nil
	m.clearedcar = false
	m.removedcar = nil
}

// SetPetsID sets the "pets" edge to the Pet entity by id.
func (m *UserMutation) SetPetsID(id int) {
	m.pets = &id
}

// ClearPets clears the "pets" edge to the Pet entity.
func (m *UserMutation) ClearPets() {
	m.clearedpets = true
}

// PetsCleared reports if the "pets" edge to the Pet entity was cleared.
func (m *UserMutation) PetsCleared() bool {
	return m.clearedpets
}

// PetsID returns the "pets" edge ID in the mutation.
func (m *UserMutation) PetsID() (id int, exists bool) {
	if m.pets != nil {
		return *m.pets, true
	}
	return
}

// PetsIDs returns the "pets" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// PetsID instead. It exists only for internal usage by the builders.
func (m *UserMutation) PetsIDs() (ids []int) {
	if id := m.pets; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetPets resets all changes to the "pets" edge.
func (m *UserMutation) ResetPets() {
	m.pets = nil
	m.clearedpets = false
}

// AddFriendIDs adds the "friends" edge to the User entity by ids.
func (m *UserMutation) AddFriendIDs(ids ...int) {
	if m.friends == nil {
		m.friends = make(map[int]struct{})
	}
	for i := range ids {
		m.friends[ids[i]] = struct{}{}
	}
}

// ClearFriends clears the "friends" edge to the User entity.
func (m *UserMutation) ClearFriends() {
	m.clearedfriends = true
}

// FriendsCleared reports if the "friends" edge to the User entity was cleared.
func (m *UserMutation) FriendsCleared() bool {
	return m.clearedfriends
}

// RemoveFriendIDs removes the "friends" edge to the User entity by IDs.
func (m *UserMutation) RemoveFriendIDs(ids ...int) {
	if m.removedfriends == nil {
		m.removedfriends = make(map[int]struct{})
	}
	for i := range ids {
		delete(m.friends, ids[i])
		m.removedfriends[ids[i]] = struct{}{}
	}
}

// RemovedFriends returns the removed IDs of the "friends" edge to the User entity.
func (m *UserMutation) RemovedFriendsIDs() (ids []int) {
	for id := range m.removedfriends {
		ids = append(ids, id)
	}
	return
}

// FriendsIDs returns the "friends" edge IDs in the mutation.
func (m *UserMutation) FriendsIDs() (ids []int) {
	for id := range m.friends {
		ids = append(ids, id)
	}
	return
}

// ResetFriends resets all changes to the "friends" edge.
func (m *UserMutation) ResetFriends() {
	m.friends = nil
	m.clearedfriends = false
	m.removedfriends = nil
}

// Where appends a list predicates to the UserMutation builder.
func (m *UserMutation) Where(ps ...predicate.User) {
	m.predicates = append(m.predicates, ps...)
}

// Op returns the operation name.
func (m *UserMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (User).
func (m *UserMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *UserMutation) Fields() []string {
	fields := make([]string, 0, 15)
	if m.mixed_string != nil {
		fields = append(fields, user.FieldMixedString)
	}
	if m.mixed_enum != nil {
		fields = append(fields, user.FieldMixedEnum)
	}
	if m.age != nil {
		fields = append(fields, user.FieldAge)
	}
	if m.name != nil {
		fields = append(fields, user.FieldName)
	}
	if m.description != nil {
		fields = append(fields, user.FieldDescription)
	}
	if m.nickname != nil {
		fields = append(fields, user.FieldNickname)
	}
	if m.phone != nil {
		fields = append(fields, user.FieldPhone)
	}
	if m.buffer != nil {
		fields = append(fields, user.FieldBuffer)
	}
	if m.title != nil {
		fields = append(fields, user.FieldTitle)
	}
	if m.new_name != nil {
		fields = append(fields, user.FieldNewName)
	}
	if m.blob != nil {
		fields = append(fields, user.FieldBlob)
	}
	if m.state != nil {
		fields = append(fields, user.FieldState)
	}
	if m.status != nil {
		fields = append(fields, user.FieldStatus)
	}
	if m.workplace != nil {
		fields = append(fields, user.FieldWorkplace)
	}
	if m.created_at != nil {
		fields = append(fields, user.FieldCreatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *UserMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case user.FieldMixedString:
		return m.MixedString()
	case user.FieldMixedEnum:
		return m.MixedEnum()
	case user.FieldAge:
		return m.Age()
	case user.FieldName:
		return m.Name()
	case user.FieldDescription:
		return m.Description()
	case user.FieldNickname:
		return m.Nickname()
	case user.FieldPhone:
		return m.Phone()
	case user.FieldBuffer:
		return m.Buffer()
	case user.FieldTitle:
		return m.Title()
	case user.FieldNewName:
		return m.NewName()
	case user.FieldBlob:
		return m.Blob()
	case user.FieldState:
		return m.State()
	case user.FieldStatus:
		return m.Status()
	case user.FieldWorkplace:
		return m.Workplace()
	case user.FieldCreatedAt:
		return m.CreatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *UserMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case user.FieldMixedString:
		return m.OldMixedString(ctx)
	case user.FieldMixedEnum:
		return m.OldMixedEnum(ctx)
	case user.FieldAge:
		return m.OldAge(ctx)
	case user.FieldName:
		return m.OldName(ctx)
	case user.FieldDescription:
		return m.OldDescription(ctx)
	case user.FieldNickname:
		return m.OldNickname(ctx)
	case user.FieldPhone:
		return m.OldPhone(ctx)
	case user.FieldBuffer:
		return m.OldBuffer(ctx)
	case user.FieldTitle:
		return m.OldTitle(ctx)
	case user.FieldNewName:
		return m.OldNewName(ctx)
	case user.FieldBlob:
		return m.OldBlob(ctx)
	case user.FieldState:
		return m.OldState(ctx)
	case user.FieldStatus:
		return m.OldStatus(ctx)
	case user.FieldWorkplace:
		return m.OldWorkplace(ctx)
	case user.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown User field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserMutation) SetField(name string, value ent.Value) error {
	switch name {
	case user.FieldMixedString:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetMixedString(v)
		return nil
	case user.FieldMixedEnum:
		v, ok := value.(user.MixedEnum)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetMixedEnum(v)
		return nil
	case user.FieldAge:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAge(v)
		return nil
	case user.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case user.FieldDescription:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDescription(v)
		return nil
	case user.FieldNickname:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNickname(v)
		return nil
	case user.FieldPhone:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPhone(v)
		return nil
	case user.FieldBuffer:
		v, ok := value.([]byte)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetBuffer(v)
		return nil
	case user.FieldTitle:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetTitle(v)
		return nil
	case user.FieldNewName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNewName(v)
		return nil
	case user.FieldBlob:
		v, ok := value.([]byte)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetBlob(v)
		return nil
	case user.FieldState:
		v, ok := value.(user.State)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetState(v)
		return nil
	case user.FieldStatus:
		v, ok := value.(user.Status)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStatus(v)
		return nil
	case user.FieldWorkplace:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetWorkplace(v)
		return nil
	case user.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown User field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *UserMutation) AddedFields() []string {
	var fields []string
	if m.addage != nil {
		fields = append(fields, user.FieldAge)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *UserMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case user.FieldAge:
		return m.AddedAge()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserMutation) AddField(name string, value ent.Value) error {
	switch name {
	case user.FieldAge:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddAge(v)
		return nil
	}
	return fmt.Errorf("unknown User numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *UserMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(user.FieldDescription) {
		fields = append(fields, user.FieldDescription)
	}
	if m.FieldCleared(user.FieldBuffer) {
		fields = append(fields, user.FieldBuffer)
	}
	if m.FieldCleared(user.FieldNewName) {
		fields = append(fields, user.FieldNewName)
	}
	if m.FieldCleared(user.FieldBlob) {
		fields = append(fields, user.FieldBlob)
	}
	if m.FieldCleared(user.FieldState) {
		fields = append(fields, user.FieldState)
	}
	if m.FieldCleared(user.FieldStatus) {
		fields = append(fields, user.FieldStatus)
	}
	if m.FieldCleared(user.FieldWorkplace) {
		fields = append(fields, user.FieldWorkplace)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *UserMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *UserMutation) ClearField(name string) error {
	switch name {
	case user.FieldDescription:
		m.ClearDescription()
		return nil
	case user.FieldBuffer:
		m.ClearBuffer()
		return nil
	case user.FieldNewName:
		m.ClearNewName()
		return nil
	case user.FieldBlob:
		m.ClearBlob()
		return nil
	case user.FieldState:
		m.ClearState()
		return nil
	case user.FieldStatus:
		m.ClearStatus()
		return nil
	case user.FieldWorkplace:
		m.ClearWorkplace()
		return nil
	}
	return fmt.Errorf("unknown User nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *UserMutation) ResetField(name string) error {
	switch name {
	case user.FieldMixedString:
		m.ResetMixedString()
		return nil
	case user.FieldMixedEnum:
		m.ResetMixedEnum()
		return nil
	case user.FieldAge:
		m.ResetAge()
		return nil
	case user.FieldName:
		m.ResetName()
		return nil
	case user.FieldDescription:
		m.ResetDescription()
		return nil
	case user.FieldNickname:
		m.ResetNickname()
		return nil
	case user.FieldPhone:
		m.ResetPhone()
		return nil
	case user.FieldBuffer:
		m.ResetBuffer()
		return nil
	case user.FieldTitle:
		m.ResetTitle()
		return nil
	case user.FieldNewName:
		m.ResetNewName()
		return nil
	case user.FieldBlob:
		m.ResetBlob()
		return nil
	case user.FieldState:
		m.ResetState()
		return nil
	case user.FieldStatus:
		m.ResetStatus()
		return nil
	case user.FieldWorkplace:
		m.ResetWorkplace()
		return nil
	case user.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	}
	return fmt.Errorf("unknown User field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *UserMutation) AddedEdges() []string {
	edges := make([]string, 0, 3)
	if m.car != nil {
		edges = append(edges, user.EdgeCar)
	}
	if m.pets != nil {
		edges = append(edges, user.EdgePets)
	}
	if m.friends != nil {
		edges = append(edges, user.EdgeFriends)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *UserMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case user.EdgeCar:
		ids := make([]ent.Value, 0, len(m.car))
		for id := range m.car {
			ids = append(ids, id)
		}
		return ids
	case user.EdgePets:
		if id := m.pets; id != nil {
			return []ent.Value{*id}
		}
	case user.EdgeFriends:
		ids := make([]ent.Value, 0, len(m.friends))
		for id := range m.friends {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *UserMutation) RemovedEdges() []string {
	edges := make([]string, 0, 3)
	if m.removedcar != nil {
		edges = append(edges, user.EdgeCar)
	}
	if m.removedfriends != nil {
		edges = append(edges, user.EdgeFriends)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *UserMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case user.EdgeCar:
		ids := make([]ent.Value, 0, len(m.removedcar))
		for id := range m.removedcar {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeFriends:
		ids := make([]ent.Value, 0, len(m.removedfriends))
		for id := range m.removedfriends {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *UserMutation) ClearedEdges() []string {
	edges := make([]string, 0, 3)
	if m.clearedcar {
		edges = append(edges, user.EdgeCar)
	}
	if m.clearedpets {
		edges = append(edges, user.EdgePets)
	}
	if m.clearedfriends {
		edges = append(edges, user.EdgeFriends)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *UserMutation) EdgeCleared(name string) bool {
	switch name {
	case user.EdgeCar:
		return m.clearedcar
	case user.EdgePets:
		return m.clearedpets
	case user.EdgeFriends:
		return m.clearedfriends
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *UserMutation) ClearEdge(name string) error {
	switch name {
	case user.EdgePets:
		m.ClearPets()
		return nil
	}
	return fmt.Errorf("unknown User unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *UserMutation) ResetEdge(name string) error {
	switch name {
	case user.EdgeCar:
		m.ResetCar()
		return nil
	case user.EdgePets:
		m.ResetPets()
		return nil
	case user.EdgeFriends:
		m.ResetFriends()
		return nil
	}
	return fmt.Errorf("unknown User edge %s", name)
}
