// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by internal/gen.go, DO NOT EDIT.

package entql

import (
	"database/sql/driver"
	"time"
)

//go:generate go run internal/gen.go

// Fielder is the interface for creating a predicate (entql.P)
// by a field name from the different builder types below.
type Fielder interface {
	Field(string) P
}

// BoolP is the interface for predicates of type bool (`type P[bool]`).
type BoolP interface {
	Fielder
	bool()
}

// boolP implements the BoolP interface.
type boolP struct {
	P
	done func(string)
}

func (p *boolP) Field(name string) P {
	p.done(name)
	return p.P
}

func (*boolP) bool() {}

// BoolEQ applies the EQ operation on the given value.
func BoolEQ(v bool) BoolP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &boolP{P: EQ(field, value), done: done}
}

// BoolNEQ applies the NEQ operation on the given value.
func BoolNEQ(v bool) BoolP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &boolP{P: NEQ(field, value), done: done}
}

// BoolOr returns a composed predicate that represents the logical OR predicate.
func BoolOr(x, y BoolP, z ...BoolP) BoolP {
	expr := &boolP{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = Or(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// BoolAnd returns a composed predicate that represents the logical AND predicate.
func BoolAnd(x, y BoolP, z ...BoolP) BoolP {
	expr := &boolP{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = And(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// BoolNot returns a predicate that represents the logical negation of the given predicate.
func BoolNot(x BoolP) BoolP {
	expr := &boolP{}
	expr.done = func(name string) {
		expr.P = Not(x.Field(name))
	}
	return expr
}

// BytesP is the interface for predicates of type []byte (`type P[[]byte]`).
type BytesP interface {
	Fielder
	bytes()
}

// bytesP implements the BytesP interface.
type bytesP struct {
	P
	done func(string)
}

func (p *bytesP) Field(name string) P {
	p.done(name)
	return p.P
}

func (*bytesP) bytes() {}

// BytesEQ applies the EQ operation on the given value.
func BytesEQ(v []byte) BytesP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &bytesP{P: EQ(field, value), done: done}
}

// BytesNEQ applies the NEQ operation on the given value.
func BytesNEQ(v []byte) BytesP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &bytesP{P: NEQ(field, value), done: done}
}

// BytesOr returns a composed predicate that represents the logical OR predicate.
func BytesOr(x, y BytesP, z ...BytesP) BytesP {
	expr := &bytesP{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = Or(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// BytesAnd returns a composed predicate that represents the logical AND predicate.
func BytesAnd(x, y BytesP, z ...BytesP) BytesP {
	expr := &bytesP{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = And(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// BytesNot returns a predicate that represents the logical negation of the given predicate.
func BytesNot(x BytesP) BytesP {
	expr := &bytesP{}
	expr.done = func(name string) {
		expr.P = Not(x.Field(name))
	}
	return expr
}

// TimeP is the interface for predicates of type time.Time (`type P[time.Time]`).
type TimeP interface {
	Fielder
	time()
}

// timeP implements the TimeP interface.
type timeP struct {
	P
	done func(string)
}

func (p *timeP) Field(name string) P {
	p.done(name)
	return p.P
}

func (*timeP) time() {}

// TimeEQ applies the EQ operation on the given value.
func TimeEQ(v time.Time) TimeP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &timeP{P: EQ(field, value), done: done}
}

// TimeNEQ applies the NEQ operation on the given value.
func TimeNEQ(v time.Time) TimeP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &timeP{P: NEQ(field, value), done: done}
}

// TimeLT applies the LT operation on the given value.
func TimeLT(v time.Time) TimeP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &timeP{P: LT(field, value), done: done}
}

// TimeLTE applies the LTE operation on the given value.
func TimeLTE(v time.Time) TimeP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &timeP{P: LTE(field, value), done: done}
}

// TimeGT applies the GT operation on the given value.
func TimeGT(v time.Time) TimeP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &timeP{P: GT(field, value), done: done}
}

// TimeGTE applies the GTE operation on the given value.
func TimeGTE(v time.Time) TimeP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &timeP{P: GTE(field, value), done: done}
}

// TimeOr returns a composed predicate that represents the logical OR predicate.
func TimeOr(x, y TimeP, z ...TimeP) TimeP {
	expr := &timeP{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = Or(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// TimeAnd returns a composed predicate that represents the logical AND predicate.
func TimeAnd(x, y TimeP, z ...TimeP) TimeP {
	expr := &timeP{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = And(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// TimeNot returns a predicate that represents the logical negation of the given predicate.
func TimeNot(x TimeP) TimeP {
	expr := &timeP{}
	expr.done = func(name string) {
		expr.P = Not(x.Field(name))
	}
	return expr
}

// UintP is the interface for predicates of type uint (`type P[uint]`).
type UintP interface {
	Fielder
	uint()
}

// uintP implements the UintP interface.
type uintP struct {
	P
	done func(string)
}

func (p *uintP) Field(name string) P {
	p.done(name)
	return p.P
}

func (*uintP) uint() {}

// UintEQ applies the EQ operation on the given value.
func UintEQ(v uint) UintP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uintP{P: EQ(field, value), done: done}
}

// UintNEQ applies the NEQ operation on the given value.
func UintNEQ(v uint) UintP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uintP{P: NEQ(field, value), done: done}
}

// UintLT applies the LT operation on the given value.
func UintLT(v uint) UintP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uintP{P: LT(field, value), done: done}
}

// UintLTE applies the LTE operation on the given value.
func UintLTE(v uint) UintP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uintP{P: LTE(field, value), done: done}
}

// UintGT applies the GT operation on the given value.
func UintGT(v uint) UintP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uintP{P: GT(field, value), done: done}
}

// UintGTE applies the GTE operation on the given value.
func UintGTE(v uint) UintP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uintP{P: GTE(field, value), done: done}
}

// UintOr returns a composed predicate that represents the logical OR predicate.
func UintOr(x, y UintP, z ...UintP) UintP {
	expr := &uintP{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = Or(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// UintAnd returns a composed predicate that represents the logical AND predicate.
func UintAnd(x, y UintP, z ...UintP) UintP {
	expr := &uintP{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = And(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// UintNot returns a predicate that represents the logical negation of the given predicate.
func UintNot(x UintP) UintP {
	expr := &uintP{}
	expr.done = func(name string) {
		expr.P = Not(x.Field(name))
	}
	return expr
}

// Uint8P is the interface for predicates of type uint8 (`type P[uint8]`).
type Uint8P interface {
	Fielder
	uint8()
}

// uint8P implements the Uint8P interface.
type uint8P struct {
	P
	done func(string)
}

func (p *uint8P) Field(name string) P {
	p.done(name)
	return p.P
}

func (*uint8P) uint8() {}

// Uint8EQ applies the EQ operation on the given value.
func Uint8EQ(v uint8) Uint8P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint8P{P: EQ(field, value), done: done}
}

// Uint8NEQ applies the NEQ operation on the given value.
func Uint8NEQ(v uint8) Uint8P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint8P{P: NEQ(field, value), done: done}
}

// Uint8LT applies the LT operation on the given value.
func Uint8LT(v uint8) Uint8P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint8P{P: LT(field, value), done: done}
}

// Uint8LTE applies the LTE operation on the given value.
func Uint8LTE(v uint8) Uint8P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint8P{P: LTE(field, value), done: done}
}

// Uint8GT applies the GT operation on the given value.
func Uint8GT(v uint8) Uint8P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint8P{P: GT(field, value), done: done}
}

// Uint8GTE applies the GTE operation on the given value.
func Uint8GTE(v uint8) Uint8P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint8P{P: GTE(field, value), done: done}
}

// Uint8Or returns a composed predicate that represents the logical OR predicate.
func Uint8Or(x, y Uint8P, z ...Uint8P) Uint8P {
	expr := &uint8P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = Or(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Uint8And returns a composed predicate that represents the logical AND predicate.
func Uint8And(x, y Uint8P, z ...Uint8P) Uint8P {
	expr := &uint8P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = And(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Uint8Not returns a predicate that represents the logical negation of the given predicate.
func Uint8Not(x Uint8P) Uint8P {
	expr := &uint8P{}
	expr.done = func(name string) {
		expr.P = Not(x.Field(name))
	}
	return expr
}

// Uint16P is the interface for predicates of type uint16 (`type P[uint16]`).
type Uint16P interface {
	Fielder
	uint16()
}

// uint16P implements the Uint16P interface.
type uint16P struct {
	P
	done func(string)
}

func (p *uint16P) Field(name string) P {
	p.done(name)
	return p.P
}

func (*uint16P) uint16() {}

// Uint16EQ applies the EQ operation on the given value.
func Uint16EQ(v uint16) Uint16P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint16P{P: EQ(field, value), done: done}
}

// Uint16NEQ applies the NEQ operation on the given value.
func Uint16NEQ(v uint16) Uint16P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint16P{P: NEQ(field, value), done: done}
}

// Uint16LT applies the LT operation on the given value.
func Uint16LT(v uint16) Uint16P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint16P{P: LT(field, value), done: done}
}

// Uint16LTE applies the LTE operation on the given value.
func Uint16LTE(v uint16) Uint16P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint16P{P: LTE(field, value), done: done}
}

// Uint16GT applies the GT operation on the given value.
func Uint16GT(v uint16) Uint16P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint16P{P: GT(field, value), done: done}
}

// Uint16GTE applies the GTE operation on the given value.
func Uint16GTE(v uint16) Uint16P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint16P{P: GTE(field, value), done: done}
}

// Uint16Or returns a composed predicate that represents the logical OR predicate.
func Uint16Or(x, y Uint16P, z ...Uint16P) Uint16P {
	expr := &uint16P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = Or(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Uint16And returns a composed predicate that represents the logical AND predicate.
func Uint16And(x, y Uint16P, z ...Uint16P) Uint16P {
	expr := &uint16P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = And(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Uint16Not returns a predicate that represents the logical negation of the given predicate.
func Uint16Not(x Uint16P) Uint16P {
	expr := &uint16P{}
	expr.done = func(name string) {
		expr.P = Not(x.Field(name))
	}
	return expr
}

// Uint32P is the interface for predicates of type uint32 (`type P[uint32]`).
type Uint32P interface {
	Fielder
	uint32()
}

// uint32P implements the Uint32P interface.
type uint32P struct {
	P
	done func(string)
}

func (p *uint32P) Field(name string) P {
	p.done(name)
	return p.P
}

func (*uint32P) uint32() {}

// Uint32EQ applies the EQ operation on the given value.
func Uint32EQ(v uint32) Uint32P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint32P{P: EQ(field, value), done: done}
}

// Uint32NEQ applies the NEQ operation on the given value.
func Uint32NEQ(v uint32) Uint32P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint32P{P: NEQ(field, value), done: done}
}

// Uint32LT applies the LT operation on the given value.
func Uint32LT(v uint32) Uint32P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint32P{P: LT(field, value), done: done}
}

// Uint32LTE applies the LTE operation on the given value.
func Uint32LTE(v uint32) Uint32P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint32P{P: LTE(field, value), done: done}
}

// Uint32GT applies the GT operation on the given value.
func Uint32GT(v uint32) Uint32P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint32P{P: GT(field, value), done: done}
}

// Uint32GTE applies the GTE operation on the given value.
func Uint32GTE(v uint32) Uint32P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint32P{P: GTE(field, value), done: done}
}

// Uint32Or returns a composed predicate that represents the logical OR predicate.
func Uint32Or(x, y Uint32P, z ...Uint32P) Uint32P {
	expr := &uint32P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = Or(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Uint32And returns a composed predicate that represents the logical AND predicate.
func Uint32And(x, y Uint32P, z ...Uint32P) Uint32P {
	expr := &uint32P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = And(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Uint32Not returns a predicate that represents the logical negation of the given predicate.
func Uint32Not(x Uint32P) Uint32P {
	expr := &uint32P{}
	expr.done = func(name string) {
		expr.P = Not(x.Field(name))
	}
	return expr
}

// Uint64P is the interface for predicates of type uint64 (`type P[uint64]`).
type Uint64P interface {
	Fielder
	uint64()
}

// uint64P implements the Uint64P interface.
type uint64P struct {
	P
	done func(string)
}

func (p *uint64P) Field(name string) P {
	p.done(name)
	return p.P
}

func (*uint64P) uint64() {}

// Uint64EQ applies the EQ operation on the given value.
func Uint64EQ(v uint64) Uint64P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint64P{P: EQ(field, value), done: done}
}

// Uint64NEQ applies the NEQ operation on the given value.
func Uint64NEQ(v uint64) Uint64P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint64P{P: NEQ(field, value), done: done}
}

// Uint64LT applies the LT operation on the given value.
func Uint64LT(v uint64) Uint64P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint64P{P: LT(field, value), done: done}
}

// Uint64LTE applies the LTE operation on the given value.
func Uint64LTE(v uint64) Uint64P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint64P{P: LTE(field, value), done: done}
}

// Uint64GT applies the GT operation on the given value.
func Uint64GT(v uint64) Uint64P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint64P{P: GT(field, value), done: done}
}

// Uint64GTE applies the GTE operation on the given value.
func Uint64GTE(v uint64) Uint64P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &uint64P{P: GTE(field, value), done: done}
}

// Uint64Or returns a composed predicate that represents the logical OR predicate.
func Uint64Or(x, y Uint64P, z ...Uint64P) Uint64P {
	expr := &uint64P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = Or(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Uint64And returns a composed predicate that represents the logical AND predicate.
func Uint64And(x, y Uint64P, z ...Uint64P) Uint64P {
	expr := &uint64P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = And(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Uint64Not returns a predicate that represents the logical negation of the given predicate.
func Uint64Not(x Uint64P) Uint64P {
	expr := &uint64P{}
	expr.done = func(name string) {
		expr.P = Not(x.Field(name))
	}
	return expr
}

// IntP is the interface for predicates of type int (`type P[int]`).
type IntP interface {
	Fielder
	int()
}

// intP implements the IntP interface.
type intP struct {
	P
	done func(string)
}

func (p *intP) Field(name string) P {
	p.done(name)
	return p.P
}

func (*intP) int() {}

// IntEQ applies the EQ operation on the given value.
func IntEQ(v int) IntP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &intP{P: EQ(field, value), done: done}
}

// IntNEQ applies the NEQ operation on the given value.
func IntNEQ(v int) IntP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &intP{P: NEQ(field, value), done: done}
}

// IntLT applies the LT operation on the given value.
func IntLT(v int) IntP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &intP{P: LT(field, value), done: done}
}

// IntLTE applies the LTE operation on the given value.
func IntLTE(v int) IntP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &intP{P: LTE(field, value), done: done}
}

// IntGT applies the GT operation on the given value.
func IntGT(v int) IntP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &intP{P: GT(field, value), done: done}
}

// IntGTE applies the GTE operation on the given value.
func IntGTE(v int) IntP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &intP{P: GTE(field, value), done: done}
}

// IntOr returns a composed predicate that represents the logical OR predicate.
func IntOr(x, y IntP, z ...IntP) IntP {
	expr := &intP{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = Or(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// IntAnd returns a composed predicate that represents the logical AND predicate.
func IntAnd(x, y IntP, z ...IntP) IntP {
	expr := &intP{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = And(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// IntNot returns a predicate that represents the logical negation of the given predicate.
func IntNot(x IntP) IntP {
	expr := &intP{}
	expr.done = func(name string) {
		expr.P = Not(x.Field(name))
	}
	return expr
}

// Int8P is the interface for predicates of type int8 (`type P[int8]`).
type Int8P interface {
	Fielder
	int8()
}

// int8P implements the Int8P interface.
type int8P struct {
	P
	done func(string)
}

func (p *int8P) Field(name string) P {
	p.done(name)
	return p.P
}

func (*int8P) int8() {}

// Int8EQ applies the EQ operation on the given value.
func Int8EQ(v int8) Int8P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int8P{P: EQ(field, value), done: done}
}

// Int8NEQ applies the NEQ operation on the given value.
func Int8NEQ(v int8) Int8P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int8P{P: NEQ(field, value), done: done}
}

// Int8LT applies the LT operation on the given value.
func Int8LT(v int8) Int8P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int8P{P: LT(field, value), done: done}
}

// Int8LTE applies the LTE operation on the given value.
func Int8LTE(v int8) Int8P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int8P{P: LTE(field, value), done: done}
}

// Int8GT applies the GT operation on the given value.
func Int8GT(v int8) Int8P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int8P{P: GT(field, value), done: done}
}

// Int8GTE applies the GTE operation on the given value.
func Int8GTE(v int8) Int8P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int8P{P: GTE(field, value), done: done}
}

// Int8Or returns a composed predicate that represents the logical OR predicate.
func Int8Or(x, y Int8P, z ...Int8P) Int8P {
	expr := &int8P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = Or(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Int8And returns a composed predicate that represents the logical AND predicate.
func Int8And(x, y Int8P, z ...Int8P) Int8P {
	expr := &int8P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = And(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Int8Not returns a predicate that represents the logical negation of the given predicate.
func Int8Not(x Int8P) Int8P {
	expr := &int8P{}
	expr.done = func(name string) {
		expr.P = Not(x.Field(name))
	}
	return expr
}

// Int16P is the interface for predicates of type int16 (`type P[int16]`).
type Int16P interface {
	Fielder
	int16()
}

// int16P implements the Int16P interface.
type int16P struct {
	P
	done func(string)
}

func (p *int16P) Field(name string) P {
	p.done(name)
	return p.P
}

func (*int16P) int16() {}

// Int16EQ applies the EQ operation on the given value.
func Int16EQ(v int16) Int16P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int16P{P: EQ(field, value), done: done}
}

// Int16NEQ applies the NEQ operation on the given value.
func Int16NEQ(v int16) Int16P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int16P{P: NEQ(field, value), done: done}
}

// Int16LT applies the LT operation on the given value.
func Int16LT(v int16) Int16P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int16P{P: LT(field, value), done: done}
}

// Int16LTE applies the LTE operation on the given value.
func Int16LTE(v int16) Int16P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int16P{P: LTE(field, value), done: done}
}

// Int16GT applies the GT operation on the given value.
func Int16GT(v int16) Int16P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int16P{P: GT(field, value), done: done}
}

// Int16GTE applies the GTE operation on the given value.
func Int16GTE(v int16) Int16P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int16P{P: GTE(field, value), done: done}
}

// Int16Or returns a composed predicate that represents the logical OR predicate.
func Int16Or(x, y Int16P, z ...Int16P) Int16P {
	expr := &int16P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = Or(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Int16And returns a composed predicate that represents the logical AND predicate.
func Int16And(x, y Int16P, z ...Int16P) Int16P {
	expr := &int16P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = And(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Int16Not returns a predicate that represents the logical negation of the given predicate.
func Int16Not(x Int16P) Int16P {
	expr := &int16P{}
	expr.done = func(name string) {
		expr.P = Not(x.Field(name))
	}
	return expr
}

// Int32P is the interface for predicates of type int32 (`type P[int32]`).
type Int32P interface {
	Fielder
	int32()
}

// int32P implements the Int32P interface.
type int32P struct {
	P
	done func(string)
}

func (p *int32P) Field(name string) P {
	p.done(name)
	return p.P
}

func (*int32P) int32() {}

// Int32EQ applies the EQ operation on the given value.
func Int32EQ(v int32) Int32P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int32P{P: EQ(field, value), done: done}
}

// Int32NEQ applies the NEQ operation on the given value.
func Int32NEQ(v int32) Int32P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int32P{P: NEQ(field, value), done: done}
}

// Int32LT applies the LT operation on the given value.
func Int32LT(v int32) Int32P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int32P{P: LT(field, value), done: done}
}

// Int32LTE applies the LTE operation on the given value.
func Int32LTE(v int32) Int32P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int32P{P: LTE(field, value), done: done}
}

// Int32GT applies the GT operation on the given value.
func Int32GT(v int32) Int32P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int32P{P: GT(field, value), done: done}
}

// Int32GTE applies the GTE operation on the given value.
func Int32GTE(v int32) Int32P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int32P{P: GTE(field, value), done: done}
}

// Int32Or returns a composed predicate that represents the logical OR predicate.
func Int32Or(x, y Int32P, z ...Int32P) Int32P {
	expr := &int32P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = Or(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Int32And returns a composed predicate that represents the logical AND predicate.
func Int32And(x, y Int32P, z ...Int32P) Int32P {
	expr := &int32P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = And(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Int32Not returns a predicate that represents the logical negation of the given predicate.
func Int32Not(x Int32P) Int32P {
	expr := &int32P{}
	expr.done = func(name string) {
		expr.P = Not(x.Field(name))
	}
	return expr
}

// Int64P is the interface for predicates of type int64 (`type P[int64]`).
type Int64P interface {
	Fielder
	int64()
}

// int64P implements the Int64P interface.
type int64P struct {
	P
	done func(string)
}

func (p *int64P) Field(name string) P {
	p.done(name)
	return p.P
}

func (*int64P) int64() {}

// Int64EQ applies the EQ operation on the given value.
func Int64EQ(v int64) Int64P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int64P{P: EQ(field, value), done: done}
}

// Int64NEQ applies the NEQ operation on the given value.
func Int64NEQ(v int64) Int64P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int64P{P: NEQ(field, value), done: done}
}

// Int64LT applies the LT operation on the given value.
func Int64LT(v int64) Int64P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int64P{P: LT(field, value), done: done}
}

// Int64LTE applies the LTE operation on the given value.
func Int64LTE(v int64) Int64P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int64P{P: LTE(field, value), done: done}
}

// Int64GT applies the GT operation on the given value.
func Int64GT(v int64) Int64P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int64P{P: GT(field, value), done: done}
}

// Int64GTE applies the GTE operation on the given value.
func Int64GTE(v int64) Int64P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &int64P{P: GTE(field, value), done: done}
}

// Int64Or returns a composed predicate that represents the logical OR predicate.
func Int64Or(x, y Int64P, z ...Int64P) Int64P {
	expr := &int64P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = Or(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Int64And returns a composed predicate that represents the logical AND predicate.
func Int64And(x, y Int64P, z ...Int64P) Int64P {
	expr := &int64P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = And(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Int64Not returns a predicate that represents the logical negation of the given predicate.
func Int64Not(x Int64P) Int64P {
	expr := &int64P{}
	expr.done = func(name string) {
		expr.P = Not(x.Field(name))
	}
	return expr
}

// Float32P is the interface for predicates of type float32 (`type P[float32]`).
type Float32P interface {
	Fielder
	float32()
}

// float32P implements the Float32P interface.
type float32P struct {
	P
	done func(string)
}

func (p *float32P) Field(name string) P {
	p.done(name)
	return p.P
}

func (*float32P) float32() {}

// Float32EQ applies the EQ operation on the given value.
func Float32EQ(v float32) Float32P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &float32P{P: EQ(field, value), done: done}
}

// Float32NEQ applies the NEQ operation on the given value.
func Float32NEQ(v float32) Float32P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &float32P{P: NEQ(field, value), done: done}
}

// Float32LT applies the LT operation on the given value.
func Float32LT(v float32) Float32P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &float32P{P: LT(field, value), done: done}
}

// Float32LTE applies the LTE operation on the given value.
func Float32LTE(v float32) Float32P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &float32P{P: LTE(field, value), done: done}
}

// Float32GT applies the GT operation on the given value.
func Float32GT(v float32) Float32P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &float32P{P: GT(field, value), done: done}
}

// Float32GTE applies the GTE operation on the given value.
func Float32GTE(v float32) Float32P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &float32P{P: GTE(field, value), done: done}
}

// Float32Or returns a composed predicate that represents the logical OR predicate.
func Float32Or(x, y Float32P, z ...Float32P) Float32P {
	expr := &float32P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = Or(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Float32And returns a composed predicate that represents the logical AND predicate.
func Float32And(x, y Float32P, z ...Float32P) Float32P {
	expr := &float32P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = And(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Float32Not returns a predicate that represents the logical negation of the given predicate.
func Float32Not(x Float32P) Float32P {
	expr := &float32P{}
	expr.done = func(name string) {
		expr.P = Not(x.Field(name))
	}
	return expr
}

// Float64P is the interface for predicates of type float64 (`type P[float64]`).
type Float64P interface {
	Fielder
	float64()
}

// float64P implements the Float64P interface.
type float64P struct {
	P
	done func(string)
}

func (p *float64P) Field(name string) P {
	p.done(name)
	return p.P
}

func (*float64P) float64() {}

// Float64EQ applies the EQ operation on the given value.
func Float64EQ(v float64) Float64P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &float64P{P: EQ(field, value), done: done}
}

// Float64NEQ applies the NEQ operation on the given value.
func Float64NEQ(v float64) Float64P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &float64P{P: NEQ(field, value), done: done}
}

// Float64LT applies the LT operation on the given value.
func Float64LT(v float64) Float64P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &float64P{P: LT(field, value), done: done}
}

// Float64LTE applies the LTE operation on the given value.
func Float64LTE(v float64) Float64P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &float64P{P: LTE(field, value), done: done}
}

// Float64GT applies the GT operation on the given value.
func Float64GT(v float64) Float64P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &float64P{P: GT(field, value), done: done}
}

// Float64GTE applies the GTE operation on the given value.
func Float64GTE(v float64) Float64P {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &float64P{P: GTE(field, value), done: done}
}

// Float64Or returns a composed predicate that represents the logical OR predicate.
func Float64Or(x, y Float64P, z ...Float64P) Float64P {
	expr := &float64P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = Or(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Float64And returns a composed predicate that represents the logical AND predicate.
func Float64And(x, y Float64P, z ...Float64P) Float64P {
	expr := &float64P{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = And(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// Float64Not returns a predicate that represents the logical negation of the given predicate.
func Float64Not(x Float64P) Float64P {
	expr := &float64P{}
	expr.done = func(name string) {
		expr.P = Not(x.Field(name))
	}
	return expr
}

// StringP is the interface for predicates of type string (`type P[string]`).
type StringP interface {
	Fielder
	string()
}

// stringP implements the StringP interface.
type stringP struct {
	P
	done func(string)
}

func (p *stringP) Field(name string) P {
	p.done(name)
	return p.P
}

func (*stringP) string() {}

// StringEQ applies the EQ operation on the given value.
func StringEQ(v string) StringP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &stringP{P: EQ(field, value), done: done}
}

// StringNEQ applies the NEQ operation on the given value.
func StringNEQ(v string) StringP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &stringP{P: NEQ(field, value), done: done}
}

// StringLT applies the LT operation on the given value.
func StringLT(v string) StringP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &stringP{P: LT(field, value), done: done}
}

// StringLTE applies the LTE operation on the given value.
func StringLTE(v string) StringP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &stringP{P: LTE(field, value), done: done}
}

// StringGT applies the GT operation on the given value.
func StringGT(v string) StringP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &stringP{P: GT(field, value), done: done}
}

// StringGTE applies the GTE operation on the given value.
func StringGTE(v string) StringP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &stringP{P: GTE(field, value), done: done}
}

// StringOr returns a composed predicate that represents the logical OR predicate.
func StringOr(x, y StringP, z ...StringP) StringP {
	expr := &stringP{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = Or(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// StringAnd returns a composed predicate that represents the logical AND predicate.
func StringAnd(x, y StringP, z ...StringP) StringP {
	expr := &stringP{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = And(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// StringNot returns a predicate that represents the logical negation of the given predicate.
func StringNot(x StringP) StringP {
	expr := &stringP{}
	expr.done = func(name string) {
		expr.P = Not(x.Field(name))
	}
	return expr
}

// ValueP is the interface for predicates of type [16]byte (`type P[[16]byte]`).
type ValueP interface {
	Fielder
	value()
}

// valueP implements the ValueP interface.
type valueP struct {
	P
	done func(string)
}

func (p *valueP) Field(name string) P {
	p.done(name)
	return p.P
}

func (*valueP) value() {}

// ValueEQ applies the EQ operation on the given value.
func ValueEQ(v driver.Valuer) ValueP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &valueP{P: EQ(field, value), done: done}
}

// ValueNEQ applies the NEQ operation on the given value.
func ValueNEQ(v driver.Valuer) ValueP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &valueP{P: NEQ(field, value), done: done}
}

// ValueOr returns a composed predicate that represents the logical OR predicate.
func ValueOr(x, y ValueP, z ...ValueP) ValueP {
	expr := &valueP{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = Or(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// ValueAnd returns a composed predicate that represents the logical AND predicate.
func ValueAnd(x, y ValueP, z ...ValueP) ValueP {
	expr := &valueP{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = And(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// ValueNot returns a predicate that represents the logical negation of the given predicate.
func ValueNot(x ValueP) ValueP {
	expr := &valueP{}
	expr.done = func(name string) {
		expr.P = Not(x.Field(name))
	}
	return expr
}

// OtherP is the interface for predicates of type other (`type P[other]`).
type OtherP interface {
	Fielder
	other()
}

// otherP implements the OtherP interface.
type otherP struct {
	P
	done func(string)
}

func (p *otherP) Field(name string) P {
	p.done(name)
	return p.P
}

func (*otherP) other() {}

// OtherEQ applies the EQ operation on the given value.
func OtherEQ(v driver.Valuer) OtherP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &otherP{P: EQ(field, value), done: done}
}

// OtherNEQ applies the NEQ operation on the given value.
func OtherNEQ(v driver.Valuer) OtherP {
	field := &Field{}
	value := &Value{V: v}
	done := func(name string) { field.Name = name }
	return &otherP{P: NEQ(field, value), done: done}
}

// OtherOr returns a composed predicate that represents the logical OR predicate.
func OtherOr(x, y OtherP, z ...OtherP) OtherP {
	expr := &otherP{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = Or(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// OtherAnd returns a composed predicate that represents the logical AND predicate.
func OtherAnd(x, y OtherP, z ...OtherP) OtherP {
	expr := &otherP{}
	expr.done = func(name string) {
		zs := make([]P, len(z))
		for i := range z {
			zs[i] = z[i].Field(name)
		}
		expr.P = And(x.Field(name), y.Field(name), zs...)
	}
	return expr
}

// OtherNot returns a predicate that represents the logical negation of the given predicate.
func OtherNot(x OtherP) OtherP {
	expr := &otherP{}
	expr.done = func(name string) {
		expr.P = Not(x.Field(name))
	}
	return expr
}
