---
title:  "How to validate a Beam Release"
date:   2021-06-08 00:00:01 -0800
categories:
  - blog
authors:
  - pabloem

---
<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

Performing new releases is a core responsibility of any software project.
It is even more important in the culture of Apache projects. Releases are
the main flow of new code / features among the community of a project.

Beam is no exception: We aspire to keep a release cadence of about 6 weeks,
and try to work with the community to release useful new features, and to
keep Beam useful.

### Configure a Java build to validate a Beam release candidate

First of all, it would be useful to have a single property in your `pom.xml`
where you keep the global Beam version that you're using. Something like this
in your `pom.xml`:

{{< highlight java >}}
&lt;properties&gt;
    ...
    &lt;beam.version&gt;2.26.0&lt;/beam.version&gt;
    ...
&lt;/properties&gt;
&lt;dependencies&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;org.apache.beam&lt;/groupId&gt;
        &lt;artifactId&gt;beam-sdks-java-core&lt;/artifactId&gt;
        &lt;version&gt;${beam.version}&lt;/version&gt;
    &lt;/dependency&gt;
    ...
&lt;/dependencies&gt;
{{< /highlight >}}

Second, you can add a new profile to your `pom.xml` file. In this new profile,
add a new repository with the staging repository for the new Beam release. For
Beam 2.27.0, this was `https://repository.apache.org/content/repositories/orgapachebeam-1149/`.

{{< highlight java >}}
        &lt;profile&gt;
            &lt;id&gt;validaterelease&lt;/id&gt;
            &lt;repositories&gt;
                &lt;repository&gt;
                    &lt;id&gt;apache.beam.newrelease&lt;/id&gt;
                    &lt;url&gt;${beam.release.repo}&lt;/url&gt;
                &lt;/repository&gt;
            &lt;/repositories&gt;
        &lt;/profile&gt;
{{< /highlight >}}

Once you have a `beam.version` property in your `pom.xml`, and a new profile
with the new release, you can run your `mvn` command activating the new profile,
and the new Beam version:

```
mvn test -Pvalidaterelease \
         -Dbeam.version=2.27.0 \
         -Dbeam.release.repo=https://repository.apache.org/content/repositories/orgapachebeam-XXXX/
```

This should build your project against the new release, and run basic tests.
It will allow you to run basic validations against the new Beam release.
If you find any issues, then you can share them *before* the release is
finalized, so your concerns can be addressed by the community.


### Configuring a Python build to validate a Beam release candidate

For Python SDK releases, you can install SDK from Pypi, by enabling the
installation of pre-release artifacts.

First, make sure that your `requirements.txt` or `setup.py` files allow
for Beam versions above the current one. Something like this should install
the latest available version:

```
apache-beam<=3.0.0
```

With that, you can ask `pip` to install pre-release versions of Beam in your
environment:

```
pip install --pre apache-beam
```

With that, the Beam version in your environment will be the latest release
candidate, and you can go ahead and run your tests to verify that everything
works well.
